import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#name DataAzurermAppServiceEnvironmentV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#resource_group_name DataAzurermAppServiceEnvironmentV3#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#timeouts DataAzurermAppServiceEnvironmentV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAppServiceEnvironmentV3Timeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceEnvironmentV3ClusterSetting extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get ipAddresses(): string[];
    /**
     * @stability stable
     */
    get ports(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermAppServiceEnvironmentV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#read DataAzurermAppServiceEnvironmentV3#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAppServiceEnvironmentV3TimeoutsToTerraform(struct?: DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference | DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAppServiceEnvironmentV3Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAppServiceEnvironmentV3Timeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3 azurerm_app_service_environment_v3}.
 *
 * @stability stable
 */
export declare class DataAzurermAppServiceEnvironmentV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3 azurerm_app_service_environment_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceEnvironmentV3Config);
    /**
     * @stability stable
     */
    get allowNewPrivateEndpointConnections(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    clusterSetting(index: string): DataAzurermAppServiceEnvironmentV3ClusterSetting;
    /**
     * @stability stable
     */
    get dedicatedHostCount(): number;
    /**
     * @stability stable
     */
    get dnsSuffix(): string;
    /**
     * @stability stable
     */
    get externalInboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    inboundNetworkDependencies(index: string): DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies;
    /**
     * @stability stable
     */
    get internalInboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get internalLoadBalancingMode(): string;
    /**
     * @stability stable
     */
    get ipSslAddressCount(): number;
    /**
     * @stability stable
     */
    get linuxOutboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pricingTier(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get windowsOutboundIpAddresses(): string[];
    /**
     * @stability stable
     */
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAppServiceEnvironmentV3Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAppServiceEnvironmentV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
