import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetDataLakeGen1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1#data_share_id DataAzurermDataShareDatasetDataLakeGen1#data_share_id}.
     *
     * @stability stable
     */
    readonly dataShareId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1#name DataAzurermDataShareDatasetDataLakeGen1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1#timeouts DataAzurermDataShareDatasetDataLakeGen1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareDatasetDataLakeGen1Timeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetDataLakeGen1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1#read DataAzurermDataShareDatasetDataLakeGen1#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetDataLakeGen1TimeoutsToTerraform(struct?: DataAzurermDataShareDatasetDataLakeGen1TimeoutsOutputReference | DataAzurermDataShareDatasetDataLakeGen1Timeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetDataLakeGen1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareDatasetDataLakeGen1Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareDatasetDataLakeGen1Timeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetDataLakeGen1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen1 azurerm_data_share_dataset_data_lake_gen1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetDataLakeGen1Config);
    /**
     * @stability stable
     */
    get dataLakeStoreId(): string;
    private _dataShareId?;
    /**
     * @stability stable
     */
    get dataShareId(): string;
    /**
     * @stability stable
     */
    set dataShareId(value: string);
    /**
     * @stability stable
     */
    get dataShareIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get fileName(): string;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareDatasetDataLakeGen1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareDatasetDataLakeGen1Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareDatasetDataLakeGen1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
