import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDatabaseMigrationServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service#name DataAzurermDatabaseMigrationService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service#resource_group_name DataAzurermDatabaseMigrationService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service#timeouts DataAzurermDatabaseMigrationService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDatabaseMigrationServiceTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDatabaseMigrationServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service#read DataAzurermDatabaseMigrationService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDatabaseMigrationServiceTimeoutsToTerraform(struct?: DataAzurermDatabaseMigrationServiceTimeoutsOutputReference | DataAzurermDatabaseMigrationServiceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDatabaseMigrationServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDatabaseMigrationServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDatabaseMigrationServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service azurerm_database_migration_service}.
 *
 * @stability stable
 */
export declare class DataAzurermDatabaseMigrationService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_service azurerm_database_migration_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDatabaseMigrationServiceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDatabaseMigrationServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDatabaseMigrationServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDatabaseMigrationServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
