import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMonitorDiagnosticCategoriesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#resource_id DataAzurermMonitorDiagnosticCategories#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#timeouts DataAzurermMonitorDiagnosticCategories#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMonitorDiagnosticCategoriesTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermMonitorDiagnosticCategoriesTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories#read DataAzurermMonitorDiagnosticCategories#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMonitorDiagnosticCategoriesTimeoutsToTerraform(struct?: DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference | DataAzurermMonitorDiagnosticCategoriesTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories azurerm_monitor_diagnostic_categories}.
 *
 * @stability stable
 */
export declare class DataAzurermMonitorDiagnosticCategories extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_diagnostic_categories azurerm_monitor_diagnostic_categories} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorDiagnosticCategoriesConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get logs(): string[];
    /**
     * @stability stable
     */
    get metrics(): string[];
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMonitorDiagnosticCategoriesTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMonitorDiagnosticCategoriesTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMonitorDiagnosticCategoriesTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
