import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#subscription_id DataAzurermSubscription#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#timeouts DataAzurermSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/subscription#read DataAzurermSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionTimeoutsToTerraform(struct?: DataAzurermSubscriptionTimeoutsOutputReference | DataAzurermSubscriptionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSubscriptionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/subscription azurerm_subscription}.
 *
 * @stability stable
 */
export declare class DataAzurermSubscription extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/subscription azurerm_subscription} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get locationPlacementId(): string;
    /**
     * @stability stable
     */
    get quotaId(): string;
    /**
     * @stability stable
     */
    get spendingLimit(): string;
    /**
     * @stability stable
     */
    get state(): string;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    resetSubscriptionId(): void;
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
