import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataShareDatasetBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#container_name DataShareDatasetBlobStorage#container_name}.
     *
     * @stability stable
     */
    readonly containerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#data_share_id DataShareDatasetBlobStorage#data_share_id}.
     *
     * @stability stable
     */
    readonly dataShareId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#file_path DataShareDatasetBlobStorage#file_path}.
     *
     * @stability stable
     */
    readonly filePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#folder_path DataShareDatasetBlobStorage#folder_path}.
     *
     * @stability stable
     */
    readonly folderPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#name DataShareDatasetBlobStorage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#storage_account DataShareDatasetBlobStorage#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount: DataShareDatasetBlobStorageStorageAccount;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#timeouts DataShareDatasetBlobStorage#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataShareDatasetBlobStorageTimeouts;
}
/**
 * @stability stable
 */
export interface DataShareDatasetBlobStorageStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#name DataShareDatasetBlobStorage#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#resource_group_name DataShareDatasetBlobStorage#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#subscription_id DataShareDatasetBlobStorage#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
}
export declare function dataShareDatasetBlobStorageStorageAccountToTerraform(struct?: DataShareDatasetBlobStorageStorageAccountOutputReference | DataShareDatasetBlobStorageStorageAccount): any;
/**
 * @stability stable
 */
export declare class DataShareDatasetBlobStorageStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataShareDatasetBlobStorageStorageAccount | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataShareDatasetBlobStorageStorageAccount | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataShareDatasetBlobStorageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#create DataShareDatasetBlobStorage#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#delete DataShareDatasetBlobStorage#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage#read DataShareDatasetBlobStorage#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataShareDatasetBlobStorageTimeoutsToTerraform(struct?: DataShareDatasetBlobStorageTimeoutsOutputReference | DataShareDatasetBlobStorageTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataShareDatasetBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataShareDatasetBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataShareDatasetBlobStorageTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage}.
 *
 * @stability stable
 */
export declare class DataShareDatasetBlobStorage extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataShareDatasetBlobStorageConfig);
    private _containerName?;
    /**
     * @stability stable
     */
    get containerName(): string;
    /**
     * @stability stable
     */
    set containerName(value: string);
    /**
     * @stability stable
     */
    get containerNameInput(): string | undefined;
    private _dataShareId?;
    /**
     * @stability stable
     */
    get dataShareId(): string;
    /**
     * @stability stable
     */
    set dataShareId(value: string);
    /**
     * @stability stable
     */
    get dataShareIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    private _filePath?;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    set filePath(value: string);
    /**
     * @stability stable
     */
    resetFilePath(): void;
    /**
     * @stability stable
     */
    get filePathInput(): string | undefined;
    private _folderPath?;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    set folderPath(value: string);
    /**
     * @stability stable
     */
    resetFolderPath(): void;
    /**
     * @stability stable
     */
    get folderPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccount;
    /**
     * @stability stable
     */
    get storageAccount(): DataShareDatasetBlobStorageStorageAccountOutputReference;
    /**
     * @stability stable
     */
    putStorageAccount(value: DataShareDatasetBlobStorageStorageAccount): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): DataShareDatasetBlobStorageStorageAccount | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataShareDatasetBlobStorageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataShareDatasetBlobStorageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataShareDatasetBlobStorageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
