import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataboxEdgeOrderConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#device_name DataboxEdgeOrder#device_name}.
     *
     * @stability stable
     */
    readonly deviceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#resource_group_name DataboxEdgeOrder#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * contact block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#contact DataboxEdgeOrder#contact}
     *
     * @stability stable
     */
    readonly contact: DataboxEdgeOrderContact;
    /**
     * shipment_address block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#shipment_address DataboxEdgeOrder#shipment_address}
     *
     * @stability stable
     */
    readonly shipmentAddress: DataboxEdgeOrderShipmentAddress;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#timeouts DataboxEdgeOrder#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataboxEdgeOrderTimeouts;
}
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderReturnTracking extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get carrierName(): string;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    get trackingId(): string;
    /**
     * @stability stable
     */
    get trackingUrl(): string;
}
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderShipmentHistory extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalDetails(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    get comments(): string;
    /**
     * @stability stable
     */
    get lastUpdate(): string;
}
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderShipmentTracking extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get carrierName(): string;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    get trackingId(): string;
    /**
     * @stability stable
     */
    get trackingUrl(): string;
}
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalDetails(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    get comments(): string;
    /**
     * @stability stable
     */
    get info(): string;
    /**
     * @stability stable
     */
    get lastUpdate(): string;
}
/**
 * @stability stable
 */
export interface DataboxEdgeOrderContact {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#company_name DataboxEdgeOrder#company_name}.
     *
     * @stability stable
     */
    readonly companyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#emails DataboxEdgeOrder#emails}.
     *
     * @stability stable
     */
    readonly emails: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#name DataboxEdgeOrder#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#phone_number DataboxEdgeOrder#phone_number}.
     *
     * @stability stable
     */
    readonly phoneNumber: string;
}
export declare function databoxEdgeOrderContactToTerraform(struct?: DataboxEdgeOrderContactOutputReference | DataboxEdgeOrderContact): any;
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderContactOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataboxEdgeOrderContact | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataboxEdgeOrderContact | undefined);
    private _companyName?;
    /**
     * @stability stable
     */
    get companyName(): string;
    /**
     * @stability stable
     */
    set companyName(value: string);
    /**
     * @stability stable
     */
    get companyNameInput(): string | undefined;
    private _emails?;
    /**
     * @stability stable
     */
    get emails(): string[];
    /**
     * @stability stable
     */
    set emails(value: string[]);
    /**
     * @stability stable
     */
    get emailsInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _phoneNumber?;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
    /**
     * @stability stable
     */
    set phoneNumber(value: string);
    /**
     * @stability stable
     */
    get phoneNumberInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataboxEdgeOrderShipmentAddress {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#address DataboxEdgeOrder#address}.
     *
     * @stability stable
     */
    readonly address: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#city DataboxEdgeOrder#city}.
     *
     * @stability stable
     */
    readonly city: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#country DataboxEdgeOrder#country}.
     *
     * @stability stable
     */
    readonly country: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#postal_code DataboxEdgeOrder#postal_code}.
     *
     * @stability stable
     */
    readonly postalCode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#state DataboxEdgeOrder#state}.
     *
     * @stability stable
     */
    readonly state: string;
}
export declare function databoxEdgeOrderShipmentAddressToTerraform(struct?: DataboxEdgeOrderShipmentAddressOutputReference | DataboxEdgeOrderShipmentAddress): any;
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderShipmentAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataboxEdgeOrderShipmentAddress | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataboxEdgeOrderShipmentAddress | undefined);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string[];
    /**
     * @stability stable
     */
    set address(value: string[]);
    /**
     * @stability stable
     */
    get addressInput(): string[] | undefined;
    private _city?;
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    set city(value: string);
    /**
     * @stability stable
     */
    get cityInput(): string | undefined;
    private _country?;
    /**
     * @stability stable
     */
    get country(): string;
    /**
     * @stability stable
     */
    set country(value: string);
    /**
     * @stability stable
     */
    get countryInput(): string | undefined;
    private _postalCode?;
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    set postalCode(value: string);
    /**
     * @stability stable
     */
    get postalCodeInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataboxEdgeOrderTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#create DataboxEdgeOrder#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#delete DataboxEdgeOrder#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#read DataboxEdgeOrder#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order#update DataboxEdgeOrder#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function databoxEdgeOrderTimeoutsToTerraform(struct?: DataboxEdgeOrderTimeoutsOutputReference | DataboxEdgeOrderTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataboxEdgeOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataboxEdgeOrderTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataboxEdgeOrderTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order azurerm_databox_edge_order}.
 *
 * @stability stable
 */
export declare class DataboxEdgeOrder extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/databox_edge_order azurerm_databox_edge_order} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataboxEdgeOrderConfig);
    private _deviceName?;
    /**
     * @stability stable
     */
    get deviceName(): string;
    /**
     * @stability stable
     */
    set deviceName(value: string);
    /**
     * @stability stable
     */
    get deviceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    returnTracking(index: string): DataboxEdgeOrderReturnTracking;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    shipmentHistory(index: string): DataboxEdgeOrderShipmentHistory;
    /**
     * @stability stable
     */
    shipmentTracking(index: string): DataboxEdgeOrderShipmentTracking;
    /**
     * @stability stable
     */
    status(index: string): DataboxEdgeOrderStatus;
    private _contact;
    /**
     * @stability stable
     */
    get contact(): DataboxEdgeOrderContactOutputReference;
    /**
     * @stability stable
     */
    putContact(value: DataboxEdgeOrderContact): void;
    /**
     * @stability stable
     */
    get contactInput(): DataboxEdgeOrderContact | undefined;
    private _shipmentAddress;
    /**
     * @stability stable
     */
    get shipmentAddress(): DataboxEdgeOrderShipmentAddressOutputReference;
    /**
     * @stability stable
     */
    putShipmentAddress(value: DataboxEdgeOrderShipmentAddress): void;
    /**
     * @stability stable
     */
    get shipmentAddressInput(): DataboxEdgeOrderShipmentAddress | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataboxEdgeOrderTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataboxEdgeOrderTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataboxEdgeOrderTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
