import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventhubNamespaceAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#listen EventhubNamespaceAuthorizationRule#listen}.
     *
     * @stability stable
     */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#manage EventhubNamespaceAuthorizationRule#manage}.
     *
     * @stability stable
     */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#name EventhubNamespaceAuthorizationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#namespace_name EventhubNamespaceAuthorizationRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#resource_group_name EventhubNamespaceAuthorizationRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#send EventhubNamespaceAuthorizationRule#send}.
     *
     * @stability stable
     */
    readonly send?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#timeouts EventhubNamespaceAuthorizationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventhubNamespaceAuthorizationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface EventhubNamespaceAuthorizationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#create EventhubNamespaceAuthorizationRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#delete EventhubNamespaceAuthorizationRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#read EventhubNamespaceAuthorizationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule#update EventhubNamespaceAuthorizationRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventhubNamespaceAuthorizationRuleTimeoutsToTerraform(struct?: EventhubNamespaceAuthorizationRuleTimeoutsOutputReference | EventhubNamespaceAuthorizationRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class EventhubNamespaceAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventhubNamespaceAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventhubNamespaceAuthorizationRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule azurerm_eventhub_namespace_authorization_rule}.
 *
 * @stability stable
 */
export declare class EventhubNamespaceAuthorizationRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventhub_namespace_authorization_rule azurerm_eventhub_namespace_authorization_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventhubNamespaceAuthorizationRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _listen?;
    /**
     * @stability stable
     */
    get listen(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set listen(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetListen(): void;
    /**
     * @stability stable
     */
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    /**
     * @stability stable
     */
    get manage(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manage(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManage(): void;
    /**
     * @stability stable
     */
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _send?;
    /**
     * @stability stable
     */
    get send(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set send(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSend(): void;
    /**
     * @stability stable
     */
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventhubNamespaceAuthorizationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventhubNamespaceAuthorizationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventhubNamespaceAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
