import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MachineLearningComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#authorization_type MachineLearningComputeInstance#authorization_type}.
     *
     * @stability stable
     */
    readonly authorizationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#description MachineLearningComputeInstance#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#local_auth_enabled MachineLearningComputeInstance#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#location MachineLearningComputeInstance#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#machine_learning_workspace_id MachineLearningComputeInstance#machine_learning_workspace_id}.
     *
     * @stability stable
     */
    readonly machineLearningWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#name MachineLearningComputeInstance#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#subnet_resource_id MachineLearningComputeInstance#subnet_resource_id}.
     *
     * @stability stable
     */
    readonly subnetResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#tags MachineLearningComputeInstance#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#virtual_machine_size MachineLearningComputeInstance#virtual_machine_size}.
     *
     * @stability stable
     */
    readonly virtualMachineSize: string;
    /**
     * assign_to_user block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#assign_to_user MachineLearningComputeInstance#assign_to_user}
     *
     * @stability stable
     */
    readonly assignToUser?: MachineLearningComputeInstanceAssignToUser;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#identity MachineLearningComputeInstance#identity}
     *
     * @stability stable
     */
    readonly identity?: MachineLearningComputeInstanceIdentity;
    /**
     * ssh block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#ssh MachineLearningComputeInstance#ssh}
     *
     * @stability stable
     */
    readonly ssh?: MachineLearningComputeInstanceSsh;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#timeouts MachineLearningComputeInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MachineLearningComputeInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeInstanceAssignToUser {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#object_id MachineLearningComputeInstance#object_id}.
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#tenant_id MachineLearningComputeInstance#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function machineLearningComputeInstanceAssignToUserToTerraform(struct?: MachineLearningComputeInstanceAssignToUserOutputReference | MachineLearningComputeInstanceAssignToUser): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeInstanceAssignToUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeInstanceAssignToUser | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeInstanceAssignToUser | undefined);
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeInstanceIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#identity_ids MachineLearningComputeInstance#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#type MachineLearningComputeInstance#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function machineLearningComputeInstanceIdentityToTerraform(struct?: MachineLearningComputeInstanceIdentityOutputReference | MachineLearningComputeInstanceIdentity): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeInstanceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeInstanceIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeInstanceIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeInstanceSsh {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#public_key MachineLearningComputeInstance#public_key}.
     *
     * @stability stable
     */
    readonly publicKey: string;
}
export declare function machineLearningComputeInstanceSshToTerraform(struct?: MachineLearningComputeInstanceSshOutputReference | MachineLearningComputeInstanceSsh): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeInstanceSshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeInstanceSsh | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeInstanceSsh | undefined);
    /**
     * @stability stable
     */
    get port(): number;
    private _publicKey?;
    /**
     * @stability stable
     */
    get publicKey(): string;
    /**
     * @stability stable
     */
    set publicKey(value: string);
    /**
     * @stability stable
     */
    get publicKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface MachineLearningComputeInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#create MachineLearningComputeInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#delete MachineLearningComputeInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance#read MachineLearningComputeInstance#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function machineLearningComputeInstanceTimeoutsToTerraform(struct?: MachineLearningComputeInstanceTimeoutsOutputReference | MachineLearningComputeInstanceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MachineLearningComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningComputeInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningComputeInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance azurerm_machine_learning_compute_instance}.
 *
 * @stability stable
 */
export declare class MachineLearningComputeInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_compute_instance azurerm_machine_learning_compute_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MachineLearningComputeInstanceConfig);
    private _authorizationType?;
    /**
     * @stability stable
     */
    get authorizationType(): string;
    /**
     * @stability stable
     */
    set authorizationType(value: string);
    /**
     * @stability stable
     */
    resetAuthorizationType(): void;
    /**
     * @stability stable
     */
    get authorizationTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceId(): string;
    /**
     * @stability stable
     */
    set machineLearningWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _subnetResourceId?;
    /**
     * @stability stable
     */
    get subnetResourceId(): string;
    /**
     * @stability stable
     */
    set subnetResourceId(value: string);
    /**
     * @stability stable
     */
    resetSubnetResourceId(): void;
    /**
     * @stability stable
     */
    get subnetResourceIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualMachineSize?;
    /**
     * @stability stable
     */
    get virtualMachineSize(): string;
    /**
     * @stability stable
     */
    set virtualMachineSize(value: string);
    /**
     * @stability stable
     */
    get virtualMachineSizeInput(): string | undefined;
    private _assignToUser;
    /**
     * @stability stable
     */
    get assignToUser(): MachineLearningComputeInstanceAssignToUserOutputReference;
    /**
     * @stability stable
     */
    putAssignToUser(value: MachineLearningComputeInstanceAssignToUser): void;
    /**
     * @stability stable
     */
    resetAssignToUser(): void;
    /**
     * @stability stable
     */
    get assignToUserInput(): MachineLearningComputeInstanceAssignToUser | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MachineLearningComputeInstanceIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MachineLearningComputeInstanceIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MachineLearningComputeInstanceIdentity | undefined;
    private _ssh;
    /**
     * @stability stable
     */
    get ssh(): MachineLearningComputeInstanceSshOutputReference;
    /**
     * @stability stable
     */
    putSsh(value: MachineLearningComputeInstanceSsh): void;
    /**
     * @stability stable
     */
    resetSsh(): void;
    /**
     * @stability stable
     */
    get sshInput(): MachineLearningComputeInstanceSsh | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MachineLearningComputeInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MachineLearningComputeInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MachineLearningComputeInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
