import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#description MonitorActionRuleSuppression#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#enabled MonitorActionRuleSuppression#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#name MonitorActionRuleSuppression#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#resource_group_name MonitorActionRuleSuppression#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#tags MonitorActionRuleSuppression#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#condition MonitorActionRuleSuppression#condition}
     *
     * @stability stable
     */
    readonly condition?: MonitorActionRuleSuppressionCondition;
    /**
     * scope block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#scope MonitorActionRuleSuppression#scope}
     *
     * @stability stable
     */
    readonly scope?: MonitorActionRuleSuppressionScope;
    /**
     * suppression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#suppression MonitorActionRuleSuppression#suppression}
     *
     * @stability stable
     */
    readonly suppression: MonitorActionRuleSuppressionSuppression;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#timeouts MonitorActionRuleSuppression#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorActionRuleSuppressionTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionAlertContext {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionAlertContextToTerraform(struct?: MonitorActionRuleSuppressionConditionAlertContextOutputReference | MonitorActionRuleSuppressionConditionAlertContext): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionAlertContext | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionAlertContext | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionAlertRuleId {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionAlertRuleIdToTerraform(struct?: MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference | MonitorActionRuleSuppressionConditionAlertRuleId): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionAlertRuleId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionAlertRuleId | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionDescription {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionDescriptionToTerraform(struct?: MonitorActionRuleSuppressionConditionDescriptionOutputReference | MonitorActionRuleSuppressionConditionDescription): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionDescription | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionDescription | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionMonitorToTerraform(struct?: MonitorActionRuleSuppressionConditionMonitorOutputReference | MonitorActionRuleSuppressionConditionMonitor): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionMonitor | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionMonitorService {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionMonitorServiceToTerraform(struct?: MonitorActionRuleSuppressionConditionMonitorServiceOutputReference | MonitorActionRuleSuppressionConditionMonitorService): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionMonitorService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionMonitorService | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionSeverity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionSeverityToTerraform(struct?: MonitorActionRuleSuppressionConditionSeverityOutputReference | MonitorActionRuleSuppressionConditionSeverity): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionSeverity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionSeverity | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionConditionTargetResourceType {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionTargetResourceTypeToTerraform(struct?: MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference | MonitorActionRuleSuppressionConditionTargetResourceType): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionConditionTargetResourceType | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionConditionTargetResourceType | undefined);
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionCondition {
    /**
     * alert_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#alert_context MonitorActionRuleSuppression#alert_context}
     *
     * @stability stable
     */
    readonly alertContext?: MonitorActionRuleSuppressionConditionAlertContext;
    /**
     * alert_rule_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#alert_rule_id MonitorActionRuleSuppression#alert_rule_id}
     *
     * @stability stable
     */
    readonly alertRuleId?: MonitorActionRuleSuppressionConditionAlertRuleId;
    /**
     * description block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#description MonitorActionRuleSuppression#description}
     *
     * @stability stable
     */
    readonly description?: MonitorActionRuleSuppressionConditionDescription;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#monitor MonitorActionRuleSuppression#monitor}
     *
     * @stability stable
     */
    readonly monitor?: MonitorActionRuleSuppressionConditionMonitor;
    /**
     * monitor_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#monitor_service MonitorActionRuleSuppression#monitor_service}
     *
     * @stability stable
     */
    readonly monitorService?: MonitorActionRuleSuppressionConditionMonitorService;
    /**
     * severity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#severity MonitorActionRuleSuppression#severity}
     *
     * @stability stable
     */
    readonly severity?: MonitorActionRuleSuppressionConditionSeverity;
    /**
     * target_resource_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#target_resource_type MonitorActionRuleSuppression#target_resource_type}
     *
     * @stability stable
     */
    readonly targetResourceType?: MonitorActionRuleSuppressionConditionTargetResourceType;
}
export declare function monitorActionRuleSuppressionConditionToTerraform(struct?: MonitorActionRuleSuppressionConditionOutputReference | MonitorActionRuleSuppressionCondition): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionCondition | undefined);
    private _alertContext;
    /**
     * @stability stable
     */
    get alertContext(): MonitorActionRuleSuppressionConditionAlertContextOutputReference;
    /**
     * @stability stable
     */
    putAlertContext(value: MonitorActionRuleSuppressionConditionAlertContext): void;
    /**
     * @stability stable
     */
    resetAlertContext(): void;
    /**
     * @stability stable
     */
    get alertContextInput(): MonitorActionRuleSuppressionConditionAlertContext | undefined;
    private _alertRuleId;
    /**
     * @stability stable
     */
    get alertRuleId(): MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference;
    /**
     * @stability stable
     */
    putAlertRuleId(value: MonitorActionRuleSuppressionConditionAlertRuleId): void;
    /**
     * @stability stable
     */
    resetAlertRuleId(): void;
    /**
     * @stability stable
     */
    get alertRuleIdInput(): MonitorActionRuleSuppressionConditionAlertRuleId | undefined;
    private _description;
    /**
     * @stability stable
     */
    get description(): MonitorActionRuleSuppressionConditionDescriptionOutputReference;
    /**
     * @stability stable
     */
    putDescription(value: MonitorActionRuleSuppressionConditionDescription): void;
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): MonitorActionRuleSuppressionConditionDescription | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): MonitorActionRuleSuppressionConditionMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: MonitorActionRuleSuppressionConditionMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): MonitorActionRuleSuppressionConditionMonitor | undefined;
    private _monitorService;
    /**
     * @stability stable
     */
    get monitorService(): MonitorActionRuleSuppressionConditionMonitorServiceOutputReference;
    /**
     * @stability stable
     */
    putMonitorService(value: MonitorActionRuleSuppressionConditionMonitorService): void;
    /**
     * @stability stable
     */
    resetMonitorService(): void;
    /**
     * @stability stable
     */
    get monitorServiceInput(): MonitorActionRuleSuppressionConditionMonitorService | undefined;
    private _severity;
    /**
     * @stability stable
     */
    get severity(): MonitorActionRuleSuppressionConditionSeverityOutputReference;
    /**
     * @stability stable
     */
    putSeverity(value: MonitorActionRuleSuppressionConditionSeverity): void;
    /**
     * @stability stable
     */
    resetSeverity(): void;
    /**
     * @stability stable
     */
    get severityInput(): MonitorActionRuleSuppressionConditionSeverity | undefined;
    private _targetResourceType;
    /**
     * @stability stable
     */
    get targetResourceType(): MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference;
    /**
     * @stability stable
     */
    putTargetResourceType(value: MonitorActionRuleSuppressionConditionTargetResourceType): void;
    /**
     * @stability stable
     */
    resetTargetResourceType(): void;
    /**
     * @stability stable
     */
    get targetResourceTypeInput(): MonitorActionRuleSuppressionConditionTargetResourceType | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionScope {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#resource_ids MonitorActionRuleSuppression#resource_ids}.
     *
     * @stability stable
     */
    readonly resourceIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#type MonitorActionRuleSuppression#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function monitorActionRuleSuppressionScopeToTerraform(struct?: MonitorActionRuleSuppressionScopeOutputReference | MonitorActionRuleSuppressionScope): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionScope | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionScope | undefined);
    private _resourceIds?;
    /**
     * @stability stable
     */
    get resourceIds(): string[];
    /**
     * @stability stable
     */
    set resourceIds(value: string[]);
    /**
     * @stability stable
     */
    get resourceIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionSuppressionSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#end_date_utc MonitorActionRuleSuppression#end_date_utc}.
     *
     * @stability stable
     */
    readonly endDateUtc: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_monthly MonitorActionRuleSuppression#recurrence_monthly}.
     *
     * @stability stable
     */
    readonly recurrenceMonthly?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_weekly MonitorActionRuleSuppression#recurrence_weekly}.
     *
     * @stability stable
     */
    readonly recurrenceWeekly?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#start_date_utc MonitorActionRuleSuppression#start_date_utc}.
     *
     * @stability stable
     */
    readonly startDateUtc: string;
}
export declare function monitorActionRuleSuppressionSuppressionScheduleToTerraform(struct?: MonitorActionRuleSuppressionSuppressionScheduleOutputReference | MonitorActionRuleSuppressionSuppressionSchedule): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionSuppressionScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionSuppressionSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionSuppressionSchedule | undefined);
    private _endDateUtc?;
    /**
     * @stability stable
     */
    get endDateUtc(): string;
    /**
     * @stability stable
     */
    set endDateUtc(value: string);
    /**
     * @stability stable
     */
    get endDateUtcInput(): string | undefined;
    private _recurrenceMonthly?;
    /**
     * @stability stable
     */
    get recurrenceMonthly(): number[];
    /**
     * @stability stable
     */
    set recurrenceMonthly(value: number[]);
    /**
     * @stability stable
     */
    resetRecurrenceMonthly(): void;
    /**
     * @stability stable
     */
    get recurrenceMonthlyInput(): number[] | undefined;
    private _recurrenceWeekly?;
    /**
     * @stability stable
     */
    get recurrenceWeekly(): string[];
    /**
     * @stability stable
     */
    set recurrenceWeekly(value: string[]);
    /**
     * @stability stable
     */
    resetRecurrenceWeekly(): void;
    /**
     * @stability stable
     */
    get recurrenceWeeklyInput(): string[] | undefined;
    private _startDateUtc?;
    /**
     * @stability stable
     */
    get startDateUtc(): string;
    /**
     * @stability stable
     */
    set startDateUtc(value: string);
    /**
     * @stability stable
     */
    get startDateUtcInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionSuppression {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_type MonitorActionRuleSuppression#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#schedule MonitorActionRuleSuppression#schedule}
     *
     * @stability stable
     */
    readonly schedule?: MonitorActionRuleSuppressionSuppressionSchedule;
}
export declare function monitorActionRuleSuppressionSuppressionToTerraform(struct?: MonitorActionRuleSuppressionSuppressionOutputReference | MonitorActionRuleSuppressionSuppression): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionSuppressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionSuppression | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionSuppression | undefined);
    private _recurrenceType?;
    /**
     * @stability stable
     */
    get recurrenceType(): string;
    /**
     * @stability stable
     */
    set recurrenceType(value: string);
    /**
     * @stability stable
     */
    get recurrenceTypeInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): MonitorActionRuleSuppressionSuppressionScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: MonitorActionRuleSuppressionSuppressionSchedule): void;
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): MonitorActionRuleSuppressionSuppressionSchedule | undefined;
}
/**
 * @stability stable
 */
export interface MonitorActionRuleSuppressionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#create MonitorActionRuleSuppression#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#delete MonitorActionRuleSuppression#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#read MonitorActionRuleSuppression#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#update MonitorActionRuleSuppression#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorActionRuleSuppressionTimeoutsToTerraform(struct?: MonitorActionRuleSuppressionTimeoutsOutputReference | MonitorActionRuleSuppressionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitorActionRuleSuppressionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorActionRuleSuppressionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorActionRuleSuppressionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression azurerm_monitor_action_rule_suppression}.
 *
 * @stability stable
 */
export declare class MonitorActionRuleSuppression extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression azurerm_monitor_action_rule_suppression} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorActionRuleSuppressionConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): MonitorActionRuleSuppressionConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: MonitorActionRuleSuppressionCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): MonitorActionRuleSuppressionCondition | undefined;
    private _scope;
    /**
     * @stability stable
     */
    get scope(): MonitorActionRuleSuppressionScopeOutputReference;
    /**
     * @stability stable
     */
    putScope(value: MonitorActionRuleSuppressionScope): void;
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): MonitorActionRuleSuppressionScope | undefined;
    private _suppression;
    /**
     * @stability stable
     */
    get suppression(): MonitorActionRuleSuppressionSuppressionOutputReference;
    /**
     * @stability stable
     */
    putSuppression(value: MonitorActionRuleSuppressionSuppression): void;
    /**
     * @stability stable
     */
    get suppressionInput(): MonitorActionRuleSuppressionSuppression | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorActionRuleSuppressionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorActionRuleSuppressionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorActionRuleSuppressionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
