import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PolicyDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#description PolicyDefinition#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#display_name PolicyDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#management_group_id PolicyDefinition#management_group_id}.
     *
     * @stability stable
     */
    readonly managementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#management_group_name PolicyDefinition#management_group_name}.
     *
     * @stability stable
     */
    readonly managementGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#metadata PolicyDefinition#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#mode PolicyDefinition#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#name PolicyDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#parameters PolicyDefinition#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#policy_rule PolicyDefinition#policy_rule}.
     *
     * @stability stable
     */
    readonly policyRule?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#policy_type PolicyDefinition#policy_type}.
     *
     * @stability stable
     */
    readonly policyType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#timeouts PolicyDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PolicyDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface PolicyDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#create PolicyDefinition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#delete PolicyDefinition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#read PolicyDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition#update PolicyDefinition#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function policyDefinitionTimeoutsToTerraform(struct?: PolicyDefinitionTimeoutsOutputReference | PolicyDefinitionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PolicyDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PolicyDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PolicyDefinitionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition azurerm_policy_definition}.
 *
 * @stability stable
 */
export declare class PolicyDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/policy_definition azurerm_policy_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PolicyDefinitionConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupId?;
    /**
     * @stability stable
     */
    get managementGroupId(): string;
    /**
     * @stability stable
     */
    set managementGroupId(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupId(): void;
    /**
     * @stability stable
     */
    get managementGroupIdInput(): string | undefined;
    private _managementGroupName?;
    /**
     * @stability stable
     */
    get managementGroupName(): string;
    /**
     * @stability stable
     */
    set managementGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupName(): void;
    /**
     * @stability stable
     */
    get managementGroupNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    set parameters(value: string);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): string | undefined;
    private _policyRule?;
    /**
     * @stability stable
     */
    get policyRule(): string;
    /**
     * @stability stable
     */
    set policyRule(value: string);
    /**
     * @stability stable
     */
    resetPolicyRule(): void;
    /**
     * @stability stable
     */
    get policyRuleInput(): string | undefined;
    private _policyType?;
    /**
     * @stability stable
     */
    get policyType(): string;
    /**
     * @stability stable
     */
    set policyType(value: string);
    /**
     * @stability stable
     */
    get policyTypeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PolicyDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PolicyDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PolicyDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
