import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RedisLinkedServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#linked_redis_cache_id RedisLinkedServer#linked_redis_cache_id}.
     *
     * @stability stable
     */
    readonly linkedRedisCacheId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#linked_redis_cache_location RedisLinkedServer#linked_redis_cache_location}.
     *
     * @stability stable
     */
    readonly linkedRedisCacheLocation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#resource_group_name RedisLinkedServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#server_role RedisLinkedServer#server_role}.
     *
     * @stability stable
     */
    readonly serverRole: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#target_redis_cache_name RedisLinkedServer#target_redis_cache_name}.
     *
     * @stability stable
     */
    readonly targetRedisCacheName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#timeouts RedisLinkedServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RedisLinkedServerTimeouts;
}
/**
 * @stability stable
 */
export interface RedisLinkedServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#create RedisLinkedServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#delete RedisLinkedServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#read RedisLinkedServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server#update RedisLinkedServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function redisLinkedServerTimeoutsToTerraform(struct?: RedisLinkedServerTimeoutsOutputReference | RedisLinkedServerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class RedisLinkedServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RedisLinkedServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RedisLinkedServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server azurerm_redis_linked_server}.
 *
 * @stability stable
 */
export declare class RedisLinkedServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/redis_linked_server azurerm_redis_linked_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RedisLinkedServerConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedRedisCacheId?;
    /**
     * @stability stable
     */
    get linkedRedisCacheId(): string;
    /**
     * @stability stable
     */
    set linkedRedisCacheId(value: string);
    /**
     * @stability stable
     */
    get linkedRedisCacheIdInput(): string | undefined;
    private _linkedRedisCacheLocation?;
    /**
     * @stability stable
     */
    get linkedRedisCacheLocation(): string;
    /**
     * @stability stable
     */
    set linkedRedisCacheLocation(value: string);
    /**
     * @stability stable
     */
    get linkedRedisCacheLocationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverRole?;
    /**
     * @stability stable
     */
    get serverRole(): string;
    /**
     * @stability stable
     */
    set serverRole(value: string);
    /**
     * @stability stable
     */
    get serverRoleInput(): string | undefined;
    private _targetRedisCacheName?;
    /**
     * @stability stable
     */
    get targetRedisCacheName(): string;
    /**
     * @stability stable
     */
    set targetRedisCacheName(value: string);
    /**
     * @stability stable
     */
    get targetRedisCacheNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RedisLinkedServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RedisLinkedServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RedisLinkedServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
