import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#additional_data SecurityCenterAssessment#additional_data}.
     *
     * @stability stable
     */
    readonly additionalData?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#assessment_policy_id SecurityCenterAssessment#assessment_policy_id}.
     *
     * @stability stable
     */
    readonly assessmentPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#target_resource_id SecurityCenterAssessment#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#status SecurityCenterAssessment#status}
     *
     * @stability stable
     */
    readonly status: SecurityCenterAssessmentStatus;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#timeouts SecurityCenterAssessment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterAssessmentTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterAssessmentStatus {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#cause SecurityCenterAssessment#cause}.
     *
     * @stability stable
     */
    readonly cause?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#code SecurityCenterAssessment#code}.
     *
     * @stability stable
     */
    readonly code: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#description SecurityCenterAssessment#description}.
     *
     * @stability stable
     */
    readonly description?: string;
}
export declare function securityCenterAssessmentStatusToTerraform(struct?: SecurityCenterAssessmentStatusOutputReference | SecurityCenterAssessmentStatus): any;
/**
 * @stability stable
 */
export declare class SecurityCenterAssessmentStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterAssessmentStatus | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterAssessmentStatus | undefined);
    private _cause?;
    /**
     * @stability stable
     */
    get cause(): string;
    /**
     * @stability stable
     */
    set cause(value: string);
    /**
     * @stability stable
     */
    resetCause(): void;
    /**
     * @stability stable
     */
    get causeInput(): string | undefined;
    private _code?;
    /**
     * @stability stable
     */
    get code(): string;
    /**
     * @stability stable
     */
    set code(value: string);
    /**
     * @stability stable
     */
    get codeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SecurityCenterAssessmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#create SecurityCenterAssessment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#delete SecurityCenterAssessment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#read SecurityCenterAssessment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment#update SecurityCenterAssessment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function securityCenterAssessmentTimeoutsToTerraform(struct?: SecurityCenterAssessmentTimeoutsOutputReference | SecurityCenterAssessmentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SecurityCenterAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterAssessmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment azurerm_security_center_assessment}.
 *
 * @stability stable
 */
export declare class SecurityCenterAssessment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_assessment azurerm_security_center_assessment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityCenterAssessmentConfig);
    private _additionalData?;
    /**
     * @stability stable
     */
    get additionalData(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set additionalData(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetAdditionalData(): void;
    /**
     * @stability stable
     */
    get additionalDataInput(): {
        [key: string]: string;
    } | undefined;
    private _assessmentPolicyId?;
    /**
     * @stability stable
     */
    get assessmentPolicyId(): string;
    /**
     * @stability stable
     */
    set assessmentPolicyId(value: string);
    /**
     * @stability stable
     */
    get assessmentPolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _status;
    /**
     * @stability stable
     */
    get status(): SecurityCenterAssessmentStatusOutputReference;
    /**
     * @stability stable
     */
    putStatus(value: SecurityCenterAssessmentStatus): void;
    /**
     * @stability stable
     */
    get statusInput(): SecurityCenterAssessmentStatus | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterAssessmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterAssessmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterAssessmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
