import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#certificate_name SpringCloudCustomDomain#certificate_name}.
     *
     * @stability stable
     */
    readonly certificateName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#name SpringCloudCustomDomain#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#spring_cloud_app_id SpringCloudCustomDomain#spring_cloud_app_id}.
     *
     * @stability stable
     */
    readonly springCloudAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#thumbprint SpringCloudCustomDomain#thumbprint}.
     *
     * @stability stable
     */
    readonly thumbprint?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#timeouts SpringCloudCustomDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudCustomDomainTimeouts;
}
/**
 * @stability stable
 */
export interface SpringCloudCustomDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#create SpringCloudCustomDomain#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#delete SpringCloudCustomDomain#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#read SpringCloudCustomDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain#update SpringCloudCustomDomain#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function springCloudCustomDomainTimeoutsToTerraform(struct?: SpringCloudCustomDomainTimeoutsOutputReference | SpringCloudCustomDomainTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SpringCloudCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudCustomDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudCustomDomainTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain azurerm_spring_cloud_custom_domain}.
 *
 * @stability stable
 */
export declare class SpringCloudCustomDomain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_custom_domain azurerm_spring_cloud_custom_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudCustomDomainConfig);
    private _certificateName?;
    /**
     * @stability stable
     */
    get certificateName(): string;
    /**
     * @stability stable
     */
    set certificateName(value: string);
    /**
     * @stability stable
     */
    resetCertificateName(): void;
    /**
     * @stability stable
     */
    get certificateNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _springCloudAppId?;
    /**
     * @stability stable
     */
    get springCloudAppId(): string;
    /**
     * @stability stable
     */
    set springCloudAppId(value: string);
    /**
     * @stability stable
     */
    get springCloudAppIdInput(): string | undefined;
    private _thumbprint?;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    /**
     * @stability stable
     */
    set thumbprint(value: string);
    /**
     * @stability stable
     */
    resetThumbprint(): void;
    /**
     * @stability stable
     */
    get thumbprintInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudCustomDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudCustomDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudCustomDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
