import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#databases SqlFailoverGroup#databases}.
     *
     * @stability stable
     */
    readonly databases?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#name SqlFailoverGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#resource_group_name SqlFailoverGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#server_name SqlFailoverGroup#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#tags SqlFailoverGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * partner_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#partner_servers SqlFailoverGroup#partner_servers}
     *
     * @stability stable
     */
    readonly partnerServers: SqlFailoverGroupPartnerServers[] | cdktf.IResolvable;
    /**
     * read_write_endpoint_failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#read_write_endpoint_failover_policy SqlFailoverGroup#read_write_endpoint_failover_policy}
     *
     * @stability stable
     */
    readonly readWriteEndpointFailoverPolicy: SqlFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
     * readonly_endpoint_failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#readonly_endpoint_failover_policy SqlFailoverGroup#readonly_endpoint_failover_policy}
     *
     * @stability stable
     */
    readonly readonlyEndpointFailoverPolicy?: SqlFailoverGroupReadonlyEndpointFailoverPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#timeouts SqlFailoverGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlFailoverGroupTimeouts;
}
/**
 * @stability stable
 */
export interface SqlFailoverGroupPartnerServers {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#id SqlFailoverGroup#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function sqlFailoverGroupPartnerServersToTerraform(struct?: SqlFailoverGroupPartnerServers | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface SqlFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#grace_minutes SqlFailoverGroup#grace_minutes}.
     *
     * @stability stable
     */
    readonly graceMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#mode SqlFailoverGroup#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function sqlFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: SqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | SqlFailoverGroupReadWriteEndpointFailoverPolicy): any;
/**
 * @stability stable
 */
export declare class SqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    /**
     * @stability stable
     */
    get graceMinutes(): number;
    /**
     * @stability stable
     */
    set graceMinutes(value: number);
    /**
     * @stability stable
     */
    resetGraceMinutes(): void;
    /**
     * @stability stable
     */
    get graceMinutesInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlFailoverGroupReadonlyEndpointFailoverPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#mode SqlFailoverGroup#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function sqlFailoverGroupReadonlyEndpointFailoverPolicyToTerraform(struct?: SqlFailoverGroupReadonlyEndpointFailoverPolicyOutputReference | SqlFailoverGroupReadonlyEndpointFailoverPolicy): any;
/**
 * @stability stable
 */
export declare class SqlFailoverGroupReadonlyEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlFailoverGroupReadonlyEndpointFailoverPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlFailoverGroupReadonlyEndpointFailoverPolicy | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlFailoverGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#create SqlFailoverGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#delete SqlFailoverGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#read SqlFailoverGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group#update SqlFailoverGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlFailoverGroupTimeoutsToTerraform(struct?: SqlFailoverGroupTimeoutsOutputReference | SqlFailoverGroupTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SqlFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlFailoverGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group azurerm_sql_failover_group}.
 *
 * @stability stable
 */
export declare class SqlFailoverGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_failover_group azurerm_sql_failover_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlFailoverGroupConfig);
    private _databases?;
    /**
     * @stability stable
     */
    get databases(): string[];
    /**
     * @stability stable
     */
    set databases(value: string[]);
    /**
     * @stability stable
     */
    resetDatabases(): void;
    /**
     * @stability stable
     */
    get databasesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get role(): string;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _partnerServers?;
    /**
     * @stability stable
     */
    get partnerServers(): SqlFailoverGroupPartnerServers[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set partnerServers(value: SqlFailoverGroupPartnerServers[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get partnerServersInput(): cdktf.IResolvable | SqlFailoverGroupPartnerServers[] | undefined;
    private _readWriteEndpointFailoverPolicy;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicy(): SqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    /**
     * @stability stable
     */
    putReadWriteEndpointFailoverPolicy(value: SqlFailoverGroupReadWriteEndpointFailoverPolicy): void;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicyInput(): SqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _readonlyEndpointFailoverPolicy;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicy(): SqlFailoverGroupReadonlyEndpointFailoverPolicyOutputReference;
    /**
     * @stability stable
     */
    putReadonlyEndpointFailoverPolicy(value: SqlFailoverGroupReadonlyEndpointFailoverPolicy): void;
    /**
     * @stability stable
     */
    resetReadonlyEndpointFailoverPolicy(): void;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicyInput(): SqlFailoverGroupReadonlyEndpointFailoverPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlFailoverGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlFailoverGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
