import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageObjectReplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#destination_storage_account_id StorageObjectReplication#destination_storage_account_id}.
     *
     * @stability stable
     */
    readonly destinationStorageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#source_storage_account_id StorageObjectReplication#source_storage_account_id}.
     *
     * @stability stable
     */
    readonly sourceStorageAccountId: string;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#rules StorageObjectReplication#rules}
     *
     * @stability stable
     */
    readonly rules: StorageObjectReplicationRules[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#timeouts StorageObjectReplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageObjectReplicationTimeouts;
}
/**
 * @stability stable
 */
export interface StorageObjectReplicationRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#copy_blobs_created_after StorageObjectReplication#copy_blobs_created_after}.
     *
     * @stability stable
     */
    readonly copyBlobsCreatedAfter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#destination_container_name StorageObjectReplication#destination_container_name}.
     *
     * @stability stable
     */
    readonly destinationContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#filter_out_blobs_with_prefix StorageObjectReplication#filter_out_blobs_with_prefix}.
     *
     * @stability stable
     */
    readonly filterOutBlobsWithPrefix?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#source_container_name StorageObjectReplication#source_container_name}.
     *
     * @stability stable
     */
    readonly sourceContainerName: string;
}
export declare function storageObjectReplicationRulesToTerraform(struct?: StorageObjectReplicationRules | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface StorageObjectReplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#create StorageObjectReplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#delete StorageObjectReplication#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#read StorageObjectReplication#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication#update StorageObjectReplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageObjectReplicationTimeoutsToTerraform(struct?: StorageObjectReplicationTimeoutsOutputReference | StorageObjectReplicationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StorageObjectReplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageObjectReplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageObjectReplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication azurerm_storage_object_replication}.
 *
 * @stability stable
 */
export declare class StorageObjectReplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_object_replication azurerm_storage_object_replication} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageObjectReplicationConfig);
    /**
     * @stability stable
     */
    get destinationObjectReplicationId(): string;
    private _destinationStorageAccountId?;
    /**
     * @stability stable
     */
    get destinationStorageAccountId(): string;
    /**
     * @stability stable
     */
    set destinationStorageAccountId(value: string);
    /**
     * @stability stable
     */
    get destinationStorageAccountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get sourceObjectReplicationId(): string;
    private _sourceStorageAccountId?;
    /**
     * @stability stable
     */
    get sourceStorageAccountId(): string;
    /**
     * @stability stable
     */
    set sourceStorageAccountId(value: string);
    /**
     * @stability stable
     */
    get sourceStorageAccountIdInput(): string | undefined;
    private _rules?;
    /**
     * @stability stable
     */
    get rules(): StorageObjectReplicationRules[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rules(value: StorageObjectReplicationRules[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get rulesInput(): cdktf.IResolvable | StorageObjectReplicationRules[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageObjectReplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageObjectReplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageObjectReplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
