import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsStreamInputEventhubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#eventhub_consumer_group_name StreamAnalyticsStreamInputEventhub#eventhub_consumer_group_name}.
     *
     * @stability stable
     */
    readonly eventhubConsumerGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#eventhub_name StreamAnalyticsStreamInputEventhub#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#name StreamAnalyticsStreamInputEventhub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#resource_group_name StreamAnalyticsStreamInputEventhub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#servicebus_namespace StreamAnalyticsStreamInputEventhub#servicebus_namespace}.
     *
     * @stability stable
     */
    readonly servicebusNamespace: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#shared_access_policy_key StreamAnalyticsStreamInputEventhub#shared_access_policy_key}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#shared_access_policy_name StreamAnalyticsStreamInputEventhub#shared_access_policy_name}.
     *
     * @stability stable
     */
    readonly sharedAccessPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#stream_analytics_job_name StreamAnalyticsStreamInputEventhub#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * serialization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#serialization StreamAnalyticsStreamInputEventhub#serialization}
     *
     * @stability stable
     */
    readonly serialization: StreamAnalyticsStreamInputEventhubSerialization;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#timeouts StreamAnalyticsStreamInputEventhub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsStreamInputEventhubTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsStreamInputEventhubSerialization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#encoding StreamAnalyticsStreamInputEventhub#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#field_delimiter StreamAnalyticsStreamInputEventhub#field_delimiter}.
     *
     * @stability stable
     */
    readonly fieldDelimiter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#type StreamAnalyticsStreamInputEventhub#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function streamAnalyticsStreamInputEventhubSerializationToTerraform(struct?: StreamAnalyticsStreamInputEventhubSerializationOutputReference | StreamAnalyticsStreamInputEventhubSerialization): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsStreamInputEventhubSerializationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsStreamInputEventhubSerialization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsStreamInputEventhubSerialization | undefined);
    private _encoding?;
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    set encoding(value: string);
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): string | undefined;
    private _fieldDelimiter?;
    /**
     * @stability stable
     */
    get fieldDelimiter(): string;
    /**
     * @stability stable
     */
    set fieldDelimiter(value: string);
    /**
     * @stability stable
     */
    resetFieldDelimiter(): void;
    /**
     * @stability stable
     */
    get fieldDelimiterInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsStreamInputEventhubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#create StreamAnalyticsStreamInputEventhub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#delete StreamAnalyticsStreamInputEventhub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#read StreamAnalyticsStreamInputEventhub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub#update StreamAnalyticsStreamInputEventhub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsStreamInputEventhubTimeoutsToTerraform(struct?: StreamAnalyticsStreamInputEventhubTimeoutsOutputReference | StreamAnalyticsStreamInputEventhubTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsStreamInputEventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsStreamInputEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsStreamInputEventhubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub azurerm_stream_analytics_stream_input_eventhub}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsStreamInputEventhub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_stream_input_eventhub azurerm_stream_analytics_stream_input_eventhub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsStreamInputEventhubConfig);
    private _eventhubConsumerGroupName?;
    /**
     * @stability stable
     */
    get eventhubConsumerGroupName(): string;
    /**
     * @stability stable
     */
    set eventhubConsumerGroupName(value: string);
    /**
     * @stability stable
     */
    resetEventhubConsumerGroupName(): void;
    /**
     * @stability stable
     */
    get eventhubConsumerGroupNameInput(): string | undefined;
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _servicebusNamespace?;
    /**
     * @stability stable
     */
    get servicebusNamespace(): string;
    /**
     * @stability stable
     */
    set servicebusNamespace(value: string);
    /**
     * @stability stable
     */
    get servicebusNamespaceInput(): string | undefined;
    private _sharedAccessPolicyKey?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyKey(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyKey(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyKeyInput(): string | undefined;
    private _sharedAccessPolicyName?;
    /**
     * @stability stable
     */
    get sharedAccessPolicyName(): string;
    /**
     * @stability stable
     */
    set sharedAccessPolicyName(value: string);
    /**
     * @stability stable
     */
    get sharedAccessPolicyNameInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _serialization;
    /**
     * @stability stable
     */
    get serialization(): StreamAnalyticsStreamInputEventhubSerializationOutputReference;
    /**
     * @stability stable
     */
    putSerialization(value: StreamAnalyticsStreamInputEventhubSerialization): void;
    /**
     * @stability stable
     */
    get serializationInput(): StreamAnalyticsStreamInputEventhubSerialization | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsStreamInputEventhubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsStreamInputEventhubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsStreamInputEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
