import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSqlPoolWorkloadClassifierConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#context SynapseSqlPoolWorkloadClassifier#context}.
     *
     * @stability stable
     */
    readonly context?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#end_time SynapseSqlPoolWorkloadClassifier#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#importance SynapseSqlPoolWorkloadClassifier#importance}.
     *
     * @stability stable
     */
    readonly importance?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#label SynapseSqlPoolWorkloadClassifier#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#member_name SynapseSqlPoolWorkloadClassifier#member_name}.
     *
     * @stability stable
     */
    readonly memberName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#name SynapseSqlPoolWorkloadClassifier#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#start_time SynapseSqlPoolWorkloadClassifier#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#workload_group_id SynapseSqlPoolWorkloadClassifier#workload_group_id}.
     *
     * @stability stable
     */
    readonly workloadGroupId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#timeouts SynapseSqlPoolWorkloadClassifier#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSqlPoolWorkloadClassifierTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSqlPoolWorkloadClassifierTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#create SynapseSqlPoolWorkloadClassifier#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#delete SynapseSqlPoolWorkloadClassifier#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#read SynapseSqlPoolWorkloadClassifier#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier#update SynapseSqlPoolWorkloadClassifier#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSqlPoolWorkloadClassifierTimeoutsToTerraform(struct?: SynapseSqlPoolWorkloadClassifierTimeoutsOutputReference | SynapseSqlPoolWorkloadClassifierTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SynapseSqlPoolWorkloadClassifierTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSqlPoolWorkloadClassifierTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSqlPoolWorkloadClassifierTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier azurerm_synapse_sql_pool_workload_classifier}.
 *
 * @stability stable
 */
export declare class SynapseSqlPoolWorkloadClassifier extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_sql_pool_workload_classifier azurerm_synapse_sql_pool_workload_classifier} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSqlPoolWorkloadClassifierConfig);
    private _context?;
    /**
     * @stability stable
     */
    get context(): string;
    /**
     * @stability stable
     */
    set context(value: string);
    /**
     * @stability stable
     */
    resetContext(): void;
    /**
     * @stability stable
     */
    get contextInput(): string | undefined;
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _importance?;
    /**
     * @stability stable
     */
    get importance(): string;
    /**
     * @stability stable
     */
    set importance(value: string);
    /**
     * @stability stable
     */
    resetImportance(): void;
    /**
     * @stability stable
     */
    get importanceInput(): string | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _memberName?;
    /**
     * @stability stable
     */
    get memberName(): string;
    /**
     * @stability stable
     */
    set memberName(value: string);
    /**
     * @stability stable
     */
    get memberNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _workloadGroupId?;
    /**
     * @stability stable
     */
    get workloadGroupId(): string;
    /**
     * @stability stable
     */
    set workloadGroupId(value: string);
    /**
     * @stability stable
     */
    get workloadGroupIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSqlPoolWorkloadClassifierTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSqlPoolWorkloadClassifierTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSqlPoolWorkloadClassifierTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
