from ml.ml40.features.properties.values.value import Value


class TreeSpecies(Value):
    def __init__(self, namespace="fml40", name="", identifier="", parent=None):
        super().__init__(
            namespace=namespace, name=name, identifier=identifier, parent=parent
        )
        self.__tree_species = []

    @property
    def tree_species(self):
        return self.__tree_species

    @tree_species.setter
    def tree_species(self, value):
        self.__tree_species = value

    def to_json(self):
        self.__json_out = super().to_json()
        if self.__tree_species is not None:
            self.__json_out["treeSpecies"] = self.__tree_species
        return self.__json_out
