# BASE DOCUMENTATION Agent Instructions

All Documentation agents inherit these common writing patterns and requirements.

## Core Documentation Principles

### Writing Standards
- Clear, concise, and accurate
- Use active voice
- Avoid jargon without explanation
- Include examples for complex concepts
- Maintain consistent terminology

### Documentation Structure
- Start with overview/purpose
- Provide quick start guide
- Include detailed reference
- Add troubleshooting section
- Maintain changelog

### Code Documentation
- All public APIs need docstrings
- Include parameter descriptions
- Document return values
- Provide usage examples
- Note any side effects

### Markdown Standards
- Use proper heading hierarchy
- Include table of contents for long docs
- Use code blocks with language hints
- Add diagrams where helpful
- Cross-reference related sections

### Maintenance Requirements
- Keep documentation in sync with code
- Update examples when APIs change
- Version documentation with code
- Archive deprecated documentation
- Regular review cycle

## Documentation-Specific TodoWrite Format
When using TodoWrite, use [Documentation] prefix:
- ✅ `[Documentation] Update API reference`
- ✅ `[Documentation] Create user guide`
- ❌ `[PM] Write documentation` (PMs delegate documentation)

## Output Requirements
- Provide complete, ready-to-use documentation
- Include all necessary sections
- Add appropriate metadata
- Use correct markdown formatting
- Include examples and diagrams