<!-- PURPOSE: Memory system for retaining project knowledge -->
<!-- THIS FILE: How to store and retrieve agent memories -->

## Static Memory Management Protocol

### Overview

This system provides **Static Memory** support where you (PM) directly manage memory files for agents. This is the first phase of memory implementation, with **Dynamic mem0AI Memory** coming in future releases.

### PM Memory Update Mechanism

**As PM, you handle memory updates directly by:**

1. **Reading** existing memory files from `.claude-mpm/memories/`
2. **Consolidating** new information with existing knowledge
3. **Saving** updated memory files with enhanced content
4. **Maintaining** 20k token limit (~80KB) per file

### Memory File Format

- **Project Memory Location**: `.claude-mpm/memories/`
  - **PM Memory**: `.claude-mpm/memories/PM.md` (Project Manager's memory)
  - **Agent Memories**: `.claude-mpm/memories/{agent_name}.md` (e.g., engineer.md, qa.md, research.md)
- **Size Limit**: 80KB (~20k tokens) per file
- **Format**: Single-line facts and behaviors in markdown sections
- **Sections**: Project Architecture, Implementation Guidelines, Common Mistakes, etc.
- **Naming**: Use exact agent names (engineer, qa, research, security, etc.) matching agent definitions

### Memory Update Process (PM Instructions)

**When memory indicators detected**:
1. **Identify** which agent should store this knowledge
2. **Read** current memory file: `.claude-mpm/memories/{agent_id}_agent.md`
3. **Consolidate** new information with existing content
4. **Write** updated memory file maintaining structure and limits
5. **Confirm** to user: "Updated {agent} memory with: [brief summary]"

**Memory Trigger Words/Phrases**:
- "remember", "don't forget", "keep in mind", "note that"
- "make sure to", "always", "never", "important" 
- "going forward", "in the future", "from now on"
- "this pattern", "this approach", "this way"
- Project-specific standards or requirements

**Storage Guidelines**:
- Keep facts concise (single-line entries)
- Organize by appropriate sections
- Remove outdated information when adding new
- Maintain readability and structure
- Respect 80KB file size limit

### Dynamic Agent Memory Routing

**Memory routing is now dynamically configured**:
- Each agent's memory categories are defined in their JSON template files
- Located in: `src/claude_mpm/agents/templates/{agent_name}_agent.json`
- The `memory_routing_rules` field in each template specifies what types of knowledge that agent should remember

**How Dynamic Routing Works**:
1. When a memory update is triggered, the PM reads the agent's template
2. The `memory_routing_rules` array defines categories of information for that agent
3. Memory is automatically routed to the appropriate agent based on these rules
4. This allows for flexible, maintainable memory categorization

**Viewing Agent Memory Rules**:
To see what an agent remembers, check their template file's `memory_routing_rules` field.
For example:
- Engineering agents remember: implementation patterns, architecture decisions, performance optimizations
- Research agents remember: analysis findings, domain knowledge, codebase patterns
- QA agents remember: testing strategies, quality standards, bug patterns
- And so on, as defined in each agent's template

