# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetClusterKubeConfigResult',
    'AwaitableGetClusterKubeConfigResult',
    'get_cluster_kube_config',
    'get_cluster_kube_config_output',
]

@pulumi.output_type
class GetClusterKubeConfigResult:
    """
    A collection of values returned by getClusterKubeConfig.
    """
    def __init__(__self__, cluster_id=None, content=None, endpoint=None, expiration=None, id=None, token_version=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if expiration and not isinstance(expiration, int):
            raise TypeError("Expected argument 'expiration' to be a int")
        pulumi.set(__self__, "expiration", expiration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if token_version and not isinstance(token_version, str):
            raise TypeError("Expected argument 'token_version' to be a str")
        pulumi.set(__self__, "token_version", token_version)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        content of the Kubeconfig YAML for the cluster.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[int]:
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="tokenVersion")
    def token_version(self) -> Optional[str]:
        return pulumi.get(self, "token_version")


class AwaitableGetClusterKubeConfigResult(GetClusterKubeConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterKubeConfigResult(
            cluster_id=self.cluster_id,
            content=self.content,
            endpoint=self.endpoint,
            expiration=self.expiration,
            id=self.id,
            token_version=self.token_version)


def get_cluster_kube_config(cluster_id: Optional[str] = None,
                            endpoint: Optional[str] = None,
                            expiration: Optional[int] = None,
                            token_version: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterKubeConfigResult:
    """
    This data source provides details about a specific Cluster Kube Config resource in Oracle Cloud Infrastructure Container Engine service.

    Create the Kubeconfig YAML for a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_kube_config = oci.ContainerEngine.get_cluster_kube_config(cluster_id=oci_containerengine_cluster["test_cluster"]["id"],
        endpoint=var["cluster_kube_config_endpoint"],
        expiration=var["cluster_kube_config_expiration"],
        token_version=var["cluster_kube_config_token_version"])
    ```


    :param str cluster_id: The OCID of the cluster.
    :param str endpoint: The endpoint to target. A cluster may have multiple endpoints exposed but the kubeconfig can only target one at a time.
    :param int expiration: Deprecated. This field is no longer used.
    :param str token_version: The version of the kubeconfig token. Supported value 2.0.0
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['endpoint'] = endpoint
    __args__['expiration'] = expiration
    __args__['tokenVersion'] = token_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getClusterKubeConfig:getClusterKubeConfig', __args__, opts=opts, typ=GetClusterKubeConfigResult).value

    return AwaitableGetClusterKubeConfigResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        content=pulumi.get(__ret__, 'content'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        expiration=pulumi.get(__ret__, 'expiration'),
        id=pulumi.get(__ret__, 'id'),
        token_version=pulumi.get(__ret__, 'token_version'))


@_utilities.lift_output_func(get_cluster_kube_config)
def get_cluster_kube_config_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                   endpoint: Optional[pulumi.Input[Optional[str]]] = None,
                                   expiration: Optional[pulumi.Input[Optional[int]]] = None,
                                   token_version: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClusterKubeConfigResult]:
    """
    This data source provides details about a specific Cluster Kube Config resource in Oracle Cloud Infrastructure Container Engine service.

    Create the Kubeconfig YAML for a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_kube_config = oci.ContainerEngine.get_cluster_kube_config(cluster_id=oci_containerengine_cluster["test_cluster"]["id"],
        endpoint=var["cluster_kube_config_endpoint"],
        expiration=var["cluster_kube_config_expiration"],
        token_version=var["cluster_kube_config_token_version"])
    ```


    :param str cluster_id: The OCID of the cluster.
    :param str endpoint: The endpoint to target. A cluster may have multiple endpoints exposed but the kubeconfig can only target one at a time.
    :param int expiration: Deprecated. This field is no longer used.
    :param str token_version: The version of the kubeconfig token. Supported value 2.0.0
    """
    ...
