# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetByoipAllocatedRangesResult',
    'AwaitableGetByoipAllocatedRangesResult',
    'get_byoip_allocated_ranges',
    'get_byoip_allocated_ranges_output',
]

@pulumi.output_type
class GetByoipAllocatedRangesResult:
    """
    A collection of values returned by getByoipAllocatedRanges.
    """
    def __init__(__self__, byoip_allocated_range_collections=None, byoip_range_id=None, filters=None, id=None):
        if byoip_allocated_range_collections and not isinstance(byoip_allocated_range_collections, list):
            raise TypeError("Expected argument 'byoip_allocated_range_collections' to be a list")
        pulumi.set(__self__, "byoip_allocated_range_collections", byoip_allocated_range_collections)
        if byoip_range_id and not isinstance(byoip_range_id, str):
            raise TypeError("Expected argument 'byoip_range_id' to be a str")
        pulumi.set(__self__, "byoip_range_id", byoip_range_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="byoipAllocatedRangeCollections")
    def byoip_allocated_range_collections(self) -> Sequence['outputs.GetByoipAllocatedRangesByoipAllocatedRangeCollectionResult']:
        """
        The list of byoip_allocated_range_collection.
        """
        return pulumi.get(self, "byoip_allocated_range_collections")

    @property
    @pulumi.getter(name="byoipRangeId")
    def byoip_range_id(self) -> str:
        return pulumi.get(self, "byoip_range_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetByoipAllocatedRangesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetByoipAllocatedRangesResult(GetByoipAllocatedRangesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetByoipAllocatedRangesResult(
            byoip_allocated_range_collections=self.byoip_allocated_range_collections,
            byoip_range_id=self.byoip_range_id,
            filters=self.filters,
            id=self.id)


def get_byoip_allocated_ranges(byoip_range_id: Optional[str] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetByoipAllocatedRangesFilterArgs']]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetByoipAllocatedRangesResult:
    """
    This data source provides the list of Byoip Allocated Ranges in Oracle Cloud Infrastructure Core service.

    Lists the subranges of a BYOIP CIDR block currently allocated to an IP pool.
    Each `ByoipAllocatedRange` object also lists the IP pool where it is allocated.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_allocated_ranges = oci.Core.get_byoip_allocated_ranges(byoip_range_id=oci_core_byoip_range["test_byoip_range"]["id"])
    ```


    :param str byoip_range_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `ByoipRange` resource containing the BYOIP CIDR block.
    """
    __args__ = dict()
    __args__['byoipRangeId'] = byoip_range_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getByoipAllocatedRanges:getByoipAllocatedRanges', __args__, opts=opts, typ=GetByoipAllocatedRangesResult).value

    return AwaitableGetByoipAllocatedRangesResult(
        byoip_allocated_range_collections=pulumi.get(__ret__, 'byoip_allocated_range_collections'),
        byoip_range_id=pulumi.get(__ret__, 'byoip_range_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_byoip_allocated_ranges)
def get_byoip_allocated_ranges_output(byoip_range_id: Optional[pulumi.Input[str]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetByoipAllocatedRangesFilterArgs']]]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetByoipAllocatedRangesResult]:
    """
    This data source provides the list of Byoip Allocated Ranges in Oracle Cloud Infrastructure Core service.

    Lists the subranges of a BYOIP CIDR block currently allocated to an IP pool.
    Each `ByoipAllocatedRange` object also lists the IP pool where it is allocated.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_byoip_allocated_ranges = oci.Core.get_byoip_allocated_ranges(byoip_range_id=oci_core_byoip_range["test_byoip_range"]["id"])
    ```


    :param str byoip_range_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the `ByoipRange` resource containing the BYOIP CIDR block.
    """
    ...
