# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserAssessmentUsersResult',
    'AwaitableGetUserAssessmentUsersResult',
    'get_user_assessment_users',
    'get_user_assessment_users_output',
]

@pulumi.output_type
class GetUserAssessmentUsersResult:
    """
    A collection of values returned by getUserAssessmentUsers.
    """
    def __init__(__self__, access_level=None, account_status=None, authentication_type=None, compartment_id_in_subtree=None, filters=None, id=None, target_id=None, time_last_login_greater_than_or_equal_to=None, time_last_login_less_than=None, time_password_last_changed_greater_than_or_equal_to=None, time_password_last_changed_less_than=None, time_user_created_greater_than_or_equal_to=None, time_user_created_less_than=None, user_assessment_id=None, user_category=None, user_key=None, user_name=None, user_profile=None, user_role=None, user_type=None, users=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if account_status and not isinstance(account_status, str):
            raise TypeError("Expected argument 'account_status' to be a str")
        pulumi.set(__self__, "account_status", account_status)
        if authentication_type and not isinstance(authentication_type, str):
            raise TypeError("Expected argument 'authentication_type' to be a str")
        pulumi.set(__self__, "authentication_type", authentication_type)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_last_login_greater_than_or_equal_to and not isinstance(time_last_login_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_last_login_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_last_login_greater_than_or_equal_to", time_last_login_greater_than_or_equal_to)
        if time_last_login_less_than and not isinstance(time_last_login_less_than, str):
            raise TypeError("Expected argument 'time_last_login_less_than' to be a str")
        pulumi.set(__self__, "time_last_login_less_than", time_last_login_less_than)
        if time_password_last_changed_greater_than_or_equal_to and not isinstance(time_password_last_changed_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_password_last_changed_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_password_last_changed_greater_than_or_equal_to", time_password_last_changed_greater_than_or_equal_to)
        if time_password_last_changed_less_than and not isinstance(time_password_last_changed_less_than, str):
            raise TypeError("Expected argument 'time_password_last_changed_less_than' to be a str")
        pulumi.set(__self__, "time_password_last_changed_less_than", time_password_last_changed_less_than)
        if time_user_created_greater_than_or_equal_to and not isinstance(time_user_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_user_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_user_created_greater_than_or_equal_to", time_user_created_greater_than_or_equal_to)
        if time_user_created_less_than and not isinstance(time_user_created_less_than, str):
            raise TypeError("Expected argument 'time_user_created_less_than' to be a str")
        pulumi.set(__self__, "time_user_created_less_than", time_user_created_less_than)
        if user_assessment_id and not isinstance(user_assessment_id, str):
            raise TypeError("Expected argument 'user_assessment_id' to be a str")
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)
        if user_category and not isinstance(user_category, str):
            raise TypeError("Expected argument 'user_category' to be a str")
        pulumi.set(__self__, "user_category", user_category)
        if user_key and not isinstance(user_key, str):
            raise TypeError("Expected argument 'user_key' to be a str")
        pulumi.set(__self__, "user_key", user_key)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)
        if user_profile and not isinstance(user_profile, str):
            raise TypeError("Expected argument 'user_profile' to be a str")
        pulumi.set(__self__, "user_profile", user_profile)
        if user_role and not isinstance(user_role, str):
            raise TypeError("Expected argument 'user_role' to be a str")
        pulumi.set(__self__, "user_role", user_role)
        if user_type and not isinstance(user_type, str):
            raise TypeError("Expected argument 'user_type' to be a str")
        pulumi.set(__self__, "user_type", user_type)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> Optional[str]:
        """
        The user account status.
        """
        return pulumi.get(self, "account_status")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[str]:
        """
        The user authentication method.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserAssessmentUsersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeLastLoginGreaterThanOrEqualTo")
    def time_last_login_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_last_login_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeLastLoginLessThan")
    def time_last_login_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_last_login_less_than")

    @property
    @pulumi.getter(name="timePasswordLastChangedGreaterThanOrEqualTo")
    def time_password_last_changed_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_password_last_changed_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timePasswordLastChangedLessThan")
    def time_password_last_changed_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_password_last_changed_less_than")

    @property
    @pulumi.getter(name="timeUserCreatedGreaterThanOrEqualTo")
    def time_user_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_user_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeUserCreatedLessThan")
    def time_user_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_user_created_less_than")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> str:
        return pulumi.get(self, "user_assessment_id")

    @property
    @pulumi.getter(name="userCategory")
    def user_category(self) -> Optional[str]:
        """
        The user category based on the privileges and other details of the user.
        """
        return pulumi.get(self, "user_category")

    @property
    @pulumi.getter(name="userKey")
    def user_key(self) -> Optional[str]:
        return pulumi.get(self, "user_key")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        The database user name.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userProfile")
    def user_profile(self) -> Optional[str]:
        """
        The user profile name.
        """
        return pulumi.get(self, "user_profile")

    @property
    @pulumi.getter(name="userRole")
    def user_role(self) -> Optional[str]:
        return pulumi.get(self, "user_role")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[str]:
        return pulumi.get(self, "user_type")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUserAssessmentUsersUserResult']:
        """
        The list of users.
        """
        return pulumi.get(self, "users")


class AwaitableGetUserAssessmentUsersResult(GetUserAssessmentUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAssessmentUsersResult(
            access_level=self.access_level,
            account_status=self.account_status,
            authentication_type=self.authentication_type,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            target_id=self.target_id,
            time_last_login_greater_than_or_equal_to=self.time_last_login_greater_than_or_equal_to,
            time_last_login_less_than=self.time_last_login_less_than,
            time_password_last_changed_greater_than_or_equal_to=self.time_password_last_changed_greater_than_or_equal_to,
            time_password_last_changed_less_than=self.time_password_last_changed_less_than,
            time_user_created_greater_than_or_equal_to=self.time_user_created_greater_than_or_equal_to,
            time_user_created_less_than=self.time_user_created_less_than,
            user_assessment_id=self.user_assessment_id,
            user_category=self.user_category,
            user_key=self.user_key,
            user_name=self.user_name,
            user_profile=self.user_profile,
            user_role=self.user_role,
            user_type=self.user_type,
            users=self.users)


def get_user_assessment_users(access_level: Optional[str] = None,
                              account_status: Optional[str] = None,
                              authentication_type: Optional[str] = None,
                              compartment_id_in_subtree: Optional[bool] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetUserAssessmentUsersFilterArgs']]] = None,
                              target_id: Optional[str] = None,
                              time_last_login_greater_than_or_equal_to: Optional[str] = None,
                              time_last_login_less_than: Optional[str] = None,
                              time_password_last_changed_greater_than_or_equal_to: Optional[str] = None,
                              time_password_last_changed_less_than: Optional[str] = None,
                              time_user_created_greater_than_or_equal_to: Optional[str] = None,
                              time_user_created_less_than: Optional[str] = None,
                              user_assessment_id: Optional[str] = None,
                              user_category: Optional[str] = None,
                              user_key: Optional[str] = None,
                              user_name: Optional[str] = None,
                              user_profile: Optional[str] = None,
                              user_role: Optional[str] = None,
                              user_type: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAssessmentUsersResult:
    """
    This data source provides the list of User Assessment Users in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of users of the specified user assessment. The result contains the database user details for each user, such
    as user type, account status, last login time, user creation time, authentication type, user profile, and the date and time
    of the latest password change. It also contains the user category derived from these user details as well as privileges
    granted to each user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_users = oci.DataSafe.get_user_assessment_users(user_assessment_id=oci_data_safe_user_assessment["test_user_assessment"]["id"],
        access_level=var["user_assessment_user_access_level"],
        account_status=var["user_assessment_user_account_status"],
        authentication_type=var["user_assessment_user_authentication_type"],
        compartment_id_in_subtree=var["user_assessment_user_compartment_id_in_subtree"],
        target_id=oci_cloud_guard_target["test_target"]["id"],
        time_last_login_greater_than_or_equal_to=var["user_assessment_user_time_last_login_greater_than_or_equal_to"],
        time_last_login_less_than=var["user_assessment_user_time_last_login_less_than"],
        time_password_last_changed_greater_than_or_equal_to=var["user_assessment_user_time_password_last_changed_greater_than_or_equal_to"],
        time_password_last_changed_less_than=var["user_assessment_user_time_password_last_changed_less_than"],
        time_user_created_greater_than_or_equal_to=var["user_assessment_user_time_user_created_greater_than_or_equal_to"],
        time_user_created_less_than=var["user_assessment_user_time_user_created_less_than"],
        user_category=var["user_assessment_user_user_category"],
        user_key=var["user_assessment_user_user_key"],
        user_name=oci_identity_user["test_user"]["name"],
        user_profile=var["user_assessment_user_user_profile"],
        user_role=var["user_assessment_user_user_role"],
        user_type=var["user_assessment_user_user_type"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str account_status: A filter to return only items that match the specified account status.
    :param str authentication_type: A filter to return only items that match the specified authentication type.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_last_login_greater_than_or_equal_to: A filter to return users whose last login time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_last_login_less_than: A filter to return users whose last login time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str time_password_last_changed_greater_than_or_equal_to: A filter to return users whose last password change in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_password_last_changed_less_than: A filter to return users whose last password change in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_user_created_greater_than_or_equal_to: A filter to return users whose creation time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str time_user_created_less_than: A filter to return users whose creation time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str user_assessment_id: The OCID of the user assessment.
    :param str user_category: A filter to return only items that match the specified user category.
    :param str user_key: A filter to return only items that match the specified user key.
    :param str user_name: A filter to return only items that match the specified user name.
    :param str user_profile: A filter to return only items that match the specified user profile.
    :param str user_role: A filter to return only items that match the specified user role.
    :param str user_type: A filter to return only items that match the specified user type. The possible values can be
           * ADMIN_PRIVILEGED
           * APPLICATION
           * PRIVILEGED
           * SCHEMA
           * NON_PRIVILEGED as specified by '#/definitions/userTypes'.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['accountStatus'] = account_status
    __args__['authenticationType'] = authentication_type
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetId'] = target_id
    __args__['timeLastLoginGreaterThanOrEqualTo'] = time_last_login_greater_than_or_equal_to
    __args__['timeLastLoginLessThan'] = time_last_login_less_than
    __args__['timePasswordLastChangedGreaterThanOrEqualTo'] = time_password_last_changed_greater_than_or_equal_to
    __args__['timePasswordLastChangedLessThan'] = time_password_last_changed_less_than
    __args__['timeUserCreatedGreaterThanOrEqualTo'] = time_user_created_greater_than_or_equal_to
    __args__['timeUserCreatedLessThan'] = time_user_created_less_than
    __args__['userAssessmentId'] = user_assessment_id
    __args__['userCategory'] = user_category
    __args__['userKey'] = user_key
    __args__['userName'] = user_name
    __args__['userProfile'] = user_profile
    __args__['userRole'] = user_role
    __args__['userType'] = user_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUserAssessmentUsers:getUserAssessmentUsers', __args__, opts=opts, typ=GetUserAssessmentUsersResult).value

    return AwaitableGetUserAssessmentUsersResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        account_status=pulumi.get(__ret__, 'account_status'),
        authentication_type=pulumi.get(__ret__, 'authentication_type'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_last_login_greater_than_or_equal_to=pulumi.get(__ret__, 'time_last_login_greater_than_or_equal_to'),
        time_last_login_less_than=pulumi.get(__ret__, 'time_last_login_less_than'),
        time_password_last_changed_greater_than_or_equal_to=pulumi.get(__ret__, 'time_password_last_changed_greater_than_or_equal_to'),
        time_password_last_changed_less_than=pulumi.get(__ret__, 'time_password_last_changed_less_than'),
        time_user_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_user_created_greater_than_or_equal_to'),
        time_user_created_less_than=pulumi.get(__ret__, 'time_user_created_less_than'),
        user_assessment_id=pulumi.get(__ret__, 'user_assessment_id'),
        user_category=pulumi.get(__ret__, 'user_category'),
        user_key=pulumi.get(__ret__, 'user_key'),
        user_name=pulumi.get(__ret__, 'user_name'),
        user_profile=pulumi.get(__ret__, 'user_profile'),
        user_role=pulumi.get(__ret__, 'user_role'),
        user_type=pulumi.get(__ret__, 'user_type'),
        users=pulumi.get(__ret__, 'users'))


@_utilities.lift_output_func(get_user_assessment_users)
def get_user_assessment_users_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                     account_status: Optional[pulumi.Input[Optional[str]]] = None,
                                     authentication_type: Optional[pulumi.Input[Optional[str]]] = None,
                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUserAssessmentUsersFilterArgs']]]]] = None,
                                     target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_last_login_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_last_login_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_password_last_changed_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_password_last_changed_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_user_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_user_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_assessment_id: Optional[pulumi.Input[str]] = None,
                                     user_category: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_key: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_profile: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_role: Optional[pulumi.Input[Optional[str]]] = None,
                                     user_type: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserAssessmentUsersResult]:
    """
    This data source provides the list of User Assessment Users in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of users of the specified user assessment. The result contains the database user details for each user, such
    as user type, account status, last login time, user creation time, authentication type, user profile, and the date and time
    of the latest password change. It also contains the user category derived from these user details as well as privileges
    granted to each user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_users = oci.DataSafe.get_user_assessment_users(user_assessment_id=oci_data_safe_user_assessment["test_user_assessment"]["id"],
        access_level=var["user_assessment_user_access_level"],
        account_status=var["user_assessment_user_account_status"],
        authentication_type=var["user_assessment_user_authentication_type"],
        compartment_id_in_subtree=var["user_assessment_user_compartment_id_in_subtree"],
        target_id=oci_cloud_guard_target["test_target"]["id"],
        time_last_login_greater_than_or_equal_to=var["user_assessment_user_time_last_login_greater_than_or_equal_to"],
        time_last_login_less_than=var["user_assessment_user_time_last_login_less_than"],
        time_password_last_changed_greater_than_or_equal_to=var["user_assessment_user_time_password_last_changed_greater_than_or_equal_to"],
        time_password_last_changed_less_than=var["user_assessment_user_time_password_last_changed_less_than"],
        time_user_created_greater_than_or_equal_to=var["user_assessment_user_time_user_created_greater_than_or_equal_to"],
        time_user_created_less_than=var["user_assessment_user_time_user_created_less_than"],
        user_category=var["user_assessment_user_user_category"],
        user_key=var["user_assessment_user_user_key"],
        user_name=oci_identity_user["test_user"]["name"],
        user_profile=var["user_assessment_user_user_profile"],
        user_role=var["user_assessment_user_user_role"],
        user_type=var["user_assessment_user_user_type"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str account_status: A filter to return only items that match the specified account status.
    :param str authentication_type: A filter to return only items that match the specified authentication type.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_last_login_greater_than_or_equal_to: A filter to return users whose last login time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_last_login_less_than: A filter to return users whose last login time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str time_password_last_changed_greater_than_or_equal_to: A filter to return users whose last password change in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_password_last_changed_less_than: A filter to return users whose last password change in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_user_created_greater_than_or_equal_to: A filter to return users whose creation time in the database is greater than or equal to the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str time_user_created_less_than: A filter to return users whose creation time in the database is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). **Example:** 2016-12-19T16:39:57.600Z
    :param str user_assessment_id: The OCID of the user assessment.
    :param str user_category: A filter to return only items that match the specified user category.
    :param str user_key: A filter to return only items that match the specified user key.
    :param str user_name: A filter to return only items that match the specified user name.
    :param str user_profile: A filter to return only items that match the specified user profile.
    :param str user_role: A filter to return only items that match the specified user role.
    :param str user_type: A filter to return only items that match the specified user type. The possible values can be
           * ADMIN_PRIVILEGED
           * APPLICATION
           * PRIVILEGED
           * SCHEMA
           * NON_PRIVILEGED as specified by '#/definitions/userTypes'.
    """
    ...
