# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExternalAsmArgs', 'ExternalAsm']

@pulumi.input_type
class ExternalAsmArgs:
    def __init__(__self__, *,
                 external_asm_id: pulumi.Input[str],
                 external_connector_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ExternalAsm resource.
        :param pulumi.Input[str] external_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        :param pulumi.Input[str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "external_asm_id", external_asm_id)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)

    @property
    @pulumi.getter(name="externalAsmId")
    def external_asm_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        """
        return pulumi.get(self, "external_asm_id")

    @external_asm_id.setter
    def external_asm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_asm_id", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_connector_id", value)


@pulumi.input_type
class _ExternalAsmState:
    def __init__(__self__, *,
                 additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 component_name: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_asm_id: Optional[pulumi.Input[str]] = None,
                 external_connector_id: Optional[pulumi.Input[str]] = None,
                 external_db_system_id: Optional[pulumi.Input[str]] = None,
                 grid_home: Optional[pulumi.Input[str]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 is_flex_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 serviced_databases: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAsmServicedDatabaseArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalAsm resources.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details of the external ASM defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        :param pulumi.Input[str] component_name: The name of the external ASM.
        :param pulumi.Input[str] display_name: The user-friendly name for the database. The name does not have to be unique.
        :param pulumi.Input[str] external_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        :param pulumi.Input[str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the ASM is a part of.
        :param pulumi.Input[str] grid_home: The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.
        :param pulumi.Input[bool] is_cluster: Indicates whether the ASM is a cluster ASM or not.
        :param pulumi.Input[bool] is_flex_enabled: Indicates whether Oracle Flex ASM is enabled or not.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input['ExternalAsmServicedDatabaseArgs']]] serviced_databases: The list of databases that are serviced by the ASM.
        :param pulumi.Input[str] state: The current lifecycle state of the external ASM.
        :param pulumi.Input[str] time_created: The date and time the external ASM was created.
        :param pulumi.Input[str] time_updated: The date and time the external ASM was last updated.
        :param pulumi.Input[str] version: The ASM version.
        """
        if additional_details is not None:
            pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name is not None:
            pulumi.set(__self__, "component_name", component_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_asm_id is not None:
            pulumi.set(__self__, "external_asm_id", external_asm_id)
        if external_connector_id is not None:
            pulumi.set(__self__, "external_connector_id", external_connector_id)
        if external_db_system_id is not None:
            pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if grid_home is not None:
            pulumi.set(__self__, "grid_home", grid_home)
        if is_cluster is not None:
            pulumi.set(__self__, "is_cluster", is_cluster)
        if is_flex_enabled is not None:
            pulumi.set(__self__, "is_flex_enabled", is_flex_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if serviced_databases is not None:
            pulumi.set(__self__, "serviced_databases", serviced_databases)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The additional details of the external ASM defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @additional_details.setter
    def additional_details(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "additional_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the external ASM.
        """
        return pulumi.get(self, "component_name")

    @component_name.setter
    def component_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalAsmId")
    def external_asm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        """
        return pulumi.get(self, "external_asm_id")

    @external_asm_id.setter
    def external_asm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_asm_id", value)

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "external_connector_id")

    @external_connector_id.setter
    def external_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_connector_id", value)

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the ASM is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @external_db_system_id.setter
    def external_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_db_system_id", value)

    @property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> Optional[pulumi.Input[str]]:
        """
        The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @grid_home.setter
    def grid_home(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grid_home", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the ASM is a cluster ASM or not.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter(name="isFlexEnabled")
    def is_flex_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether Oracle Flex ASM is enabled or not.
        """
        return pulumi.get(self, "is_flex_enabled")

    @is_flex_enabled.setter
    def is_flex_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_flex_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAsmServicedDatabaseArgs']]]]:
        """
        The list of databases that are serviced by the ASM.
        """
        return pulumi.get(self, "serviced_databases")

    @serviced_databases.setter
    def serviced_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExternalAsmServicedDatabaseArgs']]]]):
        pulumi.set(self, "serviced_databases", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the external ASM.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the external ASM was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the external ASM was last updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The ASM version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ExternalAsm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_asm_id: Optional[pulumi.Input[str]] = None,
                 external_connector_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the External Asm resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external ASM specified by `externalAsmId`.

        ## Import

        ExternalAsms can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/externalAsm:ExternalAsm test_external_asm "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] external_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        :param pulumi.Input[str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalAsmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Asm resource in Oracle Cloud Infrastructure Database Management service.

        Updates the external ASM specified by `externalAsmId`.

        ## Import

        ExternalAsms can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/externalAsm:ExternalAsm test_external_asm "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalAsmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalAsmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_asm_id: Optional[pulumi.Input[str]] = None,
                 external_connector_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalAsmArgs.__new__(ExternalAsmArgs)

            if external_asm_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_asm_id'")
            __props__.__dict__["external_asm_id"] = external_asm_id
            __props__.__dict__["external_connector_id"] = external_connector_id
            __props__.__dict__["additional_details"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["component_name"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["external_db_system_id"] = None
            __props__.__dict__["grid_home"] = None
            __props__.__dict__["is_cluster"] = None
            __props__.__dict__["is_flex_enabled"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["serviced_databases"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["version"] = None
        super(ExternalAsm, __self__).__init__(
            'oci:DatabaseManagement/externalAsm:ExternalAsm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_details: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            component_name: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            external_asm_id: Optional[pulumi.Input[str]] = None,
            external_connector_id: Optional[pulumi.Input[str]] = None,
            external_db_system_id: Optional[pulumi.Input[str]] = None,
            grid_home: Optional[pulumi.Input[str]] = None,
            is_cluster: Optional[pulumi.Input[bool]] = None,
            is_flex_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            serviced_databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalAsmServicedDatabaseArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ExternalAsm':
        """
        Get an existing ExternalAsm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] additional_details: The additional details of the external ASM defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        :param pulumi.Input[str] component_name: The name of the external ASM.
        :param pulumi.Input[str] display_name: The user-friendly name for the database. The name does not have to be unique.
        :param pulumi.Input[str] external_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        :param pulumi.Input[str] external_connector_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the ASM is a part of.
        :param pulumi.Input[str] grid_home: The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.
        :param pulumi.Input[bool] is_cluster: Indicates whether the ASM is a cluster ASM or not.
        :param pulumi.Input[bool] is_flex_enabled: Indicates whether Oracle Flex ASM is enabled or not.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExternalAsmServicedDatabaseArgs']]]] serviced_databases: The list of databases that are serviced by the ASM.
        :param pulumi.Input[str] state: The current lifecycle state of the external ASM.
        :param pulumi.Input[str] time_created: The date and time the external ASM was created.
        :param pulumi.Input[str] time_updated: The date and time the external ASM was last updated.
        :param pulumi.Input[str] version: The ASM version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalAsmState.__new__(_ExternalAsmState)

        __props__.__dict__["additional_details"] = additional_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_name"] = component_name
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_asm_id"] = external_asm_id
        __props__.__dict__["external_connector_id"] = external_connector_id
        __props__.__dict__["external_db_system_id"] = external_db_system_id
        __props__.__dict__["grid_home"] = grid_home
        __props__.__dict__["is_cluster"] = is_cluster
        __props__.__dict__["is_flex_enabled"] = is_flex_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["serviced_databases"] = serviced_databases
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["version"] = version
        return ExternalAsm(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The additional details of the external ASM defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> pulumi.Output[str]:
        """
        The name of the external ASM.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalAsmId")
    def external_asm_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external ASM.
        """
        return pulumi.get(self, "external_asm_id")

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "external_connector_id")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the ASM is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="gridHome")
    def grid_home(self) -> pulumi.Output[str]:
        """
        The directory in which ASM is installed. This is the same directory in which Oracle Grid Infrastructure is installed.
        """
        return pulumi.get(self, "grid_home")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> pulumi.Output[bool]:
        """
        Indicates whether the ASM is a cluster ASM or not.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="isFlexEnabled")
    def is_flex_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether Oracle Flex ASM is enabled or not.
        """
        return pulumi.get(self, "is_flex_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> pulumi.Output[Sequence['outputs.ExternalAsmServicedDatabase']]:
        """
        The list of databases that are serviced by the ASM.
        """
        return pulumi.get(self, "serviced_databases")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the external ASM.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the external ASM was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the external ASM was last updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The ASM version.
        """
        return pulumi.get(self, "version")

