# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetExternalDbHomeResult',
    'AwaitableGetExternalDbHomeResult',
    'get_external_db_home',
    'get_external_db_home_output',
]

@pulumi.output_type
class GetExternalDbHomeResult:
    """
    A collection of values returned by getExternalDbHome.
    """
    def __init__(__self__, additional_details=None, compartment_id=None, component_name=None, display_name=None, external_db_home_id=None, external_db_system_id=None, home_directory=None, id=None, lifecycle_details=None, state=None, time_created=None, time_updated=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name and not isinstance(component_name, str):
            raise TypeError("Expected argument 'component_name' to be a str")
        pulumi.set(__self__, "component_name", component_name)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_db_home_id and not isinstance(external_db_home_id, str):
            raise TypeError("Expected argument 'external_db_home_id' to be a str")
        pulumi.set(__self__, "external_db_home_id", external_db_home_id)
        if external_db_system_id and not isinstance(external_db_system_id, str):
            raise TypeError("Expected argument 'external_db_system_id' to be a str")
        pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if home_directory and not isinstance(home_directory, str):
            raise TypeError("Expected argument 'home_directory' to be a str")
        pulumi.set(__self__, "home_directory", home_directory)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details of the DB home defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> str:
        """
        The name of the external DB home.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the external DB home. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalDbHomeId")
    def external_db_home_id(self) -> str:
        return pulumi.get(self, "external_db_home_id")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the DB home is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="homeDirectory")
    def home_directory(self) -> str:
        """
        The location of the DB home.
        """
        return pulumi.get(self, "home_directory")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the external DB home.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the external DB home was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the external DB home was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetExternalDbHomeResult(GetExternalDbHomeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalDbHomeResult(
            additional_details=self.additional_details,
            compartment_id=self.compartment_id,
            component_name=self.component_name,
            display_name=self.display_name,
            external_db_home_id=self.external_db_home_id,
            external_db_system_id=self.external_db_system_id,
            home_directory=self.home_directory,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_external_db_home(external_db_home_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalDbHomeResult:
    """
    This data source provides details about a specific External Db Home resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB home specified by `externalDbHomeId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_home = oci.DatabaseManagement.get_external_db_home(external_db_home_id=oci_database_management_external_db_home["test_external_db_home"]["id"])
    ```


    :param str external_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database home.
    """
    __args__ = dict()
    __args__['externalDbHomeId'] = external_db_home_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalDbHome:getExternalDbHome', __args__, opts=opts, typ=GetExternalDbHomeResult).value

    return AwaitableGetExternalDbHomeResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_name=pulumi.get(__ret__, 'component_name'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_db_home_id=pulumi.get(__ret__, 'external_db_home_id'),
        external_db_system_id=pulumi.get(__ret__, 'external_db_system_id'),
        home_directory=pulumi.get(__ret__, 'home_directory'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_external_db_home)
def get_external_db_home_output(external_db_home_id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalDbHomeResult]:
    """
    This data source provides details about a specific External Db Home resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external DB home specified by `externalDbHomeId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_db_home = oci.DatabaseManagement.get_external_db_home(external_db_home_id=oci_database_management_external_db_home["test_external_db_home"]["id"])
    ```


    :param str external_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database home.
    """
    ...
