# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DrPlanExecutionExecutionOptions',
    'DrPlanExecutionGroupExecution',
    'DrPlanExecutionGroupExecutionStepExecution',
    'DrPlanExecutionGroupExecutionStepExecutionLogLocation',
    'DrPlanExecutionLogLocation',
    'DrPlanPlanGroup',
    'DrPlanPlanGroupStep',
    'DrPlanPlanGroupStepUserDefinedStep',
    'DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocation',
    'DrProtectionGroupAssociation',
    'DrProtectionGroupLogLocation',
    'DrProtectionGroupMember',
    'DrProtectionGroupMemberVnicMapping',
    'GetDrPlanExecutionExecutionOptionResult',
    'GetDrPlanExecutionGroupExecutionResult',
    'GetDrPlanExecutionGroupExecutionStepExecutionResult',
    'GetDrPlanExecutionGroupExecutionStepExecutionLogLocationResult',
    'GetDrPlanExecutionLogLocationResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemExecutionOptionResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionLogLocationResult',
    'GetDrPlanExecutionsDrPlanExecutionCollectionItemLogLocationResult',
    'GetDrPlanExecutionsFilterResult',
    'GetDrPlanPlanGroupResult',
    'GetDrPlanPlanGroupStepResult',
    'GetDrPlanPlanGroupStepUserDefinedStepResult',
    'GetDrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult',
    'GetDrPlansDrPlanCollectionResult',
    'GetDrPlansDrPlanCollectionItemResult',
    'GetDrPlansDrPlanCollectionItemPlanGroupResult',
    'GetDrPlansDrPlanCollectionItemPlanGroupStepResult',
    'GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepResult',
    'GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult',
    'GetDrPlansFilterResult',
    'GetDrProtectionGroupAssociationResult',
    'GetDrProtectionGroupLogLocationResult',
    'GetDrProtectionGroupMemberResult',
    'GetDrProtectionGroupMemberVnicMappingResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionItemResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionItemAssociationResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionItemLogLocationResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberResult',
    'GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult',
    'GetDrProtectionGroupsFilterResult',
]

@pulumi.output_type
class DrPlanExecutionExecutionOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planExecutionType":
            suggest = "plan_execution_type"
        elif key == "arePrechecksEnabled":
            suggest = "are_prechecks_enabled"
        elif key == "areWarningsIgnored":
            suggest = "are_warnings_ignored"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanExecutionExecutionOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanExecutionExecutionOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanExecutionExecutionOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 plan_execution_type: str,
                 are_prechecks_enabled: Optional[bool] = None,
                 are_warnings_ignored: Optional[bool] = None):
        """
        :param str plan_execution_type: The type of the plan execution.
        :param bool are_prechecks_enabled: A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        :param bool are_warnings_ignored: A flag indicating whether warnings should be ignored during the switchover precheck.  Example: `true`
        """
        pulumi.set(__self__, "plan_execution_type", plan_execution_type)
        if are_prechecks_enabled is not None:
            pulumi.set(__self__, "are_prechecks_enabled", are_prechecks_enabled)
        if are_warnings_ignored is not None:
            pulumi.set(__self__, "are_warnings_ignored", are_warnings_ignored)

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> str:
        """
        The type of the plan execution.
        """
        return pulumi.get(self, "plan_execution_type")

    @property
    @pulumi.getter(name="arePrechecksEnabled")
    def are_prechecks_enabled(self) -> Optional[bool]:
        """
        A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_prechecks_enabled")

    @property
    @pulumi.getter(name="areWarningsIgnored")
    def are_warnings_ignored(self) -> Optional[bool]:
        """
        A flag indicating whether warnings should be ignored during the switchover precheck.  Example: `true`
        """
        return pulumi.get(self, "are_warnings_ignored")


@pulumi.output_type
class DrPlanExecutionGroupExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "executionDurationInSec":
            suggest = "execution_duration_in_sec"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "stepExecutions":
            suggest = "step_executions"
        elif key == "timeEnded":
            suggest = "time_ended"
        elif key == "timeStarted":
            suggest = "time_started"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanExecutionGroupExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanExecutionGroupExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanExecutionGroupExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 execution_duration_in_sec: Optional[int] = None,
                 group_id: Optional[str] = None,
                 status: Optional[str] = None,
                 status_details: Optional[str] = None,
                 step_executions: Optional[Sequence['outputs.DrPlanExecutionGroupExecutionStepExecution']] = None,
                 time_ended: Optional[str] = None,
                 time_started: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param Sequence['DrPlanExecutionGroupExecutionStepExecutionArgs'] step_executions: A list of details of each step executed in this group.
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_duration_in_sec is not None:
            pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)
        if step_executions is not None:
            pulumi.set(__self__, "step_executions", step_executions)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[int]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[str]:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepExecutions")
    def step_executions(self) -> Optional[Sequence['outputs.DrPlanExecutionGroupExecutionStepExecution']]:
        """
        A list of details of each step executed in this group.
        """
        return pulumi.get(self, "step_executions")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[str]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[str]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DrPlanExecutionGroupExecutionStepExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "executionDurationInSec":
            suggest = "execution_duration_in_sec"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "logLocations":
            suggest = "log_locations"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "stepId":
            suggest = "step_id"
        elif key == "timeEnded":
            suggest = "time_ended"
        elif key == "timeStarted":
            suggest = "time_started"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanExecutionGroupExecutionStepExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanExecutionGroupExecutionStepExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanExecutionGroupExecutionStepExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 execution_duration_in_sec: Optional[int] = None,
                 group_id: Optional[str] = None,
                 log_locations: Optional[Sequence['outputs.DrPlanExecutionGroupExecutionStepExecutionLogLocation']] = None,
                 status: Optional[str] = None,
                 status_details: Optional[str] = None,
                 step_id: Optional[str] = None,
                 time_ended: Optional[str] = None,
                 time_started: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str display_name: (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param Sequence['DrPlanExecutionGroupExecutionStepExecutionLogLocationArgs'] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param str step_id: The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_duration_in_sec is not None:
            pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)
        if step_id is not None:
            pulumi.set(__self__, "step_id", step_id)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The display name of the DR Plan Execution.  Example: `Execution - EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> Optional[int]:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[Sequence['outputs.DrPlanExecutionGroupExecutionStepExecutionLogLocation']]:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[str]:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> Optional[str]:
        """
        The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[str]:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[str]:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DrPlanExecutionGroupExecutionStepExecutionLogLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DrPlanExecutionLogLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DrPlanPlanGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanPlanGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanPlanGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanPlanGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 steps: Optional[Sequence['outputs.DrPlanPlanGroupStep']] = None,
                 type: Optional[str] = None):
        """
        :param str display_name: (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param Sequence['DrPlanPlanGroupStepArgs'] steps: The list of steps in this plan group.
        :param str type: The type of DR Plan to be created. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def steps(self) -> Optional[Sequence['outputs.DrPlanPlanGroupStep']]:
        """
        The list of steps in this plan group.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of DR Plan to be created. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DrPlanPlanGroupStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "errorMode":
            suggest = "error_mode"
        elif key == "groupId":
            suggest = "group_id"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "memberId":
            suggest = "member_id"
        elif key == "userDefinedSteps":
            suggest = "user_defined_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanPlanGroupStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanPlanGroupStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanPlanGroupStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 error_mode: Optional[str] = None,
                 group_id: Optional[str] = None,
                 id: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 member_id: Optional[str] = None,
                 timeout: Optional[int] = None,
                 type: Optional[str] = None,
                 user_defined_steps: Optional[Sequence['outputs.DrPlanPlanGroupStepUserDefinedStep']] = None):
        """
        :param str display_name: (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        :param str error_mode: The error mode for this step.
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param bool is_enabled: A flag indicating whether this step should be enabled for execution.  Example: `true`
        :param str member_id: The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        :param int timeout: The timeout in seconds for executing this step.  Example: `600`
        :param str type: The type of DR Plan to be created. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param Sequence['DrPlanPlanGroupStepUserDefinedStepArgs'] user_defined_steps: The details for a user-defined step in a DR Plan.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if error_mode is not None:
            pulumi.set(__self__, "error_mode", error_mode)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if member_id is not None:
            pulumi.set(__self__, "member_id", member_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_defined_steps is not None:
            pulumi.set(__self__, "user_defined_steps", user_defined_steps)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        (Updatable) The display name of the DR Plan being created.  Example: `EBS Switchover PHX to IAD`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="errorMode")
    def error_mode(self) -> Optional[str]:
        """
        The error mode for this step.
        """
        return pulumi.get(self, "error_mode")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        A flag indicating whether this step should be enabled for execution.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> Optional[str]:
        """
        The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        The timeout in seconds for executing this step.  Example: `600`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of DR Plan to be created. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userDefinedSteps")
    def user_defined_steps(self) -> Optional[Sequence['outputs.DrPlanPlanGroupStepUserDefinedStep']]:
        """
        The details for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "user_defined_steps")


@pulumi.output_type
class DrPlanPlanGroupStepUserDefinedStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionId":
            suggest = "function_id"
        elif key == "functionRegion":
            suggest = "function_region"
        elif key == "objectStorageScriptLocations":
            suggest = "object_storage_script_locations"
        elif key == "requestBody":
            suggest = "request_body"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "runOnInstanceId":
            suggest = "run_on_instance_id"
        elif key == "runOnInstanceRegion":
            suggest = "run_on_instance_region"
        elif key == "scriptCommand":
            suggest = "script_command"
        elif key == "stepType":
            suggest = "step_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrPlanPlanGroupStepUserDefinedStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrPlanPlanGroupStepUserDefinedStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrPlanPlanGroupStepUserDefinedStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_id: Optional[str] = None,
                 function_region: Optional[str] = None,
                 object_storage_script_locations: Optional[Sequence['outputs.DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocation']] = None,
                 request_body: Optional[str] = None,
                 run_as_user: Optional[str] = None,
                 run_on_instance_id: Optional[str] = None,
                 run_on_instance_region: Optional[str] = None,
                 script_command: Optional[str] = None,
                 step_type: Optional[str] = None):
        """
        :param str function_id: The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        :param str function_region: The region in which the function is deployed.  Example: `us-ashburn-1`
        :param Sequence['DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs'] object_storage_script_locations: Information about an Object Storage script location for a user-defined step in a DR Plan.
        :param str request_body: The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        :param str run_as_user: The userid on the instance to be used for executing the script or command.  Example: `opc`
        :param str run_on_instance_id: The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str run_on_instance_region: The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        :param str script_command: The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        :param str step_type: The type of the step.
        """
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if function_region is not None:
            pulumi.set(__self__, "function_region", function_region)
        if object_storage_script_locations is not None:
            pulumi.set(__self__, "object_storage_script_locations", object_storage_script_locations)
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if run_on_instance_id is not None:
            pulumi.set(__self__, "run_on_instance_id", run_on_instance_id)
        if run_on_instance_region is not None:
            pulumi.set(__self__, "run_on_instance_region", run_on_instance_region)
        if script_command is not None:
            pulumi.set(__self__, "script_command", script_command)
        if step_type is not None:
            pulumi.set(__self__, "step_type", step_type)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[str]:
        """
        The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionRegion")
    def function_region(self) -> Optional[str]:
        """
        The region in which the function is deployed.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "function_region")

    @property
    @pulumi.getter(name="objectStorageScriptLocations")
    def object_storage_script_locations(self) -> Optional[Sequence['outputs.DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocation']]:
        """
        Information about an Object Storage script location for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "object_storage_script_locations")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[str]:
        """
        The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[str]:
        """
        The userid on the instance to be used for executing the script or command.  Example: `opc`
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="runOnInstanceId")
    def run_on_instance_id(self) -> Optional[str]:
        """
        The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "run_on_instance_id")

    @property
    @pulumi.getter(name="runOnInstanceRegion")
    def run_on_instance_region(self) -> Optional[str]:
        """
        The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "run_on_instance_region")

    @property
    @pulumi.getter(name="scriptCommand")
    def script_command(self) -> Optional[str]:
        """
        The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        """
        return pulumi.get(self, "script_command")

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> Optional[str]:
        """
        The type of the step.
        """
        return pulumi.get(self, "step_type")


@pulumi.output_type
class DrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DrProtectionGroupAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerId":
            suggest = "peer_id"
        elif key == "peerRegion":
            suggest = "peer_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrProtectionGroupAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrProtectionGroupAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrProtectionGroupAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: str,
                 peer_id: Optional[str] = None,
                 peer_region: Optional[str] = None):
        """
        :param str role: The role of this DR Protection Group.
        :param str peer_id: The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        pulumi.set(__self__, "role", role)
        if peer_id is not None:
            pulumi.set(__self__, "peer_id", peer_id)
        if peer_region is not None:
            pulumi.set(__self__, "peer_region", peer_region)

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of this DR Protection Group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[str]:
        """
        The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> Optional[str]:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")


@pulumi.output_type
class DrProtectionGroupLogLocation(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: Optional[str] = None):
        """
        :param str bucket: (Updatable) The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: (Updatable) The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        (Updatable) The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        (Updatable) The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class DrProtectionGroupMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memberId":
            suggest = "member_id"
        elif key == "memberType":
            suggest = "member_type"
        elif key == "destinationCapacityReservationId":
            suggest = "destination_capacity_reservation_id"
        elif key == "destinationCompartmentId":
            suggest = "destination_compartment_id"
        elif key == "destinationDedicatedVmHostId":
            suggest = "destination_dedicated_vm_host_id"
        elif key == "isMovable":
            suggest = "is_movable"
        elif key == "isRetainFaultDomain":
            suggest = "is_retain_fault_domain"
        elif key == "passwordVaultSecretId":
            suggest = "password_vault_secret_id"
        elif key == "vnicMapping":
            suggest = "vnic_mapping"
        elif key == "vnicMappings":
            suggest = "vnic_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrProtectionGroupMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrProtectionGroupMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrProtectionGroupMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 member_id: str,
                 member_type: str,
                 destination_capacity_reservation_id: Optional[str] = None,
                 destination_compartment_id: Optional[str] = None,
                 destination_dedicated_vm_host_id: Optional[str] = None,
                 is_movable: Optional[bool] = None,
                 is_retain_fault_domain: Optional[bool] = None,
                 password_vault_secret_id: Optional[str] = None,
                 vnic_mapping: Optional[Sequence['outputs.DrProtectionGroupMemberVnicMapping']] = None,
                 vnic_mappings: Optional[Sequence['outputs.DrProtectionGroupMemberVnicMapping']] = None):
        """
        :param str member_id: (Updatable) The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str member_type: (Updatable) The type of the member.
        :param str destination_capacity_reservation_id: (Updatable) The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        :param str destination_compartment_id: (Updatable) The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param str destination_dedicated_vm_host_id: (Updatable) The OCID of the dedicated VM Host in the destination region where this compute instance should be launched  Example: `ocid1.dedicatedvmhost.oc1.iad.&lt;unique_id&gt;`
        :param bool is_movable: (Updatable) A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        :param bool is_retain_fault_domain: (Updatable) A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        :param str password_vault_secret_id: (Updatable) The OCID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.&lt;unique_id&gt;`
        :param Sequence['DrProtectionGroupMemberVnicMappingArgs'] vnic_mapping: (Updatable) A list of Compute Instance VNIC mappings.
        :param Sequence['DrProtectionGroupMemberVnicMappingArgs'] vnic_mappings: (Updatable) A list of Compute Instance VNIC mappings.
        """
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "member_type", member_type)
        if destination_capacity_reservation_id is not None:
            pulumi.set(__self__, "destination_capacity_reservation_id", destination_capacity_reservation_id)
        if destination_compartment_id is not None:
            pulumi.set(__self__, "destination_compartment_id", destination_compartment_id)
        if destination_dedicated_vm_host_id is not None:
            pulumi.set(__self__, "destination_dedicated_vm_host_id", destination_dedicated_vm_host_id)
        if is_movable is not None:
            pulumi.set(__self__, "is_movable", is_movable)
        if is_retain_fault_domain is not None:
            pulumi.set(__self__, "is_retain_fault_domain", is_retain_fault_domain)
        if password_vault_secret_id is not None:
            pulumi.set(__self__, "password_vault_secret_id", password_vault_secret_id)
        if vnic_mapping is not None:
            pulumi.set(__self__, "vnic_mapping", vnic_mapping)
        if vnic_mappings is not None:
            pulumi.set(__self__, "vnic_mappings", vnic_mappings)

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> str:
        """
        (Updatable) The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> str:
        """
        (Updatable) The type of the member.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter(name="destinationCapacityReservationId")
    def destination_capacity_reservation_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_capacity_reservation_id")

    @property
    @pulumi.getter(name="destinationCompartmentId")
    def destination_compartment_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_compartment_id")

    @property
    @pulumi.getter(name="destinationDedicatedVmHostId")
    def destination_dedicated_vm_host_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the dedicated VM Host in the destination region where this compute instance should be launched  Example: `ocid1.dedicatedvmhost.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_dedicated_vm_host_id")

    @property
    @pulumi.getter(name="isMovable")
    def is_movable(self) -> Optional[bool]:
        """
        (Updatable) A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        """
        return pulumi.get(self, "is_movable")

    @property
    @pulumi.getter(name="isRetainFaultDomain")
    def is_retain_fault_domain(self) -> Optional[bool]:
        """
        (Updatable) A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        """
        return pulumi.get(self, "is_retain_fault_domain")

    @property
    @pulumi.getter(name="passwordVaultSecretId")
    def password_vault_secret_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "password_vault_secret_id")

    @property
    @pulumi.getter(name="vnicMapping")
    def vnic_mapping(self) -> Optional[Sequence['outputs.DrProtectionGroupMemberVnicMapping']]:
        """
        (Updatable) A list of Compute Instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mapping")

    @property
    @pulumi.getter(name="vnicMappings")
    def vnic_mappings(self) -> Optional[Sequence['outputs.DrProtectionGroupMemberVnicMapping']]:
        """
        (Updatable) A list of Compute Instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mappings")


@pulumi.output_type
class DrProtectionGroupMemberVnicMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationNsgIdLists":
            suggest = "destination_nsg_id_lists"
        elif key == "destinationPrimaryPrivateIpAddress":
            suggest = "destination_primary_private_ip_address"
        elif key == "destinationPrimaryPrivateIpHostnameLabel":
            suggest = "destination_primary_private_ip_hostname_label"
        elif key == "destinationSubnetId":
            suggest = "destination_subnet_id"
        elif key == "sourceVnicId":
            suggest = "source_vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DrProtectionGroupMemberVnicMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DrProtectionGroupMemberVnicMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DrProtectionGroupMemberVnicMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_nsg_id_lists: Optional[Sequence[str]] = None,
                 destination_primary_private_ip_address: Optional[str] = None,
                 destination_primary_private_ip_hostname_label: Optional[str] = None,
                 destination_subnet_id: Optional[str] = None,
                 source_vnic_id: Optional[str] = None):
        """
        :param Sequence[str] destination_nsg_id_lists: (Updatable) A list of network security group (NSG) IDs in the destination region which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        :param str destination_primary_private_ip_address: (Updatable) The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        :param str destination_primary_private_ip_hostname_label: (Updatable) The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        :param str destination_subnet_id: (Updatable) The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        :param str source_vnic_id: (Updatable) The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        if destination_nsg_id_lists is not None:
            pulumi.set(__self__, "destination_nsg_id_lists", destination_nsg_id_lists)
        if destination_primary_private_ip_address is not None:
            pulumi.set(__self__, "destination_primary_private_ip_address", destination_primary_private_ip_address)
        if destination_primary_private_ip_hostname_label is not None:
            pulumi.set(__self__, "destination_primary_private_ip_hostname_label", destination_primary_private_ip_hostname_label)
        if destination_subnet_id is not None:
            pulumi.set(__self__, "destination_subnet_id", destination_subnet_id)
        if source_vnic_id is not None:
            pulumi.set(__self__, "source_vnic_id", source_vnic_id)

    @property
    @pulumi.getter(name="destinationNsgIdLists")
    def destination_nsg_id_lists(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of network security group (NSG) IDs in the destination region which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        """
        return pulumi.get(self, "destination_nsg_id_lists")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpAddress")
    def destination_primary_private_ip_address(self) -> Optional[str]:
        """
        (Updatable) The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "destination_primary_private_ip_address")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpHostnameLabel")
    def destination_primary_private_ip_hostname_label(self) -> Optional[str]:
        """
        (Updatable) The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        """
        return pulumi.get(self, "destination_primary_private_ip_hostname_label")

    @property
    @pulumi.getter(name="destinationSubnetId")
    def destination_subnet_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_subnet_id")

    @property
    @pulumi.getter(name="sourceVnicId")
    def source_vnic_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "source_vnic_id")


@pulumi.output_type
class GetDrPlanExecutionExecutionOptionResult(dict):
    def __init__(__self__, *,
                 are_prechecks_enabled: bool,
                 are_warnings_ignored: bool,
                 plan_execution_type: str):
        """
        :param bool are_prechecks_enabled: A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        :param bool are_warnings_ignored: A flag indicating whether warnings should be ignored during the plan execution.  Example: `false`
        :param str plan_execution_type: The type of the DR Plan executed.
        """
        pulumi.set(__self__, "are_prechecks_enabled", are_prechecks_enabled)
        pulumi.set(__self__, "are_warnings_ignored", are_warnings_ignored)
        pulumi.set(__self__, "plan_execution_type", plan_execution_type)

    @property
    @pulumi.getter(name="arePrechecksEnabled")
    def are_prechecks_enabled(self) -> bool:
        """
        A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_prechecks_enabled")

    @property
    @pulumi.getter(name="areWarningsIgnored")
    def are_warnings_ignored(self) -> bool:
        """
        A flag indicating whether warnings should be ignored during the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_warnings_ignored")

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> str:
        """
        The type of the DR Plan executed.
        """
        return pulumi.get(self, "plan_execution_type")


@pulumi.output_type
class GetDrPlanExecutionGroupExecutionResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 execution_duration_in_sec: int,
                 group_id: str,
                 status: str,
                 status_details: str,
                 step_executions: Sequence['outputs.GetDrPlanExecutionGroupExecutionStepExecutionResult'],
                 time_ended: str,
                 time_started: str,
                 type: str):
        """
        :param str display_name: The display name of the step.  Example: `DATABASE_SWITCHOVER`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param Sequence['GetDrPlanExecutionGroupExecutionStepExecutionArgs'] step_executions: A list of details of each step executed in this group.
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        pulumi.set(__self__, "step_executions", step_executions)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the step.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepExecutions")
    def step_executions(self) -> Sequence['outputs.GetDrPlanExecutionGroupExecutionStepExecutionResult']:
        """
        A list of details of each step executed in this group.
        """
        return pulumi.get(self, "step_executions")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlanExecutionGroupExecutionStepExecutionResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 execution_duration_in_sec: int,
                 group_id: str,
                 log_locations: Sequence['outputs.GetDrPlanExecutionGroupExecutionStepExecutionLogLocationResult'],
                 status: str,
                 status_details: str,
                 step_id: str,
                 time_ended: str,
                 time_started: str,
                 type: str):
        """
        :param str display_name: The display name of the step.  Example: `DATABASE_SWITCHOVER`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param Sequence['GetDrPlanExecutionGroupExecutionStepExecutionLogLocationArgs'] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param str step_id: The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "log_locations", log_locations)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        pulumi.set(__self__, "step_id", step_id)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the step.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrPlanExecutionGroupExecutionStepExecutionLogLocationResult']:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlanExecutionGroupExecutionStepExecutionLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlanExecutionLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 dr_protection_group_id: str,
                 execution_duration_in_sec: int,
                 execution_options: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemExecutionOptionResult'],
                 freeform_tags: Mapping[str, Any],
                 group_executions: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionResult'],
                 id: str,
                 life_cycle_details: str,
                 log_locations: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemLogLocationResult'],
                 peer_dr_protection_group_id: str,
                 peer_region: str,
                 plan_execution_type: str,
                 plan_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_ended: str,
                 time_started: str,
                 time_updated: str):
        """
        :param str compartment_id: The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param str dr_protection_group_id: The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param Sequence['GetDrPlanExecutionsDrPlanExecutionCollectionItemExecutionOptionArgs'] execution_options: The options for a plan execution.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param Sequence['GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionArgs'] group_executions: A list of groups executed in this DR Plan Execution.
        :param str id: The OCID of the DR Plan Execution.  Example: `ocid1.drplanexecution.oc1.iad.&lt;unique_id&gt;`
        :param str life_cycle_details: A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        :param Sequence['GetDrPlanExecutionsDrPlanExecutionCollectionItemLogLocationArgs'] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param str peer_dr_protection_group_id: The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param str plan_execution_type: The type of the DR Plan executed.
        :param str plan_id: The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;`
        :param str state: A filter to return only DR Plan Executions that match the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_updated: The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        pulumi.set(__self__, "execution_options", execution_options)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "group_executions", group_executions)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        pulumi.set(__self__, "log_locations", log_locations)
        pulumi.set(__self__, "peer_dr_protection_group_id", peer_dr_protection_group_id)
        pulumi.set(__self__, "peer_region", peer_region)
        pulumi.set(__self__, "plan_execution_type", plan_execution_type)
        pulumi.set(__self__, "plan_id", plan_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing this DR Plan Execution.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemExecutionOptionResult']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionResult']:
        """
        A list of groups executed in this DR Plan Execution.
        """
        return pulumi.get(self, "group_executions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the DR Plan Execution.  Example: `ocid1.drplanexecution.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> str:
        """
        A message describing the DR Plan Execution's current state in more detail.  Example: `The DR Plan Execution [Execution - EBS Switchover PHX to IAD] is currently in progress`
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemLogLocationResult']:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> str:
        """
        The OCID of peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> str:
        """
        The type of the DR Plan executed.
        """
        return pulumi.get(self, "plan_execution_type")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The OCID of the DR Plan.  Example: `ocid1.drplan.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only DR Plan Executions that match the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time at which DR Plan Execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time at which DR Plan Execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemExecutionOptionResult(dict):
    def __init__(__self__, *,
                 are_prechecks_enabled: bool,
                 are_warnings_ignored: bool,
                 plan_execution_type: str):
        """
        :param bool are_prechecks_enabled: A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        :param bool are_warnings_ignored: A flag indicating whether warnings should be ignored during the plan execution.  Example: `false`
        :param str plan_execution_type: The type of the DR Plan executed.
        """
        pulumi.set(__self__, "are_prechecks_enabled", are_prechecks_enabled)
        pulumi.set(__self__, "are_warnings_ignored", are_warnings_ignored)
        pulumi.set(__self__, "plan_execution_type", plan_execution_type)

    @property
    @pulumi.getter(name="arePrechecksEnabled")
    def are_prechecks_enabled(self) -> bool:
        """
        A flag indicating whether prechecks should be executed before the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_prechecks_enabled")

    @property
    @pulumi.getter(name="areWarningsIgnored")
    def are_warnings_ignored(self) -> bool:
        """
        A flag indicating whether warnings should be ignored during the plan execution.  Example: `false`
        """
        return pulumi.get(self, "are_warnings_ignored")

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> str:
        """
        The type of the DR Plan executed.
        """
        return pulumi.get(self, "plan_execution_type")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 execution_duration_in_sec: int,
                 group_id: str,
                 status: str,
                 status_details: str,
                 step_executions: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionResult'],
                 time_ended: str,
                 time_started: str,
                 type: str):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param Sequence['GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionArgs'] step_executions: A list of details of each step executed in this group.
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        pulumi.set(__self__, "step_executions", step_executions)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepExecutions")
    def step_executions(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionResult']:
        """
        A list of details of each step executed in this group.
        """
        return pulumi.get(self, "step_executions")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 execution_duration_in_sec: int,
                 group_id: str,
                 log_locations: Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionLogLocationResult'],
                 status: str,
                 status_details: str,
                 step_id: str,
                 time_ended: str,
                 time_started: str,
                 type: str):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param int execution_duration_in_sec: The total duration in seconds taken to complete step execution.  Example: `35`
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param Sequence['GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionLogLocationArgs'] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param str status: The status of the step execution.
        :param str status_details: Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        :param str step_id: The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param str time_ended: The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_started: The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The plan group type.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "log_locations", log_locations)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_details", status_details)
        pulumi.set(__self__, "step_id", step_id)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionLogLocationResult']:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the step execution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> str:
        """
        Additional details about the step execution status.  Example: `This step failed to complete due to a timeout`
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        The unique id of this step. Must not be modified by user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "step_id")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR Plan Execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR Plan Execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The plan group type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemGroupExecutionStepExecutionLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlanExecutionsDrPlanExecutionCollectionItemLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlanExecutionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDrPlanPlanGroupResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 id: str,
                 steps: Sequence['outputs.GetDrPlanPlanGroupStepResult'],
                 type: str):
        """
        :param str display_name: The display name of this DR Plan Group.  Example: `DATABASE_SWITCHOVER`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param Sequence['GetDrPlanPlanGroupStepArgs'] steps: The list of steps in this plan group.
        :param str type: The type of this DR Plan.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of this DR Plan Group.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetDrPlanPlanGroupStepResult']:
        """
        The list of steps in this plan group.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this DR Plan.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlanPlanGroupStepResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 error_mode: str,
                 group_id: str,
                 id: str,
                 is_enabled: bool,
                 member_id: str,
                 timeout: int,
                 type: str,
                 user_defined_steps: Sequence['outputs.GetDrPlanPlanGroupStepUserDefinedStepResult']):
        """
        :param str display_name: The display name of this DR Plan Group.  Example: `DATABASE_SWITCHOVER`
        :param str error_mode: The error mode for this step.
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param bool is_enabled: A flag indicating whether this step should be enabled for execution.  Example: `true`
        :param str member_id: The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        :param int timeout: The timeout in seconds for executing this step.  Example: `600`
        :param str type: The type of this DR Plan.
        :param Sequence['GetDrPlanPlanGroupStepUserDefinedStepArgs'] user_defined_steps: The details for a user-defined step in a DR Plan.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "error_mode", error_mode)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_defined_steps", user_defined_steps)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of this DR Plan Group.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="errorMode")
    def error_mode(self) -> str:
        """
        The error mode for this step.
        """
        return pulumi.get(self, "error_mode")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        A flag indicating whether this step should be enabled for execution.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> str:
        """
        The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        The timeout in seconds for executing this step.  Example: `600`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this DR Plan.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userDefinedSteps")
    def user_defined_steps(self) -> Sequence['outputs.GetDrPlanPlanGroupStepUserDefinedStepResult']:
        """
        The details for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "user_defined_steps")


@pulumi.output_type
class GetDrPlanPlanGroupStepUserDefinedStepResult(dict):
    def __init__(__self__, *,
                 function_id: str,
                 function_region: str,
                 object_storage_script_locations: Sequence['outputs.GetDrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult'],
                 request_body: str,
                 run_as_user: str,
                 run_on_instance_id: str,
                 run_on_instance_region: str,
                 script_command: str,
                 step_type: str):
        """
        :param str function_id: The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        :param str function_region: The region in which the function is deployed.  Example: `us-ashburn-1`
        :param Sequence['GetDrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs'] object_storage_script_locations: Information about an Object Storage script location for a user-defined step in a DR Plan.
        :param str request_body: The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        :param str run_as_user: The userid on the instance to be used for executing the script or command.  Example: `opc`
        :param str run_on_instance_id: The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str run_on_instance_region: The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        :param str script_command: The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        :param str step_type: The type of the step.
        """
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "function_region", function_region)
        pulumi.set(__self__, "object_storage_script_locations", object_storage_script_locations)
        pulumi.set(__self__, "request_body", request_body)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "run_on_instance_id", run_on_instance_id)
        pulumi.set(__self__, "run_on_instance_region", run_on_instance_region)
        pulumi.set(__self__, "script_command", script_command)
        pulumi.set(__self__, "step_type", step_type)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> str:
        """
        The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionRegion")
    def function_region(self) -> str:
        """
        The region in which the function is deployed.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "function_region")

    @property
    @pulumi.getter(name="objectStorageScriptLocations")
    def object_storage_script_locations(self) -> Sequence['outputs.GetDrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult']:
        """
        Information about an Object Storage script location for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "object_storage_script_locations")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> str:
        """
        The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> str:
        """
        The userid on the instance to be used for executing the script or command.  Example: `opc`
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="runOnInstanceId")
    def run_on_instance_id(self) -> str:
        """
        The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "run_on_instance_id")

    @property
    @pulumi.getter(name="runOnInstanceRegion")
    def run_on_instance_region(self) -> str:
        """
        The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "run_on_instance_region")

    @property
    @pulumi.getter(name="scriptCommand")
    def script_command(self) -> str:
        """
        The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        """
        return pulumi.get(self, "script_command")

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> str:
        """
        The type of the step.
        """
        return pulumi.get(self, "step_type")


@pulumi.output_type
class GetDrPlanPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlansDrPlanCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDrPlansDrPlanCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDrPlansDrPlanCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 dr_protection_group_id: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 life_cycle_details: str,
                 peer_dr_protection_group_id: str,
                 peer_region: str,
                 plan_groups: Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 type: str):
        """
        :param str compartment_id: The OCID of the compartment containing the DR Plan.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param str dr_protection_group_id: The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param str life_cycle_details: A message describing the DR Plan's current state in more detail.
        :param str peer_dr_protection_group_id: The OCID of the peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `us-phoenix-1`
        :param Sequence['GetDrPlansDrPlanCollectionItemPlanGroupArgs'] plan_groups: The list of groups in this DR Plan.
        :param str state: A filter to return only DR Plans that match the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the DR Plan was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_updated: The date and time the DR Plan was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str type: The type of this DR Plan.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        pulumi.set(__self__, "peer_dr_protection_group_id", peer_dr_protection_group_id)
        pulumi.set(__self__, "peer_region", peer_region)
        pulumi.set(__self__, "plan_groups", plan_groups)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the DR Plan.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR Protection Group. Mandatory query param.  Example: `ocid1.drprotectiongroup.oc1.phx.exampleocid`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> str:
        """
        A message describing the DR Plan's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> str:
        """
        The OCID of the peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer (remote) DR Protection Group associated with this plan's DR Protection Group.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="planGroups")
    def plan_groups(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupResult']:
        """
        The list of groups in this DR Plan.
        """
        return pulumi.get(self, "plan_groups")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only DR Plans that match the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the DR Plan was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the DR Plan was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this DR Plan.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlansDrPlanCollectionItemPlanGroupResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 id: str,
                 steps: Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepResult'],
                 type: str):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param Sequence['GetDrPlansDrPlanCollectionItemPlanGroupStepArgs'] steps: The list of steps in this plan group.
        :param str type: The type of this DR Plan.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepResult']:
        """
        The list of steps in this plan group.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this DR Plan.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDrPlansDrPlanCollectionItemPlanGroupStepResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 error_mode: str,
                 group_id: str,
                 id: str,
                 is_enabled: bool,
                 member_id: str,
                 timeout: int,
                 type: str,
                 user_defined_steps: Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepResult']):
        """
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param str error_mode: The error mode for this step.
        :param str group_id: The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        :param str id: The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        :param bool is_enabled: A flag indicating whether this step should be enabled for execution.  Example: `true`
        :param str member_id: The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        :param int timeout: The timeout in seconds for executing this step.  Example: `600`
        :param str type: The type of this DR Plan.
        :param Sequence['GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepArgs'] user_defined_steps: The details for a user-defined step in a DR Plan.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "error_mode", error_mode)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_defined_steps", user_defined_steps)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="errorMode")
    def error_mode(self) -> str:
        """
        The error mode for this step.
        """
        return pulumi.get(self, "error_mode")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The unique id of the group to which this step belongs. Must not be modified by user.  Example: `sgid1.group..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of this step. Must not be modified by the user.  Example: `sgid1.step..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        A flag indicating whether this step should be enabled for execution.  Example: `true`
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> str:
        """
        The OCID of the member associated with this step.  Example: `ocid1.database.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        The timeout in seconds for executing this step.  Example: `600`
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this DR Plan.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userDefinedSteps")
    def user_defined_steps(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepResult']:
        """
        The details for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "user_defined_steps")


@pulumi.output_type
class GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepResult(dict):
    def __init__(__self__, *,
                 function_id: str,
                 function_region: str,
                 object_storage_script_locations: Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult'],
                 request_body: str,
                 run_as_user: str,
                 run_on_instance_id: str,
                 run_on_instance_region: str,
                 script_command: str,
                 step_type: str):
        """
        :param str function_id: The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        :param str function_region: The region in which the function is deployed.  Example: `us-ashburn-1`
        :param Sequence['GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepObjectStorageScriptLocationArgs'] object_storage_script_locations: Information about an Object Storage script location for a user-defined step in a DR Plan.
        :param str request_body: The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        :param str run_as_user: The userid on the instance to be used for executing the script or command.  Example: `opc`
        :param str run_on_instance_id: The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str run_on_instance_region: The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        :param str script_command: The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        :param str step_type: The type of the step.
        """
        pulumi.set(__self__, "function_id", function_id)
        pulumi.set(__self__, "function_region", function_region)
        pulumi.set(__self__, "object_storage_script_locations", object_storage_script_locations)
        pulumi.set(__self__, "request_body", request_body)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "run_on_instance_id", run_on_instance_id)
        pulumi.set(__self__, "run_on_instance_region", run_on_instance_region)
        pulumi.set(__self__, "script_command", script_command)
        pulumi.set(__self__, "step_type", step_type)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> str:
        """
        The OCID of function to be invoked.  Example: `ocid1.fnfunc.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="functionRegion")
    def function_region(self) -> str:
        """
        The region in which the function is deployed.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "function_region")

    @property
    @pulumi.getter(name="objectStorageScriptLocations")
    def object_storage_script_locations(self) -> Sequence['outputs.GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult']:
        """
        Information about an Object Storage script location for a user-defined step in a DR Plan.
        """
        return pulumi.get(self, "object_storage_script_locations")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> str:
        """
        The request body for the function.  Example: `{ "FnParam1", "FnParam2" }`
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> str:
        """
        The userid on the instance to be used for executing the script or command.  Example: `opc`
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="runOnInstanceId")
    def run_on_instance_id(self) -> str:
        """
        The OCID of the instance where this script or command should be executed.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "run_on_instance_id")

    @property
    @pulumi.getter(name="runOnInstanceRegion")
    def run_on_instance_region(self) -> str:
        """
        The region of the instance where this script or command should be executed.  Example: `us-phoenix-1`
        """
        return pulumi.get(self, "run_on_instance_region")

    @property
    @pulumi.getter(name="scriptCommand")
    def script_command(self) -> str:
        """
        The script name and arguments.  Example: `/usr/bin/python3 /home/opc/scripts/my_app_script.py arg1 arg2 arg3`
        """
        return pulumi.get(self, "script_command")

    @property
    @pulumi.getter(name="stepType")
    def step_type(self) -> str:
        """
        The type of the step.
        """
        return pulumi.get(self, "step_type")


@pulumi.output_type
class GetDrPlansDrPlanCollectionItemPlanGroupStepUserDefinedStepObjectStorageScriptLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `custom_dr_scripts`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `validate_app_start.sh`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrPlansFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDrProtectionGroupAssociationResult(dict):
    def __init__(__self__, *,
                 peer_id: str,
                 peer_region: str,
                 role: str):
        """
        :param str peer_id: The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param str role: The role of the DR Protection Group.
        """
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "peer_region", peer_region)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> str:
        """
        The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the DR Protection Group.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetDrProtectionGroupLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrProtectionGroupMemberResult(dict):
    def __init__(__self__, *,
                 destination_capacity_reservation_id: str,
                 destination_compartment_id: str,
                 destination_dedicated_vm_host_id: str,
                 is_movable: bool,
                 is_retain_fault_domain: bool,
                 member_id: str,
                 member_type: str,
                 password_vault_secret_id: str,
                 vnic_mapping: Sequence['outputs.GetDrProtectionGroupMemberVnicMappingResult'],
                 vnic_mappings: Sequence['outputs.GetDrProtectionGroupMemberVnicMappingResult']):
        """
        :param str destination_capacity_reservation_id: The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        :param str destination_compartment_id: The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param str destination_dedicated_vm_host_id: The OCID of the dedicated VM Host for this compute instance in the destination region.  Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`
        :param bool is_movable: A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        :param bool is_retain_fault_domain: A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        :param str member_id: The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str member_type: The type of the member.
        :param str password_vault_secret_id: The ID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.exampleocid1`
        :param Sequence['GetDrProtectionGroupMemberVnicMappingArgs'] vnic_mapping: A list of compute instance VNIC mappings.
        :param Sequence['GetDrProtectionGroupMemberVnicMappingArgs'] vnic_mappings: A list of compute instance VNIC mappings.
        """
        pulumi.set(__self__, "destination_capacity_reservation_id", destination_capacity_reservation_id)
        pulumi.set(__self__, "destination_compartment_id", destination_compartment_id)
        pulumi.set(__self__, "destination_dedicated_vm_host_id", destination_dedicated_vm_host_id)
        pulumi.set(__self__, "is_movable", is_movable)
        pulumi.set(__self__, "is_retain_fault_domain", is_retain_fault_domain)
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "member_type", member_type)
        pulumi.set(__self__, "password_vault_secret_id", password_vault_secret_id)
        pulumi.set(__self__, "vnic_mapping", vnic_mapping)
        pulumi.set(__self__, "vnic_mappings", vnic_mappings)

    @property
    @pulumi.getter(name="destinationCapacityReservationId")
    def destination_capacity_reservation_id(self) -> str:
        """
        The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_capacity_reservation_id")

    @property
    @pulumi.getter(name="destinationCompartmentId")
    def destination_compartment_id(self) -> str:
        """
        The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_compartment_id")

    @property
    @pulumi.getter(name="destinationDedicatedVmHostId")
    def destination_dedicated_vm_host_id(self) -> str:
        """
        The OCID of the dedicated VM Host for this compute instance in the destination region.  Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_dedicated_vm_host_id")

    @property
    @pulumi.getter(name="isMovable")
    def is_movable(self) -> bool:
        """
        A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        """
        return pulumi.get(self, "is_movable")

    @property
    @pulumi.getter(name="isRetainFaultDomain")
    def is_retain_fault_domain(self) -> bool:
        """
        A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        """
        return pulumi.get(self, "is_retain_fault_domain")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> str:
        """
        The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> str:
        """
        The type of the member.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter(name="passwordVaultSecretId")
    def password_vault_secret_id(self) -> str:
        """
        The ID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.exampleocid1`
        """
        return pulumi.get(self, "password_vault_secret_id")

    @property
    @pulumi.getter(name="vnicMapping")
    def vnic_mapping(self) -> Sequence['outputs.GetDrProtectionGroupMemberVnicMappingResult']:
        """
        A list of compute instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mapping")

    @property
    @pulumi.getter(name="vnicMappings")
    def vnic_mappings(self) -> Sequence['outputs.GetDrProtectionGroupMemberVnicMappingResult']:
        """
        A list of compute instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mappings")


@pulumi.output_type
class GetDrProtectionGroupMemberVnicMappingResult(dict):
    def __init__(__self__, *,
                 destination_nsg_id_lists: Sequence[str],
                 destination_primary_private_ip_address: str,
                 destination_primary_private_ip_hostname_label: str,
                 destination_subnet_id: str,
                 source_vnic_id: str):
        """
        :param Sequence[str] destination_nsg_id_lists: A list of destination region's network security group (NSG) OCIDs which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        :param str destination_primary_private_ip_address: The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        :param str destination_primary_private_ip_hostname_label: The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        :param str destination_subnet_id: The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        :param str source_vnic_id: The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        pulumi.set(__self__, "destination_nsg_id_lists", destination_nsg_id_lists)
        pulumi.set(__self__, "destination_primary_private_ip_address", destination_primary_private_ip_address)
        pulumi.set(__self__, "destination_primary_private_ip_hostname_label", destination_primary_private_ip_hostname_label)
        pulumi.set(__self__, "destination_subnet_id", destination_subnet_id)
        pulumi.set(__self__, "source_vnic_id", source_vnic_id)

    @property
    @pulumi.getter(name="destinationNsgIdLists")
    def destination_nsg_id_lists(self) -> Sequence[str]:
        """
        A list of destination region's network security group (NSG) OCIDs which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        """
        return pulumi.get(self, "destination_nsg_id_lists")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpAddress")
    def destination_primary_private_ip_address(self) -> str:
        """
        The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "destination_primary_private_ip_address")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpHostnameLabel")
    def destination_primary_private_ip_hostname_label(self) -> str:
        """
        The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        """
        return pulumi.get(self, "destination_primary_private_ip_hostname_label")

    @property
    @pulumi.getter(name="destinationSubnetId")
    def destination_subnet_id(self) -> str:
        """
        The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_subnet_id")

    @property
    @pulumi.getter(name="sourceVnicId")
    def source_vnic_id(self) -> str:
        """
        The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "source_vnic_id")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionItemResult(dict):
    def __init__(__self__, *,
                 associations: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemAssociationResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 disassociate_trigger: int,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 life_cycle_details: str,
                 log_locations: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemLogLocationResult'],
                 members: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberResult'],
                 peer_id: str,
                 peer_region: str,
                 role: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID (OCID) of the compartment in which to list resources.  Example: `ocid1.compartment.oc1..exampleocid1`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param str id: The OCID of the DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        :param str life_cycle_details: A message describing the DR Protection Group's current state in more detail.
        :param Sequence['GetDrProtectionGroupsDrProtectionGroupCollectionItemLogLocationArgs'] log_locations: Information about an Object Storage log location for a DR Protection Group.
        :param Sequence['GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberArgs'] members: A list of DR Protection Group members.
        :param str peer_id: The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param str role: The DR Protection Group Role.
        :param str state: A filter to return only DR Protection Groups that match the given lifecycleState.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The date and time the DR Protection Group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        :param str time_updated: The date and time the DR Protection Group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        pulumi.set(__self__, "associations", associations)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "disassociate_trigger", disassociate_trigger)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        pulumi.set(__self__, "log_locations", log_locations)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "peer_region", peer_region)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemAssociationResult']:
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID (OCID) of the compartment in which to list resources.  Example: `ocid1.compartment.oc1..exampleocid1`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="disassociateTrigger")
    def disassociate_trigger(self) -> int:
        return pulumi.get(self, "disassociate_trigger")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.  Example: `MY UNIQUE DISPLAY NAME`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> str:
        """
        A message describing the DR Protection Group's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemLogLocationResult']:
        """
        Information about an Object Storage log location for a DR Protection Group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberResult']:
        """
        A list of DR Protection Group members.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> str:
        """
        The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The DR Protection Group Role.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only DR Protection Groups that match the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the DR Protection Group was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the DR Protection Group was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionItemAssociationResult(dict):
    def __init__(__self__, *,
                 peer_id: str,
                 peer_region: str,
                 role: str):
        """
        :param str peer_id: The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        :param str peer_region: The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        :param str role: The DR Protection Group Role.
        """
        pulumi.set(__self__, "peer_id", peer_id)
        pulumi.set(__self__, "peer_region", peer_region)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> str:
        """
        The OCID of the peer (remote) DR Protection Group.  Example: `ocid1.drprotectiongroup.oc1.iad.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer (remote) DR Protection Group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The DR Protection Group Role.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionItemLogLocationResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        :param str namespace: The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        :param str object: The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The bucket name inside the Object Storage namespace.  Example: `operation_logs`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in Object Storage (Note - this is usually the tenancy name).  Example: `myocitenancy`
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The object name inside the Object Storage bucket.  Example: `switchover_plan_executions`
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberResult(dict):
    def __init__(__self__, *,
                 destination_capacity_reservation_id: str,
                 destination_compartment_id: str,
                 destination_dedicated_vm_host_id: str,
                 is_movable: bool,
                 is_retain_fault_domain: bool,
                 member_id: str,
                 member_type: str,
                 password_vault_secret_id: str,
                 vnic_mapping: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult'],
                 vnic_mappings: Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult']):
        """
        :param str destination_capacity_reservation_id: The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        :param str destination_compartment_id: The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        :param str destination_dedicated_vm_host_id: The OCID of the dedicated VM Host for this compute instance in the destination region.  Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`
        :param bool is_movable: A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        :param bool is_retain_fault_domain: A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        :param str member_id: The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        :param str member_type: The type of the member.
        :param str password_vault_secret_id: The ID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.exampleocid1`
        :param Sequence['GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingArgs'] vnic_mapping: A list of compute instance VNIC mappings.
        :param Sequence['GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingArgs'] vnic_mappings: A list of compute instance VNIC mappings.
        """
        pulumi.set(__self__, "destination_capacity_reservation_id", destination_capacity_reservation_id)
        pulumi.set(__self__, "destination_compartment_id", destination_compartment_id)
        pulumi.set(__self__, "destination_dedicated_vm_host_id", destination_dedicated_vm_host_id)
        pulumi.set(__self__, "is_movable", is_movable)
        pulumi.set(__self__, "is_retain_fault_domain", is_retain_fault_domain)
        pulumi.set(__self__, "member_id", member_id)
        pulumi.set(__self__, "member_type", member_type)
        pulumi.set(__self__, "password_vault_secret_id", password_vault_secret_id)
        pulumi.set(__self__, "vnic_mapping", vnic_mapping)
        pulumi.set(__self__, "vnic_mappings", vnic_mappings)

    @property
    @pulumi.getter(name="destinationCapacityReservationId")
    def destination_capacity_reservation_id(self) -> str:
        """
        The OCID of the capacity reservation in the destination region using which this compute instance should be launched.  Example: `ocid1.capacityreservation.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_capacity_reservation_id")

    @property
    @pulumi.getter(name="destinationCompartmentId")
    def destination_compartment_id(self) -> str:
        """
        The OCID of the compartment for this compute instance in the destination region.  Example: `ocid1.compartment.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_compartment_id")

    @property
    @pulumi.getter(name="destinationDedicatedVmHostId")
    def destination_dedicated_vm_host_id(self) -> str:
        """
        The OCID of the dedicated VM Host for this compute instance in the destination region.  Example: `ocid1.dedicatedvmhost.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_dedicated_vm_host_id")

    @property
    @pulumi.getter(name="isMovable")
    def is_movable(self) -> bool:
        """
        A flag indicating if this compute instance should be moved during DR operations.  Example: `false`
        """
        return pulumi.get(self, "is_movable")

    @property
    @pulumi.getter(name="isRetainFaultDomain")
    def is_retain_fault_domain(self) -> bool:
        """
        A flag indicating if this compute instance should be moved to the same fault domain.  Compute instance launch will fail if this flag is set to true and capacity is not available in that specific fault domain in the destination region.  Example: `false`
        """
        return pulumi.get(self, "is_retain_fault_domain")

    @property
    @pulumi.getter(name="memberId")
    def member_id(self) -> str:
        """
        The OCID of the member.  Example: `ocid1.instance.oc1.phx.&lt;unique_id&gt;`
        """
        return pulumi.get(self, "member_id")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> str:
        """
        The type of the member.
        """
        return pulumi.get(self, "member_type")

    @property
    @pulumi.getter(name="passwordVaultSecretId")
    def password_vault_secret_id(self) -> str:
        """
        The ID of the vault secret where the database password is stored.  Example: `ocid1.vaultsecret.oc1.phx.exampleocid1`
        """
        return pulumi.get(self, "password_vault_secret_id")

    @property
    @pulumi.getter(name="vnicMapping")
    def vnic_mapping(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult']:
        """
        A list of compute instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mapping")

    @property
    @pulumi.getter(name="vnicMappings")
    def vnic_mappings(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult']:
        """
        A list of compute instance VNIC mappings.
        """
        return pulumi.get(self, "vnic_mappings")


@pulumi.output_type
class GetDrProtectionGroupsDrProtectionGroupCollectionItemMemberVnicMappingResult(dict):
    def __init__(__self__, *,
                 destination_nsg_id_lists: Sequence[str],
                 destination_primary_private_ip_address: str,
                 destination_primary_private_ip_hostname_label: str,
                 destination_subnet_id: str,
                 source_vnic_id: str):
        """
        :param Sequence[str] destination_nsg_id_lists: A list of destination region's network security group (NSG) OCIDs which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        :param str destination_primary_private_ip_address: The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        :param str destination_primary_private_ip_hostname_label: The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        :param str destination_subnet_id: The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        :param str source_vnic_id: The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        pulumi.set(__self__, "destination_nsg_id_lists", destination_nsg_id_lists)
        pulumi.set(__self__, "destination_primary_private_ip_address", destination_primary_private_ip_address)
        pulumi.set(__self__, "destination_primary_private_ip_hostname_label", destination_primary_private_ip_hostname_label)
        pulumi.set(__self__, "destination_subnet_id", destination_subnet_id)
        pulumi.set(__self__, "source_vnic_id", source_vnic_id)

    @property
    @pulumi.getter(name="destinationNsgIdLists")
    def destination_nsg_id_lists(self) -> Sequence[str]:
        """
        A list of destination region's network security group (NSG) OCIDs which this VNIC should use.  Example: `[ ocid1.networksecuritygroup.oc1..&lt;unique_id&gt;, ocid1.networksecuritygroup.oc1..&lt;unique_id&gt; ]`
        """
        return pulumi.get(self, "destination_nsg_id_lists")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpAddress")
    def destination_primary_private_ip_address(self) -> str:
        """
        The primary private IP address to assign. This address must belong to the destination subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "destination_primary_private_ip_address")

    @property
    @pulumi.getter(name="destinationPrimaryPrivateIpHostnameLabel")
    def destination_primary_private_ip_hostname_label(self) -> str:
        """
        The hostname to assign for this primary private IP. The value is the hostname portion of the private IP's fully qualified domain name (FQDN)  (for example, bminstance1 in FQDN bminstance1.subnet123.vcn1.oraclevcn.com).  Example: `bminstance1`
        """
        return pulumi.get(self, "destination_primary_private_ip_hostname_label")

    @property
    @pulumi.getter(name="destinationSubnetId")
    def destination_subnet_id(self) -> str:
        """
        The OCID of the destination (remote) subnet to which this VNIC should connect.  Example: `ocid1.subnet.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "destination_subnet_id")

    @property
    @pulumi.getter(name="sourceVnicId")
    def source_vnic_id(self) -> str:
        """
        The OCID of the VNIC.  Example: `ocid1.vnic.oc1..&lt;unique_id&gt;`
        """
        return pulumi.get(self, "source_vnic_id")


@pulumi.output_type
class GetDrProtectionGroupsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


