#pragma once

#include "dma.h"
#include "memory_mgr.h"

namespace akida {

struct MultiPassMemory {
  // address of one 32bit word needed by multi pass program to write output of
  // dummy descriptors
  dma::addr dummy_output_addr;
  // address of multi pass program descriptors
  dma::addr descriptors_addr;
  // address of multi pass learning descriptor;
  dma::addr learn_descriptor_addr;

  void alloc_memory(MemoryMgr* memory_mgr, const uint8_t* program);
  void free_memory(MemoryMgr* memory_mgr);
  void update_learn_descriptor_addr(dma::addr learn_descriptor_address);
};

}  // namespace akida
