/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.measures.continuous.InfoMeasureCalculatorContinuous;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ArrayFileReader;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.EmpiricalNullDistributionComputer;
import infodynamics.utils.MatrixUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class AutoAnalyser
extends JFrame
implements ActionListener,
DocumentListener,
MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String CALC_TYPE_DISCRETE = "Discrete";
    public static final String CALC_TYPE_BINNED = "Binned";
    protected String[] calcTypes;
    protected String[] unitsForEachCalc;
    public static final String CALC_TYPE_GAUSSIAN = "Gaussian";
    public static final String CALC_TYPE_KRASKOV = "Kraskov (KSG)";
    public static final String CALC_TYPE_KERNEL = "Kernel";
    public static final String CALC_TYPE_KOZ_LEO = "Kozachenko-Leonenko";
    protected static final String DISCRETE_PROPNAME_BASE = "base";
    protected String[] discreteProperties;
    protected String[] discretePropertyDefaultValues;
    protected String[] discretePropertyDescriptions;
    protected String[] commonContPropertyNames;
    protected String[] commonContPropertiesFieldNames;
    protected String[] commonContPropertyDescriptions;
    protected int numVariables = 1;
    protected String[] variableColNumLabels = null;
    protected boolean[] disableVariableColTextFieldsForAllCombos = null;
    protected int indentsForAllCombos = 1;
    protected Class calcClass = null;
    protected Class abstractContinuousClass = null;
    protected Class discreteClass = null;
    protected String measureAcronym = null;
    protected String variableRelationshipFormatString = null;
    protected JButton computeButton;
    protected JButton openDataButton;
    protected File dataFile = null;
    protected JComboBox<String> calcTypeComboBox;
    protected JTextField dataFileTextField;
    protected JLabel dataFileDescriptorLabel;
    protected double[][] data = null;
    protected int[][] dataDiscrete = null;
    protected int dataRows = 0;
    protected int dataColumns = 0;
    protected boolean useAllCombosCheckBox = false;
    protected String wordForCombinations = null;
    protected JCheckBox allCombosCheckBox;
    protected JTextField[] variableColTextFields;
    protected boolean useStatSigCheckBox = false;
    protected JCheckBox statSigCheckBox;
    protected JCheckBox statSigAnalyticCheckBox;
    protected int numPermutationsToCheck = 100;
    protected JTable propertiesTable;
    protected PropertiesTableModel propertiesTableModel;
    protected Vector<String> propertyNames;
    protected Vector<String> propertyFieldNames;
    protected Vector<String> propertyDescriptions;
    protected HashMap<String, String> propertyValues;
    protected JCheckBox computeResultCheckBox;
    protected JLabel resultsLabel;
    protected JTextArea javaCodeTextArea;
    protected JTextArea pythonCodeTextArea;
    protected JTextArea matlabCodeTextArea;
    protected String codeDefaultText = "    ... Awaiting new parameter selection (press compute) ...";
    protected String buttonTextCodeAndCompute = "Generate code and Compute";
    protected String buttonTextCodeOnly = "Generate code";
    protected String appletTitle;
    protected String pathToAutoAnalyserDir = "";
    protected String jidtFolder = "";

    public AutoAnalyser() {
        this(System.getProperty("user.dir") + "/");
    }

    public AutoAnalyser(String string) {
        this.pathToAutoAnalyserDir = string;
        System.out.println("Working directory is: " + System.getProperty("user.dir"));
        System.out.println("Starting with path to AutoAnalyser folder: " + string);
        this.jidtFolder = string + "../../";
        this.makeSpecificInitialisations();
        ImageIcon imageIcon = new ImageIcon(this.jidtFolder + "JIDT-logo.png");
        if (imageIcon.getImageLoadStatus() != 8) {
            imageIcon = new ImageIcon(this.jidtFolder + "web/JIDT-logo.png");
        }
        this.setIconImage(imageIcon.getImage());
        Image image = new ImageIcon(string + "JIDT-logo-watermark.png").getImage();
        this.setDefaultCloseOperation(3);
        this.setSize(1100, 670);
        this.setTitle(this.appletTitle);
        this.setLocationRelativeTo(null);
        JLabel jLabel = new JLabel("Calculator Type:");
        jLabel.setToolTipText("Select estimator type. \"Discrete\" is for discrete or pre-binned data; all others for continuous data.");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.calcTypeComboBox = new JComboBox<String>(this.calcTypes);
        this.calcTypeComboBox.setSelectedIndex(3);
        this.calcTypeComboBox.addActionListener(this);
        JLabel jLabel2 = new JLabel("Data file:");
        jLabel2.setToolTipText("Must be a text file of samples or time-series values with time/sample increasing in rows, and variables along columns");
        this.dataFileTextField = new JTextField(30);
        this.dataFileTextField.setEnabled(false);
        this.dataFileTextField.addMouseListener(this);
        this.openDataButton = new JButton("Select");
        this.openDataButton.addActionListener(this);
        this.dataFileDescriptorLabel = new JLabel("No data file selected yet ...");
        this.dataFileDescriptorLabel.setHorizontalAlignment(4);
        this.dataFileDescriptorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.allCombosCheckBox = new JCheckBox("All " + this.wordForCombinations + "?");
        this.allCombosCheckBox.setToolTipText("Compute for all column " + this.wordForCombinations + "?");
        this.allCombosCheckBox.addChangeListener(this);
        this.variableColTextFields = new JTextField[this.numVariables];
        JLabel[] jLabelArray = new JLabel[this.numVariables];
        for (int i = 0; i < this.numVariables; ++i) {
            jLabelArray[i] = new JLabel(this.variableColNumLabels[i] + " column:");
            jLabelArray[i].setToolTipText("First column is 0.");
            jLabelArray[i].setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.variableColTextFields[i] = new JTextField(5);
            this.variableColTextFields[i].setEnabled(true);
            this.variableColTextFields[i].setText(Integer.toString(i));
            this.variableColTextFields[i].getDocument().addDocumentListener(this);
        }
        this.statSigCheckBox = new JCheckBox("Add stat. signif.?");
        this.statSigCheckBox.setToolTipText("Compute the null surrogate distribution under the null hypothesis that source and target are not related?");
        this.statSigCheckBox.addChangeListener(this);
        this.statSigAnalyticCheckBox = new JCheckBox("analytically?");
        this.statSigAnalyticCheckBox.setToolTipText("Compute the null surrogate distribution analytically?");
        this.statSigAnalyticCheckBox.addChangeListener(this);
        this.statSigAnalyticCheckBox.setEnabled(false);
        JLabel jLabel3 = new JLabel(" ");
        jLabel3.setSize(10, 10);
        JLabel jLabel4 = new JLabel(" ");
        jLabel4.setSize(10, 10);
        JLabel jLabel5 = new JLabel(" ");
        jLabel5.setSize(10, 10);
        this.putCalcPropertiesInTable();
        this.propertiesTableModel = new PropertiesTableModel();
        this.propertiesTable = new TableWithToolTip(this.propertiesTableModel);
        this.propertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        Font font = this.propertiesTable.getTableHeader().getFont();
        this.propertiesTable.getTableHeader().setFont(font.deriveFont(1));
        TableColumn tableColumn = this.propertiesTable.getColumn("Property value");
        tableColumn.setMinWidth(130);
        tableColumn.setMaxWidth(130);
        JScrollPane jScrollPane = new JScrollPane(this.propertiesTable);
        Dimension dimension = this.propertiesTable.getPreferredSize();
        int n = this.propertiesTable.getRowHeight();
        jScrollPane.setPreferredSize(new Dimension(dimension.width, n * 17 + 6));
        jScrollPane.setMinimumSize(new Dimension(dimension.width, n * 17 + 6));
        System.out.println("Row height was " + n);
        this.computeResultCheckBox = new JCheckBox("Compute result?");
        this.computeResultCheckBox.setToolTipText("Compute result or only generate code?");
        this.computeResultCheckBox.setSelected(true);
        this.computeResultCheckBox.addChangeListener(this);
        this.computeButton = new JButton(this.buttonTextCodeAndCompute);
        this.computeButton.addActionListener(this);
        this.resultsLabel = new JLabel(" ");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Generated code"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.javaCodeTextArea = new TextAreaWithImage(this.codeDefaultText, image);
        this.javaCodeTextArea.setOpaque(false);
        this.javaCodeTextArea.setEditable(false);
        this.javaCodeTextArea.setBorder(BorderFactory.createCompoundBorder(this.javaCodeTextArea.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JScrollPane jScrollPane2 = new JScrollPane(this.javaCodeTextArea);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        int n2 = 560;
        int n3 = 480;
        Dimension dimension2 = new Dimension(n2, n3);
        jScrollPane2.setPreferredSize(dimension2);
        jScrollPane2.setMinimumSize(dimension2);
        jScrollPane2.setMaximumSize(dimension2);
        jTabbedPane.addTab("Java", jScrollPane2);
        this.pythonCodeTextArea = new TextAreaWithImage(this.codeDefaultText, image);
        this.pythonCodeTextArea.setOpaque(false);
        this.pythonCodeTextArea.setEditable(false);
        this.pythonCodeTextArea.setBorder(BorderFactory.createCompoundBorder(this.pythonCodeTextArea.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JScrollPane jScrollPane3 = new JScrollPane(this.pythonCodeTextArea);
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setHorizontalScrollBarPolicy(30);
        jScrollPane3.setPreferredSize(dimension2);
        jScrollPane3.setMinimumSize(dimension2);
        jScrollPane3.setMaximumSize(dimension2);
        jTabbedPane.addTab("Python", jScrollPane3);
        this.matlabCodeTextArea = new TextAreaWithImage(this.codeDefaultText, image);
        this.matlabCodeTextArea.setOpaque(false);
        this.matlabCodeTextArea.setEditable(false);
        this.matlabCodeTextArea.setBorder(BorderFactory.createCompoundBorder(this.matlabCodeTextArea.getBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JScrollPane jScrollPane4 = new JScrollPane(this.matlabCodeTextArea);
        jScrollPane4.setVerticalScrollBarPolicy(20);
        jScrollPane4.setHorizontalScrollBarPolicy(30);
        jScrollPane4.setPreferredSize(dimension2);
        jScrollPane4.setMinimumSize(dimension2);
        jScrollPane4.setMaximumSize(dimension2);
        jTabbedPane.addTab("Matlab", jScrollPane4);
        jPanel.add(jTabbedPane);
        jPanel.setSize(n2 + 10, n3 + 10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Calculation parameters"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(this.calcTypeComboBox, gridBagConstraints);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.dataFileTextField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.openDataButton, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        jPanel2.add((Component)this.dataFileDescriptorLabel, gridBagConstraints);
        if (this.useAllCombosCheckBox) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.allCombosCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = -1;
        }
        for (int i = 0; i < this.numVariables; ++i) {
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)jLabelArray[i], gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.variableColTextFields[i], gridBagConstraints);
        }
        if (this.useStatSigCheckBox) {
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel2.add((Component)this.statSigCheckBox, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)this.statSigAnalyticCheckBox, gridBagConstraints);
        }
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add(this.computeResultCheckBox);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.computeButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Status"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.resultsLabel);
        this.add((Component)jPanel2, "West");
        this.add((Component)jPanel, "East");
        this.add((Component)jPanel3, "South");
        this.setVisible(true);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        this.javaCodeTextArea.repaint();
        this.pythonCodeTextArea.repaint();
        this.pythonCodeTextArea.repaint();
    }

    protected abstract void makeSpecificInitialisations();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.resultsLabel.setText(" ");
        this.javaCodeTextArea.setText(this.codeDefaultText);
        this.pythonCodeTextArea.setText(this.codeDefaultText);
        this.matlabCodeTextArea.setText(this.codeDefaultText);
        if (actionEvent.getSource() == this.computeButton) {
            this.compute();
        } else if (actionEvent.getSource() == this.openDataButton) {
            this.selectFileAction();
        } else if (actionEvent.getSource() == this.calcTypeComboBox) {
            this.putCalcPropertiesInTable();
            this.propertiesTableModel.fireTableDataChanged();
            System.out.println("Added properties for new calculator");
            if (this.statSigCheckBox.isSelected()) {
                if (this.calcImplementsAnalyticStatSig()) {
                    this.statSigAnalyticCheckBox.setEnabled(true);
                } else {
                    this.statSigAnalyticCheckBox.setSelected(false);
                    this.statSigAnalyticCheckBox.setEnabled(false);
                }
            } else {
                this.statSigAnalyticCheckBox.setSelected(false);
                this.statSigAnalyticCheckBox.setEnabled(false);
            }
        }
    }

    @Override
    public void repaint() {
        System.out.println("repainting ...");
        super.repaint();
    }

    protected void selectFileAction() {
        JFileChooser jFileChooser;
        System.out.println("Open data button pressed ...");
        if (this.dataFile == null) {
            jFileChooser = new JFileChooser(this.pathToAutoAnalyserDir + "../data/");
            System.out.println("Choosing data from: " + this.pathToAutoAnalyserDir + "../data/");
        } else {
            jFileChooser = new JFileChooser(this.dataFile);
        }
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.dataFile = jFileChooser.getSelectedFile();
            this.dataFileTextField.setText(this.dataFile.getAbsolutePath());
            System.out.println("Data file selected: " + this.dataFile.getAbsolutePath());
            this.loadData(false);
        }
    }

    protected void loadData(boolean bl) {
        ArrayFileReader arrayFileReader = new ArrayFileReader(this.dataFile);
        try {
            if (bl) {
                this.dataDiscrete = arrayFileReader.getInt2DMatrix();
                this.dataRows = this.dataDiscrete.length;
                this.dataColumns = this.dataRows > 0 ? this.dataDiscrete[0].length : 0;
            } else {
                this.data = arrayFileReader.getDouble2DMatrix();
                this.dataRows = this.data.length;
                this.dataColumns = this.dataRows > 0 ? this.data[0].length : 0;
            }
            this.dataFileDescriptorLabel.setText(String.format("Valid data file with %d rows and %d columns", this.dataRows, this.dataColumns));
            System.out.printf("Read in data with %d rows and %d columns\n", this.dataRows, this.dataColumns);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, exception.getMessage() + (bl ? ".\nFor Discrete calculator make sure you load a file with integer data!" : ""));
            this.dataFileDescriptorLabel.setText("Invalid data file, please load another");
            if (bl) {
                this.dataDiscrete = null;
            }
            this.data = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void compute() {
        String string;
        Object object;
        String string2;
        Comparable<File> comparable;
        String string3;
        Comparable<File> comparable2;
        System.out.println("Compute button pressed ...");
        this.resultsLabel.setText("Computing ...");
        String string4 = (String)this.calcTypeComboBox.getSelectedItem();
        String string5 = this.unitsForEachCalc[this.calcTypeComboBox.getSelectedIndex()];
        if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
            this.loadData(true);
            if (this.dataDiscrete == null) {
                this.resultsLabel.setText(" ");
                return;
            }
        } else if (this.data == null) {
            JOptionPane.showMessageDialog(this, "No valid data source selected");
            this.resultsLabel.setText(" ");
            return;
        }
        int[] nArray = new int[this.numVariables];
        Vector<int[]> vector = new Vector<int[]>();
        if (this.computeResultCheckBox.isSelected()) {
            try {
                if (this.allCombosCheckBox.isSelected()) {
                    this.fillOutAllCombinations(vector);
                } else {
                    for (int i = 0; i < this.numVariables; ++i) {
                        nArray[i] = Integer.parseInt(this.variableColTextFields[i].getText());
                        if (nArray[i] >= 0 && nArray[i] < this.dataColumns) continue;
                        JOptionPane.showMessageDialog(this, String.format("%s column must be between 0 and %d for this data set", this.variableColNumLabels[i], this.dataColumns - 1));
                        this.resultsLabel.setText(" ");
                        return;
                    }
                    vector.add(nArray);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
                this.resultsLabel.setText("Cannot parse a column number from input: " + exception.getMessage());
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package infodynamics.demos.autoanalysis;\n\n");
        stringBuffer.append("import infodynamics.utils.ArrayFileReader;\n");
        if (this.statSigCheckBox.isSelected()) {
            if (this.statSigAnalyticCheckBox.isSelected()) {
                stringBuffer.append("import infodynamics.utils.AnalyticMeasurementDistribution;\n");
            } else {
                stringBuffer.append("import infodynamics.utils.EmpiricalMeasurementDistribution;\n");
            }
        }
        stringBuffer.append("import infodynamics.utils.MatrixUtils;\n\n");
        if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
            stringBuffer.append("import infodynamics.measures.discrete.*;\n");
        } else {
            stringBuffer.append("import infodynamics.measures.continuous.*;\n");
        }
        try {
            comparable2 = new File(this.jidtFolder + "infodynamics.jar");
            string3 = ((File)comparable2).getCanonicalPath();
            comparable = new File(this.pathToAutoAnalyserDir + "../python");
            string2 = ((File)comparable).getCanonicalPath();
            object = new File(this.pathToAutoAnalyserDir + "../octave");
            string = ((File)object).getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage());
            this.resultsLabel.setText("Cannot find jar and Matlab/Python utility locations: " + iOException.getMessage());
            return;
        }
        comparable2 = new StringBuffer();
        ((StringBuffer)comparable2).append("from jpype import *\n");
        ((StringBuffer)comparable2).append("import numpy\n");
        ((StringBuffer)comparable2).append("# Our python data file readers are a bit of a hack, python users will do better on this:\n");
        ((StringBuffer)comparable2).append("sys.path.append(\"" + string2 + "\")\n");
        if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
            ((StringBuffer)comparable2).append("import readIntsFile\n\n");
        } else {
            ((StringBuffer)comparable2).append("import readFloatsFile\n\n");
        }
        ((StringBuffer)comparable2).append("# Add JIDT jar library to the path\n");
        ((StringBuffer)comparable2).append("jarLocation = \"" + string3 + "\"\n");
        ((StringBuffer)comparable2).append("# Start the JVM (add the \"-Xmx\" option with say 1024M if you get crashes due to not enough memory space)\n");
        ((StringBuffer)comparable2).append("startJVM(getDefaultJVMPath(), \"-ea\", \"-Djava.class.path=\" + jarLocation)\n\n");
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append("% Add JIDT jar library to the path, and disable warnings that it's already there:\n");
        ((StringBuffer)comparable).append("warning('off','MATLAB:Java:DuplicateClass');\n");
        ((StringBuffer)comparable).append("javaaddpath('" + string3 + "');\n");
        ((StringBuffer)comparable).append("% Add utilities to the path\n");
        ((StringBuffer)comparable).append("addpath('" + string + "');\n\n");
        try {
            Object object2;
            String string6;
            String string7;
            Object object3;
            String string8;
            int n;
            Object object4;
            int n2;
            object = null;
            InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            if (!string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) && !string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                object = this.assignCalcObjectContinuous(string4);
                if (string4.equalsIgnoreCase(CALC_TYPE_GAUSSIAN)) {
                    stringBuffer.append("import infodynamics.measures.continuous.gaussian.*;\n");
                    string9 = "    calc = new " + object.getClass().getSimpleName() + "();\n";
                    string10 = "calcClass = JPackage(\"infodynamics.measures.continuous.gaussian\")." + object.getClass().getSimpleName() + "\n";
                    string11 = "calc = javaObject('infodynamics.measures.continuous.gaussian." + object.getClass().getSimpleName() + "');\n";
                } else if (string4.startsWith(CALC_TYPE_KRASKOV)) {
                    stringBuffer.append("import infodynamics.measures.continuous.kraskov.*;\n");
                    string9 = "    calc = new " + object.getClass().getSimpleName() + "();\n";
                    string10 = "calcClass = JPackage(\"infodynamics.measures.continuous.kraskov\")." + object.getClass().getSimpleName() + "\n";
                    string11 = "calc = javaObject('infodynamics.measures.continuous.kraskov." + object.getClass().getSimpleName() + "');\n";
                } else if (string4.equalsIgnoreCase(CALC_TYPE_KERNEL)) {
                    stringBuffer.append("import infodynamics.measures.continuous.kernel.*;\n");
                    string9 = "    calc = new " + object.getClass().getSimpleName() + "();\n";
                    string10 = "calcClass = JPackage(\"infodynamics.measures.continuous.kernel\")." + object.getClass().getSimpleName() + "\n";
                    string11 = "calc = javaObject('infodynamics.measures.continuous.kernel." + object.getClass().getSimpleName() + "');\n";
                } else if (string4.equalsIgnoreCase(CALC_TYPE_KOZ_LEO)) {
                    stringBuffer.append("import infodynamics.measures.continuous.kozachenko.*;\n");
                    string9 = "    calc = new " + object.getClass().getSimpleName() + "();\n";
                    string10 = "calcClass = JPackage(\"infodynamics.measures.continuous.kozachenko\")." + object.getClass().getSimpleName() + "\n";
                    string11 = "calc = javaObject('infodynamics.measures.continuous.kozachenko." + object.getClass().getSimpleName() + "');\n";
                } else {
                    throw new Exception("No recognised calculator selected: " + string4);
                }
            }
            stringBuffer.append("\npublic class GeneratedCalculator {\n\n");
            stringBuffer.append("  public static void main(String[] args) throws Exception {\n\n");
            String string12 = "0. Load/prepare the data:\n";
            String string13 = this.dataFile.getAbsolutePath().replace("\\", "\\\\");
            stringBuffer.append("    // " + string12);
            stringBuffer.append("    String dataFile = \"" + string13 + "\";\n");
            stringBuffer.append("    ArrayFileReader afr = new ArrayFileReader(dataFile);\n");
            if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                stringBuffer.append("    int[][] data = afr.getInt2DMatrix();\n");
                if (!this.allCombosCheckBox.isSelected()) {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        stringBuffer.append("    int[] " + this.variableColNumLabels[n2].toLowerCase() + " = MatrixUtils.selectColumn(data, " + nArray[n2] + ");\n");
                    }
                    stringBuffer.append("\n");
                }
            } else if (string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                stringBuffer.append("    double[][] data = afr.getDouble2DMatrix();\n");
                if (!this.allCombosCheckBox.isSelected()) {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        stringBuffer.append("    int[] " + this.variableColNumLabels[n2].toLowerCase() + " = MatrixUtils.discretise(\n        " + "MatrixUtils.selectColumn(data, " + nArray[n2] + "), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ");\n");
                    }
                    stringBuffer.append("\n");
                }
            } else {
                stringBuffer.append("    double[][] data = afr.getDouble2DMatrix();\n");
                if (!this.allCombosCheckBox.isSelected()) {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        stringBuffer.append("    double[] " + this.variableColNumLabels[n2].toLowerCase() + " = MatrixUtils.selectColumn(data, " + nArray[n2] + ");\n");
                    }
                    stringBuffer.append("\n");
                }
            }
            ((StringBuffer)comparable2).append("# " + string12);
            if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                ((StringBuffer)comparable2).append("dataRaw = readIntsFile.readIntsFile(\"" + this.dataFile.getAbsolutePath() + "\")\n");
            } else {
                ((StringBuffer)comparable2).append("dataRaw = readFloatsFile.readFloatsFile(\"" + this.dataFile.getAbsolutePath() + "\")\n");
            }
            ((StringBuffer)comparable2).append("# As numpy array:\n");
            ((StringBuffer)comparable2).append("data = numpy.array(dataRaw)\n");
            if (!this.allCombosCheckBox.isSelected()) {
                if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable2).append(this.variableColNumLabels[n2].toLowerCase() + " = JArray(JInt, 1)(data[:," + nArray[n2] + "].tolist())\n");
                    }
                } else if (string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    ((StringBuffer)comparable2).append("mUtils = JPackage('infodynamics.utils').MatrixUtils\n");
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable2).append(this.variableColNumLabels[n2].toLowerCase() + " = mUtils.discretise(JArray(JDouble, 1)(data[:," + nArray[n2] + "].tolist()), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ")\n");
                    }
                } else {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable2).append(this.variableColNumLabels[n2].toLowerCase() + " = data[:," + nArray[n2] + "]\n");
                    }
                }
                ((StringBuffer)comparable2).append("\n");
            }
            ((StringBuffer)comparable).append("% " + string12);
            ((StringBuffer)comparable).append("data = load('" + this.dataFile.getAbsolutePath() + "');\n");
            if (!this.allCombosCheckBox.isSelected()) {
                ((StringBuffer)comparable).append("% Column indices start from 1 in Matlab:\n");
                if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable).append(this.variableColNumLabels[n2].toLowerCase() + " = octaveToJavaIntArray(data(:," + (nArray[n2] + 1) + "));\n");
                    }
                } else if (string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    ((StringBuffer)comparable).append("mUtils = javaObject('infodynamics.utils.MatrixUtils');\n");
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable).append(this.variableColNumLabels[n2].toLowerCase() + " = mUtils.discretise(octaveToJavaDoubleArray(data(:," + (nArray[n2] + 1) + ")), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ");\n");
                    }
                } else {
                    for (n2 = 0; n2 < this.numVariables; ++n2) {
                        ((StringBuffer)comparable).append(this.variableColNumLabels[n2].toLowerCase() + " = octaveToJavaDoubleArray(data(:," + (nArray[n2] + 1) + "));\n");
                    }
                }
                ((StringBuffer)comparable).append("\n");
            }
            String string14 = "1. Construct the calculator:\n";
            stringBuffer.append("    // " + string14);
            ((StringBuffer)comparable2).append("# " + string14);
            ((StringBuffer)comparable).append("% " + string14);
            if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                object4 = this.assignCalcObjectDiscrete();
                if (object4 == null) {
                    return;
                }
                infoMeasureCalculatorDiscrete = ((DiscreteCalcAndArguments)object4).calc;
                n = ((DiscreteCalcAndArguments)object4).base;
                string8 = ((DiscreteCalcAndArguments)object4).arguments;
                if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                    int n3 = MatrixUtils.min(this.dataDiscrete);
                    int n4 = MatrixUtils.max(this.dataDiscrete);
                    if (n3 < 0 || n4 >= n) {
                        JOptionPane.showMessageDialog(this, "Values in data file (in range " + n3 + ":" + n4 + ") lie outside the expected range 0:" + (n - 1) + " for base " + n);
                        this.resultsLabel.setText(" ");
                        return;
                    }
                }
                stringBuffer.append("    " + infoMeasureCalculatorDiscrete.getClass().getSimpleName() + " calc\n");
                stringBuffer.append("        = new " + infoMeasureCalculatorDiscrete.getClass().getSimpleName() + "(" + string8 + ");\n");
                ((StringBuffer)comparable2).append("calcClass = JPackage(\"infodynamics.measures.discrete\")." + infoMeasureCalculatorDiscrete.getClass().getSimpleName() + "\n");
                ((StringBuffer)comparable2).append("calc = calcClass(" + string8 + ")\n");
                ((StringBuffer)comparable).append("calc = javaObject('infodynamics.measures.discrete." + infoMeasureCalculatorDiscrete.getClass().getSimpleName() + "', " + string8 + ");\n");
                object3 = "2. No other properties to set for discrete calculators.\n";
                stringBuffer.append("    // " + (String)object3);
                ((StringBuffer)comparable2).append("# " + (String)object3);
                ((StringBuffer)comparable).append("% " + (String)object3);
            } else {
                stringBuffer.append("    " + object.getClass().getSimpleName() + " calc;\n");
                stringBuffer.append(string9);
                ((StringBuffer)comparable2).append(string10);
                ((StringBuffer)comparable2).append("calc = calcClass()\n");
                ((StringBuffer)comparable).append(string11);
                object4 = "2. Set any properties to non-default values:\n";
                stringBuffer.append("    // " + (String)object4);
                ((StringBuffer)comparable2).append("# " + (String)object4);
                ((StringBuffer)comparable).append("% " + (String)object4);
                n = 0;
                boolean bl = false;
                for (String string15 : this.propertyNames) {
                    String string16 = null;
                    string7 = this.propertyFieldNames.get(n++);
                    try {
                        string16 = this.propertyValues.get(string15);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        JOptionPane.showMessageDialog(this, exception.getMessage());
                        this.resultsLabel.setText("Cannot find a value for property " + string15);
                    }
                    if (string16.equalsIgnoreCase(object.getProperty(string15))) continue;
                    bl = true;
                    object.setProperty(string15, string16);
                    stringBuffer.append("    calc.setProperty(" + string7 + ",\n        \"" + string16 + "\");\n");
                    ((StringBuffer)comparable2).append("calc.setProperty(\"" + string15 + "\", \"" + string16 + "\")\n");
                    ((StringBuffer)comparable).append("calc.setProperty('" + string15 + "', '" + string16 + "');\n");
                }
                if (!bl) {
                    object3 = "No properties were set to non-default values\n";
                    stringBuffer.append("    // " + (String)object3);
                    ((StringBuffer)comparable2).append("# " + (String)object3);
                    ((StringBuffer)comparable).append("% " + (String)object3);
                }
            }
            object4 = "    ";
            String string17 = "";
            string8 = "";
            object3 = new StringBuffer();
            if (this.allCombosCheckBox.isSelected()) {
                int n5;
                if (string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    ((StringBuffer)comparable2).append("mUtils = JPackage('infodynamics.utils').MatrixUtils\n");
                    ((StringBuffer)comparable).append("mUtils = javaObject('infodynamics.utils.MatrixUtils');\n");
                }
                String[] stringArray = this.setUpLoopsForAllCombos(stringBuffer, (StringBuffer)comparable2, (StringBuffer)comparable);
                for (n5 = 0; n5 < this.indentsForAllCombos; ++n5) {
                    object4 = (String)object4 + "    ";
                    string17 = string17 + "    ";
                    string8 = string8 + "\t";
                }
                for (n5 = 0; n5 < this.numVariables; ++n5) {
                    ((StringBuffer)object3).append(stringArray[n5] + ", ");
                }
                ((StringBuffer)comparable).append(string8 + "% Column indices start from 1 in Matlab:\n");
                if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE)) {
                    for (n5 = 0; n5 < this.numVariables; ++n5) {
                        stringBuffer.append((String)object4 + "int[] " + this.variableColNumLabels[n5].toLowerCase() + " = MatrixUtils.selectColumn(data, " + stringArray[n5] + ");\n");
                        ((StringBuffer)comparable).append(string8 + this.variableColNumLabels[n5].toLowerCase() + " = octaveToJavaIntArray(data(:, " + stringArray[n5] + "));\n");
                        ((StringBuffer)comparable2).append(string17 + this.variableColNumLabels[n5].toLowerCase() + " = JArray(JInt, 1)(data[:, " + stringArray[n5] + "].tolist())\n");
                    }
                } else if (string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    for (n5 = 0; n5 < this.numVariables; ++n5) {
                        stringBuffer.append((String)object4 + "int[] " + this.variableColNumLabels[n5].toLowerCase() + " = MatrixUtils.discretise(\n" + (String)object4 + "    " + "MatrixUtils.selectColumn(data, " + stringArray[n5] + "), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ");\n");
                        ((StringBuffer)comparable).append(string8 + this.variableColNumLabels[n5].toLowerCase() + " = mUtils.discretise(octaveToJavaDoubleArray(data(:," + stringArray[n5] + ")), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ");\n");
                        ((StringBuffer)comparable2).append(string17 + this.variableColNumLabels[n5].toLowerCase() + " = mUtils.discretise(JArray(JDouble, 1)(data[:," + stringArray[n5] + "].tolist()), " + this.propertyValues.get(DISCRETE_PROPNAME_BASE) + ")\n");
                    }
                } else {
                    for (n5 = 0; n5 < this.numVariables; ++n5) {
                        stringBuffer.append((String)object4 + "double[] " + this.variableColNumLabels[n5].toLowerCase() + " = MatrixUtils.selectColumn(data, " + stringArray[n5] + ");\n");
                        ((StringBuffer)comparable).append(string8 + this.variableColNumLabels[n5].toLowerCase() + " = octaveToJavaDoubleArray(data(:, " + stringArray[n5] + "));\n");
                        ((StringBuffer)comparable2).append(string17 + this.variableColNumLabels[n5].toLowerCase() + " = data[:, " + stringArray[n5] + "]\n");
                    }
                }
                stringBuffer.append("\n");
                ((StringBuffer)comparable).append("\n");
                ((StringBuffer)comparable2).append("\n");
            }
            String string18 = "3. Initialise the calculator for (re-)use:\n";
            stringBuffer.append((String)object4 + "// " + string18);
            stringBuffer.append((String)object4 + "calc.initialise();\n");
            ((StringBuffer)comparable2).append(string17 + "# " + string18);
            ((StringBuffer)comparable2).append(string17 + "calc.initialise()\n");
            ((StringBuffer)comparable).append(string8 + "% " + string18);
            ((StringBuffer)comparable).append(string8 + "calc.initialise();\n");
            String string19 = "4. Supply the sample data:\n";
            string7 = string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED) ? "addObservations" : "setObservations";
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < this.numVariables; ++i) {
                stringBuffer2.append(this.variableColNumLabels[i].toLowerCase());
                if (i >= this.numVariables - 1) continue;
                stringBuffer2.append(", ");
            }
            stringBuffer.append((String)object4 + "// " + string19);
            stringBuffer.append((String)object4 + "calc." + string7 + "(" + stringBuffer2 + ");\n");
            ((StringBuffer)comparable2).append(string17 + "# " + string19);
            ((StringBuffer)comparable2).append(string17 + "calc." + string7 + "(" + stringBuffer2 + ")\n");
            ((StringBuffer)comparable).append(string8 + "% " + string19);
            ((StringBuffer)comparable).append(string8 + "calc." + string7 + "(" + stringBuffer2 + ");\n");
            String string20 = "5. Compute the estimate:\n";
            stringBuffer.append((String)object4 + "// " + string20);
            stringBuffer.append((String)object4 + "double result = calc.computeAverageLocalOfObservations();\n");
            ((StringBuffer)comparable2).append(string17 + "# " + string20);
            ((StringBuffer)comparable2).append(string17 + "result = calc.computeAverageLocalOfObservations()\n");
            ((StringBuffer)comparable).append(string8 + "% " + string20);
            ((StringBuffer)comparable).append(string8 + "result = calc.computeAverageLocalOfObservations();\n");
            String string21 = this.allCombosCheckBox.isSelected() ? String.format(this.measureAcronym + "_%s(%s) = ", string4, this.variableRelationshipFormatString) : String.format(this.measureAcronym + "_%s(%s) = ", string4, this.formatStringWithColumnNumbers(this.variableRelationshipFormatString, nArray));
            String string22 = "";
            String string23 = "";
            if (this.statSigCheckBox.isSelected()) {
                void var33_52;
                string6 = "6. Compute the (statistical significance via) null distribution";
                if (this.statSigAnalyticCheckBox.isSelected()) {
                    object2 = "AnalyticMeasurementDistribution";
                    String object5 = "";
                    string6 = string6 + " analytically:\n";
                } else {
                    object2 = "EmpiricalMeasurementDistribution";
                    String string15 = Integer.toString(this.numPermutationsToCheck);
                    string6 = string6 + " empirically (e.g. with 100 permutations):\n";
                }
                stringBuffer.append((String)object4 + "// " + string6);
                stringBuffer.append((String)object4 + (String)object2 + " measDist = calc.computeSignificance(" + (String)var33_52 + ");\n");
                ((StringBuffer)comparable2).append(string17 + "# " + string6);
                ((StringBuffer)comparable2).append(string17 + "measDist = calc.computeSignificance(" + (String)var33_52 + ")\n");
                ((StringBuffer)comparable).append(string8 + "% " + string6);
                ((StringBuffer)comparable).append(string8 + "measDist = calc.computeSignificance(" + (String)var33_52 + ");\n");
                if (this.statSigAnalyticCheckBox.isSelected()) {
                    string22 = " (analytic p(surrogate > measured)=%.5f)";
                    string23 = ", measDist.pValue";
                } else {
                    string22 = " (null: %.4f +/- %.4f std dev.; p(surrogate > measured)=%.5f from %d surrogates)";
                    string23 = String.format(", measDist.getMeanOfDistribution(), measDist.getStdOfDistribution(), measDist.pValue, %d", this.numPermutationsToCheck);
                }
            }
            stringBuffer.append("\n" + (String)object4 + "System.out.printf(\"" + string21 + "%.4f " + string5 + string22 + "\\n\",\n    " + (String)object4 + object3 + "result" + string23 + ");\n");
            ((StringBuffer)comparable2).append("\n" + string17 + "print(\"" + string21 + "%.4f " + string5 + string22 + "\" %\n    " + string17 + "(" + object3 + "result" + string23 + "))\n");
            ((StringBuffer)comparable).append("\n" + string8 + "fprintf('" + string21 + "%.4f " + string5 + string22 + "\\n', ...\n\t" + string8 + object3 + "result" + string23 + ");\n");
            if (this.allCombosCheckBox.isSelected()) {
                this.finaliseLoopsForAllCombos(stringBuffer, (StringBuffer)comparable2, (StringBuffer)comparable);
                this.resultsLabel.setText("See console for all pairs calculation results");
                if (!string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) && !string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    System.out.println("Property values not read back into GUI for all pairs calculation");
                }
            }
            stringBuffer.append("  }\n");
            stringBuffer.append("}\n\n");
            this.javaCodeTextArea.setText(stringBuffer.toString());
            this.javaCodeTextArea.setCaretPosition(0);
            this.pythonCodeTextArea.setText(((StringBuffer)comparable2).toString());
            this.pythonCodeTextArea.setCaretPosition(0);
            this.matlabCodeTextArea.setText(((StringBuffer)comparable).toString());
            this.matlabCodeTextArea.setCaretPosition(0);
            string6 = "";
            try {
                object2 = new FileWriter(this.pathToAutoAnalyserDir + "../java/infodynamics/demos/autoanalysis/GeneratedCalculator.java");
                ((Writer)object2).write(stringBuffer.toString());
                ((OutputStreamWriter)object2).close();
                object2 = new FileWriter(this.pathToAutoAnalyserDir + "GeneratedCalculator.py");
                ((Writer)object2).write(((StringBuffer)comparable2).toString());
                ((OutputStreamWriter)object2).close();
                object2 = new FileWriter(this.pathToAutoAnalyserDir + "GeneratedCalculator.m");
                ((Writer)object2).write(((StringBuffer)comparable).toString());
                ((OutputStreamWriter)object2).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                string6 = " (Error writing generated code files though, see console)";
            }
            if (this.computeResultCheckBox.isSelected()) {
                for (int[] nArray2 : vector) {
                    Object object5;
                    if (this.allCombosCheckBox.isSelected() && this.skipColumnCombo(nArray2)) {
                        System.out.print("Skipping column combo ");
                        MatrixUtils.printArray(System.out, nArray2);
                        continue;
                    }
                    if (string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                        infoMeasureCalculatorDiscrete.initialise();
                    } else {
                        object.initialise();
                    }
                    this.setObservations(infoMeasureCalculatorDiscrete, (InfoMeasureCalculatorContinuous)object, nArray2);
                    double d = string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED) ? infoMeasureCalculatorDiscrete.computeAverageLocalOfObservations() : object.computeAverageLocalOfObservations();
                    String string16 = "";
                    if (this.statSigCheckBox.isSelected()) {
                        Object object6;
                        if (this.statSigAnalyticCheckBox.isSelected()) {
                            object5 = string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED) ? (AnalyticNullDistributionComputer)((Object)infoMeasureCalculatorDiscrete) : (AnalyticNullDistributionComputer)object;
                            object6 = object5.computeSignificance();
                            string16 = String.format(string22, ((AnalyticMeasurementDistribution)object6).pValue);
                        } else {
                            object6 = string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string4.equalsIgnoreCase(CALC_TYPE_BINNED) ? (EmpiricalNullDistributionComputer)((Object)infoMeasureCalculatorDiscrete) : (EmpiricalNullDistributionComputer)object;
                            object5 = object6.computeSignificance(this.numPermutationsToCheck);
                            string16 = String.format(string22, ((EmpiricalMeasurementDistribution)object5).getMeanOfDistribution(), ((EmpiricalMeasurementDistribution)object5).getStdOfDistribution(), ((EmpiricalMeasurementDistribution)object5).pValue, this.numPermutationsToCheck);
                        }
                    }
                    if (this.allCombosCheckBox.isSelected()) {
                        object5 = String.format(this.formatStringWithColumnNumbers(string21 + "%%.4f %%s" + string16, nArray2), d, string5);
                    } else {
                        object5 = String.format(string21 + "%.4f %s" + string16, d, string5);
                        this.resultsLabel.setText((String)object5 + string6);
                    }
                    System.out.println((String)object5);
                }
                if (this.allCombosCheckBox.isSelected() && !string4.equalsIgnoreCase(CALC_TYPE_DISCRETE) && !string4.equalsIgnoreCase(CALC_TYPE_BINNED)) {
                    for (String string24 : this.propertyNames) {
                        String string25 = null;
                        try {
                            string25 = object.getProperty(string24);
                            this.propertyValues.put(string24, string25);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                            JOptionPane.showMessageDialog(this, exception.getMessage());
                            this.resultsLabel.setText("Cannot find a value for property " + string24);
                        }
                    }
                    this.propertiesTableModel.fireTableDataChanged();
                }
            } else {
                this.resultsLabel.setText("Code generated (no computation performed)");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Calculation failed, please see console");
        }
    }

    protected abstract void fillOutAllCombinations(Vector<int[]> var1) throws Exception;

    protected abstract String[] setUpLoopsForAllCombos(StringBuffer var1, StringBuffer var2, StringBuffer var3);

    protected abstract void finaliseLoopsForAllCombos(StringBuffer var1, StringBuffer var2, StringBuffer var3);

    protected abstract String formatStringWithColumnNumbers(String var1, int[] var2);

    protected abstract boolean skipColumnCombo(int[] var1);

    protected abstract InfoMeasureCalculatorContinuous assignCalcObjectContinuous(String var1) throws Exception;

    protected abstract DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception;

    protected abstract void setObservations(InfoMeasureCalculatorDiscrete var1, InfoMeasureCalculatorContinuous var2, int[] var3) throws Exception;

    public void putCalcPropertiesInTable() {
        System.out.println("Getting calc properties");
        String string = (String)this.calcTypeComboBox.getSelectedItem();
        CalcProperties calcProperties = null;
        try {
            calcProperties = this.assignCalcProperties(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot load requested calculator");
        }
        String[] stringArray = calcProperties.classSpecificPropertyNames;
        String[] stringArray2 = calcProperties.classSpecificPropertiesFieldNames;
        String[] stringArray3 = calcProperties.classSpecificPropertyDescriptions;
        this.calcClass = calcProperties.calcClass;
        InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous = calcProperties.calc;
        this.propertyNames = new Vector();
        this.propertyFieldNames = new Vector();
        this.propertyDescriptions = new Vector();
        if (string.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string.equalsIgnoreCase(CALC_TYPE_BINNED)) {
            int n = 0;
            this.propertyValues = new HashMap();
            for (String string2 : this.discreteProperties) {
                String string3 = this.discretePropertyDescriptions[n];
                String string4 = this.discretePropertyDefaultValues[n];
                ++n;
                this.propertyNames.add(string2);
                this.propertyDescriptions.add(string3);
                this.propertyValues.put(string2, string4);
                System.out.println("Adding property name " + string2);
            }
        } else {
            String string5;
            String string6;
            int n = 0;
            for (String string7 : this.commonContPropertiesFieldNames) {
                string6 = this.commonContPropertyNames[n];
                string5 = this.commonContPropertyDescriptions[n];
                ++n;
                System.out.println("Adding property name " + this.abstractContinuousClass.getSimpleName() + "." + string7 + " = \"" + string6 + "\"");
                this.propertyFieldNames.add(this.abstractContinuousClass.getSimpleName() + "." + string7);
                this.propertyNames.add(string6);
                this.propertyDescriptions.add(string5);
            }
            n = 0;
            for (String string7 : stringArray2) {
                string6 = stringArray[n];
                string5 = stringArray3[n];
                ++n;
                this.propertyNames.add(string6);
                this.propertyDescriptions.add(string5);
                if (string7.contains(".")) {
                    System.out.println("Adding property name " + string7 + " = \"" + string6 + "\"");
                    this.propertyFieldNames.add(string7);
                    continue;
                }
                System.out.println("Adding property name " + this.calcClass.getSimpleName() + "." + string7 + " = \"" + string6 + "\"");
                this.propertyFieldNames.add(this.calcClass.getSimpleName() + "." + string7);
            }
            this.propertyValues = new HashMap();
            for (String string8 : this.propertyNames) {
                try {
                    String string7;
                    InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous2 = infoMeasureCalculatorContinuous;
                    string7 = infoMeasureCalculatorContinuous2.getProperty(string8);
                    this.propertyValues.put(string8, string7);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                    this.propertyValues.put(string8, "Cannot find a value");
                }
            }
        }
    }

    protected CalcProperties assignCalcProperties(String string) throws Exception {
        if (string.equalsIgnoreCase(CALC_TYPE_DISCRETE) || string.equalsIgnoreCase(CALC_TYPE_BINNED)) {
            CalcProperties calcProperties = new CalcProperties();
            calcProperties.calcClass = this.discreteClass;
            calcProperties.calc = null;
            calcProperties.classSpecificPropertyNames = this.discreteProperties;
            calcProperties.classSpecificPropertiesFieldNames = null;
            calcProperties.classSpecificPropertyDescriptions = this.discretePropertyDescriptions;
            return calcProperties;
        }
        return null;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.resultsLabel.setText(" ");
        this.javaCodeTextArea.setText(this.codeDefaultText);
        this.pythonCodeTextArea.setText(this.codeDefaultText);
        this.matlabCodeTextArea.setText(this.codeDefaultText);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.resultsLabel.setText(" ");
        this.javaCodeTextArea.setText(this.codeDefaultText);
        this.pythonCodeTextArea.setText(this.codeDefaultText);
        this.matlabCodeTextArea.setText(this.codeDefaultText);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.resultsLabel.setText(" ");
        this.javaCodeTextArea.setText(this.codeDefaultText);
        this.pythonCodeTextArea.setText(this.codeDefaultText);
        this.matlabCodeTextArea.setText(this.codeDefaultText);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.resultsLabel.setText(" ");
        this.javaCodeTextArea.setText(this.codeDefaultText);
        this.pythonCodeTextArea.setText(this.codeDefaultText);
        this.matlabCodeTextArea.setText(this.codeDefaultText);
        if (mouseEvent.getSource() == this.dataFileTextField) {
            this.selectFileAction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.allCombosCheckBox) {
            if (this.allCombosCheckBox.isSelected()) {
                for (int i = 0; i < this.numVariables; ++i) {
                    if (!this.disableVariableColTextFieldsForAllCombos[i]) continue;
                    this.variableColTextFields[i].setEnabled(false);
                }
            } else {
                for (int i = 0; i < this.numVariables; ++i) {
                    this.variableColTextFields[i].setEnabled(true);
                }
            }
        } else if (changeEvent.getSource() == this.statSigCheckBox) {
            System.out.println("StatSigCheckBox state changed to " + this.statSigCheckBox.isSelected());
            if (this.statSigCheckBox.isSelected()) {
                if (this.calcImplementsAnalyticStatSig()) {
                    this.statSigAnalyticCheckBox.setEnabled(true);
                } else {
                    this.statSigAnalyticCheckBox.setSelected(false);
                    this.statSigAnalyticCheckBox.setEnabled(false);
                }
            } else {
                this.statSigAnalyticCheckBox.setSelected(false);
                this.statSigAnalyticCheckBox.setEnabled(false);
            }
        } else if (changeEvent.getSource() == this.computeResultCheckBox) {
            if (this.computeResultCheckBox.isSelected()) {
                this.computeButton.setText(this.buttonTextCodeAndCompute);
            } else {
                this.computeButton.setText(this.buttonTextCodeOnly);
            }
        }
    }

    protected boolean calcImplementsAnalyticStatSig() {
        for (Class clazz = this.calcClass; clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] classArray;
            for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                if (clazz2 != AnalyticNullDistributionComputer.class) continue;
                return true;
            }
        }
        return false;
    }

    protected class CalcProperties {
        InfoMeasureCalculatorContinuous calc;
        Class calcClass;
        String[] classSpecificPropertyNames;
        String[] classSpecificPropertiesFieldNames;
        String[] classSpecificPropertyDescriptions;

        protected CalcProperties() {
        }
    }

    protected class PropertiesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "Property name";
            }
            return "Property value";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            String string = AutoAnalyser.this.propertyNames.get(n);
            AutoAnalyser.this.propertyValues.put(string, (String)object);
            AutoAnalyser.this.resultsLabel.setText(" ");
            AutoAnalyser.this.javaCodeTextArea.setText(AutoAnalyser.this.codeDefaultText);
            AutoAnalyser.this.pythonCodeTextArea.setText(AutoAnalyser.this.codeDefaultText);
            AutoAnalyser.this.matlabCodeTextArea.setText(AutoAnalyser.this.codeDefaultText);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AutoAnalyser.this.propertyNames.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = AutoAnalyser.this.propertyNames.get(n);
            if (n2 == 0) {
                return string;
            }
            return AutoAnalyser.this.propertyValues.get(string);
        }
    }

    protected class TableWithToolTip
    extends JTable {
        private static final long serialVersionUID = 1L;

        public TableWithToolTip(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent && n2 == 0) {
                JComponent jComponent = (JComponent)component;
                try {
                    jComponent.setToolTipText("<html>" + AutoAnalyser.this.propertyFieldNames.get(n) + ": " + AutoAnalyser.this.propertyDescriptions.get(n) + "</html>");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return component;
        }
    }

    protected class DiscreteCalcAndArguments {
        InfoMeasureCalculatorDiscrete calc;
        int base;
        String arguments;

        DiscreteCalcAndArguments(InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete, int n, String string) {
            this.calc = infoMeasureCalculatorDiscrete;
            this.base = n;
            this.arguments = string;
        }
    }

    public class TextAreaWithImage
    extends JTextArea {
        private static final long serialVersionUID = 1L;
        protected Image image;
        protected boolean rescaled;
        protected int xOffset;
        protected int yOffset;

        public TextAreaWithImage(String string, Image image) {
            super(string);
            this.rescaled = false;
            this.xOffset = 0;
            this.yOffset = 0;
            this.setOpaque(false);
            this.image = image;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.rescaled) {
                int n;
                int n2 = this.getWidth();
                this.image = n2 < (n = this.getHeight()) ? this.image.getScaledInstance(n2, -1, 0) : this.image.getScaledInstance(-1, n, 0);
                this.rescaled = true;
            }
            graphics.drawImage(this.image, 50, 0, null);
            super.paintComponent(graphics);
        }
    }
}

