/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.MultiInfoCalculator;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Random;
import java.util.Vector;

public abstract class MultiInfoCalculatorCommon
implements MultiInfoCalculator {
    protected int dimensions = 1;
    protected int totalObservations = 0;
    protected boolean debug = false;
    protected double[][] observations;
    protected Vector<double[]> individualObservations;
    protected boolean miComputed = false;
    protected double lastAverage;
    protected boolean addedMoreThanOneObservationSet;
    protected boolean normalise = true;
    private boolean underSample = false;
    private double samplingFactor = 0.1;
    private Random rand;

    @Override
    public void initialise() {
        this.initialise(this.dimensions);
    }

    @Override
    public void initialise(int n) {
        this.dimensions = n;
        this.lastAverage = 0.0;
        this.totalObservations = 0;
        this.miComputed = false;
        this.observations = null;
        this.addedMoreThanOneObservationSet = false;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("NORMALISE")) {
            this.normalise = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("SAMPLING_FACTOR")) {
            this.samplingFactor = Double.parseDouble(string2);
            this.underSample = this.samplingFactor < 1.0;
            this.rand = new Random();
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase("NORMALISE")) {
            return Boolean.toString(this.normalise);
        }
        if (string.equalsIgnoreCase("SAMPLING_FACTOR")) {
            return Double.toString(this.samplingFactor);
        }
        return null;
    }

    @Override
    public void setObservations(double[][] dArray) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray);
        this.finaliseAddObservations();
        this.addedMoreThanOneObservationSet = false;
    }

    @Override
    public void startAddObservations() {
        this.individualObservations = new Vector();
    }

    @Override
    public void addObservation(double[] dArray) {
        if (this.underSample && this.rand.nextDouble() >= this.samplingFactor) {
            return;
        }
        if (this.individualObservations.size() > 0) {
            this.addedMoreThanOneObservationSet = true;
        }
        this.individualObservations.add(dArray);
    }

    @Override
    public void addObservations(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addObservation(dArray[i]);
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.observations = new double[this.individualObservations.size()][];
        for (int i = 0; i < this.observations.length; ++i) {
            this.observations[i] = this.individualObservations.elementAt(i);
        }
        this.individualObservations = null;
        if (this.observations[0].length != this.dimensions) {
            throw new Exception("Incorrect number of dimensions " + this.observations[0].length + " in supplied observations (expected " + this.dimensions + ")");
        }
        this.totalObservations = this.observations.length;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][][] nArrayArray = new int[n][][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = randomGenerator.generateRandomPerturbations(this.totalObservations, this.dimensions - 1);
        }
        return this.computeSignificance(nArrayArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][][] nArray) throws Exception {
        int n = nArray.length;
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        double d = this.lastAverage;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2;
            empiricalMeasurementDistribution.distribution[i] = d2 = this.computeAverageLocalOfObservations(nArray[i]);
            if (this.debug) {
                System.out.println("New MI was " + d2);
            }
            if (!(d2 >= d)) continue;
            ++n2;
        }
        this.lastAverage = d;
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public double computeAverageLocalOfObservations(int[][] nArray) throws Exception {
        if (nArray == null) {
            return this.computeAverageLocalOfObservations();
        }
        MultiInfoCalculatorCommon multiInfoCalculatorCommon = (MultiInfoCalculatorCommon)this.clone();
        double[][] dArray = MatrixUtils.reorderDataForVariables(this.observations, nArray);
        multiInfoCalculatorCommon.initialise(this.dimensions);
        multiInfoCalculatorCommon.setObservations(dArray);
        return multiInfoCalculatorCommon.computeAverageLocalOfObservations();
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.totalObservations;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }
}

