/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.gaussian;

import infodynamics.measures.continuous.MultiInfoCalculatorCommon;
import infodynamics.utils.MatrixUtils;

public class MultiInfoCalculatorGaussian
extends MultiInfoCalculatorCommon {
    double[][] covariance = null;
    double[] means = null;
    boolean covFromObservations;

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        this.setCovariance(MatrixUtils.covarianceMatrix(this.observations), true);
    }

    public void setCovariance(double[][] dArray) throws Exception {
        this.setCovariance(dArray, false);
    }

    public void setCovarianceAndMeans(double[][] dArray, double[] dArray2) throws Exception {
        this.means = dArray2;
        this.setCovariance(dArray, false);
    }

    public void setCovariance(double[][] dArray, boolean bl) throws Exception {
        if (!bl) {
            this.observations = null;
        }
        if (dArray.length != this.dimensions) {
            throw new Exception("Supplied covariance matrix does not match initialised number of dimensions");
        }
        if (dArray.length != dArray[0].length) {
            throw new Exception("Covariance matrices must be square");
        }
        this.covFromObservations = bl;
        this.covariance = dArray;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        if (this.covariance == null) {
            throw new Exception("Cannot calculate multi-information without having a covariance either supplied or computed via setObservations()");
        }
        if (!this.miComputed) {
            double d = -Math.log(MatrixUtils.determinantSymmPosDefMatrix(this.covariance));
            for (int i = 0; i < this.dimensions; ++i) {
                d += Math.log(this.covariance[i][i]);
            }
            this.lastAverage = 0.5 * d;
        }
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        if (this.observations == null) {
            throw new Exception("Cannot compute local values of previous observations if they have not been set!");
        }
        return this.computeLocalUsingPreviousObservations(this.observations);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) throws Exception {
        if (this.means == null || this.covariance == null) {
            throw new Exception("Cannot compute local values without having means and covariance either supplied or computed via setObservations()");
        }
        double[][] dArray2 = MatrixUtils.CholeskyDecomposition(this.covariance);
        double[][] dArray3 = MatrixUtils.solveViaCholeskyResult(dArray2, MatrixUtils.identityMatrix(dArray2.length));
        double d = MatrixUtils.determinantViaCholeskyResult(dArray2);
        double[] dArray4 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray5 = MatrixUtils.subtract(dArray[i], this.means);
            double d2 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray5, dArray3), dArray5);
            double d3 = Math.exp(-0.5 * d2) / Math.sqrt(d);
            double d4 = Math.log(d3);
            for (int j = 0; j < this.dimensions; ++j) {
                double d5 = Math.exp(-0.5 * (dArray[i][j] - this.means[j]) * (dArray[i][j] - this.means[j]) / this.covariance[j][j]) / Math.sqrt(this.covariance[j][j]);
                d4 -= Math.log(d5);
            }
            dArray4[i] = d4;
        }
        return dArray4;
    }
}

