/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.measures.continuous.kernel.TransferEntropyKernelCounts;
import infodynamics.utils.MatrixUtils;

public class KernelEstimatorTransferEntropy
extends KernelEstimatorMultiVariate {
    private double suppliedKernelWidthSource;
    private double kernelWidthSourceInUse;
    private double[] destNext;
    private double[] source;
    private double destNextObs;
    private double sourceObs;
    private int countNextPast;
    private int countPastSource;
    private int countNextPastSource;

    public KernelEstimatorTransferEntropy() {
        this.makeCorrelatedPointAddedCallback = true;
    }

    @Override
    public void initialise(int n, double d) {
        super.initialise(n, d);
        this.suppliedKernelWidthSource = d;
    }

    public void initialise(int n, double d, double d2) {
        super.initialise(n, d);
        this.suppliedKernelWidthSource = d2;
    }

    public void setObservations(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.setObservations(dArray);
        if (this.normalise) {
            double d = MatrixUtils.stdDev(dArray3);
            this.kernelWidthSourceInUse = this.suppliedKernelWidthSource * d;
        } else {
            this.kernelWidthSourceInUse = this.suppliedKernelWidthSource;
        }
        this.source = dArray3;
        this.destNext = dArray2;
    }

    public synchronized TransferEntropyKernelCounts getCount(double[] dArray, double d, double d2, int n) {
        this.countNextPast = 0;
        this.countPastSource = 0;
        this.countNextPastSource = 0;
        this.destNextObs = d;
        this.sourceObs = d2;
        int n2 = n < 0 ? super.getCount(dArray) : super.getCount(dArray, n);
        TransferEntropyKernelCounts transferEntropyKernelCounts = new TransferEntropyKernelCounts(n2, this.countNextPast, this.countPastSource, this.countNextPastSource);
        return transferEntropyKernelCounts;
    }

    public void setEpsSource(double d) {
        this.suppliedKernelWidthSource = d;
    }

    @Override
    protected void correlatedPointAddedCallback(int n) {
        boolean bl = false;
        if (Math.abs(this.sourceObs - this.source[n]) <= this.kernelWidthSourceInUse) {
            ++this.countPastSource;
            bl = true;
        }
        if (Math.abs(this.destNextObs - this.destNext[n]) <= this.kernelWidthsInUse[0]) {
            ++this.countNextPast;
            if (bl) {
                ++this.countNextPastSource;
            }
        }
    }

    @Override
    protected void correlatedPointRemovedCallback(int n) {
        boolean bl = false;
        if (Math.abs(this.sourceObs - this.source[n]) <= this.kernelWidthSourceInUse) {
            --this.countPastSource;
            bl = true;
        }
        if (Math.abs(this.destNextObs - this.destNext[n]) <= this.kernelWidthsInUse[0]) {
            --this.countNextPast;
            if (bl) {
                --this.countNextPastSource;
            }
        }
    }
}

