/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.NearestNeighbourSearcher;
import infodynamics.utils.NeighbourNodeData;
import java.util.Arrays;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Vector;

public class KdTree
extends NearestNeighbourSearcher {
    protected double[][][] originalDataSets;
    protected int[][] masterSortedArrayIndices = null;
    protected double[][][] dimensionToArray = null;
    protected int[] dimensionToArrayIndex = null;
    protected int[] dimensionToVariableNumber = null;
    protected int totalDimensions = 0;
    protected KdTreeNode rootNode = null;

    public KdTree(double[][] dArray) {
        this(new int[]{dArray[0].length}, new double[][][]{dArray});
    }

    public KdTree(int[] nArray, double[][][] dArray) {
        int n;
        int n2;
        this.originalDataSets = dArray;
        int n3 = dArray[0].length;
        this.totalDimensions = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.totalDimensions += nArray[n2];
        }
        this.dimensionToArray = new double[this.totalDimensions][][];
        this.dimensionToArrayIndex = new int[this.totalDimensions];
        this.dimensionToVariableNumber = new int[this.totalDimensions];
        n2 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            for (int j = 0; j < n; ++j) {
                this.dimensionToArray[n2] = dArray[i];
                this.dimensionToVariableNumber[n2] = i;
                this.dimensionToArrayIndex[n2] = n2 - n4;
                ++n2;
            }
            n4 = n2;
        }
        double[][] dArray2 = new double[n3][2];
        this.masterSortedArrayIndices = new int[this.totalDimensions + 1][n3];
        for (n = 0; n < this.totalDimensions; ++n) {
            int n5;
            double[][] dArray3 = this.dimensionToArray[n];
            MatrixUtils.arrayCopy(dArray3, 0, this.dimensionToArrayIndex[n], dArray2, 0, 0, n3, 1);
            for (n5 = 0; n5 < n3; ++n5) {
                dArray2[n5][1] = n5;
            }
            Arrays.sort(dArray2, FirstIndexComparatorDouble.getInstance());
            for (n5 = 0; n5 < n3; ++n5) {
                this.masterSortedArrayIndices[n][n5] = (int)dArray2[n5][1];
            }
        }
        this.rootNode = this.constructKdTree(0, 0, n3, this.masterSortedArrayIndices);
        this.masterSortedArrayIndices = null;
    }

    protected KdTreeNode constructKdTree(int n, int n2, int n3, int[][] nArray) {
        int n4;
        int n5;
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return new KdTreeNode(nArray[n][n2], null, null);
        }
        if (n3 == 2) {
            return new KdTreeNode(nArray[n][n2], null, new KdTreeNode(nArray[n][n2 + 1], null, null));
        }
        double[][] dArray = this.dimensionToArray[n];
        int n6 = this.dimensionToArrayIndex[n];
        for (n5 = n2 + n3 / 2; n5 > n2 && dArray[nArray[n][n5 - 1]][n6] == dArray[nArray[n][n5]][n6]; --n5) {
        }
        double d = dArray[nArray[n][n5]][n6];
        int n7 = nArray[n][n5];
        int n8 = n2;
        int n9 = n5 - n2;
        int n10 = n5 + 1;
        int n11 = n2 + n3 - 1 - n5;
        int[][] nArrayArray = new int[this.totalDimensions + 1][];
        int[] nArray2 = nArray[this.totalDimensions];
        for (n4 = 0; n4 < this.totalDimensions; ++n4) {
            if (n4 == n) {
                nArrayArray[n4] = nArray[n4];
                continue;
            }
            int n12 = n8;
            int n13 = n10;
            for (int i = n2; i < n2 + n3; ++i) {
                int n14 = nArray[n4][i];
                if (n14 == n7) continue;
                if (dArray[n14][n6] < d) {
                    nArray2[n12++] = n14;
                    continue;
                }
                nArray2[n13++] = n14;
            }
            if (n12 > n8 + n9) {
                throw new RuntimeException("Exceeded expected number of points on left");
            }
            if (n13 > n10 + n11) {
                throw new RuntimeException("Exceeded expected number of points on right");
            }
            int[] nArray3 = nArray[n4];
            nArrayArray[n4] = nArray2;
            nArray2 = nArray3;
        }
        nArrayArray[this.totalDimensions] = nArray2;
        n4 = (n + 1) % this.totalDimensions;
        return new KdTreeNode(n7, this.constructKdTree(n4, n8, n9, nArrayArray), this.constructKdTree(n4, n10, n11, nArrayArray));
    }

    @Override
    public void setNormType(int n) {
        super.setNormType(n);
    }

    @Override
    public void setNormType(String string) {
        super.setNormType(string);
    }

    public static final double norm(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        switch (n) {
            case 2: {
                for (int i = 0; i < dArray.length; ++i) {
                    double d2 = dArray[i] - dArray2[i];
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    if (!(d2 > d)) continue;
                    d = d2;
                }
                return d;
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] - dArray2[i];
            d += d3 * d3;
        }
        return d;
    }

    public static final double normWithAbort(double[] dArray, double[] dArray2, double d, int n) {
        double d2 = 0.0;
        switch (n) {
            case 2: {
                for (int i = 0; i < dArray.length; ++i) {
                    double d3 = dArray[i] - dArray2[i];
                    if (d3 < 0.0) {
                        d3 = -d3;
                    }
                    if (!(d3 > d2)) continue;
                    if (d3 > d) {
                        return Double.POSITIVE_INFINITY;
                    }
                    d2 = d3;
                }
                return d2;
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = dArray[i] - dArray2[i];
            if (!((d2 += d4 * d4) > d)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    @Override
    public NeighbourNodeData findNearestNeighbour(int n) {
        if (this.rootNode == null) {
            return null;
        }
        return this.findNearestNeighbour(n, this.rootNode, 0, null);
    }

    protected NeighbourNodeData findNearestNeighbour(int n, KdTreeNode kdTreeNode, int n2, NeighbourNodeData neighbourNodeData) {
        int n3 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        double d = dArray[n][n4] - dArray[kdTreeNode.indexOfThisPoint][n4];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        if (kdTreeNode.indexOfThisPoint != n && (neighbourNodeData == null || d2 < neighbourNodeData.distance)) {
            double d3 = 0.0;
            double[] dArray2 = new double[this.originalDataSets.length];
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                dArray2[i] = neighbourNodeData == null ? KdTree.norm(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], this.normTypeToUse) : KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], neighbourNodeData.distance, this.normTypeToUse);
                if (dArray2[i] > d3 && Double.isInfinite(d3 = dArray2[i])) break;
            }
            if (neighbourNodeData == null || d3 < neighbourNodeData.distance) {
                neighbourNodeData = new NeighbourNodeData(kdTreeNode.indexOfThisPoint, dArray2, d3);
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            neighbourNodeData = this.findNearestNeighbour(n, kdTreeNode2, n2 + 1, neighbourNodeData);
        }
        if ((neighbourNodeData == null || d2 < neighbourNodeData.distance) && kdTreeNode3 != null) {
            neighbourNodeData = this.findNearestNeighbour(n, kdTreeNode3, n2 + 1, neighbourNodeData);
        }
        return neighbourNodeData;
    }

    @Override
    public PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int n, int n2) throws Exception {
        if (this.originalDataSets[0].length <= n) {
            throw new Exception("Not enough data points for a K nearest neighbours search");
        }
        PriorityQueue<NeighbourNodeData> priorityQueue = new PriorityQueue<NeighbourNodeData>(n);
        if (this.rootNode == null) {
            return priorityQueue;
        }
        this.findKNearestNeighbours(n, n2, this.rootNode, 0, priorityQueue);
        return priorityQueue;
    }

    @Override
    public PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int n, int n2, int n3) throws Exception {
        if (this.originalDataSets[0].length <= n + 2 * n3) {
            throw new Exception("Not enough data points for a K nearest neighbours search with dynamic exclusion window of " + n3 + " points either side");
        }
        PriorityQueue<NeighbourNodeData> priorityQueue = new PriorityQueue<NeighbourNodeData>(n);
        if (this.rootNode == null) {
            return priorityQueue;
        }
        this.findKNearestNeighbours(n, n2, n3, this.rootNode, 0, priorityQueue);
        return priorityQueue;
    }

    protected void findKNearestNeighbours(int n, int n2, KdTreeNode kdTreeNode, int n3, PriorityQueue<NeighbourNodeData> priorityQueue) {
        int n4 = n3 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        double d = dArray[n2][n5] - dArray[kdTreeNode.indexOfThisPoint][n5];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        NeighbourNodeData neighbourNodeData = priorityQueue.peek();
        if (kdTreeNode.indexOfThisPoint != n2 && (priorityQueue.size() < n || d2 < neighbourNodeData.distance)) {
            double d3 = 0.0;
            double[] dArray2 = new double[this.originalDataSets.length];
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                dArray2[i] = priorityQueue.size() < n ? KdTree.norm(this.originalDataSets[i][n2], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], this.normTypeToUse) : KdTree.normWithAbort(this.originalDataSets[i][n2], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], neighbourNodeData.distance, this.normTypeToUse);
                if (dArray2[i] > d3 && Double.isInfinite(d3 = dArray2[i])) break;
            }
            if (priorityQueue.size() < n || d3 < neighbourNodeData.distance) {
                if (priorityQueue.size() == n) {
                    priorityQueue.poll();
                }
                priorityQueue.add(new NeighbourNodeData(kdTreeNode.indexOfThisPoint, dArray2, d3));
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            this.findKNearestNeighbours(n, n2, kdTreeNode2, n3 + 1, priorityQueue);
        }
        neighbourNodeData = priorityQueue.peek();
        if ((priorityQueue.size() < n || d2 < neighbourNodeData.distance) && kdTreeNode3 != null) {
            this.findKNearestNeighbours(n, n2, kdTreeNode3, n3 + 1, priorityQueue);
        }
    }

    protected void findKNearestNeighbours(int n, int n2, int n3, KdTreeNode kdTreeNode, int n4, PriorityQueue<NeighbourNodeData> priorityQueue) {
        int n5 = n4 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        double d = dArray[n2][n6] - dArray[kdTreeNode.indexOfThisPoint][n6];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        NeighbourNodeData neighbourNodeData = priorityQueue.peek();
        if (!(kdTreeNode.indexOfThisPoint - n2 <= n3 && kdTreeNode.indexOfThisPoint - n2 >= -n3 || priorityQueue.size() >= n && !(d2 < neighbourNodeData.distance))) {
            double d3 = 0.0;
            double[] dArray2 = new double[this.originalDataSets.length];
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                dArray2[i] = priorityQueue.size() < n ? KdTree.norm(this.originalDataSets[i][n2], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], this.normTypeToUse) : KdTree.normWithAbort(this.originalDataSets[i][n2], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], neighbourNodeData.distance, this.normTypeToUse);
                if (dArray2[i] > d3 && Double.isInfinite(d3 = dArray2[i])) break;
            }
            if (priorityQueue.size() < n || d3 < neighbourNodeData.distance) {
                if (priorityQueue.size() == n) {
                    priorityQueue.poll();
                }
                priorityQueue.add(new NeighbourNodeData(kdTreeNode.indexOfThisPoint, dArray2, d3));
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            this.findKNearestNeighbours(n, n2, n3, kdTreeNode2, n4 + 1, priorityQueue);
        }
        neighbourNodeData = priorityQueue.peek();
        if ((priorityQueue.size() < n || d2 < neighbourNodeData.distance) && kdTreeNode3 != null) {
            this.findKNearestNeighbours(n, n2, n3, kdTreeNode3, n4 + 1, priorityQueue);
        }
    }

    public PriorityQueue<NeighbourNodeData> findKNearestNeighbours(int n, double[][] dArray) throws Exception {
        if (this.originalDataSets[0].length <= n) {
            throw new Exception("Not enough data points for a K nearest neighbours search");
        }
        PriorityQueue<NeighbourNodeData> priorityQueue = new PriorityQueue<NeighbourNodeData>(n);
        if (this.rootNode == null) {
            return priorityQueue;
        }
        this.findKNearestNeighbours(n, dArray, this.rootNode, 0, priorityQueue);
        return priorityQueue;
    }

    protected void findKNearestNeighbours(int n, double[][] dArray, KdTreeNode kdTreeNode, int n2, PriorityQueue<NeighbourNodeData> priorityQueue) {
        int n3 = n2 % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        int n5 = this.dimensionToVariableNumber[n3];
        double d = dArray[n5][n4] - dArray2[kdTreeNode.indexOfThisPoint][n4];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        NeighbourNodeData neighbourNodeData = priorityQueue.peek();
        if (priorityQueue.size() < n || d2 < neighbourNodeData.distance) {
            double d3 = 0.0;
            double[] dArray3 = new double[this.originalDataSets.length];
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                dArray3[i] = priorityQueue.size() < n ? KdTree.norm(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], this.normTypeToUse) : KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], neighbourNodeData.distance, this.normTypeToUse);
                if (dArray3[i] > d3 && Double.isInfinite(d3 = dArray3[i])) break;
            }
            if (priorityQueue.size() < n || d3 < neighbourNodeData.distance) {
                if (priorityQueue.size() == n) {
                    priorityQueue.poll();
                }
                priorityQueue.add(new NeighbourNodeData(kdTreeNode.indexOfThisPoint, dArray3, d3));
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            this.findKNearestNeighbours(n, dArray, kdTreeNode2, n2 + 1, priorityQueue);
        }
        neighbourNodeData = priorityQueue.peek();
        if ((priorityQueue.size() < n || d2 < neighbourNodeData.distance) && kdTreeNode3 != null) {
            this.findKNearestNeighbours(n, dArray, kdTreeNode3, n2 + 1, priorityQueue);
        }
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(n, this.rootNode, 0, d, bl);
    }

    protected int countPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl) {
        int n3 = 0;
        int n4 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        double d2 = dArray[n][n5] - dArray[kdTreeNode.indexOfThisPoint][n5];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (kdTreeNode.indexOfThisPoint != n && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n3;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode3, n2 + 1, d, bl);
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(int n, double d, int n2, boolean bl) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(n, this.rootNode, 0, d, n2, bl);
    }

    protected int countPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        double d2 = dArray[n][n6] - dArray[kdTreeNode.indexOfThisPoint][n6];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (Math.abs(kdTreeNode.indexOfThisPoint - n) > n3 && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n4;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 += this.countPointsWithinR(n, kdTreeNode2, n2 + 1, d, n3, bl);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n4 += this.countPointsWithinR(n, kdTreeNode3, n2 + 1, d, n3, bl);
        }
        return n4;
    }

    @Override
    public int countPointsWithinR(double[][] dArray, double d, boolean bl) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(dArray, this.rootNode, 0, d, bl);
    }

    protected int countPointsWithinR(double[][] dArray, KdTreeNode kdTreeNode, int n, double d, boolean bl) {
        int n2 = 0;
        int n3 = n % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        int n5 = this.dimensionToVariableNumber[n3];
        double d2 = dArray[n5][n4] - dArray2[kdTreeNode.indexOfThisPoint][n4];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (d3 < d || bl && d3 == d) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n2;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n2 += this.countPointsWithinR(dArray, kdTreeNode2, n + 1, d, bl);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n2 += this.countPointsWithinR(dArray, kdTreeNode3, n + 1, d, bl);
        }
        return n2;
    }

    @Override
    public Collection<NeighbourNodeData> findPointsWithinR(int n, double d, boolean bl) {
        Vector<NeighbourNodeData> vector = new Vector<NeighbourNodeData>();
        if (this.rootNode == null) {
            return vector;
        }
        this.findPointsWithinR(n, this.rootNode, 0, d, bl, vector);
        return vector;
    }

    protected void findPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl, Collection<NeighbourNodeData> collection) {
        Object object;
        int n3 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        double d2 = dArray[n][n4] - dArray[kdTreeNode.indexOfThisPoint][n4];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (kdTreeNode.indexOfThisPoint != n && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d5 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                collection.add(new NeighbourNodeData(kdTreeNode.indexOfThisPoint, (double[])object, d4));
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            this.findPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl, collection);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            this.findPointsWithinR(n, (KdTreeNode)object, n2 + 1, d, bl, collection);
        }
    }

    @Override
    public void findPointsWithinR(int n, double d, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            nArray[0] = -1;
            return;
        }
        int n2 = this.findPointsWithinR(n, this.rootNode, 0, d, bl, blArray, nArray, 0);
        nArray[n2] = -1;
    }

    protected int findPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl, boolean[] blArray, int[] nArray, int n3) {
        Object object;
        int n4 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        double d2 = dArray[n][n5] - dArray[kdTreeNode.indexOfThisPoint][n5];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (kdTreeNode.indexOfThisPoint != n && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d5 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                nArray[n3++] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 = this.findPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl, blArray, nArray, n3);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            n3 = this.findPointsWithinR(n, (KdTreeNode)object, n2 + 1, d, bl, blArray, nArray, n3);
        }
        return n3;
    }

    @Override
    public void findPointsWithinR(int n, double d, int n2, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            nArray[0] = -1;
            return;
        }
        int n3 = this.findPointsWithinR(n, this.rootNode, 0, d, n2, bl, blArray, nArray, 0);
        nArray[n3] = -1;
    }

    protected int findPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, int n3, boolean bl, boolean[] blArray, int[] nArray, int n4) {
        Object object;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        double d2 = dArray[n][n6] - dArray[kdTreeNode.indexOfThisPoint][n6];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (Math.abs(kdTreeNode.indexOfThisPoint - n) > n3 && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d5 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                nArray[n4++] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 = this.findPointsWithinR(n, kdTreeNode2, n2 + 1, d, n3, bl, blArray, nArray, n4);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            n4 = this.findPointsWithinR(n, (KdTreeNode)object, n2 + 1, d, n3, bl, blArray, nArray, n4);
        }
        return n4;
    }

    @Override
    public int findPointsWithinR(int n, double d, int n2, boolean bl, boolean[] blArray, double[] dArray, double[][] dArray2) {
        if (this.rootNode == null) {
            dArray2[0][1] = -1.0;
            return 0;
        }
        int n3 = this.findPointsWithinR(n, this.rootNode, 0, d, n2, bl, blArray, dArray, dArray2, 0);
        dArray2[n3][1] = -1.0;
        return n3;
    }

    protected int findPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, int n3, boolean bl, boolean[] blArray, double[] dArray, double[][] dArray2, int n4) {
        Object object;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray3 = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        double d2 = dArray3[n][n6] - dArray3[kdTreeNode.indexOfThisPoint][n6];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (Math.abs(kdTreeNode.indexOfThisPoint - n) > n3 && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d5 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                dArray[kdTreeNode.indexOfThisPoint] = d4;
                dArray2[n4][0] = d4;
                dArray2[n4++][1] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 = this.findPointsWithinR(n, kdTreeNode2, n2 + 1, d, n3, bl, blArray, dArray, dArray2, n4);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            n4 = this.findPointsWithinR(n, (KdTreeNode)object, n2 + 1, d, n3, bl, blArray, dArray, dArray2, n4);
        }
        return n4;
    }

    public int findPointsWithinRAndTakeRadiusMax(int n, double d, int n2, boolean bl, int n3, boolean[] blArray, double[] dArray, double[][] dArray2) {
        if (this.rootNode == null) {
            dArray2[0][1] = -1.0;
            return 0;
        }
        int n4 = this.findPointsWithinRAndTakeRadiusMax(n, this.rootNode, 0, d, n2, bl, n3, blArray, dArray, dArray2, 0);
        dArray2[n4][1] = -1.0;
        return n4;
    }

    protected int findPointsWithinRAndTakeRadiusMax(int n, KdTreeNode kdTreeNode, int n2, double d, int n3, boolean bl, int n4, boolean[] blArray, double[] dArray, double[][] dArray2, int n5) {
        Object object;
        int n6 = n2 % this.totalDimensions;
        double[][] dArray3 = this.dimensionToArray[n6];
        int n7 = this.dimensionToArrayIndex[n6];
        double d2 = dArray3[n][n7] - dArray3[kdTreeNode.indexOfThisPoint][n7];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (blArray[kdTreeNode.indexOfThisPoint] && Math.abs(kdTreeNode.indexOfThisPoint - n) > n3 && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                if (i == n4) continue;
                double d5 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                if (d4 < dArray[kdTreeNode.indexOfThisPoint]) {
                    d4 = dArray[kdTreeNode.indexOfThisPoint];
                }
                dArray2[n5][0] = d4;
                dArray2[n5++][1] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n5 = this.findPointsWithinRAndTakeRadiusMax(n, kdTreeNode2, n2 + 1, d, n3, bl, n4, blArray, dArray, dArray2, n5);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            n5 = this.findPointsWithinRAndTakeRadiusMax(n, (KdTreeNode)object, n2 + 1, d, n3, bl, n4, blArray, dArray, dArray2, n5);
        }
        return n5;
    }

    @Override
    public void findPointsWithinR(double d, double[][] dArray, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            nArray[0] = -1;
            return;
        }
        int n = this.findPointsWithinR(dArray, this.rootNode, 0, d, bl, blArray, nArray, 0);
        nArray[n] = -1;
    }

    protected int findPointsWithinR(double[][] dArray, KdTreeNode kdTreeNode, int n, double d, boolean bl, boolean[] blArray, int[] nArray, int n2) {
        Object object;
        int n3 = n % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        int n5 = this.dimensionToVariableNumber[n3];
        double d2 = dArray[n5][n4] - dArray2[kdTreeNode.indexOfThisPoint][n4];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (d3 < d || bl && d3 == d) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d4 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d5 = KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (d5 >= d && (!bl || d5 != d)) {
                    bl2 = false;
                    break;
                }
                object[i] = d5;
                if (!(d5 > d4)) continue;
                d4 = d5;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                nArray[n2++] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n2 = this.findPointsWithinR(dArray, kdTreeNode2, n + 1, d, bl, blArray, nArray, n2);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && object != null) {
            n2 = this.findPointsWithinR(dArray, (KdTreeNode)object, n + 1, d, bl, blArray, nArray, n2);
        }
        return n2;
    }

    public int countPointsWithinR(int n, double d, boolean bl, int n2, boolean[] blArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(n, this.rootNode, 0, d, bl, n2, blArray);
    }

    public int countPointsStrictlyWithinR(int n, double d, int n2, boolean[] blArray) {
        return this.countPointsWithinR(n, d, false, n2, blArray);
    }

    public int countPointsWithinOrOnR(int n, double d, int n2, boolean[] blArray) {
        return this.countPointsWithinR(n, d, true, n2, blArray);
    }

    protected int countPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl, int n3, boolean[] blArray) {
        int n4 = 0;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        int n7 = this.dimensionToVariableNumber[n5];
        double d2 = dArray[n][n6] - dArray[kdTreeNode.indexOfThisPoint][n6];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (blArray[kdTreeNode.indexOfThisPoint] && kdTreeNode.indexOfThisPoint != n && (n7 == n3 || d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4;
                if (i == n3 || !((d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse)) >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n4;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 += this.countPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl, n3, blArray);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n4 += this.countPointsWithinR(n, kdTreeNode3, n2 + 1, d, bl, n3, blArray);
        }
        return n4;
    }

    public int countPointsWithinR(double d, double[][] dArray, boolean bl, int n, boolean[] blArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(dArray, this.rootNode, 0, d, bl, n, blArray);
    }

    protected int countPointsWithinR(double[][] dArray, KdTreeNode kdTreeNode, int n, double d, boolean bl, int n2, boolean[] blArray) {
        int n3 = 0;
        int n4 = n % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        int n6 = this.dimensionToVariableNumber[n4];
        double d2 = dArray[n6][n5] - dArray2[kdTreeNode.indexOfThisPoint][n5];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (blArray[kdTreeNode.indexOfThisPoint] && (n6 == n2 || d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4;
                if (i == n2 || !((d4 = KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse)) >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n3;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 += this.countPointsWithinR(dArray, kdTreeNode2, n + 1, d, bl, n2, blArray);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n3 += this.countPointsWithinR(dArray, kdTreeNode3, n + 1, d, bl, n2, blArray);
        }
        return n3;
    }

    public void findPointsWithinRs(int n, double[] dArray, int n2, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            nArray[0] = -1;
            return;
        }
        int n3 = this.findPointsWithinRs(n, this.rootNode, 0, dArray, n2, bl, blArray, nArray, 0);
        nArray[n3] = -1;
    }

    protected int findPointsWithinRs(int n, KdTreeNode kdTreeNode, int n2, double[] dArray, int n3, boolean bl, boolean[] blArray, int[] nArray, int n4) {
        Object object;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        int n7 = this.dimensionToVariableNumber[n5];
        double d = dArray2[n][n6] - dArray2[kdTreeNode.indexOfThisPoint][n6];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        if (Math.abs(kdTreeNode.indexOfThisPoint - n) > n3 && (d2 < dArray[n7] || bl && d2 == dArray[n7])) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d3 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], dArray[i], this.normTypeToUse);
                if (d4 >= dArray[i] && (!bl || d4 != dArray[i])) {
                    bl2 = false;
                    break;
                }
                object[i] = d4;
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                nArray[n4++] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 = this.findPointsWithinRs(n, kdTreeNode2, n2 + 1, dArray, n3, bl, blArray, nArray, n4);
        }
        if ((d2 < dArray[n7] || bl && d < 0.0 && d2 == dArray[n7]) && object != null) {
            n4 = this.findPointsWithinRs(n, (KdTreeNode)object, n2 + 1, dArray, n3, bl, blArray, nArray, n4);
        }
        return n4;
    }

    public void findPointsWithinRs(double[] dArray, double[][] dArray2, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            nArray[0] = -1;
            return;
        }
        int n = this.findPointsWithinRs(dArray2, this.rootNode, 0, dArray, bl, blArray, nArray, 0);
        nArray[n] = -1;
    }

    protected int findPointsWithinRs(double[][] dArray, KdTreeNode kdTreeNode, int n, double[] dArray2, boolean bl, boolean[] blArray, int[] nArray, int n2) {
        Object object;
        int n3 = n % this.totalDimensions;
        double[][] dArray3 = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        int n5 = this.dimensionToVariableNumber[n3];
        double d = dArray[n5][n4] - dArray3[kdTreeNode.indexOfThisPoint][n4];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        if (d2 < dArray2[n5] || bl && d2 == dArray2[n5]) {
            boolean bl2 = true;
            object = new double[this.originalDataSets.length];
            double d3 = 0.0;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], dArray2[i], this.normTypeToUse);
                if (d4 >= dArray2[i] && (!bl || d4 != dArray2[i])) {
                    bl2 = false;
                    break;
                }
                object[i] = d4;
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
            if (bl2) {
                blArray[kdTreeNode.indexOfThisPoint] = true;
                nArray[n2++] = kdTreeNode.indexOfThisPoint;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        object = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            object = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            object = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n2 = this.findPointsWithinRs(dArray, kdTreeNode2, n + 1, dArray2, bl, blArray, nArray, n2);
        }
        if ((d2 < dArray2[n5] || bl && d < 0.0 && d2 == dArray2[n5]) && object != null) {
            n2 = this.findPointsWithinRs(dArray, (KdTreeNode)object, n + 1, dArray2, bl, blArray, nArray, n2);
        }
        return n2;
    }

    public int countPointsWithinRs(int n, double[] dArray, boolean bl, int n2, boolean[] blArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinRs(n, this.rootNode, 0, dArray, bl, n2, blArray);
    }

    public int countPointsStrictlyWithinRs(int n, double[] dArray, int n2, boolean[] blArray) {
        return this.countPointsWithinRs(n, dArray, false, n2, blArray);
    }

    public int countPointsWithinOrOnRs(int n, double[] dArray, int n2, boolean[] blArray) {
        return this.countPointsWithinRs(n, dArray, true, n2, blArray);
    }

    protected int countPointsWithinRs(int n, KdTreeNode kdTreeNode, int n2, double[] dArray, boolean bl, int n3, boolean[] blArray) {
        int n4 = 0;
        int n5 = n2 % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n5];
        int n6 = this.dimensionToArrayIndex[n5];
        int n7 = this.dimensionToVariableNumber[n5];
        double d = dArray2[n][n6] - dArray2[kdTreeNode.indexOfThisPoint][n6];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        if (blArray[kdTreeNode.indexOfThisPoint] && kdTreeNode.indexOfThisPoint != n && (n7 == n3 || d2 < dArray[n7] || bl && d2 == dArray[n7])) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d3;
                if (i == n3 || !((d3 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], dArray[i], this.normTypeToUse)) >= dArray[i]) || bl && d3 == dArray[i]) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n4;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n4 += this.countPointsWithinRs(n, kdTreeNode2, n2 + 1, dArray, bl, n3, blArray);
        }
        if ((d2 < dArray[n7] || bl && d < 0.0 && d2 == dArray[n7]) && kdTreeNode3 != null) {
            n4 += this.countPointsWithinRs(n, kdTreeNode3, n2 + 1, dArray, bl, n3, blArray);
        }
        return n4;
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl, boolean[] blArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(n, this.rootNode, 0, d, bl, blArray);
    }

    protected int countPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl, boolean[] blArray) {
        int n3 = 0;
        int n4 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        double d2 = dArray[n][n5] - dArray[kdTreeNode.indexOfThisPoint][n5];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (kdTreeNode.indexOfThisPoint != n && (d3 < d || bl && d3 == d) && blArray[kdTreeNode.indexOfThisPoint]) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n3;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl, blArray);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode3, n2 + 1, d, bl, blArray);
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(int n, double d, boolean bl, boolean[] blArray, int[] nArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(n, this.rootNode, 0, d, bl, blArray, nArray);
    }

    protected int countPointsWithinR(int n, KdTreeNode kdTreeNode, int n2, double d, boolean bl, boolean[] blArray, int[] nArray) {
        int n3 = 0;
        int n4 = n2 % this.totalDimensions;
        double[][] dArray = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        double d2 = dArray[n][n5] - dArray[kdTreeNode.indexOfThisPoint][n5];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (kdTreeNode.indexOfThisPoint != n && (d3 < d || bl && d3 == d) && blArray[nArray[kdTreeNode.indexOfThisPoint]]) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n3;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode2, n2 + 1, d, bl, blArray, nArray);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n3 += this.countPointsWithinR(n, kdTreeNode3, n2 + 1, d, bl, blArray, nArray);
        }
        return n3;
    }

    @Override
    public int countPointsWithinR(double[][] dArray, double d, boolean bl, boolean[] blArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinR(dArray, this.rootNode, 0, d, bl, blArray);
    }

    protected int countPointsWithinR(double[][] dArray, KdTreeNode kdTreeNode, int n, double d, boolean bl, boolean[] blArray) {
        int n2 = 0;
        int n3 = n % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n3];
        int n4 = this.dimensionToArrayIndex[n3];
        int n5 = this.dimensionToVariableNumber[n3];
        double d2 = dArray[n5][n4] - dArray2[kdTreeNode.indexOfThisPoint][n4];
        double d3 = this.normTypeToUse == 2 ? (d2 > 0.0 ? d2 : -d2) : d2 * d2;
        if (blArray[kdTreeNode.indexOfThisPoint] && (d3 < d || bl && d3 == d)) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d4 = KdTree.normWithAbort(dArray[i], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], d, this.normTypeToUse);
                if (!(d4 >= d) || bl && d4 == d) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n2;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d2 < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n2 += this.countPointsWithinR(dArray, kdTreeNode2, n + 1, d, bl, blArray);
        }
        if ((d3 < d || bl && d2 < 0.0 && d3 == d) && kdTreeNode3 != null) {
            n2 += this.countPointsWithinR(dArray, kdTreeNode3, n + 1, d, bl, blArray);
        }
        return n2;
    }

    public int countPointsWithinRs(int n, double[] dArray, boolean bl) {
        if (bl) {
            return this.countPointsWithinOrOnRs(n, dArray);
        }
        return this.countPointsStrictlyWithinRs(n, dArray);
    }

    public int countPointsStrictlyWithinRs(int n, double[] dArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinRs(n, this.rootNode, 0, dArray, false);
    }

    public int countPointsWithinOrOnRs(int n, double[] dArray) {
        if (this.rootNode == null) {
            return 0;
        }
        return this.countPointsWithinRs(n, this.rootNode, 0, dArray, true);
    }

    protected int countPointsWithinRs(int n, KdTreeNode kdTreeNode, int n2, double[] dArray, boolean bl) {
        int n3 = 0;
        int n4 = n2 % this.totalDimensions;
        double[][] dArray2 = this.dimensionToArray[n4];
        int n5 = this.dimensionToArrayIndex[n4];
        int n6 = this.dimensionToVariableNumber[n4];
        double d = dArray2[n][n5] - dArray2[kdTreeNode.indexOfThisPoint][n5];
        double d2 = this.normTypeToUse == 2 ? (d > 0.0 ? d : -d) : d * d;
        if (kdTreeNode.indexOfThisPoint != n && (d2 < dArray[n6] || bl && d2 == dArray[n6])) {
            boolean bl2 = true;
            for (int i = 0; i < this.originalDataSets.length; ++i) {
                double d3 = KdTree.normWithAbort(this.originalDataSets[i][n], this.originalDataSets[i][kdTreeNode.indexOfThisPoint], dArray[i], this.normTypeToUse);
                if (!(d3 >= dArray[i]) || bl && d3 == dArray[i]) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ++n3;
            }
        }
        KdTreeNode kdTreeNode2 = null;
        KdTreeNode kdTreeNode3 = null;
        if (d < 0.0) {
            kdTreeNode2 = kdTreeNode.leftTree;
            kdTreeNode3 = kdTreeNode.rightTree;
        } else {
            kdTreeNode2 = kdTreeNode.rightTree;
            kdTreeNode3 = kdTreeNode.leftTree;
        }
        if (kdTreeNode2 != null) {
            n3 += this.countPointsWithinRs(n, kdTreeNode2, n2 + 1, dArray, bl);
        }
        if ((d2 < dArray[n6] || bl && d < 0.0 && d2 == dArray[n6]) && kdTreeNode3 != null) {
            n3 += this.countPointsWithinRs(n, kdTreeNode3, n2 + 1, dArray, bl);
        }
        return n3;
    }

    public void print() {
        this.print(this.rootNode, 0);
    }

    protected void print(KdTreeNode kdTreeNode, int n) {
        int n2;
        if (kdTreeNode == null) {
            System.out.print("null");
            return;
        }
        if (n > 0) {
            System.out.println();
        }
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("\t");
        }
        System.out.print("((");
        for (n2 = 0; n2 < this.totalDimensions; ++n2) {
            System.out.printf("%.3f,", this.dimensionToArray[n2][kdTreeNode.indexOfThisPoint][this.dimensionToArrayIndex[n2]]);
        }
        System.out.print("),");
        this.print(kdTreeNode.leftTree, n + 1);
        System.out.print(", ");
        this.print(kdTreeNode.rightTree, n + 1);
        System.out.println(")");
    }

    protected class KdTreeNode {
        protected int indexOfThisPoint;
        protected KdTreeNode leftTree;
        protected KdTreeNode rightTree;

        protected KdTreeNode(int n, KdTreeNode kdTreeNode, KdTreeNode kdTreeNode2) {
            this.indexOfThisPoint = n;
            this.leftTree = kdTreeNode;
            this.rightTree = kdTreeNode2;
        }
    }
}

