/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.random;

import infodynamics.utils.commonsmath3.random.BitsStreamGenerator;
import infodynamics.utils.commonsmath3.util.FastMath;
import java.io.Serializable;

public abstract class AbstractWell
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = -817701723016583596L;
    protected int index;
    protected final int[] v;
    protected final int[] iRm1;
    protected final int[] iRm2;
    protected final int[] i1;
    protected final int[] i2;
    protected final int[] i3;

    protected AbstractWell(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, null);
    }

    protected AbstractWell(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, new int[]{n5});
    }

    protected AbstractWell(int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = (n + 32 - 1) / 32;
        this.v = new int[n5];
        this.index = 0;
        this.iRm1 = new int[n5];
        this.iRm2 = new int[n5];
        this.i1 = new int[n5];
        this.i2 = new int[n5];
        this.i3 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            this.iRm1[i] = (i + n5 - 1) % n5;
            this.iRm2[i] = (i + n5 - 2) % n5;
            this.i1[i] = (i + n2) % n5;
            this.i2[i] = (i + n3) % n5;
            this.i3[i] = (i + n4) % n5;
        }
        this.setSeed(nArray);
    }

    protected AbstractWell(int n, int n2, int n3, int n4, long l) {
        this(n, n2, n3, n4, new int[]{(int)(l >>> 32), (int)(l & 0xFFFFFFFFL)});
    }

    @Override
    public void setSeed(int n) {
        this.setSeed(new int[]{n});
    }

    @Override
    public void setSeed(int[] nArray) {
        if (nArray == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        System.arraycopy(nArray, 0, this.v, 0, FastMath.min(nArray.length, this.v.length));
        if (nArray.length < this.v.length) {
            for (int i = nArray.length; i < this.v.length; ++i) {
                long l = this.v[i - nArray.length];
                this.v[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
        this.clear();
    }

    @Override
    public void setSeed(long l) {
        this.setSeed(new int[]{(int)(l >>> 32), (int)(l & 0xFFFFFFFFL)});
    }

    @Override
    protected abstract int next(int var1);
}

