"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetSettlementRefundsQueryParamInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    PAYMENT = "payment"


class GetSettlementRefundsRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    include: NotRequired[Nullable[GetSettlementRefundsQueryParamInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetSettlementRefundsRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    include: Annotated[
        OptionalNullable[GetSettlementRefundsQueryParamInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "include", "testmode"]
        nullable_fields = ["limit", "include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementRefundsSettlementsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementRefundsSettlementsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementRefundsSettlementsResponseLinksTypedDict(TypedDict):
    documentation: GetSettlementRefundsSettlementsResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsSettlementsResponseLinks(BaseModel):
    documentation: GetSettlementRefundsSettlementsResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsSettlementsResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        GetSettlementRefundsSettlementsResponseLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetSettlementRefundsSettlementsResponseResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementRefundsSettlementsResponseResponseBodyData

    def __init__(self, data: GetSettlementRefundsSettlementsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementRefundsSettlementsResponseResponseBodyData
        )


class GetSettlementRefundsSettlementsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementRefundsSettlementsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementRefundsSettlementsLinksTypedDict(TypedDict):
    documentation: GetSettlementRefundsSettlementsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsSettlementsLinks(BaseModel):
    documentation: GetSettlementRefundsSettlementsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementRefundsSettlementsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        GetSettlementRefundsSettlementsLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetSettlementRefundsSettlementsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementRefundsSettlementsResponseBodyData

    def __init__(self, data: GetSettlementRefundsSettlementsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementRefundsSettlementsResponseBodyData
        )


class GetSettlementRefundsAmountTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsAmount(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsMetadata2TypedDict(TypedDict):
    pass


class GetSettlementRefundsMetadata2(BaseModel):
    pass


GetSettlementRefundsMetadataTypedDict = TypeAliasType(
    "GetSettlementRefundsMetadataTypedDict",
    Union[GetSettlementRefundsMetadata2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


GetSettlementRefundsMetadata = TypeAliasType(
    "GetSettlementRefundsMetadata", Union[GetSettlementRefundsMetadata2, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class GetSettlementRefundsExternalReferenceTypedDict(TypedDict):
    type: NotRequired[str]
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class GetSettlementRefundsExternalReference(BaseModel):
    type: Optional[str] = None
    r"""Specifies the reference type

    Possible values: `acquirer-reference`
    """

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class GetSettlementRefundsSettlementsAmountTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsSettlementsAmount(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementRefundsSourceTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled back from."""


class GetSettlementRefundsSource(BaseModel):
    r"""Where the funds will be pulled back from."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled back from."""


class GetSettlementRefundsRoutingReversalsTypedDict(TypedDict):
    amount: NotRequired[GetSettlementRefundsSettlementsAmountTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[GetSettlementRefundsSourceTypedDict]
    r"""Where the funds will be pulled back from."""


class GetSettlementRefundsRoutingReversals(BaseModel):
    amount: Optional[GetSettlementRefundsSettlementsAmount] = None
    r"""The amount that will be pulled back."""

    source: Optional[GetSettlementRefundsSource] = None
    r"""Where the funds will be pulled back from."""


class GetSettlementRefundsSettlementsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlementsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlementsResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlementsResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSettlementsResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementRefundsSettlementsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: NotRequired[GetSettlementRefundsPaymentTypedDict]
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""
    settlement: NotRequired[Nullable[GetSettlementRefundsSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""
    documentation: NotRequired[
        GetSettlementRefundsSettlementsResponse200DocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementRefundsSettlementsResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementRefundsSettlementsSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: Optional[GetSettlementRefundsPayment] = None
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    settlement: OptionalNullable[GetSettlementRefundsSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not yet settled."""

    documentation: Optional[GetSettlementRefundsSettlementsResponse200Documentation] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "payment", "settlement", "documentation"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementRefundsRefundsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[GetSettlementRefundsAmountTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""
    settlement_amount: NotRequired[
        Nullable[GetSettlementRefundsSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[GetSettlementRefundsMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this refund was created for. The full payment object can be retrieved via the payment URL in the `_links` object."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[str]
    r"""Refunds may take some time to get confirmed.

    Possible values: `queued` `pending` `processing` `refunded` `failed` `canceled`
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    external_reference: NotRequired[GetSettlementRefundsExternalReferenceTypedDict]
    routing_reversals: NotRequired[
        Nullable[List[GetSettlementRefundsRoutingReversalsTypedDict]]
    ]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    links: NotRequired[GetSettlementRefundsSettlementsResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementRefundsRefunds(BaseModel):
    resource: Optional[str] = "refund"
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie will always refer to the refund by this ID. Example: `re_4qqhO89gsT`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[GetSettlementRefundsAmount] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment amount."""

    settlement_amount: Annotated[
        OptionalNullable[GetSettlementRefundsSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[GetSettlementRefundsMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this refund was created for. The full payment object can be retrieved via the payment URL in the `_links` object."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""

    status: Optional[str] = None
    r"""Refunds may take some time to get confirmed.

    Possible values: `queued` `pending` `processing` `refunded` `failed` `canceled`
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    external_reference: Annotated[
        Optional[GetSettlementRefundsExternalReference],
        pydantic.Field(alias="externalReference"),
    ] = None

    routing_reversals: Annotated[
        OptionalNullable[List[GetSettlementRefundsRoutingReversals]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    links: Annotated[
        Optional[GetSettlementRefundsSettlementsResponse200Links],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "metadata",
            "paymentId",
            "settlementId",
            "status",
            "createdAt",
            "externalReference",
            "routingReversals",
            "_links",
        ]
        nullable_fields = [
            "settlementAmount",
            "metadata",
            "settlementId",
            "routingReversals",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementRefundsEmbeddedTypedDict(TypedDict):
    refunds: NotRequired[List[GetSettlementRefundsRefundsTypedDict]]
    r"""An array of refund objects."""


class GetSettlementRefundsEmbedded(BaseModel):
    refunds: Optional[List[GetSettlementRefundsRefunds]] = None
    r"""An array of refund objects."""


class GetSettlementRefundsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementRefundsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[GetSettlementRefundsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[GetSettlementRefundsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[GetSettlementRefundsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementRefundsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementRefundsSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[GetSettlementRefundsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[GetSettlementRefundsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[GetSettlementRefundsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementRefundsResponseBodyTypedDict(TypedDict):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[GetSettlementRefundsEmbeddedTypedDict]
    links: NotRequired[GetSettlementRefundsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class GetSettlementRefundsResponseBody(BaseModel):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[GetSettlementRefundsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[GetSettlementRefundsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
