def convert_dict(prop_idents) -> dict:
    """
    Transfet the dict generated by sparql.py, store them in the format of:
    {
      "123" : [ "P345/Q123", "P789/Q234" ],
     "453" : [ "P789/Q43", "P256/Q456", "P31/Q567" ],
      ...
    }
    :param prop_idents:
    :return:
    """
    identifier_nodes_dict = {}
    count = 0
    keys = set()
    for P_number,p_entity in prop_idents.items():
        count += 1
        print(P_number,count)
        for identi,Q_number in p_entity.items():
            #if identi in identifier_nodes_dict.keys():
            if identi in keys:
                identifier_nodes_dict[identi].append(P_number + '/' + Q_number)
            else:
                keys.add(identi)
                identifier_nodes_dict[identi] = [P_number + '/' + Q_number]
    return identifier_nodes_dict


def dict_slice(dict_input, start, end) -> dict:
    """
    take slice for python dict
    :param dict_input: a dict for slicing
    :param start: start position for splicing
    :param end: end position for slicing
    :return: the sliced dict
    """
    keys = dict_input.keys()
    dict_slice = {}
    for k in keys[start:end]:
        dict_slice[k] = dict_input[k]
    return dict_slice
