metadata_wikipedia = {
  "datamart_id": 0,
  "title": "List of United States counties by per capita income",
  "description": "List of United States counties by per capita income",
  "url": "https://github.com/usc-isi-i2/wikidata-wikifier/raw/master/example/List_of_United_States_counties_by_per_capita_income.csv",
  "materialization": {
    "python_path": "general_materializer",
    "arguments": {
      "url": "https://github.com/usc-isi-i2/wikidata-wikifier/raw/master/example/List_of_United_States_counties_by_per_capita_income.csv",
      "file_type": "csv",
      "index": 0
    }
  },
  "variables": [
    {
      "datamart_id": 1,
      "semantic_type": [],
      "name": "Rank",
      "description": "column name: Rank, dtype: int64"
    },
    {
      "datamart_id": 2,
      "semantic_type": [],
      "name": "County-area",
      "description": "column name: County-area, dtype: object",
      "named_entity": [
        "New York County",
        "Arlington",
        "Falls Church City",
        "Marin",
        "Alexandria City",
        "Pitkin",
        "Los Alamos",
        "Fairfax County",
        "Hunterdon",
        "Borden",
        "Montgomery",
        "Morris",
        "Fairfield",
        "San Francisco",
        "Howard",
        "Westchester",
        "Somerset",
        "Nantucket",
        "Loudoun",
        "North Slope",
        "San Mateo",
        "Kalawao",
        "Washington City",
        "Goochland",
        "Norfolk",
        "Fairfax City",
        "Douglas",
        "Teton",
        "Bergen",
        "Middlesex",
        "Monmouth",
        "Summit",
        "Nassau",
        "Mineral",
        "Chester",
        "Ozaukee",
        "Clear Creek",
        "Santa Clara",
        "Williamson",
        "San Miguel",
        "Anne Arundel",
        "Putnam",
        "Newport",
        "Delaware County",
        "King",
        "Fauquier",
        "Hamilton",
        "Eagle",
        "James City County",
        "Bristol",
        "Johnson",
        "Clarke",
        "Williams",
        "DuPage",
        "Poquoson City",
        "Rockingham",
        "Calvert",
        "Contra Costa",
        "Queen Anne's",
        "Gilpin",
        "Talbot",
        "Lake",
        "Boulder",
        "Billings",
        "Sussex",
        "Collin",
        "San Juan",
        "Litchfield",
        "Waukesha",
        "Juneau",
        "Hennepin",
        "Boone",
        "Bucks",
        "Mercer",
        "Carver",
        "Broomfield",
        "Prince William",
        "Charles",
        "Albemarle",
        "Skagway",
        "Bristol Bay",
        "Washington County",
        "Suffolk",
        "Frederick",
        "St. Johns",
        "Burlington",
        "Fulton",
        "Stafford",
        "Rappahannock",
        "Oakland",
        "Collier",
        "York",
        "Hinsdale",
        "Divide",
        "Anchorage",
        "Roberts",
        "Union",
        "Carroll",
        "Barnstable",
        "Jefferson",
        "Elbert",
        "St. Mary's",
        "Sublette",
        "Dallas",
        "Kendall",
        "Alameda",
        "Blaine",
        "Scott",
        "Harford",
        "Fayette",
        "Denali",
        "Plymouth",
        "Saratoga",
        "Essex",
        "Platte",
        "Placer",
        "El Dorado",
        "Routt",
        "Lincoln",
        "Dakota",
        "Napa",
        "St. Louis County",
        "Hartford",
        "Rockwall",
        "Rockland",
        "Forsyth",
        "Orange",
        "Geauga",
        "Tolland",
        "Hillsborough",
        "Baltimore County",
        "Yakutat",
        "King George",
        "Petersburg Census Area",
        "Fort Bend",
        "Olmsted",
        "Loving",
        "Martin",
        "Monroe",
        "Denton",
        "Campbell",
        "Kent",
        "Mountrail",
        "Oconee",
        "Dunn",
        "New London",
        "Dane",
        "Midland",
        "Llano",
        "Columbia",
        "Dutchess",
        "Oldham",
        "Warren",
        "Hanover",
        "Storey",
        "Dukes",
        "Towner",
        "Shelby",
        "Chittenden",
        "Denver",
        "Washtenaw",
        "Travis",
        "Madison",
        "Wake",
        "Grand Isle",
        "Henrico",
        "McKenzie",
        "Cobb",
        "Foster",
        "Ouray",
        "Comal",
        "Cape May",
        "Ventura",
        "Burke",
        "Worcester",
        "Cumberland",
        "Burleigh",
        "Cook",
        "Palm Beach",
        "Sonoma",
        "Clackamas",
        "Greeley",
        "Hudson",
        "Gloucester",
        "Arapahoe",
        "Valdez-Cordova Census Area",
        "Chesterfield",
        "New Haven",
        "Sitka",
        "Beaufort",
        "Botetourt",
        "Mecklenburg",
        "New Castle",
        "Nevada County",
        "Prince George's",
        "McHenry",
        "Albany",
        "Sarasota",
        "Santa Fe",
        "Santa Cruz",
        "Oliver",
        "St. Croix",
        "Fairbanks North Star",
        "Livingston",
        "New Kent",
        "Bowman",
        "Richland",
        "Cavalier",
        "LaMoure",
        "Bottineau",
        "Virginia Beach City",
        "Richmond",
        "Aleutians West Census Area",
        "Dickinson",
        "Kitsap",
        "Roanoke County",
        "Barnes",
        "Lane",
        "Grand",
        "Allegheny",
        "Ketchikan Gateway",
        "St. Charles",
        "Terrell",
        "Sioux",
        "Park",
        "Adams",
        "Harris",
        "Leelanau",
        "Steele",
        "Daniels",
        "Stark",
        "Sheridan",
        "Spotsylvania",
        "Snohomish",
        "Mathews",
        "Merrimack",
        "Miner",
        "Kenai Peninsula",
        "Powhatan",
        "Piatt",
        "Renville",
        "Chatham",
        "Grundy",
        "Glasscock",
        "Haines",
        "Teller",
        "McLean",
        "Butler",
        "Converse",
        "Island",
        "Stanley",
        "Windsor",
        "Woodford",
        "Galveston",
        "Audubon",
        "Isle of Wight",
        "Fluvanna",
        "Larimer",
        "Grafton",
        "Lancaster",
        "Medina",
        "Parker",
        "San Diego",
        "Door",
        "Anoka",
        "Camden",
        "Slope",
        "Indian River",
        "Dare",
        "Cass",
        "Belknap",
        "Sweetwater",
        "Ocean",
        "Multnomah",
        "Polk",
        "Ulster",
        "Hodgeman",
        "Nelson",
        "Will",
        "St. Tammany",
        "Honolulu",
        "Santa Barbara",
        "Hughes",
        "Ness",
        "Sully",
        "Sarpy",
        "Charleston",
        "La Plata",
        "Chambers",
        "Gillespie",
        "Thomas",
        "Wheeler",
        "Kane",
        "Hood",
        "Greene",
        "Saunders",
        "Goliad",
        "Rensselaer",
        "Sangamon",
        "San Luis Obispo",
        "Sargent",
        "Linn",
        "Goodhue",
        "Warrick",
        "Chesapeake City",
        "Ontario",
        "Natrona",
        "Hendricks",
        "Plumas",
        "Lander",
        "Archuleta",
        "Thurston",
        "Emmet",
        "New Hanover",
        "Jo Daviess",
        "Wright",
        "Cherokee",
        "Montour",
        "Cameron",
        "Hemphill",
        "Matanuska-Susitna",
        "Cecil",
        "Maui",
        "Ramsey",
        "Hampshire",
        "Southeast Fairbanks Census Area",
        "Clay",
        "Morton",
        "Strafford",
        "Durham",
        "Calaveras",
        "Wells",
        "Berkshire",
        "Northampton",
        "Pinellas",
        "Franklin",
        "Dauphin",
        "Bennington",
        "Posey",
        "Suffolk City",
        "Pope",
        "Kossuth",
        "Randall",
        "Dodge",
        "Brazoria",
        "Walsh",
        "Lipscomb",
        "Gallatin",
        "Solano",
        "Moore",
        "Calumet",
        "Kidder",
        "Lafayette",
        "Stillwater",
        "El Paso",
        "Windham",
        "Sagadahoc",
        "DeKalb",
        "Hoonah-Angoon Census Area",
        "Salem",
        "Weston",
        "Clermont",
        "Manassas City",
        "Onondaga",
        "Stevens",
        "Bremer",
        "Addison",
        "Bath",
        "Bedford County",
        "Seminole",
        "Washoe",
        "Porter",
        "Okaloosa",
        "Benton",
        "Sullivan",
        "Northumberland",
        "Fallon",
        "Kodiak Island",
        "Ward",
        "Powder River",
        "Laramie",
        "Dundy",
        "Wrangell",
        "Davidson",
        "Clinton",
        "Skamania",
        "Peoria",
        "Eddy",
        "Miami",
        "Lewis and Clark",
        "Seward",
        "Elko",
        "Custer",
        "Menard",
        "Schenectady",
        "Washakie",
        "Cheyenne",
        "Wabasha",
        "Tarrant",
        "Chase",
        "Pierce",
        "Crook",
        "Broward",
        "Outagamie",
        "Ascension",
        "Kanawha",
        "Graham",
        "Knox",
        "Somervell",
        "Grant",
        "Hancock",
        "O'Brien",
        "Sherburne",
        "Iowa County",
        "Eureka",
        "Irion",
        "Westmoreland",
        "Mono",
        "Tazewell",
        "Guthrie",
        "Traverse",
        "Baylor",
        "Lac qui Parle",
        "Ottawa",
        "Erie",
        "Perkins",
        "Lehigh",
        "Chisago",
        "Hettinger",
        "Logan",
        "Clark",
        "Cheshire",
        "Wilson",
        "Pembina",
        "Archer",
        "Kearney",
        "Brewster",
        "Sumner",
        "Le Sueur",
        "Brown",
        "Yellowstone",
        "Spink",
        "Los Angeles",
        "Yolo",
        "Sutton",
        "Kenton",
        "Pike",
        "Emmons",
        "Moody",
        "Tulsa",
        "Grand Traverse",
        "Gunnison",
        "Coffey",
        "Colonial Heights City",
        "Marathon",
        "Carbon",
        "Rio Blanco",
        "Bryan",
        "Canadian",
        "Deuel",
        "Deschutes",
        "East Baton Rouge",
        "Sumter",
        "Mason",
        "Kimble",
        "Lawrence",
        "Carteret",
        "Wibaux",
        "Kingsbury",
        "McPherson",
        "Ada",
        "Murray",
        "Inyo",
        "Andrews",
        "Bossier",
        "Cuyahoga",
        "Tompkins",
        "Pulaski",
        "Atlantic",
        "Culpeper",
        "McMullen",
        "Rogers",
        "Jackson",
        "Bartholomew",
        "Stutsman",
        "Lee",
        "Amador",
        "Dawson",
        "Roger Mills",
        "Manatee",
        "Cerro Gordo",
        "Yankton",
        "Charlottesville City",
        "Maricopa",
        "Tioga",
        "Fredericksburg City",
        "Griggs",
        "Floyd",
        "Richmond City",
        "Ellis",
        "Chaffee",
        "Major",
        "McCone",
        "Lamoille",
        "Decatur",
        "Passaic",
        "Racine",
        "Walworth",
        "Henry",
        "Mills",
        "Traill",
        "Lebanon",
        "Skagit",
        "Green",
        "Dearborn",
        "Effingham",
        "Loudon",
        "Oneida",
        "Buchanan",
        "Grand Forks",
        "Leavenworth",
        "Brevard",
        "Pennington",
        "Mariposa",
        "Young",
        "Thayer",
        "Jeff Davis",
        "Louisa",
        "Winnebago",
        "Garfield",
        "Aransas",
        "Charlevoix",
        "Manassas Park City",
        "King William",
        "Fremont",
        "Kittson",
        "Sandoval",
        "Calhoun",
        "Cleveland",
        "Mitchell",
        "Rankin",
        "Rawlins",
        "Lexington",
        "Kandiyohi",
        "Hays",
        "Santa Rosa",
        "Phelps",
        "Brunswick",
        "Marshall",
        "Carson",
        "McLeod",
        "Armstrong",
        "Bernalillo",
        "Smith",
        "Niobrara",
        "Blanco",
        "Baldwin",
        "Jones",
        "Coweta",
        "Macomb",
        "Humboldt",
        "Sacramento",
        "Glynn",
        "Berks",
        "Licking",
        "Garden",
        "Bureau",
        "DeWitt",
        "Mesa",
        "Pickens",
        "Nicollet",
        "Spencer",
        "Salem City",
        "Kauai",
        "Greenville",
        "Ogle",
        "Reagan",
        "Jerauld",
        "Schoharie",
        "Eaton",
        "Cedar",
        "Oklahoma County",
        "Hot Springs",
        "Aleutians East",
        "Whatcom",
        "Crow Wing",
        "Panola",
        "Kenosha",
        "McCook",
        "Orleans",
        "Queens",
        "Iredell",
        "Guilford",
        "Rock Island",
        "Houston",
        "Coke",
        "Otter Tail",
        "Dorchester",
        "Minnehaha",
        "Highland County",
        "Fond du Lac",
        "Sac",
        "Lamar",
        "Kerr",
        "Wood",
        "Davie",
        "Osborne",
        "Providence",
        "Charlotte",
        "Granite",
        "Morgan",
        "La Crosse",
        "Berkeley",
        "Carson City",
        "Beaver",
        "Dubuque",
        "Vilas",
        "St. Clair",
        "Gove",
        "Macon",
        "Barber",
        "Pratt",
        "Rutland",
        "Charles City County",
        "Leon",
        "Hyde",
        "Worth",
        "Guadalupe",
        "Harrison",
        "Potter",
        "Cole",
        "Buncombe",
        "Duval",
        "Ransom",
        "Ohio County",
        "Sheboygan",
        "Golden Valley",
        "Hutchinson",
        "Salt Lake",
        "Stearns",
        "Winchester City",
        "Shawnee",
        "Perry",
        "Koochiching",
        "Davis",
        "Lorain",
        "Lyon",
        "Hand",
        "Woods",
        "Big Stone",
        "Chippewa",
        "Niagara",
        "Sauk",
        "Story",
        "Saline",
        "McCracken",
        "Waupaca",
        "Tuolumne",
        "Oconto",
        "Gwinnett",
        "San Benito",
        "Henderson",
        "Chelan",
        "Austin",
        "Ida",
        "Clallam",
        "Otoe",
        "Currituck",
        "Pottawattamie",
        "Monongalia",
        "Walton",
        "Manitowoc",
        "Sanborn",
        "Hampden",
        "Banner",
        "Barton",
        "Flathead",
        "Sibley",
        "Valley",
        "Wasatch",
        "Edmunds",
        "Kingfisher",
        "Kennebec",
        "Missoula",
        "Kalamazoo",
        "Haakon",
        "Swift",
        "Plaquemines",
        "Waseca",
        "Caroline",
        "Champaign",
        "LaSalle",
        "Harding",
        "Clatsop",
        "Freeborn",
        "Meeker",
        "Wise",
        "Spokane",
        "Roseau",
        "Redwood",
        "Rockbridge",
        "Jessamine",
        "Watonwan",
        "Sedgwick",
        "Newton",
        "Lackawanna",
        "Dubois",
        "Codington",
        "Adair",
        "Hardin",
        "Pocahontas",
        "Centre",
        "Gray",
        "Republic",
        "Alpine",
        "Trigg",
        "Liberty",
        "Augusta",
        "Uinta",
        "Isanti",
        "Marion",
        "Weld",
        "Jersey",
        "Fillmore",
        "Becker",
        "Ford",
        "Shackelford",
        "Wallace",
        "McIntosh",
        "Pawnee",
        "Turner",
        "Genesee",
        "Blue Earth",
        "Wicomico",
        "Bayfield",
        "Meade",
        "White",
        "Steuben",
        "Rice",
        "Bandera",
        "Portage",
        "Chemung",
        "Wayne",
        "Auglaize",
        "Harlan",
        "Gilliam",
        "Poweshiek",
        "Tama",
        "Newport News City",
        "Yellow Medicine",
        "Andrew",
        "McClain",
        "Kings",
        "Eau Claire",
        "Kewaunee",
        "Allen",
        "Green Lake",
        "Pima",
        "Nemaha",
        "Frontier",
        "Keya Paha",
        "Cabarrus",
        "Hampton City",
        "Hamlin",
        "Crawford",
        "Cherry",
        "Burt",
        "Cooke",
        "Antelope",
        "Yavapai",
        "Hood River",
        "DeSoto",
        "Wilkin",
        "Christian",
        "Shenandoah",
        "Big Horn",
        "Haskell",
        "Amelia",
        "Iroquois",
        "Keith",
        "Tipton",
        "Rutherford",
        "Clayton",
        "Faribault",
        "Winneshiek",
        "Barry",
        "Palo Alto",
        "Box Butte",
        "Muscatine",
        "Limestone",
        "Trempealeau",
        "Burnet",
        "Sierra",
        "Mower",
        "Kaufman",
        "Aitkin",
        "Garrett",
        "St. James",
        "Allamakee",
        "Woodward",
        "Carter",
        "Jasper",
        "Pottawatomie",
        "Kosciusko",
        "Hubbard",
        "De Baca",
        "Wagoner",
        "Dewey",
        "Alachua",
        "Washburn",
        "West Baton Rouge",
        "Sherman",
        "Broome",
        "Benzie",
        "Buffalo",
        "Keweenaw",
        "Lafourche",
        "Luzerne",
        "Osage",
        "Schleicher",
        "Ballard",
        "Monterey",
        "Delta",
        "Aiken",
        "Ingham",
        "Staunton City",
        "Baltimore City",
        "Atchison",
        "San Jacinto",
        "Cascade",
        "Churchill",
        "Edwards",
        "Cayuga",
        "Victoria",
        "Montague",
        "Kootenai",
        "Russell",
        "Norfolk City",
        "Asotin",
        "Macoupin",
        "Osceola",
        "Dickey",
        "Merrick",
        "Hawaii County",
        "Whitley",
        "Davison",
        "Prince of Wales-Hyder Census Area",
        "Moffat",
        "Autauga",
        "Hartley",
        "Kimball",
        "Anderson",
        "Franklin County",
        "Monona",
        "Gage",
        "Ray",
        "Haywood",
        "Boyd",
        "Whiteside",
        "Rock",
        "Bay",
        "Flagler",
        "Cuming",
        "Susquehanna",
        "Yates",
        "Androscoggin",
        "Georgetown",
        "White Pine",
        "Prince George",
        "Carlton",
        "Fergus",
        "Des Moines",
        "Faulkner",
        "Vanderburgh",
        "Antrim",
        "Pepin",
        "Coos",
        "Calcasieu",
        "Colorado County",
        "Jack",
        "Boise",
        "Otsego",
        "Bullitt",
        "Caddo",
        "Lavaca",
        "Milwaukee",
        "Yamhill",
        "Black Hawk",
        "Broadwater",
        "Craven",
        "Judith Basin",
        "Rich",
        "Gibson",
        "Nez Perce",
        "Bexar",
        "Ector",
        "Webster",
        "Wabaunsee",
        "Wyoming County",
        "Rush",
        "Schuyler",
        "Paulding",
        "Alleghany",
        "Allegan",
        "Chickasaw",
        "Pipestone",
        "Holt",
        "Terrebonne",
        "Wabash",
        "Throckmorton",
        "Itasca",
        "Gregg",
        "Stonewall",
        "Huerfano",
        "Kingman",
        "Beadle",
        "Berrien",
        "Grayson",
        "Horry",
        "Lemhi",
        "Bosque",
        "Owen",
        "Mahoning",
        "Volusia",
        "Curry",
        "Hansford",
        "Beckham",
        "Treasure",
        "Roane",
        "Lapeer",
        "Penobscot",
        "Pacific",
        "Lucas",
        "Blair",
        "Crockett",
        "King and Queen",
        "Elmore",
        "Pickaway",
        "Washita",
        "Robertson",
        "Walla Walla",
        "Perquimans",
        "Sawyer",
        "Uintah",
        "Wichita",
        "Taylor",
        "Marquette",
        "Mahaska",
        "Blount",
        "Butte",
        "Moultrie",
        "Dinwiddie",
        "Kankakee",
        "Harvey",
        "Lubbock",
        "Phillips",
        "Dixon",
        "Rooks",
        "Transylvania",
        "Morrison",
        "Colfax",
        "Cape Girardeau",
        "Hayes",
        "Pointe Coupee",
        "Elk",
        "Pasco",
        "Pamlico",
        "Price",
        "Tom Green",
        "Norman",
        "Tippecanoe",
        "Nance",
        "Nueces",
        "Shasta",
        "Bradford",
        "Palo Pinto",
        "Cabell",
        "Hall",
        "Appomattox",
        "Winkler",
        "Fall River",
        "Cochise",
        "Sutter",
        "Riverside",
        "Caribou",
        "Caledonia",
        "Kiowa",
        "Richardson",
        "Silver Bow",
        "Cowlitz",
        "Marinette",
        "Hitchcock",
        "Montezuma",
        "Pender",
        "Cimarron",
        "Lauderdale",
        "St. Joseph",
        "Aurora",
        "Grady",
        "Shawano",
        "Page",
        "Giles",
        "Goshen",
        "Rockdale",
        "Cheatham",
        "Cottonwood",
        "Escambia",
        "Lampasas",
        "Winona",
        "Herkimer",
        "Cheboygan",
        "Duchesne",
        "Matagorda",
        "Ochiltree",
        "Coconino",
        "Reno",
        "Coffee",
        "Preble",
        "San Patricio",
        "Edgar",
        "Stephenson",
        "Bastrop",
        "Barron",
        "Ringgold",
        "Iron",
        "Red Willow",
        "Mendocino",
        "Ralls",
        "Roanoke City",
        "St. Lucie",
        "Tripp",
        "Woodbury",
        "Gosper",
        "Red Lake",
        "Baker",
        "Catawba",
        "Sebastian",
        "Bonner",
        "Scotts Bluff",
        "Wythe",
        "Lonoke",
        "Nicholas",
        "Hanson",
        "Bond",
        "Cortland",
        "Refugio",
        "Miami-Dade",
        "Callaway",
        "Garland",
        "Pend Oreille",
        "Alamance",
        "Toole",
        "Citrus",
        "Portsmouth City",
        "Craighead",
        "Jewell",
        "Stanton",
        "Wallowa",
        "Williamsburg City",
        "Oswego",
        "Day",
        "Pendleton",
        "Seneca",
        "Weber",
        "Brookings",
        "Trego",
        "Snyder",
        "Faulk",
        "Fountain",
        "St. Louis City",
        "Arkansas County",
        "Cleburne",
        "Gregory",
        "Stephens",
        "Pitt",
        "Roscommon",
        "Musselshell",
        "Schuylkill",
        "Iberia",
        "Lycoming",
        "Langlade",
        "Stoddard",
        "Daviess",
        "Upton",
        "Riley",
        "Lewis",
        "Norton",
        "Indiana County",
        "Ste. Genevieve",
        "Bowie",
        "Cooper",
        "Trinity",
        "Buena Vista",
        "Montrose",
        "Bourbon",
        "Mille Lacs",
        "Waushara",
        "Nash",
        "Dolores",
        "Freestone",
        "Vermillion",
        "Waynesboro City",
        "Beaverhead",
        "Ravalli",
        "Scurry",
        "Bell",
        "Muscogee",
        "Callahan",
        "Waldo",
        "LaPorte",
        "Collingsworth",
        "Wasco",
        "Burnett",
        "Harper",
        "Brooke",
        "Daggett",
        "Sandusky",
        "Kittitas",
        "Van Wert",
        "Ellsworth",
        "Presque Isle",
        "Caldwell",
        "Maury",
        "Pasquotank",
        "Sweet Grass",
        "Defiance",
        "Yadkin",
        "Alcona",
        "Petroleum",
        "Doniphan",
        "Shiawassee",
        "Fisher",
        "Accomack",
        "Manistee",
        "Wapello",
        "Norton City",
        "Dale",
        "Vernon",
        "Cambria",
        "Gaston",
        "Bonneville",
        "Kershaw",
        "Tuscaloosa",
        "Mackinac",
        "Latimer",
        "Huntington",
        "Surry",
        "Nobles",
        "San Joaquin",
        "Vermilion",
        "Amherst",
        "Trumbull",
        "Morrill",
        "Darke",
        "Beauregard",
        "Mobile",
        "Yuma",
        "Alfalfa",
        "Lea",
        "Upshur",
        "La Salle",
        "Tillamook",
        "Nuckolls",
        "Florence",
        "Southampton",
        "McKean",
        "Waller",
        "Johnston",
        "Lenawee",
        "Labette",
        "Todd",
        "Wyandot",
        "Pontotoc",
        "Belmont",
        "Comanche",
        "Saginaw",
        "Hunt",
        "Wahkiakum",
        "Menominee",
        "Creek",
        "Latah",
        "Bedford City",
        "Baca",
        "Granville",
        "Siskiyou",
        "Kearny",
        "Crane",
        "Kanabec",
        "Greenwood",
        "Philadelphia",
        "Rabun",
        "Bedford",
        "Huron",
        "Pondera",
        "Tooele",
        "Boyle",
        "Keokuk",
        "Sevier",
        "Rosebud",
        "Klickitat",
        "Sabine",
        "Morrow",
        "Kay",
        "La Paz",
        "St. Lawrence",
        "Humphreys",
        "Las Animas",
        "Chautauqua",
        "St. Martin",
        "Clearwater",
        "McCormick",
        "Glenn",
        "Hopkins",
        "Rapides",
        "East Feliciana",
        "Chenango",
        "Marengo",
        "Trimble",
        "Furnas",
        "Texas County",
        "Venango",
        "Ripley",
        "Deer Lodge",
        "Cattaraugus",
        "Massac",
        "Iosco",
        "Greenup",
        "Maries",
        "Hockley",
        "Randolph",
        "Coles",
        "Tuscarawas",
        "Pittsburg",
        "Alpena",
        "Noble",
        "Rains",
        "Pickett",
        "Ashland",
        "Pueblo",
        "Brule",
        "Van Zandt",
        "Ouachita",
        "Donley",
        "Lake of the Woods",
        "Clarion",
        "Spartanburg",
        "Watauga",
        "Bear Lake",
        "Wirt",
        "Kit Carson",
        "Nye",
        "Raleigh",
        "Gasconade",
        "Camas",
        "Grays Harbor",
        "Piscataquis",
        "Wakulla",
        "Josephine",
        "Woodson",
        "Galax City",
        "Assumption",
        "Chouteau",
        "Stone",
        "Van Buren",
        "West Feliciana",
        "Box Elder",
        "Brazos",
        "Greenbrier",
        "Stewart",
        "Catoosa",
        "Dade",
        "Erath",
        "Stanislaus",
        "McLennan",
        "Wetzel",
        "Bradley",
        "Rusk",
        "Lynn",
        "Finney",
        "Juniata",
        "Beltrami",
        "Lake and Peninsula",
        "Appanoose",
        "Avery",
        "Newberry",
        "Ontonagon",
        "Pittsylvania",
        "Colusa",
        "Columbiana",
        "Gaines",
        "Colbert",
        "Aroostook",
        "Dickson",
        "Burleson",
        "Cowley",
        "Carlisle",
        "Loup",
        "Dillingham Census Area",
        "Craig",
        "Calloway",
        "Klamath",
        "Northwest Arctic",
        "Preston",
        "Cotton",
        "Troup",
        "Red River",
        "Oxford",
        "Lynchburg City",
        "Tallapoosa",
        "Pine",
        "Hernando",
        "Geary",
        "Yoakum",
        "Barrow",
        "Hill",
        "Crittenden",
        "Crenshaw",
        "Garrard",
        "St. John the Baptist",
        "Baxter",
        "Taos",
        "San Bernardino",
        "Bannock",
        "Gilmer",
        "St. Mary",
        "Pleasants",
        "Stokes",
        "Ross",
        "Person",
        "Garvin",
        "Clearfield",
        "Tangipahoa",
        "Hamblen",
        "Milam",
        "New Madrid",
        "Allegany",
        "Dyer",
        "Whitman",
        "Terry",
        "Modoc",
        "Vigo",
        "Gates",
        "Iberville",
        "Gallia",
        "Neosho",
        "Dawes",
        "Jefferson Davis",
        "Tucker",
        "Eastland",
        "Elkhart",
        "Cottle",
        "Onslow",
        "Grenada",
        "Bates",
        "Hocking",
        "Bartow",
        "Live Oak",
        "Angelina",
        "Bibb",
        "Lowndes",
        "Bon Homme",
        "Halifax",
        "Bracken",
        "Rowan",
        "Pinal",
        "Lumpkin",
        "Obion",
        "Sequatchie",
        "Schoolcraft",
        "Richmond County",
        "Payne",
        "Walker",
        "Harney",
        "Esmeralda",
        "Ashe",
        "Smyth",
        "Umatilla",
        "Mohave",
        "Natchitoches",
        "Mifflin",
        "Gila",
        "Muskingum",
        "Utah County",
        "Tuscola",
        "Cullman",
        "Edgefield",
        "Graves",
        "Costilla",
        "Huntingdon",
        "Hooker",
        "Okanogan",
        "Saguache",
        "Sanilac",
        "Tyler",
        "Chilton",
        "Briscoe",
        "McCulloch",
        "Hawkins",
        "Prairie",
        "Miller",
        "Newaygo",
        "Muskegon",
        "Catron",
        "Mingo",
        "Twin Falls",
        "Lyman",
        "Mayes",
        "Dickens",
        "Wexford",
        "Cannon",
        "Rio Grande",
        "Pearl River",
        "Mora",
        "Guernsey",
        "Parke",
        "Gentry",
        "Coshocton",
        "Greenlee",
        "Stanly",
        "Oglethorpe",
        "Trousdale",
        "Shoshone",
        "Cloud",
        "Forest",
        "Jim Wells",
        "Hinds",
        "Alexander",
        "Tehama",
        "Tate",
        "Towns",
        "Covington",
        "Hopewell City",
        "Hillsdale",
        "Wilbarger",
        "Hart",
        "Gladwin",
        "Butts",
        "Scotland",
        "Nacogdoches",
        "Fannin",
        "Gogebic",
        "Wadena",
        "Navarro",
        "Choctaw",
        "Blackford",
        "St. Bernard",
        "Harnett",
        "Wharton",
        "Grimes",
        "Missaukee",
        "Kern",
        "Independence",
        "Gonzales",
        "Meagher",
        "Nome Census Area",
        "Kalkaska",
        "Yancey",
        "Gem",
        "Childress",
        "Pecos",
        "Runnels",
        "Banks",
        "Taney",
        "George",
        "Fresno",
        "Ionia",
        "Etowah",
        "Foard",
        "Oktibbeha",
        "Geneva",
        "Benewah",
        "Atascosa",
        "Gilchrist",
        "Covington City",
        "Sterling",
        "Bleckley",
        "Unicoi",
        "Emery",
        "Jennings",
        "Darlington",
        "Cache",
        "Highlands",
        "Ferry",
        "Chattahoochee",
        "McDonough",
        "Conway",
        "Arenac",
        "Switzerland",
        "Rio Arriba",
        "Ashtabula",
        "Muhlenberg",
        "Concho",
        "Millard",
        "Catahoula",
        "Branch",
        "Lassen",
        "Laurel",
        "Love",
        "Acadia",
        "Martinsville City",
        "Karnes",
        "Little River",
        "Otero",
        "Boundary",
        "Muskogee",
        "Hardeman",
        "Desha",
        "Haralson",
        "Spalding",
        "Houghton",
        "Starke",
        "Ashley",
        "Lenoir",
        "Okmulgee",
        "Dallam",
        "Coal",
        "Barren",
        "McMinn",
        "Powell",
        "Forrest",
        "Yukon-Koyukuk Census Area",
        "Saluda",
        "Alger",
        "Emporia City",
        "Pettis",
        "Castro",
        "Audrain",
        "Montmorency",
        "Appling",
        "Ogemaw",
        "Swain",
        "Danville City",
        "Valencia",
        "LaRue",
        "Minidoka",
        "Franklin City",
        "Do̱a Ana",
        "Laclede",
        "Weakley",
        "Mahnomen",
        "Whitfield",
        "Chaves",
        "Alamosa",
        "Chariton",
        "Edmonson",
        "Sampson",
        "Bollinger",
        "St. Helena",
        "Moniteau",
        "Simpson",
        "Scioto",
        "Yakima",
        "Peach",
        "Treutlen",
        "Talladega",
        "Brooks",
        "Meigs",
        "St. Landry",
        "Coryell",
        "LaGrange",
        "Titus",
        "Highland",
        "Nottoway",
        "Mecosta",
        "Hampton",
        "Parmer",
        "Fleming",
        "Hickman",
        "Hot Spring",
        "Columbus",
        "Nowata",
        "Yuba",
        "Chowan",
        "Jay",
        "Jim Hogg",
        "Sanders",
        "Gordon",
        "Camp",
        "Idaho County",
        "Payette",
        "Bladen",
        "Laurens",
        "Alcorn",
        "Woodruff",
        "Del Norte",
        "Isabella",
        "Schley",
        "Hardy",
        "Charles Mix",
        "Wilkes",
        "Nolan",
        "Evans",
        "Winston",
        "Oceana",
        "Montcalm",
        "Coleman",
        "Heard",
        "Crosby",
        "Bienville",
        "Wyandotte",
        "Rhea",
        "Prowers",
        "Petersburg City",
        "Tift",
        "McDowell",
        "Kleberg",
        "Habersham",
        "Mississippi County",
        "Bamberg",
        "Bingham",
        "Barnwell",
        "Patrick",
        "Ware",
        "Gratiot",
        "Motley",
        "Meriwether",
        "Bristol City",
        "Hale",
        "Colleton",
        "Luce",
        "Hoke",
        "Yalobusha",
        "Lamb",
        "Wilkinson",
        "Toombs",
        "Cross",
        "San Augustine",
        "Neshoba",
        "Bailey",
        "Torrance",
        "Screven",
        "Braxton",
        "Bullock",
        "Dougherty",
        "Bulloch",
        "Claiborne",
        "Harmon",
        "Bacon",
        "Gulf",
        "St. Francois",
        "Dent",
        "Pushmataha",
        "Bland",
        "Bethel Census Area",
        "Coosa",
        "Tippah",
        "Buena Vista City",
        "Reynolds",
        "Knott",
        "Suwannee",
        "McNairy",
        "Attala",
        "Hidalgo",
        "Gooding",
        "Overton",
        "Tishomingo",
        "Copiah",
        "Levy",
        "Dickenson",
        "Irwin",
        "Pershing",
        "Crisp",
        "Merced",
        "Bronx",
        "Benson",
        "Clare",
        "Le Flore",
        "Abbeville",
        "Sequoyah",
        "Juab",
        "Itawamba",
        "Socorro",
        "Breckinridge",
        "Vinton",
        "Nodaway",
        "Oscoda",
        "Izard",
        "Tillman",
        "Evangeline",
        "San Saba",
        "Avoyelles",
        "Dunklin",
        "Glascock",
        "West Carroll",
        "Upson",
        "Caswell",
        "Candler",
        "Greer",
        "Twiggs",
        "Quay",
        "Grainger",
        "Real",
        "McDuffie",
        "Vance",
        "Tulare",
        "Letcher",
        "Swisher",
        "Barbour",
        "Val Verde",
        "Hertford",
        "Madera",
        "Ritchie",
        "Atoka",
        "Clinch",
        "Sanpete",
        "Cassia",
        "Okeechobee",
        "Canyon",
        "Washington Parish",
        "Baraga",
        "Orangeburg",
        "Power",
        "Clarendon",
        "Arthur",
        "Lunenburg",
        "Gadsden",
        "McCurtain",
        "Early",
        "Jenkins",
        "Deaf Smith",
        "Dimmit",
        "McDonald",
        "Uvalde",
        "Roosevelt",
        "Cocke",
        "Summers",
        "Howell",
        "Hempstead",
        "Cochran",
        "Hickory",
        "Wheatland",
        "Doddridge",
        "Conejos",
        "Lanier",
        "Ozark",
        "Prince Edward",
        "Crowley",
        "Jerome",
        "Holmes",
        "Tensas",
        "Metcalfe",
        "Buckingham",
        "Long",
        "Duplin",
        "Charlton",
        "Bertie",
        "Harrisonburg City",
        "Emanuel",
        "Drew",
        "Colquitt",
        "Athens",
        "Yell",
        "Amite",
        "Edgecombe",
        "Piute",
        "Brantley",
        "Poinsett",
        "Pemiscot",
        "Shannon",
        "Dixie",
        "Walthall",
        "Bee",
        "Winn",
        "Leake",
        "Imperial",
        "Anson",
        "Searcy",
        "Sharp",
        "Kinney",
        "Morehouse",
        "Zapata",
        "Tyrrell",
        "Navajo",
        "Prentiss",
        "Chicot",
        "Okfuskee",
        "Rockcastle",
        "Falls",
        "Bolivar",
        "Fentress",
        "Estill",
        "Concordia",
        "Leslie",
        "Greensville",
        "Malheur",
        "Oregon County",
        "Bennett",
        "Culberson",
        "Radford City",
        "Garza",
        "Presidio",
        "Hendry",
        "Cibola",
        "Luna",
        "Chattooga",
        "Glades",
        "Atkinson",
        "Owyhee",
        "Menifee",
        "Frio",
        "Echols",
        "Mellette",
        "Bledsoe",
        "Sharkey",
        "Coahoma",
        "Conecuh",
        "Glacier",
        "Casey",
        "Tunica",
        "St. Francis",
        "Rolette",
        "Reeves",
        "Hardee",
        "Robeson",
        "Tattnall",
        "Kenedy",
        "Magoffin",
        "Bent",
        "Dillon",
        "Williamsburg",
        "Lexington City",
        "Breathitt",
        "Marlboro",
        "Webb",
        "Dooly",
        "Taliaferro",
        "Leflore",
        "Yazoo",
        "Corson",
        "Ben Hill",
        "Quitman",
        "Wolfe",
        "Hudspeth",
        "Elliott",
        "Kemper",
        "Issaquena",
        "Maverick",
        "Owsley",
        "Wilcox",
        "Allendale",
        "Zavala",
        "Noxubee",
        "Tallahatchie",
        "Apache",
        "McKinley",
        "Sunflower",
        "Telfair",
        "Ziebach",
        "East Carroll",
        "McCreary",
        "Starr",
        "Willacy",
        "Kusilvak Census Area",
        "Oglala Lakota"
      ]
    },
    {
      "datamart_id": 3,
      "semantic_type": [],
      "name": "State",
      "description": "column name: State, dtype: object",
      "named_entity": [
        "New York",
        "Virginia",
        "California",
        "Colorado",
        "New Mexico",
        "New Jersey",
        "Texas",
        "Maryland",
        "Connecticut",
        "Massachusetts",
        "Alaska",
        "Hawaii",
        "District of Columbia",
        "Wyoming",
        "Utah",
        "Pennsylvania",
        "Wisconsin",
        "Tennessee",
        "Rhode Island",
        "Ohio",
        "Washington",
        "Indiana",
        "Kansas",
        "North Dakota",
        "Illinois",
        "New Hampshire",
        "Minnesota",
        "Florida",
        "Georgia",
        "Michigan",
        "South Dakota",
        "Iowa",
        "Idaho",
        "Missouri",
        "North Carolina",
        "Nevada",
        "Kentucky",
        "Alabama",
        "Vermont",
        "Mississippi",
        "Montana",
        "Maine",
        "Oregon",
        "South Carolina",
        "Delaware",
        "Nebraska",
        "Louisiana",
        "West Virginia",
        "Oklahoma",
        "Arkansas",
        "Arizona"
      ]
    },
    {
      "datamart_id": 4,
      "semantic_type": [],
      "name": "Per capita income",
      "description": "column name: Per capita income, dtype: object",
      "named_entity": [
        "$62,498 ",
        "$62,018 ",
        "$59,088 ",
        "$56,791 ",
        "$54,608 ",
        "$51,814 ",
        "$51,044 ",
        "$50,532 ",
        "$50,349 ",
        "$50,042 ",
        "$49,038 ",
        "$48,814 ",
        "$48,721 ",
        "$48,486 ",
        "$48,172 ",
        "$47,984 ",
        "$47,803 ",
        "$47,331 ",
        "$46,565 ",
        "$46,457 ",
        "$45,732 ",
        "$45,515 ",
        "$45,290 ",
        "$45,039 ",
        "$44,692 ",
        "$44,345 ",
        "$43,634 ",
        "$43,444 ",
        "$43,347 ",
        "$42,861 ",
        "$42,749 ",
        "$42,462 ",
        "$42,400 ",
        "$42,255 ",
        "$42,210 ",
        "$42,041 ",
        "$41,716 ",
        "$41,513 ",
        "$41,472 ",
        "$41,292 ",
        "$40,827 ",
        "$40,415 ",
        "$40,309 ",
        "$40,293 ",
        "$40,189 ",
        "$39,992 ",
        "$39,911 ",
        "$39,600 ",
        "$39,521 ",
        "$39,497 ",
        "$39,133 ",
        "$38,893 ",
        "$38,827 ",
        "$38,748 ",
        "$38,738 ",
        "$38,570 ",
        "$38,444 ",
        "$38,399 ",
        "$38,260 ",
        "$38,219 ",
        "$38,108 ",
        "$38,022 ",
        "$38,018 ",
        "$38,011 ",
        "$37,972 ",
        "$37,949 ",
        "$37,839 ",
        "$37,719 ",
        "$37,667 ",
        "$37,577 ",
        "$37,558 ",
        "$37,485 ",
        "$37,482 ",
        "$37,466 ",
        "$37,465 ",
        "$37,457 ",
        "$37,442 ",
        "$37,401 ",
        "$37,277 ",
        "$37,239 ",
        "$37,139 ",
        "$37,024 ",
        "$37,023 ",
        "$36,945 ",
        "$36,917 ",
        "$36,836 ",
        "$36,835 ",
        "$36,757 ",
        "$36,706 ",
        "$36,574 ",
        "$36,505 ",
        "$36,458 ",
        "$36,439 ",
        "$36,373 ",
        "$36,365 ",
        "$36,303 ",
        "$36,214 ",
        "$36,172 ",
        "$36,167 ",
        "$36,153 ",
        "$36,142 ",
        "$36,087 ",
        "$36,077 ",
        "$36,017 ",
        "$35,944 ",
        "$35,844 ",
        "$35,827 ",
        "$35,763 ",
        "$35,524 ",
        "$35,467 ",
        "$35,425 ",
        "$35,344 ",
        "$35,295 ",
        "$35,220 ",
        "$35,176 ",
        "$35,167 ",
        "$35,143 ",
        "$35,089 ",
        "$34,886 ",
        "$34,884 ",
        "$34,873 ",
        "$34,839 ",
        "$34,828 ",
        "$34,795 ",
        "$34,698 ",
        "$34,617 ",
        "$34,591 ",
        "$34,582 ",
        "$34,465 ",
        "$34,455 ",
        "$34,392 ",
        "$34,390 ",
        "$34,374 ",
        "$34,345 ",
        "$34,317 ",
        "$34,234 ",
        "$34,183 ",
        "$34,123 ",
        "$34,084 ",
        "$34,073 ",
        "$34,068 ",
        "$34,057 ",
        "$34,025 ",
        "$33,974 ",
        "$33,855 ",
        "$33,850 ",
        "$33,814 ",
        "$33,803 ",
        "$33,801 ",
        "$33,788 ",
        "$33,782 ",
        "$33,712 ",
        "$33,672 ",
        "$33,634 ",
        "$33,613 ",
        "$33,594 ",
        "$33,591 ",
        "$33,555 ",
        "$33,540 ",
        "$33,472 ",
        "$33,363 ",
        "$33,357 ",
        "$33,313 ",
        "$33,281 ",
        "$33,251 ",
        "$33,231 ",
        "$33,206 ",
        "$33,179 ",
        "$33,172 ",
        "$33,170 ",
        "$33,166 ",
        "$33,159 ",
        "$33,115 ",
        "$33,078 ",
        "$33,069 ",
        "$33,063 ",
        "$33,062 ",
        "$33,015 ",
        "$32,980 ",
        "$32,948 ",
        "$32,930 ",
        "$32,911 ",
        "$32,908 ",
        "$32,887 ",
        "$32,880 ",
        "$32,876 ",
        "$32,868 ",
        "$32,858 ",
        "$32,835 ",
        "$32,781 ",
        "$32,650 ",
        "$32,641 ",
        "$32,600 ",
        "$32,595 ",
        "$32,579 ",
        "$32,572 ",
        "$32,523 ",
        "$32,521 ",
        "$32,503 ",
        "$32,490 ",
        "$32,482 ",
        "$32,406 ",
        "$32,346 ",
        "$32,344 ",
        "$32,341 ",
        "$32,328 ",
        "$32,313 ",
        "$32,298 ",
        "$32,295 ",
        "$32,253 ",
        "$32,220 ",
        "$32,181 ",
        "$32,143 ",
        "$32,129 ",
        "$32,068 ",
        "$32,045 ",
        "$32,036 ",
        "$32,028 ",
        "$32,020 ",
        "$31,989 ",
        "$31,969 ",
        "$31,934 ",
        "$31,933 ",
        "$31,823 ",
        "$31,791 ",
        "$31,790 ",
        "$31,769 ",
        "$31,767 ",
        "$31,758 ",
        "$31,728 ",
        "$31,721 ",
        "$31,694 ",
        "$31,684 ",
        "$31,593 ",
        "$31,589 ",
        "$31,586 ",
        "$31,578 ",
        "$31,558 ",
        "$31,537 ",
        "$31,517 ",
        "$31,504 ",
        "$31,502 ",
        "$31,482 ",
        "$31,462 ",
        "$31,455 ",
        "$31,449 ",
        "$31,412 ",
        "$31,378 ",
        "$31,360 ",
        "$31,349 ",
        "$31,342 ",
        "$31,310 ",
        "$31,288 ",
        "$31,276 ",
        "$31,256 ",
        "$31,252 ",
        "$31,190 ",
        "$31,178 ",
        "$31,175 ",
        "$31,164 ",
        "$31,135 ",
        "$31,096 ",
        "$31,078 ",
        "$31,075 ",
        "$31,070 ",
        "$30,992 ",
        "$30,957 ",
        "$30,949 ",
        "$30,941 ",
        "$30,933 ",
        "$30,932 ",
        "$30,926 ",
        "$30,919 ",
        "$30,903 ",
        "$30,881 ",
        "$30,740 ",
        "$30,738 ",
        "$30,737 ",
        "$30,707 ",
        "$30,692 ",
        "$30,668 ",
        "$30,657 ",
        "$30,647 ",
        "$30,592 ",
        "$30,586 ",
        "$30,583 ",
        "$30,532 ",
        "$30,531 ",
        "$30,529 ",
        "$30,518 ",
        "$30,517 ",
        "$30,477 ",
        "$30,475 ",
        "$30,460 ",
        "$30,442 ",
        "$30,440 ",
        "$30,432 ",
        "$30,397 ",
        "$30,377 ",
        "$30,363 ",
        "$30,361 ",
        "$30,352 ",
        "$30,351 ",
        "$30,284 ",
        "$30,223 ",
        "$30,218 ",
        "$30,189 ",
        "$30,183 ",
        "$30,158 ",
        "$30,151 ",
        "$30,140 ",
        "$30,117 ",
        "$30,116 ",
        "$30,112 ",
        "$30,097 ",
        "$30,082 ",
        "$30,046 ",
        "$30,040 ",
        "$30,039 ",
        "$30,031 ",
        "$29,987 ",
        "$29,974 ",
        "$29,954 ",
        "$29,950 ",
        "$29,943 ",
        "$29,932 ",
        "$29,927 ",
        "$29,905 ",
        "$29,904 ",
        "$29,877 ",
        "$29,836 ",
        "$29,830 ",
        "$29,806 ",
        "$29,800 ",
        "$29,793 ",
        "$29,761 ",
        "$29,744 ",
        "$29,718 ",
        "$29,681 ",
        "$29,679 ",
        "$29,675 ",
        "$29,638 ",
        "$29,623 ",
        "$29,615 ",
        "$29,605 ",
        "$29,600 ",
        "$29,592 ",
        "$29,559 ",
        "$29,544 ",
        "$29,536 ",
        "$29,534 ",
        "$29,518 ",
        "$29,517 ",
        "$29,484 ",
        "$29,460 ",
        "$29,437 ",
        "$29,406 ",
        "$29,389 ",
        "$29,369 ",
        "$29,347 ",
        "$29,329 ",
        "$29,328 ",
        "$29,301 ",
        "$29,294 ",
        "$29,277 ",
        "$29,266 ",
        "$29,262 ",
        "$29,259 ",
        "$29,251 ",
        "$29,235 ",
        "$29,234 ",
        "$29,219 ",
        "$29,196 ",
        "$29,187 ",
        "$29,180 ",
        "$29,135 ",
        "$29,132 ",
        "$29,128 ",
        "$29,127 ",
        "$29,125 ",
        "$29,124 ",
        "$29,107 ",
        "$29,088 ",
        "$29,081 ",
        "$29,072 ",
        "$29,060 ",
        "$29,017 ",
        "$28,948 ",
        "$28,939 ",
        "$28,929 ",
        "$28,926 ",
        "$28,913 ",
        "$28,907 ",
        "$28,904 ",
        "$28,901 ",
        "$28,894 ",
        "$28,889 ",
        "$28,868 ",
        "$28,867 ",
        "$28,852 ",
        "$28,837 ",
        "$28,829 ",
        "$28,810 ",
        "$28,806 ",
        "$28,772 ",
        "$28,764 ",
        "$28,761 ",
        "$28,752 ",
        "$28,746 ",
        "$28,732 ",
        "$28,727 ",
        "$28,725 ",
        "$28,722 ",
        "$28,704 ",
        "$28,697 ",
        "$28,675 ",
        "$28,673 ",
        "$28,670 ",
        "$28,669 ",
        "$28,600 ",
        "$28,583 ",
        "$28,582 ",
        "$28,575 ",
        "$28,568 ",
        "$28,563 ",
        "$28,562 ",
        "$28,557 ",
        "$28,528 ",
        "$28,505 ",
        "$28,502 ",
        "$28,474 ",
        "$28,467 ",
        "$28,449 ",
        "$28,438 ",
        "$28,433 ",
        "$28,412 ",
        "$28,400 ",
        "$28,359 ",
        "$28,358 ",
        "$28,356 ",
        "$28,331 ",
        "$28,330 ",
        "$28,323 ",
        "$28,319 ",
        "$28,308 ",
        "$28,296 ",
        "$28,283 ",
        "$28,282 ",
        "$28,273 ",
        "$28,266 ",
        "$28,265 ",
        "$28,241 ",
        "$28,223 ",
        "$28,212 ",
        "$28,207 ",
        "$28,205 ",
        "$28,201 ",
        "$28,189 ",
        "$28,186 ",
        "$28,178 ",
        "$28,174 ",
        "$28,146 ",
        "$28,136 ",
        "$28,134 ",
        "$28,132 ",
        "$28,129 ",
        "$28,111 ",
        "$28,086 ",
        "$28,081 ",
        "$28,072 ",
        "$28,071 ",
        "$28,070 ",
        "$28,068 ",
        "$28,056 ",
        "$28,055 ",
        "$28,051 ",
        "$28,046 ",
        "$28,037 ",
        "$28,030 ",
        "$28,021 ",
        "$28,014 ",
        "$27,979 ",
        "$27,978 ",
        "$27,957 ",
        "$27,948 ",
        "$27,942 ",
        "$27,931 ",
        "$27,925 ",
        "$27,923 ",
        "$27,914 ",
        "$27,910 ",
        "$27,908 ",
        "$27,899 ",
        "$27,893 ",
        "$27,887 ",
        "$27,883 ",
        "$27,878 ",
        "$27,874 ",
        "$27,865 ",
        "$27,864 ",
        "$27,828 ",
        "$27,824 ",
        "$27,818 ",
        "$27,817 ",
        "$27,802 ",
        "$27,800 ",
        "$27,797 ",
        "$27,796 ",
        "$27,795 ",
        "$27,793 ",
        "$27,787 ",
        "$27,761 ",
        "$27,757 ",
        "$27,749 ",
        "$27,730 ",
        "$27,721 ",
        "$27,716 ",
        "$27,713 ",
        "$27,704 ",
        "$27,691 ",
        "$27,690 ",
        "$27,685 ",
        "$27,682 ",
        "$27,681 ",
        "$27,676 ",
        "$27,673 ",
        "$27,660 ",
        "$27,655 ",
        "$27,654 ",
        "$27,639 ",
        "$27,627 ",
        "$27,610 ",
        "$27,607 ",
        "$27,599 ",
        "$27,593 ",
        "$27,586 ",
        "$27,556 ",
        "$27,552 ",
        "$27,525 ",
        "$27,524 ",
        "$27,505 ",
        "$27,504 ",
        "$27,502 ",
        "$27,498 ",
        "$27,496 ",
        "$27,492 ",
        "$27,485 ",
        "$27,469 ",
        "$27,463 ",
        "$27,462 ",
        "$27,452 ",
        "$27,450 ",
        "$27,441 ",
        "$27,429 ",
        "$27,423 ",
        "$27,418 ",
        "$27,414 ",
        "$27,407 ",
        "$27,398 ",
        "$27,391 ",
        "$27,390 ",
        "$27,379 ",
        "$27,375 ",
        "$27,365 ",
        "$27,361 ",
        "$27,359 ",
        "$27,351 ",
        "$27,348 ",
        "$27,347 ",
        "$27,330 ",
        "$27,329 ",
        "$27,326 ",
        "$27,323 ",
        "$27,322 ",
        "$27,298 ",
        "$27,296 ",
        "$27,291 ",
        "$27,289 ",
        "$27,284 ",
        "$27,268 ",
        "$27,259 ",
        "$27,256 ",
        "$27,238 ",
        "$27,230 ",
        "$27,229 ",
        "$27,222 ",
        "$27,199 ",
        "$27,197 ",
        "$27,185 ",
        "$27,184 ",
        "$27,183 ",
        "$27,182 ",
        "$27,168 ",
        "$27,161 ",
        "$27,157 ",
        "$27,154 ",
        "$27,152 ",
        "$27,149 ",
        "$27,141 ",
        "$27,138 ",
        "$27,130 ",
        "$27,118 ",
        "$27,117 ",
        "$27,101 ",
        "$27,098 ",
        "$27,074 ",
        "$27,065 ",
        "$27,060 ",
        "$27,058 ",
        "$27,053 ",
        "$27,051 ",
        "$27,045 ",
        "$27,041 ",
        "$27,039 ",
        "$27,038 ",
        "$27,032 ",
        "$27,031 ",
        "$27,026 ",
        "$27,017 ",
        "$27,015 ",
        "$27,009 ",
        "$27,000 ",
        "$26,998 ",
        "$26,988 ",
        "$26,979 ",
        "$26,965 ",
        "$26,958 ",
        "$26,956 ",
        "$26,955 ",
        "$26,954 ",
        "$26,953 ",
        "$26,947 ",
        "$26,945 ",
        "$26,944 ",
        "$26,940 ",
        "$26,930 ",
        "$26,927 ",
        "$26,924 ",
        "$26,920 ",
        "$26,911 ",
        "$26,908 ",
        "$26,906 ",
        "$26,903 ",
        "$26,897 ",
        "$26,895 ",
        "$26,886 ",
        "$26,880 ",
        "$26,873 ",
        "$26,861 ",
        "$26,856 ",
        "$26,843 ",
        "$26,841 ",
        "$26,839 ",
        "$26,834 ",
        "$26,827 ",
        "$26,824 ",
        "$26,823 ",
        "$26,816 ",
        "$26,814 ",
        "$26,813 ",
        "$26,811 ",
        "$26,797 ",
        "$26,781 ",
        "$26,770 ",
        "$26,767 ",
        "$26,766 ",
        "$26,762 ",
        "$26,757 ",
        "$26,756 ",
        "$26,748 ",
        "$26,746 ",
        "$26,739 ",
        "$26,738 ",
        "$26,724 ",
        "$26,723 ",
        "$26,716 ",
        "$26,715 ",
        "$26,705 ",
        "$26,704 ",
        "$26,700 ",
        "$26,686 ",
        "$26,674 ",
        "$26,666 ",
        "$26,665 ",
        "$26,661 ",
        "$26,658 ",
        "$26,643 ",
        "$26,635 ",
        "$26,633 ",
        "$26,625 ",
        "$26,624 ",
        "$26,620 ",
        "$26,614 ",
        "$26,603 ",
        "$26,590 ",
        "$26,584 ",
        "$26,582 ",
        "$26,577 ",
        "$26,576 ",
        "$26,567 ",
        "$26,561 ",
        "$26,553 ",
        "$26,544 ",
        "$26,541 ",
        "$26,535 ",
        "$26,532 ",
        "$26,530 ",
        "$26,527 ",
        "$26,525 ",
        "$26,515 ",
        "$26,514 ",
        "$26,505 ",
        "$26,500 ",
        "$26,496 ",
        "$26,495 ",
        "$26,472 ",
        "$26,467 ",
        "$26,461 ",
        "$26,459 ",
        "$26,455 ",
        "$26,450 ",
        "$26,407 ",
        "$26,400 ",
        "$26,388 ",
        "$26,387 ",
        "$26,380 ",
        "$26,372 ",
        "$26,370 ",
        "$26,368 ",
        "$26,357 ",
        "$26,350 ",
        "$26,345 ",
        "$26,342 ",
        "$26,335 ",
        "$26,334 ",
        "$26,330 ",
        "$26,326 ",
        "$26,325 ",
        "$26,321 ",
        "$26,319 ",
        "$26,313 ",
        "$26,308 ",
        "$26,286 ",
        "$26,280 ",
        "$26,277 ",
        "$26,274 ",
        "$26,271 ",
        "$26,264 ",
        "$26,261 ",
        "$26,258 ",
        "$26,254 ",
        "$26,252 ",
        "$26,243 ",
        "$26,234 ",
        "$26,233 ",
        "$26,232 ",
        "$26,229 ",
        "$26,224 ",
        "$26,217 ",
        "$26,209 ",
        "$26,205 ",
        "$26,198 ",
        "$26,196 ",
        "$26,195 ",
        "$26,188 ",
        "$26,187 ",
        "$26,184 ",
        "$26,180 ",
        "$26,160 ",
        "$26,159 ",
        "$26,143 ",
        "$26,139 ",
        "$26,137 ",
        "$26,135 ",
        "$26,126 ",
        "$26,113 ",
        "$26,110 ",
        "$26,109 ",
        "$26,103 ",
        "$26,102 ",
        "$26,095 ",
        "$26,065 ",
        "$26,062 ",
        "$26,060 ",
        "$26,059 ",
        "$26,057 ",
        "$26,048 ",
        "$26,045 ",
        "$26,035 ",
        "$26,030 ",
        "$26,028 ",
        "$26,027 ",
        "$26,022 ",
        "$26,019 ",
        "$25,993 ",
        "$25,991 ",
        "$25,988 ",
        "$25,986 ",
        "$25,975 ",
        "$25,966 ",
        "$25,962 ",
        "$25,961 ",
        "$25,957 ",
        "$25,956 ",
        "$25,947 ",
        "$25,946 ",
        "$25,943 ",
        "$25,941 ",
        "$25,939 ",
        "$25,936 ",
        "$25,933 ",
        "$25,932 ",
        "$25,921 ",
        "$25,915 ",
        "$25,914 ",
        "$25,902 ",
        "$25,898 ",
        "$25,893 ",
        "$25,889 ",
        "$25,888 ",
        "$25,884 ",
        "$25,869 ",
        "$25,867 ",
        "$25,865 ",
        "$25,855 ",
        "$25,854 ",
        "$25,847 ",
        "$25,846 ",
        "$25,845 ",
        "$25,834 ",
        "$25,833 ",
        "$25,827 ",
        "$25,825 ",
        "$25,823 ",
        "$25,817 ",
        "$25,816 ",
        "$25,814 ",
        "$25,800 ",
        "$25,790 ",
        "$25,789 ",
        "$25,785 ",
        "$25,781 ",
        "$25,777 ",
        "$25,775 ",
        "$25,773 ",
        "$25,770 ",
        "$25,766 ",
        "$25,764 ",
        "$25,763 ",
        "$25,761 ",
        "$25,757 ",
        "$25,754 ",
        "$25,751 ",
        "$25,750 ",
        "$25,748 ",
        "$25,741 ",
        "$25,738 ",
        "$25,723 ",
        "$25,718 ",
        "$25,713 ",
        "$25,709 ",
        "$25,700 ",
        "$25,686 ",
        "$25,685 ",
        "$25,680 ",
        "$25,670 ",
        "$25,668 ",
        "$25,665 ",
        "$25,663 ",
        "$25,662 ",
        "$25,661 ",
        "$25,650 ",
        "$25,649 ",
        "$25,638 ",
        "$25,637 ",
        "$25,635 ",
        "$25,626 ",
        "$25,625 ",
        "$25,620 ",
        "$25,603 ",
        "$25,594 ",
        "$25,590 ",
        "$25,589 ",
        "$25,582 ",
        "$25,571 ",
        "$25,564 ",
        "$25,559 ",
        "$25,556 ",
        "$25,550 ",
        "$25,549 ",
        "$25,545 ",
        "$25,537 ",
        "$25,531 ",
        "$25,527 ",
        "$25,522 ",
        "$25,519 ",
        "$25,513 ",
        "$25,494 ",
        "$25,482 ",
        "$25,481 ",
        "$25,477 ",
        "$25,468 ",
        "$25,467 ",
        "$25,460 ",
        "$25,455 ",
        "$25,449 ",
        "$25,448 ",
        "$25,443 ",
        "$25,436 ",
        "$25,430 ",
        "$25,429 ",
        "$25,427 ",
        "$25,426 ",
        "$25,409 ",
        "$25,406 ",
        "$25,403 ",
        "$25,385 ",
        "$25,380 ",
        "$25,378 ",
        "$25,377 ",
        "$25,375 ",
        "$25,371 ",
        "$25,370 ",
        "$25,369 ",
        "$25,368 ",
        "$25,364 ",
        "$25,355 ",
        "$25,339 ",
        "$25,332 ",
        "$25,329 ",
        "$25,328 ",
        "$25,327 ",
        "$25,323 ",
        "$25,322 ",
        "$25,320 ",
        "$25,318 ",
        "$25,311 ",
        "$25,310 ",
        "$25,303 ",
        "$25,302 ",
        "$25,299 ",
        "$25,293 ",
        "$25,289 ",
        "$25,287 ",
        "$25,282 ",
        "$25,279 ",
        "$25,275 ",
        "$25,269 ",
        "$25,262 ",
        "$25,251 ",
        "$25,249 ",
        "$25,247 ",
        "$25,245 ",
        "$25,233 ",
        "$25,230 ",
        "$25,214 ",
        "$25,213 ",
        "$25,211 ",
        "$25,203 ",
        "$25,195 ",
        "$25,194 ",
        "$25,186 ",
        "$25,181 ",
        "$25,176 ",
        "$25,153 ",
        "$25,148 ",
        "$25,134 ",
        "$25,129 ",
        "$25,123 ",
        "$25,119 ",
        "$25,114 ",
        "$25,109 ",
        "$25,103 ",
        "$25,100 ",
        "$25,098 ",
        "$25,097 ",
        "$25,093 ",
        "$25,077 ",
        "$25,076 ",
        "$25,074 ",
        "$25,065 ",
        "$25,062 ",
        "$25,059 ",
        "$25,055 ",
        "$25,046 ",
        "$25,038 ",
        "$25,029 ",
        "$25,020 ",
        "$25,017 ",
        "$24,998 ",
        "$24,997 ",
        "$24,996 ",
        "$24,990 ",
        "$24,977 ",
        "$24,975 ",
        "$24,972 ",
        "$24,963 ",
        "$24,954 ",
        "$24,952 ",
        "$24,950 ",
        "$24,939 ",
        "$24,935 ",
        "$24,932 ",
        "$24,930 ",
        "$24,926 ",
        "$24,922 ",
        "$24,921 ",
        "$24,905 ",
        "$24,892 ",
        "$24,881 ",
        "$24,880 ",
        "$24,879 ",
        "$24,877 ",
        "$24,874 ",
        "$24,861 ",
        "$24,860 ",
        "$24,857 ",
        "$24,851 ",
        "$24,850 ",
        "$24,839 ",
        "$24,838 ",
        "$24,837 ",
        "$24,835 ",
        "$24,831 ",
        "$24,830 ",
        "$24,824 ",
        "$24,816 ",
        "$24,802 ",
        "$24,798 ",
        "$24,793 ",
        "$24,792 ",
        "$24,789 ",
        "$24,787 ",
        "$24,781 ",
        "$24,777 ",
        "$24,775 ",
        "$24,771 ",
        "$24,769 ",
        "$24,758 ",
        "$24,754 ",
        "$24,753 ",
        "$24,750 ",
        "$24,748 ",
        "$24,742 ",
        "$24,736 ",
        "$24,733 ",
        "$24,727 ",
        "$24,716 ",
        "$24,714 ",
        "$24,711 ",
        "$24,702 ",
        "$24,700 ",
        "$24,699 ",
        "$24,692 ",
        "$24,685 ",
        "$24,683 ",
        "$24,680 ",
        "$24,676 ",
        "$24,669 ",
        "$24,659 ",
        "$24,658 ",
        "$24,653 ",
        "$24,644 ",
        "$24,639 ",
        "$24,635 ",
        "$24,628 ",
        "$24,615 ",
        "$24,613 ",
        "$24,611 ",
        "$24,597 ",
        "$24,593 ",
        "$24,590 ",
        "$24,588 ",
        "$24,581 ",
        "$24,577 ",
        "$24,575 ",
        "$24,573 ",
        "$24,571 ",
        "$24,566 ",
        "$24,565 ",
        "$24,561 ",
        "$24,557 ",
        "$24,555 ",
        "$24,554 ",
        "$24,550 ",
        "$24,549 ",
        "$24,547 ",
        "$24,536 ",
        "$24,531 ",
        "$24,530 ",
        "$24,525 ",
        "$24,524 ",
        "$24,518 ",
        "$24,510 ",
        "$24,508 ",
        "$24,503 ",
        "$24,501 ",
        "$24,500 ",
        "$24,498 ",
        "$24,497 ",
        "$24,496 ",
        "$24,495 ",
        "$24,493 ",
        "$24,485 ",
        "$24,477 ",
        "$24,471 ",
        "$24,459 ",
        "$24,457 ",
        "$24,453 ",
        "$24,448 ",
        "$24,442 ",
        "$24,437 ",
        "$24,435 ",
        "$24,434 ",
        "$24,429 ",
        "$24,426 ",
        "$24,408 ",
        "$24,401 ",
        "$24,378 ",
        "$24,370 ",
        "$24,367 ",
        "$24,357 ",
        "$24,355 ",
        "$24,348 ",
        "$24,337 ",
        "$24,329 ",
        "$24,325 ",
        "$24,324 ",
        "$24,314 ",
        "$24,312 ",
        "$24,308 ",
        "$24,299 ",
        "$24,297 ",
        "$24,296 ",
        "$24,295 ",
        "$24,291 ",
        "$24,290 ",
        "$24,286 ",
        "$24,273 ",
        "$24,272 ",
        "$24,270 ",
        "$24,269 ",
        "$24,260 ",
        "$24,258 ",
        "$24,257 ",
        "$24,253 ",
        "$24,247 ",
        "$24,234 ",
        "$24,224 ",
        "$24,219 ",
        "$24,217 ",
        "$24,205 ",
        "$24,203 ",
        "$24,199 ",
        "$24,195 ",
        "$24,189 ",
        "$24,183 ",
        "$24,179 ",
        "$24,177 ",
        "$24,175 ",
        "$24,174 ",
        "$24,173 ",
        "$24,170 ",
        "$24,168 ",
        "$24,165 ",
        "$24,162 ",
        "$24,161 ",
        "$24,157 ",
        "$24,154 ",
        "$24,152 ",
        "$24,147 ",
        "$24,140 ",
        "$24,139 ",
        "$24,138 ",
        "$24,137 ",
        "$24,127 ",
        "$24,124 ",
        "$24,120 ",
        "$24,117 ",
        "$24,114 ",
        "$24,101 ",
        "$24,096 ",
        "$24,094 ",
        "$24,086 ",
        "$24,085 ",
        "$24,079 ",
        "$24,073 ",
        "$24,071 ",
        "$24,064 ",
        "$24,063 ",
        "$24,058 ",
        "$24,042 ",
        "$24,037 ",
        "$24,028 ",
        "$24,026 ",
        "$24,025 ",
        "$24,014 ",
        "$24,013 ",
        "$24,005 ",
        "$24,003 ",
        "$24,002 ",
        "$23,998 ",
        "$23,992 ",
        "$23,991 ",
        "$23,987 ",
        "$23,978 ",
        "$23,975 ",
        "$23,973 ",
        "$23,972 ",
        "$23,969 ",
        "$23,965 ",
        "$23,959 ",
        "$23,948 ",
        "$23,936 ",
        "$23,918 ",
        "$23,915 ",
        "$23,910 ",
        "$23,907 ",
        "$23,904 ",
        "$23,895 ",
        "$23,888 ",
        "$23,885 ",
        "$23,879 ",
        "$23,878 ",
        "$23,876 ",
        "$23,875 ",
        "$23,872 ",
        "$23,868 ",
        "$23,862 ",
        "$23,856 ",
        "$23,853 ",
        "$23,851 ",
        "$23,850 ",
        "$23,839 ",
        "$23,833 ",
        "$23,828 ",
        "$23,814 ",
        "$23,811 ",
        "$23,809 ",
        "$23,805 ",
        "$23,799 ",
        "$23,793 ",
        "$23,789 ",
        "$23,788 ",
        "$23,787 ",
        "$23,786 ",
        "$23,781 ",
        "$23,779 ",
        "$23,775 ",
        "$23,773 ",
        "$23,772 ",
        "$23,769 ",
        "$23,768 ",
        "$23,764 ",
        "$23,757 ",
        "$23,753 ",
        "$23,751 ",
        "$23,749 ",
        "$23,742 ",
        "$23,738 ",
        "$23,736 ",
        "$23,732 ",
        "$23,724 ",
        "$23,723 ",
        "$23,720 ",
        "$23,714 ",
        "$23,712 ",
        "$23,707 ",
        "$23,696 ",
        "$23,691 ",
        "$23,686 ",
        "$23,684 ",
        "$23,683 ",
        "$23,681 ",
        "$23,677 ",
        "$23,671 ",
        "$23,670 ",
        "$23,667 ",
        "$23,666 ",
        "$23,661 ",
        "$23,656 ",
        "$23,655 ",
        "$23,647 ",
        "$23,645 ",
        "$23,641 ",
        "$23,637 ",
        "$23,636 ",
        "$23,629 ",
        "$23,626 ",
        "$23,624 ",
        "$23,621 ",
        "$23,608 ",
        "$23,605 ",
        "$23,602 ",
        "$23,591 ",
        "$23,586 ",
        "$23,584 ",
        "$23,576 ",
        "$23,566 ",
        "$23,562 ",
        "$23,558 ",
        "$23,557 ",
        "$23,555 ",
        "$23,554 ",
        "$23,548 ",
        "$23,545 ",
        "$23,542 ",
        "$23,540 ",
        "$23,526 ",
        "$23,520 ",
        "$23,514 ",
        "$23,510 ",
        "$23,509 ",
        "$23,508 ",
        "$23,506 ",
        "$23,504 ",
        "$23,500 ",
        "$23,496 ",
        "$23,491 ",
        "$23,490 ",
        "$23,485 ",
        "$23,483 ",
        "$23,475 ",
        "$23,473 ",
        "$23,472 ",
        "$23,461 ",
        "$23,459 ",
        "$23,456 ",
        "$23,441 ",
        "$23,435 ",
        "$23,423 ",
        "$23,421 ",
        "$23,418 ",
        "$23,417 ",
        "$23,412 ",
        "$23,411 ",
        "$23,396 ",
        "$23,391 ",
        "$23,389 ",
        "$23,383 ",
        "$23,382 ",
        "$23,381 ",
        "$23,380 ",
        "$23,377 ",
        "$23,374 ",
        "$23,373 ",
        "$23,368 ",
        "$23,358 ",
        "$23,350 ",
        "$23,347 ",
        "$23,343 ",
        "$23,342 ",
        "$23,337 ",
        "$23,324 ",
        "$23,320 ",
        "$23,316 ",
        "$23,309 ",
        "$23,307 ",
        "$23,306 ",
        "$23,299 ",
        "$23,295 ",
        "$23,285 ",
        "$23,283 ",
        "$23,270 ",
        "$23,269 ",
        "$23,266 ",
        "$23,264 ",
        "$23,261 ",
        "$23,257 ",
        "$23,247 ",
        "$23,244 ",
        "$23,240 ",
        "$23,239 ",
        "$23,236 ",
        "$23,234 ",
        "$23,232 ",
        "$23,231 ",
        "$23,230 ",
        "$23,229 ",
        "$23,227 ",
        "$23,222 ",
        "$23,221 ",
        "$23,220 ",
        "$23,219 ",
        "$23,218 ",
        "$23,213 ",
        "$23,209 ",
        "$23,201 ",
        "$23,199 ",
        "$23,197 ",
        "$23,195 ",
        "$23,183 ",
        "$23,179 ",
        "$23,174 ",
        "$23,171 ",
        "$23,170 ",
        "$23,167 ",
        "$23,166 ",
        "$23,162 ",
        "$23,157 ",
        "$23,148 ",
        "$23,146 ",
        "$23,141 ",
        "$23,138 ",
        "$23,134 ",
        "$23,131 ",
        "$23,129 ",
        "$23,127 ",
        "$23,126 ",
        "$23,122 ",
        "$23,115 ",
        "$23,106 ",
        "$23,105 ",
        "$23,095 ",
        "$23,088 ",
        "$23,078 ",
        "$23,070 ",
        "$23,069 ",
        "$23,068 ",
        "$23,067 ",
        "$23,063 ",
        "$23,061 ",
        "$23,054 ",
        "$23,049 ",
        "$23,048 ",
        "$23,045 ",
        "$23,044 ",
        "$23,041 ",
        "$23,038 ",
        "$23,032 ",
        "$23,029 ",
        "$23,023 ",
        "$23,022 ",
        "$23,021 ",
        "$23,007 ",
        "$22,997 ",
        "$22,987 ",
        "$22,979 ",
        "$22,978 ",
        "$22,974 ",
        "$22,972 ",
        "$22,967 ",
        "$22,963 ",
        "$22,953 ",
        "$22,952 ",
        "$22,948 ",
        "$22,942 ",
        "$22,933 ",
        "$22,925 ",
        "$22,923 ",
        "$22,921 ",
        "$22,911 ",
        "$22,910 ",
        "$22,906 ",
        "$22,837 ",
        "$22,905 ",
        "$22,899 ",
        "$22,897 ",
        "$22,893 ",
        "$22,891 ",
        "$22,890 ",
        "$22,888 ",
        "$22,880 ",
        "$22,879 ",
        "$22,878 ",
        "$22,876 ",
        "$22,875 ",
        "$22,872 ",
        "$22,868 ",
        "$22,860 ",
        "$22,857 ",
        "$22,856 ",
        "$22,855 ",
        "$22,853 ",
        "$22,852 ",
        "$22,847 ",
        "$22,844 ",
        "$22,843 ",
        "$22,831 ",
        "$22,827 ",
        "$22,824 ",
        "$22,820 ",
        "$22,817 ",
        "$22,815 ",
        "$22,811 ",
        "$22,799 ",
        "$22,796 ",
        "$22,790 ",
        "$22,789 ",
        "$22,788 ",
        "$22,782 ",
        "$22,780 ",
        "$22,778 ",
        "$22,766 ",
        "$22,755 ",
        "$22,748 ",
        "$22,747 ",
        "$22,746 ",
        "$22,745 ",
        "$22,743 ",
        "$22,739 ",
        "$22,726 ",
        "$22,719 ",
        "$22,714 ",
        "$22,713 ",
        "$22,709 ",
        "$22,703 ",
        "$22,702 ",
        "$22,701 ",
        "$22,700 ",
        "$22,699 ",
        "$22,687 ",
        "$22,686 ",
        "$22,685 ",
        "$22,684 ",
        "$22,680 ",
        "$22,679 ",
        "$22,677 ",
        "$22,675 ",
        "$22,670 ",
        "$22,659 ",
        "$22,658 ",
        "$22,657 ",
        "$22,651 ",
        "$22,649 ",
        "$22,638 ",
        "$22,637 ",
        "$22,629 ",
        "$22,622 ",
        "$22,621 ",
        "$22,620 ",
        "$22,613 ",
        "$22,603 ",
        "$22,601 ",
        "$22,600 ",
        "$22,598 ",
        "$22,596 ",
        "$22,589 ",
        "$22,581 ",
        "$22,580 ",
        "$22,568 ",
        "$22,564 ",
        "$22,551 ",
        "$22,549 ",
        "$22,543 ",
        "$22,527 ",
        "$22,526 ",
        "$22,524 ",
        "$22,519 ",
        "$22,511 ",
        "$22,509 ",
        "$22,501 ",
        "$22,499 ",
        "$22,498 ",
        "$22,488 ",
        "$22,484 ",
        "$22,483 ",
        "$22,482 ",
        "$22,481 ",
        "$22,478 ",
        "$22,471 ",
        "$22,467 ",
        "$22,452 ",
        "$22,448 ",
        "$22,436 ",
        "$22,434 ",
        "$22,433 ",
        "$22,432 ",
        "$22,426 ",
        "$22,413 ",
        "$22,412 ",
        "$22,410 ",
        "$22,398 ",
        "$22,395 ",
        "$22,394 ",
        "$22,383 ",
        "$22,382 ",
        "$22,381 ",
        "$22,380 ",
        "$22,378 ",
        "$22,366 ",
        "$22,363 ",
        "$22,362 ",
        "$22,355 ",
        "$22,353 ",
        "$22,349 ",
        "$22,341 ",
        "$22,334 ",
        "$22,331 ",
        "$22,327 ",
        "$22,324 ",
        "$22,322 ",
        "$22,318 ",
        "$22,312 ",
        "$22,308 ",
        "$22,307 ",
        "$22,303 ",
        "$22,295 ",
        "$22,293 ",
        "$22,292 ",
        "$22,291 ",
        "$22,280 ",
        "$22,279 ",
        "$22,278 ",
        "$22,269 ",
        "$22,260 ",
        "$22,259 ",
        "$22,257 ",
        "$22,256 ",
        "$22,255 ",
        "$22,252 ",
        "$22,249 ",
        "$22,247 ",
        "$22,245 ",
        "$22,243 ",
        "$22,242 ",
        "$22,239 ",
        "$22,235 ",
        "$22,229 ",
        "$22,228 ",
        "$22,223 ",
        "$22,212 ",
        "$22,210 ",
        "$22,207 ",
        "$22,200 ",
        "$22,198 ",
        "$22,196 ",
        "$22,192 ",
        "$22,191 ",
        "$22,183 ",
        "$22,180 ",
        "$22,169 ",
        "$22,168 ",
        "$22,164 ",
        "$22,160 ",
        "$22,157 ",
        "$22,156 ",
        "$22,150 ",
        "$22,148 ",
        "$22,139 ",
        "$22,132 ",
        "$22,127 ",
        "$22,126 ",
        "$22,123 ",
        "$22,120 ",
        "$22,099 ",
        "$22,097 ",
        "$22,093 ",
        "$22,092 ",
        "$22,083 ",
        "$22,081 ",
        "$22,075 ",
        "$22,072 ",
        "$22,070 ",
        "$22,068 ",
        "$22,064 ",
        "$22,063 ",
        "$22,060 ",
        "$22,059 ",
        "$22,056 ",
        "$22,052 ",
        "$22,049 ",
        "$22,047 ",
        "$22,046 ",
        "$22,035 ",
        "$22,030 ",
        "$22,026 ",
        "$22,015 ",
        "$22,001 ",
        "$21,995 ",
        "$21,992 ",
        "$21,990 ",
        "$21,989 ",
        "$21,986 ",
        "$21,984 ",
        "$21,976 ",
        "$21,970 ",
        "$21,966 ",
        "$21,961 ",
        "$21,960 ",
        "$21,948 ",
        "$21,947 ",
        "$21,946 ",
        "$21,942 ",
        "$21,940 ",
        "$21,936 ",
        "$21,933 ",
        "$21,932 ",
        "$21,928 ",
        "$21,924 ",
        "$21,923 ",
        "$21,920 ",
        "$21,917 ",
        "$21,909 ",
        "$21,904 ",
        "$21,903 ",
        "$21,902 ",
        "$21,889 ",
        "$21,888 ",
        "$21,887 ",
        "$21,875 ",
        "$21,870 ",
        "$21,854 ",
        "$21,853 ",
        "$21,852 ",
        "$21,850 ",
        "$21,849 ",
        "$21,843 ",
        "$21,838 ",
        "$21,837 ",
        "$21,832 ",
        "$21,830 ",
        "$21,828 ",
        "$21,819 ",
        "$21,818 ",
        "$21,816 ",
        "$21,811 ",
        "$21,800 ",
        "$21,799 ",
        "$21,797 ",
        "$21,793 ",
        "$21,791 ",
        "$21,783 ",
        "$21,775 ",
        "$21,774 ",
        "$21,769 ",
        "$21,757 ",
        "$21,744 ",
        "$21,743 ",
        "$21,741 ",
        "$21,738 ",
        "$21,737 ",
        "$21,733 ",
        "$21,732 ",
        "$21,720 ",
        "$21,719 ",
        "$21,712 ",
        "$21,709 ",
        "$21,705 ",
        "$21,701 ",
        "$21,700 ",
        "$21,690 ",
        "$21,670 ",
        "$21,663 ",
        "$21,660 ",
        "$21,655 ",
        "$21,653 ",
        "$21,649 ",
        "$21,641 ",
        "$21,640 ",
        "$21,639 ",
        "$21,636 ",
        "$21,629 ",
        "$21,628 ",
        "$21,627 ",
        "$21,622 ",
        "$21,616 ",
        "$21,606 ",
        "$21,599 ",
        "$21,598 ",
        "$21,596 ",
        "$21,593 ",
        "$21,592 ",
        "$21,591 ",
        "$21,585 ",
        "$21,583 ",
        "$21,579 ",
        "$21,575 ",
        "$21,572 ",
        "$21,566 ",
        "$21,557 ",
        "$21,555 ",
        "$21,554 ",
        "$21,547 ",
        "$21,540 ",
        "$21,537 ",
        "$21,536 ",
        "$21,532 ",
        "$21,529 ",
        "$21,527 ",
        "$21,524 ",
        "$21,523 ",
        "$21,521 ",
        "$21,520 ",
        "$21,519 ",
        "$21,513 ",
        "$21,500 ",
        "$21,499 ",
        "$21,498 ",
        "$21,492 ",
        "$21,490 ",
        "$21,489 ",
        "$21,487 ",
        "$21,485 ",
        "$21,484 ",
        "$21,482 ",
        "$21,478 ",
        "$21,476 ",
        "$21,474 ",
        "$21,472 ",
        "$21,468 ",
        "$21,461 ",
        "$21,457 ",
        "$21,452 ",
        "$21,449 ",
        "$21,445 ",
        "$21,443 ",
        "$21,441 ",
        "$21,440 ",
        "$21,434 ",
        "$21,424 ",
        "$21,423 ",
        "$21,416 ",
        "$21,413 ",
        "$21,411 ",
        "$21,408 ",
        "$21,404 ",
        "$21,399 ",
        "$21,396 ",
        "$21,389 ",
        "$21,388 ",
        "$21,387 ",
        "$21,379 ",
        "$21,376 ",
        "$21,375 ",
        "$21,370 ",
        "$21,368 ",
        "$21,365 ",
        "$21,358 ",
        "$21,350 ",
        "$21,346 ",
        "$21,344 ",
        "$21,343 ",
        "$21,341 ",
        "$21,335 ",
        "$21,334 ",
        "$21,333 ",
        "$21,332 ",
        "$21,327 ",
        "$21,318 ",
        "$21,317 ",
        "$21,313 ",
        "$21,312 ",
        "$21,311 ",
        "$21,310 ",
        "$21,300 ",
        "$21,297 ",
        "$21,292 ",
        "$21,285 ",
        "$21,273 ",
        "$21,261 ",
        "$21,260 ",
        "$21,259 ",
        "$21,253 ",
        "$21,248 ",
        "$21,245 ",
        "$21,236 ",
        "$21,227 ",
        "$21,226 ",
        "$21,225 ",
        "$21,220 ",
        "$21,215 ",
        "$21,211 ",
        "$21,208 ",
        "$21,206 ",
        "$21,201 ",
        "$21,200 ",
        "$21,192 ",
        "$21,187 ",
        "$21,184 ",
        "$21,182 ",
        "$21,177 ",
        "$21,175 ",
        "$21,173 ",
        "$21,168 ",
        "$21,163 ",
        "$21,153 ",
        "$21,141 ",
        "$21,137 ",
        "$21,132 ",
        "$21,126 ",
        "$21,125 ",
        "$21,124 ",
        "$21,115 ",
        "$21,114 ",
        "$21,109 ",
        "$21,102 ",
        "$21,089 ",
        "$21,084 ",
        "$21,053 ",
        "$21,047 ",
        "$21,046 ",
        "$21,041 ",
        "$21,037 ",
        "$21,029 ",
        "$21,027 ",
        "$21,022 ",
        "$21,016 ",
        "$21,015 ",
        "$21,014 ",
        "$21,011 ",
        "$21,004 ",
        "$21,003 ",
        "$20,995 ",
        "$20,991 ",
        "$20,982 ",
        "$20,978 ",
        "$20,974 ",
        "$20,972 ",
        "$20,951 ",
        "$20,946 ",
        "$20,941 ",
        "$20,937 ",
        "$20,934 ",
        "$20,929 ",
        "$20,918 ",
        "$20,912 ",
        "$20,910 ",
        "$20,908 ",
        "$20,900 ",
        "$20,899 ",
        "$20,898 ",
        "$20,892 ",
        "$20,887 ",
        "$20,884 ",
        "$20,883 ",
        "$20,875 ",
        "$20,868 ",
        "$20,865 ",
        "$20,863 ",
        "$20,862 ",
        "$20,859 ",
        "$20,854 ",
        "$20,848 ",
        "$20,838 ",
        "$20,837 ",
        "$20,836 ",
        "$20,833 ",
        "$20,828 ",
        "$20,825 ",
        "$20,807 ",
        "$20,802 ",
        "$20,794 ",
        "$20,792 ",
        "$20,791 ",
        "$20,775 ",
        "$20,774 ",
        "$20,767 ",
        "$20,760 ",
        "$20,754 ",
        "$20,753 ",
        "$20,746 ",
        "$20,742 ",
        "$20,739 ",
        "$20,737 ",
        "$20,735 ",
        "$20,730 ",
        "$20,726 ",
        "$20,720 ",
        "$20,718 ",
        "$20,713 ",
        "$20,704 ",
        "$20,701 ",
        "$20,698 ",
        "$20,697 ",
        "$20,680 ",
        "$20,678 ",
        "$20,677 ",
        "$20,667 ",
        "$20,663 ",
        "$20,662 ",
        "$20,655 ",
        "$20,646 ",
        "$20,644 ",
        "$20,641 ",
        "$20,637 ",
        "$20,636 ",
        "$20,633 ",
        "$20,624 ",
        "$20,623 ",
        "$20,622 ",
        "$20,621 ",
        "$20,619 ",
        "$20,616 ",
        "$20,609 ",
        "$20,603 ",
        "$20,595 ",
        "$20,591 ",
        "$20,589 ",
        "$20,588 ",
        "$20,586 ",
        "$20,585 ",
        "$20,578 ",
        "$20,573 ",
        "$20,570 ",
        "$20,566 ",
        "$20,557 ",
        "$20,556 ",
        "$20,555 ",
        "$20,552 ",
        "$20,549 ",
        "$20,543 ",
        "$20,537 ",
        "$20,535 ",
        "$20,534 ",
        "$20,527 ",
        "$20,526 ",
        "$20,524 ",
        "$20,523 ",
        "$20,517 ",
        "$20,516 ",
        "$20,504 ",
        "$20,500 ",
        "$20,493 ",
        "$20,491 ",
        "$20,487 ",
        "$20,486 ",
        "$20,481 ",
        "$20,475 ",
        "$20,467 ",
        "$20,462 ",
        "$20,452 ",
        "$20,450 ",
        "$20,449 ",
        "$20,448 ",
        "$20,440 ",
        "$20,439 ",
        "$20,436 ",
        "$20,431 ",
        "$20,419 ",
        "$20,407 ",
        "$20,402 ",
        "$20,395 ",
        "$20,394 ",
        "$20,391 ",
        "$20,388 ",
        "$20,382 ",
        "$20,380 ",
        "$20,379 ",
        "$20,373 ",
        "$20,371 ",
        "$20,368 ",
        "$20,363 ",
        "$20,362 ",
        "$20,357 ",
        "$20,340 ",
        "$20,337 ",
        "$20,334 ",
        "$20,331 ",
        "$20,330 ",
        "$20,329 ",
        "$20,327 ",
        "$20,323 ",
        "$20,322 ",
        "$20,319 ",
        "$20,316 ",
        "$20,310 ",
        "$20,309 ",
        "$20,307 ",
        "$20,305 ",
        "$20,295 ",
        "$20,294 ",
        "$20,289 ",
        "$20,288 ",
        "$20,279 ",
        "$20,274 ",
        "$20,271 ",
        "$20,258 ",
        "$20,257 ",
        "$20,256 ",
        "$20,254 ",
        "$20,250 ",
        "$20,248 ",
        "$20,245 ",
        "$20,242 ",
        "$20,235 ",
        "$20,231 ",
        "$20,219 ",
        "$20,217 ",
        "$20,208 ",
        "$20,206 ",
        "$20,204 ",
        "$20,202 ",
        "$20,199 ",
        "$20,198 ",
        "$20,193 ",
        "$20,181 ",
        "$20,180 ",
        "$20,179 ",
        "$20,178 ",
        "$20,160 ",
        "$20,157 ",
        "$20,156 ",
        "$20,155 ",
        "$20,152 ",
        "$20,150 ",
        "$20,142 ",
        "$20,137 ",
        "$20,127 ",
        "$20,109 ",
        "$20,105 ",
        "$20,104 ",
        "$20,074 ",
        "$20,072 ",
        "$20,071 ",
        "$20,062 ",
        "$20,056 ",
        "$20,054 ",
        "$20,052 ",
        "$20,045 ",
        "$20,042 ",
        "$20,040 ",
        "$20,039 ",
        "$20,034 ",
        "$20,032 ",
        "$20,019 ",
        "$20,014 ",
        "$20,011 ",
        "$20,008 ",
        "$20,001 ",
        "$19,998 ",
        "$19,994 ",
        "$19,984 ",
        "$19,983 ",
        "$19,976 ",
        "$19,972 ",
        "$19,970 ",
        "$19,968 ",
        "$19,967 ",
        "$19,965 ",
        "$19,955 ",
        "$19,947 ",
        "$19,939 ",
        "$19,931 ",
        "$19,929 ",
        "$19,923 ",
        "$19,918 ",
        "$19,917 ",
        "$19,910 ",
        "$19,902 ",
        "$19,901 ",
        "$19,900 ",
        "$19,899 ",
        "$19,890 ",
        "$19,880 ",
        "$19,877 ",
        "$19,871 ",
        "$19,868 ",
        "$19,867 ",
        "$19,861 ",
        "$19,859 ",
        "$19,858 ",
        "$19,852 ",
        "$19,843 ",
        "$19,837 ",
        "$19,830 ",
        "$19,829 ",
        "$19,822 ",
        "$19,821 ",
        "$19,820 ",
        "$19,801 ",
        "$19,795 ",
        "$19,789 ",
        "$19,788 ",
        "$19,783 ",
        "$19,780 ",
        "$19,773 ",
        "$19,770 ",
        "$19,761 ",
        "$19,760 ",
        "$19,753 ",
        "$19,752 ",
        "$19,745 ",
        "$19,744 ",
        "$19,740 ",
        "$19,738 ",
        "$19,736 ",
        "$19,735 ",
        "$19,734 ",
        "$19,729 ",
        "$19,725 ",
        "$19,717 ",
        "$19,716 ",
        "$19,715 ",
        "$19,710 ",
        "$19,709 ",
        "$19,708 ",
        "$19,703 ",
        "$19,701 ",
        "$19,687 ",
        "$19,678 ",
        "$19,674 ",
        "$19,673 ",
        "$19,665 ",
        "$19,661 ",
        "$19,652 ",
        "$19,643 ",
        "$19,634 ",
        "$19,626 ",
        "$19,623 ",
        "$19,612 ",
        "$19,611 ",
        "$19,598 ",
        "$19,597 ",
        "$19,595 ",
        "$19,588 ",
        "$19,583 ",
        "$19,580 ",
        "$19,576 ",
        "$19,566 ",
        "$19,565 ",
        "$19,553 ",
        "$19,551 ",
        "$19,547 ",
        "$19,531 ",
        "$19,527 ",
        "$19,519 ",
        "$19,517 ",
        "$19,511 ",
        "$19,510 ",
        "$19,503 ",
        "$19,498 ",
        "$19,497 ",
        "$19,492 ",
        "$19,489 ",
        "$19,487 ",
        "$19,481 ",
        "$19,479 ",
        "$19,477 ",
        "$19,475 ",
        "$19,470 ",
        "$19,468 ",
        "$19,464 ",
        "$19,457 ",
        "$19,451 ",
        "$19,450 ",
        "$19,445 ",
        "$19,441 ",
        "$19,439 ",
        "$19,437 ",
        "$19,435 ",
        "$19,433 ",
        "$19,431 ",
        "$19,429 ",
        "$19,415 ",
        "$19,412 ",
        "$19,410 ",
        "$19,409 ",
        "$19,405 ",
        "$19,403 ",
        "$19,397 ",
        "$19,396 ",
        "$19,387 ",
        "$19,386 ",
        "$19,385 ",
        "$19,372 ",
        "$19,366 ",
        "$19,357 ",
        "$19,356 ",
        "$19,353 ",
        "$19,352 ",
        "$19,351 ",
        "$19,348 ",
        "$19,340 ",
        "$19,337 ",
        "$19,336 ",
        "$19,332 ",
        "$19,331 ",
        "$19,326 ",
        "$19,317 ",
        "$19,306 ",
        "$19,304 ",
        "$19,303 ",
        "$19,295 ",
        "$19,292 ",
        "$19,291 ",
        "$19,286 ",
        "$19,279 ",
        "$19,275 ",
        "$19,273 ",
        "$19,268 ",
        "$19,258 ",
        "$19,256 ",
        "$19,246 ",
        "$19,244 ",
        "$19,240 ",
        "$19,236 ",
        "$19,228 ",
        "$19,212 ",
        "$19,204 ",
        "$19,188 ",
        "$19,177 ",
        "$19,176 ",
        "$19,168 ",
        "$19,165 ",
        "$19,164 ",
        "$19,154 ",
        "$19,153 ",
        "$19,145 ",
        "$19,143 ",
        "$19,141 ",
        "$19,136 ",
        "$19,135 ",
        "$19,116 ",
        "$19,115 ",
        "$19,108 ",
        "$19,107 ",
        "$19,101 ",
        "$19,100 ",
        "$19,090 ",
        "$19,087 ",
        "$19,086 ",
        "$19,082 ",
        "$19,078 ",
        "$19,072 ",
        "$19,061 ",
        "$19,060 ",
        "$19,052 ",
        "$19,046 ",
        "$19,042 ",
        "$19,037 ",
        "$19,032 ",
        "$19,030 ",
        "$19,029 ",
        "$19,026 ",
        "$19,021 ",
        "$19,020 ",
        "$19,018 ",
        "$19,015 ",
        "$19,014 ",
        "$19,007 ",
        "$19,006 ",
        "$19,005 ",
        "$19,004 ",
        "$19,002 ",
        "$18,998 ",
        "$18,995 ",
        "$18,986 ",
        "$18,979 ",
        "$18,975 ",
        "$18,970 ",
        "$18,969 ",
        "$18,967 ",
        "$18,964 ",
        "$18,959 ",
        "$18,958 ",
        "$18,957 ",
        "$18,954 ",
        "$18,952 ",
        "$18,941 ",
        "$18,936 ",
        "$18,934 ",
        "$18,933 ",
        "$18,932 ",
        "$18,928 ",
        "$18,920 ",
        "$18,918 ",
        "$18,910 ",
        "$18,905 ",
        "$18,902 ",
        "$18,897 ",
        "$18,896 ",
        "$18,888 ",
        "$18,872 ",
        "$18,871 ",
        "$18,865 ",
        "$18,864 ",
        "$18,862 ",
        "$18,860 ",
        "$18,857 ",
        "$18,853 ",
        "$18,845 ",
        "$18,842 ",
        "$18,840 ",
        "$18,836 ",
        "$18,835 ",
        "$18,828 ",
        "$18,821 ",
        "$18,820 ",
        "$18,817 ",
        "$18,816 ",
        "$18,812 ",
        "$18,801 ",
        "$18,800 ",
        "$18,790 ",
        "$18,783 ",
        "$18,782 ",
        "$18,779 ",
        "$18,769 ",
        "$18,768 ",
        "$18,763 ",
        "$18,762 ",
        "$18,761 ",
        "$18,757 ",
        "$18,754 ",
        "$18,750 ",
        "$18,744 ",
        "$18,730 ",
        "$18,728 ",
        "$18,717 ",
        "$18,716 ",
        "$18,714 ",
        "$18,707 ",
        "$18,701 ",
        "$18,695 ",
        "$18,694 ",
        "$18,693 ",
        "$18,685 ",
        "$18,676 ",
        "$18,675 ",
        "$18,669 ",
        "$18,664 ",
        "$18,660 ",
        "$18,650 ",
        "$18,640 ",
        "$18,635 ",
        "$18,628 ",
        "$18,625 ",
        "$18,622 ",
        "$18,619 ",
        "$18,602 ",
        "$18,597 ",
        "$18,592 ",
        "$18,587 ",
        "$18,583 ",
        "$18,582 ",
        "$18,576 ",
        "$18,558 ",
        "$18,557 ",
        "$18,551 ",
        "$18,546 ",
        "$18,544 ",
        "$18,542 ",
        "$18,539 ",
        "$18,509 ",
        "$18,501 ",
        "$18,497 ",
        "$18,495 ",
        "$18,494 ",
        "$18,493 ",
        "$18,472 ",
        "$18,458 ",
        "$18,456 ",
        "$18,453 ",
        "$18,449 ",
        "$18,448 ",
        "$18,441 ",
        "$18,431 ",
        "$18,429 ",
        "$18,428 ",
        "$18,422 ",
        "$18,415 ",
        "$18,408 ",
        "$18,392 ",
        "$18,387 ",
        "$18,383 ",
        "$18,379 ",
        "$18,377 ",
        "$18,373 ",
        "$18,368 ",
        "$18,347 ",
        "$18,340 ",
        "$18,338 ",
        "$18,336 ",
        "$18,331 ",
        "$18,330 ",
        "$18,321 ",
        "$18,318 ",
        "$18,314 ",
        "$18,304 ",
        "$18,273 ",
        "$18,268 ",
        "$18,253 ",
        "$18,245 ",
        "$18,240 ",
        "$18,235 ",
        "$18,234 ",
        "$18,224 ",
        "$18,215 ",
        "$18,207 ",
        "$18,205 ",
        "$18,203 ",
        "$18,188 ",
        "$18,185 ",
        "$18,183 ",
        "$18,177 ",
        "$18,171 ",
        "$18,167 ",
        "$18,162 ",
        "$18,160 ",
        "$18,155 ",
        "$18,149 ",
        "$18,148 ",
        "$18,141 ",
        "$18,137 ",
        "$18,136 ",
        "$18,134 ",
        "$18,131 ",
        "$18,126 ",
        "$18,114 ",
        "$18,108 ",
        "$18,106 ",
        "$18,104 ",
        "$18,101 ",
        "$18,099 ",
        "$18,098 ",
        "$18,094 ",
        "$18,079 ",
        "$18,075 ",
        "$18,073 ",
        "$18,066 ",
        "$18,059 ",
        "$18,057 ",
        "$18,053 ",
        "$18,040 ",
        "$18,035 ",
        "$18,023 ",
        "$18,009 ",
        "$18,006 ",
        "$18,004 ",
        "$17,990 ",
        "$17,984 ",
        "$17,980 ",
        "$17,978 ",
        "$17,975 ",
        "$17,974 ",
        "$17,969 ",
        "$17,960 ",
        "$17,952 ",
        "$17,950 ",
        "$17,937 ",
        "$17,936 ",
        "$17,935 ",
        "$17,933 ",
        "$17,931 ",
        "$17,926 ",
        "$17,922 ",
        "$17,919 ",
        "$17,905 ",
        "$17,894 ",
        "$17,886 ",
        "$17,884 ",
        "$17,880 ",
        "$17,879 ",
        "$17,876 ",
        "$17,870 ",
        "$17,868 ",
        "$17,867 ",
        "$17,863 ",
        "$17,858 ",
        "$17,847 ",
        "$17,846 ",
        "$17,843 ",
        "$17,842 ",
        "$17,839 ",
        "$17,815 ",
        "$17,811 ",
        "$17,801 ",
        "$17,787 ",
        "$17,781 ",
        "$17,763 ",
        "$17,755 ",
        "$17,752 ",
        "$17,751 ",
        "$17,749 ",
        "$17,747 ",
        "$17,739 ",
        "$17,735 ",
        "$17,734 ",
        "$17,716 ",
        "$17,706 ",
        "$17,703 ",
        "$17,701 ",
        "$17,697 ",
        "$17,687 ",
        "$17,684 ",
        "$17,677 ",
        "$17,665 ",
        "$17,664 ",
        "$17,656 ",
        "$17,641 ",
        "$17,630 ",
        "$17,620 ",
        "$17,615 ",
        "$17,609 ",
        "$17,587 ",
        "$17,579 ",
        "$17,565 ",
        "$17,544 ",
        "$17,532 ",
        "$17,525 ",
        "$17,516 ",
        "$17,515 ",
        "$17,512 ",
        "$17,505 ",
        "$17,489 ",
        "$17,479 ",
        "$17,477 ",
        "$17,476 ",
        "$17,437 ",
        "$17,427 ",
        "$17,426 ",
        "$17,420 ",
        "$17,416 ",
        "$17,403 ",
        "$17,385 ",
        "$17,376 ",
        "$17,371 ",
        "$17,361 ",
        "$17,350 ",
        "$17,341 ",
        "$17,337 ",
        "$17,336 ",
        "$17,334 ",
        "$17,316 ",
        "$17,273 ",
        "$17,270 ",
        "$17,264 ",
        "$17,245 ",
        "$17,241 ",
        "$17,236 ",
        "$17,228 ",
        "$17,215 ",
        "$17,214 ",
        "$17,212 ",
        "$17,208 ",
        "$17,187 ",
        "$17,183 ",
        "$17,182 ",
        "$17,177 ",
        "$17,175 ",
        "$17,171 ",
        "$17,168 ",
        "$17,167 ",
        "$17,158 ",
        "$17,153 ",
        "$17,145 ",
        "$17,140 ",
        "$17,122 ",
        "$17,121 ",
        "$17,120 ",
        "$17,107 ",
        "$17,106 ",
        "$17,102 ",
        "$17,096 ",
        "$17,094 ",
        "$17,080 ",
        "$17,078 ",
        "$17,064 ",
        "$17,057 ",
        "$17,045 ",
        "$17,034 ",
        "$17,031 ",
        "$17,025 ",
        "$17,019 ",
        "$17,009 ",
        "$16,993 ",
        "$16,992 ",
        "$16,977 ",
        "$16,971 ",
        "$16,959 ",
        "$16,940 ",
        "$16,939 ",
        "$16,938 ",
        "$16,919 ",
        "$16,897 ",
        "$16,888 ",
        "$16,881 ",
        "$16,867 ",
        "$16,862 ",
        "$16,851 ",
        "$16,850 ",
        "$16,848 ",
        "$16,845 ",
        "$16,838 ",
        "$16,836 ",
        "$16,830 ",
        "$16,829 ",
        "$16,826 ",
        "$16,812 ",
        "$16,807 ",
        "$16,795 ",
        "$16,789 ",
        "$16,784 ",
        "$16,780 ",
        "$16,763 ",
        "$16,752 ",
        "$16,748 ",
        "$16,740 ",
        "$16,731 ",
        "$16,714 ",
        "$16,700 ",
        "$16,683 ",
        "$16,677 ",
        "$16,671 ",
        "$16,664 ",
        "$16,658 ",
        "$16,656 ",
        "$16,635 ",
        "$16,626 ",
        "$16,589 ",
        "$16,546 ",
        "$16,540 ",
        "$16,538 ",
        "$16,531 ",
        "$16,530 ",
        "$16,528 ",
        "$16,513 ",
        "$16,486 ",
        "$16,470 ",
        "$16,462 ",
        "$16,460 ",
        "$16,454 ",
        "$16,449 ",
        "$16,435 ",
        "$16,431 ",
        "$16,424 ",
        "$16,408 ",
        "$16,404 ",
        "$16,396 ",
        "$16,380 ",
        "$16,367 ",
        "$16,362 ",
        "$16,352 ",
        "$16,331 ",
        "$16,330 ",
        "$16,295 ",
        "$16,275 ",
        "$16,266 ",
        "$16,257 ",
        "$16,233 ",
        "$16,227 ",
        "$16,216 ",
        "$16,202 ",
        "$16,181 ",
        "$16,175 ",
        "$16,171 ",
        "$16,133 ",
        "$16,132 ",
        "$16,129 ",
        "$16,114 ",
        "$16,060 ",
        "$16,045 ",
        "$16,021 ",
        "$16,011 ",
        "$15,971 ",
        "$15,960 ",
        "$15,958 ",
        "$15,945 ",
        "$15,942 ",
        "$15,936 ",
        "$15,880 ",
        "$15,863 ",
        "$15,861 ",
        "$15,760 ",
        "$15,758 ",
        "$15,749 ",
        "$15,747 ",
        "$15,744 ",
        "$15,742 ",
        "$15,734 ",
        "$15,695 ",
        "$15,694 ",
        "$15,683 ",
        "$15,679 ",
        "$15,609 ",
        "$15,605 ",
        "$15,604 ",
        "$15,603 ",
        "$15,558 ",
        "$15,549 ",
        "$15,538 ",
        "$15,525 ",
        "$15,523 ",
        "$15,511 ",
        "$15,502 ",
        "$15,478 ",
        "$15,476 ",
        "$15,467 ",
        "$15,366 ",
        "$15,343 ",
        "$15,280 ",
        "$15,174 ",
        "$15,157 ",
        "$15,133 ",
        "$15,131 ",
        "$15,118 ",
        "$15,116 ",
        "$15,091 ",
        "$15,088 ",
        "$15,081 ",
        "$15,023 ",
        "$14,988 ",
        "$14,975 ",
        "$14,930 ",
        "$14,868 ",
        "$14,845 ",
        "$14,827 ",
        "$14,763 ",
        "$14,757 ",
        "$14,752 ",
        "$14,740 ",
        "$14,710 ",
        "$14,706 ",
        "$14,675 ",
        "$14,577 ",
        "$14,553 ",
        "$14,510 ",
        "$14,463 ",
        "$14,381 ",
        "$14,367 ",
        "$14,345 ",
        "$14,326 ",
        "$14,307 ",
        "$14,291 ",
        "$14,262 ",
        "$14,222 ",
        "$14,204 ",
        "$14,201 ",
        "$14,198 ",
        "$14,157 ",
        "$14,156 ",
        "$14,147 ",
        "$14,142 ",
        "$14,093 ",
        "$14,040 ",
        "$13,969 ",
        "$13,954 ",
        "$13,865 ",
        "$13,795 ",
        "$13,731 ",
        "$13,716 ",
        "$13,668 ",
        "$13,646 ",
        "$13,619 ",
        "$13,611 ",
        "$13,590 ",
        "$13,585 ",
        "$13,542 ",
        "$13,379 ",
        "$13,334 ",
        "$13,307 ",
        "$13,238 ",
        "$13,228 ",
        "$12,982 ",
        "$12,874 ",
        "$12,828 ",
        "$12,780 ",
        "$12,747 ",
        "$12,723 ",
        "$12,709 ",
        "$12,679 ",
        "$12,588 ",
        "$12,529 ",
        "$12,489 ",
        "$12,381 ",
        "$12,339 ",
        "$12,177 ",
        "$12,113 ",
        "$12,055 ",
        "$12,042 ",
        "$11,818 ",
        "$11,584 ",
        "$11,405 ",
        "$11,313 ",
        "$11,210 ",
        "$10,575 ",
        "$8,948 ",
        "$8,768 "
      ]
    },
    {
      "datamart_id": 5,
      "semantic_type": [],
      "name": "Median household income",
      "description": "column name: Median household income, dtype: object",
      "named_entity": [
        "$69,659 ",
        "$103,208 ",
        "$120,000 ",
        "$90,839 ",
        "$85,706 ",
        "$72,745 ",
        "$106,686 ",
        "$110,292 ",
        "$106,143 ",
        "$71,607 ",
        "$98,221 ",
        "$98,633 ",
        "$82,283 ",
        "$75,604 ",
        "$109,865 ",
        "$81,946 ",
        "$99,020 ",
        "$85,478 ",
        "$122,238 ",
        "$80,761 ",
        "$88,202 ",
        "$59,375 ",
        "$65,830 ",
        "$80,976 ",
        "$84,916 ",
        "$97,242 ",
        "$101,591 ",
        "$68,078 ",
        "$83,794 ",
        "$82,090 ",
        "$84,526 ",
        "$83,336 ",
        "$97,690 ",
        "$47,083 ",
        "$86,050 ",
        "$75,457 ",
        "$67,259 ",
        "$91,702 ",
        "$79,183 ",
        "$89,779 ",
        "$63,594 ",
        "$87,430 ",
        "$95,117 ",
        "$71,713 ",
        "$89,757 ",
        "$76,994 ",
        "$71,811 ",
        "$88,409 ",
        "$82,468 ",
        "$74,456 ",
        "$76,960 ",
        "$71,238 ",
        "$74,717 ",
        "$77,597 ",
        "$76,210 ",
        "$78,487 ",
        "$81,892 ",
        "$77,348 ",
        "$95,477 ",
        "$78,756 ",
        "$87,256 ",
        "$63,885 ",
        "$61,597 ",
        "$77,469 ",
        "$67,956 ",
        "$57,083 ",
        "$87,335 ",
        "$82,762 ",
        "$53,376 ",
        "$71,338 ",
        "$75,850 ",
        "$81,490 ",
        "$64,403 ",
        "$67,255 ",
        "$76,555 ",
        "$73,480 ",
        "$83,773 ",
        "$77,998 ",
        "$98,071 ",
        "$93,160 ",
        "$67,725 ",
        "$71,667 ",
        "$79,531 ",
        "$72,138 ",
        "$87,763 ",
        "$84,570 ",
        "$64,876 ",
        "$78,446 ",
        "$56,857 ",
        "$81,540 ",
        "$97,110 ",
        "$56,438 ",
        "$65,594 ",
        "$55,843 ",
        "$82,073 ",
        "$56,667 ",
        "$55,057 ",
        "$77,454 ",
        "$67,321 ",
        "$63,468 ",
        "$84,790 ",
        "$60,526 ",
        "$68,984 ",
        "$82,118 ",
        "$85,672 ",
        "$77,900 ",
        "$73,847 ",
        "$73,410 ",
        "$72,112 ",
        "$64,042 ",
        "$86,112 ",
        "$80,622 ",
        "$79,977 ",
        "$72,500 ",
        "$75,092 ",
        "$69,826 ",
        "$67,311 ",
        "$67,721 ",
        "$68,507 ",
        "$72,725 ",
        "$69,297 ",
        "$62,002 ",
        "$74,751 ",
        "$73,732 ",
        "$70,443 ",
        "$58,910 ",
        "$64,967 ",
        "$86,119 ",
        "$84,951 ",
        "$86,569 ",
        "$55,569 ",
        "$67,663 ",
        "$80,529 ",
        "$69,829 ",
        "$66,486 ",
        "$79,596 ",
        "$81,753 ",
        "$63,934 ",
        "$60,100 ",
        "$85,297 ",
        "$66,252 ",
        "$68,750 ",
        "$75,422 ",
        "$49,846 ",
        "$63,697 ",
        "$53,607 ",
        "$74,155 ",
        "$79,488 ",
        "$62,279 ",
        "$68,722 ",
        "$75,004 ",
        "$60,500 ",
        "$66,583 ",
        "$61,721 ",
        "$62,993 ",
        "$44,094 ",
        "$57,336 ",
        "$72,525 ",
        "$83,391 ",
        "$70,912 ",
        "$75,070 ",
        "$61,573 ",
        "$66,288 ",
        "$55,521 ",
        "$68,770 ",
        "$63,989 ",
        "$50,313 ",
        "$59,055 ",
        "$58,025 ",
        "$64,041 ",
        "$72,487 ",
        "$59,904 ",
        "$66,006 ",
        "$59,509 ",
        "$61,048 ",
        "$64,866 ",
        "$63,920 ",
        "$50,677 ",
        "$47,762 ",
        "$64,601 ",
        "$65,839 ",
        "$56,494 ",
        "$76,544 ",
        "$67,766 ",
        "$53,693 ",
        "$57,952 ",
        "$57,461 ",
        "$61,811 ",
        "$52,215 ",
        "$52,432 ",
        "$63,356 ",
        "$53,540 ",
        "$64,352 ",
        "$52,847 ",
        "$58,442 ",
        "$74,524 ",
        "$60,651 ",
        "$74,878 ",
        "$72,088 ",
        "$61,996 ",
        "$69,405 ",
        "$57,316 ",
        "$65,935 ",
        "$55,444 ",
        "$64,537 ",
        "$57,353 ",
        "$73,623 ",
        "$76,145 ",
        "$59,394 ",
        "$49,052 ",
        "$52,917 ",
        "$66,519 ",
        "$71,250 ",
        "$68,426 ",
        "$55,095 ",
        "$69,223 ",
        "$72,359 ",
        "$70,618 ",
        "$56,964 ",
        "$58,112 ",
        "$55,904 ",
        "$66,159 ",
        "$53,691 ",
        "$51,667 ",
        "$65,219 ",
        "$58,434 ",
        "$72,569 ",
        "$60,826 ",
        "$81,853 ",
        "$56,136 ",
        "$62,413 ",
        "$66,534 ",
        "$68,482 ",
        "$60,795 ",
        "$50,274 ",
        "$53,021 ",
        "$64,664 ",
        "$51,366 ",
        "$62,519 ",
        "$71,077 ",
        "$39,479 ",
        "$50,866 ",
        "$65,223 ",
        "$42,014 ",
        "$61,570 ",
        "$56,259 ",
        "$47,798 ",
        "$55,018 ",
        "$55,735 ",
        "$46,100 ",
        "$62,559 ",
        "$48,667 ",
        "$78,345 ",
        "$68,381 ",
        "$55,192 ",
        "$65,353 ",
        "$48,477 ",
        "$81,765 ",
        "$61,793 ",
        "$76,548 ",
        "$63,027 ",
        "$60,847 ",
        "$57,091 ",
        "$56,827 ",
        "$69,107 ",
        "$52,866 ",
        "$64,180 ",
        "$59,040 ",
        "$71,803 ",
        "$53,565 ",
        "$58,230 ",
        "$69,306 ",
        "$63,918 ",
        "$58,455 ",
        "$54,620 ",
        "$52,460 ",
        "$66,639 ",
        "$61,877 ",
        "$48,313 ",
        "$63,942 ",
        "$68,288 ",
        "$58,626 ",
        "$54,912 ",
        "$49,248 ",
        "$65,951 ",
        "$64,515 ",
        "$62,962 ",
        "$50,438 ",
        "$70,380 ",
        "$61,683 ",
        "$61,667 ",
        "$70,458 ",
        "$44,772 ",
        "$53,309 ",
        "$55,481 ",
        "$52,590 ",
        "$58,654 ",
        "$71,525 ",
        "$61,136 ",
        "$52,511 ",
        "$62,089 ",
        "$59,018 ",
        "$58,590 ",
        "$52,375 ",
        "$49,839 ",
        "$60,863 ",
        "$76,147 ",
        "$60,799 ",
        "$72,764 ",
        "$62,779 ",
        "$59,338 ",
        "$48,800 ",
        "$54,524 ",
        "$69,965 ",
        "$54,548 ",
        "$50,792 ",
        "$58,080 ",
        "$72,489 ",
        "$53,668 ",
        "$55,089 ",
        "$68,424 ",
        "$51,766 ",
        "$69,530 ",
        "$55,754 ",
        "$59,870 ",
        "$50,923 ",
        "$59,432 ",
        "$55,449 ",
        "$58,697 ",
        "$53,381 ",
        "$57,260 ",
        "$56,836 ",
        "$62,351 ",
        "$69,743 ",
        "$56,479 ",
        "$57,791 ",
        "$65,000 ",
        "$68,297 ",
        "$45,794 ",
        "$72,742 ",
        "$48,933 ",
        "$57,281 ",
        "$62,229 ",
        "$50,929 ",
        "$48,593 ",
        "$49,835 ",
        "$50,817 ",
        "$64,697 ",
        "$71,598 ",
        "$67,261 ",
        "$65,304 ",
        "$51,482 ",
        "$53,424 ",
        "$64,574 ",
        "$56,379 ",
        "$53,076 ",
        "$71,037 ",
        "$66,689 ",
        "$63,512 ",
        "$54,247 ",
        "$61,227 ",
        "$56,801 ",
        "$60,936 ",
        "$60,065 ",
        "$58,825 ",
        "$51,853 ",
        "$55,295 ",
        "$65,409 ",
        "$44,132 ",
        "$48,450 ",
        "$57,580 ",
        "$60,097 ",
        "$45,535 ",
        "$53,663 ",
        "$48,398 ",
        "$67,225 ",
        "$54,066 ",
        "$43,250 ",
        "$50,221 ",
        "$58,750 ",
        "$53,325 ",
        "$66,085 ",
        "$56,018 ",
        "$52,350 ",
        "$51,812 ",
        "$57,348 ",
        "$58,529 ",
        "$69,301 ",
        "$62,535 ",
        "$67,603 ",
        "$48,592 ",
        "$49,035 ",
        "$57,978 ",
        "$52,735 ",
        "$52,833 ",
        "$67,177 ",
        "$55,315 ",
        "$49,544 ",
        "$65,130 ",
        "$50,000 ",
        "$51,462 ",
        "$65,892 ",
        "$61,610 ",
        "$57,906 ",
        "$57,125 ",
        "$50,234 ",
        "$65,086 ",
        "$55,298 ",
        "$56,733 ",
        "$50,856 ",
        "$49,545 ",
        "$59,718 ",
        "$55,461 ",
        "$60,365 ",
        "$71,036 ",
        "$54,242 ",
        "$54,206 ",
        "$52,394 ",
        "$61,216 ",
        "$64,541 ",
        "$57,565 ",
        "$51,365 ",
        "$57,596 ",
        "$58,175 ",
        "$60,519 ",
        "$53,040 ",
        "$62,794 ",
        "$54,684 ",
        "$60,485 ",
        "$54,463 ",
        "$61,231 ",
        "$51,342 ",
        "$51,164 ",
        "$68,718 ",
        "$56,580 ",
        "$46,250 ",
        "$55,864 ",
        "$47,431 ",
        "$45,841 ",
        "$47,335 ",
        "$60,466 ",
        "$53,712 ",
        "$50,712 ",
        "$49,165 ",
        "$58,936 ",
        "$56,243 ",
        "$59,435 ",
        "$70,238 ",
        "$50,074 ",
        "$45,343 ",
        "$58,190 ",
        "$49,200 ",
        "$56,061 ",
        "$47,104 ",
        "$51,529 ",
        "$50,877 ",
        "$53,057 ",
        "$57,922 ",
        "$56,853 ",
        "$46,320 ",
        "$51,522 ",
        "$45,610 ",
        "$59,204 ",
        "$53,237 ",
        "$49,633 ",
        "$51,251 ",
        "$56,618 ",
        "$45,523 ",
        "$58,318 ",
        "$69,070 ",
        "$46,085 ",
        "$47,500 ",
        "$47,694 ",
        "$55,269 ",
        "$58,745 ",
        "$41,694 ",
        "$62,981 ",
        "$48,185 ",
        "$48,604 ",
        "$57,004 ",
        "$73,098 ",
        "$50,181 ",
        "$58,008 ",
        "$64,632 ",
        "$50,357 ",
        "$50,736 ",
        "$61,757 ",
        "$56,067 ",
        "$50,609 ",
        "$45,714 ",
        "$33,445 ",
        "$48,468 ",
        "$53,202 ",
        "$50,653 ",
        "$54,854 ",
        "$52,008 ",
        "$58,888 ",
        "$58,625 ",
        "$46,959 ",
        "$54,923 ",
        "$67,157 ",
        "$47,743 ",
        "$48,601 ",
        "$53,137 ",
        "$59,333 ",
        "$49,076 ",
        "$46,939 ",
        "$49,055 ",
        "$55,155 ",
        "$49,755 ",
        "$60,390 ",
        "$42,565 ",
        "$53,951 ",
        "$49,669 ",
        "$61,893 ",
        "$61,720 ",
        "$56,452 ",
        "$47,460 ",
        "$56,466 ",
        "$40,477 ",
        "$55,509 ",
        "$58,922 ",
        "$53,119 ",
        "$48,911 ",
        "$55,909 ",
        "$55,918 ",
        "$53,806 ",
        "$50,905 ",
        "$53,759 ",
        "$54,270 ",
        "$59,340 ",
        "$38,477 ",
        "$57,581 ",
        "$51,791 ",
        "$58,225 ",
        "$48,181 ",
        "$50,247 ",
        "$60,287 ",
        "$52,332 ",
        "$52,848 ",
        "$51,793 ",
        "$50,835 ",
        "$53,363 ",
        "$47,831 ",
        "$48,814 ",
        "$60,128 ",
        "$64,707 ",
        "$63,629 ",
        "$51,632 ",
        "$50,209 ",
        "$48,506 ",
        "$48,493 ",
        "$46,865 ",
        "$43,424 ",
        "$43,273 ",
        "$46,534 ",
        "$41,875 ",
        "$51,373 ",
        "$46,625 ",
        "$60,350 ",
        "$59,226 ",
        "$54,167 ",
        "$55,210 ",
        "$52,160 ",
        "$44,796 ",
        "$57,825 ",
        "$53,248 ",
        "$43,804 ",
        "$51,393 ",
        "$46,013 ",
        "$53,633 ",
        "$56,240 ",
        "$54,235 ",
        "$52,317 ",
        "$64,423 ",
        "$39,500 ",
        "$58,525 ",
        "$51,681 ",
        "$54,165 ",
        "$50,120 ",
        "$47,439 ",
        "$53,684 ",
        "$53,525 ",
        "$56,454 ",
        "$53,885 ",
        "$44,250 ",
        "$47,876 ",
        "$52,195 ",
        "$53,459 ",
        "$44,795 ",
        "$52,480 ",
        "$59,492 ",
        "$52,578 ",
        "$44,601 ",
        "$56,480 ",
        "$53,596 ",
        "$64,571 ",
        "$55,726 ",
        "$46,702 ",
        "$47,040 ",
        "$44,922 ",
        "$45,542 ",
        "$53,961 ",
        "$40,496 ",
        "$47,344 ",
        "$46,504 ",
        "$49,905 ",
        "$46,667 ",
        "$52,686 ",
        "$39,333 ",
        "$57,654 ",
        "$51,826 ",
        "$49,596 ",
        "$54,090 ",
        "$51,574 ",
        "$51,398 ",
        "$54,020 ",
        "$47,985 ",
        "$52,940 ",
        "$63,076 ",
        "$48,767 ",
        "$54,818 ",
        "$54,196 ",
        "$55,925 ",
        "$55,584 ",
        "$56,946 ",
        "$48,687 ",
        "$52,108 ",
        "$51,074 ",
        "$45,759 ",
        "$57,298 ",
        "$55,553 ",
        "$48,015 ",
        "$58,786 ",
        "$46,745 ",
        "$63,435 ",
        "$48,936 ",
        "$48,039 ",
        "$50,833 ",
        "$59,358 ",
        "$49,820 ",
        "$44,429 ",
        "$44,422 ",
        "$49,056 ",
        "$54,518 ",
        "$51,010 ",
        "$51,548 ",
        "$42,476 ",
        "$45,949 ",
        "$54,306 ",
        "$71,227 ",
        "$62,670 ",
        "$50,520 ",
        "$48,875 ",
        "$58,017 ",
        "$50,436 ",
        "$54,989 ",
        "$52,710 ",
        "$48,261 ",
        "$45,429 ",
        "$48,187 ",
        "$57,380 ",
        "$43,482 ",
        "$48,627 ",
        "$54,061 ",
        "$50,149 ",
        "$58,651 ",
        "$57,703 ",
        "$54,203 ",
        "$48,674 ",
        "$46,438 ",
        "$52,198 ",
        "$65,026 ",
        "$55,170 ",
        "$61,635 ",
        "$49,481 ",
        "$48,801 ",
        "$56,610 ",
        "$45,556 ",
        "$38,438 ",
        "$49,487 ",
        "$49,088 ",
        "$47,861 ",
        "$55,041 ",
        "$60,813 ",
        "$58,758 ",
        "$53,451 ",
        "$47,897 ",
        "$55,064 ",
        "$46,407 ",
        "$55,114 ",
        "$56,065 ",
        "$54,515 ",
        "$39,400 ",
        "$48,977 ",
        "$51,051 ",
        "$49,471 ",
        "$51,383 ",
        "$60,115 ",
        "$65,209 ",
        "$50,030 ",
        "$48,733 ",
        "$62,052 ",
        "$49,022 ",
        "$54,541 ",
        "$61,250 ",
        "$55,659 ",
        "$56,669 ",
        "$53,136 ",
        "$58,396 ",
        "$57,022 ",
        "$46,591 ",
        "$53,245 ",
        "$54,115 ",
        "$47,380 ",
        "$59,482 ",
        "$48,256 ",
        "$58,088 ",
        "$45,215 ",
        "$53,740 ",
        "$42,019 ",
        "$45,724 ",
        "$55,609 ",
        "$51,939 ",
        "$47,058 ",
        "$52,453 ",
        "$59,472 ",
        "$54,930 ",
        "$52,703 ",
        "$37,146 ",
        "$56,483 ",
        "$57,001 ",
        "$48,530 ",
        "$50,329 ",
        "$45,431 ",
        "$54,554 ",
        "$48,702 ",
        "$52,545 ",
        "$40,795 ",
        "$48,961 ",
        "$46,361 ",
        "$48,783 ",
        "$52,345 ",
        "$49,625 ",
        "$53,213 ",
        "$53,820 ",
        "$60,104 ",
        "$48,093 ",
        "$51,154 ",
        "$49,508 ",
        "$45,512 ",
        "$43,601 ",
        "$52,069 ",
        "$52,832 ",
        "$44,764 ",
        "$50,139 ",
        "$37,925 ",
        "$49,297 ",
        "$44,378 ",
        "$56,875 ",
        "$45,236 ",
        "$80,337 ",
        "$50,605 ",
        "$54,968 ",
        "$51,339 ",
        "$53,515 ",
        "$51,957 ",
        "$54,076 ",
        "$49,217 ",
        "$51,475 ",
        "$40,833 ",
        "$46,071 ",
        "$50,578 ",
        "$44,866 ",
        "$46,559 ",
        "$45,920 ",
        "$45,519 ",
        "$52,873 ",
        "$46,035 ",
        "$49,271 ",
        "$45,865 ",
        "$48,428 ",
        "$46,369 ",
        "$47,813 ",
        "$48,158 ",
        "$50,476 ",
        "$61,958 ",
        "$54,583 ",
        "$44,556 ",
        "$53,931 ",
        "$44,713 ",
        "$48,323 ",
        "$49,589 ",
        "$49,788 ",
        "$46,498 ",
        "$41,025 ",
        "$52,920 ",
        "$50,405 ",
        "$36,100 ",
        "$42,451 ",
        "$51,422 ",
        "$60,555 ",
        "$48,355 ",
        "$43,011 ",
        "$54,551 ",
        "$50,802 ",
        "$47,015 ",
        "$44,200 ",
        "$48,789 ",
        "$48,451 ",
        "$57,375 ",
        "$41,108 ",
        "$69,707 ",
        "$51,816 ",
        "$49,594 ",
        "$47,679 ",
        "$51,619 ",
        "$46,313 ",
        "$49,434 ",
        "$47,955 ",
        "$52,140 ",
        "$50,516 ",
        "$51,504 ",
        "$49,559 ",
        "$55,348 ",
        "$47,685 ",
        "$44,898 ",
        "$50,822 ",
        "$55,347 ",
        "$46,517 ",
        "$48,426 ",
        "$51,615 ",
        "$53,972 ",
        "$43,606 ",
        "$47,729 ",
        "$60,445 ",
        "$45,096 ",
        "$41,826 ",
        "$66,237 ",
        "$49,389 ",
        "$38,807 ",
        "$51,354 ",
        "$60,893 ",
        "$53,265 ",
        "$43,449 ",
        "$53,776 ",
        "$46,033 ",
        "$50,881 ",
        "$57,159 ",
        "$51,304 ",
        "$44,173 ",
        "$43,640 ",
        "$64,205 ",
        "$51,568 ",
        "$45,205 ",
        "$48,881 ",
        "$48,384 ",
        "$49,094 ",
        "$47,195 ",
        "$50,105 ",
        "$36,875 ",
        "$44,981 ",
        "$50,695 ",
        "$46,581 ",
        "$54,017 ",
        "$50,473 ",
        "$55,354 ",
        "$65,050 ",
        "$49,831 ",
        "$54,666 ",
        "$46,808 ",
        "$44,484 ",
        "$46,117 ",
        "$48,359 ",
        "$32,427 ",
        "$45,775 ",
        "$47,198 ",
        "$48,538 ",
        "$38,362 ",
        "$48,026 ",
        "$55,138 ",
        "$52,637 ",
        "$48,038 ",
        "$53,657 ",
        "$57,218 ",
        "$45,808 ",
        "$52,640 ",
        "$49,655 ",
        "$34,063 ",
        "$47,181 ",
        "$44,683 ",
        "$44,815 ",
        "$53,904 ",
        "$56,005 ",
        "$61,952 ",
        "$49,233 ",
        "$50,759 ",
        "$47,447 ",
        "$49,024 ",
        "$49,698 ",
        "$47,432 ",
        "$53,454 ",
        "$56,607 ",
        "$53,591 ",
        "$49,865 ",
        "$50,262 ",
        "$46,044 ",
        "$45,246 ",
        "$54,780 ",
        "$47,214 ",
        "$49,440 ",
        "$47,892 ",
        "$53,013 ",
        "$44,073 ",
        "$48,940 ",
        "$50,336 ",
        "$57,808 ",
        "$39,572 ",
        "$58,636 ",
        "$45,629 ",
        "$44,493 ",
        "$52,027 ",
        "$58,515 ",
        "$57,408 ",
        "$61,192 ",
        "$54,723 ",
        "$57,180 ",
        "$53,954 ",
        "$48,464 ",
        "$50,214 ",
        "$43,014 ",
        "$48,866 ",
        "$43,481 ",
        "$50,377 ",
        "$47,277 ",
        "$48,361 ",
        "$47,454 ",
        "$36,066 ",
        "$37,321 ",
        "$50,060 ",
        "$51,925 ",
        "$49,922 ",
        "$41,129 ",
        "$49,935 ",
        "$51,092 ",
        "$44,944 ",
        "$49,324 ",
        "$42,914 ",
        "$56,453 ",
        "$47,476 ",
        "$59,915 ",
        "$52,040 ",
        "$36,258 ",
        "$49,215 ",
        "$42,075 ",
        "$54,926 ",
        "$52,697 ",
        "$48,804 ",
        "$41,765 ",
        "$52,601 ",
        "$52,239 ",
        "$44,743 ",
        "$50,349 ",
        "$51,670 ",
        "$51,027 ",
        "$52,510 ",
        "$54,336 ",
        "$60,781 ",
        "$54,426 ",
        "$48,090 ",
        "$45,045 ",
        "$53,588 ",
        "$49,370 ",
        "$46,994 ",
        "$52,026 ",
        "$42,672 ",
        "$50,227 ",
        "$44,032 ",
        "$36,923 ",
        "$50,657 ",
        "$53,551 ",
        "$50,705 ",
        "$49,157 ",
        "$55,563 ",
        "$53,589 ",
        "$46,216 ",
        "$42,230 ",
        "$45,464 ",
        "$58,632 ",
        "$46,817 ",
        "$54,893 ",
        "$42,365 ",
        "$50,067 ",
        "$43,518 ",
        "$42,987 ",
        "$56,725 ",
        "$58,505 ",
        "$49,342 ",
        "$50,507 ",
        "$52,838 ",
        "$45,418 ",
        "$51,534 ",
        "$52,589 ",
        "$52,415 ",
        "$41,897 ",
        "$48,729 ",
        "$53,826 ",
        "$52,885 ",
        "$47,079 ",
        "$41,970 ",
        "$55,401 ",
        "$56,811 ",
        "$47,494 ",
        "$44,264 ",
        "$53,122 ",
        "$52,186 ",
        "$44,663 ",
        "$46,373 ",
        "$51,425 ",
        "$44,610 ",
        "$48,619 ",
        "$49,143 ",
        "$48,115 ",
        "$43,401 ",
        "$39,009 ",
        "$46,004 ",
        "$44,790 ",
        "$50,996 ",
        "$48,089 ",
        "$61,194 ",
        "$54,614 ",
        "$54,494 ",
        "$41,617 ",
        "$47,215 ",
        "$45,206 ",
        "$55,443 ",
        "$48,831 ",
        "$51,867 ",
        "$39,659 ",
        "$50,513 ",
        "$56,854 ",
        "$50,859 ",
        "$45,961 ",
        "$37,660 ",
        "$47,581 ",
        "$55,723 ",
        "$48,900 ",
        "$46,488 ",
        "$42,149 ",
        "$55,149 ",
        "$41,924 ",
        "$46,875 ",
        "$50,926 ",
        "$41,835 ",
        "$45,958 ",
        "$47,366 ",
        "$51,924 ",
        "$50,963 ",
        "$63,030 ",
        "$57,535 ",
        "$39,038 ",
        "$50,572 ",
        "$44,402 ",
        "$54,845 ",
        "$50,205 ",
        "$50,648 ",
        "$44,588 ",
        "$44,843 ",
        "$59,168 ",
        "$52,856 ",
        "$42,078 ",
        "$44,509 ",
        "$42,774 ",
        "$45,321 ",
        "$38,501 ",
        "$41,385 ",
        "$44,426 ",
        "$48,857 ",
        "$49,507 ",
        "$46,107 ",
        "$44,963 ",
        "$49,830 ",
        "$46,551 ",
        "$39,583 ",
        "$51,581 ",
        "$50,364 ",
        "$44,231 ",
        "$50,830 ",
        "$49,002 ",
        "$37,111 ",
        "$47,445 ",
        "$50,282 ",
        "$49,021 ",
        "$44,747 ",
        "$43,175 ",
        "$49,590 ",
        "$48,659 ",
        "$47,359 ",
        "$51,250 ",
        "$50,551 ",
        "$44,873 ",
        "$51,914 ",
        "$44,745 ",
        "$44,136 ",
        "$42,426 ",
        "$48,341 ",
        "$46,566 ",
        "$43,826 ",
        "$48,626 ",
        "$53,231 ",
        "$37,974 ",
        "$53,075 ",
        "$53,682 ",
        "$65,750 ",
        "$42,180 ",
        "$43,620 ",
        "$45,624 ",
        "$42,025 ",
        "$47,654 ",
        "$48,896 ",
        "$45,633 ",
        "$52,410 ",
        "$47,122 ",
        "$52,698 ",
        "$45,603 ",
        "$41,557 ",
        "$50,542 ",
        "$40,379 ",
        "$47,667 ",
        "$45,853 ",
        "$51,078 ",
        "$43,589 ",
        "$43,357 ",
        "$45,997 ",
        "$45,233 ",
        "$43,500 ",
        "$47,384 ",
        "$47,461 ",
        "$47,233 ",
        "$53,857 ",
        "$47,072 ",
        "$46,467 ",
        "$51,497 ",
        "$48,231 ",
        "$51,440 ",
        "$49,335 ",
        "$52,200 ",
        "$45,641 ",
        "$52,147 ",
        "$44,921 ",
        "$40,131 ",
        "$48,586 ",
        "$63,074 ",
        "$53,016 ",
        "$38,344 ",
        "$52,808 ",
        "$50,314 ",
        "$44,005 ",
        "$43,540 ",
        "$45,362 ",
        "$47,701 ",
        "$41,985 ",
        "$48,066 ",
        "$43,499 ",
        "$45,146 ",
        "$46,809 ",
        "$40,681 ",
        "$49,038 ",
        "$57,227 ",
        "$41,056 ",
        "$42,639 ",
        "$50,496 ",
        "$47,584 ",
        "$54,836 ",
        "$41,053 ",
        "$44,149 ",
        "$57,500 ",
        "$47,405 ",
        "$43,193 ",
        "$43,085 ",
        "$54,535 ",
        "$46,429 ",
        "$45,747 ",
        "$50,583 ",
        "$45,932 ",
        "$48,136 ",
        "$47,141 ",
        "$41,932 ",
        "$49,329 ",
        "$46,503 ",
        "$50,112 ",
        "$51,466 ",
        "$32,372 ",
        "$42,931 ",
        "$51,213 ",
        "$45,073 ",
        "$46,597 ",
        "$41,624 ",
        "$54,694 ",
        "$56,270 ",
        "$48,482 ",
        "$45,202 ",
        "$45,035 ",
        "$43,764 ",
        "$44,530 ",
        "$42,610 ",
        "$52,233 ",
        "$46,976 ",
        "$44,452 ",
        "$61,837 ",
        "$52,361 ",
        "$52,427 ",
        "$47,765 ",
        "$44,848 ",
        "$52,646 ",
        "$52,535 ",
        "$48,540 ",
        "$35,729 ",
        "$52,061 ",
        "$43,971 ",
        "$45,396 ",
        "$46,019 ",
        "$42,979 ",
        "$42,334 ",
        "$44,427 ",
        "$54,546 ",
        "$51,555 ",
        "$49,960 ",
        "$46,623 ",
        "$47,365 ",
        "$49,435 ",
        "$39,286 ",
        "$49,516 ",
        "$46,912 ",
        "$46,002 ",
        "$43,590 ",
        "$45,525 ",
        "$42,429 ",
        "$33,298 ",
        "$42,287 ",
        "$50,418 ",
        "$50,427 ",
        "$47,466 ",
        "$42,196 ",
        "$54,956 ",
        "$43,633 ",
        "$49,313 ",
        "$42,431 ",
        "$34,122 ",
        "$44,742 ",
        "$41,009 ",
        "$44,312 ",
        "$53,518 ",
        "$48,080 ",
        "$41,058 ",
        "$42,457 ",
        "$39,516 ",
        "$49,150 ",
        "$39,541 ",
        "$48,989 ",
        "$37,105 ",
        "$42,223 ",
        "$45,145 ",
        "$43,524 ",
        "$52,939 ",
        "$41,394 ",
        "$48,890 ",
        "$43,734 ",
        "$39,830 ",
        "$41,556 ",
        "$48,943 ",
        "$49,750 ",
        "$46,784 ",
        "$42,992 ",
        "$50,786 ",
        "$50,475 ",
        "$48,372 ",
        "$40,330 ",
        "$54,766 ",
        "$44,135 ",
        "$54,003 ",
        "$44,276 ",
        "$44,950 ",
        "$35,051 ",
        "$42,519 ",
        "$46,686 ",
        "$52,792 ",
        "$43,709 ",
        "$39,904 ",
        "$62,067 ",
        "$53,018 ",
        "$45,376 ",
        "$45,622 ",
        "$47,967 ",
        "$45,991 ",
        "$43,752 ",
        "$46,622 ",
        "$50,102 ",
        "$50,287 ",
        "$44,397 ",
        "$43,059 ",
        "$47,325 ",
        "$42,449 ",
        "$44,800 ",
        "$41,781 ",
        "$47,649 ",
        "$51,765 ",
        "$46,516 ",
        "$49,125 ",
        "$45,363 ",
        "$45,767 ",
        "$43,888 ",
        "$52,741 ",
        "$43,853 ",
        "$42,644 ",
        "$46,454 ",
        "$43,925 ",
        "$44,545 ",
        "$45,871 ",
        "$45,389 ",
        "$53,375 ",
        "$44,246 ",
        "$40,811 ",
        "$44,286 ",
        "$52,152 ",
        "$44,807 ",
        "$44,470 ",
        "$37,875 ",
        "$47,057 ",
        "$44,651 ",
        "$46,963 ",
        "$51,444 ",
        "$45,241 ",
        "$48,138 ",
        "$41,670 ",
        "$51,641 ",
        "$38,374 ",
        "$50,853 ",
        "$52,991 ",
        "$50,527 ",
        "$50,167 ",
        "$48,992 ",
        "$52,691 ",
        "$37,667 ",
        "$44,070 ",
        "$45,755 ",
        "$43,125 ",
        "$50,408 ",
        "$56,529 ",
        "$53,586 ",
        "$45,395 ",
        "$36,281 ",
        "$38,582 ",
        "$38,659 ",
        "$45,888 ",
        "$47,596 ",
        "$40,490 ",
        "$39,702 ",
        "$45,543 ",
        "$43,188 ",
        "$43,833 ",
        "$48,755 ",
        "$41,426 ",
        "$44,524 ",
        "$40,337 ",
        "$38,301 ",
        "$42,844 ",
        "$44,582 ",
        "$39,313 ",
        "$43,542 ",
        "$49,637 ",
        "$43,010 ",
        "$42,834 ",
        "$42,975 ",
        "$46,077 ",
        "$45,141 ",
        "$49,107 ",
        "$43,257 ",
        "$33,635 ",
        "$43,216 ",
        "$52,579 ",
        "$52,446 ",
        "$49,774 ",
        "$45,294 ",
        "$43,918 ",
        "$49,277 ",
        "$47,468 ",
        "$49,528 ",
        "$45,047 ",
        "$44,156 ",
        "$38,410 ",
        "$57,683 ",
        "$47,401 ",
        "$43,096 ",
        "$44,731 ",
        "$49,964 ",
        "$49,555 ",
        "$43,798 ",
        "$47,027 ",
        "$48,712 ",
        "$43,768 ",
        "$44,808 ",
        "$48,405 ",
        "$42,133 ",
        "$43,472 ",
        "$49,439 ",
        "$41,137 ",
        "$45,297 ",
        "$51,750 ",
        "$44,054 ",
        "$44,551 ",
        "$39,051 ",
        "$42,345 ",
        "$40,948 ",
        "$43,183 ",
        "$46,170 ",
        "$43,469 ",
        "$47,969 ",
        "$38,145 ",
        "$43,413 ",
        "$39,324 ",
        "$45,856 ",
        "$45,893 ",
        "$41,248 ",
        "$44,972 ",
        "$38,522 ",
        "$47,569 ",
        "$53,179 ",
        "$50,510 ",
        "$43,292 ",
        "$49,004 ",
        "$45,675 ",
        "$42,568 ",
        "$41,500 ",
        "$44,650 ",
        "$44,332 ",
        "$47,162 ",
        "$44,078 ",
        "$42,152 ",
        "$40,445 ",
        "$40,471 ",
        "$41,414 ",
        "$43,444 ",
        "$41,275 ",
        "$52,582 ",
        "$37,892 ",
        "$40,064 ",
        "$48,461 ",
        "$42,260 ",
        "$55,815 ",
        "$48,163 ",
        "$41,136 ",
        "$47,151 ",
        "$44,548 ",
        "$43,100 ",
        "$47,964 ",
        "$39,162 ",
        "$40,567 ",
        "$43,043 ",
        "$46,972 ",
        "$41,279 ",
        "$39,100 ",
        "$35,017 ",
        "$44,891 ",
        "$46,166 ",
        "$41,393 ",
        "$39,884 ",
        "$51,493 ",
        "$41,994 ",
        "$43,649 ",
        "$48,616 ",
        "$48,051 ",
        "$39,761 ",
        "$45,480 ",
        "$47,618 ",
        "$54,974 ",
        "$46,896 ",
        "$46,513 ",
        "$46,484 ",
        "$44,858 ",
        "$47,188 ",
        "$41,453 ",
        "$45,336 ",
        "$45,231 ",
        "$40,655 ",
        "$45,884 ",
        "$49,135 ",
        "$52,423 ",
        "$48,711 ",
        "$34,582 ",
        "$39,633 ",
        "$40,246 ",
        "$36,719 ",
        "$43,885 ",
        "$43,458 ",
        "$44,869 ",
        "$40,052 ",
        "$40,718 ",
        "$40,704 ",
        "$33,334 ",
        "$43,409 ",
        "$45,012 ",
        "$44,838 ",
        "$44,262 ",
        "$45,430 ",
        "$49,543 ",
        "$42,110 ",
        "$42,389 ",
        "$47,894 ",
        "$39,348 ",
        "$37,965 ",
        "$46,555 ",
        "$43,958 ",
        "$43,962 ",
        "$46,840 ",
        "$46,029 ",
        "$43,997 ",
        "$42,824 ",
        "$40,964 ",
        "$48,433 ",
        "$42,346 ",
        "$45,992 ",
        "$43,546 ",
        "$42,971 ",
        "$36,890 ",
        "$46,951 ",
        "$45,718 ",
        "$40,933 ",
        "$47,862 ",
        "$42,632 ",
        "$48,630 ",
        "$43,070 ",
        "$43,084 ",
        "$37,750 ",
        "$40,143 ",
        "$47,542 ",
        "$44,502 ",
        "$42,524 ",
        "$44,847 ",
        "$41,614 ",
        "$38,688 ",
        "$44,281 ",
        "$47,513 ",
        "$41,339 ",
        "$44,902 ",
        "$42,221 ",
        "$47,538 ",
        "$41,576 ",
        "$43,765 ",
        "$39,564 ",
        "$44,301 ",
        "$47,247 ",
        "$52,369 ",
        "$38,313 ",
        "$44,740 ",
        "$42,493 ",
        "$46,917 ",
        "$46,140 ",
        "$44,417 ",
        "$43,327 ",
        "$42,982 ",
        "$45,355 ",
        "$39,652 ",
        "$39,385 ",
        "$43,136 ",
        "$45,271 ",
        "$37,899 ",
        "$46,548 ",
        "$41,410 ",
        "$41,940 ",
        "$46,053 ",
        "$45,938 ",
        "$44,346 ",
        "$47,593 ",
        "$40,371 ",
        "$37,189 ",
        "$44,861 ",
        "$41,705 ",
        "$46,512 ",
        "$46,217 ",
        "$42,125 ",
        "$39,328 ",
        "$41,551 ",
        "$51,990 ",
        "$51,100 ",
        "$41,425 ",
        "$39,416 ",
        "$46,376 ",
        "$51,189 ",
        "$44,889 ",
        "$42,542 ",
        "$45,488 ",
        "$46,797 ",
        "$43,124 ",
        "$47,191 ",
        "$41,730 ",
        "$42,017 ",
        "$50,872 ",
        "$44,213 ",
        "$42,469 ",
        "$45,408 ",
        "$51,408 ",
        "$38,704 ",
        "$44,522 ",
        "$44,187 ",
        "$42,515 ",
        "$42,981 ",
        "$46,615 ",
        "$40,970 ",
        "$46,148 ",
        "$47,292 ",
        "$48,208 ",
        "$37,240 ",
        "$53,380 ",
        "$44,665 ",
        "$40,415 ",
        "$44,945 ",
        "$46,501 ",
        "$42,880 ",
        "$41,547 ",
        "$38,548 ",
        "$43,083 ",
        "$42,235 ",
        "$43,886 ",
        "$40,376 ",
        "$43,605 ",
        "$50,750 ",
        "$48,929 ",
        "$43,425 ",
        "$46,385 ",
        "$43,028 ",
        "$48,893 ",
        "$44,308 ",
        "$44,811 ",
        "$50,694 ",
        "$46,600 ",
        "$40,813 ",
        "$42,528 ",
        "$41,208 ",
        "$42,676 ",
        "$51,908 ",
        "$43,676 ",
        "$37,594 ",
        "$47,960 ",
        "$46,150 ",
        "$41,910 ",
        "$41,834 ",
        "$55,326 ",
        "$50,097 ",
        "$49,711 ",
        "$42,904 ",
        "$47,766 ",
        "$40,916 ",
        "$39,839 ",
        "$45,000 ",
        "$44,448 ",
        "$43,907 ",
        "$41,881 ",
        "$49,617 ",
        "$42,089 ",
        "$41,534 ",
        "$46,607 ",
        "$37,071 ",
        "$46,036 ",
        "$42,906 ",
        "$44,195 ",
        "$42,331 ",
        "$42,268 ",
        "$41,815 ",
        "$41,739 ",
        "$43,026 ",
        "$40,577 ",
        "$41,735 ",
        "$35,593 ",
        "$45,130 ",
        "$38,829 ",
        "$36,046 ",
        "$41,184 ",
        "$43,502 ",
        "$41,953 ",
        "$49,852 ",
        "$42,823 ",
        "$37,709 ",
        "$52,264 ",
        "$50,417 ",
        "$47,068 ",
        "$38,346 ",
        "$40,640 ",
        "$37,192 ",
        "$45,830 ",
        "$35,423 ",
        "$48,528 ",
        "$43,290 ",
        "$49,404 ",
        "$45,734 ",
        "$41,277 ",
        "$48,502 ",
        "$61,412 ",
        "$41,473 ",
        "$44,353 ",
        "$40,680 ",
        "$42,167 ",
        "$37,940 ",
        "$36,950 ",
        "$43,980 ",
        "$35,159 ",
        "$51,484 ",
        "$36,857 ",
        "$42,860 ",
        "$45,040 ",
        "$41,012 ",
        "$35,776 ",
        "$43,647 ",
        "$44,897 ",
        "$43,597 ",
        "$53,865 ",
        "$42,846 ",
        "$42,261 ",
        "$42,627 ",
        "$42,186 ",
        "$38,506 ",
        "$43,269 ",
        "$40,009 ",
        "$40,028 ",
        "$43,023 ",
        "$41,713 ",
        "$40,891 ",
        "$40,024 ",
        "$40,930 ",
        "$40,112 ",
        "$40,204 ",
        "$47,225 ",
        "$43,941 ",
        "$40,667 ",
        "$41,892 ",
        "$41,626 ",
        "$41,579 ",
        "$38,828 ",
        "$35,079 ",
        "$49,718 ",
        "$39,603 ",
        "$49,901 ",
        "$52,835 ",
        "$41,977 ",
        "$47,537 ",
        "$40,670 ",
        "$33,611 ",
        "$38,958 ",
        "$42,603 ",
        "$43,615 ",
        "$42,455 ",
        "$36,236 ",
        "$48,047 ",
        "$44,060 ",
        "$34,907 ",
        "$46,048 ",
        "$42,566 ",
        "$43,839 ",
        "$46,885 ",
        "$40,900 ",
        "$39,453 ",
        "$51,000 ",
        "$45,357 ",
        "$41,742 ",
        "$50,565 ",
        "$47,427 ",
        "$37,040 ",
        "$43,739 ",
        "$41,252 ",
        "$44,363 ",
        "$38,417 ",
        "$38,016 ",
        "$44,842 ",
        "$44,478 ",
        "$35,184 ",
        "$41,777 ",
        "$45,709 ",
        "$45,284 ",
        "$41,650 ",
        "$46,016 ",
        "$43,439 ",
        "$38,955 ",
        "$45,212 ",
        "$42,046 ",
        "$42,411 ",
        "$44,069 ",
        "$47,117 ",
        "$42,919 ",
        "$42,668 ",
        "$41,010 ",
        "$42,184 ",
        "$44,151 ",
        "$40,524 ",
        "$34,293 ",
        "$44,964 ",
        "$34,702 ",
        "$44,157 ",
        "$33,647 ",
        "$39,876 ",
        "$40,758 ",
        "$43,536 ",
        "$41,392 ",
        "$41,154 ",
        "$42,405 ",
        "$44,388 ",
        "$36,646 ",
        "$44,618 ",
        "$41,571 ",
        "$42,312 ",
        "$42,074 ",
        "$42,487 ",
        "$37,733 ",
        "$43,779 ",
        "$36,815 ",
        "$33,839 ",
        "$30,325 ",
        "$46,137 ",
        "$41,332 ",
        "$46,116 ",
        "$42,504 ",
        "$43,504 ",
        "$40,070 ",
        "$40,850 ",
        "$45,129 ",
        "$61,616 ",
        "$57,292 ",
        "$38,310 ",
        "$37,895 ",
        "$41,848 ",
        "$33,333 ",
        "$46,382 ",
        "$40,601 ",
        "$39,781 ",
        "$47,087 ",
        "$43,205 ",
        "$39,586 ",
        "$41,922 ",
        "$42,279 ",
        "$37,969 ",
        "$41,083 ",
        "$45,752 ",
        "$44,375 ",
        "$40,429 ",
        "$47,945 ",
        "$46,163 ",
        "$42,156 ",
        "$43,231 ",
        "$51,786 ",
        "$43,657 ",
        "$37,482 ",
        "$39,208 ",
        "$42,747 ",
        "$36,969 ",
        "$37,800 ",
        "$43,373 ",
        "$40,904 ",
        "$41,718 ",
        "$34,620 ",
        "$42,143 ",
        "$52,158 ",
        "$45,667 ",
        "$42,300 ",
        "$52,910 ",
        "$39,077 ",
        "$37,855 ",
        "$41,731 ",
        "$35,434 ",
        "$48,953 ",
        "$47,223 ",
        "$44,318 ",
        "$40,557 ",
        "$36,548 ",
        "$40,221 ",
        "$44,885 ",
        "$45,651 ",
        "$43,120 ",
        "$43,795 ",
        "$44,722 ",
        "$38,019 ",
        "$50,821 ",
        "$41,878 ",
        "$38,642 ",
        "$39,049 ",
        "$38,125 ",
        "$34,685 ",
        "$54,150 ",
        "$47,806 ",
        "$40,295 ",
        "$39,677 ",
        "$39,627 ",
        "$40,573 ",
        "$38,355 ",
        "$50,580 ",
        "$39,068 ",
        "$41,169 ",
        "$40,783 ",
        "$41,401 ",
        "$38,634 ",
        "$46,430 ",
        "$49,279 ",
        "$40,104 ",
        "$61,607 ",
        "$45,413 ",
        "$46,317 ",
        "$44,819 ",
        "$47,133 ",
        "$41,161 ",
        "$39,346 ",
        "$40,674 ",
        "$38,138 ",
        "$39,130 ",
        "$36,048 ",
        "$41,045 ",
        "$47,165 ",
        "$43,928 ",
        "$41,024 ",
        "$46,908 ",
        "$37,680 ",
        "$41,696 ",
        "$41,268 ",
        "$46,572 ",
        "$49,340 ",
        "$43,328 ",
        "$37,734 ",
        "$53,274 ",
        "$43,726 ",
        "$34,261 ",
        "$41,986 ",
        "$43,181 ",
        "$41,552 ",
        "$35,693 ",
        "$43,089 ",
        "$36,203 ",
        "$39,845 ",
        "$36,275 ",
        "$44,652 ",
        "$50,635 ",
        "$35,343 ",
        "$32,637 ",
        "$39,669 ",
        "$43,534 ",
        "$43,950 ",
        "$39,140 ",
        "$41,859 ",
        "$42,703 ",
        "$43,264 ",
        "$41,262 ",
        "$42,192 ",
        "$42,317 ",
        "$43,113 ",
        "$38,245 ",
        "$41,030 ",
        "$40,654 ",
        "$39,596 ",
        "$48,196 ",
        "$39,871 ",
        "$34,175 ",
        "$37,391 ",
        "$39,529 ",
        "$39,776 ",
        "$46,147 ",
        "$40,168 ",
        "$41,400 ",
        "$35,793 ",
        "$39,293 ",
        "$38,953 ",
        "$36,257 ",
        "$44,341 ",
        "$45,286 ",
        "$37,679 ",
        "$36,212 ",
        "$40,692 ",
        "$46,592 ",
        "$44,170 ",
        "$41,788 ",
        "$40,769 ",
        "$45,368 ",
        "$36,199 ",
        "$41,964 ",
        "$39,226 ",
        "$42,071 ",
        "$42,383 ",
        "$37,188 ",
        "$40,359 ",
        "$41,622 ",
        "$43,288 ",
        "$37,635 ",
        "$37,081 ",
        "$34,914 ",
        "$40,399 ",
        "$38,550 ",
        "$38,350 ",
        "$45,693 ",
        "$36,588 ",
        "$38,567 ",
        "$34,639 ",
        "$45,450 ",
        "$34,129 ",
        "$36,540 ",
        "$42,119 ",
        "$38,579 ",
        "$39,968 ",
        "$39,375 ",
        "$39,002 ",
        "$37,865 ",
        "$47,197 ",
        "$42,829 ",
        "$38,250 ",
        "$36,951 ",
        "$40,116 ",
        "$38,658 ",
        "$42,217 ",
        "$41,131 ",
        "$40,236 ",
        "$41,354 ",
        "$37,550 ",
        "$42,445 ",
        "$37,378 ",
        "$39,204 ",
        "$37,868 ",
        "$34,481 ",
        "$40,980 ",
        "$42,764 ",
        "$34,659 ",
        "$39,196 ",
        "$41,495 ",
        "$50,027 ",
        "$43,775 ",
        "$39,467 ",
        "$36,434 ",
        "$46,756 ",
        "$39,075 ",
        "$35,260 ",
        "$35,916 ",
        "$39,115 ",
        "$44,161 ",
        "$38,795 ",
        "$36,812 ",
        "$39,963 ",
        "$38,113 ",
        "$30,284 ",
        "$42,607 ",
        "$37,474 ",
        "$39,536 ",
        "$35,951 ",
        "$37,239 ",
        "$48,389 ",
        "$39,200 ",
        "$39,962 ",
        "$40,651 ",
        "$37,236 ",
        "$33,953 ",
        "$40,384 ",
        "$39,954 ",
        "$43,832 ",
        "$60,196 ",
        "$43,039 ",
        "$38,847 ",
        "$43,276 ",
        "$43,861 ",
        "$38,394 ",
        "$29,145 ",
        "$44,183 ",
        "$42,291 ",
        "$39,327 ",
        "$40,368 ",
        "$44,145 ",
        "$34,600 ",
        "$37,435 ",
        "$40,478 ",
        "$39,206 ",
        "$41,250 ",
        "$37,566 ",
        "$36,250 ",
        "$43,774 ",
        "$40,580 ",
        "$39,194 ",
        "$34,092 ",
        "$49,940 ",
        "$37,357 ",
        "$38,393 ",
        "$42,842 ",
        "$38,036 ",
        "$35,625 ",
        "$36,584 ",
        "$41,319 ",
        "$35,769 ",
        "$42,572 ",
        "$42,571 ",
        "$39,420 ",
        "$38,411 ",
        "$40,979 ",
        "$39,745 ",
        "$39,826 ",
        "$35,955 ",
        "$37,619 ",
        "$38,173 ",
        "$30,710 ",
        "$41,637 ",
        "$42,751 ",
        "$38,401 ",
        "$40,965 ",
        "$44,051 ",
        "$40,689 ",
        "$38,993 ",
        "$41,586 ",
        "$42,194 ",
        "$40,554 ",
        "$42,510 ",
        "$28,481 ",
        "$38,841 ",
        "$41,728 ",
        "$43,870 ",
        "$39,192 ",
        "$33,479 ",
        "$41,274 ",
        "$37,749 ",
        "$38,897 ",
        "$33,709 ",
        "$47,992 ",
        "$39,747 ",
        "$42,518 ",
        "$39,700 ",
        "$40,821 ",
        "$45,729 ",
        "$43,034 ",
        "$38,440 ",
        "$37,634 ",
        "$42,898 ",
        "$42,023 ",
        "$38,534 ",
        "$40,585 ",
        "$43,081 ",
        "$38,280 ",
        "$38,371 ",
        "$37,626 ",
        "$40,637 ",
        "$37,312 ",
        "$41,494 ",
        "$37,246 ",
        "$36,570 ",
        "$44,109 ",
        "$38,343 ",
        "$36,273 ",
        "$35,869 ",
        "$34,842 ",
        "$37,933 ",
        "$39,526 ",
        "$37,453 ",
        "$41,759 ",
        "$41,658 ",
        "$33,779 ",
        "$35,615 ",
        "$49,754 ",
        "$39,028 ",
        "$36,777 ",
        "$37,618 ",
        "$41,366 ",
        "$44,355 ",
        "$41,415 ",
        "$31,967 ",
        "$34,753 ",
        "$40,657 ",
        "$34,252 ",
        "$36,928 ",
        "$37,127 ",
        "$33,941 ",
        "$39,225 ",
        "$34,089 ",
        "$46,224 ",
        "$41,353 ",
        "$44,625 ",
        "$40,411 ",
        "$40,679 ",
        "$43,994 ",
        "$41,061 ",
        "$48,552 ",
        "$41,234 ",
        "$35,026 ",
        "$39,248 ",
        "$38,182 ",
        "$39,074 ",
        "$49,974 ",
        "$40,140 ",
        "$36,120 ",
        "$40,134 ",
        "$40,417 ",
        "$44,432 ",
        "$47,532 ",
        "$47,019 ",
        "$44,206 ",
        "$41,141 ",
        "$38,461 ",
        "$35,641 ",
        "$45,563 ",
        "$38,013 ",
        "$33,750 ",
        "$30,987 ",
        "$47,543 ",
        "$41,368 ",
        "$38,551 ",
        "$34,131 ",
        "$38,406 ",
        "$47,069 ",
        "$40,272 ",
        "$46,695 ",
        "$34,319 ",
        "$50,543 ",
        "$36,073 ",
        "$44,724 ",
        "$32,292 ",
        "$40,375 ",
        "$46,078 ",
        "$52,763 ",
        "$33,622 ",
        "$44,128 ",
        "$36,323 ",
        "$36,213 ",
        "$35,598 ",
        "$49,506 ",
        "$35,560 ",
        "$42,165 ",
        "$38,989 ",
        "$36,261 ",
        "$38,443 ",
        "$37,571 ",
        "$37,849 ",
        "$48,758 ",
        "$36,031 ",
        "$35,225 ",
        "$38,874 ",
        "$35,483 ",
        "$33,200 ",
        "$44,143 ",
        "$40,250 ",
        "$40,516 ",
        "$38,105 ",
        "$39,067 ",
        "$38,495 ",
        "$51,178 ",
        "$38,833 ",
        "$34,035 ",
        "$51,411 ",
        "$49,238 ",
        "$36,165 ",
        "$44,167 ",
        "$36,192 ",
        "$45,612 ",
        "$44,596 ",
        "$41,856 ",
        "$42,549 ",
        "$53,107 ",
        "$38,917 ",
        "$40,453 ",
        "$41,952 ",
        "$43,260 ",
        "$37,587 ",
        "$36,000 ",
        "$38,598 ",
        "$36,999 ",
        "$28,116 ",
        "$42,862 ",
        "$42,393 ",
        "$39,673 ",
        "$39,263 ",
        "$37,003 ",
        "$35,071 ",
        "$38,502 ",
        "$33,717 ",
        "$37,951 ",
        "$33,033 ",
        "$41,458 ",
        "$49,236 ",
        "$34,984 ",
        "$38,328 ",
        "$40,845 ",
        "$35,213 ",
        "$46,159 ",
        "$36,377 ",
        "$28,680 ",
        "$43,510 ",
        "$39,236 ",
        "$35,545 ",
        "$40,313 ",
        "$39,993 ",
        "$38,981 ",
        "$31,163 ",
        "$35,430 ",
        "$33,903 ",
        "$40,126 ",
        "$38,904 ",
        "$51,181 ",
        "$35,683 ",
        "$35,770 ",
        "$39,156 ",
        "$40,895 ",
        "$34,867 ",
        "$38,873 ",
        "$39,410 ",
        "$47,228 ",
        "$40,802 ",
        "$36,726 ",
        "$33,872 ",
        "$38,679 ",
        "$34,710 ",
        "$38,514 ",
        "$37,586 ",
        "$32,951 ",
        "$33,090 ",
        "$32,155 ",
        "$38,580 ",
        "$36,402 ",
        "$37,263 ",
        "$43,013 ",
        "$36,143 ",
        "$32,260 ",
        "$44,152 ",
        "$37,751 ",
        "$35,261 ",
        "$38,413 ",
        "$37,595 ",
        "$36,786 ",
        "$34,619 ",
        "$36,094 ",
        "$30,786 ",
        "$42,506 ",
        "$39,940 ",
        "$39,753 ",
        "$52,023 ",
        "$43,266 ",
        "$37,276 ",
        "$31,928 ",
        "$37,319 ",
        "$39,746 ",
        "$32,888 ",
        "$36,498 ",
        "$39,013 ",
        "$36,334 ",
        "$35,273 ",
        "$34,641 ",
        "$37,964 ",
        "$38,074 ",
        "$40,282 ",
        "$39,512 ",
        "$35,170 ",
        "$55,177 ",
        "$39,381 ",
        "$36,964 ",
        "$39,131 ",
        "$38,710 ",
        "$34,520 ",
        "$37,646 ",
        "$36,496 ",
        "$44,520 ",
        "$37,716 ",
        "$37,739 ",
        "$39,125 ",
        "$33,143 ",
        "$47,118 ",
        "$33,547 ",
        "$34,090 ",
        "$39,546 ",
        "$35,128 ",
        "$35,379 ",
        "$42,364 ",
        "$43,506 ",
        "$39,844 ",
        "$40,160 ",
        "$46,660 ",
        "$35,828 ",
        "$37,894 ",
        "$35,439 ",
        "$34,419 ",
        "$36,356 ",
        "$35,150 ",
        "$36,713 ",
        "$34,295 ",
        "$35,503 ",
        "$30,409 ",
        "$35,507 ",
        "$32,853 ",
        "$41,446 ",
        "$31,003 ",
        "$49,819 ",
        "$47,617 ",
        "$42,939 ",
        "$37,140 ",
        "$38,823 ",
        "$32,961 ",
        "$39,091 ",
        "$39,591 ",
        "$36,607 ",
        "$39,470 ",
        "$34,233 ",
        "$35,938 ",
        "$35,522 ",
        "$38,070 ",
        "$44,943 ",
        "$32,495 ",
        "$40,759 ",
        "$33,060 ",
        "$34,029 ",
        "$32,402 ",
        "$41,193 ",
        "$36,676 ",
        "$35,761 ",
        "$38,373 ",
        "$36,020 ",
        "$34,733 ",
        "$39,430 ",
        "$34,969 ",
        "$34,420 ",
        "$40,235 ",
        "$34,357 ",
        "$36,121 ",
        "$36,406 ",
        "$37,388 ",
        "$32,881 ",
        "$40,926 ",
        "$37,079 ",
        "$37,349 ",
        "$34,239 ",
        "$30,164 ",
        "$37,383 ",
        "$33,600 ",
        "$36,590 ",
        "$42,917 ",
        "$37,368 ",
        "$36,766 ",
        "$32,835 ",
        "$46,229 ",
        "$32,399 ",
        "$36,218 ",
        "$36,387 ",
        "$36,096 ",
        "$33,119 ",
        "$28,259 ",
        "$40,008 ",
        "$35,718 ",
        "$33,848 ",
        "$37,909 ",
        "$36,372 ",
        "$39,334 ",
        "$34,285 ",
        "$34,996 ",
        "$34,701 ",
        "$38,425 ",
        "$32,556 ",
        "$32,723 ",
        "$40,102 ",
        "$33,159 ",
        "$36,028 ",
        "$31,345 ",
        "$43,793 ",
        "$39,654 ",
        "$31,842 ",
        "$50,185 ",
        "$31,712 ",
        "$43,891 ",
        "$39,519 ",
        "$40,830 ",
        "$33,006 ",
        "$36,806 ",
        "$36,788 ",
        "$32,900 ",
        "$40,023 ",
        "$29,357 ",
        "$32,015 ",
        "$40,451 ",
        "$31,373 ",
        "$39,909 ",
        "$38,187 ",
        "$31,543 ",
        "$39,402 ",
        "$39,943 ",
        "$36,741 ",
        "$34,391 ",
        "$34,424 ",
        "$37,448 ",
        "$34,591 ",
        "$35,297 ",
        "$29,925 ",
        "$40,842 ",
        "$40,566 ",
        "$39,306 ",
        "$36,428 ",
        "$31,483 ",
        "$37,365 ",
        "$35,334 ",
        "$36,415 ",
        "$47,941 ",
        "$34,418 ",
        "$38,719 ",
        "$31,830 ",
        "$39,190 ",
        "$35,231 ",
        "$34,864 ",
        "$38,429 ",
        "$38,290 ",
        "$36,326 ",
        "$34,572 ",
        "$41,595 ",
        "$35,817 ",
        "$35,845 ",
        "$37,333 ",
        "$32,221 ",
        "$35,469 ",
        "$30,051 ",
        "$38,378 ",
        "$41,016 ",
        "$36,384 ",
        "$35,111 ",
        "$32,517 ",
        "$34,936 ",
        "$33,233 ",
        "$39,469 ",
        "$40,760 ",
        "$33,015 ",
        "$32,963 ",
        "$45,489 ",
        "$35,771 ",
        "$32,930 ",
        "$36,727 ",
        "$34,555 ",
        "$33,524 ",
        "$33,618 ",
        "$31,189 ",
        "$34,542 ",
        "$35,879 ",
        "$38,085 ",
        "$33,694 ",
        "$28,390 ",
        "$34,002 ",
        "$37,050 ",
        "$33,771 ",
        "$46,139 ",
        "$31,161 ",
        "$36,835 ",
        "$39,722 ",
        "$39,850 ",
        "$34,848 ",
        "$31,848 ",
        "$32,033 ",
        "$34,793 ",
        "$32,751 ",
        "$31,671 ",
        "$33,582 ",
        "$31,060 ",
        "$34,985 ",
        "$35,840 ",
        "$33,229 ",
        "$37,260 ",
        "$26,688 ",
        "$42,963 ",
        "$39,899 ",
        "$38,826 ",
        "$33,757 ",
        "$37,898 ",
        "$35,792 ",
        "$40,455 ",
        "$37,238 ",
        "$36,311 ",
        "$29,897 ",
        "$35,271 ",
        "$31,502 ",
        "$42,139 ",
        "$30,821 ",
        "$51,689 ",
        "$40,653 ",
        "$33,838 ",
        "$37,277 ",
        "$34,636 ",
        "$38,902 ",
        "$35,487 ",
        "$36,591 ",
        "$34,496 ",
        "$33,889 ",
        "$40,853 ",
        "$35,698 ",
        "$48,133 ",
        "$33,452 ",
        "$31,641 ",
        "$35,897 ",
        "$34,080 ",
        "$33,386 ",
        "$39,581 ",
        "$40,157 ",
        "$34,454 ",
        "$32,497 ",
        "$32,206 ",
        "$26,230 ",
        "$34,604 ",
        "$34,432 ",
        "$32,592 ",
        "$36,473 ",
        "$35,049 ",
        "$33,819 ",
        "$35,421 ",
        "$34,348 ",
        "$30,764 ",
        "$31,215 ",
        "$30,962 ",
        "$34,202 ",
        "$35,678 ",
        "$34,830 ",
        "$33,528 ",
        "$33,318 ",
        "$40,771 ",
        "$34,474 ",
        "$52,101 ",
        "$34,494 ",
        "$35,240 ",
        "$34,841 ",
        "$42,591 ",
        "$34,388 ",
        "$36,308 ",
        "$36,491 ",
        "$34,688 ",
        "$40,120 ",
        "$37,851 ",
        "$32,668 ",
        "$36,542 ",
        "$34,855 ",
        "$35,947 ",
        "$35,742 ",
        "$29,400 ",
        "$37,292 ",
        "$55,247 ",
        "$34,036 ",
        "$38,907 ",
        "$36,705 ",
        "$37,788 ",
        "$33,103 ",
        "$30,023 ",
        "$36,641 ",
        "$31,170 ",
        "$35,715 ",
        "$31,362 ",
        "$30,619 ",
        "$33,239 ",
        "$31,679 ",
        "$30,661 ",
        "$36,354 ",
        "$31,832 ",
        "$37,743 ",
        "$33,942 ",
        "$41,191 ",
        "$31,304 ",
        "$37,760 ",
        "$34,406 ",
        "$36,022 ",
        "$35,329 ",
        "$35,315 ",
        "$35,070 ",
        "$39,900 ",
        "$33,525 ",
        "$32,721 ",
        "$31,234 ",
        "$40,606 ",
        "$32,329 ",
        "$27,645 ",
        "$30,802 ",
        "$34,797 ",
        "$32,364 ",
        "$33,885 ",
        "$28,275 ",
        "$37,487 ",
        "$31,433 ",
        "$34,987 ",
        "$42,708 ",
        "$31,200 ",
        "$30,038 ",
        "$27,796 ",
        "$36,753 ",
        "$33,796 ",
        "$37,327 ",
        "$38,442 ",
        "$36,082 ",
        "$40,450 ",
        "$33,406 ",
        "$39,267 ",
        "$45,625 ",
        "$41,541 ",
        "$37,012 ",
        "$42,369 ",
        "$30,345 ",
        "$48,369 ",
        "$42,039 ",
        "$34,570 ",
        "$41,550 ",
        "$30,980 ",
        "$42,105 ",
        "$31,214 ",
        "$27,430 ",
        "$34,397 ",
        "$40,259 ",
        "$37,631 ",
        "$30,201 ",
        "$31,778 ",
        "$27,766 ",
        "$30,476 ",
        "$33,198 ",
        "$41,189 ",
        "$31,593 ",
        "$34,110 ",
        "$44,212 ",
        "$36,296 ",
        "$39,714 ",
        "$31,410 ",
        "$37,745 ",
        "$40,568 ",
        "$31,786 ",
        "$30,521 ",
        "$35,237 ",
        "$44,962 ",
        "$35,380 ",
        "$31,790 ",
        "$28,326 ",
        "$37,203 ",
        "$28,853 ",
        "$26,104 ",
        "$27,381 ",
        "$41,444 ",
        "$36,809 ",
        "$36,681 ",
        "$33,652 ",
        "$32,996 ",
        "$37,997 ",
        "$29,848 ",
        "$34,902 ",
        "$33,301 ",
        "$38,764 ",
        "$30,573 ",
        "$37,151 ",
        "$36,447 ",
        "$34,399 ",
        "$33,651 ",
        "$33,784 ",
        "$32,533 ",
        "$29,918 ",
        "$29,832 ",
        "$32,056 ",
        "$38,650 ",
        "$32,524 ",
        "$29,325 ",
        "$36,413 ",
        "$28,513 ",
        "$31,539 ",
        "$31,867 ",
        "$34,817 ",
        "$35,870 ",
        "$34,526 ",
        "$33,408 ",
        "$35,830 ",
        "$39,452 ",
        "$26,519 ",
        "$33,381 ",
        "$32,384 ",
        "$36,173 ",
        "$32,078 ",
        "$32,845 ",
        "$29,732 ",
        "$37,436 ",
        "$31,477 ",
        "$36,124 ",
        "$45,477 ",
        "$27,543 ",
        "$31,750 ",
        "$38,648 ",
        "$42,651 ",
        "$28,741 ",
        "$29,876 ",
        "$31,252 ",
        "$34,433 ",
        "$28,401 ",
        "$28,983 ",
        "$29,721 ",
        "$40,111 ",
        "$30,768 ",
        "$35,236 ",
        "$38,048 ",
        "$27,455 ",
        "$32,046 ",
        "$31,171 ",
        "$30,000 ",
        "$32,484 ",
        "$33,823 ",
        "$27,353 ",
        "$35,306 ",
        "$32,424 ",
        "$35,535 ",
        "$30,750 ",
        "$33,960 ",
        "$38,500 ",
        "$43,926 ",
        "$27,263 ",
        "$36,070 ",
        "$32,089 ",
        "$31,039 ",
        "$36,920 ",
        "$28,889 ",
        "$29,727 ",
        "$31,132 ",
        "$33,981 ",
        "$31,090 ",
        "$43,690 ",
        "$35,511 ",
        "$28,931 ",
        "$32,628 ",
        "$26,737 ",
        "$32,911 ",
        "$30,724 ",
        "$31,943 ",
        "$36,722 ",
        "$27,100 ",
        "$34,534 ",
        "$34,322 ",
        "$32,258 ",
        "$32,521 ",
        "$41,807 ",
        "$33,870 ",
        "$38,447 ",
        "$31,613 ",
        "$30,779 ",
        "$30,861 ",
        "$33,257 ",
        "$28,585 ",
        "$31,061 ",
        "$31,109 ",
        "$28,093 ",
        "$31,308 ",
        "$34,216 ",
        "$29,808 ",
        "$44,092 ",
        "$36,927 ",
        "$32,503 ",
        "$39,635 ",
        "$30,687 ",
        "$26,201 ",
        "$29,149 ",
        "$42,433 ",
        "$30,674 ",
        "$32,908 ",
        "$29,609 ",
        "$28,599 ",
        "$32,702 ",
        "$29,192 ",
        "$34,888 ",
        "$29,184 ",
        "$29,022 ",
        "$29,293 ",
        "$32,291 ",
        "$32,130 ",
        "$29,497 ",
        "$39,697 ",
        "$30,797 ",
        "$30,302 ",
        "$35,578 ",
        "$27,743 ",
        "$37,617 ",
        "$37,607 ",
        "$39,681 ",
        "$25,906 ",
        "$30,658 ",
        "$27,186 ",
        "$29,379 ",
        "$30,714 ",
        "$47,540 ",
        "$29,634 ",
        "$31,494 ",
        "$35,425 ",
        "$28,388 ",
        "$37,237 ",
        "$29,282 ",
        "$36,293 ",
        "$33,228 ",
        "$35,153 ",
        "$34,694 ",
        "$32,239 ",
        "$29,769 ",
        "$30,049 ",
        "$32,175 ",
        "$29,108 ",
        "$42,045 ",
        "$26,156 ",
        "$35,849 ",
        "$31,375 ",
        "$35,109 ",
        "$32,326 ",
        "$29,203 ",
        "$33,443 ",
        "$35,125 ",
        "$26,407 ",
        "$30,571 ",
        "$39,966 ",
        "$32,054 ",
        "$26,814 ",
        "$29,592 ",
        "$24,658 ",
        "$33,519 ",
        "$29,934 ",
        "$29,787 ",
        "$31,446 ",
        "$33,833 ",
        "$26,261 ",
        "$30,466 ",
        "$30,873 ",
        "$31,336 ",
        "$36,111 ",
        "$40,492 ",
        "$40,571 ",
        "$37,125 ",
        "$29,806 ",
        "$26,839 ",
        "$43,438 ",
        "$32,059 ",
        "$41,732 ",
        "$26,877 ",
        "$26,228 ",
        "$34,963 ",
        "$37,340 ",
        "$32,697 ",
        "$28,817 ",
        "$30,973 ",
        "$24,226 ",
        "$26,986 ",
        "$25,849 ",
        "$41,297 ",
        "$36,505 ",
        "$26,968 ",
        "$28,645 ",
        "$27,373 ",
        "$33,179 ",
        "$24,045 ",
        "$32,780 ",
        "$28,297 ",
        "$39,449 ",
        "$29,012 ",
        "$36,888 ",
        "$25,465 ",
        "$24,038 ",
        "$21,865 ",
        "$23,892 ",
        "$24,480 ",
        "$26,336 ",
        "$30,880 ",
        "$34,146 ",
        "$28,547 ",
        "$31,068 ",
        "$29,071 ",
        "$22,574 ",
        "$22,186 ",
        "$40,145 ",
        "$22,545 ",
        "$22,252 ",
        "$24,246 ",
        "$22,920 ",
        "$22,863 ",
        "$30,240 ",
        "$29,003 ",
        "$24,767 ",
        "$28,209 ",
        "$31,395 ",
        "$36,556 ",
        "$26,972 ",
        "$19,986 ",
        "$42,660 ",
        "$25,498 ",
        "$21,883 ",
        "$23,642 ",
        "$25,252 ",
        "$26,756 ",
        "$23,451 ",
        "$32,928 ",
        "$21,192 ",
        "$23,600 ",
        "$25,625 ",
        "$24,338 ",
        "$29,853 ",
        "$26,028 ",
        "$31,476 ",
        "$30,458 ",
        "$26,619 ",
        "$25,034 ",
        "$26,634 ",
        "$25,000 ",
        "$32,708 ",
        "$23,689 ",
        "$22,325 ",
        "$25,321 ",
        "$27,115 ",
        "$20,972 ",
        "$24,927 ",
        "$25,886 ",
        "$40,176 ",
        "$31,934 ",
        "$24,382 ",
        "$25,648 "
      ]
    },
    {
      "datamart_id": 6,
      "semantic_type": [],
      "name": "Median family income",
      "description": "column name: Median family income, dtype: object",
      "named_entity": [
        "$84,627 ",
        "$139,244 ",
        "$152,857 ",
        "$117,357 ",
        "$107,511 ",
        "$93,981 ",
        "$124,979 ",
        "$128,596 ",
        "$125,828 ",
        "$76,250 ",
        "$117,408 ",
        "$117,683 ",
        "$104,250 ",
        "$90,116 ",
        "$128,657 ",
        "$105,341 ",
        "$117,393 ",
        "$92,500 ",
        "$133,550 ",
        "$82,500 ",
        "$105,844 ",
        "$88,750 ",
        "$79,665 ",
        "$92,042 ",
        "$108,943 ",
        "$113,538 ",
        "$112,930 ",
        "$83,558 ",
        "$102,222 ",
        "$104,032 ",
        "$105,971 ",
        "$95,879 ",
        "$112,874 ",
        "$68,438 ",
        "$105,278 ",
        "$92,262 ",
        "$89,583 ",
        "$103,983 ",
        "$99,587 ",
        "$104,796 ",
        "$77,708 ",
        "$101,268 ",
        "$109,188 ",
        "$88,962 ",
        "$103,564 ",
        "$98,501 ",
        "$92,510 ",
        "$103,556 ",
        "$99,768 ",
        "$86,167 ",
        "$90,406 ",
        "$93,131 ",
        "$92,512 ",
        "$95,654 ",
        "$86,285 ",
        "$95,208 ",
        "$98,848 ",
        "$93,420 ",
        "$107,684 ",
        "$94,208 ",
        "$97,909 ",
        "$87,639 ",
        "$74,811 ",
        "$92,116 ",
        "$92,667 ",
        "$69,167 ",
        "$100,066 ",
        "$97,421 ",
        "$65,067 ",
        "$87,945 ",
        "$92,974 ",
        "$95,112 ",
        "$84,559 ",
        "$80,907 ",
        "$92,907 ",
        "$94,267 ",
        "$96,913 ",
        "$96,787 ",
        "$106,544 ",
        "$104,078 ",
        "$89,889 ",
        "$77,500 ",
        "$96,458 ",
        "$91,532 ",
        "$100,652 ",
        "$98,259 ",
        "$80,707 ",
        "$94,324 ",
        "$75,658 ",
        "$94,263 ",
        "$106,322 ",
        "$66,773 ",
        "$84,182 ",
        "$65,980 ",
        "$95,392 ",
        "$76,000 ",
        "$69,632 ",
        "$90,466 ",
        "$83,333 ",
        "$74,758 ",
        "$100,643 ",
        "$76,311 ",
        "$84,957 ",
        "$89,653 ",
        "$95,186 ",
        "$85,885 ",
        "$90,092 ",
        "$86,750 ",
        "$88,618 ",
        "$76,575 ",
        "$97,693 ",
        "$92,642 ",
        "$91,574 ",
        "$99,091 ",
        "$90,431 ",
        "$87,058 ",
        "$84,185 ",
        "$83,110 ",
        "$83,164 ",
        "$87,352 ",
        "$85,253 ",
        "$74,559 ",
        "$85,666 ",
        "$88,889 ",
        "$79,700 ",
        "$75,532 ",
        "$81,805 ",
        "$92,837 ",
        "$99,649 ",
        "$99,573 ",
        "$84,770 ",
        "$81,952 ",
        "$95,996 ",
        "$84,430 ",
        "$81,116 ",
        "$93,519 ",
        "$80,875 ",
        "$90,752 ",
        "$84,861 ",
        "$67,597 ",
        "$94,931 ",
        "$83,250 ",
        "$88,438 ",
        "$84,765 ",
        "$68,003 ",
        "$79,420 ",
        "$63,550 ",
        "$90,086 ",
        "$84,746 ",
        "$80,038 ",
        "$76,282 ",
        "$82,625 ",
        "$76,346 ",
        "$82,076 ",
        "$83,509 ",
        "$72,635 ",
        "$60,285 ",
        "$72,649 ",
        "$88,777 ",
        "$91,587 ",
        "$85,091 ",
        "$88,604 ",
        "$64,173 ",
        "$82,452 ",
        "$67,969 ",
        "$82,558 ",
        "$83,887 ",
        "$63,705 ",
        "$85,115 ",
        "$73,951 ",
        "$81,523 ",
        "$85,636 ",
        "$73,775 ",
        "$83,568 ",
        "$69,722 ",
        "$75,640 ",
        "$77,366 ",
        "$78,058 ",
        "$68,547 ",
        "$61,672 ",
        "$72,229 ",
        "$77,324 ",
        "$74,112 ",
        "$86,301 ",
        "$79,541 ",
        "$70,096 ",
        "$68,840 ",
        "$75,432 ",
        "$82,235 ",
        "$59,643 ",
        "$64,260 ",
        "$75,896 ",
        "$61,449 ",
        "$76,549 ",
        "$58,875 ",
        "$62,168 ",
        "$87,913 ",
        "$73,649 ",
        "$88,480 ",
        "$83,877 ",
        "$79,408 ",
        "$78,000 ",
        "$66,878 ",
        "$74,798 ",
        "$68,083 ",
        "$79,954 ",
        "$70,148 ",
        "$84,808 ",
        "$87,760 ",
        "$81,846 ",
        "$61,339 ",
        "$64,737 ",
        "$80,899 ",
        "$81,500 ",
        "$80,740 ",
        "$69,448 ",
        "$82,930 ",
        "$82,959 ",
        "$78,995 ",
        "$76,750 ",
        "$72,115 ",
        "$72,946 ",
        "$79,911 ",
        "$65,958 ",
        "$71,217 ",
        "$76,285 ",
        "$75,766 ",
        "$86,133 ",
        "$77,057 ",
        "$87,159 ",
        "$64,798 ",
        "$74,993 ",
        "$80,827 ",
        "$81,766 ",
        "$75,860 ",
        "$67,150 ",
        "$64,886 ",
        "$74,418 ",
        "$70,380 ",
        "$85,638 ",
        "$83,907 ",
        "$68,750 ",
        "$58,867 ",
        "$81,519 ",
        "$56,813 ",
        "$76,104 ",
        "$72,360 ",
        "$65,859 ",
        "$82,259 ",
        "$66,570 ",
        "$67,159 ",
        "$60,000 ",
        "$75,333 ",
        "$68,769 ",
        "$87,374 ",
        "$80,856 ",
        "$71,441 ",
        "$80,655 ",
        "$60,083 ",
        "$91,368 ",
        "$75,689 ",
        "$87,045 ",
        "$73,890 ",
        "$77,143 ",
        "$66,875 ",
        "$70,837 ",
        "$98,409 ",
        "$68,207 ",
        "$76,711 ",
        "$73,379 ",
        "$82,568 ",
        "$67,636 ",
        "$74,043 ",
        "$77,373 ",
        "$75,231 ",
        "$69,775 ",
        "$61,083 ",
        "$70,467 ",
        "$78,590 ",
        "$76,204 ",
        "$61,845 ",
        "$77,524 ",
        "$79,101 ",
        "$76,194 ",
        "$71,158 ",
        "$66,189 ",
        "$77,729 ",
        "$78,626 ",
        "$73,495 ",
        "$63,361 ",
        "$81,798 ",
        "$77,369 ",
        "$74,167 ",
        "$85,100 ",
        "$56,151 ",
        "$64,313 ",
        "$64,404 ",
        "$74,024 ",
        "$67,570 ",
        "$81,595 ",
        "$76,822 ",
        "$65,897 ",
        "$83,812 ",
        "$73,043 ",
        "$72,632 ",
        "$67,000 ",
        "$64,792 ",
        "$76,469 ",
        "$86,747 ",
        "$74,834 ",
        "$85,440 ",
        "$72,602 ",
        "$66,622 ",
        "$83,474 ",
        "$61,940 ",
        "$69,345 ",
        "$80,985 ",
        "$66,187 ",
        "$65,394 ",
        "$67,732 ",
        "$82,601 ",
        "$65,457 ",
        "$63,333 ",
        "$76,530 ",
        "$63,000 ",
        "$80,085 ",
        "$64,873 ",
        "$73,972 ",
        "$74,235 ",
        "$63,672 ",
        "$74,519 ",
        "$71,338 ",
        "$74,885 ",
        "$67,132 ",
        "$75,761 ",
        "$73,075 ",
        "$72,764 ",
        "$80,767 ",
        "$70,381 ",
        "$69,098 ",
        "$79,943 ",
        "$55,183 ",
        "$75,857 ",
        "$58,222 ",
        "$70,640 ",
        "$74,207 ",
        "$61,644 ",
        "$65,392 ",
        "$67,938 ",
        "$63,490 ",
        "$75,769 ",
        "$81,683 ",
        "$78,328 ",
        "$77,447 ",
        "$62,248 ",
        "$79,964 ",
        "$71,310 ",
        "$66,513 ",
        "$65,735 ",
        "$81,821 ",
        "$79,128 ",
        "$75,407 ",
        "$71,206 ",
        "$81,385 ",
        "$66,369 ",
        "$73,380 ",
        "$69,894 ",
        "$73,260 ",
        "$66,448 ",
        "$68,401 ",
        "$83,670 ",
        "$57,125 ",
        "$65,216 ",
        "$71,995 ",
        "$73,386 ",
        "$59,491 ",
        "$67,785 ",
        "$67,973 ",
        "$78,101 ",
        "$68,368 ",
        "$48,403 ",
        "$61,270 ",
        "$73,319 ",
        "$69,754 ",
        "$78,565 ",
        "$69,939 ",
        "$64,740 ",
        "$64,283 ",
        "$70,642 ",
        "$73,144 ",
        "$81,702 ",
        "$74,558 ",
        "$79,880 ",
        "$61,156 ",
        "$64,651 ",
        "$64,934 ",
        "$70,480 ",
        "$69,556 ",
        "$76,932 ",
        "$63,888 ",
        "$62,099 ",
        "$75,563 ",
        "$57,675 ",
        "$67,061 ",
        "$74,132 ",
        "$72,597 ",
        "$69,375 ",
        "$70,728 ",
        "$63,509 ",
        "$79,744 ",
        "$72,018 ",
        "$69,561 ",
        "$60,182 ",
        "$74,469 ",
        "$74,531 ",
        "$71,914 ",
        "$75,810 ",
        "$70,143 ",
        "$71,563 ",
        "$68,524 ",
        "$75,486 ",
        "$78,918 ",
        "$69,157 ",
        "$55,112 ",
        "$69,792 ",
        "$68,680 ",
        "$72,719 ",
        "$64,556 ",
        "$76,004 ",
        "$64,668 ",
        "$72,126 ",
        "$65,969 ",
        "$73,059 ",
        "$60,747 ",
        "$66,544 ",
        "$73,887 ",
        "$67,738 ",
        "$56,250 ",
        "$71,483 ",
        "$51,932 ",
        "$55,286 ",
        "$58,535 ",
        "$72,958 ",
        "$67,354 ",
        "$65,884 ",
        "$60,891 ",
        "$68,300 ",
        "$73,528 ",
        "$70,259 ",
        "$74,309 ",
        "$61,917 ",
        "$61,367 ",
        "$73,969 ",
        "$58,529 ",
        "$73,910 ",
        "$64,608 ",
        "$64,504 ",
        "$64,693 ",
        "$66,629 ",
        "$70,208 ",
        "$67,436 ",
        "$62,737 ",
        "$60,170 ",
        "$51,810 ",
        "$70,077 ",
        "$60,909 ",
        "$63,940 ",
        "$61,526 ",
        "$65,276 ",
        "$61,723 ",
        "$71,464 ",
        "$77,640 ",
        "$58,481 ",
        "$59,000 ",
        "$64,310 ",
        "$70,625 ",
        "$70,001 ",
        "$59,531 ",
        "$72,559 ",
        "$63,912 ",
        "$63,380 ",
        "$63,343 ",
        "$80,939 ",
        "$59,398 ",
        "$73,465 ",
        "$94,648 ",
        "$65,027 ",
        "$72,237 ",
        "$68,994 ",
        "$62,036 ",
        "$62,258 ",
        "$56,656 ",
        "$60,873 ",
        "$65,311 ",
        "$65,900 ",
        "$67,673 ",
        "$73,086 ",
        "$66,000 ",
        "$61,622 ",
        "$67,081 ",
        "$75,513 ",
        "$65,577 ",
        "$63,310 ",
        "$60,594 ",
        "$74,484 ",
        "$60,903 ",
        "$61,548 ",
        "$65,089 ",
        "$70,026 ",
        "$60,581 ",
        "$70,024 ",
        "$51,000 ",
        "$64,802 ",
        "$64,157 ",
        "$62,147 ",
        "$71,455 ",
        "$76,109 ",
        "$68,419 ",
        "$60,022 ",
        "$62,308 ",
        "$55,893 ",
        "$64,806 ",
        "$70,426 ",
        "$65,486 ",
        "$61,063 ",
        "$62,237 ",
        "$74,687 ",
        "$60,395 ",
        "$65,133 ",
        "$72,409 ",
        "$66,229 ",
        "$68,671 ",
        "$48,816 ",
        "$68,812 ",
        "$62,624 ",
        "$68,276 ",
        "$60,745 ",
        "$65,225 ",
        "$63,616 ",
        "$67,802 ",
        "$67,047 ",
        "$63,664 ",
        "$66,026 ",
        "$66,704 ",
        "$64,950 ",
        "$60,375 ",
        "$60,989 ",
        "$75,978 ",
        "$74,513 ",
        "$72,849 ",
        "$64,432 ",
        "$61,488 ",
        "$63,558 ",
        "$58,068 ",
        "$53,145 ",
        "$66,387 ",
        "$57,328 ",
        "$67,361 ",
        "$61,858 ",
        "$58,478 ",
        "$68,480 ",
        "$74,867 ",
        "$68,039 ",
        "$67,641 ",
        "$63,545 ",
        "$70,185 ",
        "$76,563 ",
        "$67,961 ",
        "$59,745 ",
        "$73,828 ",
        "$58,688 ",
        "$67,064 ",
        "$68,408 ",
        "$66,619 ",
        "$61,784 ",
        "$75,328 ",
        "$56,591 ",
        "$67,554 ",
        "$64,625 ",
        "$64,614 ",
        "$65,032 ",
        "$56,847 ",
        "$68,593 ",
        "$60,910 ",
        "$70,484 ",
        "$61,583 ",
        "$55,500 ",
        "$58,263 ",
        "$60,869 ",
        "$60,441 ",
        "$61,804 ",
        "$63,253 ",
        "$69,551 ",
        "$67,897 ",
        "$65,579 ",
        "$71,627 ",
        "$63,910 ",
        "$71,234 ",
        "$66,950 ",
        "$60,329 ",
        "$57,404 ",
        "$58,500 ",
        "$63,150 ",
        "$66,670 ",
        "$48,681 ",
        "$59,535 ",
        "$59,631 ",
        "$60,313 ",
        "$59,375 ",
        "$64,500 ",
        "$44,243 ",
        "$67,890 ",
        "$67,769 ",
        "$59,894 ",
        "$66,811 ",
        "$68,714 ",
        "$64,824 ",
        "$68,838 ",
        "$56,063 ",
        "$64,959 ",
        "$75,167 ",
        "$71,359 ",
        "$64,877 ",
        "$68,179 ",
        "$64,951 ",
        "$68,493 ",
        "$70,251 ",
        "$58,761 ",
        "$64,204 ",
        "$60,003 ",
        "$58,214 ",
        "$70,044 ",
        "$69,097 ",
        "$60,929 ",
        "$70,352 ",
        "$70,875 ",
        "$77,727 ",
        "$66,652 ",
        "$59,810 ",
        "$64,273 ",
        "$70,074 ",
        "$62,278 ",
        "$53,493 ",
        "$60,341 ",
        "$66,882 ",
        "$66,466 ",
        "$66,182 ",
        "$55,880 ",
        "$56,236 ",
        "$69,837 ",
        "$74,552 ",
        "$68,397 ",
        "$61,389 ",
        "$65,768 ",
        "$61,464 ",
        "$69,531 ",
        "$61,486 ",
        "$61,308 ",
        "$61,131 ",
        "$59,095 ",
        "$71,777 ",
        "$67,674 ",
        "$55,551 ",
        "$66,099 ",
        "$62,904 ",
        "$75,729 ",
        "$66,006 ",
        "$62,993 ",
        "$57,244 ",
        "$54,220 ",
        "$65,057 ",
        "$73,125 ",
        "$67,968 ",
        "$76,357 ",
        "$55,113 ",
        "$60,740 ",
        "$69,799 ",
        "$51,914 ",
        "$57,024 ",
        "$68,598 ",
        "$65,039 ",
        "$63,201 ",
        "$60,864 ",
        "$64,955 ",
        "$70,163 ",
        "$66,392 ",
        "$66,612 ",
        "$62,143 ",
        "$64,154 ",
        "$75,012 ",
        "$56,221 ",
        "$67,138 ",
        "$67,072 ",
        "$61,786 ",
        "$61,706 ",
        "$52,083 ",
        "$60,525 ",
        "$64,446 ",
        "$60,534 ",
        "$59,623 ",
        "$71,741 ",
        "$69,980 ",
        "$61,455 ",
        "$60,742 ",
        "$73,205 ",
        "$61,768 ",
        "$69,172 ",
        "$65,600 ",
        "$70,079 ",
        "$69,676 ",
        "$63,831 ",
        "$66,085 ",
        "$66,941 ",
        "$54,300 ",
        "$65,610 ",
        "$65,740 ",
        "$60,935 ",
        "$68,078 ",
        "$65,804 ",
        "$66,176 ",
        "$58,240 ",
        "$66,256 ",
        "$56,344 ",
        "$59,764 ",
        "$67,750 ",
        "$66,435 ",
        "$68,159 ",
        "$57,958 ",
        "$61,317 ",
        "$74,433 ",
        "$68,255 ",
        "$66,106 ",
        "$46,512 ",
        "$67,646 ",
        "$64,371 ",
        "$61,233 ",
        "$60,413 ",
        "$58,551 ",
        "$66,967 ",
        "$62,123 ",
        "$65,646 ",
        "$60,684 ",
        "$61,645 ",
        "$57,893 ",
        "$62,273 ",
        "$66,555 ",
        "$56,625 ",
        "$59,306 ",
        "$65,103 ",
        "$67,319 ",
        "$61,942 ",
        "$62,945 ",
        "$70,955 ",
        "$62,596 ",
        "$55,152 ",
        "$61,634 ",
        "$69,704 ",
        "$51,380 ",
        "$58,530 ",
        "$49,073 ",
        "$62,348 ",
        "$53,586 ",
        "$67,439 ",
        "$57,891 ",
        "$87,922 ",
        "$55,938 ",
        "$63,435 ",
        "$69,606 ",
        "$61,575 ",
        "$63,883 ",
        "$68,096 ",
        "$62,792 ",
        "$66,046 ",
        "$50,051 ",
        "$58,556 ",
        "$63,373 ",
        "$51,939 ",
        "$59,733 ",
        "$56,048 ",
        "$52,761 ",
        "$60,666 ",
        "$61,516 ",
        "$57,150 ",
        "$58,893 ",
        "$68,516 ",
        "$67,292 ",
        "$62,464 ",
        "$60,159 ",
        "$71,325 ",
        "$67,468 ",
        "$53,750 ",
        "$66,712 ",
        "$56,616 ",
        "$59,238 ",
        "$64,032 ",
        "$66,076 ",
        "$60,856 ",
        "$57,865 ",
        "$65,968 ",
        "$63,551 ",
        "$64,821 ",
        "$59,403 ",
        "$60,483 ",
        "$70,215 ",
        "$54,625 ",
        "$56,875 ",
        "$69,196 ",
        "$58,599 ",
        "$60,580 ",
        "$56,967 ",
        "$59,191 ",
        "$63,230 ",
        "$66,005 ",
        "$56,065 ",
        "$76,888 ",
        "$63,212 ",
        "$70,016 ",
        "$59,671 ",
        "$65,064 ",
        "$56,012 ",
        "$63,523 ",
        "$65,561 ",
        "$76,860 ",
        "$62,827 ",
        "$63,452 ",
        "$66,936 ",
        "$60,258 ",
        "$57,709 ",
        "$61,581 ",
        "$65,402 ",
        "$63,168 ",
        "$59,152 ",
        "$62,599 ",
        "$65,363 ",
        "$60,714 ",
        "$55,030 ",
        "$66,432 ",
        "$59,423 ",
        "$59,449 ",
        "$71,425 ",
        "$60,066 ",
        "$53,015 ",
        "$61,230 ",
        "$63,176 ",
        "$67,049 ",
        "$64,760 ",
        "$58,470 ",
        "$66,788 ",
        "$59,169 ",
        "$63,841 ",
        "$66,626 ",
        "$63,669 ",
        "$68,101 ",
        "$56,484 ",
        "$71,523 ",
        "$59,221 ",
        "$59,070 ",
        "$63,889 ",
        "$62,583 ",
        "$61,474 ",
        "$60,478 ",
        "$60,921 ",
        "$51,750 ",
        "$64,911 ",
        "$56,284 ",
        "$64,750 ",
        "$60,100 ",
        "$63,148 ",
        "$70,303 ",
        "$65,179 ",
        "$61,528 ",
        "$59,915 ",
        "$55,234 ",
        "$62,988 ",
        "$62,935 ",
        "$50,000 ",
        "$62,159 ",
        "$64,120 ",
        "$58,842 ",
        "$56,429 ",
        "$64,250 ",
        "$66,800 ",
        "$63,117 ",
        "$58,542 ",
        "$66,173 ",
        "$64,258 ",
        "$69,554 ",
        "$60,571 ",
        "$49,167 ",
        "$58,668 ",
        "$54,849 ",
        "$57,062 ",
        "$58,220 ",
        "$63,881 ",
        "$63,661 ",
        "$69,685 ",
        "$62,589 ",
        "$59,226 ",
        "$60,685 ",
        "$59,165 ",
        "$58,733 ",
        "$61,064 ",
        "$60,259 ",
        "$67,058 ",
        "$70,025 ",
        "$66,917 ",
        "$63,042 ",
        "$57,870 ",
        "$59,573 ",
        "$59,278 ",
        "$66,988 ",
        "$63,037 ",
        "$65,286 ",
        "$60,232 ",
        "$64,383 ",
        "$56,607 ",
        "$60,059 ",
        "$57,213 ",
        "$70,654 ",
        "$63,875 ",
        "$52,944 ",
        "$76,645 ",
        "$53,893 ",
        "$58,438 ",
        "$60,614 ",
        "$73,060 ",
        "$65,433 ",
        "$68,053 ",
        "$72,075 ",
        "$69,241 ",
        "$66,840 ",
        "$63,789 ",
        "$60,897 ",
        "$59,844 ",
        "$49,213 ",
        "$60,799 ",
        "$52,403 ",
        "$59,539 ",
        "$64,495 ",
        "$59,038 ",
        "$50,887 ",
        "$49,191 ",
        "$62,194 ",
        "$62,026 ",
        "$62,864 ",
        "$68,864 ",
        "$59,379 ",
        "$55,654 ",
        "$58,193 ",
        "$56,110 ",
        "$67,166 ",
        "$56,903 ",
        "$72,133 ",
        "$46,973 ",
        "$63,387 ",
        "$52,949 ",
        "$57,981 ",
        "$66,446 ",
        "$60,715 ",
        "$59,412 ",
        "$62,677 ",
        "$62,940 ",
        "$55,400 ",
        "$56,667 ",
        "$66,827 ",
        "$60,657 ",
        "$59,514 ",
        "$67,006 ",
        "$67,683 ",
        "$67,537 ",
        "$51,581 ",
        "$67,630 ",
        "$53,277 ",
        "$67,033 ",
        "$60,867 ",
        "$60,358 ",
        "$63,153 ",
        "$57,757 ",
        "$58,636 ",
        "$60,625 ",
        "$44,231 ",
        "$64,379 ",
        "$66,058 ",
        "$62,991 ",
        "$55,966 ",
        "$63,659 ",
        "$66,688 ",
        "$59,235 ",
        "$54,286 ",
        "$54,185 ",
        "$66,471 ",
        "$62,449 ",
        "$66,233 ",
        "$59,160 ",
        "$54,688 ",
        "$64,422 ",
        "$64,822 ",
        "$64,360 ",
        "$62,835 ",
        "$60,493 ",
        "$57,422 ",
        "$59,716 ",
        "$66,352 ",
        "$61,910 ",
        "$60,125 ",
        "$54,606 ",
        "$62,090 ",
        "$64,341 ",
        "$61,403 ",
        "$58,930 ",
        "$58,047 ",
        "$60,757 ",
        "$55,978 ",
        "$66,755 ",
        "$66,164 ",
        "$57,348 ",
        "$56,849 ",
        "$66,694 ",
        "$63,064 ",
        "$60,550 ",
        "$58,521 ",
        "$60,616 ",
        "$57,267 ",
        "$57,858 ",
        "$61,196 ",
        "$58,125 ",
        "$55,971 ",
        "$52,454 ",
        "$61,094 ",
        "$55,606 ",
        "$56,684 ",
        "$65,214 ",
        "$60,166 ",
        "$67,995 ",
        "$64,978 ",
        "$63,438 ",
        "$50,684 ",
        "$55,970 ",
        "$56,341 ",
        "$63,632 ",
        "$56,269 ",
        "$63,096 ",
        "$63,418 ",
        "$71,259 ",
        "$60,725 ",
        "$55,744 ",
        "$46,534 ",
        "$56,830 ",
        "$63,730 ",
        "$57,049 ",
        "$57,868 ",
        "$62,139 ",
        "$64,414 ",
        "$52,635 ",
        "$56,016 ",
        "$64,567 ",
        "$51,469 ",
        "$59,345 ",
        "$54,971 ",
        "$67,076 ",
        "$69,450 ",
        "$50,250 ",
        "$59,941 ",
        "$58,150 ",
        "$64,116 ",
        "$62,512 ",
        "$70,556 ",
        "$56,414 ",
        "$57,234 ",
        "$63,355 ",
        "$51,539 ",
        "$56,150 ",
        "$67,949 ",
        "$62,971 ",
        "$61,671 ",
        "$50,151 ",
        "$54,247 ",
        "$60,741 ",
        "$59,926 ",
        "$53,569 ",
        "$58,565 ",
        "$60,951 ",
        "$55,114 ",
        "$53,194 ",
        "$63,082 ",
        "$56,062 ",
        "$55,267 ",
        "$64,196 ",
        "$56,911 ",
        "$48,132 ",
        "$57,161 ",
        "$63,665 ",
        "$61,366 ",
        "$51,986 ",
        "$55,321 ",
        "$60,309 ",
        "$63,939 ",
        "$62,298 ",
        "$56,185 ",
        "$59,862 ",
        "$61,420 ",
        "$56,136 ",
        "$61,149 ",
        "$53,909 ",
        "$53,342 ",
        "$56,960 ",
        "$62,438 ",
        "$58,592 ",
        "$56,004 ",
        "$57,827 ",
        "$53,333 ",
        "$68,822 ",
        "$46,875 ",
        "$64,923 ",
        "$66,349 ",
        "$75,527 ",
        "$52,276 ",
        "$55,940 ",
        "$57,292 ",
        "$61,483 ",
        "$57,699 ",
        "$61,448 ",
        "$68,533 ",
        "$61,696 ",
        "$63,014 ",
        "$61,599 ",
        "$52,014 ",
        "$60,427 ",
        "$53,328 ",
        "$58,305 ",
        "$57,583 ",
        "$66,895 ",
        "$58,135 ",
        "$51,953 ",
        "$56,887 ",
        "$57,236 ",
        "$55,625 ",
        "$58,708 ",
        "$57,295 ",
        "$53,823 ",
        "$58,654 ",
        "$62,753 ",
        "$58,536 ",
        "$56,474 ",
        "$60,290 ",
        "$57,595 ",
        "$61,563 ",
        "$60,234 ",
        "$60,271 ",
        "$64,694 ",
        "$57,381 ",
        "$69,696 ",
        "$57,444 ",
        "$51,852 ",
        "$63,982 ",
        "$70,566 ",
        "$63,548 ",
        "$52,473 ",
        "$62,802 ",
        "$53,237 ",
        "$65,155 ",
        "$53,254 ",
        "$58,352 ",
        "$53,125 ",
        "$58,770 ",
        "$53,813 ",
        "$58,697 ",
        "$55,484 ",
        "$55,408 ",
        "$62,224 ",
        "$51,779 ",
        "$64,836 ",
        "$67,067 ",
        "$55,586 ",
        "$57,115 ",
        "$60,754 ",
        "$56,823 ",
        "$62,514 ",
        "$52,823 ",
        "$54,765 ",
        "$67,259 ",
        "$55,434 ",
        "$55,164 ",
        "$63,712 ",
        "$62,284 ",
        "$55,582 ",
        "$61,495 ",
        "$57,545 ",
        "$49,362 ",
        "$57,459 ",
        "$55,689 ",
        "$55,089 ",
        "$65,250 ",
        "$61,861 ",
        "$58,289 ",
        "$59,067 ",
        "$39,234 ",
        "$56,605 ",
        "$60,814 ",
        "$58,992 ",
        "$64,375 ",
        "$57,137 ",
        "$65,417 ",
        "$64,611 ",
        "$58,479 ",
        "$58,451 ",
        "$54,237 ",
        "$56,410 ",
        "$53,572 ",
        "$52,727 ",
        "$59,406 ",
        "$58,866 ",
        "$54,609 ",
        "$67,668 ",
        "$61,494 ",
        "$59,373 ",
        "$60,526 ",
        "$59,384 ",
        "$64,758 ",
        "$58,883 ",
        "$50,938 ",
        "$59,509 ",
        "$55,735 ",
        "$58,533 ",
        "$56,071 ",
        "$53,578 ",
        "$52,417 ",
        "$58,608 ",
        "$63,807 ",
        "$60,501 ",
        "$60,417 ",
        "$58,835 ",
        "$61,412 ",
        "$60,120 ",
        "$42,368 ",
        "$63,675 ",
        "$56,705 ",
        "$61,400 ",
        "$57,615 ",
        "$56,869 ",
        "$54,167 ",
        "$41,862 ",
        "$53,647 ",
        "$60,397 ",
        "$60,939 ",
        "$58,299 ",
        "$58,207 ",
        "$65,696 ",
        "$56,324 ",
        "$58,934 ",
        "$57,313 ",
        "$51,252 ",
        "$53,709 ",
        "$53,835 ",
        "$60,356 ",
        "$54,224 ",
        "$66,664 ",
        "$56,300 ",
        "$54,118 ",
        "$53,086 ",
        "$48,833 ",
        "$57,703 ",
        "$60,954 ",
        "$60,852 ",
        "$47,206 ",
        "$52,729 ",
        "$60,080 ",
        "$56,066 ",
        "$58,594 ",
        "$60,597 ",
        "$49,753 ",
        "$58,884 ",
        "$56,155 ",
        "$50,919 ",
        "$55,295 ",
        "$58,357 ",
        "$59,561 ",
        "$54,762 ",
        "$55,446 ",
        "$57,643 ",
        "$57,050 ",
        "$55,182 ",
        "$53,250 ",
        "$65,479 ",
        "$60,772 ",
        "$64,576 ",
        "$50,725 ",
        "$54,619 ",
        "$55,909 ",
        "$46,000 ",
        "$50,956 ",
        "$53,912 ",
        "$60,073 ",
        "$59,108 ",
        "$51,103 ",
        "$46,831 ",
        "$65,922 ",
        "$54,952 ",
        "$55,652 ",
        "$51,701 ",
        "$61,103 ",
        "$59,173 ",
        "$56,626 ",
        "$55,917 ",
        "$55,610 ",
        "$58,543 ",
        "$61,559 ",
        "$65,591 ",
        "$56,425 ",
        "$55,102 ",
        "$57,946 ",
        "$53,029 ",
        "$55,536 ",
        "$51,702 ",
        "$60,155 ",
        "$61,841 ",
        "$57,604 ",
        "$56,125 ",
        "$59,064 ",
        "$55,378 ",
        "$53,807 ",
        "$65,220 ",
        "$54,679 ",
        "$53,902 ",
        "$55,394 ",
        "$54,700 ",
        "$57,722 ",
        "$56,552 ",
        "$59,103 ",
        "$71,343 ",
        "$63,086 ",
        "$54,402 ",
        "$62,459 ",
        "$56,917 ",
        "$56,427 ",
        "$53,571 ",
        "$54,483 ",
        "$54,222 ",
        "$56,198 ",
        "$60,995 ",
        "$55,063 ",
        "$58,547 ",
        "$51,399 ",
        "$63,938 ",
        "$52,300 ",
        "$58,295 ",
        "$64,930 ",
        "$59,252 ",
        "$55,668 ",
        "$58,918 ",
        "$58,910 ",
        "$57,038 ",
        "$55,120 ",
        "$54,242 ",
        "$57,129 ",
        "$63,378 ",
        "$54,941 ",
        "$46,015 ",
        "$49,080 ",
        "$53,713 ",
        "$62,627 ",
        "$56,810 ",
        "$53,495 ",
        "$49,245 ",
        "$54,708 ",
        "$57,662 ",
        "$52,974 ",
        "$53,740 ",
        "$53,359 ",
        "$49,600 ",
        "$55,673 ",
        "$56,861 ",
        "$61,629 ",
        "$56,389 ",
        "$57,046 ",
        "$54,485 ",
        "$57,784 ",
        "$55,505 ",
        "$63,243 ",
        "$55,060 ",
        "$54,697 ",
        "$59,593 ",
        "$51,882 ",
        "$52,742 ",
        "$59,972 ",
        "$58,441 ",
        "$61,433 ",
        "$61,851 ",
        "$55,081 ",
        "$55,382 ",
        "$58,656 ",
        "$58,034 ",
        "$67,948 ",
        "$62,062 ",
        "$55,976 ",
        "$55,028 ",
        "$46,010 ",
        "$63,048 ",
        "$56,923 ",
        "$60,296 ",
        "$51,190 ",
        "$51,838 ",
        "$60,121 ",
        "$59,308 ",
        "$54,770 ",
        "$56,167 ",
        "$56,897 ",
        "$58,898 ",
        "$53,854 ",
        "$57,530 ",
        "$56,069 ",
        "$51,601 ",
        "$58,486 ",
        "$54,367 ",
        "$61,426 ",
        "$48,486 ",
        "$54,255 ",
        "$61,250 ",
        "$54,827 ",
        "$53,353 ",
        "$49,059 ",
        "$58,831 ",
        "$52,214 ",
        "$54,364 ",
        "$59,462 ",
        "$54,459 ",
        "$54,936 ",
        "$48,879 ",
        "$50,334 ",
        "$54,519 ",
        "$48,547 ",
        "$57,202 ",
        "$58,583 ",
        "$54,190 ",
        "$56,889 ",
        "$49,200 ",
        "$59,600 ",
        "$61,088 ",
        "$59,691 ",
        "$58,808 ",
        "$53,650 ",
        "$51,199 ",
        "$57,647 ",
        "$54,596 ",
        "$56,168 ",
        "$56,750 ",
        "$53,822 ",
        "$50,511 ",
        "$49,568 ",
        "$53,463 ",
        "$49,044 ",
        "$60,786 ",
        "$45,633 ",
        "$48,275 ",
        "$56,346 ",
        "$56,188 ",
        "$61,238 ",
        "$50,719 ",
        "$60,134 ",
        "$48,963 ",
        "$49,138 ",
        "$48,388 ",
        "$47,847 ",
        "$53,945 ",
        "$53,259 ",
        "$51,250 ",
        "$48,013 ",
        "$61,226 ",
        "$56,565 ",
        "$53,632 ",
        "$52,466 ",
        "$51,957 ",
        "$60,886 ",
        "$54,513 ",
        "$52,446 ",
        "$64,329 ",
        "$59,391 ",
        "$48,450 ",
        "$57,357 ",
        "$60,974 ",
        "$62,642 ",
        "$61,219 ",
        "$56,090 ",
        "$53,072 ",
        "$55,325 ",
        "$55,675 ",
        "$56,074 ",
        "$54,219 ",
        "$57,196 ",
        "$51,944 ",
        "$48,894 ",
        "$54,191 ",
        "$60,737 ",
        "$59,729 ",
        "$57,079 ",
        "$43,627 ",
        "$50,137 ",
        "$43,160 ",
        "$57,834 ",
        "$49,942 ",
        "$62,959 ",
        "$56,512 ",
        "$49,517 ",
        "$40,691 ",
        "$59,112 ",
        "$56,974 ",
        "$55,380 ",
        "$51,402 ",
        "$57,160 ",
        "$58,750 ",
        "$52,857 ",
        "$50,629 ",
        "$61,676 ",
        "$49,034 ",
        "$49,565 ",
        "$57,866 ",
        "$57,391 ",
        "$54,423 ",
        "$63,634 ",
        "$55,401 ",
        "$63,182 ",
        "$56,225 ",
        "$51,599 ",
        "$50,855 ",
        "$55,208 ",
        "$53,995 ",
        "$55,348 ",
        "$52,514 ",
        "$47,349 ",
        "$58,937 ",
        "$55,848 ",
        "$48,310 ",
        "$57,885 ",
        "$54,746 ",
        "$57,440 ",
        "$52,816 ",
        "$52,681 ",
        "$51,875 ",
        "$53,810 ",
        "$54,284 ",
        "$50,674 ",
        "$57,726 ",
        "$54,294 ",
        "$51,272 ",
        "$56,620 ",
        "$58,115 ",
        "$50,999 ",
        "$57,957 ",
        "$52,614 ",
        "$58,674 ",
        "$48,250 ",
        "$53,598 ",
        "$47,404 ",
        "$55,943 ",
        "$56,561 ",
        "$60,249 ",
        "$48,333 ",
        "$55,776 ",
        "$55,605 ",
        "$67,898 ",
        "$56,634 ",
        "$52,813 ",
        "$54,196 ",
        "$63,929 ",
        "$57,364 ",
        "$58,566 ",
        "$46,601 ",
        "$47,327 ",
        "$54,149 ",
        "$55,558 ",
        "$45,616 ",
        "$57,067 ",
        "$52,800 ",
        "$54,654 ",
        "$55,554 ",
        "$58,462 ",
        "$55,053 ",
        "$55,802 ",
        "$50,372 ",
        "$45,424 ",
        "$58,225 ",
        "$56,042 ",
        "$53,971 ",
        "$55,000 ",
        "$48,708 ",
        "$49,708 ",
        "$60,101 ",
        "$62,490 ",
        "$51,694 ",
        "$56,290 ",
        "$58,504 ",
        "$54,461 ",
        "$56,132 ",
        "$51,973 ",
        "$57,070 ",
        "$53,218 ",
        "$51,941 ",
        "$51,087 ",
        "$57,684 ",
        "$54,630 ",
        "$51,851 ",
        "$51,540 ",
        "$55,274 ",
        "$52,593 ",
        "$58,922 ",
        "$61,660 ",
        "$47,542 ",
        "$53,192 ",
        "$52,998 ",
        "$55,034 ",
        "$55,188 ",
        "$57,263 ",
        "$49,894 ",
        "$59,331 ",
        "$44,650 ",
        "$59,900 ",
        "$54,061 ",
        "$56,802 ",
        "$56,297 ",
        "$53,975 ",
        "$50,755 ",
        "$44,859 ",
        "$54,218 ",
        "$57,472 ",
        "$50,365 ",
        "$53,355 ",
        "$54,060 ",
        "$60,388 ",
        "$62,500 ",
        "$53,929 ",
        "$59,364 ",
        "$52,234 ",
        "$62,033 ",
        "$53,502 ",
        "$60,006 ",
        "$58,447 ",
        "$55,587 ",
        "$52,280 ",
        "$53,489 ",
        "$55,665 ",
        "$51,235 ",
        "$52,127 ",
        "$62,389 ",
        "$52,846 ",
        "$58,038 ",
        "$51,660 ",
        "$51,472 ",
        "$61,952 ",
        "$59,684 ",
        "$58,463 ",
        "$48,711 ",
        "$59,156 ",
        "$49,907 ",
        "$50,344 ",
        "$53,847 ",
        "$57,009 ",
        "$54,460 ",
        "$52,738 ",
        "$57,117 ",
        "$52,232 ",
        "$46,932 ",
        "$54,389 ",
        "$54,240 ",
        "$49,682 ",
        "$55,339 ",
        "$54,004 ",
        "$55,101 ",
        "$50,565 ",
        "$48,156 ",
        "$49,566 ",
        "$52,398 ",
        "$51,183 ",
        "$60,899 ",
        "$44,058 ",
        "$56,215 ",
        "$48,080 ",
        "$51,724 ",
        "$52,423 ",
        "$53,680 ",
        "$52,235 ",
        "$54,842 ",
        "$54,846 ",
        "$47,183 ",
        "$60,735 ",
        "$53,288 ",
        "$52,000 ",
        "$46,375 ",
        "$52,953 ",
        "$57,375 ",
        "$50,864 ",
        "$55,763 ",
        "$53,401 ",
        "$56,337 ",
        "$53,871 ",
        "$52,698 ",
        "$58,031 ",
        "$66,201 ",
        "$49,654 ",
        "$56,354 ",
        "$50,069 ",
        "$54,323 ",
        "$50,704 ",
        "$47,830 ",
        "$48,836 ",
        "$54,728 ",
        "$60,188 ",
        "$48,375 ",
        "$46,816 ",
        "$58,660 ",
        "$48,886 ",
        "$53,627 ",
        "$51,772 ",
        "$50,266 ",
        "$42,729 ",
        "$53,346 ",
        "$51,949 ",
        "$54,418 ",
        "$61,309 ",
        "$54,492 ",
        "$53,089 ",
        "$52,567 ",
        "$52,854 ",
        "$54,589 ",
        "$47,585 ",
        "$52,661 ",
        "$47,736 ",
        "$48,283 ",
        "$51,705 ",
        "$54,962 ",
        "$51,596 ",
        "$52,447 ",
        "$51,092 ",
        "$55,125 ",
        "$50,996 ",
        "$54,664 ",
        "$54,395 ",
        "$52,496 ",
        "$49,904 ",
        "$50,251 ",
        "$53,856 ",
        "$46,528 ",
        "$48,116 ",
        "$57,174 ",
        "$51,458 ",
        "$57,713 ",
        "$59,074 ",
        "$51,925 ",
        "$59,022 ",
        "$51,282 ",
        "$47,537 ",
        "$49,714 ",
        "$52,637 ",
        "$55,256 ",
        "$50,840 ",
        "$45,265 ",
        "$54,432 ",
        "$53,746 ",
        "$45,998 ",
        "$54,413 ",
        "$55,331 ",
        "$54,440 ",
        "$54,920 ",
        "$48,789 ",
        "$46,538 ",
        "$54,093 ",
        "$50,429 ",
        "$52,410 ",
        "$61,002 ",
        "$60,224 ",
        "$53,465 ",
        "$50,907 ",
        "$57,326 ",
        "$56,202 ",
        "$48,308 ",
        "$55,018 ",
        "$55,233 ",
        "$42,159 ",
        "$55,342 ",
        "$52,705 ",
        "$58,977 ",
        "$57,613 ",
        "$53,602 ",
        "$57,078 ",
        "$54,725 ",
        "$53,557 ",
        "$51,707 ",
        "$50,992 ",
        "$56,271 ",
        "$52,844 ",
        "$57,961 ",
        "$49,816 ",
        "$54,945 ",
        "$57,363 ",
        "$52,662 ",
        "$53,457 ",
        "$52,408 ",
        "$55,818 ",
        "$53,246 ",
        "$48,420 ",
        "$49,145 ",
        "$43,795 ",
        "$57,538 ",
        "$51,692 ",
        "$44,605 ",
        "$45,798 ",
        "$49,936 ",
        "$53,887 ",
        "$52,579 ",
        "$46,587 ",
        "$52,948 ",
        "$55,745 ",
        "$45,917 ",
        "$50,969 ",
        "$51,120 ",
        "$54,652 ",
        "$54,292 ",
        "$59,910 ",
        "$51,449 ",
        "$46,913 ",
        "$52,336 ",
        "$47,159 ",
        "$47,297 ",
        "$52,918 ",
        "$58,006 ",
        "$55,603 ",
        "$53,099 ",
        "$54,327 ",
        "$50,111 ",
        "$49,527 ",
        "$54,472 ",
        "$75,613 ",
        "$62,898 ",
        "$58,863 ",
        "$48,487 ",
        "$44,111 ",
        "$50,948 ",
        "$48,008 ",
        "$58,869 ",
        "$50,753 ",
        "$55,768 ",
        "$50,830 ",
        "$52,201 ",
        "$55,432 ",
        "$53,085 ",
        "$54,696 ",
        "$49,622 ",
        "$50,351 ",
        "$55,414 ",
        "$49,308 ",
        "$49,574 ",
        "$56,111 ",
        "$54,701 ",
        "$54,315 ",
        "$53,549 ",
        "$53,828 ",
        "$52,124 ",
        "$44,208 ",
        "$51,142 ",
        "$46,847 ",
        "$47,023 ",
        "$46,040 ",
        "$47,682 ",
        "$53,963 ",
        "$44,986 ",
        "$52,071 ",
        "$54,399 ",
        "$53,267 ",
        "$56,868 ",
        "$50,924 ",
        "$50,779 ",
        "$51,391 ",
        "$42,978 ",
        "$57,960 ",
        "$58,641 ",
        "$51,398 ",
        "$51,734 ",
        "$49,351 ",
        "$48,323 ",
        "$53,500 ",
        "$53,946 ",
        "$56,139 ",
        "$54,074 ",
        "$52,922 ",
        "$52,735 ",
        "$50,222 ",
        "$59,037 ",
        "$53,091 ",
        "$55,169 ",
        "$47,667 ",
        "$42,917 ",
        "$46,502 ",
        "$56,089 ",
        "$50,114 ",
        "$56,752 ",
        "$48,896 ",
        "$46,632 ",
        "$47,067 ",
        "$56,113 ",
        "$54,036 ",
        "$53,186 ",
        "$49,718 ",
        "$52,415 ",
        "$46,154 ",
        "$57,826 ",
        "$55,881 ",
        "$50,524 ",
        "$52,128 ",
        "$56,721 ",
        "$62,765 ",
        "$50,076 ",
        "$46,024 ",
        "$49,920 ",
        "$50,676 ",
        "$46,839 ",
        "$51,177 ",
        "$49,968 ",
        "$53,869 ",
        "$48,461 ",
        "$51,712 ",
        "$46,432 ",
        "$51,353 ",
        "$49,631 ",
        "$51,718 ",
        "$55,545 ",
        "$59,882 ",
        "$47,100 ",
        "$58,892 ",
        "$55,617 ",
        "$48,083 ",
        "$50,107 ",
        "$54,591 ",
        "$45,080 ",
        "$52,347 ",
        "$46,954 ",
        "$49,542 ",
        "$48,903 ",
        "$55,105 ",
        "$56,540 ",
        "$45,499 ",
        "$44,541 ",
        "$59,294 ",
        "$52,583 ",
        "$51,503 ",
        "$44,624 ",
        "$48,754 ",
        "$50,910 ",
        "$52,836 ",
        "$51,451 ",
        "$49,194 ",
        "$49,521 ",
        "$50,944 ",
        "$47,330 ",
        "$51,031 ",
        "$53,101 ",
        "$50,162 ",
        "$57,715 ",
        "$50,963 ",
        "$47,745 ",
        "$49,860 ",
        "$45,221 ",
        "$48,865 ",
        "$54,942 ",
        "$47,724 ",
        "$56,131 ",
        "$45,048 ",
        "$54,022 ",
        "$47,037 ",
        "$63,713 ",
        "$51,674 ",
        "$52,204 ",
        "$45,765 ",
        "$46,268 ",
        "$52,203 ",
        "$53,577 ",
        "$51,029 ",
        "$54,279 ",
        "$52,184 ",
        "$44,653 ",
        "$54,015 ",
        "$48,918 ",
        "$49,915 ",
        "$52,301 ",
        "$43,611 ",
        "$62,952 ",
        "$55,547 ",
        "$49,677 ",
        "$44,129 ",
        "$44,271 ",
        "$49,154 ",
        "$47,587 ",
        "$48,417 ",
        "$53,154 ",
        "$45,708 ",
        "$47,715 ",
        "$39,241 ",
        "$49,819 ",
        "$48,301 ",
        "$47,807 ",
        "$53,840 ",
        "$50,469 ",
        "$52,456 ",
        "$55,431 ",
        "$52,837 ",
        "$48,739 ",
        "$44,902 ",
        "$56,223 ",
        "$49,681 ",
        "$48,568 ",
        "$54,663 ",
        "$47,825 ",
        "$51,067 ",
        "$48,314 ",
        "$47,396 ",
        "$49,891 ",
        "$52,112 ",
        "$50,936 ",
        "$47,796 ",
        "$48,662 ",
        "$44,073 ",
        "$55,508 ",
        "$51,656 ",
        "$57,732 ",
        "$45,024 ",
        "$55,526 ",
        "$50,537 ",
        "$55,282 ",
        "$56,826 ",
        "$46,784 ",
        "$49,238 ",
        "$50,574 ",
        "$49,290 ",
        "$47,557 ",
        "$45,000 ",
        "$49,664 ",
        "$57,330 ",
        "$68,487 ",
        "$56,881 ",
        "$50,683 ",
        "$42,540 ",
        "$56,933 ",
        "$51,500 ",
        "$49,643 ",
        "$51,591 ",
        "$48,618 ",
        "$47,184 ",
        "$46,776 ",
        "$57,434 ",
        "$47,136 ",
        "$50,851 ",
        "$48,705 ",
        "$45,117 ",
        "$47,936 ",
        "$48,222 ",
        "$48,958 ",
        "$48,756 ",
        "$50,977 ",
        "$65,542 ",
        "$51,319 ",
        "$47,103 ",
        "$53,025 ",
        "$53,879 ",
        "$50,693 ",
        "$41,551 ",
        "$54,961 ",
        "$51,921 ",
        "$42,366 ",
        "$47,539 ",
        "$52,996 ",
        "$41,154 ",
        "$54,583 ",
        "$46,952 ",
        "$50,648 ",
        "$47,671 ",
        "$52,092 ",
        "$46,245 ",
        "$50,560 ",
        "$50,202 ",
        "$49,713 ",
        "$50,653 ",
        "$44,363 ",
        "$52,652 ",
        "$46,066 ",
        "$49,975 ",
        "$49,157 ",
        "$41,667 ",
        "$42,909 ",
        "$46,669 ",
        "$51,790 ",
        "$51,206 ",
        "$53,882 ",
        "$50,181 ",
        "$47,576 ",
        "$44,401 ",
        "$50,092 ",
        "$49,107 ",
        "$45,821 ",
        "$47,986 ",
        "$45,108 ",
        "$61,750 ",
        "$40,245 ",
        "$50,795 ",
        "$61,713 ",
        "$52,749 ",
        "$53,558 ",
        "$48,790 ",
        "$52,116 ",
        "$45,347 ",
        "$48,796 ",
        "$64,292 ",
        "$50,330 ",
        "$41,794 ",
        "$50,128 ",
        "$52,130 ",
        "$47,750 ",
        "$52,697 ",
        "$48,818 ",
        "$46,486 ",
        "$47,403 ",
        "$50,234 ",
        "$47,920 ",
        "$48,074 ",
        "$49,685 ",
        "$54,611 ",
        "$46,628 ",
        "$50,563 ",
        "$57,399 ",
        "$52,030 ",
        "$47,768 ",
        "$47,380 ",
        "$48,435 ",
        "$45,688 ",
        "$51,207 ",
        "$47,588 ",
        "$48,164 ",
        "$47,551 ",
        "$45,551 ",
        "$47,132 ",
        "$50,123 ",
        "$49,018 ",
        "$45,434 ",
        "$51,887 ",
        "$46,690 ",
        "$45,707 ",
        "$47,987 ",
        "$50,376 ",
        "$48,376 ",
        "$43,822 ",
        "$44,751 ",
        "$47,214 ",
        "$48,952 ",
        "$49,976 ",
        "$45,604 ",
        "$43,975 ",
        "$47,473 ",
        "$45,605 ",
        "$61,761 ",
        "$49,328 ",
        "$50,952 ",
        "$50,394 ",
        "$48,603 ",
        "$52,392 ",
        "$54,448 ",
        "$46,207 ",
        "$44,849 ",
        "$53,116 ",
        "$46,570 ",
        "$50,354 ",
        "$47,493 ",
        "$48,478 ",
        "$45,876 ",
        "$45,310 ",
        "$43,500 ",
        "$51,196 ",
        "$45,087 ",
        "$54,000 ",
        "$51,172 ",
        "$56,398 ",
        "$47,446 ",
        "$52,618 ",
        "$46,707 ",
        "$44,442 ",
        "$45,275 ",
        "$47,604 ",
        "$50,288 ",
        "$46,076 ",
        "$47,078 ",
        "$48,153 ",
        "$45,693 ",
        "$44,842 ",
        "$49,267 ",
        "$49,398 ",
        "$49,872 ",
        "$58,160 ",
        "$58,525 ",
        "$51,519 ",
        "$45,546 ",
        "$51,561 ",
        "$46,764 ",
        "$44,788 ",
        "$53,793 ",
        "$50,884 ",
        "$54,829 ",
        "$47,259 ",
        "$44,152 ",
        "$55,210 ",
        "$43,481 ",
        "$41,110 ",
        "$53,016 ",
        "$51,667 ",
        "$40,917 ",
        "$46,202 ",
        "$54,721 ",
        "$49,087 ",
        "$56,345 ",
        "$45,742 ",
        "$46,594 ",
        "$59,397 ",
        "$44,029 ",
        "$52,482 ",
        "$53,214 ",
        "$60,948 ",
        "$41,225 ",
        "$51,657 ",
        "$46,150 ",
        "$49,041 ",
        "$47,101 ",
        "$57,220 ",
        "$42,866 ",
        "$46,476 ",
        "$48,723 ",
        "$49,468 ",
        "$50,393 ",
        "$42,164 ",
        "$45,989 ",
        "$49,808 ",
        "$54,058 ",
        "$46,002 ",
        "$45,479 ",
        "$44,175 ",
        "$33,897 ",
        "$48,689 ",
        "$47,363 ",
        "$50,218 ",
        "$44,874 ",
        "$47,747 ",
        "$47,011 ",
        "$57,380 ",
        "$47,436 ",
        "$42,835 ",
        "$59,266 ",
        "$44,627 ",
        "$45,865 ",
        "$39,876 ",
        "$58,661 ",
        "$50,033 ",
        "$50,701 ",
        "$50,554 ",
        "$65,616 ",
        "$48,174 ",
        "$43,075 ",
        "$47,074 ",
        "$54,529 ",
        "$50,761 ",
        "$46,159 ",
        "$49,806 ",
        "$47,700 ",
        "$40,875 ",
        "$48,406 ",
        "$46,828 ",
        "$44,390 ",
        "$44,436 ",
        "$48,251 ",
        "$45,764 ",
        "$46,243 ",
        "$45,331 ",
        "$48,125 ",
        "$58,850 ",
        "$43,284 ",
        "$48,661 ",
        "$48,578 ",
        "$45,076 ",
        "$51,866 ",
        "$45,750 ",
        "$39,937 ",
        "$55,748 ",
        "$50,231 ",
        "$43,400 ",
        "$47,075 ",
        "$49,077 ",
        "$51,106 ",
        "$48,910 ",
        "$52,409 ",
        "$39,580 ",
        "$46,205 ",
        "$45,583 ",
        "$53,653 ",
        "$45,612 ",
        "$45,306 ",
        "$48,720 ",
        "$44,301 ",
        "$44,888 ",
        "$48,576 ",
        "$54,581 ",
        "$52,848 ",
        "$49,342 ",
        "$46,827 ",
        "$43,459 ",
        "$48,014 ",
        "$44,705 ",
        "$46,083 ",
        "$42,896 ",
        "$53,689 ",
        "$46,574 ",
        "$41,429 ",
        "$49,064 ",
        "$40,595 ",
        "$49,127 ",
        "$53,564 ",
        "$42,730 ",
        "$41,058 ",
        "$51,289 ",
        "$48,372 ",
        "$42,632 ",
        "$48,011 ",
        "$44,907 ",
        "$44,610 ",
        "$42,137 ",
        "$52,144 ",
        "$51,589 ",
        "$40,768 ",
        "$51,686 ",
        "$45,162 ",
        "$50,559 ",
        "$56,195 ",
        "$49,733 ",
        "$43,780 ",
        "$47,769 ",
        "$51,748 ",
        "$41,733 ",
        "$41,572 ",
        "$44,518 ",
        "$43,826 ",
        "$42,636 ",
        "$50,628 ",
        "$43,922 ",
        "$47,000 ",
        "$43,888 ",
        "$47,781 ",
        "$40,767 ",
        "$57,710 ",
        "$49,740 ",
        "$45,690 ",
        "$45,728 ",
        "$46,749 ",
        "$48,169 ",
        "$47,663 ",
        "$49,889 ",
        "$51,356 ",
        "$47,637 ",
        "$43,557 ",
        "$46,113 ",
        "$51,964 ",
        "$45,273 ",
        "$44,691 ",
        "$45,143 ",
        "$40,590 ",
        "$59,253 ",
        "$41,019 ",
        "$41,981 ",
        "$47,303 ",
        "$47,472 ",
        "$49,280 ",
        "$53,932 ",
        "$48,946 ",
        "$52,500 ",
        "$46,281 ",
        "$56,184 ",
        "$46,282 ",
        "$43,074 ",
        "$44,755 ",
        "$47,672 ",
        "$44,309 ",
        "$45,208 ",
        "$45,574 ",
        "$39,659 ",
        "$44,911 ",
        "$43,349 ",
        "$48,828 ",
        "$37,119 ",
        "$56,459 ",
        "$51,922 ",
        "$50,325 ",
        "$48,562 ",
        "$49,121 ",
        "$42,210 ",
        "$46,643 ",
        "$42,588 ",
        "$48,274 ",
        "$41,720 ",
        "$49,043 ",
        "$45,003 ",
        "$47,096 ",
        "$45,490 ",
        "$47,774 ",
        "$50,744 ",
        "$46,549 ",
        "$41,040 ",
        "$49,541 ",
        "$44,783 ",
        "$44,772 ",
        "$45,503 ",
        "$48,694 ",
        "$43,135 ",
        "$43,512 ",
        "$47,376 ",
        "$42,775 ",
        "$44,210 ",
        "$39,650 ",
        "$48,810 ",
        "$45,781 ",
        "$44,962 ",
        "$51,998 ",
        "$40,855 ",
        "$43,210 ",
        "$44,778 ",
        "$43,320 ",
        "$47,378 ",
        "$45,625 ",
        "$47,649 ",
        "$43,053 ",
        "$38,275 ",
        "$53,997 ",
        "$41,216 ",
        "$46,069 ",
        "$44,069 ",
        "$44,470 ",
        "$46,557 ",
        "$36,902 ",
        "$49,378 ",
        "$41,943 ",
        "$51,470 ",
        "$51,563 ",
        "$47,950 ",
        "$44,587 ",
        "$46,489 ",
        "$40,847 ",
        "$52,391 ",
        "$41,390 ",
        "$43,097 ",
        "$51,780 ",
        "$42,083 ",
        "$42,470 ",
        "$39,469 ",
        "$48,984 ",
        "$47,832 ",
        "$41,010 ",
        "$52,529 ",
        "$42,371 ",
        "$47,839 ",
        "$46,731 ",
        "$44,200 ",
        "$45,593 ",
        "$46,369 ",
        "$41,113 ",
        "$47,419 ",
        "$45,518 ",
        "$42,354 ",
        "$39,465 ",
        "$47,435 ",
        "$37,887 ",
        "$49,381 ",
        "$42,379 ",
        "$42,271 ",
        "$47,025 ",
        "$48,623 ",
        "$46,526 ",
        "$44,481 ",
        "$40,559 ",
        "$42,333 ",
        "$41,712 ",
        "$45,874 ",
        "$38,502 ",
        "$46,802 ",
        "$48,610 ",
        "$42,286 ",
        "$43,317 ",
        "$49,499 ",
        "$46,474 ",
        "$46,536 ",
        "$45,492 ",
        "$47,360 ",
        "$43,038 ",
        "$44,720 ",
        "$43,818 ",
        "$42,547 ",
        "$48,306 ",
        "$43,146 ",
        "$46,275 ",
        "$46,455 ",
        "$44,302 ",
        "$50,893 ",
        "$41,387 ",
        "$40,000 ",
        "$43,597 ",
        "$41,025 ",
        "$52,983 ",
        "$38,048 ",
        "$46,797 ",
        "$49,741 ",
        "$46,250 ",
        "$44,633 ",
        "$42,607 ",
        "$43,636 ",
        "$41,716 ",
        "$45,950 ",
        "$50,796 ",
        "$43,384 ",
        "$37,827 ",
        "$53,584 ",
        "$46,311 ",
        "$43,373 ",
        "$46,360 ",
        "$45,304 ",
        "$44,343 ",
        "$45,647 ",
        "$39,966 ",
        "$46,442 ",
        "$43,094 ",
        "$40,970 ",
        "$48,100 ",
        "$42,500 ",
        "$41,014 ",
        "$43,598 ",
        "$41,449 ",
        "$42,182 ",
        "$45,409 ",
        "$45,070 ",
        "$43,693 ",
        "$52,627 ",
        "$46,591 ",
        "$43,884 ",
        "$44,933 ",
        "$43,935 ",
        "$48,719 ",
        "$38,145 ",
        "$39,274 ",
        "$42,436 ",
        "$52,100 ",
        "$42,766 ",
        "$49,379 ",
        "$36,597 ",
        "$50,491 ",
        "$50,403 ",
        "$46,454 ",
        "$48,115 ",
        "$46,972 ",
        "$44,411 ",
        "$44,574 ",
        "$46,537 ",
        "$42,356 ",
        "$38,834 ",
        "$44,637 ",
        "$41,121 ",
        "$48,906 ",
        "$40,589 ",
        "$53,224 ",
        "$52,077 ",
        "$44,034 ",
        "$46,777 ",
        "$41,358 ",
        "$48,350 ",
        "$42,293 ",
        "$39,526 ",
        "$49,429 ",
        "$39,632 ",
        "$43,684 ",
        "$50,781 ",
        "$43,716 ",
        "$50,489 ",
        "$41,545 ",
        "$41,356 ",
        "$44,985 ",
        "$42,048 ",
        "$37,432 ",
        "$42,800 ",
        "$47,683 ",
        "$44,619 ",
        "$47,602 ",
        "$40,802 ",
        "$37,440 ",
        "$45,093 ",
        "$40,783 ",
        "$43,587 ",
        "$43,178 ",
        "$40,949 ",
        "$48,675 ",
        "$44,106 ",
        "$45,351 ",
        "$42,751 ",
        "$45,769 ",
        "$44,651 ",
        "$41,278 ",
        "$39,169 ",
        "$44,973 ",
        "$41,250 ",
        "$40,597 ",
        "$43,439 ",
        "$43,771 ",
        "$45,934 ",
        "$40,814 ",
        "$41,314 ",
        "$50,125 ",
        "$42,357 ",
        "$42,934 ",
        "$41,288 ",
        "$47,456 ",
        "$38,843 ",
        "$45,361 ",
        "$40,821 ",
        "$45,269 ",
        "$44,382 ",
        "$45,213 ",
        "$40,297 ",
        "$44,408 ",
        "$43,408 ",
        "$45,314 ",
        "$47,211 ",
        "$42,828 ",
        "$38,941 ",
        "$50,116 ",
        "$57,207 ",
        "$45,142 ",
        "$44,076 ",
        "$46,870 ",
        "$41,674 ",
        "$45,839 ",
        "$42,089 ",
        "$35,914 ",
        "$56,449 ",
        "$37,218 ",
        "$41,849 ",
        "$41,518 ",
        "$42,523 ",
        "$40,517 ",
        "$41,920 ",
        "$39,717 ",
        "$45,487 ",
        "$41,022 ",
        "$45,678 ",
        "$40,311 ",
        "$45,971 ",
        "$38,503 ",
        "$49,279 ",
        "$44,338 ",
        "$44,018 ",
        "$41,319 ",
        "$43,590 ",
        "$45,925 ",
        "$42,466 ",
        "$48,735 ",
        "$35,901 ",
        "$45,355 ",
        "$34,786 ",
        "$41,304 ",
        "$41,071 ",
        "$38,438 ",
        "$40,284 ",
        "$44,510 ",
        "$37,249 ",
        "$41,930 ",
        "$45,500 ",
        "$44,104 ",
        "$37,243 ",
        "$34,030 ",
        "$45,110 ",
        "$43,138 ",
        "$44,395 ",
        "$49,852 ",
        "$45,212 ",
        "$45,452 ",
        "$41,713 ",
        "$48,238 ",
        "$50,772 ",
        "$51,241 ",
        "$45,615 ",
        "$41,653 ",
        "$49,829 ",
        "$42,792 ",
        "$51,608 ",
        "$43,119 ",
        "$48,257 ",
        "$44,638 ",
        "$47,302 ",
        "$40,147 ",
        "$40,786 ",
        "$42,415 ",
        "$49,562 ",
        "$42,011 ",
        "$41,963 ",
        "$45,831 ",
        "$37,838 ",
        "$41,108 ",
        "$37,620 ",
        "$42,038 ",
        "$45,837 ",
        "$42,577 ",
        "$51,946 ",
        "$40,172 ",
        "$41,774 ",
        "$48,750 ",
        "$38,173 ",
        "$41,875 ",
        "$56,044 ",
        "$50,314 ",
        "$40,224 ",
        "$34,176 ",
        "$47,844 ",
        "$40,732 ",
        "$35,490 ",
        "$36,044 ",
        "$47,763 ",
        "$48,028 ",
        "$44,403 ",
        "$45,757 ",
        "$39,539 ",
        "$45,172 ",
        "$38,734 ",
        "$41,173 ",
        "$49,229 ",
        "$42,703 ",
        "$39,065 ",
        "$41,797 ",
        "$43,004 ",
        "$40,717 ",
        "$43,121 ",
        "$44,595 ",
        "$41,181 ",
        "$38,500 ",
        "$39,665 ",
        "$45,152 ",
        "$43,407 ",
        "$43,458 ",
        "$45,463 ",
        "$36,457 ",
        "$42,070 ",
        "$38,920 ",
        "$42,242 ",
        "$43,594 ",
        "$43,622 ",
        "$39,718 ",
        "$42,359 ",
        "$43,465 ",
        "$51,739 ",
        "$38,063 ",
        "$42,657 ",
        "$40,322 ",
        "$44,025 ",
        "$37,938 ",
        "$39,661 ",
        "$38,913 ",
        "$48,282 ",
        "$41,270 ",
        "$40,267 ",
        "$46,585 ",
        "$53,295 ",
        "$35,328 ",
        "$40,943 ",
        "$50,583 ",
        "$48,786 ",
        "$50,522 ",
        "$38,728 ",
        "$41,164 ",
        "$40,989 ",
        "$42,029 ",
        "$35,842 ",
        "$39,534 ",
        "$37,256 ",
        "$49,612 ",
        "$50,091 ",
        "$40,850 ",
        "$47,044 ",
        "$53,588 ",
        "$35,017 ",
        "$37,388 ",
        "$39,884 ",
        "$42,684 ",
        "$39,502 ",
        "$41,964 ",
        "$38,765 ",
        "$46,696 ",
        "$42,307 ",
        "$38,993 ",
        "$41,469 ",
        "$36,277 ",
        "$42,351 ",
        "$50,179 ",
        "$48,121 ",
        "$35,422 ",
        "$41,975 ",
        "$39,616 ",
        "$41,038 ",
        "$49,649 ",
        "$38,152 ",
        "$36,659 ",
        "$41,440 ",
        "$42,959 ",
        "$50,229 ",
        "$45,713 ",
        "$39,681 ",
        "$38,007 ",
        "$34,684 ",
        "$43,462 ",
        "$41,233 ",
        "$39,284 ",
        "$43,634 ",
        "$31,364 ",
        "$39,404 ",
        "$45,200 ",
        "$42,594 ",
        "$38,766 ",
        "$45,540 ",
        "$39,667 ",
        "$53,413 ",
        "$42,629 ",
        "$39,444 ",
        "$40,550 ",
        "$45,375 ",
        "$39,570 ",
        "$36,783 ",
        "$37,267 ",
        "$33,025 ",
        "$40,704 ",
        "$38,493 ",
        "$39,949 ",
        "$57,163 ",
        "$43,516 ",
        "$42,093 ",
        "$53,520 ",
        "$36,550 ",
        "$34,451 ",
        "$38,974 ",
        "$47,756 ",
        "$43,452 ",
        "$43,216 ",
        "$36,866 ",
        "$36,443 ",
        "$42,933 ",
        "$37,837 ",
        "$44,811 ",
        "$36,327 ",
        "$38,125 ",
        "$37,796 ",
        "$37,009 ",
        "$38,312 ",
        "$36,059 ",
        "$47,517 ",
        "$36,823 ",
        "$38,058 ",
        "$45,825 ",
        "$36,791 ",
        "$55,377 ",
        "$46,295 ",
        "$40,282 ",
        "$52,230 ",
        "$33,791 ",
        "$41,116 ",
        "$43,793 ",
        "$34,986 ",
        "$37,664 ",
        "$57,450 ",
        "$56,979 ",
        "$36,559 ",
        "$41,707 ",
        "$40,657 ",
        "$40,119 ",
        "$42,024 ",
        "$35,762 ",
        "$45,838 ",
        "$40,623 ",
        "$44,267 ",
        "$37,317 ",
        "$42,457 ",
        "$37,441 ",
        "$34,500 ",
        "$37,118 ",
        "$53,022 ",
        "$29,749 ",
        "$38,823 ",
        "$41,818 ",
        "$36,023 ",
        "$38,356 ",
        "$36,807 ",
        "$39,993 ",
        "$31,078 ",
        "$38,759 ",
        "$46,968 ",
        "$41,477 ",
        "$35,507 ",
        "$36,073 ",
        "$38,639 ",
        "$31,966 ",
        "$36,701 ",
        "$41,516 ",
        "$37,277 ",
        "$38,789 ",
        "$34,946 ",
        "$40,486 ",
        "$31,922 ",
        "$37,395 ",
        "$34,705 ",
        "$38,763 ",
        "$34,042 ",
        "$46,615 ",
        "$44,980 ",
        "$40,872 ",
        "$35,861 ",
        "$47,204 ",
        "$39,010 ",
        "$37,385 ",
        "$49,303 ",
        "$34,600 ",
        "$39,019 ",
        "$31,816 ",
        "$38,565 ",
        "$42,598 ",
        "$40,936 ",
        "$33,952 ",
        "$41,966 ",
        "$31,809 ",
        "$39,514 ",
        "$39,346 ",
        "$51,219 ",
        "$34,739 ",
        "$37,295 ",
        "$36,935 ",
        "$37,321 ",
        "$36,332 ",
        "$28,825 ",
        "$39,384 ",
        "$31,440 ",
        "$41,410 ",
        "$38,617 ",
        "$47,109 ",
        "$36,500 ",
        "$32,879 ",
        "$28,558 ",
        "$30,776 ",
        "$30,285 ",
        "$33,157 ",
        "$37,250 ",
        "$36,884 ",
        "$35,307 ",
        "$33,333 ",
        "$36,435 ",
        "$30,407 ",
        "$35,594 ",
        "$48,269 ",
        "$25,304 ",
        "$30,671 ",
        "$33,786 ",
        "$30,036 ",
        "$28,171 ",
        "$37,668 ",
        "$40,962 ",
        "$26,488 ",
        "$32,108 ",
        "$34,762 ",
        "$45,120 ",
        "$33,977 ",
        "$29,973 ",
        "$48,365 ",
        "$33,063 ",
        "$30,085 ",
        "$26,739 ",
        "$30,276 ",
        "$36,632 ",
        "$32,566 ",
        "$38,627 ",
        "$28,352 ",
        "$28,816 ",
        "$32,930 ",
        "$34,375 ",
        "$37,539 ",
        "$32,793 ",
        "$37,095 ",
        "$36,109 ",
        "$31,893 ",
        "$32,986 ",
        "$33,608 ",
        "$35,795 ",
        "$32,273 ",
        "$31,385 ",
        "$25,995 ",
        "$30,840 ",
        "$36,926 ",
        "$30,543 ",
        "$27,552 ",
        "$31,301 ",
        "$31,592 ",
        "$40,750 ",
        "$32,671 ",
        "$31,556 ",
        "$26,029 "
      ]
    },
    {
      "datamart_id": 7,
      "semantic_type": [],
      "name": "Population",
      "description": "column name: Population, dtype: object",
      "named_entity": [
        "1,605,272",
        "214,861",
        "12,731",
        "254,643",
        "143,684",
        "17,173",
        "17,979",
        "1,101,071",
        "127,047",
        "649",
        "989,474",
        "495,261",
        "926,233",
        "817,501",
        "293,821",
        "956,283",
        "326,207",
        "10,224",
        "326,477",
        "9,484",
        "729,543",
        "71",
        "619,371",
        "21,565",
        "677,296",
        "23,027",
        "293,014",
        "21,575",
        "912,795",
        "1,522,533",
        "629,735",
        "37,232",
        "1,343,765",
        "761",
        "503,075",
        "86,708",
        "9,048",
        "1,812,208",
        "804,621",
        "188,935",
        "7,496",
        "544,426",
        "99,718",
        "82,545",
        "178,139",
        "165,690",
        "1,974,567",
        "66,015",
        "282,977",
        "52,151",
        "68,171",
        "49,426",
        "552,947",
        "14,191",
        "25,024",
        "922,803",
        "12,117",
        "296,718",
        "89,332",
        "1,065,794",
        "48,166",
        "5,477",
        "37,859",
        "702,099",
        "301,072",
        "876",
        "147,924",
        "811,308",
        "15,786",
        "188,629",
        "391,200",
        "31,897",
        "1,170,623",
        "58,009",
        "625,977",
        "368,094",
        "92,770",
        "57,171",
        "416,668",
        "148,957",
        "100,636",
        "1,080",
        "933",
        "126,627",
        "1,495,803",
        "236,668",
        "197,115",
        "449,964",
        "948,554",
        "241,315",
        "131,885",
        "7,448",
        "1,213,406",
        "328,209",
        "65,762",
        "809",
        "2,155",
        "295,237",
        "1,030",
        "14,575",
        "167,261",
        "215,449",
        "540,669",
        "23,295",
        "107,079",
        "10,178",
        "69,526",
        "34,951",
        "1,535,248",
        "21,294",
        "132,774",
        "246,664",
        "107,105",
        "2,020",
        "497,386",
        "221,169",
        "750,808",
        "90,842",
        "540,568",
        "355,924",
        "180,982",
        "23,409",
        "46,693",
        "402,306",
        "137,837",
        "999,725",
        "895,827",
        "81,020",
        "315,069",
        "182,916",
        "136,057",
        "93,610",
        "152,366",
        "402,017",
        "812,261",
        "817,026",
        "607",
        "24,151",
        "3,806",
        "47,035",
        "608,939",
        "146,063",
        "87",
        "3,051,771",
        "147,786",
        "28,091",
        "74,213",
        "687,857",
        "46,901",
        "165,628",
        "8,280",
        "33,240",
        "3,786",
        "274,090",
        "496,762",
        "142,289",
        "19,223",
        "62,674",
        "297,385",
        "60,940",
        "108,150",
        "100,328",
        "3,981",
        "16,739",
        "2,285",
        "198,366",
        "157,637",
        "619,297",
        "348,560",
        "1,063,248",
        "559,771",
        "215,274",
        "97,151",
        "929,214",
        "6,984",
        "311,314",
        "7,377",
        "699,235",
        "3,355",
        "7,702",
        "4,475",
        "112,083",
        "96,684",
        "829,017",
        "472,162",
        "2,094",
        "51,479",
        "283,046",
        "83,906",
        "5,195",
        "1,339,221",
        "487,469",
        "735,701",
        "380,532",
        "1,202",
        "644,605",
        "289,098",
        "585,333",
        "9,682",
        "320,430",
        "862,611",
        "8,945",
        "165,354",
        "33,076",
        "947,135",
        "542,784",
        "98,509",
        "873,481",
        "308,060",
        "305,279",
        "383,094",
        "145,400",
        "264,808",
        "1,840",
        "84,912",
        "785,853",
        "98,656",
        "182,402",
        "18,791",
        "3,168",
        "10,318",
        "3,952",
        "132,186",
        "4,136",
        "6,529",
        "442,151",
        "339,279",
        "470,223",
        "237,449",
        "5,538",
        "16,818",
        "252,687",
        "8,456",
        "33,181",
        "92,824",
        "11,085",
        "1,616",
        "14,535",
        "1,226,933",
        "13,595",
        "365,101",
        "837",
        "47,694",
        "802,688",
        "1,229",
        "16,131",
        "20,130",
        "2,328",
        "32,267",
        "21,682",
        "1,976",
        "1,778",
        "25,666",
        "3,473",
        "124,319",
        "724,627",
        "8,943",
        "146,710",
        "2,355",
        "116,366",
        "56,163",
        "28,108",
        "16,620",
        "2,512",
        "64,886",
        "12,416",
        "1,176",
        "2,546",
        "539,608",
        "23,276",
        "441,445",
        "9,163",
        "184,535",
        "128,213",
        "13,937",
        "78,806",
        "2,966",
        "56,416",
        "38,903",
        "296,669",
        "6,002",
        "35,373",
        "25,860",
        "305,798",
        "89,166",
        "11,303",
        "173,252",
        "118,478",
        "3,138,265",
        "27,826",
        "334,027",
        "513,512",
        "738",
        "373,902",
        "139,356",
        "10,851",
        "34,289",
        "154,080",
        "60,216",
        "44,437",
        "578,902",
        "747,641",
        "171,240",
        "438,307",
        "182,086",
        "1,946",
        "3,101",
        "11,434",
        "679,688",
        "236,832",
        "964,678",
        "427,288",
        "65,584",
        "17,238",
        "3,095",
        "1,420",
        "162,728",
        "5,212,372",
        "358,736",
        "52,039",
        "35,570",
        "25,003",
        "734",
        "79,453",
        "5,526",
        "518,380",
        "51,756",
        "162,588",
        "20,800",
        "7,281",
        "159,565",
        "198,269",
        "272,094",
        "3,859",
        "213,425",
        "46,259",
        "60,163",
        "225,597",
        "108,311",
        "77,343",
        "321",
        "148,623",
        "19,586",
        "5,844",
        "12,109",
        "59,427",
        "256,080",
        "32,858",
        "802,481",
        "206,403",
        "22,602",
        "25,222",
        "126,142",
        "218,277",
        "54,131",
        "18,379",
        "134,034",
        "6,789",
        "3,959",
        "83,842",
        "91,519",
        "101,435",
        "156,633",
        "515,732",
        "159,267",
        "7,047",
        "225,116",
        "27,874",
        "123,836",
        "276,494",
        "45,147",
        "20,234",
        "4,220",
        "130,545",
        "24,988",
        "298,439",
        "920,015",
        "71,408",
        "300,843",
        "121,214",
        "269,035",
        "1,313",
        "36,871",
        "25,713",
        "524,697",
        "84,842",
        "229,850",
        "10,957",
        "15,437",
        "198,220",
        "123,062",
        "20,159",
        "46,631",
        "319,493",
        "11,102",
        "16,604",
        "3,379",
        "167,080",
        "91,499",
        "417,258",
        "74,163",
        "89,425",
        "49,288",
        "2,429",
        "224,719",
        "205,426",
        "37,836",
        "9,173",
        "634,423",
        "44,216",
        "52,683",
        "549,870",
        "35,194",
        "700,308",
        "2,141",
        "65,825",
        "7,153",
        "198,417",
        "39,317",
        "467,202",
        "9,723",
        "746,548",
        "24,387",
        "50,064",
        "36,811",
        "4,686",
        "69,175",
        "427,184",
        "36,868",
        "425,495",
        "165,168",
        "185,852",
        "178,992",
        "43,398",
        "141,796",
        "12,334",
        "3,085",
        "13,850",
        "64,008",
        "1,669",
        "93,073",
        "1,994",
        "2,371",
        "638,395",
        "75,802",
        "11,126",
        "187,117",
        "54,284",
        "208,047",
        "32,682",
        "64,143",
        "16,824",
        "50,023",
        "8,306",
        "5,593",
        "12,687",
        "3,000",
        "154,821",
        "8,468",
        "10,022",
        "1,181,824",
        "21,549",
        "56,647",
        "1,848,423",
        "29,882",
        "4,813",
        "3,984",
        "805,434",
        "7,110",
        "13,762",
        "1,784,889",
        "38,502",
        "10,611",
        "178,013",
        "109,920",
        "192,311",
        "2,604",
        "436,983",
        "8,537",
        "436,339",
        "2,372",
        "70,466",
        "14,249",
        "11,473",
        "8,595",
        "89,120",
        "34,297",
        "16,323",
        "1,804",
        "1,603",
        "364,090",
        "14,217",
        "135,747",
        "10,843",
        "3,507",
        "3,678",
        "7,184",
        "41,372",
        "919,230",
        "56,033",
        "29,376",
        "24,923",
        "2,949",
        "746,580",
        "352,068",
        "53,691",
        "2,539",
        "10,141",
        "4,182,285",
        "118,115",
        "1,966",
        "10,825",
        "3,635",
        "76,896",
        "39,694",
        "116,948",
        "16,091",
        "28,557",
        "541,592",
        "7,327",
        "48,149",
        "37,891",
        "8,853",
        "54,557",
        "6,518",
        "9,244",
        "163,724",
        "27,758",
        "250,597",
        "150,156",
        "6,522",
        "9,893,481",
        "202,288",
        "4,058",
        "36,264",
        "16,258",
        "160,828",
        "57,179",
        "3,521",
        "15,606",
        "6,460",
        "432,549",
        "609,610",
        "8,334",
        "88,182",
        "33,934",
        "15,421",
        "5,342",
        "8,516",
        "17,481",
        "134,497",
        "10,126",
        "16,800",
        "6,770",
        "31,410",
        "119,546",
        "4,362",
        "160,565",
        "441,901",
        "98,409",
        "4,034",
        "4,566",
        "24,305",
        "67,198",
        "928",
        "5,142",
        "4,522",
        "99,875",
        "40,870",
        "29,297",
        "401,673",
        "8,639",
        "18,482",
        "15,554",
        "119,947",
        "1,272,533",
        "102,270",
        "386,106",
        "268,373",
        "48,019",
        "274,960",
        "8,464",
        "47,330",
        "616",
        "87,730",
        "10,263",
        "77,930",
        "21,046",
        "633,968",
        "37,422",
        "22,387",
        "65,786",
        "3,713",
        "2,382",
        "329,487",
        "76,885",
        "13,249",
        "43,932",
        "28,966",
        "101,496",
        "22,518",
        "43,663",
        "36,512",
        "3,889,161",
        "43,753",
        "50,789",
        "340,973",
        "25,931",
        "1,952",
        "2,370",
        "75,120",
        "207,878",
        "4,120",
        "18,063",
        "7,604",
        "1,794",
        "24,670",
        "2,933",
        "502,854",
        "26,310",
        "1,257,913",
        "195,045",
        "289,873",
        "36,982",
        "102,619",
        "15,199",
        "50,260",
        "14,983",
        "8,125",
        "134,411",
        "5,927",
        "117,641",
        "36,901",
        "49,975",
        "51,329",
        "34,274",
        "49,188",
        "35,868",
        "42,911",
        "20,954",
        "24,662",
        "147,110",
        "67,357",
        "77,002",
        "11,564",
        "545,667",
        "102,752",
        "18,577",
        "18,061",
        "18,395",
        "5,187",
        "2,311",
        "33,384",
        "167,860",
        "2,249",
        "23,627",
        "26,030",
        "90,606",
        "15,125",
        "15,959",
        "7,291",
        "4,528",
        "133,503",
        "5,062",
        "261,047",
        "6,368",
        "200,632",
        "433,477",
        "658,552",
        "7,902",
        "143,665",
        "2,545",
        "165,776",
        "266,575",
        "42,265",
        "164,144",
        "155,579",
        "9,186",
        "5,942",
        "2,553",
        "110,324",
        "9,454",
        "6,158",
        "36,321",
        "1,773",
        "2,412,481",
        "667,092",
        "369,650",
        "3,790",
        "2,495",
        "10,562",
        "6,308",
        "5,854",
        "187,114",
        "20,637",
        "129,397",
        "52,627",
        "845,197",
        "9,776",
        "1,435,207",
        "85,989",
        "80,280",
        "412,078",
        "167,065",
        "9,090",
        "227,439",
        "34,594",
        "16,511",
        "147,432",
        "29,486",
        "32,849",
        "17,303",
        "5,990",
        "24,950",
        "67,872",
        "459,857",
        "53,092",
        "3,441",
        "23,709",
        "25,971",
        "16,325",
        "6,078",
        "56,687",
        "2,055",
        "32,404",
        "107,920",
        "39,181",
        "192,665",
        "25,643",
        "18,452",
        "732,118",
        "230,934",
        "4,825",
        "354,656",
        "3,141",
        "148,435",
        "203,211",
        "62,742",
        "23,877",
        "166,874",
        "5,605",
        "357,013",
        "523,306",
        "2,256,400",
        "20,634",
        "161,297",
        "495,326",
        "21,834",
        "147,477",
        "18,915",
        "3,271",
        "57,369",
        "32,617",
        "12,088",
        "173,108",
        "2,276",
        "7,869",
        "101,666",
        "28,631",
        "10,227",
        "56,763",
        "112,210",
        "8,701",
        "49,696",
        "12,013",
        "127,325",
        "14,626",
        "21,241",
        "41,339",
        "3,846",
        "627,469",
        "161,276",
        "18,971",
        "3,105",
        "9,692",
        "4,930",
        "49,333",
        "115,420",
        "105,812",
        "54,821",
        "17,665",
        "170,382",
        "94,411",
        "21,401",
        "49,390",
        "268,939",
        "2,835",
        "110,262",
        "4,898",
        "9,580",
        "1,976,925",
        "9,730",
        "61,270",
        "9,255",
        "7,205",
        "278,624",
        "1,387",
        "36,128",
        "7,562",
        "135,940",
        "14,729",
        "2,323",
        "76,228",
        "241,801",
        "872,598",
        "75,239",
        "5,472",
        "76,634",
        "44,156",
        "115,235",
        "9,132",
        "1,698",
        "7,239",
        "1,048,314",
        "10,623",
        "3,181",
        "151,053",
        "15,499",
        "675,641",
        "26,587",
        "14,940",
        "178,378",
        "45,808",
        "13,251",
        "311,886",
        "301,720",
        "25,703",
        "3,433",
        "8,849",
        "5,209",
        "12,272",
        "215,465",
        "62,353",
        "90,750",
        "12,454",
        "48,896",
        "109,844",
        "74,469",
        "65,610",
        "52,300",
        "15,809",
        "200,327",
        "54,728",
        "37,531",
        "151,408",
        "1,371",
        "17,870",
        "825,911",
        "1,145",
        "56,115",
        "7,186",
        "869",
        "73,047",
        "609,544",
        "54,068",
        "28,573",
        "7,099",
        "10,651",
        "71,731",
        "15,727",
        "23,880",
        "92,962",
        "98,483",
        "56,590",
        "18,100",
        "15,128",
        "13,092",
        "81,098",
        "2,348",
        "465,144",
        "10,481",
        "11,243",
        "816",
        "27,602",
        "31,522",
        "91,536",
        "15,146",
        "9,698",
        "69,217",
        "24,542",
        "4,051",
        "15,069",
        "121,757",
        "9,952",
        "110,243",
        "389,708",
        "4,245",
        "252,763",
        "1,944",
        "43,905",
        "2,943",
        "9,678",
        "23,385",
        "150,594",
        "8,790",
        "19,046",
        "28,757",
        "202,428",
        "113,295",
        "48,928",
        "687",
        "7,465",
        "37,157",
        "107,583",
        "31,129",
        "23,197",
        "59,894",
        "152,020",
        "473,832",
        "15,587",
        "15,942",
        "22,345",
        "49,112",
        "11,173",
        "212,227",
        "83,985",
        "10,037",
        "42,871",
        "500,768",
        "14,151",
        "214,275",
        "5,441",
        "42,103",
        "27,439",
        "31,367",
        "7,588",
        "54,945",
        "7,243",
        "78,761",
        "932,919",
        "154,460",
        "6,012",
        "4,919",
        "1,165",
        "14,289",
        "2,357",
        "73,726",
        "21,040",
        "168,947",
        "38,078",
        "34,339",
        "33,318",
        "258,780",
        "22,850",
        "5,818",
        "32,800",
        "20,359",
        "13,991",
        "13,793",
        "6,075",
        "3,362",
        "20,732",
        "1,568",
        "2,791",
        "2,759",
        "35,535",
        "8,344",
        "59,872",
        "2,188",
        "64,504",
        "99,683",
        "15,071",
        "25,914",
        "14,630",
        "267,017",
        "98,951",
        "64,585",
        "102,867",
        "11,695",
        "20,533",
        "123,891",
        "382",
        "163,387",
        "88,876",
        "2,775",
        "93,224",
        "45,906",
        "3,445",
        "1,915",
        "18,804",
        "17,661",
        "181,025",
        "10,294",
        "17,319",
        "206,349",
        "35,155",
        "2,539,789",
        "99,788",
        "28,485",
        "20,578",
        "358,324",
        "19,042",
        "14,909",
        "986,891",
        "7,207",
        "2,568",
        "10,057",
        "698",
        "20,870",
        "181,415",
        "136,957",
        "17,532",
        "5,925",
        "72,839",
        "19,707",
        "8,617",
        "5,735",
        "32,871",
        "6,748",
        "143,205",
        "46,070",
        "38,484",
        "6,600",
        "211,968",
        "22,427",
        "163,975",
        "17,453",
        "6,576",
        "78,724",
        "42,270",
        "43,994",
        "16,603",
        "11,741",
        "4,219",
        "54,804",
        "234,206",
        "20,659",
        "12,712",
        "29,446",
        "8,247",
        "15,834",
        "271,102",
        "269,407",
        "130,192",
        "17,990",
        "14,430",
        "21,038",
        "59,121",
        "9,352",
        "11,312",
        "42,798",
        "7,332",
        "85,264",
        "29,098",
        "43,230",
        "536,433",
        "3,127",
        "39,252",
        "4,796",
        "228,980",
        "70,136",
        "77,134",
        "105,220",
        "38,687",
        "5,713",
        "16,032",
        "55,633",
        "30,014",
        "21,916",
        "14,242",
        "20,483",
        "1,241",
        "36,710",
        "22,009",
        "77,527",
        "20,440",
        "1,975",
        "1,175,416",
        "74,077",
        "65,074",
        "4,800",
        "249,848",
        "165,030",
        "15,842",
        "913",
        "24,012",
        "3,129",
        "199,298",
        "17,474",
        "7,211",
        "46,885",
        "52,961",
        "152,384",
        "2,181",
        "96,755",
        "320,827",
        "219,636",
        "16,260",
        "3,316",
        "8,282",
        "7,563",
        "420,569",
        "42,601",
        "30,659",
        "161,710",
        "36,745",
        "281,531",
        "23,989",
        "621,445",
        "101,569",
        "82,372",
        "26,669",
        "81,621",
        "24,572",
        "2,998",
        "659",
        "79,767",
        "88,068",
        "19,668",
        "32,667",
        "140,785",
        "6,945",
        "5,869",
        "81,865",
        "28,650",
        "244,090",
        "21,802",
        "47,462",
        "6,335",
        "5,264",
        "7,802",
        "187,044",
        "62,676",
        "10,872",
        "33,274",
        "20,381",
        "26,201",
        "15,621",
        "19,622",
        "34,995",
        "16,177",
        "36,675",
        "5,672",
        "13,447",
        "1,292",
        "88,598",
        "54,907",
        "6,076",
        "3,779",
        "75,263",
        "56,195",
        "9,208",
        "22,055",
        "7,307",
        "14,008",
        "59,638",
        "10,149",
        "23,290",
        "10,732",
        "58,951",
        "20,109",
        "49,314",
        "58,150",
        "35,608",
        "10,739",
        "15,486",
        "2,645",
        "8,010",
        "8,500",
        "1,436",
        "13,466",
        "170,704",
        "97,301",
        "9,095",
        "139,802",
        "293,384",
        "19,737",
        "42,948",
        "5,288",
        "44,511",
        "25,293",
        "38,756",
        "375,348",
        "9,499",
        "107,634",
        "60,280",
        "10,023",
        "36,462",
        "35,398",
        "11,517",
        "75,930",
        "40,301",
        "115,928",
        "205,117",
        "180,233",
        "23,504",
        "7,417",
        "32,520",
        "161,865",
        "193,528",
        "20,776",
        "35,424",
        "32,840",
        "9,012",
        "34,050",
        "6,944",
        "1,865",
        "111,221",
        "24,127",
        "75,250",
        "255,551",
        "19,351",
        "33,398",
        "16,284",
        "950,527",
        "28,746",
        "99,802",
        "9,560",
        "131,468",
        "11,348",
        "5,666",
        "27,707",
        "104,041",
        "2,043",
        "2,279",
        "33,514",
        "39,458",
        "1,753,238",
        "141,542",
        "8,013",
        "353,382",
        "32,350",
        "67,152",
        "4,657",
        "37,626",
        "7,050",
        "452,030",
        "28,177",
        "280,518",
        "300,926",
        "41,429",
        "60,956",
        "3,233",
        "9,680",
        "18,432",
        "16,802",
        "143,845",
        "63,237",
        "184,366",
        "62,029",
        "16,240",
        "40,811",
        "7,176",
        "1,435",
        "106,211",
        "111,742",
        "12,379",
        "21,313",
        "9,470",
        "4,771",
        "912,242",
        "10,435",
        "13,430",
        "40,800",
        "111,868",
        "9,601",
        "11,848",
        "160,345",
        "1,623",
        "23,042",
        "45,219",
        "9,216",
        "82,795",
        "122,258",
        "1,363",
        "6,625",
        "86,779",
        "40,517",
        "49,317",
        "7,860",
        "17,663",
        "43,221",
        "156,290",
        "52,212",
        "121,292",
        "276,688",
        "7,853",
        "18,094",
        "10,807",
        "34,768",
        "65,087",
        "34,190",
        "237,033",
        "496,268",
        "22,361",
        "5,566",
        "4,331",
        "22,715",
        "711",
        "53,765",
        "494,250",
        "34,651",
        "11,785",
        "88,323",
        "74,419",
        "19,734",
        "153,649",
        "20,781",
        "439,511",
        "139,906",
        "60,925",
        "6,469",
        "126,940",
        "84,521",
        "3,840",
        "7,020",
        "5,516",
        "79,895",
        "115,438",
        "55,949",
        "156,741",
        "55,165",
        "2,507",
        "7,359",
        "4,027",
        "11,631",
        "66,623",
        "59,092",
        "13,463",
        "16,542",
        "33,722",
        "2,231",
        "107,312",
        "6,256",
        "67,358",
        "22,428",
        "123,722",
        "220,542",
        "14,869",
        "27,977",
        "112,991",
        "34,722",
        "282,633",
        "5,573",
        "5,953",
        "5,189",
        "119,673",
        "32,894",
        "33,118",
        "10,495",
        "76,322",
        "1,142",
        "22,736",
        "31,799",
        "468,194",
        "19,902",
        "13,115",
        "14,025",
        "20,269",
        "18,949",
        "111,969",
        "3,973",
        "6,753",
        "104,820",
        "175,628",
        "3,199",
        "3,707",
        "11,659",
        "67,021",
        "47,491",
        "2,708",
        "344,257",
        "177,966",
        "62,624",
        "68,614",
        "7,490",
        "28,017",
        "2,189",
        "96,604",
        "182,841",
        "20,960",
        "33,188",
        "15,054",
        "7,260",
        "133,486",
        "7,001",
        "16,213",
        "131,038",
        "66,606",
        "94,787",
        "2,228,528",
        "6,867",
        "31,157",
        "9,389",
        "8,289",
        "34,322",
        "9,269",
        "102,110",
        "41,632",
        "2,884",
        "94,910",
        "25,512",
        "60,647",
        "134,613",
        "53,412",
        "278,231",
        "2,432",
        "92,666",
        "266,694",
        "709",
        "144,405",
        "2,722",
        "52,855",
        "41,776",
        "15,838",
        "61,600",
        "4,399",
        "15,308",
        "17,111",
        "16,841",
        "13,458",
        "12,339",
        "9,311",
        "85,650",
        "39,213",
        "44,953",
        "11,658",
        "300,795",
        "19,001",
        "19,937",
        "51,328",
        "14,201",
        "64,428",
        "50,019",
        "25,985",
        "19,109",
        "17,257",
        "20,822",
        "36,639",
        "21,986",
        "10,467",
        "134,795",
        "64,319",
        "21,503",
        "59,431",
        "50,468",
        "981",
        "42,050",
        "65,210",
        "18,339",
        "39,855",
        "47,315",
        "28,164",
        "17,452",
        "26,673",
        "74,730",
        "45,826",
        "5,107",
        "5,937",
        "11,015",
        "102,326",
        "69,078",
        "6,347",
        "87,497",
        "10,206",
        "97,355",
        "281,015",
        "98,261",
        "5,571",
        "102,155",
        "2,005",
        "207,911",
        "28,092",
        "30,517",
        "4,087",
        "60,577",
        "4,391",
        "17,922",
        "66,467",
        "252,157",
        "16,055",
        "2,527",
        "154,432",
        "54,967",
        "6,971",
        "56,666",
        "4,256",
        "126,536",
        "40,743",
        "36,883",
        "29,274",
        "69,266",
        "33,859",
        "26,168",
        "14,779",
        "14,508",
        "3,377",
        "28,648",
        "49,271",
        "2,549,075",
        "44,276",
        "96,547",
        "12,956",
        "152,472",
        "5,224",
        "2,093",
        "140,214",
        "4,700",
        "132,588",
        "95,901",
        "98,398",
        "3,061",
        "6,148",
        "6,924",
        "42,089",
        "14,579",
        "121,797",
        "5,669",
        "14,714",
        "35,359",
        "233,871",
        "32,295",
        "2,981",
        "39,711",
        "118,073",
        "33,863",
        "22,266",
        "10,055",
        "322,033",
        "8,410",
        "17,108",
        "114,750",
        "61,298",
        "8,823",
        "318,955",
        "18,957",
        "25,856",
        "4,247",
        "44,929",
        "43,822",
        "20,633",
        "139,634",
        "170,485",
        "15,109",
        "24,281",
        "4,729",
        "147,700",
        "12,547",
        "73,551",
        "116,604",
        "25,870",
        "135,534",
        "19,838",
        "23,884",
        "2,129",
        "29,860",
        "97,230",
        "3,323",
        "73,243",
        "27,108",
        "5,640",
        "88,404",
        "26,280",
        "6,419",
        "17,996",
        "92,851",
        "17,574",
        "90,374",
        "131,500",
        "13,638",
        "20,350",
        "41,020",
        "19,999",
        "25,927",
        "4,205",
        "26,613",
        "24,483",
        "95,571",
        "1,709",
        "5,296",
        "45,678",
        "19,657",
        "16,098",
        "21,099",
        "9,278",
        "40,423",
        "10,625",
        "17,014",
        "316,144",
        "194,949",
        "13,535",
        "38,819",
        "111,310",
        "25,281",
        "15,449",
        "116,059",
        "42,253",
        "84,397",
        "5,951",
        "10,269",
        "23,932",
        "830",
        "60,619",
        "787",
        "6,063",
        "41,291",
        "28,685",
        "6,454",
        "13,234",
        "10,083",
        "137,763",
        "17,911",
        "81,821",
        "29,471",
        "17,205",
        "5,000",
        "46,303",
        "40,419",
        "3,640",
        "38,911",
        "38,217",
        "10,785",
        "19,441",
        "538",
        "7,905",
        "69,910",
        "3,924",
        "33,289",
        "24,626",
        "50,799",
        "41,923",
        "35,469",
        "3,998",
        "20,188",
        "8,608",
        "50,102",
        "25,741",
        "30,002",
        "38,215",
        "190,756",
        "3,710",
        "10,210",
        "142,448",
        "207,263",
        "105,580",
        "4,891",
        "35,736",
        "61,918",
        "196,824",
        "13,842",
        "11,099",
        "44,597",
        "42,267",
        "5,763",
        "38,769",
        "160,126",
        "11,034",
        "37,044",
        "6,922",
        "21,490",
        "693,177",
        "58,394",
        "22,607",
        "32,244",
        "42,769",
        "208,792",
        "17,487",
        "5,390",
        "162,975",
        "16,578",
        "4,958",
        "29,229",
        "16,674",
        "157,342",
        "2,064",
        "52,666",
        "35,891",
        "413,188",
        "43,871",
        "10,093",
        "5,674",
        "65,681",
        "39,640",
        "1,423",
        "14,843",
        "94,444",
        "36,967",
        "38,807",
        "25,300",
        "4,462",
        "4,477",
        "18,444",
        "137,393",
        "43,294",
        "46,512",
        "43,836",
        "172,321",
        "40,985",
        "99,505",
        "21,369",
        "22,183",
        "24,697",
        "22,582",
        "31,296",
        "37,700",
        "177,640",
        "421,575",
        "69,990",
        "3,182",
        "4,273",
        "124,591",
        "48,389",
        "23,975",
        "47,800",
        "198,841",
        "86,455",
        "58,552",
        "4,006",
        "23,917",
        "70,246",
        "68,928",
        "37,636",
        "6,052",
        "36,829",
        "3,761",
        "17,502",
        "1,804,507",
        "13,778",
        "27,184",
        "58,188",
        "105,895",
        "44,503",
        "3,956",
        "4,484",
        "16,151",
        "6,582",
        "13,744",
        "1,536,704",
        "10,836",
        "12,491",
        "16,271",
        "44,932",
        "49,490",
        "59,390",
        "13,530",
        "6,166",
        "42,663",
        "59,120",
        "28,701",
        "1,330",
        "12,780",
        "10,428",
        "91,295",
        "62,753",
        "32,293",
        "33,001",
        "9,310",
        "20,537",
        "24,286",
        "34,932",
        "5,885",
        "75,419",
        "8,755",
        "46,122",
        "20,408",
        "112,097",
        "20,741",
        "77,341",
        "17,807",
        "18,392",
        "15,136",
        "46,053",
        "134,156",
        "52,559",
        "37,099",
        "8,725",
        "21,399",
        "10,091",
        "28,054",
        "8,021",
        "46,810",
        "6,382",
        "132,034",
        "8,394",
        "32,751",
        "20,111",
        "50,121",
        "52,545",
        "1,947",
        "30,660",
        "188,480",
        "10,599",
        "56,376",
        "20,669",
        "8,818",
        "4,920",
        "21,157",
        "53,051",
        "54,590",
        "28,636",
        "27,400",
        "7,862",
        "9,285",
        "79,735",
        "15,282",
        "10,381",
        "25,662",
        "25,939",
        "36,822",
        "26,034",
        "42,013",
        "9,102",
        "2,070",
        "318,441",
        "78,636",
        "333,503",
        "4,486",
        "5,123",
        "43,513",
        "23,115",
        "33,218",
        "53,732",
        "92,528",
        "45,417",
        "89,419",
        "8,413",
        "29,399",
        "11,529",
        "10,989",
        "5,095",
        "53,234",
        "160,048",
        "3,048",
        "47,057",
        "123,387",
        "5,286",
        "17,308",
        "15,425",
        "52,515",
        "154,641",
        "16,839",
        "28,804",
        "3,620",
        "39,720",
        "47,509",
        "286,789",
        "34,238",
        "39,070",
        "39,501",
        "13,571",
        "107,286",
        "51,557",
        "5,957",
        "5,796",
        "8,189",
        "20,506",
        "3,167",
        "43,368",
        "78,993",
        "17,762",
        "15,083",
        "1,267",
        "72,092",
        "38,362",
        "17,343",
        "15,371",
        "33,411",
        "83,976",
        "83,964",
        "30,824",
        "77,767",
        "82,783",
        "28,689",
        "2,763",
        "3,278",
        "6,977",
        "51,648",
        "10,197",
        "23,268",
        "88,173",
        "22,777",
        "5,827",
        "31,817",
        "75,897",
        "15,522",
        "50,160",
        "197,642",
        "35,588",
        "17,722",
        "19,581",
        "2,210",
        "16,574",
        "51,080",
        "13,313",
        "38,802",
        "64,606",
        "16,580",
        "38,744",
        "518,321",
        "237,316",
        "6,371",
        "16,435",
        "100,070",
        "13,253",
        "53,508",
        "5,841",
        "47,575",
        "36,920",
        "24,737",
        "24,517",
        "45,021",
        "1,454",
        "35,295",
        "18,875",
        "12,808",
        "10,184",
        "17,756",
        "21,461",
        "25,975",
        "37,514",
        "6,584",
        "63,077",
        "21,366",
        "51,676",
        "107,078",
        "18,019",
        "54,456",
        "71,230",
        "123,382",
        "3,937",
        "33,086",
        "53,517",
        "49,926",
        "26,813",
        "9,943",
        "64,260",
        "2,376",
        "11,180",
        "17,201",
        "131,027",
        "32,449",
        "22,088",
        "28,905",
        "37,799",
        "36,232",
        "51,942",
        "117,648",
        "5,064",
        "581",
        "11,723",
        "4,923",
        "5,199",
        "14,017",
        "37,383",
        "66,211",
        "14,646",
        "22,940",
        "100,808",
        "14,142",
        "9,249",
        "43,348",
        "47,904",
        "26,865",
        "141,902",
        "49,751",
        "7,624",
        "33,666",
        "58,735",
        "30,177",
        "67,776",
        "9,028",
        "57,657",
        "76,467",
        "41,428",
        "18,693",
        "3,762",
        "31,928",
        "29,449",
        "173,119",
        "35,583",
        "15,453",
        "61,154",
        "28,214",
        "52,510",
        "7,998",
        "48,905",
        "13,485",
        "69,933",
        "16,301",
        "9,283",
        "28,064",
        "7,517",
        "62,309",
        "44,664",
        "37,623",
        "80,337",
        "16,337",
        "13,955",
        "16,896",
        "45,139",
        "41,281",
        "32,899",
        "2,056,915",
        "34,869",
        "83,091",
        "21,467",
        "28,308",
        "54,078",
        "7,602",
        "47,063",
        "77,802",
        "45,015",
        "13,748",
        "39,361",
        "610,295",
        "27,410",
        "81,536",
        "122,665",
        "62,721",
        "128,476",
        "49,302",
        "7,603",
        "24,503",
        "3,614",
        "37,942",
        "111,160",
        "20,698",
        "81,147",
        "16,592",
        "18,695",
        "74,394",
        "38,239",
        "45,512",
        "44,604",
        "32,650",
        "12,644",
        "9,468",
        "108,084",
        "11,982",
        "14,469",
        "119,483",
        "35,051",
        "33,360",
        "16,411",
        "44,969",
        "30,859",
        "16,477",
        "19,134",
        "56,589",
        "9,172",
        "31,498",
        "8,840",
        "7,061",
        "25,677",
        "18,465",
        "116,803",
        "16,068",
        "68,557",
        "198,662",
        "41,394",
        "92,974",
        "1,546",
        "179,935",
        "21,745",
        "69,727",
        "38,266",
        "16,878",
        "9,969",
        "1,905",
        "29,268",
        "15,766",
        "15,008",
        "100,382",
        "11,603",
        "12,592",
        "40,362",
        "15,051",
        "14,571",
        "77,946",
        "2,786",
        "12,128",
        "87,042",
        "155,524",
        "48,618",
        "39,182",
        "81,365",
        "59,746",
        "4,099",
        "7,048",
        "70,144",
        "19,450",
        "35,938",
        "8,472",
        "138,265",
        "379,128",
        "30,428",
        "31,566",
        "14,333",
        "29,028",
        "6,695",
        "8,407",
        "6,276",
        "136,145",
        "7,420",
        "20,894",
        "9,140",
        "77,897",
        "68,481",
        "7,314",
        "52,795",
        "979",
        "4,956",
        "117,575",
        "16,906",
        "27,180",
        "31,979",
        "76,306",
        "201,680",
        "117,714",
        "39,216",
        "32,621",
        "39,403",
        "46,698",
        "53,335",
        "64,899",
        "85,872",
        "529,262",
        "55,172",
        "80,499",
        "34,630",
        "26,698",
        "37,329",
        "3,552",
        "45,874",
        "30,818",
        "703",
        "41,143",
        "57,623",
        "6,200",
        "4,383",
        "41,307",
        "42,637",
        "9,120",
        "43,744",
        "66,622",
        "1,615",
        "12,378",
        "8,302",
        "63,369",
        "11,218",
        "56,759",
        "12,734",
        "26,528",
        "1,186",
        "7,894",
        "27,531",
        "43,515",
        "46,926",
        "66,323",
        "48,280",
        "8,648",
        "27,271",
        "171,153",
        "51,759",
        "3,683",
        "26,460",
        "28,902",
        "13,953",
        "15,377",
        "38,760",
        "78,067",
        "3,804",
        "41,110",
        "32,690",
        "61,111",
        "13,790",
        "11,913",
        "12,607",
        "6,904",
        "13,318",
        "55,569",
        "4,788",
        "39,935",
        "9,493",
        "17,210",
        "6,774",
        "60,055",
        "36,862",
        "201,081",
        "43,079",
        "142,042",
        "72,702",
        "8,679",
        "69,671",
        "60,529",
        "10,656",
        "96,147",
        "14,730",
        "7,843",
        "12,729",
        "53,171",
        "24,035",
        "36,624",
        "9,419",
        "41,217",
        "7,085",
        "27,934",
        "246,300",
        "37,071",
        "63,241",
        "26,762",
        "28,625",
        "14,340",
        "10,551",
        "14,348",
        "49,664",
        "17,284",
        "39,470",
        "37,847",
        "62,261",
        "22,429",
        "93,699",
        "10,094",
        "46,463",
        "13,371",
        "8,723",
        "25,348",
        "25,664",
        "23,563",
        "4,859",
        "65,085",
        "53,011",
        "107,645",
        "33,819",
        "13,564",
        "10,439",
        "16,414",
        "8,798",
        "16,179",
        "13,772",
        "47,883",
        "12,946",
        "13,687",
        "12,665",
        "2,782",
        "3,116",
        "38,850",
        "118,793",
        "41,185",
        "49,275",
        "26,663",
        "848,204",
        "13,512",
        "36,786",
        "19,920",
        "7,035",
        "16,723",
        "9,695",
        "17,142",
        "17,724",
        "23,589",
        "8,638",
        "35,797",
        "16,722",
        "7,057",
        "15,590",
        "10,198",
        "18,333",
        "52,412",
        "73,486",
        "22,757",
        "939,605",
        "63,909",
        "104,260",
        "1,133",
        "48,198",
        "26,791",
        "45,714",
        "11,869",
        "34,009",
        "11,740",
        "16,917",
        "20,920",
        "3,749",
        "34,424",
        "5,880",
        "1,358",
        "12,961",
        "21,227",
        "18,254",
        "5,237",
        "24,256",
        "10,895",
        "26,011",
        "28,324",
        "68,346",
        "10,194",
        "30,344",
        "114,181",
        "98,275",
        "28,587",
        "97,670",
        "32,274",
        "15,545",
        "7,623",
        "12,869",
        "12,193",
        "32,549",
        "21,235",
        "15,753",
        "7,734",
        "751",
        "10,534",
        "40,218",
        "100,835",
        "31,427",
        "18,774",
        "29,214",
        "34,217",
        "9,524",
        "44,692",
        "4,070",
        "12,543",
        "10,332",
        "614",
        "10,982",
        "35,297",
        "36,274",
        "44,398",
        "28,044",
        "34,018",
        "59,178",
        "62,248",
        "29,878",
        "9,496",
        "61,847",
        "3,851",
        "20,842",
        "36,442",
        "13,808",
        "14,916",
        "8,347",
        "12,992",
        "64,767",
        "10,866",
        "41,039",
        "70,657",
        "6,035",
        "121,526",
        "2,760",
        "27,069",
        "53,451",
        "11,554",
        "11,774",
        "22,819",
        "24,685",
        "12,774",
        "21,321",
        "68,679",
        "9,467",
        "28,594",
        "33,624",
        "28,015",
        "64,011",
        "36,494",
        "8,762",
        "23,267",
        "74,169",
        "22,029",
        "21,645",
        "59,277",
        "39,747",
        "6,854",
        "42,504",
        "52,338",
        "76,013",
        "90,202",
        "7,052",
        "75,991",
        "28,646",
        "20,990",
        "5,656",
        "19,895",
        "9,497",
        "19,008",
        "22,182",
        "32,977",
        "5,773",
        "42,146",
        "8,046",
        "5,442",
        "90,591",
        "25,584",
        "55,544",
        "6,054",
        "38,465",
        "50,447",
        "9,598",
        "42,580",
        "44,857",
        "18,354",
        "21,537",
        "31,886",
        "42,996",
        "76,461",
        "21,619",
        "14,149",
        "26,389",
        "20,104",
        "8,539",
        "15,860",
        "21,361",
        "30,615",
        "34,870",
        "211,175",
        "67,403",
        "34,779",
        "39,861",
        "10,282",
        "68,174",
        "5,475",
        "31,088",
        "11,046",
        "81,835",
        "24,371",
        "45,620",
        "102,556",
        "42,007",
        "65,627",
        "35,614",
        "15,933",
        "7,730",
        "12,148",
        "63,687",
        "61,796",
        "13,088",
        "12,408",
        "8,871",
        "15,138",
        "11,062",
        "15,657",
        "5,562",
        "23,377",
        "17,443",
        "24,512",
        "78,952",
        "5,182",
        "244,654",
        "27,481",
        "10,902",
        "22,576",
        "6,817",
        "81,845",
        "15,885",
        "33,034",
        "11,706",
        "4,944",
        "3,731",
        "83,534",
        "11,418",
        "24,863",
        "29,979",
        "36,051",
        "25,655",
        "75,966",
        "37,463",
        "32,360",
        "75,782",
        "23,417",
        "64,473",
        "43,395",
        "15,004",
        "15,862",
        "43,007",
        "20,840",
        "6,274",
        "12,266",
        "10,193",
        "67,568",
        "10,159",
        "14,435",
        "45,339",
        "118,864",
        "4,834",
        "34,145",
        "33,182",
        "6,611",
        "57,761",
        "27,338",
        "13,829",
        "25,573",
        "10,580",
        "42,946",
        "72,574",
        "14,782",
        "21,333",
        "82,407",
        "5,271",
        "27,493",
        "16,217",
        "11,400",
        "55,409",
        "12,415",
        "16,269",
        "22,629",
        "23,614",
        "34,969",
        "66,457",
        "37,159",
        "26,822",
        "586",
        "41,927",
        "20,540",
        "20,798",
        "25,833",
        "14,945",
        "41,154",
        "10,505",
        "20,358",
        "23,365",
        "7,180",
        "20,123",
        "2,769",
        "18,817",
        "28,357",
        "70,400",
        "38,488",
        "20,792",
        "22,221",
        "6,457",
        "5,017",
        "13,922",
        "9,176",
        "69,184",
        "14,396",
        "9,387",
        "8,525",
        "22,113",
        "57,438",
        "23,146",
        "12,709",
        "279,837",
        "23,324",
        "23,955",
        "3,310",
        "15,087",
        "24,342",
        "26,456",
        "25,651",
        "13,437",
        "63,234",
        "8,744",
        "11,708",
        "6,056",
        "14,229",
        "158,348",
        "46,850",
        "32,080",
        "12,473",
        "32,326",
        "11,111",
        "40,537",
        "44,963",
        "20,675",
        "4,257",
        "32,052",
        "43,181",
        "45,912",
        "15,814",
        "111,334",
        "12,849",
        "31,666",
        "45,485",
        "17,896",
        "19,943",
        "22,399",
        "18,445",
        "25,674",
        "14,639",
        "8,308",
        "36,008",
        "199,026",
        "42,148",
        "19,907",
        "1,182",
        "21,695",
        "17,713",
        "17,151",
        "23,659",
        "15,594",
        "50,865",
        "18,139",
        "24,585",
        "24,147",
        "17,147",
        "12,958",
        "38,453",
        "6,550",
        "12,478",
        "10,604",
        "48,842",
        "24,112",
        "15,671",
        "12,554",
        "13,921",
        "14,460",
        "10,129",
        "9,653",
        "27,229",
        "18,531",
        "17,760",
        "8,948",
        "8,855",
        "13,703",
        "29,655",
        "45,889",
        "7,121",
        "16,185",
        "20,816",
        "14,576",
        "8,745",
        "18,579",
        "14,455",
        "14,524",
        "10,746",
        "48,203",
        "46,018",
        "94,220",
        "6,650",
        "8,682",
        "17,066",
        "71,190",
        "31,915",
        "47,488",
        "2,894",
        "17,854",
        "30,207",
        "19,829",
        "11,159",
        "25,910",
        "21,670",
        "15,793",
        "65,602",
        "15,649",
        "11,406",
        "8,375",
        "15,790",
        "6,795",
        "19,052",
        "17,356",
        "58,262",
        "17,110",
        "11,198",
        "22,080",
        "4,458",
        "21,660",
        "16,398",
        "6,699",
        "6,661",
        "21,382",
        "42,865",
        "151,806",
        "26,066",
        "19,383",
        "24,711",
        "5,771",
        "11,527",
        "24,428",
        "813,015",
        "23,479",
        "73,683",
        "11,250",
        "15,278",
        "11,086",
        "22,109",
        "27,243",
        "19,582",
        "41,308",
        "32,029",
        "28,525",
        "25,443",
        "29,204",
        "40,289",
        "20,539",
        "13,838",
        "2,213",
        "6,260",
        "55,587",
        "28,406",
        "21,998",
        "28,488",
        "15,749",
        "9,571",
        "25,986",
        "6,752",
        "16,605",
        "23,521",
        "40,269",
        "258,707",
        "1,397,315",
        "36,652",
        "6,721",
        "4,397",
        "16,733",
        "71,076",
        "30,823",
        "50,062",
        "8,573",
        "12,746",
        "25,233",
        "41,834",
        "26,674",
        "21,502",
        "10,300",
        "23,366",
        "20,059",
        "13,365",
        "23,404",
        "32,879",
        "7,498",
        "23,347",
        "16,827",
        "34,558",
        "16,614",
        "27,676",
        "8,590",
        "13,560",
        "7,898",
        "33,793",
        "6,050",
        "41,765",
        "36,150",
        "31,916",
        "3,094",
        "11,252",
        "11,540",
        "36,823",
        "26,918",
        "23,462",
        "11,045",
        "6,178",
        "15,877",
        "22,912",
        "8,808",
        "262,455",
        "54,251",
        "9,073",
        "8,890",
        "20,392",
        "22,653",
        "3,348",
        "29,093",
        "21,697",
        "45,120",
        "446,644",
        "24,202",
        "8,211",
        "5,706",
        "7,807",
        "32,099",
        "16,655",
        "8,678",
        "25,830",
        "48,730",
        "24,516",
        "29,605",
        "151,435",
        "12,505",
        "10,303",
        "14,070",
        "46,435",
        "6,766",
        "27,930",
        "23,054",
        "39,642",
        "11,775",
        "5,319",
        "192,153",
        "20,699",
        "11,898",
        "12,049",
        "27,981",
        "21,964",
        "15,167",
        "46,935",
        "23,746",
        "39,448",
        "16,996",
        "25,135",
        "8,787",
        "6,842",
        "91,836",
        "7,756",
        "15,042",
        "13,771",
        "34,652",
        "47,122",
        "507",
        "2,254",
        "8,831",
        "12,759",
        "12,801",
        "46,860",
        "33,143",
        "8,637",
        "25,253",
        "10,787",
        "8,642",
        "32,308",
        "19,307",
        "49,326",
        "10,270",
        "20,982",
        "16,964",
        "22,892",
        "23,920",
        "26,578",
        "8,673",
        "19,984",
        "35,596",
        "22,754",
        "19,177",
        "24,602",
        "13,795",
        "40,458",
        "20,624",
        "12,517",
        "24,702",
        "22,509",
        "3,068",
        "18,696",
        "25,408",
        "14,807",
        "9,649",
        "2,138",
        "8,213",
        "12,350",
        "8,256",
        "18,345",
        "30,187",
        "10,250",
        "43,091",
        "19,520",
        "46,534",
        "9,520",
        "7,861",
        "7,501",
        "23,166",
        "5,629",
        "12,174",
        "22,391",
        "42,841",
        "5,105",
        "10,043",
        "37,168",
        "17,126",
        "15,285",
        "19,516",
        "8,440",
        "46,452",
        "59,169",
        "22,154",
        "10,265",
        "17,636",
        "6,915",
        "13,080",
        "20,879",
        "23,425",
        "22,669",
        "18,686",
        "22,660",
        "14,875",
        "45,781",
        "64,811",
        "3,410",
        "22,416",
        "6,689",
        "22,014",
        "13,061",
        "56,049",
        "1,791",
        "18,802",
        "8,002",
        "18,409",
        "24,403",
        "10,501",
        "10,665",
        "18,160",
        "7,816",
        "8,388",
        "16,234",
        "15,265",
        "32,281",
        "19,864",
        "8,045",
        "9,246",
        "21,253",
        "27,321",
        "20,803",
        "40,553",
        "9,903",
        "28,255",
        "15,129",
        "19,174",
        "23,519",
        "175,201",
        "26,569",
        "26,347",
        "8,101",
        "17,203",
        "3,589",
        "27,603",
        "17,403",
        "14,164",
        "50,578",
        "25,497",
        "4,272",
        "10,874",
        "12,873",
        "107,326",
        "25,354",
        "12,007",
        "38,169",
        "11,621",
        "32,695",
        "5,221",
        "12,268",
        "16,997",
        "17,719",
        "18,158",
        "34,107",
        "9,050",
        "17,943",
        "39,504",
        "14,601",
        "20,652",
        "11,220",
        "14,071",
        "13,647",
        "20,797",
        "12,078",
        "11,732",
        "13,903",
        "30,898",
        "10,935",
        "68,110",
        "14,655",
        "3,431",
        "29,012",
        "13,657",
        "2,345",
        "12,248",
        "11,485",
        "16,705",
        "6,356",
        "7,579",
        "23,223",
        "38,346",
        "13,859",
        "27,296",
        "25,001",
        "17,220",
        "25,670",
        "17,137",
        "17,227",
        "35,718",
        "8,332",
        "11,474",
        "6,334",
        "9,388",
        "13,418",
        "17,522",
        "4,053",
        "2,072",
        "27,794",
        "22,778",
        "12,853",
        "4,889",
        "25,815",
        "25,143",
        "12,939",
        "23,340",
        "36,201",
        "17,809",
        "13,104",
        "13,528",
        "16,006",
        "5,419",
        "14,271",
        "10,660",
        "19,070",
        "12,835",
        "10,754",
        "27,914",
        "14,176",
        "4,258",
        "14,795",
        "13,775",
        "27,336",
        "134,535",
        "25,343",
        "12,582",
        "524",
        "37,542",
        "13,689",
        "13,179",
        "28,409",
        "6,141",
        "14,148",
        "31,661",
        "26,897",
        "8,934",
        "6,592",
        "33,944",
        "20,079",
        "7,026",
        "16,696",
        "18,643",
        "18,890",
        "4,292",
        "410,710",
        "13,776",
        "14,700",
        "28,542",
        "254,829",
        "14,554",
        "14,337",
        "1,766",
        "31,865",
        "7,225",
        "6,737",
        "31,993",
        "28,122",
        "4,078",
        "790,646",
        "17,576",
        "2,396",
        "4,626",
        "7,299",
        "13,552",
        "16,702",
        "3,394",
        "21,651",
        "7,784",
        "7,554",
        "8,028",
        "10,383",
        "1,383",
        "10,390",
        "54,880",
        "7,696",
        "7,980",
        "4,738",
        "15,307",
        "21,633",
        "11,531",
        "10,214",
        "6,921",
        "6,007",
        "9,110",
        "3,133",
        "9,258",
        "11,849",
        "11,358",
        "15,231",
        "7,690",
        "71,978",
        "72,373",
        "28,722",
        "10,267",
        "16,391",
        "9,233",
        "2,821",
        "9,553",
        "18,931",
        "7,674",
        "7,773",
        "18,163",
        "61,351",
        "22,039",
        "7,678",
        "9,783",
        "7,746"
      ]
    },
    {
      "datamart_id": 8,
      "semantic_type": [],
      "name": "Number of households",
      "description": "column name: Number of households, dtype: object",
      "named_entity": [
        "736,192",
        "94,454",
        "5,020",
        "102,912",
        "65,369",
        "7,507",
        "7,590",
        "389,908",
        "46,816",
        "225",
        "360,563",
        "179,665",
        "332,655",
        "345,344",
        "106,142",
        "343,561",
        "115,531",
        "4,069",
        "106,997",
        "1,990",
        "257,941",
        "46",
        "263,649",
        "8,058",
        "257,451",
        "8,492",
        "103,780",
        "7,583",
        "335,422",
        "581,120",
        "233,909",
        "13,627",
        "441,955",
        "393",
        "184,788",
        "34,108",
        "4,024",
        "609,377",
        "307,488",
        "66,364",
        "3,234",
        "199,904",
        "34,496",
        "34,774",
        "64,208",
        "66,141",
        "802,606",
        "23,130",
        "103,234",
        "17,966",
        "26,883",
        "19,174",
        "216,304",
        "5,580",
        "10,411",
        "336,028",
        "4,591",
        "116,262",
        "30,923",
        "375,855",
        "17,292",
        "2,504",
        "16,013",
        "241,072",
        "120,521",
        "350",
        "54,746",
        "289,752",
        "7,753",
        "75,755",
        "153,422",
        "12,099",
        "481,263",
        "21,908",
        "230,366",
        "130,754",
        "33,486",
        "22,016",
        "132,442",
        "51,247",
        "37,964",
        "412",
        "384",
        "49,430",
        "497,347",
        "86,337",
        "75,558",
        "164,979",
        "368,184",
        "88,947",
        "42,178",
        "3,261",
        "486,332",
        "122,972",
        "24,071",
        "388",
        "1,035",
        "105,208",
        "374",
        "5,758",
        "59,909",
        "95,398",
        "219,562",
        "8,240",
        "37,589",
        "3,502",
        "26,262",
        "12,760",
        "545,071",
        "9,207",
        "45,630",
        "90,708",
        "37,930",
        "716",
        "179,617",
        "88,460",
        "286,008",
        "36,781",
        "185,483",
        "132,709",
        "67,885",
        "9,647",
        "17,250",
        "154,275",
        "49,431",
        "403,293",
        "347,874",
        "26,820",
        "98,326",
        "58,080",
        "51,403",
        "34,621",
        "54,327",
        "154,324",
        "313,912",
        "280,988",
        "254",
        "8,314",
        "1,643",
        "19,455",
        "191,406",
        "57,262",
        "33",
        "995,512",
        "59,891",
        "11,138",
        "28,503",
        "243,394",
        "17,108",
        "68,880",
        "3,069",
        "11,485",
        "1,438",
        "107,066",
        "206,982",
        "50,644",
        "8,519",
        "25,280",
        "107,830",
        "19,532",
        "41,463",
        "36,927",
        "1,843",
        "5,891",
        "1,034",
        "74,144",
        "62,587",
        "266,069",
        "135,800",
        "411,876",
        "204,771",
        "76,546",
        "36,342",
        "348,627",
        "3,023",
        "123,683",
        "2,666",
        "261,242",
        "1,555",
        "3,542",
        "1,943",
        "41,954",
        "42,312",
        "267,076",
        "163,462",
        "1,007",
        "20,530",
        "117,359",
        "34,703",
        "2,614",
        "526,007",
        "185,660",
        "288,240",
        "146,527",
        "493",
        "243,875",
        "104,145",
        "225,552",
        "3,424",
        "113,637",
        "328,013",
        "3,554",
        "64,417",
        "12,825",
        "366,689",
        "200,739",
        "40,991",
        "303,441",
        "108,852",
        "122,700",
        "170,555",
        "61,012",
        "93,504",
        "753",
        "32,114",
        "277,302",
        "35,588",
        "67,691",
        "6,886",
        "1,354",
        "4,270",
        "1,754",
        "52,053",
        "1,955",
        "3,028",
        "164,944",
        "132,975",
        "164,609",
        "95,286",
        "1,033",
        "7,981",
        "97,622",
        "3,650",
        "12,506",
        "37,928",
        "4,871",
        "808",
        "5,227",
        "526,004",
        "5,295",
        "135,974",
        "403",
        "20,922",
        "299,663",
        "553",
        "7,038",
        "7,498",
        "1,101",
        "11,426",
        "9,103",
        "890",
        "10,439",
        "1,612",
        "41,709",
        "268,722",
        "3,856",
        "56,812",
        "1,053",
        "38,075",
        "21,720",
        "9,544",
        "6,546",
        "1,041",
        "26,017",
        "5,073",
        "409",
        "1,245",
        "201,771",
        "9,434",
        "154,948",
        "4,021",
        "73,213",
        "43,975",
        "5,746",
        "33,096",
        "1,273",
        "25,024",
        "14,362",
        "110,032",
        "2,684",
        "13,560",
        "9,462",
        "121,423",
        "35,111",
        "5,182",
        "65,499",
        "42,322",
        "1,076,483",
        "13,459",
        "122,625",
        "187,941",
        "296",
        "125,317",
        "58,038",
        "4,400",
        "14,624",
        "65,816",
        "25,049",
        "16,682",
        "221,774",
        "305,939",
        "64,016",
        "173,164",
        "69,862",
        "821",
        "1,474",
        "4,527",
        "222,652",
        "87,518",
        "309,803",
        "141,720",
        "28,081",
        "6,992",
        "1,340",
        "606",
        "59,606",
        "1,933,335",
        "143,717",
        "20,947",
        "12,147",
        "10,655",
        "323",
        "29,172",
        "2,319",
        "170,358",
        "20,758",
        "62,836",
        "8,142",
        "64,242",
        "82,807",
        "102,154",
        "1,741",
        "86,052",
        "18,711",
        "22,454",
        "79,421",
        "43,794",
        "31,116",
        "126",
        "52,946",
        "8,997",
        "2,010",
        "4,881",
        "24,661",
        "100,801",
        "13,545",
        "327,914",
        "86,010",
        "9,616",
        "9,701",
        "44,983",
        "76,144",
        "19,889",
        "7,233",
        "54,005",
        "2,529",
        "1,440",
        "33,717",
        "31,123",
        "36,394",
        "52,623",
        "205,395",
        "58,828",
        "2,326",
        "86,934",
        "11,416",
        "46,968",
        "111,276",
        "18,702",
        "7,647",
        "1,949",
        "55,301",
        "9,698",
        "112,189",
        "401,708",
        "30,534",
        "123,142",
        "43,255",
        "108,831",
        "614",
        "15,442",
        "10,050",
        "204,226",
        "30,492",
        "94,048",
        "4,758",
        "6,728",
        "81,293",
        "48,080",
        "7,326",
        "17,378",
        "107,717",
        "4,948",
        "7,148",
        "1,115",
        "67,049",
        "36,973",
        "141,464",
        "28,044",
        "36,997",
        "18,381",
        "1,146",
        "86,504",
        "68,211",
        "14,387",
        "3,757",
        "237,039",
        "19,417",
        "18,216",
        "210,037",
        "15,022",
        "264,496",
        "930",
        "25,003",
        "2,975",
        "73,728",
        "12,072",
        "184,855",
        "3,700",
        "297,040",
        "9,258",
        "18,082",
        "14,164",
        "2,101",
        "27,233",
        "147,529",
        "13,889",
        "163,198",
        "61,502",
        "73,253",
        "65,675",
        "17,808",
        "52,239",
        "5,691",
        "1,199",
        "4,501",
        "25,173",
        "720",
        "36,859",
        "893",
        "1,149",
        "256,745",
        "28,534",
        "4,452",
        "75,892",
        "19,866",
        "84,098",
        "12,334",
        "26,555",
        "6,165",
        "17,599",
        "3,731",
        "2,573",
        "5,071",
        "1,258",
        "58,059",
        "3,468",
        "4,405",
        "468,295",
        "8,890",
        "22,735",
        "659,736",
        "13,801",
        "1,854",
        "1,697",
        "300,623",
        "3,010",
        "5,501",
        "663,458",
        "14,535",
        "4,304",
        "69,572",
        "38,287",
        "82,756",
        "1,192",
        "181,100",
        "3,193",
        "167,592",
        "1,113",
        "26,071",
        "6,098",
        "4,826",
        "3,679",
        "29,948",
        "14,817",
        "6,745",
        "733",
        "654",
        "152,109",
        "5,268",
        "54,428",
        "4,641",
        "1,510",
        "1,798",
        "3,074",
        "17,614",
        "380,152",
        "21,391",
        "12,381",
        "9,867",
        "1,262",
        "305,832",
        "133,289",
        "19,569",
        "1,097",
        "4,119",
        "1,434,694",
        "44,018",
        "827",
        "4,982",
        "1,431",
        "30,458",
        "16,941",
        "42,800",
        "6,353",
        "11,801",
        "220,375",
        "3,328",
        "17,989",
        "14,051",
        "3,342",
        "24,355",
        "2,621",
        "4,152",
        "60,835",
        "10,997",
        "98,962",
        "61,023",
        "2,624",
        "3,230,383",
        "70,347",
        "1,445",
        "15,757",
        "6,614",
        "61,800",
        "21,581",
        "1,634",
        "6,092",
        "2,686",
        "158,855",
        "241,915",
        "3,482",
        "34,655",
        "12,621",
        "6,293",
        "2,232",
        "3,501",
        "7,017",
        "53,079",
        "4,322",
        "6,919",
        "2,638",
        "11,230",
        "41,876",
        "1,789",
        "64,568",
        "167,422",
        "43,507",
        "1,699",
        "1,895",
        "10,597",
        "29,158",
        "2,311",
        "1,951",
        "37,307",
        "15,069",
        "11,540",
        "151,600",
        "3,820",
        "7,873",
        "5,217",
        "45,776",
        "534,476",
        "38,409",
        "153,720",
        "107,238",
        "18,616",
        "101,091",
        "3,283",
        "16,039",
        "32,693",
        "4,469",
        "30,041",
        "8,873",
        "241,531",
        "14,262",
        "8,506",
        "24,270",
        "1,305",
        "1,104",
        "131,197",
        "29,440",
        "5,024",
        "19,967",
        "11,962",
        "38,141",
        "8,698",
        "17,443",
        "14,354",
        "1,411,727",
        "15,157",
        "20,202",
        "135,496",
        "9,779",
        "855",
        "29,087",
        "84,833",
        "1,734",
        "7,832",
        "3,084",
        "760",
        "10,046",
        "1,482",
        "162,543",
        "10,574",
        "471,340",
        "75,087",
        "115,237",
        "15,590",
        "39,929",
        "6,671",
        "20,393",
        "5,375",
        "3,306",
        "52,023",
        "2,471",
        "45,293",
        "14,640",
        "18,556",
        "21,332",
        "13,544",
        "19,543",
        "15,797",
        "15,469",
        "8,187",
        "9,999",
        "54,309",
        "27,465",
        "26,358",
        "4,655",
        "220,277",
        "40,723",
        "6,897",
        "7,238",
        "7,186",
        "2,343",
        "989",
        "13,046",
        "68,140",
        "970",
        "9,834",
        "10,667",
        "35,203",
        "4,435",
        "5,998",
        "2,965",
        "1,912",
        "47,164",
        "2,061",
        "96,701",
        "2,804",
        "76,444",
        "167,251",
        "259,634",
        "3,120",
        "53,223",
        "1,224",
        "65,649",
        "103,742",
        "17,120",
        "56,459",
        "57,368",
        "3,808",
        "2,416",
        "1,099",
        "47,600",
        "4,080",
        "2,337",
        "14,716",
        "647",
        "858,332",
        "263,135",
        "134,612",
        "1,726",
        "1,045",
        "4,036",
        "2,576",
        "2,485",
        "73,283",
        "8,063",
        "46,912",
        "18,547",
        "332,818",
        "4,222",
        "517,243",
        "33,384",
        "31,547",
        "153,897",
        "64,009",
        "3,488",
        "82,150",
        "836",
        "13,998",
        "6,802",
        "58,598",
        "11,083",
        "12,192",
        "6,230",
        "2,580",
        "9,908",
        "22,390",
        "175,149",
        "20,745",
        "1,178",
        "9,610",
        "10,079",
        "6,716",
        "2,408",
        "20,163",
        "882",
        "12,820",
        "43,362",
        "15,919",
        "67,805",
        "10,820",
        "7,665",
        "285,320",
        "86,483",
        "2,238",
        "140,439",
        "435",
        "55,960",
        "79,314",
        "26,963",
        "6,314",
        "62,560",
        "2,186",
        "148,398",
        "194,082",
        "778,630",
        "8,797",
        "59,468",
        "196,463",
        "8,948",
        "60,456",
        "7,809",
        "1,436",
        "24,356",
        "13,386",
        "5,083",
        "67,623",
        "1,006",
        "2,793",
        "41,267",
        "9,773",
        "21,678",
        "43,398",
        "3,642",
        "20,357",
        "5,354",
        "49,086",
        "5,882",
        "8,457",
        "16,234",
        "1,727",
        "237,800",
        "70,545",
        "7,421",
        "1,473",
        "2,860",
        "2,121",
        "19,069",
        "45,949",
        "40,447",
        "21,186",
        "7,129",
        "70,867",
        "37,366",
        "10,636",
        "21,058",
        "102,885",
        "1,201",
        "45,142",
        "2,187",
        "4,234",
        "710,058",
        "4,074",
        "25,754",
        "3,969",
        "2,850",
        "110,377",
        "549",
        "15,067",
        "3,197",
        "46,409",
        "5,996",
        "1,051",
        "29,302",
        "100,838",
        "330,897",
        "30,610",
        "2,283",
        "31,972",
        "18,553",
        "46,312",
        "3,885",
        "754",
        "2,937",
        "2,108",
        "344,089",
        "4,358",
        "1,398",
        "56,737",
        "6,400",
        "271,545",
        "10,393",
        "6,404",
        "72,584",
        "18,173",
        "6,134",
        "95,238",
        "116,705",
        "10,083",
        "1,429",
        "3,439",
        "2,347",
        "5,093",
        "88,376",
        "25,206",
        "35,196",
        "5,021",
        "20,008",
        "41,287",
        "32,037",
        "27,037",
        "21,388",
        "6,077",
        "85,238",
        "22,025",
        "15,701",
        "58,702",
        "648",
        "6,513",
        "266,952",
        "465",
        "2,342",
        "16,995",
        "3,202",
        "379",
        "27,220",
        "229,373",
        "17,938",
        "10,615",
        "3,182",
        "4,216",
        "30,814",
        "6,438",
        "9,121",
        "36,460",
        "36,449",
        "22,639",
        "6,245",
        "5,889",
        "5,367",
        "34,067",
        "177,990",
        "4,457",
        "4,648",
        "330",
        "11,491",
        "12,663",
        "36,901",
        "6,090",
        "3,519",
        "25,621",
        "7,602",
        "1,589",
        "5,733",
        "51,719",
        "4,356",
        "45,523",
        "143,874",
        "2,048",
        "100,072",
        "807",
        "18,266",
        "1,364",
        "4,315",
        "8,615",
        "58,273",
        "3,529",
        "7,328",
        "10,680",
        "79,137",
        "44,257",
        "18,365",
        "261",
        "3,248",
        "15,749",
        "45,246",
        "13,230",
        "9,288",
        "20,487",
        "51,016",
        "187,572",
        "6,402",
        "6,507",
        "9,234",
        "18,012",
        "4,445",
        "78,459",
        "32,137",
        "3,580",
        "14,927",
        "192,651",
        "5,374",
        "85,769",
        "2,242",
        "15,890",
        "11,566",
        "12,578",
        "3,295",
        "20,633",
        "3,227",
        "29,994",
        "343,517",
        "57,197",
        "2,066",
        "2,274",
        "394",
        "5,935",
        "847",
        "27,999",
        "7,290",
        "58,875",
        "13,860",
        "13,022",
        "12,691",
        "90,465",
        "8,752",
        "2,444",
        "13,476",
        "8,685",
        "5,651",
        "6,081",
        "2,422",
        "8,626",
        "611",
        "1,308",
        "1,314",
        "13,504",
        "3,461",
        "23,884",
        "932",
        "24,476",
        "36,405",
        "6,964",
        "6,240",
        "94,666",
        "41,503",
        "22,299",
        "41,239",
        "5,066",
        "8,405",
        "51,771",
        "169",
        "60,992",
        "35,622",
        "1,282",
        "36,399",
        "18,241",
        "1,573",
        "883",
        "7,488",
        "6,794",
        "69,211",
        "4,135",
        "6,691",
        "69,238",
        "12,749",
        "916,025",
        "39,754",
        "12,906",
        "8,145",
        "138,212",
        "8,001",
        "6,189",
        "384,041",
        "3,001",
        "1,086",
        "4,345",
        "354",
        "8,422",
        "64,713",
        "52,511",
        "7,130",
        "2,041",
        "26,565",
        "7,731",
        "3,776",
        "2,618",
        "11,806",
        "2,899",
        "52,330",
        "20,913",
        "14,466",
        "2,855",
        "91,349",
        "8,144",
        "57,979",
        "7,061",
        "2,685",
        "29,652",
        "17,397",
        "18,933",
        "6,078",
        "4,462",
        "1,411",
        "22,755",
        "91,075",
        "8,089",
        "4,808",
        "11,892",
        "3,786",
        "6,622",
        "102,484",
        "96,731",
        "46,246",
        "7,707",
        "6,331",
        "8,042",
        "22,610",
        "3,948",
        "4,860",
        "16,410",
        "3,079",
        "31,794",
        "11,745",
        "16,588",
        "222,578",
        "1,253",
        "15,855",
        "2,019",
        "88,844",
        "27,975",
        "29,531",
        "34,922",
        "14,446",
        "1,936",
        "7,741",
        "22,173",
        "11,974",
        "7,786",
        "5,862",
        "7,382",
        "495",
        "14,826",
        "7,974",
        "29,705",
        "8,670",
        "689",
        "415,790",
        "27,016",
        "25,903",
        "1,830",
        "96,043",
        "58,524",
        "7,348",
        "401",
        "8,820",
        "1,369",
        "79,763",
        "7,682",
        "2,916",
        "17,705",
        "17,830",
        "52,044",
        "1,014",
        "35,072",
        "130,880",
        "80,812",
        "6,558",
        "1,078",
        "3,327",
        "3,301",
        "125,428",
        "16,285",
        "12,671",
        "63,388",
        "15,257",
        "108,823",
        "10,495",
        "241,455",
        "2,448",
        "39,263",
        "31,162",
        "9,425",
        "33,430",
        "9,253",
        "1,269",
        "321",
        "31,311",
        "32,072",
        "8,038",
        "12,572",
        "55,679",
        "3,317",
        "2,503",
        "31,901",
        "12,513",
        "85,557",
        "9,058",
        "19,254",
        "2,676",
        "2,178",
        "3,316",
        "64,909",
        "24,456",
        "4,738",
        "13,094",
        "8,788",
        "11,432",
        "6,445",
        "8,471",
        "13,867",
        "7,007",
        "15,221",
        "2,240",
        "5,062",
        "625",
        "33,173",
        "20,071",
        "1,748",
        "1,641",
        "30,548",
        "23,358",
        "3,981",
        "9,133",
        "3,159",
        "5,806",
        "22,463",
        "4,117",
        "8,735",
        "26,608",
        "7,995",
        "19,530",
        "23,370",
        "14,498",
        "4,389",
        "6,395",
        "1,076",
        "3,361",
        "3,407",
        "666",
        "5,777",
        "67,561",
        "35,647",
        "3,822",
        "50,321",
        "113,449",
        "8,479",
        "10,384",
        "17,163",
        "2,113",
        "17,171",
        "9,602",
        "15,359",
        "150,003",
        "3,401",
        "44,006",
        "23,115",
        "3,357",
        "10,848",
        "13,789",
        "4,924",
        "28,239",
        "16,993",
        "42,413",
        "83,140",
        "73,963",
        "9,731",
        "3,085",
        "14,531",
        "64,379",
        "73,726",
        "8,079",
        "13,926",
        "14,042",
        "2,972",
        "11,623",
        "2,994",
        "42,502",
        "9,818",
        "27,874",
        "98,554",
        "7,711",
        "11,924",
        "6,568",
        "379,637",
        "11,824",
        "34,138",
        "3,884",
        "52,276",
        "4,381",
        "2,421",
        "10,904",
        "39,931",
        "879",
        "664",
        "16,019",
        "604,698",
        "49,962",
        "3,311",
        "144,912",
        "12,477",
        "26,912",
        "1,683",
        "15,458",
        "2,693",
        "152,803",
        "10,992",
        "109,675",
        "117,250",
        "17,257",
        "23,508",
        "1,529",
        "3,904",
        "7,684",
        "6,349",
        "47,881",
        "24,499",
        "65,392",
        "24,078",
        "6,773",
        "8,323",
        "15,851",
        "3,077",
        "679",
        "39,401",
        "41,794",
        "5,364",
        "8,745",
        "3,924",
        "2,218",
        "360,072",
        "5,273",
        "15,350",
        "39,279",
        "3,970",
        "4,785",
        "63,309",
        "758",
        "8,551",
        "18,862",
        "3,613",
        "34,544",
        "45,292",
        "578",
        "3,059",
        "35,569",
        "15,425",
        "18,311",
        "3,223",
        "7,343",
        "14,611",
        "60,414",
        "19,558",
        "46,559",
        "113,490",
        "3,832",
        "7,012",
        "4,601",
        "14,875",
        "24,092",
        "13,514",
        "98,201",
        "195,907",
        "10,355",
        "1,983",
        "1,870",
        "7,755",
        "332",
        "22,117",
        "182,080",
        "14,138",
        "4,986",
        "32,684",
        "30,106",
        "7,845",
        "62,608",
        "9,366",
        "178,101",
        "50,007",
        "22,583",
        "2,647",
        "51,433",
        "31,353",
        "1,375",
        "2,863",
        "2,369",
        "28,324",
        "44,240",
        "19,167",
        "66,239",
        "22,611",
        "1,011",
        "3,319",
        "1,651",
        "4,630",
        "24,136",
        "21,677",
        "5,437",
        "7,663",
        "11,007",
        "877",
        "44,127",
        "2,764",
        "26,436",
        "9,073",
        "48,728",
        "84,816",
        "5,676",
        "9,932",
        "41,245",
        "13,287",
        "105,277",
        "2,388",
        "2,348",
        "2,349",
        "46,192",
        "13,981",
        "13,416",
        "3,686",
        "29,411",
        "477",
        "8,818",
        "13,478",
        "182,707",
        "7,509",
        "5,146",
        "6,776",
        "6,948",
        "8,101",
        "42,286",
        "1,745",
        "2,737",
        "37,844",
        "66,667",
        "1,414",
        "1,534",
        "4,425",
        "26,225",
        "19,844",
        "1,343",
        "123,915",
        "68,980",
        "24,213",
        "9,541",
        "28,525",
        "3,056",
        "10,491",
        "839",
        "40,144",
        "61,220",
        "7,984",
        "13,117",
        "5,803",
        "2,709",
        "46,295",
        "3,138",
        "6,620",
        "49,174",
        "26,819",
        "31,725",
        "683,144",
        "2,644",
        "12,491",
        "3,886",
        "3,779",
        "15,042",
        "3,633",
        "39,602",
        "18,573",
        "1,366",
        "34,789",
        "10,688",
        "16,571",
        "53,296",
        "20,254",
        "115,574",
        "1,067",
        "38,458",
        "101,947",
        "55,864",
        "1,102",
        "19,762",
        "17,245",
        "6,415",
        "25,029",
        "6,453",
        "7,167",
        "6,605",
        "5,255",
        "5,149",
        "3,672",
        "29,317",
        "14,421",
        "17,543",
        "4,802",
        "111,689",
        "7,511",
        "7,289",
        "18,957",
        "5,212",
        "26,815",
        "19,703",
        "11,477",
        "6,850",
        "6,874",
        "8,328",
        "13,260",
        "8,374",
        "3,736",
        "46,198",
        "25,693",
        "7,870",
        "22,168",
        "18,820",
        "438",
        "16,238",
        "22,147",
        "7,893",
        "15,014",
        "19,408",
        "11,006",
        "6,569",
        "10,194",
        "25,432",
        "19,168",
        "2,074",
        "2,953",
        "4,732",
        "39,250",
        "27,599",
        "33,878",
        "4,044",
        "42,494",
        "106,060",
        "35,713",
        "2,530",
        "38,654",
        "767",
        "79,214",
        "10,562",
        "12,890",
        "1,681",
        "21,293",
        "14,499",
        "1,884",
        "6,855",
        "23,415",
        "92,634",
        "7,120",
        "1,065",
        "58,533",
        "21,774",
        "2,545",
        "22,593",
        "1,893",
        "49,294",
        "17,388",
        "14,690",
        "11,656",
        "25,052",
        "15,340",
        "10,657",
        "5,965",
        "6,310",
        "1,037",
        "6,373",
        "12,470",
        "18,069",
        "2,818",
        "828,031",
        "16,548",
        "39,881",
        "5,484",
        "60,139",
        "1,927",
        "938",
        "60,319",
        "2,147",
        "49,304",
        "36,690",
        "37,834",
        "1,454",
        "2,336",
        "2,996",
        "15,800",
        "4,391",
        "45,325",
        "2,511",
        "5,357",
        "13,429",
        "79,525",
        "11,979",
        "1,232",
        "14,397",
        "45,011",
        "12,244",
        "8,991",
        "3,914",
        "121,226",
        "3,029",
        "6,925",
        "42,487",
        "21,574",
        "3,444",
        "140,652",
        "7,883",
        "10,286",
        "1,986",
        "17,690",
        "17,647",
        "8,761",
        "53,914",
        "66,026",
        "6,163",
        "11,617",
        "1,966",
        "59,658",
        "5,339",
        "26,496",
        "46,046",
        "9,909",
        "53,428",
        "8,758",
        "9,110",
        "940",
        "12,224",
        "37,677",
        "1,218",
        "4,184",
        "25,895",
        "10,677",
        "2,248",
        "34,310",
        "10,455",
        "2,402",
        "7,235",
        "33,808",
        "36,823",
        "49,016",
        "5,668",
        "7,615",
        "16,586",
        "7,865",
        "10,312",
        "1,800",
        "9,550",
        "9,902",
        "37,726",
        "780",
        "1,969",
        "18,143",
        "7,251",
        "6,466",
        "8,708",
        "4,110",
        "16,848",
        "4,553",
        "5,846",
        "104,049",
        "72,243",
        "5,201",
        "16,448",
        "42,690",
        "1,174",
        "9,612",
        "7,354",
        "46,187",
        "16,032",
        "29,520",
        "2,595",
        "4,146",
        "9,968",
        "305",
        "23,906",
        "345",
        "2,303",
        "16,538",
        "11,442",
        "2,528",
        "6,253",
        "3,935",
        "54,963",
        "32,144",
        "12,216",
        "6,300",
        "2,144",
        "18,787",
        "14,399",
        "1,304",
        "19,663",
        "15,203",
        "14,926",
        "4,863",
        "7,730",
        "233",
        "3,161",
        "27,485",
        "1,518",
        "14,333",
        "10,571",
        "18,386",
        "15,624",
        "14,534",
        "1,706",
        "7,493",
        "19,345",
        "10,235",
        "11,790",
        "14,590",
        "72,253",
        "1,492",
        "3,646",
        "58,208",
        "79,450",
        "36,066",
        "1,817",
        "14,241",
        "24,084",
        "67,882",
        "5,168",
        "5,000",
        "18,145",
        "17,058",
        "2,487",
        "15,288",
        "60,100",
        "4,160",
        "2,602",
        "7,964",
        "215,563",
        "21,765",
        "8,015",
        "12,680",
        "16,713",
        "86,246",
        "7,077",
        "2,380",
        "64,580",
        "6,772",
        "2,037",
        "11,459",
        "7,063",
        "50,676",
        "748",
        "20,776",
        "12,948",
        "155,178",
        "16,222",
        "3,811",
        "2,031",
        "21,126",
        "14,286",
        "559",
        "5,619",
        "39,348",
        "15,885",
        "13,976",
        "10,236",
        "2,119",
        "3,583",
        "1,767",
        "6,708",
        "51,332",
        "17,450",
        "15,284",
        "13,601",
        "60,759",
        "16,067",
        "37,754",
        "8,703",
        "9,551",
        "9,904",
        "9,284",
        "11,963",
        "14,793",
        "64,026",
        "165,669",
        "28,329",
        "1,186",
        "44,251",
        "18,404",
        "9,623",
        "18,512",
        "77,412",
        "30,756",
        "22,045",
        "1,715",
        "10,787",
        "26,296",
        "28,326",
        "14,941",
        "2,800",
        "14,610",
        "670,987",
        "5,790",
        "11,043",
        "19,953",
        "40,552",
        "1,301",
        "1,571",
        "6,277",
        "5,486",
        "580,017",
        "3,938",
        "4,861",
        "6,997",
        "15,062",
        "20,198",
        "22,361",
        "5,134",
        "2,302",
        "15,725",
        "18,281",
        "11,100",
        "527",
        "4,354",
        "36,815",
        "26,072",
        "13,473",
        "12,894",
        "3,268",
        "8,019",
        "9,175",
        "12,940",
        "2,425",
        "29,527",
        "3,115",
        "18,357",
        "10,221",
        "41,839",
        "8,278",
        "29,791",
        "6,140",
        "7,396",
        "5,992",
        "18,592",
        "54,863",
        "18,756",
        "15,086",
        "3,586",
        "9,141",
        "9,628",
        "3,308",
        "18,495",
        "2,589",
        "47,606",
        "3,294",
        "13,907",
        "6,991",
        "19,829",
        "21,481",
        "864",
        "12,098",
        "73,296",
        "4,431",
        "21,651",
        "8,464",
        "3,512",
        "2,215",
        "7,180",
        "18,714",
        "22,547",
        "10,761",
        "11,788",
        "3,566",
        "3,855",
        "32,246",
        "6,053",
        "3,903",
        "11,172",
        "9,792",
        "14,465",
        "15,969",
        "3,749",
        "838",
        "113,285",
        "29,732",
        "134,002",
        "1,714",
        "1,890",
        "17,684",
        "7,973",
        "11,889",
        "21,046",
        "36,149",
        "18,456",
        "33,331",
        "12,899",
        "4,565",
        "4,232",
        "20,207",
        "62,439",
        "949",
        "17,581",
        "48,458",
        "2,094",
        "7,001",
        "6,008",
        "19,064",
        "57,551",
        "6,216",
        "11,203",
        "1,280",
        "1,665",
        "15,776",
        "17,722",
        "107,350",
        "13,256",
        "15,893",
        "5,121",
        "43,846",
        "20,909",
        "2,442",
        "2,427",
        "3,046",
        "8,112",
        "1,544",
        "18,046",
        "31,364",
        "6,972",
        "6,168",
        "464",
        "27,396",
        "14,417",
        "7,769",
        "6,086",
        "13,438",
        "31,484",
        "31,898",
        "29,632",
        "34,390",
        "11,107",
        "1,517",
        "3,018",
        "19,278",
        "4,015",
        "8,571",
        "34,831",
        "8,388",
        "2,228",
        "13,320",
        "28,374",
        "4,007",
        "16,207",
        "70,239",
        "15,409",
        "6,852",
        "8,872",
        "775",
        "5,851",
        "19,420",
        "5,292",
        "14,827",
        "23,941",
        "6,325",
        "14,383",
        "166,883",
        "84,862",
        "2,457",
        "6,903",
        "37,603",
        "5,058",
        "17,772",
        "2,179",
        "19,266",
        "12,515",
        "9,248",
        "9,559",
        "16,781",
        "508",
        "13,303",
        "7,037",
        "5,534",
        "3,825",
        "7,122",
        "10,174",
        "7,882",
        "10,429",
        "14,254",
        "3,269",
        "26,092",
        "6,853",
        "19,238",
        "42,095",
        "22,260",
        "30,597",
        "47,330",
        "1,707",
        "20,092",
        "18,647",
        "10,270",
        "4,049",
        "26,505",
        "943",
        "4,286",
        "6,258",
        "50,637",
        "12,668",
        "8,124",
        "11,829",
        "12,414",
        "21,692",
        "44,722",
        "2,034",
        "240",
        "5,289",
        "1,339",
        "2,122",
        "5,781",
        "14,937",
        "27,378",
        "6,111",
        "9,692",
        "33,840",
        "4,993",
        "3,743",
        "17,655",
        "17,411",
        "2,727",
        "10,230",
        "46,826",
        "19,416",
        "1,828",
        "12,697",
        "2,345",
        "21,204",
        "10,963",
        "24,441",
        "3,320",
        "22,890",
        "28,556",
        "16,373",
        "7,179",
        "1,548",
        "11,160",
        "11,758",
        "70,210",
        "12,532",
        "6,455",
        "23,313",
        "11,226",
        "18,148",
        "2,654",
        "15,743",
        "5,574",
        "23,413",
        "6,139",
        "3,794",
        "10,631",
        "24,009",
        "18,294",
        "14,947",
        "29,809",
        "5,601",
        "6,302",
        "15,440",
        "18,155",
        "13,338",
        "603,879",
        "14,000",
        "30,271",
        "8,552",
        "11,513",
        "2,747",
        "18,969",
        "28,308",
        "18,503",
        "5,132",
        "15,320",
        "219,540",
        "10,294",
        "32,192",
        "44,418",
        "24,315",
        "40,945",
        "18,027",
        "3,274",
        "9,330",
        "1,565",
        "13,405",
        "39,494",
        "8,221",
        "31,575",
        "6,341",
        "7,423",
        "28,433",
        "15,100",
        "16,624",
        "16,380",
        "12,703",
        "4,067",
        "3,983",
        "39,597",
        "4,459",
        "5,347",
        "43,971",
        "13,395",
        "11,192",
        "6,451",
        "16,699",
        "11,576",
        "6,508",
        "7,263",
        "23,764",
        "3,709",
        "11,634",
        "3,734",
        "3,050",
        "9,781",
        "6,872",
        "44,849",
        "6,775",
        "28,185",
        "70,130",
        "16,589",
        "37,693",
        "709",
        "60,071",
        "7,941",
        "27,004",
        "14,738",
        "6,832",
        "4,104",
        "791",
        "11,478",
        "6,204",
        "34,567",
        "3,882",
        "4,854",
        "15,609",
        "5,660",
        "6,430",
        "28,956",
        "1,022",
        "5,091",
        "30,668",
        "56,585",
        "18,786",
        "15,370",
        "31,690",
        "23,178",
        "1,724",
        "2,501",
        "25,658",
        "7,411",
        "14,770",
        "3,252",
        "52,300",
        "123,733",
        "10,999",
        "12,462",
        "5,616",
        "10,342",
        "2,728",
        "3,590",
        "2,774",
        "54,363",
        "2,943",
        "8,880",
        "2,853",
        "30,010",
        "26,191",
        "3,113",
        "15,747",
        "479",
        "46,325",
        "6,878",
        "11,839",
        "12,650",
        "26,744",
        "80,230",
        "45,196",
        "15,169",
        "14,209",
        "14,903",
        "20,601",
        "23,046",
        "33,976",
        "143,005",
        "21,211",
        "31,342",
        "13,036",
        "9,108",
        "14,419",
        "1,361",
        "17,193",
        "11,578",
        "295",
        "15,980",
        "21,108",
        "2,692",
        "1,668",
        "16,596",
        "16,329",
        "3,712",
        "16,232",
        "25,751",
        "605",
        "10,446",
        "5,065",
        "2,967",
        "26,108",
        "3,741",
        "23,348",
        "4,830",
        "9,555",
        "502",
        "3,394",
        "11,019",
        "16,950",
        "16,877",
        "24,578",
        "18,156",
        "3,346",
        "10,609",
        "65,008",
        "19,797",
        "1,581",
        "10,827",
        "11,514",
        "5,145",
        "6,618",
        "14,605",
        "28,166",
        "1,423",
        "15,896",
        "913",
        "12,473",
        "22,326",
        "5,383",
        "4,722",
        "4,620",
        "2,105",
        "5,505",
        "20,556",
        "1,532",
        "15,690",
        "3,509",
        "5,893",
        "23,567",
        "14,495",
        "72,281",
        "16,575",
        "54,350",
        "28,980",
        "3,386",
        "26,981",
        "23,108",
        "4,237",
        "34,646",
        "5,714",
        "20,765",
        "8,914",
        "13,210",
        "4,022",
        "3,739",
        "13,728",
        "2,884",
        "10,930",
        "1,736",
        "87,844",
        "14,101",
        "23,374",
        "10,168",
        "9,936",
        "4,865",
        "4,261",
        "5,051",
        "19,205",
        "16,110",
        "15,041",
        "25,641",
        "8,766",
        "34,250",
        "17,642",
        "5,161",
        "3,694",
        "10,009",
        "10,895",
        "7,776",
        "1,915",
        "23,586",
        "21,019",
        "39,373",
        "11,814",
        "5,150",
        "4,563",
        "6,269",
        "3,497",
        "7,070",
        "5,830",
        "17,466",
        "5,232",
        "5,518",
        "5,190",
        "1,271",
        "1,056",
        "13,714",
        "40,677",
        "14,517",
        "18,367",
        "8,848",
        "255,271",
        "5,648",
        "14,544",
        "6,638",
        "2,749",
        "6,740",
        "2,797",
        "7,035",
        "7,278",
        "9,408",
        "3,545",
        "13,095",
        "6,323",
        "2,374",
        "4,588",
        "3,815",
        "3,818",
        "20,698",
        "29,967",
        "7,842",
        "289,811",
        "22,152",
        "40,217",
        "491",
        "18,176",
        "10,945",
        "3,888",
        "15,095",
        "4,449",
        "13,382",
        "3,901",
        "7,309",
        "1,575",
        "12,127",
        "458",
        "3,955",
        "7,764",
        "7,601",
        "1,929",
        "8,774",
        "3,598",
        "9,934",
        "10,632",
        "26,609",
        "4,151",
        "11,836",
        "35,375",
        "10,859",
        "37,760",
        "6,389",
        "2,951",
        "4,949",
        "2,613",
        "12,620",
        "8,154",
        "6,363",
        "3,175",
        "304",
        "4,099",
        "14,783",
        "38,952",
        "11,869",
        "6,970",
        "11,766",
        "11,103",
        "3,770",
        "17,377",
        "857",
        "4,101",
        "3,767",
        "246",
        "4,248",
        "11,010",
        "15,862",
        "9,732",
        "9,945",
        "3,791",
        "22,931",
        "22,603",
        "3,378",
        "22,527",
        "1,660",
        "8,207",
        "14,699",
        "5,995",
        "4,497",
        "3,151",
        "5,315",
        "23,945",
        "4,144",
        "26,802",
        "2,419",
        "42,751",
        "1,629",
        "8,216",
        "22,690",
        "4,294",
        "4,480",
        "9,013",
        "8,334",
        "5,305",
        "5,603",
        "28,677",
        "3,569",
        "10,806",
        "13,170",
        "11,180",
        "22,997",
        "14,029",
        "3,462",
        "8,964",
        "25,899",
        "6,820",
        "8,656",
        "23,569",
        "15,124",
        "2,375",
        "2,328",
        "16,584",
        "20,313",
        "24,844",
        "30,012",
        "2,411",
        "27,822",
        "11,191",
        "7,999",
        "2,056",
        "7,020",
        "3,607",
        "8,225",
        "7,982",
        "12,959",
        "2,488",
        "16,212",
        "2,588",
        "1,845",
        "34,664",
        "9,327",
        "21,142",
        "2,458",
        "11,593",
        "18,309",
        "4,128",
        "16,603",
        "17,523",
        "6,934",
        "8,998",
        "11,504",
        "5,368",
        "18,659",
        "26,894",
        "8,224",
        "5,221",
        "6,994",
        "11,163",
        "3,551",
        "5,970",
        "7,936",
        "12,700",
        "13,045",
        "73,797",
        "13,912",
        "27,214",
        "13,797",
        "15,366",
        "4,148",
        "24,677",
        "2,058",
        "11,937",
        "4,793",
        "23,445",
        "9,011",
        "16,980",
        "34,450",
        "16,555",
        "23,499",
        "13,464",
        "2,958",
        "4,766",
        "23,336",
        "23,368",
        "4,549",
        "3,515",
        "5,586",
        "4,130",
        "5,464",
        "2,097",
        "9,154",
        "6,737",
        "9,449",
        "29,452",
        "1,926",
        "79,679",
        "9,525",
        "4,269",
        "2,112",
        "8,532",
        "2,515",
        "31,486",
        "6,573",
        "13,288",
        "4,776",
        "2,230",
        "1,557",
        "30,935",
        "4,789",
        "10,034",
        "13,793",
        "20,416",
        "11,833",
        "10,725",
        "28,367",
        "7,929",
        "26,362",
        "16,918",
        "5,636",
        "5,673",
        "15,536",
        "7,470",
        "2,597",
        "5,140",
        "3,936",
        "23,604",
        "3,215",
        "5,539",
        "16,402",
        "41,358",
        "13,722",
        "12,231",
        "2,640",
        "21,758",
        "10,322",
        "5,162",
        "9,648",
        "4,050",
        "17,085",
        "24,300",
        "5,945",
        "8,179",
        "31,417",
        "1,805",
        "10,319",
        "19,066",
        "4,475",
        "6,534",
        "8,056",
        "9,940",
        "14,256",
        "25,184",
        "14,679",
        "10,912",
        "249",
        "6,769",
        "8,069",
        "7,146",
        "9,897",
        "15,406",
        "4,126",
        "8,092",
        "7,889",
        "3,070",
        "8,061",
        "1,129",
        "7,427",
        "9,593",
        "24,817",
        "8,233",
        "2,456",
        "1,829",
        "11,854",
        "3,191",
        "27,512",
        "6,084",
        "3,873",
        "2,995",
        "7,340",
        "24,079",
        "7,429",
        "5,052",
        "90,413",
        "8,764",
        "8,715",
        "1,177",
        "5,527",
        "9,489",
        "9,537",
        "9,631",
        "10,733",
        "5,589",
        "23,400",
        "3,478",
        "4,321",
        "2,164",
        "57,291",
        "16,938",
        "12,096",
        "4,935",
        "12,456",
        "4,324",
        "13,691",
        "17,252",
        "8,105",
        "1,579",
        "11,241",
        "14,805",
        "5,883",
        "39,722",
        "4,713",
        "12,437",
        "14,650",
        "7,244",
        "7,368",
        "10,610",
        "7,931",
        "8,416",
        "7,846",
        "8,099",
        "4,883",
        "3,106",
        "13,460",
        "70,122",
        "14,787",
        "7,635",
        "433",
        "8,135",
        "7,674",
        "5,936",
        "9,560",
        "5,969",
        "17,422",
        "6,393",
        "9,708",
        "9,444",
        "5,056",
        "14,905",
        "4,362",
        "4,751",
        "4,161",
        "16,161",
        "9,536",
        "6,048",
        "4,797",
        "4,803",
        "4,084",
        "3,496",
        "10,310",
        "7,099",
        "5,208",
        "6,818",
        "3,622",
        "3,275",
        "5,649",
        "10,829",
        "2,358",
        "5,638",
        "7,619",
        "2,710",
        "6,559",
        "5,165",
        "5,780",
        "17,632",
        "16,338",
        "35,661",
        "2,744",
        "3,195",
        "6,308",
        "25,254",
        "12,553",
        "16,875",
        "1,106",
        "5,871",
        "9,937",
        "7,688",
        "9,227",
        "7,851",
        "5,414",
        "24,654",
        "5,858",
        "4,900",
        "3,423",
        "6,814",
        "2,480",
        "16,378",
        "6,956",
        "4,506",
        "8,472",
        "1,606",
        "6,892",
        "2,738",
        "2,664",
        "5,892",
        "7,104",
        "15,712",
        "40,785",
        "9,736",
        "7,185",
        "9,485",
        "2,148",
        "1,837",
        "4,493",
        "8,846",
        "255,573",
        "9,101",
        "28,047",
        "4,325",
        "5,552",
        "4,212",
        "8,815",
        "10,722",
        "7,643",
        "14,645",
        "12,134",
        "11,022",
        "9,786",
        "15,582",
        "7,750",
        "4,920",
        "871",
        "2,426",
        "20,762",
        "10,816",
        "8,618",
        "10,801",
        "6,352",
        "3,277",
        "9,729",
        "2,091",
        "7,036",
        "8,832",
        "14,614",
        "75,409",
        "474,842",
        "13,960",
        "2,291",
        "1,773",
        "6,443",
        "24,923",
        "13,215",
        "18,412",
        "3,737",
        "5,124",
        "9,809",
        "9,985",
        "8,186",
        "3,016",
        "8,859",
        "5,329",
        "7,213",
        "5,191",
        "8,987",
        "12,368",
        "3,020",
        "8,599",
        "7,015",
        "11,928",
        "6,305",
        "10,525",
        "3,781",
        "3,141",
        "5,682",
        "3,013",
        "11,967",
        "2,035",
        "15,332",
        "11,624",
        "12,882",
        "1,189",
        "4,495",
        "13,050",
        "10,341",
        "8,813",
        "3,861",
        "2,246",
        "5,823",
        "8,341",
        "86,274",
        "21,550",
        "3,928",
        "3,476",
        "8,164",
        "9,003",
        "1,127",
        "11,435",
        "8,143",
        "8,604",
        "16,640",
        "131,642",
        "3,507",
        "2,208",
        "2,604",
        "11,493",
        "6,099",
        "2,590",
        "9,370",
        "15,082",
        "8,624",
        "42,516",
        "4,574",
        "4,032",
        "5,303",
        "15,435",
        "2,586",
        "7,781",
        "7,653",
        "12,999",
        "4,034",
        "2,046",
        "63,442",
        "7,704",
        "4,350",
        "4,750",
        "8,857",
        "7,455",
        "6,043",
        "10,570",
        "15,422",
        "6,093",
        "9,199",
        "34,180",
        "2,568",
        "5,509",
        "4,414",
        "12,690",
        "15,078",
        "177",
        "884",
        "4,572",
        "4,150",
        "16,662",
        "13,078",
        "3,166",
        "8,925",
        "4,030",
        "3,354",
        "12,087",
        "6,191",
        "16,244",
        "7,119",
        "5,726",
        "8,619",
        "3,000",
        "7,043",
        "14,917",
        "2,237",
        "7,091",
        "7,406",
        "5,350",
        "15,796",
        "8,235",
        "5,135",
        "8,533",
        "8,296",
        "1,039",
        "7,241",
        "4,219",
        "8,563",
        "5,975",
        "4,139",
        "817",
        "2,778",
        "4,603",
        "3,099",
        "7,115",
        "10,171",
        "3,725",
        "16,173",
        "18,254",
        "3,348",
        "4,063",
        "3,187",
        "2,722",
        "7,453",
        "1,173",
        "4,483",
        "7,676",
        "12,467",
        "2,049",
        "3,919",
        "11,031",
        "5,817",
        "4,841",
        "7,926",
        "17,622",
        "22,052",
        "8,206",
        "4,083",
        "7,270",
        "2,050",
        "3,727",
        "7,629",
        "8,305",
        "3,681",
        "8,026",
        "7,496",
        "7,672",
        "5,944",
        "14,497",
        "15,918",
        "22,181",
        "1,374",
        "8,544",
        "2,682",
        "7,917",
        "21,021",
        "570",
        "5,738",
        "3,393",
        "6,550",
        "9,369",
        "3,264",
        "6,941",
        "3,281",
        "3,220",
        "6,130",
        "8,539",
        "6,808",
        "3,351",
        "8,339",
        "9,200",
        "8,107",
        "15,959",
        "3,250",
        "3,960",
        "5,402",
        "7,040",
        "48,099",
        "9,686",
        "8,419",
        "3,435",
        "3,296",
        "7,023",
        "1,195",
        "10,482",
        "4,460",
        "18,123",
        "9,653",
        "1,480",
        "4,401",
        "3,769",
        "34,343",
        "9,611",
        "3,704",
        "13,681",
        "4,510",
        "12,049",
        "1,617",
        "4,246",
        "5,600",
        "6,921",
        "12,301",
        "3,185",
        "14,092",
        "5,829",
        "7,642",
        "4,206",
        "5,544",
        "5,178",
        "8,083",
        "3,389",
        "4,447",
        "10,136",
        "20,558",
        "4,657",
        "1,059",
        "2,305",
        "11,343",
        "4,697",
        "4,895",
        "4,096",
        "5,516",
        "1,588",
        "2,616",
        "7,881",
        "11,223",
        "5,003",
        "8,016",
        "8,862",
        "5,826",
        "9,457",
        "5,745",
        "3,843",
        "6,580",
        "13,172",
        "2,758",
        "3,911",
        "2,379",
        "2,748",
        "5,712",
        "4,805",
        "1,382",
        "698",
        "8,333",
        "4,556",
        "1,725",
        "9,464",
        "9,290",
        "8,131",
        "5,359",
        "13,047",
        "6,541",
        "4,994",
        "4,194",
        "6,050",
        "1,687",
        "4,116",
        "6,739",
        "4,229",
        "9,358",
        "1,116",
        "7,463",
        "45,154",
        "7,885",
        "4,730",
        "159",
        "10,323",
        "4,931",
        "8,046",
        "11,109",
        "10,622",
        "1,873",
        "4,188",
        "11,744",
        "8,690",
        "1,804",
        "11,621",
        "5,641",
        "1,709",
        "6,220",
        "7,295",
        "1,220",
        "117,836",
        "5,290",
        "4,696",
        "67,372",
        "5,133",
        "704",
        "12,350",
        "2,439",
        "2,835",
        "10,887",
        "8,710",
        "1,185",
        "217,691",
        "6,110",
        "1,260",
        "2,779",
        "5,060",
        "4,872",
        "1,096",
        "8,229",
        "3,114",
        "4,887",
        "3,605",
        "461",
        "3,400",
        "15,714",
        "2,001",
        "1,721",
        "3,807",
        "4,068",
        "7,317",
        "3,866",
        "1,864",
        "1,851",
        "2,705",
        "1,235",
        "3,107",
        "3,654",
        "4,640",
        "2,520",
        "19,055",
        "17,427",
        "8,394",
        "3,491",
        "5,567",
        "2,742",
        "803",
        "3,190",
        "6,511",
        "2,201",
        "6,312",
        "15,949",
        "542",
        "5,499",
        "1,744",
        "2,680",
        "2,096",
        "2,867"
      ],
      "temporal_coverage": {
        "start": "0100-05-07T00:00:00",
        "end": "2068-04-07T00:00:00"
      }
    },
    {
      "datamart_id": 9,
      "semantic_type": [],
      "name": "County-equivalent_link",
      "description": "column name: County-equivalent_link, dtype: object",
      "named_entity": [
        "https://en.wikipedia.org/wiki/Manhattan",
        "https://en.wikipedia.org/wiki/Arlington_County,_Virginia",
        "https://en.wikipedia.org/wiki/Falls_Church,_Virginia",
        "https://en.wikipedia.org/wiki/Marin_County,_California",
        "https://en.wikipedia.org/wiki/Alexandria,_Virginia",
        "https://en.wikipedia.org/wiki/Pitkin_County,_Colorado",
        "https://en.wikipedia.org/wiki/Los_Alamos_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Fairfax_County,_Virginia",
        "https://en.wikipedia.org/wiki/Hunterdon_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Borden_County,_Texas",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Maryland",
        "https://en.wikipedia.org/wiki/Morris_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Fairfield_County,_Connecticut",
        "https://en.wikipedia.org/wiki/San_Francisco",
        "https://en.wikipedia.org/wiki/Howard_County,_Maryland",
        "https://en.wikipedia.org/wiki/Westchester_County,_New_York",
        "https://en.wikipedia.org/wiki/Somerset_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Nantucket",
        "https://en.wikipedia.org/wiki/Loudoun_County,_Virginia",
        "https://en.wikipedia.org/wiki/North_Slope_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/San_Mateo_County,_California",
        "https://en.wikipedia.org/wiki/Kalawao_County,_Hawaii",
        "https://en.wikipedia.org/wiki/Washington,_D.C.",
        "https://en.wikipedia.org/wiki/Goochland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Norfolk_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Fairfax,_Virginia",
        "https://en.wikipedia.org/wiki/Douglas_County,_Colorado",
        "https://en.wikipedia.org/wiki/Teton_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Bergen_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Middlesex_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Monmouth_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Summit_County,_Utah",
        "https://en.wikipedia.org/wiki/Nassau_County,_New_York",
        "https://en.wikipedia.org/wiki/Mineral_County,_Colorado",
        "https://en.wikipedia.org/wiki/Chester_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Ozaukee_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Clear_Creek_County,_Colorado",
        "https://en.wikipedia.org/wiki/Santa_Clara_County,_California",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Williamson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/San_Miguel_County,_Colorado",
        "https://en.wikipedia.org/wiki/Anne_Arundel_County,_Maryland",
        "https://en.wikipedia.org/wiki/Putnam_County,_New_York",
        "https://en.wikipedia.org/wiki/Newport_County,_Rhode_Island",
        "https://en.wikipedia.org/wiki/Delaware_County,_Ohio",
        "https://en.wikipedia.org/wiki/Middlesex_County,_Connecticut",
        "https://en.wikipedia.org/wiki/King_County,_Washington",
        "https://en.wikipedia.org/wiki/Fauquier_County,_Virginia",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Indiana",
        "https://en.wikipedia.org/wiki/Eagle_County,_Colorado",
        "https://en.wikipedia.org/wiki/James_City_County,_Virginia",
        "https://en.wikipedia.org/wiki/Bristol_County,_Rhode_Island",
        "https://en.wikipedia.org/wiki/Johnson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Clarke_County,_Virginia",
        "https://en.wikipedia.org/wiki/Williams_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/DuPage_County,_Illinois",
        "https://en.wikipedia.org/wiki/Poquoson,_Virginia",
        "https://en.wikipedia.org/wiki/Rockingham_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Calvert_County,_Maryland",
        "https://en.wikipedia.org/wiki/Contra_Costa_County,_California",
        "https://en.wikipedia.org/wiki/Queen_Anne%27s_County,_Maryland",
        "https://en.wikipedia.org/wiki/Gilpin_County,_Colorado",
        "https://en.wikipedia.org/wiki/Talbot_County,_Maryland",
        "https://en.wikipedia.org/wiki/Lake_County,_Illinois",
        "https://en.wikipedia.org/wiki/Boulder_County,_Colorado",
        "https://en.wikipedia.org/wiki/Billings_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Sussex_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Collin_County,_Texas",
        "https://en.wikipedia.org/wiki/San_Juan_County,_Washington",
        "https://en.wikipedia.org/wiki/Litchfield_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Waukesha_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Juneau,_Alaska",
        "https://en.wikipedia.org/wiki/Hennepin_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Boone_County,_Indiana",
        "https://en.wikipedia.org/wiki/Bucks_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Mercer_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Carver_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Broomfield_County,_Colorado",
        "https://en.wikipedia.org/wiki/Prince_William_County,_Virginia",
        "https://en.wikipedia.org/wiki/Charles_County,_Maryland",
        "https://en.wikipedia.org/wiki/Albemarle_County,_Virginia",
        "https://en.wikipedia.org/wiki/Skagway,_Alaska",
        "https://en.wikipedia.org/wiki/Bristol_Bay_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Washington_County,_Rhode_Island",
        "https://en.wikipedia.org/wiki/Suffolk_County,_New_York",
        "https://en.wikipedia.org/wiki/Frederick_County,_Maryland",
        "https://en.wikipedia.org/wiki/St._Johns_County,_Florida",
        "https://en.wikipedia.org/wiki/Burlington_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Fulton_County,_Georgia",
        "https://en.wikipedia.org/wiki/Washington_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Stafford_County,_Virginia",
        "https://en.wikipedia.org/wiki/Rappahannock_County,_Virginia",
        "https://en.wikipedia.org/wiki/Oakland_County,_Michigan",
        "https://en.wikipedia.org/wiki/Collier_County,_Florida",
        "https://en.wikipedia.org/wiki/York_County,_Virginia",
        "https://en.wikipedia.org/wiki/Hinsdale_County,_Colorado",
        "https://en.wikipedia.org/wiki/Divide_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Anchorage,_Alaska",
        "https://en.wikipedia.org/wiki/Roberts_County,_Texas",
        "https://en.wikipedia.org/wiki/Union_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Carroll_County,_Maryland",
        "https://en.wikipedia.org/wiki/Barnstable_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Colorado",
        "https://en.wikipedia.org/wiki/Elbert_County,_Colorado",
        "https://en.wikipedia.org/wiki/St._Mary%27s_County,_Maryland",
        "https://en.wikipedia.org/wiki/Sublette_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Dallas_County,_Iowa",
        "https://en.wikipedia.org/wiki/Kendall_County,_Texas",
        "https://en.wikipedia.org/wiki/Alameda_County,_California",
        "https://en.wikipedia.org/wiki/Blaine_County,_Idaho",
        "https://en.wikipedia.org/wiki/Scott_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Harford_County,_Maryland",
        "https://en.wikipedia.org/wiki/Fayette_County,_Georgia",
        "https://en.wikipedia.org/wiki/Denali_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Plymouth_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Saratoga_County,_New_York",
        "https://en.wikipedia.org/wiki/Essex_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Platte_County,_Missouri",
        "https://en.wikipedia.org/wiki/Union_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Placer_County,_California",
        "https://en.wikipedia.org/wiki/El_Dorado_County,_California",
        "https://en.wikipedia.org/wiki/Routt_County,_Colorado",
        "https://en.wikipedia.org/wiki/Lincoln_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Dakota_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Napa_County,_California",
        "https://en.wikipedia.org/wiki/St._Louis_County,_Missouri",
        "https://en.wikipedia.org/wiki/Hartford_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Rockwall_County,_Texas",
        "https://en.wikipedia.org/wiki/Rockland_County,_New_York",
        "https://en.wikipedia.org/wiki/Forsyth_County,_Georgia",
        "https://en.wikipedia.org/wiki/Orange_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Geauga_County,_Ohio",
        "https://en.wikipedia.org/wiki/Tolland_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Hillsborough_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Baltimore_County,_Maryland",
        "https://en.wikipedia.org/wiki/Middlesex_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Yakutat,_Alaska",
        "https://en.wikipedia.org/wiki/King_George_County,_Virginia",
        "https://en.wikipedia.org/wiki/Petersburg_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Douglas_County,_Nevada",
        "https://en.wikipedia.org/wiki/Fort_Bend_County,_Texas",
        "https://en.wikipedia.org/wiki/Olmsted_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Loving_County,_Texas",
        "https://en.wikipedia.org/wiki/Orange_County,_California",
        "https://en.wikipedia.org/wiki/Martin_County,_Florida",
        "https://en.wikipedia.org/wiki/Summit_County,_Colorado",
        "https://en.wikipedia.org/wiki/Monroe_County,_Florida",
        "https://en.wikipedia.org/wiki/Denton_County,_Texas",
        "https://en.wikipedia.org/wiki/Campbell_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Kent_County,_Rhode_Island",
        "https://en.wikipedia.org/wiki/Mountrail_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Oconee_County,_Georgia",
        "https://en.wikipedia.org/wiki/Dunn_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/New_London_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Dane_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Midland_County,_Texas",
        "https://en.wikipedia.org/wiki/Llano_County,_Texas",
        "https://en.wikipedia.org/wiki/Columbia_County,_New_York",
        "https://en.wikipedia.org/wiki/Dutchess_County,_New_York",
        "https://en.wikipedia.org/wiki/Oldham_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Warren_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Hanover_County,_Virginia",
        "https://en.wikipedia.org/wiki/Storey_County,_Nevada",
        "https://en.wikipedia.org/wiki/Dukes_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Towner_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Shelby_County,_Alabama",
        "https://en.wikipedia.org/wiki/Chittenden_County,_Vermont",
        "https://en.wikipedia.org/wiki/Denver",
        "https://en.wikipedia.org/wiki/Washtenaw_County,_Michigan",
        "https://en.wikipedia.org/wiki/Travis_County,_Texas",
        "https://en.wikipedia.org/wiki/Delaware_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Warren_County,_Ohio",
        "https://en.wikipedia.org/wiki/Madison_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Wake_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Grand_Isle_County,_Vermont",
        "https://en.wikipedia.org/wiki/Henrico_County,_Virginia",
        "https://en.wikipedia.org/wiki/McKenzie_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Cobb_County,_Georgia",
        "https://en.wikipedia.org/wiki/Foster_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Madison_County,_Montana",
        "https://en.wikipedia.org/wiki/Ouray_County,_Colorado",
        "https://en.wikipedia.org/wiki/Comal_County,_Texas",
        "https://en.wikipedia.org/wiki/Cape_May_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Ventura_County,_California",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Texas",
        "https://en.wikipedia.org/wiki/Burke_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Worcester_County,_Maryland",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Maine",
        "https://en.wikipedia.org/wiki/Burleigh_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Cook_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Palm_Beach_County,_Florida",
        "https://en.wikipedia.org/wiki/Sonoma_County,_California",
        "https://en.wikipedia.org/wiki/Suffolk_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Clackamas_County,_Oregon",
        "https://en.wikipedia.org/wiki/Greeley_County,_Kansas",
        "https://en.wikipedia.org/wiki/Hudson_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Gloucester_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Arapahoe_County,_Colorado",
        "https://en.wikipedia.org/wiki/Valdez%E2%80%93Cordova_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Chesterfield_County,_Virginia",
        "https://en.wikipedia.org/wiki/New_Haven_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Sitka,_Alaska",
        "https://en.wikipedia.org/wiki/Beaufort_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Botetourt_County,_Virginia",
        "https://en.wikipedia.org/wiki/Mecklenburg_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/New_Castle_County,_Delaware",
        "https://en.wikipedia.org/wiki/Nevada_County,_California",
        "https://en.wikipedia.org/wiki/Prince_George%27s_County,_Maryland",
        "https://en.wikipedia.org/wiki/McHenry_County,_Illinois",
        "https://en.wikipedia.org/wiki/Albany_County,_New_York",
        "https://en.wikipedia.org/wiki/Sarasota_County,_Florida",
        "https://en.wikipedia.org/wiki/Santa_Fe_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Santa_Cruz_County,_California",
        "https://en.wikipedia.org/wiki/Oliver_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/St._Croix_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Essex_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Fairbanks_North_Star_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Livingston_County,_Michigan",
        "https://en.wikipedia.org/wiki/New_Kent_County,_Virginia",
        "https://en.wikipedia.org/wiki/Bowman_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Richland_County,_Montana",
        "https://en.wikipedia.org/wiki/Cavalier_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Washington_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/LaMoure_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Bottineau_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Virginia_Beach,_Virginia",
        "https://en.wikipedia.org/wiki/Madison_County,_Alabama",
        "https://en.wikipedia.org/wiki/Staten_Island",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Aleutians_West_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Dickinson_County,_Iowa",
        "https://en.wikipedia.org/wiki/Kitsap_County,_Washington",
        "https://en.wikipedia.org/wiki/Mercer_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Monroe_County,_Illinois",
        "https://en.wikipedia.org/wiki/Roanoke_County,_Virginia",
        "https://en.wikipedia.org/wiki/Barnes_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Lane_County,_Kansas",
        "https://en.wikipedia.org/wiki/Grand_County,_Colorado",
        "https://en.wikipedia.org/wiki/Allegheny_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Ketchikan_Gateway_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/St._Charles_County,_Missouri",
        "https://en.wikipedia.org/wiki/Terrell_County,_Texas",
        "https://en.wikipedia.org/wiki/Carroll_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Worcester_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Sioux_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Park_County,_Colorado",
        "https://en.wikipedia.org/wiki/Kent_County,_Maryland",
        "https://en.wikipedia.org/wiki/Adams_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Harris_County,_Georgia",
        "https://en.wikipedia.org/wiki/Leelanau_County,_Michigan",
        "https://en.wikipedia.org/wiki/Steele_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Daniels_County,_Montana",
        "https://en.wikipedia.org/wiki/Stark_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Sheridan_County,_Montana",
        "https://en.wikipedia.org/wiki/Spotsylvania_County,_Virginia",
        "https://en.wikipedia.org/wiki/Snohomish_County,_Washington",
        "https://en.wikipedia.org/wiki/Mathews_County,_Virginia",
        "https://en.wikipedia.org/wiki/Merrimack_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Miner_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Kendall_County,_Illinois",
        "https://en.wikipedia.org/wiki/Kenai_Peninsula_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Powhatan_County,_Virginia",
        "https://en.wikipedia.org/wiki/Piatt_County,_Illinois",
        "https://en.wikipedia.org/wiki/Renville_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Chatham_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Grundy_County,_Iowa",
        "https://en.wikipedia.org/wiki/Glasscock_County,_Texas",
        "https://en.wikipedia.org/wiki/Haines_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Washington_County,_Oregon",
        "https://en.wikipedia.org/wiki/Teller_County,_Colorado",
        "https://en.wikipedia.org/wiki/Williamson_County,_Texas",
        "https://en.wikipedia.org/wiki/McLean_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Butler_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Columbia_County,_Georgia",
        "https://en.wikipedia.org/wiki/Converse_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Island_County,_Washington",
        "https://en.wikipedia.org/wiki/Stanley_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Windsor_County,_Vermont",
        "https://en.wikipedia.org/wiki/Woodford_County,_Illinois",
        "https://en.wikipedia.org/wiki/Galveston_County,_Texas",
        "https://en.wikipedia.org/wiki/Audubon_County,_Iowa",
        "https://en.wikipedia.org/wiki/Isle_of_Wight_County,_Virginia",
        "https://en.wikipedia.org/wiki/Fluvanna_County,_Virginia",
        "https://en.wikipedia.org/wiki/Larimer_County,_Colorado",
        "https://en.wikipedia.org/wiki/Grafton_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Lancaster_County,_Virginia",
        "https://en.wikipedia.org/wiki/Medina_County,_Ohio",
        "https://en.wikipedia.org/wiki/Parker_County,_Texas",
        "https://en.wikipedia.org/wiki/San_Diego_County,_California",
        "https://en.wikipedia.org/wiki/Door_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Anoka_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Camden_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Slope_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Orange_County,_New_York",
        "https://en.wikipedia.org/wiki/Indian_River_County,_Florida",
        "https://en.wikipedia.org/wiki/Middlesex_County,_Virginia",
        "https://en.wikipedia.org/wiki/Dare_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Cass_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Belknap_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Sweetwater_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Ocean_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Multnomah_County,_Oregon",
        "https://en.wikipedia.org/wiki/McLean_County,_Illinois",
        "https://en.wikipedia.org/wiki/Polk_County,_Iowa",
        "https://en.wikipedia.org/wiki/Ulster_County,_New_York",
        "https://en.wikipedia.org/wiki/Hodgeman_County,_Kansas",
        "https://en.wikipedia.org/wiki/Nelson_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Montana",
        "https://en.wikipedia.org/wiki/Will_County,_Illinois",
        "https://en.wikipedia.org/wiki/St._Tammany_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Honolulu_County,_Hawaii",
        "https://en.wikipedia.org/wiki/Santa_Barbara_County,_California",
        "https://en.wikipedia.org/wiki/Warren_County,_New_York",
        "https://en.wikipedia.org/wiki/Hughes_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Ness_County,_Kansas",
        "https://en.wikipedia.org/wiki/Sully_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Sarpy_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Cook_County,_Illinois",
        "https://en.wikipedia.org/wiki/Charleston_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/La_Plata_County,_Colorado",
        "https://en.wikipedia.org/wiki/Chambers_County,_Texas",
        "https://en.wikipedia.org/wiki/Gillespie_County,_Texas",
        "https://en.wikipedia.org/wiki/Thomas_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Frederick_County,_Virginia",
        "https://en.wikipedia.org/wiki/Wheeler_County,_Texas",
        "https://en.wikipedia.org/wiki/Kane_County,_Illinois",
        "https://en.wikipedia.org/wiki/Hood_County,_Texas",
        "https://en.wikipedia.org/wiki/Greene_County,_Ohio",
        "https://en.wikipedia.org/wiki/Saunders_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Goliad_County,_Texas",
        "https://en.wikipedia.org/wiki/Rensselaer_County,_New_York",
        "https://en.wikipedia.org/wiki/Sangamon_County,_Illinois",
        "https://en.wikipedia.org/wiki/San_Luis_Obispo_County,_California",
        "https://en.wikipedia.org/wiki/Sargent_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Linn_County,_Iowa",
        "https://en.wikipedia.org/wiki/Goodhue_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Warrick_County,_Indiana",
        "https://en.wikipedia.org/wiki/Chesapeake,_Virginia",
        "https://en.wikipedia.org/wiki/Ontario_County,_New_York",
        "https://en.wikipedia.org/wiki/Natrona_County,_Wyoming",
        "https://en.wikipedia.org/wiki/King_County,_Texas",
        "https://en.wikipedia.org/wiki/Hendricks_County,_Indiana",
        "https://en.wikipedia.org/wiki/Plumas_County,_California",
        "https://en.wikipedia.org/wiki/Lander_County,_Nevada",
        "https://en.wikipedia.org/wiki/Archuleta_County,_Colorado",
        "https://en.wikipedia.org/wiki/Washington_County,_Vermont",
        "https://en.wikipedia.org/wiki/Thurston_County,_Washington",
        "https://en.wikipedia.org/wiki/Emmet_County,_Michigan",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Ohio",
        "https://en.wikipedia.org/wiki/New_Hanover_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Jo_Daviess_County,_Illinois",
        "https://en.wikipedia.org/wiki/Cass_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Wright_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Georgia",
        "https://en.wikipedia.org/wiki/Jefferson_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Montour_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Johnson_County,_Iowa",
        "https://en.wikipedia.org/wiki/Cameron_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Hemphill_County,_Texas",
        "https://en.wikipedia.org/wiki/Midland_County,_Michigan",
        "https://en.wikipedia.org/wiki/Matanuska-Susitna_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Cecil_County,_Maryland",
        "https://en.wikipedia.org/wiki/Maui_County,_Hawaii",
        "https://en.wikipedia.org/wiki/Ramsey_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Hampshire_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Southeast_Fairbanks_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Clay_County,_Missouri",
        "https://en.wikipedia.org/wiki/Morton_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Strafford_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Durham_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Calaveras_County,_California",
        "https://en.wikipedia.org/wiki/Washington_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Wells_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Berkshire_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Woodford_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Northampton_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Pinellas_County,_Florida",
        "https://en.wikipedia.org/wiki/Franklin_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Fayette_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Boone_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Dauphin_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Sheridan_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Bennington_County,_Vermont",
        "https://en.wikipedia.org/wiki/Posey_County,_Indiana",
        "https://en.wikipedia.org/wiki/Douglas_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Suffolk,_Virginia",
        "https://en.wikipedia.org/wiki/Lake_County,_Ohio",
        "https://en.wikipedia.org/wiki/Pope_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Kossuth_County,_Iowa",
        "https://en.wikipedia.org/wiki/York_County,_Maine",
        "https://en.wikipedia.org/wiki/Randall_County,_Texas",
        "https://en.wikipedia.org/wiki/Dodge_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Warren_County,_Iowa",
        "https://en.wikipedia.org/wiki/Brazoria_County,_Texas",
        "https://en.wikipedia.org/wiki/Walsh_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Clay_County,_Iowa",
        "https://en.wikipedia.org/wiki/Lipscomb_County,_Texas",
        "https://en.wikipedia.org/wiki/Scott_County,_Iowa",
        "https://en.wikipedia.org/wiki/Gallatin_County,_Montana",
        "https://en.wikipedia.org/wiki/Solano_County,_California",
        "https://en.wikipedia.org/wiki/Nassau_County,_Florida",
        "https://en.wikipedia.org/wiki/Moore_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Calumet_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Kidder_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Lafayette_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Union_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Warren_County,_Virginia",
        "https://en.wikipedia.org/wiki/Stillwater_County,_Montana",
        "https://en.wikipedia.org/wiki/El_Paso_County,_Colorado",
        "https://en.wikipedia.org/wiki/Windham_County,_Vermont",
        "https://en.wikipedia.org/wiki/Union_County,_Ohio",
        "https://en.wikipedia.org/wiki/Bristol_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Sagadahoc_County,_Maine",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Georgia",
        "https://en.wikipedia.org/wiki/Hoonah%E2%80%93Angoon_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Salem_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Weston_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Clermont_County,_Ohio",
        "https://en.wikipedia.org/wiki/Manassas,_Virginia",
        "https://en.wikipedia.org/wiki/Onondaga_County,_New_York",
        "https://en.wikipedia.org/wiki/Stevens_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Monroe_County,_New_York",
        "https://en.wikipedia.org/wiki/Bremer_County,_Iowa",
        "https://en.wikipedia.org/wiki/Grundy_County,_Illinois",
        "https://en.wikipedia.org/wiki/Addison_County,_Vermont",
        "https://en.wikipedia.org/wiki/Bath_County,_Virginia",
        "https://en.wikipedia.org/wiki/Bedford_County,_Virginia",
        "https://en.wikipedia.org/wiki/Seminole_County,_Florida",
        "https://en.wikipedia.org/wiki/Gloucester_County,_Virginia",
        "https://en.wikipedia.org/wiki/Washoe_County,_Nevada",
        "https://en.wikipedia.org/wiki/Porter_County,_Indiana",
        "https://en.wikipedia.org/wiki/Okaloosa_County,_Florida",
        "https://en.wikipedia.org/wiki/Benton_County,_Washington",
        "https://en.wikipedia.org/wiki/Sullivan_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Johnson_County,_Indiana",
        "https://en.wikipedia.org/wiki/Northumberland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Fallon_County,_Montana",
        "https://en.wikipedia.org/wiki/Kodiak_Island_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Ward_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Powder_River_County,_Montana",
        "https://en.wikipedia.org/wiki/Laramie_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Dundy_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Wrangell,_Alaska",
        "https://en.wikipedia.org/wiki/Davidson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Clinton_County,_Michigan",
        "https://en.wikipedia.org/wiki/Skamania_County,_Washington",
        "https://en.wikipedia.org/wiki/Peoria_County,_Illinois",
        "https://en.wikipedia.org/wiki/Eddy_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Washington_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Miami_County,_Kansas",
        "https://en.wikipedia.org/wiki/Lewis_and_Clark_County,_Montana",
        "https://en.wikipedia.org/wiki/Seward_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Elko_County,_Nevada",
        "https://en.wikipedia.org/wiki/Custer_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/McHenry_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Menard_County,_Illinois",
        "https://en.wikipedia.org/wiki/Douglas_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Schenectady_County,_New_York",
        "https://en.wikipedia.org/wiki/Washakie_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Cheyenne_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Franklin_County,_Ohio",
        "https://en.wikipedia.org/wiki/Wabasha_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Columbia_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Tarrant_County,_Texas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Washington",
        "https://en.wikipedia.org/wiki/Hamilton_County,_New_York",
        "https://en.wikipedia.org/wiki/Chase_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Pierce_County,_Washington",
        "https://en.wikipedia.org/wiki/Crook_County,_Wyoming",
        "https://en.wikipedia.org/wiki/York_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Broward_County,_Florida",
        "https://en.wikipedia.org/wiki/Fayette_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Franklin_County,_Texas",
        "https://en.wikipedia.org/wiki/Outagamie_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Ascension_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Kanawha_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Graham_County,_Kansas",
        "https://en.wikipedia.org/wiki/Knox_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Somervell_County,_Texas",
        "https://en.wikipedia.org/wiki/York_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Grant_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Hancock_County,_Indiana",
        "https://en.wikipedia.org/wiki/O%27Brien_County,_Iowa",
        "https://en.wikipedia.org/wiki/Ramsey_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Johnson_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Sherburne_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Maine",
        "https://en.wikipedia.org/wiki/Iowa_County,_Iowa",
        "https://en.wikipedia.org/wiki/Eureka_County,_Nevada",
        "https://en.wikipedia.org/wiki/Irion_County,_Texas",
        "https://en.wikipedia.org/wiki/Westmoreland_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Mono_County,_California",
        "https://en.wikipedia.org/wiki/Tazewell_County,_Illinois",
        "https://en.wikipedia.org/wiki/Guthrie_County,_Iowa",
        "https://en.wikipedia.org/wiki/Traverse_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Baylor_County,_Texas",
        "https://en.wikipedia.org/wiki/Lac_qui_Parle_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Ottawa_County,_Ohio",
        "https://en.wikipedia.org/wiki/Erie_County,_New_York",
        "https://en.wikipedia.org/wiki/Putnam_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Sheridan_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Plymouth_County,_Iowa",
        "https://en.wikipedia.org/wiki/Perkins_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Lehigh_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Chisago_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Hettinger_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Emmet_County,_Iowa",
        "https://en.wikipedia.org/wiki/Harris_County,_Texas",
        "https://en.wikipedia.org/wiki/Windham_County,_Connecticut",
        "https://en.wikipedia.org/wiki/Logan_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Lake_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Clark_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Cheshire_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/Knox_County,_Maine",
        "https://en.wikipedia.org/wiki/Wilson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Greene_County,_Georgia",
        "https://en.wikipedia.org/wiki/Park_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Summit_County,_Ohio",
        "https://en.wikipedia.org/wiki/Pembina_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Scott_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Clinton_County,_Illinois",
        "https://en.wikipedia.org/wiki/Archer_County,_Texas",
        "https://en.wikipedia.org/wiki/Hancock_County,_Maine",
        "https://en.wikipedia.org/wiki/Kearney_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Brewster_County,_Texas",
        "https://en.wikipedia.org/wiki/Sumner_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Le_Sueur_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Brown_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Yellowstone_County,_Montana",
        "https://en.wikipedia.org/wiki/Spink_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Los_Angeles_County,_California",
        "https://en.wikipedia.org/wiki/Yolo_County,_California",
        "https://en.wikipedia.org/wiki/Sutton_County,_Texas",
        "https://en.wikipedia.org/wiki/Douglas_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Richland_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Kenton_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pike_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Emmons_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Madison_County,_Iowa",
        "https://en.wikipedia.org/wiki/Moody_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Clark_County,_Washington",
        "https://en.wikipedia.org/wiki/Tulsa_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Butler_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Grand_Traverse_County,_Michigan",
        "https://en.wikipedia.org/wiki/Orange_County,_Virginia",
        "https://en.wikipedia.org/wiki/Gunnison_County,_Colorado",
        "https://en.wikipedia.org/wiki/Polk_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Coffey_County,_Kansas",
        "https://en.wikipedia.org/wiki/Colonial_Heights,_Virginia",
        "https://en.wikipedia.org/wiki/Marathon_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Carbon_County,_Montana",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Iowa",
        "https://en.wikipedia.org/wiki/Rio_Blanco_County,_Colorado",
        "https://en.wikipedia.org/wiki/Bryan_County,_Georgia",
        "https://en.wikipedia.org/wiki/Canadian_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Deuel_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Deschutes_County,_Oregon",
        "https://en.wikipedia.org/wiki/East_Baton_Rouge_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Sumter_County,_Florida",
        "https://en.wikipedia.org/wiki/Mason_County,_Texas",
        "https://en.wikipedia.org/wiki/Kimble_County,_Texas",
        "https://en.wikipedia.org/wiki/Lawrence_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Carteret_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Wibaux_County,_Montana",
        "https://en.wikipedia.org/wiki/Kingsbury_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Grant_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Cass_County,_Missouri",
        "https://en.wikipedia.org/wiki/Pierce_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/McPherson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Ada_County,_Idaho",
        "https://en.wikipedia.org/wiki/Murray_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Inyo_County,_California",
        "https://en.wikipedia.org/wiki/Andrews_County,_Texas",
        "https://en.wikipedia.org/wiki/Bossier_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Cuyahoga_County,_Ohio",
        "https://en.wikipedia.org/wiki/Tompkins_County,_New_York",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Madison_County,_Illinois",
        "https://en.wikipedia.org/wiki/Franklin_County,_Vermont",
        "https://en.wikipedia.org/wiki/Atlantic_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Warren_County,_Indiana",
        "https://en.wikipedia.org/wiki/Culpeper_County,_Virginia",
        "https://en.wikipedia.org/wiki/McMullen_County,_Texas",
        "https://en.wikipedia.org/wiki/Rogers_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Jackson_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Bartholomew_County,_Indiana",
        "https://en.wikipedia.org/wiki/Stutsman_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Lee_County,_Florida",
        "https://en.wikipedia.org/wiki/Amador_County,_California",
        "https://en.wikipedia.org/wiki/Dawson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Butler_County,_Kansas",
        "https://en.wikipedia.org/wiki/Roger_Mills_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Eddy_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Manatee_County,_Florida",
        "https://en.wikipedia.org/wiki/Rockingham_County,_Virginia",
        "https://en.wikipedia.org/wiki/Madison_County,_Virginia",
        "https://en.wikipedia.org/wiki/Cerro_Gordo_County,_Iowa",
        "https://en.wikipedia.org/wiki/Orange_County,_Vermont",
        "https://en.wikipedia.org/wiki/Adams_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Yankton_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Charlottesville,_Virginia",
        "https://en.wikipedia.org/wiki/Steele_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Maricopa_County,_Arizona",
        "https://en.wikipedia.org/wiki/Wilson_County,_Texas",
        "https://en.wikipedia.org/wiki/Tioga_County,_New_York",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Fredericksburg,_Virginia",
        "https://en.wikipedia.org/wiki/Deuel_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Griggs_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Floyd_County,_Indiana",
        "https://en.wikipedia.org/wiki/Richmond,_Virginia",
        "https://en.wikipedia.org/wiki/Ellis_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Chaffee_County,_Colorado",
        "https://en.wikipedia.org/wiki/Major_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/McCone_County,_Montana",
        "https://en.wikipedia.org/wiki/Lamoille_County,_Vermont",
        "https://en.wikipedia.org/wiki/Decatur_County,_Kansas",
        "https://en.wikipedia.org/wiki/Passaic_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Boone_County,_Iowa",
        "https://en.wikipedia.org/wiki/Hillsborough_County,_Florida",
        "https://en.wikipedia.org/wiki/Racine_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Lancaster_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Brown_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Walworth_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Carroll_County,_Illinois",
        "https://en.wikipedia.org/wiki/Henry_County,_Illinois",
        "https://en.wikipedia.org/wiki/Mills_County,_Iowa",
        "https://en.wikipedia.org/wiki/Traill_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Lebanon_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Putnam_County,_Illinois",
        "https://en.wikipedia.org/wiki/Skagit_County,_Washington",
        "https://en.wikipedia.org/wiki/Green_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Dearborn_County,_Indiana",
        "https://en.wikipedia.org/wiki/Washington_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Effingham_County,_Illinois",
        "https://en.wikipedia.org/wiki/Loudon_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Oneida_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Shelby_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Buchanan_County,_Iowa",
        "https://en.wikipedia.org/wiki/Fayette_County,_Texas",
        "https://en.wikipedia.org/wiki/Fairfield_County,_Ohio",
        "https://en.wikipedia.org/wiki/Grand_Forks_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Leavenworth_County,_Kansas",
        "https://en.wikipedia.org/wiki/Lake_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Brevard_County,_Florida",
        "https://en.wikipedia.org/wiki/Pennington_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Greene_County,_Virginia",
        "https://en.wikipedia.org/wiki/Mariposa_County,_California",
        "https://en.wikipedia.org/wiki/Young_County,_Texas",
        "https://en.wikipedia.org/wiki/Thayer_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Jeff_Davis_County,_Texas",
        "https://en.wikipedia.org/wiki/Louisa_County,_Virginia",
        "https://en.wikipedia.org/wiki/Winnebago_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Garfield_County,_Washington",
        "https://en.wikipedia.org/wiki/Aransas_County,_Texas",
        "https://en.wikipedia.org/wiki/Charlevoix_County,_Michigan",
        "https://en.wikipedia.org/wiki/Campbell_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Manassas_Park,_Virginia",
        "https://en.wikipedia.org/wiki/King_William_County,_Virginia",
        "https://en.wikipedia.org/wiki/Fremont_County,_Iowa",
        "https://en.wikipedia.org/wiki/Kittson_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Sandoval_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Illinois",
        "https://en.wikipedia.org/wiki/Cleveland_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Mitchell_County,_Kansas",
        "https://en.wikipedia.org/wiki/Sussex_County,_Delaware",
        "https://en.wikipedia.org/wiki/Jefferson_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Alabama",
        "https://en.wikipedia.org/wiki/Thomas_County,_Kansas",
        "https://en.wikipedia.org/wiki/Rankin_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Rawlins_County,_Kansas",
        "https://en.wikipedia.org/wiki/Boone_County,_Missouri",
        "https://en.wikipedia.org/wiki/Lexington_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Kandiyohi_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Hays_County,_Texas",
        "https://en.wikipedia.org/wiki/Santa_Rosa_County,_Florida",
        "https://en.wikipedia.org/wiki/Phelps_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Stark_County,_Illinois",
        "https://en.wikipedia.org/wiki/Sheridan_County,_Kansas",
        "https://en.wikipedia.org/wiki/Brunswick_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Marshall_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Carson_County,_Texas",
        "https://en.wikipedia.org/wiki/McLeod_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Armstrong_County,_Texas",
        "https://en.wikipedia.org/wiki/Dallas_County,_Texas",
        "https://en.wikipedia.org/wiki/Bernalillo_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Butler_County,_Ohio",
        "https://en.wikipedia.org/wiki/Smith_County,_Kansas",
        "https://en.wikipedia.org/wiki/Niobrara_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Blanco_County,_Texas",
        "https://en.wikipedia.org/wiki/Howard_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Baldwin_County,_Alabama",
        "https://en.wikipedia.org/wiki/Jones_County,_Iowa",
        "https://en.wikipedia.org/wiki/Coweta_County,_Georgia",
        "https://en.wikipedia.org/wiki/St._Charles_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Macomb_County,_Michigan",
        "https://en.wikipedia.org/wiki/Humboldt_County,_Iowa",
        "https://en.wikipedia.org/wiki/Sacramento_County,_California",
        "https://en.wikipedia.org/wiki/Benton_County,_Oregon",
        "https://en.wikipedia.org/wiki/Glynn_County,_Georgia",
        "https://en.wikipedia.org/wiki/Berks_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Licking_County,_Ohio",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Benton_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Garden_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Bureau_County,_Illinois",
        "https://en.wikipedia.org/wiki/DeWitt_County,_Illinois",
        "https://en.wikipedia.org/wiki/Mesa_County,_Colorado",
        "https://en.wikipedia.org/wiki/Pickens_County,_Georgia",
        "https://en.wikipedia.org/wiki/Nicollet_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Spencer_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Grant_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Salem,_Virginia",
        "https://en.wikipedia.org/wiki/Kauai_County,_Hawaii",
        "https://en.wikipedia.org/wiki/Greenville_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Ogle_County,_Illinois",
        "https://en.wikipedia.org/wiki/Reagan_County,_Texas",
        "https://en.wikipedia.org/wiki/Iowa_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Benton_County,_Iowa",
        "https://en.wikipedia.org/wiki/Mercer_County,_Illinois",
        "https://en.wikipedia.org/wiki/Ottawa_County,_Kansas",
        "https://en.wikipedia.org/wiki/Garfield_County,_Colorado",
        "https://en.wikipedia.org/wiki/Jerauld_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Schoharie_County,_New_York",
        "https://en.wikipedia.org/wiki/Eaton_County,_Michigan",
        "https://en.wikipedia.org/wiki/Essex_County,_New_York",
        "https://en.wikipedia.org/wiki/Clay_County,_Florida",
        "https://en.wikipedia.org/wiki/Brown_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Cedar_County,_Iowa",
        "https://en.wikipedia.org/wiki/Oklahoma_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/York_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Hot_Springs_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Forsyth_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Aleutians_East_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Washington_County,_Maryland",
        "https://en.wikipedia.org/wiki/Whatcom_County,_Washington",
        "https://en.wikipedia.org/wiki/Crow_Wing_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Panola_County,_Texas",
        "https://en.wikipedia.org/wiki/Humboldt_County,_Nevada",
        "https://en.wikipedia.org/wiki/Kenosha_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/McCook_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Orleans_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lancaster_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Queens",
        "https://en.wikipedia.org/wiki/Martin_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Iredell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Guilford_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Washington_County,_Iowa",
        "https://en.wikipedia.org/wiki/Rock_Island_County,_Illinois",
        "https://en.wikipedia.org/wiki/Houston_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Coke_County,_Texas",
        "https://en.wikipedia.org/wiki/Otter_Tail_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Dorchester_County,_Maryland",
        "https://en.wikipedia.org/wiki/Shelby_County,_Iowa",
        "https://en.wikipedia.org/wiki/Minnehaha_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Highland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Grant_County,_Kansas",
        "https://en.wikipedia.org/wiki/Fond_du_Lac_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Lee_County,_Georgia",
        "https://en.wikipedia.org/wiki/Sac_County,_Iowa",
        "https://en.wikipedia.org/wiki/Lamar_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Douglas_County,_Kansas",
        "https://en.wikipedia.org/wiki/Platte_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Kerr_County,_Texas",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Iowa",
        "https://en.wikipedia.org/wiki/Wood_County,_Ohio",
        "https://en.wikipedia.org/wiki/Washington_County,_Illinois",
        "https://en.wikipedia.org/wiki/Putnam_County,_Georgia",
        "https://en.wikipedia.org/wiki/Davie_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Osborne_County,_Kansas",
        "https://en.wikipedia.org/wiki/Providence_County,_Rhode_Island",
        "https://en.wikipedia.org/wiki/Charlotte_County,_Florida",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Granite_County,_Montana",
        "https://en.wikipedia.org/wiki/Morgan_County,_Utah",
        "https://en.wikipedia.org/wiki/Scott_County,_Kansas",
        "https://en.wikipedia.org/wiki/Columbia_County,_Oregon",
        "https://en.wikipedia.org/wiki/La_Crosse_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Berkeley_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Carson_City,_Nevada",
        "https://en.wikipedia.org/wiki/Delaware_County,_Iowa",
        "https://en.wikipedia.org/wiki/Beaver_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Dubuque_County,_Iowa",
        "https://en.wikipedia.org/wiki/Vilas_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Franklin_County,_Kentucky",
        "https://en.wikipedia.org/wiki/St._Clair_County,_Illinois",
        "https://en.wikipedia.org/wiki/Gove_County,_Kansas",
        "https://en.wikipedia.org/wiki/Macon_County,_Illinois",
        "https://en.wikipedia.org/wiki/Barber_County,_Kansas",
        "https://en.wikipedia.org/wiki/Linn_County,_Kansas",
        "https://en.wikipedia.org/wiki/Clark_County,_Nevada",
        "https://en.wikipedia.org/wiki/Pratt_County,_Kansas",
        "https://en.wikipedia.org/wiki/Rutland_County,_Vermont",
        "https://en.wikipedia.org/wiki/Greene_County,_Iowa",
        "https://en.wikipedia.org/wiki/Charles_City_County,_Virginia",
        "https://en.wikipedia.org/wiki/Leon_County,_Florida",
        "https://en.wikipedia.org/wiki/Hyde_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Worth_County,_Iowa",
        "https://en.wikipedia.org/wiki/Guadalupe_County,_Texas",
        "https://en.wikipedia.org/wiki/Harrison_County,_Iowa",
        "https://en.wikipedia.org/wiki/Potter_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Cole_County,_Missouri",
        "https://en.wikipedia.org/wiki/Buncombe_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Duval_County,_Florida",
        "https://en.wikipedia.org/wiki/Hancock_County,_Ohio",
        "https://en.wikipedia.org/wiki/Ransom_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Erie_County,_Ohio",
        "https://en.wikipedia.org/wiki/Ohio_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Sheboygan_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Dawson_County,_Montana",
        "https://en.wikipedia.org/wiki/Golden_Valley_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Hutchinson_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Beaver_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Salt_Lake_County,_Utah",
        "https://en.wikipedia.org/wiki/Franklin_County,_Iowa",
        "https://en.wikipedia.org/wiki/Franklin_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Stearns_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Renville_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Jackson_County,_Missouri",
        "https://en.wikipedia.org/wiki/Winchester,_Virginia",
        "https://en.wikipedia.org/wiki/Nelson_County,_Virginia",
        "https://en.wikipedia.org/wiki/Shawnee_County,_Kansas",
        "https://en.wikipedia.org/wiki/Perry_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Koochiching_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Davis_County,_Utah",
        "https://en.wikipedia.org/wiki/Lorain_County,_Ohio",
        "https://en.wikipedia.org/wiki/Lyon_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Hand_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Woods_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Big_Stone_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Chippewa_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Niagara_County,_New_York",
        "https://en.wikipedia.org/wiki/Sauk_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Story_County,_Iowa",
        "https://en.wikipedia.org/wiki/Marshall_County,_Illinois",
        "https://en.wikipedia.org/wiki/Clinton_County,_Iowa",
        "https://en.wikipedia.org/wiki/Saline_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Wood_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/McCracken_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Waupaca_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Carbon_County,_Wyoming",
        "https://en.wikipedia.org/wiki/St._Louis_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Tuolumne_County,_California",
        "https://en.wikipedia.org/wiki/Oconto_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Monroe_County,_Michigan",
        "https://en.wikipedia.org/wiki/Jackson_County,_Colorado",
        "https://en.wikipedia.org/wiki/Morgan_County,_Georgia",
        "https://en.wikipedia.org/wiki/Gwinnett_County,_Georgia",
        "https://en.wikipedia.org/wiki/Garfield_County,_Montana",
        "https://en.wikipedia.org/wiki/Walworth_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/San_Benito_County,_California",
        "https://en.wikipedia.org/wiki/Henderson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Wheeler_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Chelan_County,_Washington",
        "https://en.wikipedia.org/wiki/Kent_County,_Michigan",
        "https://en.wikipedia.org/wiki/Boone_County,_Illinois",
        "https://en.wikipedia.org/wiki/Austin_County,_Texas",
        "https://en.wikipedia.org/wiki/Ida_County,_Iowa",
        "https://en.wikipedia.org/wiki/Clay_County,_Texas",
        "https://en.wikipedia.org/wiki/Clallam_County,_Washington",
        "https://en.wikipedia.org/wiki/Otoe_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Currituck_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Pottawattamie_County,_Iowa",
        "https://en.wikipedia.org/wiki/Monongalia_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Walton_County,_Florida",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Brown_County,_Indiana",
        "https://en.wikipedia.org/wiki/Wright_County,_Iowa",
        "https://en.wikipedia.org/wiki/Manitowoc_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Sanborn_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Hampden_County,_Massachusetts",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Washington",
        "https://en.wikipedia.org/wiki/Hancock_County,_Iowa",
        "https://en.wikipedia.org/wiki/Banner_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Barton_County,_Kansas",
        "https://en.wikipedia.org/wiki/Polk_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Flathead_County,_Montana",
        "https://en.wikipedia.org/wiki/Sibley_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Valley_County,_Idaho",
        "https://en.wikipedia.org/wiki/Morgan_County,_Indiana",
        "https://en.wikipedia.org/wiki/Wasatch_County,_Utah",
        "https://en.wikipedia.org/wiki/Edmunds_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Kingfisher_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Kennebec_County,_Maine",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Iowa",
        "https://en.wikipedia.org/wiki/Missoula_County,_Montana",
        "https://en.wikipedia.org/wiki/Richland_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Custer_County,_Colorado",
        "https://en.wikipedia.org/wiki/Kalamazoo_County,_Michigan",
        "https://en.wikipedia.org/wiki/Haakon_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Polk_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Perkins_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Swift_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Plaquemines_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Franklin_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Cedar_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Waseca_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Caroline_County,_Virginia",
        "https://en.wikipedia.org/wiki/Champaign_County,_Illinois",
        "https://en.wikipedia.org/wiki/LaSalle_County,_Illinois",
        "https://en.wikipedia.org/wiki/Greene_County,_New_York",
        "https://en.wikipedia.org/wiki/Harding_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Valley_County,_Montana",
        "https://en.wikipedia.org/wiki/Clatsop_County,_Oregon",
        "https://en.wikipedia.org/wiki/Henderson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Freeborn_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Meeker_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Wise_County,_Texas",
        "https://en.wikipedia.org/wiki/Ellis_County,_Texas",
        "https://en.wikipedia.org/wiki/Spokane_County,_Washington",
        "https://en.wikipedia.org/wiki/Roseau_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Redwood_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Rockbridge_County,_Virginia",
        "https://en.wikipedia.org/wiki/Jessamine_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Watonwan_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Smith_County,_Texas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Camden_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Logan_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Sedgwick_County,_Kansas",
        "https://en.wikipedia.org/wiki/Newton_County,_Indiana",
        "https://en.wikipedia.org/wiki/Lackawanna_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Boone_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Dubois_County,_Indiana",
        "https://en.wikipedia.org/wiki/Codington_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Adams_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Adair_County,_Iowa",
        "https://en.wikipedia.org/wiki/Hardin_County,_Texas",
        "https://en.wikipedia.org/wiki/Pocahontas_County,_Iowa",
        "https://en.wikipedia.org/wiki/Lincoln_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Shelby_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Centre_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Gray_County,_Kansas",
        "https://en.wikipedia.org/wiki/Republic_County,_Kansas",
        "https://en.wikipedia.org/wiki/Alpine_County,_California",
        "https://en.wikipedia.org/wiki/Trigg_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Liberty_County,_Montana",
        "https://en.wikipedia.org/wiki/Augusta_County,_Virginia",
        "https://en.wikipedia.org/wiki/Uinta_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Monroe_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Isanti_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Putnam_County,_Ohio",
        "https://en.wikipedia.org/wiki/Marion_County,_Iowa",
        "https://en.wikipedia.org/wiki/Weld_County,_Colorado",
        "https://en.wikipedia.org/wiki/Jersey_County,_Illinois",
        "https://en.wikipedia.org/wiki/Fillmore_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Becker_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Lincoln_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Ford_County,_Illinois",
        "https://en.wikipedia.org/wiki/Cass_County,_Iowa",
        "https://en.wikipedia.org/wiki/Ohio_County,_Indiana",
        "https://en.wikipedia.org/wiki/Shackelford_County,_Texas",
        "https://en.wikipedia.org/wiki/Carroll_County,_Iowa",
        "https://en.wikipedia.org/wiki/Wallace_County,_Kansas",
        "https://en.wikipedia.org/wiki/McIntosh_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Pawnee_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Lee_County,_Illinois",
        "https://en.wikipedia.org/wiki/Turner_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Genesee_County,_New_York",
        "https://en.wikipedia.org/wiki/Clark_County,_Kansas",
        "https://en.wikipedia.org/wiki/Blue_Earth_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Wicomico_County,_Maryland",
        "https://en.wikipedia.org/wiki/Bayfield_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Meade_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/White_County,_Illinois",
        "https://en.wikipedia.org/wiki/Ottawa_County,_Michigan",
        "https://en.wikipedia.org/wiki/Steuben_County,_New_York",
        "https://en.wikipedia.org/wiki/Rice_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Miami_County,_Ohio",
        "https://en.wikipedia.org/wiki/Decatur_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Bandera_County,_Texas",
        "https://en.wikipedia.org/wiki/Washington_County,_Tennessee",
        "https://en.wikipedia.org/wiki/McPherson_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Portage_County,_Ohio",
        "https://en.wikipedia.org/wiki/Chemung_County,_New_York",
        "https://en.wikipedia.org/wiki/Logan_County,_Kansas",
        "https://en.wikipedia.org/wiki/Wayne_County,_New_York",
        "https://en.wikipedia.org/wiki/Auglaize_County,_Ohio",
        "https://en.wikipedia.org/wiki/Harlan_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Gilliam_County,_Oregon",
        "https://en.wikipedia.org/wiki/Poweshiek_County,_Iowa",
        "https://en.wikipedia.org/wiki/Tama_County,_Iowa",
        "https://en.wikipedia.org/wiki/Newport_News,_Virginia",
        "https://en.wikipedia.org/wiki/Yellow_Medicine_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Andrew_County,_Missouri",
        "https://en.wikipedia.org/wiki/Henry_County,_Georgia",
        "https://en.wikipedia.org/wiki/McClain_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Brooklyn",
        "https://en.wikipedia.org/wiki/Eau_Claire_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Cass_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Kewaunee_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Allen_County,_Indiana",
        "https://en.wikipedia.org/wiki/Green_Lake_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Butler_County,_Iowa",
        "https://en.wikipedia.org/wiki/Pima_County,_Arizona",
        "https://en.wikipedia.org/wiki/Nemaha_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Frontier_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Marshall_County,_Kansas",
        "https://en.wikipedia.org/wiki/Keya_Paha_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Fillmore_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Cabarrus_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Hampton,_Virginia",
        "https://en.wikipedia.org/wiki/Westmoreland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Hamlin_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Madison_County,_New_York",
        "https://en.wikipedia.org/wiki/Crawford_County,_Illinois",
        "https://en.wikipedia.org/wiki/Knox_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Cherry_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Caroline_County,_Maryland",
        "https://en.wikipedia.org/wiki/Burt_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Houston_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Oregon",
        "https://en.wikipedia.org/wiki/Cooke_County,_Texas",
        "https://en.wikipedia.org/wiki/Antelope_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Yavapai_County,_Arizona",
        "https://en.wikipedia.org/wiki/Hood_River_County,_Oregon",
        "https://en.wikipedia.org/wiki/DeSoto_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Hardin_County,_Iowa",
        "https://en.wikipedia.org/wiki/Wilkin_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Christian_County,_Missouri",
        "https://en.wikipedia.org/wiki/Shenandoah_County,_Virginia",
        "https://en.wikipedia.org/wiki/Douglas_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Lee_County,_Texas",
        "https://en.wikipedia.org/wiki/Big_Horn_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Haskell_County,_Kansas",
        "https://en.wikipedia.org/wiki/Washington_County,_Virginia",
        "https://en.wikipedia.org/wiki/Oneida_County,_New_York",
        "https://en.wikipedia.org/wiki/Clinton_County,_Missouri",
        "https://en.wikipedia.org/wiki/Amelia_County,_Virginia",
        "https://en.wikipedia.org/wiki/Iroquois_County,_Illinois",
        "https://en.wikipedia.org/wiki/Keith_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Tipton_County,_Indiana",
        "https://en.wikipedia.org/wiki/Chatham_County,_Georgia",
        "https://en.wikipedia.org/wiki/Rutherford_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Livingston_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Clayton_County,_Iowa",
        "https://en.wikipedia.org/wiki/Faribault_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Winneshiek_County,_Iowa",
        "https://en.wikipedia.org/wiki/Barry_County,_Michigan",
        "https://en.wikipedia.org/wiki/Palo_Alto_County,_Iowa",
        "https://en.wikipedia.org/wiki/Box_Butte_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Muscatine_County,_Iowa",
        "https://en.wikipedia.org/wiki/Lake_County,_Colorado",
        "https://en.wikipedia.org/wiki/Limestone_County,_Alabama",
        "https://en.wikipedia.org/wiki/Trempealeau_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Burnet_County,_Texas",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Ohio",
        "https://en.wikipedia.org/wiki/Sierra_County,_California",
        "https://en.wikipedia.org/wiki/Mower_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Washington_County,_Colorado",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Alabama",
        "https://en.wikipedia.org/wiki/Portage_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Sullivan_County,_New_York",
        "https://en.wikipedia.org/wiki/Kaufman_County,_Texas",
        "https://en.wikipedia.org/wiki/Livingston_County,_Illinois",
        "https://en.wikipedia.org/wiki/Stevens_County,_Kansas",
        "https://en.wikipedia.org/wiki/Aitkin_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Saline_County,_Kansas",
        "https://en.wikipedia.org/wiki/Garrett_County,_Maryland",
        "https://en.wikipedia.org/wiki/St._James_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Allamakee_County,_Iowa",
        "https://en.wikipedia.org/wiki/Woodward_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Carter_County,_Montana",
        "https://en.wikipedia.org/wiki/Jasper_County,_Iowa",
        "https://en.wikipedia.org/wiki/Pottawatomie_County,_Kansas",
        "https://en.wikipedia.org/wiki/Kosciusko_County,_Indiana",
        "https://en.wikipedia.org/wiki/Hubbard_County,_Minnesota",
        "https://en.wikipedia.org/wiki/De_Baca_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Orange_County,_Florida",
        "https://en.wikipedia.org/wiki/Wagoner_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Carbon_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Dewey_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Alachua_County,_Florida",
        "https://en.wikipedia.org/wiki/Kent_County,_Delaware",
        "https://en.wikipedia.org/wiki/Washburn_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Kent_County,_Texas",
        "https://en.wikipedia.org/wiki/West_Baton_Rouge_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Sherman_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Broome_County,_New_York",
        "https://en.wikipedia.org/wiki/Benzie_County,_Michigan",
        "https://en.wikipedia.org/wiki/Pierce_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Buffalo_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Effingham_County,_Georgia",
        "https://en.wikipedia.org/wiki/Johnson_County,_Texas",
        "https://en.wikipedia.org/wiki/Keweenaw_County,_Michigan",
        "https://en.wikipedia.org/wiki/Lafourche_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Luzerne_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Missouri",
        "https://en.wikipedia.org/wiki/Osage_County,_Kansas",
        "https://en.wikipedia.org/wiki/Schleicher_County,_Texas",
        "https://en.wikipedia.org/wiki/Ballard_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Monterey_County,_California",
        "https://en.wikipedia.org/wiki/Fulton_County,_Ohio",
        "https://en.wikipedia.org/wiki/Delta_County,_Colorado",
        "https://en.wikipedia.org/wiki/Aiken_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Albany_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Ingham_County,_Michigan",
        "https://en.wikipedia.org/wiki/Staunton,_Virginia",
        "https://en.wikipedia.org/wiki/Baltimore",
        "https://en.wikipedia.org/wiki/Atchison_County,_Missouri",
        "https://en.wikipedia.org/wiki/Franklin_County,_Missouri",
        "https://en.wikipedia.org/wiki/Orange_County,_Texas",
        "https://en.wikipedia.org/wiki/San_Jacinto_County,_Texas",
        "https://en.wikipedia.org/wiki/Cascade_County,_Montana",
        "https://en.wikipedia.org/wiki/Churchill_County,_Nevada",
        "https://en.wikipedia.org/wiki/Edwards_County,_Kansas",
        "https://en.wikipedia.org/wiki/San_Juan_County,_Colorado",
        "https://en.wikipedia.org/wiki/Cayuga_County,_New_York",
        "https://en.wikipedia.org/wiki/Victoria_County,_Texas",
        "https://en.wikipedia.org/wiki/Montague_County,_Texas",
        "https://en.wikipedia.org/wiki/Warren_County,_Missouri",
        "https://en.wikipedia.org/wiki/Kootenai_County,_Idaho",
        "https://en.wikipedia.org/wiki/Russell_County,_Kansas",
        "https://en.wikipedia.org/wiki/Morris_County,_Kansas",
        "https://en.wikipedia.org/wiki/Clinton_County,_New_York",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Norfolk,_Virginia",
        "https://en.wikipedia.org/wiki/Asotin_County,_Washington",
        "https://en.wikipedia.org/wiki/Macoupin_County,_Illinois",
        "https://en.wikipedia.org/wiki/Osceola_County,_Iowa",
        "https://en.wikipedia.org/wiki/Dickey_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Merrick_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Hawaii_County,_Hawaii",
        "https://en.wikipedia.org/wiki/Chippewa_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Custer_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Whitley_County,_Indiana",
        "https://en.wikipedia.org/wiki/Polk_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Dickinson_County,_Michigan",
        "https://en.wikipedia.org/wiki/Park_County,_Montana",
        "https://en.wikipedia.org/wiki/Davison_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Madison_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Floyd_County,_Iowa",
        "https://en.wikipedia.org/wiki/Dodge_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Prince_of_Wales_%E2%80%93_Hyder_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Moffat_County,_Colorado",
        "https://en.wikipedia.org/wiki/Wheeler_County,_Oregon",
        "https://en.wikipedia.org/wiki/Dodge_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Autauga_County,_Alabama",
        "https://en.wikipedia.org/wiki/Hartley_County,_Texas",
        "https://en.wikipedia.org/wiki/Kimball_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Anderson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Franklin_County,_Virginia",
        "https://en.wikipedia.org/wiki/Monona_County,_Iowa",
        "https://en.wikipedia.org/wiki/Gage_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Grant_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Pennington_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Clay_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Nemaha_County,_Kansas",
        "https://en.wikipedia.org/wiki/Ray_County,_Missouri",
        "https://en.wikipedia.org/wiki/Winnebago_County,_Iowa",
        "https://en.wikipedia.org/wiki/Haywood_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Carroll_County,_Indiana",
        "https://en.wikipedia.org/wiki/Boyd_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Whiteside_County,_Illinois",
        "https://en.wikipedia.org/wiki/Clark_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Mitchell_County,_Iowa",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Iowa",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Kansas",
        "https://en.wikipedia.org/wiki/Monroe_County,_Iowa",
        "https://en.wikipedia.org/wiki/Clay_County,_Kansas",
        "https://en.wikipedia.org/wiki/Rock_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Buffalo_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Bay_County,_Florida",
        "https://en.wikipedia.org/wiki/Flagler_County,_Florida",
        "https://en.wikipedia.org/wiki/Cuming_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Dorchester_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Winnebago_County,_Illinois",
        "https://en.wikipedia.org/wiki/Jackson_County,_Iowa",
        "https://en.wikipedia.org/wiki/Jones_County,_Georgia",
        "https://en.wikipedia.org/wiki/Susquehanna_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Scott_County,_Illinois",
        "https://en.wikipedia.org/wiki/Shelby_County,_Indiana",
        "https://en.wikipedia.org/wiki/Yates_County,_New_York",
        "https://en.wikipedia.org/wiki/Benton_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Stark_County,_Ohio",
        "https://en.wikipedia.org/wiki/Wayne_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Androscoggin_County,_Maine",
        "https://en.wikipedia.org/wiki/Georgetown_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/White_Pine_County,_Nevada",
        "https://en.wikipedia.org/wiki/Prince_George_County,_Virginia",
        "https://en.wikipedia.org/wiki/Carlton_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Fergus_County,_Montana",
        "https://en.wikipedia.org/wiki/Polk_County,_Oregon",
        "https://en.wikipedia.org/wiki/Des_Moines_County,_Iowa",
        "https://en.wikipedia.org/wiki/Faulkner_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Jackson_County,_Oregon",
        "https://en.wikipedia.org/wiki/Vanderburgh_County,_Indiana",
        "https://en.wikipedia.org/wiki/Antrim_County,_Michigan",
        "https://en.wikipedia.org/wiki/Pepin_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Coos_County,_New_Hampshire",
        "https://en.wikipedia.org/wiki/St._Clair_County,_Michigan",
        "https://en.wikipedia.org/wiki/Calcasieu_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Colorado_County,_Texas",
        "https://en.wikipedia.org/wiki/Morgan_County,_Illinois",
        "https://en.wikipedia.org/wiki/Marshall_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Jack_County,_Texas",
        "https://en.wikipedia.org/wiki/Sioux_County,_Iowa",
        "https://en.wikipedia.org/wiki/Boise_County,_Idaho",
        "https://en.wikipedia.org/wiki/Sherman_County,_Oregon",
        "https://en.wikipedia.org/wiki/Clark_County,_Indiana",
        "https://en.wikipedia.org/wiki/Otsego_County,_Michigan",
        "https://en.wikipedia.org/wiki/Bullitt_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Caddo_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lavaca_County,_Texas",
        "https://en.wikipedia.org/wiki/Jasper_County,_Indiana",
        "https://en.wikipedia.org/wiki/Clark_County,_Illinois",
        "https://en.wikipedia.org/wiki/Milwaukee_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Ellis_County,_Kansas",
        "https://en.wikipedia.org/wiki/Yamhill_County,_Oregon",
        "https://en.wikipedia.org/wiki/Howard_County,_Iowa",
        "https://en.wikipedia.org/wiki/Black_Hawk_County,_Iowa",
        "https://en.wikipedia.org/wiki/Louisa_County,_Iowa",
        "https://en.wikipedia.org/wiki/Broadwater_County,_Montana",
        "https://en.wikipedia.org/wiki/Wells_County,_Indiana",
        "https://en.wikipedia.org/wiki/Craven_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Judith_Basin_County,_Montana",
        "https://en.wikipedia.org/wiki/Rich_County,_Utah",
        "https://en.wikipedia.org/wiki/Gibson_County,_Indiana",
        "https://en.wikipedia.org/wiki/Nez_Perce_County,_Idaho",
        "https://en.wikipedia.org/wiki/Bexar_County,_Texas",
        "https://en.wikipedia.org/wiki/Ector_County,_Texas",
        "https://en.wikipedia.org/wiki/Franklin_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Lane_County,_Oregon",
        "https://en.wikipedia.org/wiki/Platte_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Adams_County,_Illinois",
        "https://en.wikipedia.org/wiki/Marshall_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Webster_County,_Iowa",
        "https://en.wikipedia.org/wiki/Wabaunsee_County,_Kansas",
        "https://en.wikipedia.org/wiki/Adams_County,_Colorado",
        "https://en.wikipedia.org/wiki/Wyoming_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Erie_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Lake_County,_Florida",
        "https://en.wikipedia.org/wiki/Warren_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Garfield_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Rush_County,_Kansas",
        "https://en.wikipedia.org/wiki/Jasper_County,_Illinois",
        "https://en.wikipedia.org/wiki/Schuyler_County,_New_York",
        "https://en.wikipedia.org/wiki/Leon_County,_Texas",
        "https://en.wikipedia.org/wiki/Paulding_County,_Georgia",
        "https://en.wikipedia.org/wiki/Washington_County,_New_York",
        "https://en.wikipedia.org/wiki/Berkeley_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Otsego_County,_New_York",
        "https://en.wikipedia.org/wiki/Alleghany_County,_Virginia",
        "https://en.wikipedia.org/wiki/Anderson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Mercer_County,_Ohio",
        "https://en.wikipedia.org/wiki/Kane_County,_Utah",
        "https://en.wikipedia.org/wiki/Campbell_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Hardin_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Allegan_County,_Michigan",
        "https://en.wikipedia.org/wiki/Chickasaw_County,_Iowa",
        "https://en.wikipedia.org/wiki/Mercer_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pipestone_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Holt_County,_Missouri",
        "https://en.wikipedia.org/wiki/Marion_County,_Indiana",
        "https://en.wikipedia.org/wiki/Holt_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Jackson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Marshall_County,_Iowa",
        "https://en.wikipedia.org/wiki/Terrebonne_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Rock_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Wabash_County,_Illinois",
        "https://en.wikipedia.org/wiki/Rock_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Throckmorton_County,_Texas",
        "https://en.wikipedia.org/wiki/Franklin_County,_Indiana",
        "https://en.wikipedia.org/wiki/Itasca_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Carroll_County,_Missouri",
        "https://en.wikipedia.org/wiki/Howard_County,_Indiana",
        "https://en.wikipedia.org/wiki/Gregg_County,_Texas",
        "https://en.wikipedia.org/wiki/Stonewall_County,_Texas",
        "https://en.wikipedia.org/wiki/Huerfano_County,_Colorado",
        "https://en.wikipedia.org/wiki/Wood_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Fremont_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Shelby_County,_Ohio",
        "https://en.wikipedia.org/wiki/Kingman_County,_Kansas",
        "https://en.wikipedia.org/wiki/Beadle_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Madison_County,_Ohio",
        "https://en.wikipedia.org/wiki/Berrien_County,_Michigan",
        "https://en.wikipedia.org/wiki/Wayne_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Grayson_County,_Texas",
        "https://en.wikipedia.org/wiki/Horry_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Lemhi_County,_Idaho",
        "https://en.wikipedia.org/wiki/Bosque_County,_Texas",
        "https://en.wikipedia.org/wiki/Owen_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Virginia",
        "https://en.wikipedia.org/wiki/Livingston_County,_New_York",
        "https://en.wikipedia.org/wiki/Steuben_County,_Indiana",
        "https://en.wikipedia.org/wiki/Mahoning_County,_Ohio",
        "https://en.wikipedia.org/wiki/Volusia_County,_Florida",
        "https://en.wikipedia.org/wiki/Curry_County,_Oregon",
        "https://en.wikipedia.org/wiki/Hansford_County,_Texas",
        "https://en.wikipedia.org/wiki/Custer_County,_Idaho",
        "https://en.wikipedia.org/wiki/Beckham_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Treasure_County,_Montana",
        "https://en.wikipedia.org/wiki/Roane_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lake_County,_Indiana",
        "https://en.wikipedia.org/wiki/Christian_County,_Illinois",
        "https://en.wikipedia.org/wiki/Custer_County,_Montana",
        "https://en.wikipedia.org/wiki/Lapeer_County,_Michigan",
        "https://en.wikipedia.org/wiki/Oconee_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Dickinson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Penobscot_County,_Maine",
        "https://en.wikipedia.org/wiki/Pacific_County,_Washington",
        "https://en.wikipedia.org/wiki/Lucas_County,_Ohio",
        "https://en.wikipedia.org/wiki/Jackson_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Knox_County,_Ohio",
        "https://en.wikipedia.org/wiki/Clay_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Blair_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/St._Clair_County,_Alabama",
        "https://en.wikipedia.org/wiki/Crockett_County,_Texas",
        "https://en.wikipedia.org/wiki/King_and_Queen_County,_Virginia",
        "https://en.wikipedia.org/wiki/Gallatin_County,_Illinois",
        "https://en.wikipedia.org/wiki/Elmore_County,_Alabama",
        "https://en.wikipedia.org/wiki/Warren_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pickaway_County,_Ohio",
        "https://en.wikipedia.org/wiki/Sullivan_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Fulton_County,_New_York",
        "https://en.wikipedia.org/wiki/Greeley_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Grant_County,_Oregon",
        "https://en.wikipedia.org/wiki/Columbia_County,_Washington",
        "https://en.wikipedia.org/wiki/Washita_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Robertson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Walla_Walla_County,_Washington",
        "https://en.wikipedia.org/wiki/Perquimans_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Sawyer_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Uintah_County,_Utah",
        "https://en.wikipedia.org/wiki/Wichita_County,_Kansas",
        "https://en.wikipedia.org/wiki/Bay_County,_Michigan",
        "https://en.wikipedia.org/wiki/Taylor_County,_Iowa",
        "https://en.wikipedia.org/wiki/Marquette_County,_Michigan",
        "https://en.wikipedia.org/wiki/Mahaska_County,_Iowa",
        "https://en.wikipedia.org/wiki/Blount_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Butte_County,_California",
        "https://en.wikipedia.org/wiki/Moultrie_County,_Illinois",
        "https://en.wikipedia.org/wiki/Dinwiddie_County,_Virginia",
        "https://en.wikipedia.org/wiki/Kankakee_County,_Illinois",
        "https://en.wikipedia.org/wiki/Harvey_County,_Kansas",
        "https://en.wikipedia.org/wiki/Lubbock_County,_Texas",
        "https://en.wikipedia.org/wiki/Phillips_County,_Kansas",
        "https://en.wikipedia.org/wiki/Dixon_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Rooks_County,_Kansas",
        "https://en.wikipedia.org/wiki/Morgan_County,_Alabama",
        "https://en.wikipedia.org/wiki/Transylvania_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Morrison_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Colfax_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Cape_Girardeau_County,_Missouri",
        "https://en.wikipedia.org/wiki/Hayes_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Pointe_Coupee_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Elk_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Pasco_County,_Florida",
        "https://en.wikipedia.org/wiki/Douglas_County,_Illinois",
        "https://en.wikipedia.org/wiki/Pamlico_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Price_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/DeWitt_County,_Texas",
        "https://en.wikipedia.org/wiki/Hancock_County,_Illinois",
        "https://en.wikipedia.org/wiki/Tom_Green_County,_Texas",
        "https://en.wikipedia.org/wiki/Adams_County,_Iowa",
        "https://en.wikipedia.org/wiki/Norman_County,_Minnesota",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Illinois",
        "https://en.wikipedia.org/wiki/Tippecanoe_County,_Indiana",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Kansas",
        "https://en.wikipedia.org/wiki/Nance_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Lyon_County,_Iowa",
        "https://en.wikipedia.org/wiki/Columbia_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Delaware_County,_New_York",
        "https://en.wikipedia.org/wiki/Cheyenne_County,_Kansas",
        "https://en.wikipedia.org/wiki/Nueces_County,_Texas",
        "https://en.wikipedia.org/wiki/Shasta_County,_California",
        "https://en.wikipedia.org/wiki/Bradford_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/White_County,_Indiana",
        "https://en.wikipedia.org/wiki/Armstrong_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Schuyler_County,_Illinois",
        "https://en.wikipedia.org/wiki/Palo_Pinto_County,_Texas",
        "https://en.wikipedia.org/wiki/Cheyenne_County,_Colorado",
        "https://en.wikipedia.org/wiki/Cabell_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Hall_County,_Georgia",
        "https://en.wikipedia.org/wiki/Spencer_County,_Indiana",
        "https://en.wikipedia.org/wiki/Lafayette_County,_Missouri",
        "https://en.wikipedia.org/wiki/Appomattox_County,_Virginia",
        "https://en.wikipedia.org/wiki/Winkler_County,_Texas",
        "https://en.wikipedia.org/wiki/Douglas_County,_Georgia",
        "https://en.wikipedia.org/wiki/Fall_River_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Richland_County,_Illinois",
        "https://en.wikipedia.org/wiki/Cochise_County,_Arizona",
        "https://en.wikipedia.org/wiki/Williamson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Sutter_County,_California",
        "https://en.wikipedia.org/wiki/Riverside_County,_California",
        "https://en.wikipedia.org/wiki/Caribou_County,_Idaho",
        "https://en.wikipedia.org/wiki/Caledonia_County,_Vermont",
        "https://en.wikipedia.org/wiki/Kiowa_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Richardson_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Silver_Bow_County,_Montana",
        "https://en.wikipedia.org/wiki/Grand_County,_Utah",
        "https://en.wikipedia.org/wiki/Cowlitz_County,_Washington",
        "https://en.wikipedia.org/wiki/Marinette_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Hitchcock_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Virginia",
        "https://en.wikipedia.org/wiki/Montezuma_County,_Colorado",
        "https://en.wikipedia.org/wiki/Nelson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Mason_County,_Washington",
        "https://en.wikipedia.org/wiki/Humboldt_County,_California",
        "https://en.wikipedia.org/wiki/Pender_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Greene_County,_Missouri",
        "https://en.wikipedia.org/wiki/Cimarron_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Lauderdale_County,_Alabama",
        "https://en.wikipedia.org/wiki/St._Joseph_County,_Indiana",
        "https://en.wikipedia.org/wiki/Golden_Valley_County,_Montana",
        "https://en.wikipedia.org/wiki/Lee_County,_Alabama",
        "https://en.wikipedia.org/wiki/Aurora_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Grady_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Shawano_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Page_County,_Iowa",
        "https://en.wikipedia.org/wiki/Washington_County,_Ohio",
        "https://en.wikipedia.org/wiki/Pierce_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Marquette_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Giles_County,_Virginia",
        "https://en.wikipedia.org/wiki/Lafayette_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Goshen_County,_Wyoming",
        "https://en.wikipedia.org/wiki/Northampton_County,_Virginia",
        "https://en.wikipedia.org/wiki/Clarke_County,_Iowa",
        "https://en.wikipedia.org/wiki/Rockdale_County,_Georgia",
        "https://en.wikipedia.org/wiki/Cheatham_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Monroe_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Cottonwood_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Escambia_County,_Florida",
        "https://en.wikipedia.org/wiki/Perry_County,_Missouri",
        "https://en.wikipedia.org/wiki/Lampasas_County,_Texas",
        "https://en.wikipedia.org/wiki/Winona_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Jackson_County,_Texas",
        "https://en.wikipedia.org/wiki/Herkimer_County,_New_York",
        "https://en.wikipedia.org/wiki/Montgomery_County,_New_York",
        "https://en.wikipedia.org/wiki/Cheboygan_County,_Michigan",
        "https://en.wikipedia.org/wiki/Duchesne_County,_Utah",
        "https://en.wikipedia.org/wiki/Rush_County,_Indiana",
        "https://en.wikipedia.org/wiki/Fayette_County,_Iowa",
        "https://en.wikipedia.org/wiki/Matagorda_County,_Texas",
        "https://en.wikipedia.org/wiki/Hutchinson_County,_Texas",
        "https://en.wikipedia.org/wiki/Ochiltree_County,_Texas",
        "https://en.wikipedia.org/wiki/Coconino_County,_Arizona",
        "https://en.wikipedia.org/wiki/Reno_County,_Kansas",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Texas",
        "https://en.wikipedia.org/wiki/Hall_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Coffee_County,_Alabama",
        "https://en.wikipedia.org/wiki/Jones_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Preble_County,_Ohio",
        "https://en.wikipedia.org/wiki/San_Patricio_County,_Texas",
        "https://en.wikipedia.org/wiki/Edgar_County,_Illinois",
        "https://en.wikipedia.org/wiki/Champaign_County,_Ohio",
        "https://en.wikipedia.org/wiki/Stephenson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Henry_County,_Ohio",
        "https://en.wikipedia.org/wiki/Mason_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Juneau_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Bastrop_County,_Texas",
        "https://en.wikipedia.org/wiki/Barron_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Ringgold_County,_Iowa",
        "https://en.wikipedia.org/wiki/Iron_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Red_Willow_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Houston_County,_Alabama",
        "https://en.wikipedia.org/wiki/Harrison_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Moore_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Mendocino_County,_California",
        "https://en.wikipedia.org/wiki/Ralls_County,_Missouri",
        "https://en.wikipedia.org/wiki/Roanoke,_Virginia",
        "https://en.wikipedia.org/wiki/St._Lucie_County,_Florida",
        "https://en.wikipedia.org/wiki/Madison_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Tripp_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Woodbury_County,_Iowa",
        "https://en.wikipedia.org/wiki/Gosper_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Washington_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Custer_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Hancock_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Red_Lake_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Jackson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Harrison_County,_Indiana",
        "https://en.wikipedia.org/wiki/Stafford_County,_Kansas",
        "https://en.wikipedia.org/wiki/Grant_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Harrison_County,_Texas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Texas",
        "https://en.wikipedia.org/wiki/Baker_County,_Oregon",
        "https://en.wikipedia.org/wiki/Kiowa_County,_Kansas",
        "https://en.wikipedia.org/wiki/Catawba_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Campbell_County,_Virginia",
        "https://en.wikipedia.org/wiki/Pawnee_County,_Kansas",
        "https://en.wikipedia.org/wiki/Marion_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Valley_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Sebastian_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Bonner_County,_Idaho",
        "https://en.wikipedia.org/wiki/Scotts_Bluff_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Wythe_County,_Virginia",
        "https://en.wikipedia.org/wiki/Lonoke_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Macon_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Nicholas_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Fulton_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Mason_County,_Illinois",
        "https://en.wikipedia.org/wiki/Hanson_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Bond_County,_Illinois",
        "https://en.wikipedia.org/wiki/Mason_County,_Michigan",
        "https://en.wikipedia.org/wiki/Cortland_County,_New_York",
        "https://en.wikipedia.org/wiki/Refugio_County,_Texas",
        "https://en.wikipedia.org/wiki/Miami-Dade_County,_Florida",
        "https://en.wikipedia.org/wiki/Callaway_County,_Missouri",
        "https://en.wikipedia.org/wiki/Garland_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Pend_Oreille_County,_Washington",
        "https://en.wikipedia.org/wiki/Alamance_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Toole_County,_Montana",
        "https://en.wikipedia.org/wiki/Boyd_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Citrus_County,_Florida",
        "https://en.wikipedia.org/wiki/Mineral_County,_Nevada",
        "https://en.wikipedia.org/wiki/Taylor_County,_Texas",
        "https://en.wikipedia.org/wiki/Portsmouth,_Virginia",
        "https://en.wikipedia.org/wiki/Craighead_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Jewell_County,_Kansas",
        "https://en.wikipedia.org/wiki/Stanton_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Wallowa_County,_Oregon",
        "https://en.wikipedia.org/wiki/Wood_County,_Texas",
        "https://en.wikipedia.org/wiki/Williamsburg,_Virginia",
        "https://en.wikipedia.org/wiki/Oswego_County,_New_York",
        "https://en.wikipedia.org/wiki/Day_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Pendleton_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Seneca_County,_New_York",
        "https://en.wikipedia.org/wiki/Weber_County,_Utah",
        "https://en.wikipedia.org/wiki/Brookings_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Trego_County,_Kansas",
        "https://en.wikipedia.org/wiki/Snyder_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Jefferson_County,_New_York",
        "https://en.wikipedia.org/wiki/Washington_County,_Texas",
        "https://en.wikipedia.org/wiki/Shelby_County,_Illinois",
        "https://en.wikipedia.org/wiki/Faulk_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Rice_County,_Kansas",
        "https://en.wikipedia.org/wiki/Cumberland_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Texas",
        "https://en.wikipedia.org/wiki/Fountain_County,_Indiana",
        "https://en.wikipedia.org/wiki/Wayne_County,_Ohio",
        "https://en.wikipedia.org/wiki/Tipton_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Benton_County,_Indiana",
        "https://en.wikipedia.org/wiki/St._Louis",
        "https://en.wikipedia.org/wiki/Arkansas_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Cleburne_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Gregory_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Stephens_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Camden_County,_Missouri",
        "https://en.wikipedia.org/wiki/Taylor_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Monroe_County,_Indiana",
        "https://en.wikipedia.org/wiki/Pitt_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Calhoun_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Roscommon_County,_Michigan",
        "https://en.wikipedia.org/wiki/Musselshell_County,_Montana",
        "https://en.wikipedia.org/wiki/Schuylkill_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Union_County,_Iowa",
        "https://en.wikipedia.org/wiki/Iberia_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lycoming_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Franklin_County,_Kansas",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Michigan",
        "https://en.wikipedia.org/wiki/Langlade_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Sumner_County,_Kansas",
        "https://en.wikipedia.org/wiki/Worth_County,_Missouri",
        "https://en.wikipedia.org/wiki/Stoddard_County,_Missouri",
        "https://en.wikipedia.org/wiki/Daviess_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Upton_County,_Texas",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Illinois",
        "https://en.wikipedia.org/wiki/Riley_County,_Kansas",
        "https://en.wikipedia.org/wiki/Lewis_County,_New_York",
        "https://en.wikipedia.org/wiki/Norton_County,_Kansas",
        "https://en.wikipedia.org/wiki/Indiana_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Jackson_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Sullivan_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Ste._Genevieve_County,_Missouri",
        "https://en.wikipedia.org/wiki/Bowie_County,_Texas",
        "https://en.wikipedia.org/wiki/Cooper_County,_Missouri",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Wichita_County,_Texas",
        "https://en.wikipedia.org/wiki/Trinity_County,_California",
        "https://en.wikipedia.org/wiki/Buena_Vista_County,_Iowa",
        "https://en.wikipedia.org/wiki/Montrose_County,_Colorado",
        "https://en.wikipedia.org/wiki/Bourbon_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Mille_Lacs_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Phillips_County,_Montana",
        "https://en.wikipedia.org/wiki/Monroe_County,_Georgia",
        "https://en.wikipedia.org/wiki/Waushara_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Nash_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Dolores_County,_Colorado",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Nevada",
        "https://en.wikipedia.org/wiki/Logan_County,_Ohio",
        "https://en.wikipedia.org/wiki/Freestone_County,_Texas",
        "https://en.wikipedia.org/wiki/Vermillion_County,_Indiana",
        "https://en.wikipedia.org/wiki/Waynesboro,_Virginia",
        "https://en.wikipedia.org/wiki/Beaverhead_County,_Montana",
        "https://en.wikipedia.org/wiki/Ravalli_County,_Montana",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Iowa",
        "https://en.wikipedia.org/wiki/Scurry_County,_Texas",
        "https://en.wikipedia.org/wiki/Bell_County,_Texas",
        "https://en.wikipedia.org/wiki/Muscogee_County,_Georgia",
        "https://en.wikipedia.org/wiki/Callahan_County,_Texas",
        "https://en.wikipedia.org/wiki/Waldo_County,_Maine",
        "https://en.wikipedia.org/wiki/LaPorte_County,_Indiana",
        "https://en.wikipedia.org/wiki/Collingsworth_County,_Texas",
        "https://en.wikipedia.org/wiki/Wasco_County,_Oregon",
        "https://en.wikipedia.org/wiki/Burnett_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Mercer_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Indiana",
        "https://en.wikipedia.org/wiki/Walton_County,_Georgia",
        "https://en.wikipedia.org/wiki/Harper_County,_Kansas",
        "https://en.wikipedia.org/wiki/Martin_County,_Indiana",
        "https://en.wikipedia.org/wiki/Brooke_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Daggett_County,_Utah",
        "https://en.wikipedia.org/wiki/Sandusky_County,_Ohio",
        "https://en.wikipedia.org/wiki/Logan_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Teton_County,_Montana",
        "https://en.wikipedia.org/wiki/Kittitas_County,_Washington",
        "https://en.wikipedia.org/wiki/Van_Wert_County,_Ohio",
        "https://en.wikipedia.org/wiki/Ellsworth_County,_Kansas",
        "https://en.wikipedia.org/wiki/Presque_Isle_County,_Michigan",
        "https://en.wikipedia.org/wiki/Caldwell_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Clark_County,_Ohio",
        "https://en.wikipedia.org/wiki/Richland_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Maury_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Grant_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Crawford_County,_Iowa",
        "https://en.wikipedia.org/wiki/Cameron_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Henderson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pasquotank_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Sweet_Grass_County,_Montana",
        "https://en.wikipedia.org/wiki/Cass_County,_Michigan",
        "https://en.wikipedia.org/wiki/Defiance_County,_Ohio",
        "https://en.wikipedia.org/wiki/Yadkin_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Alcona_County,_Michigan",
        "https://en.wikipedia.org/wiki/Paulding_County,_Ohio",
        "https://en.wikipedia.org/wiki/Petroleum_County,_Montana",
        "https://en.wikipedia.org/wiki/Doniphan_County,_Kansas",
        "https://en.wikipedia.org/wiki/Shiawassee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Fisher_County,_Texas",
        "https://en.wikipedia.org/wiki/Accomack_County,_Virginia",
        "https://en.wikipedia.org/wiki/Manistee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Camden_County,_Georgia",
        "https://en.wikipedia.org/wiki/Wyoming_County,_New_York",
        "https://en.wikipedia.org/wiki/Wapello_County,_Iowa",
        "https://en.wikipedia.org/wiki/Norton,_Virginia",
        "https://en.wikipedia.org/wiki/Henry_County,_Iowa",
        "https://en.wikipedia.org/wiki/Hancock_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Dale_County,_Alabama",
        "https://en.wikipedia.org/wiki/Union_County,_Oregon",
        "https://en.wikipedia.org/wiki/Vernon_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Indiana",
        "https://en.wikipedia.org/wiki/Harrison_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Harper_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Roberts_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Cambria_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Gaston_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Bonneville_County,_Idaho",
        "https://en.wikipedia.org/wiki/Mills_County,_Texas",
        "https://en.wikipedia.org/wiki/Lee_County,_Iowa",
        "https://en.wikipedia.org/wiki/Kershaw_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Tuscaloosa_County,_Alabama",
        "https://en.wikipedia.org/wiki/Osage_County,_Missouri",
        "https://en.wikipedia.org/wiki/Mackinac_County,_Michigan",
        "https://en.wikipedia.org/wiki/Hancock_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Tioga_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Washington_County,_Kansas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Jackson_County,_Michigan",
        "https://en.wikipedia.org/wiki/Latimer_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Huntington_County,_Indiana",
        "https://en.wikipedia.org/wiki/Surry_County,_Virginia",
        "https://en.wikipedia.org/wiki/Nobles_County,_Minnesota",
        "https://en.wikipedia.org/wiki/McPherson_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/San_Joaquin_County,_California",
        "https://en.wikipedia.org/wiki/Vermilion_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Logan_County,_Colorado",
        "https://en.wikipedia.org/wiki/Amherst_County,_Virginia",
        "https://en.wikipedia.org/wiki/Jackson_County,_Indiana",
        "https://en.wikipedia.org/wiki/Trumbull_County,_Ohio",
        "https://en.wikipedia.org/wiki/Potter_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Sheridan_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Davidson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Crawford_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Morrill_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Jackson_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Wayne_County,_Illinois",
        "https://en.wikipedia.org/wiki/Cumberland_County,_New_Jersey",
        "https://en.wikipedia.org/wiki/Oldham_County,_Texas",
        "https://en.wikipedia.org/wiki/Darke_County,_Ohio",
        "https://en.wikipedia.org/wiki/Beauregard_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Mobile_County,_Alabama",
        "https://en.wikipedia.org/wiki/Dunn_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Yuma_County,_Colorado",
        "https://en.wikipedia.org/wiki/Alfalfa_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Lea_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Upshur_County,_Texas",
        "https://en.wikipedia.org/wiki/Kiowa_County,_Colorado",
        "https://en.wikipedia.org/wiki/La_Salle_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Northumberland_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Delta_County,_Michigan",
        "https://en.wikipedia.org/wiki/Douglas_County,_Washington",
        "https://en.wikipedia.org/wiki/Tillamook_County,_Oregon",
        "https://en.wikipedia.org/wiki/Nuckolls_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Teton_County,_Idaho",
        "https://en.wikipedia.org/wiki/Florence_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Southampton_County,_Virginia",
        "https://en.wikipedia.org/wiki/Florence_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/McKean_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Medina_County,_Texas",
        "https://en.wikipedia.org/wiki/Waller_County,_Texas",
        "https://en.wikipedia.org/wiki/Johnston_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Franklin_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lenawee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Labette_County,_Kansas",
        "https://en.wikipedia.org/wiki/Henry_County,_Missouri",
        "https://en.wikipedia.org/wiki/Todd_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Wyandot_County,_Ohio",
        "https://en.wikipedia.org/wiki/Marshall_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pontotoc_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Genesee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Belmont_County,_Ohio",
        "https://en.wikipedia.org/wiki/Morton_County,_Kansas",
        "https://en.wikipedia.org/wiki/Hardin_County,_Illinois",
        "https://en.wikipedia.org/wiki/Comanche_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Warren_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Page_County,_Virginia",
        "https://en.wikipedia.org/wiki/Osage_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Saginaw_County,_Michigan",
        "https://en.wikipedia.org/wiki/Hunt_County,_Texas",
        "https://en.wikipedia.org/wiki/Newton_County,_Missouri",
        "https://en.wikipedia.org/wiki/Wahkiakum_County,_Washington",
        "https://en.wikipedia.org/wiki/Menominee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Creek_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Ohio",
        "https://en.wikipedia.org/wiki/Latah_County,_Idaho",
        "https://en.wikipedia.org/wiki/Bedford,_Virginia",
        "https://en.wikipedia.org/wiki/Fulton_County,_Illinois",
        "https://en.wikipedia.org/wiki/Baca_County,_Colorado",
        "https://en.wikipedia.org/wiki/Morgan_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Wayne_County,_Michigan",
        "https://en.wikipedia.org/wiki/Greene_County,_Illinois",
        "https://en.wikipedia.org/wiki/Orleans_County,_Vermont",
        "https://en.wikipedia.org/wiki/Granville_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Allen_County,_Ohio",
        "https://en.wikipedia.org/wiki/Siskiyou_County,_California",
        "https://en.wikipedia.org/wiki/Kearny_County,_Kansas",
        "https://en.wikipedia.org/wiki/Crane_County,_Texas",
        "https://en.wikipedia.org/wiki/Kanabec_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Greenwood_County,_Kansas",
        "https://en.wikipedia.org/wiki/Clay_County,_Illinois",
        "https://en.wikipedia.org/wiki/Philadelphia_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Ward_County,_Texas",
        "https://en.wikipedia.org/wiki/Marion_County,_Kansas",
        "https://en.wikipedia.org/wiki/Rabun_County,_Georgia",
        "https://en.wikipedia.org/wiki/Union_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Bedford_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Huron_County,_Ohio",
        "https://en.wikipedia.org/wiki/Cass_County,_Illinois",
        "https://en.wikipedia.org/wiki/Pondera_County,_Montana",
        "https://en.wikipedia.org/wiki/Orleans_County,_New_York",
        "https://en.wikipedia.org/wiki/Tooele_County,_Utah",
        "https://en.wikipedia.org/wiki/Boyle_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Harding_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Pike_County,_Indiana",
        "https://en.wikipedia.org/wiki/Keokuk_County,_Iowa",
        "https://en.wikipedia.org/wiki/Sevier_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Coos_County,_Oregon",
        "https://en.wikipedia.org/wiki/Henry_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Greene_County,_Indiana",
        "https://en.wikipedia.org/wiki/Rosebud_County,_Montana",
        "https://en.wikipedia.org/wiki/Klickitat_County,_Washington",
        "https://en.wikipedia.org/wiki/Sabine_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Morrow_County,_Ohio",
        "https://en.wikipedia.org/wiki/Haskell_County,_Texas",
        "https://en.wikipedia.org/wiki/Lewis_County,_Washington",
        "https://en.wikipedia.org/wiki/Davis_County,_Iowa",
        "https://en.wikipedia.org/wiki/Kay_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/La_Paz_County,_Arizona",
        "https://en.wikipedia.org/wiki/St._Lawrence_County,_New_York",
        "https://en.wikipedia.org/wiki/Adams_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Somerset_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Pike_County,_Georgia",
        "https://en.wikipedia.org/wiki/Humphreys_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Las_Animas_County,_Colorado",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Indiana",
        "https://en.wikipedia.org/wiki/Chautauqua_County,_New_York",
        "https://en.wikipedia.org/wiki/St._Martin_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Boone_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Clearwater_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Union_County,_Georgia",
        "https://en.wikipedia.org/wiki/McCormick_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Glenn_County,_California",
        "https://en.wikipedia.org/wiki/Anderson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Hopkins_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Wayne_County,_Iowa",
        "https://en.wikipedia.org/wiki/Rapides_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lyon_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Huron_County,_Michigan",
        "https://en.wikipedia.org/wiki/East_Feliciana_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Chenango_County,_New_York",
        "https://en.wikipedia.org/wiki/Knox_County,_Illinois",
        "https://en.wikipedia.org/wiki/Garfield_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Franklin_County,_Maine",
        "https://en.wikipedia.org/wiki/Anderson_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Clay_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Seneca_County,_Ohio",
        "https://en.wikipedia.org/wiki/Marengo_County,_Alabama",
        "https://en.wikipedia.org/wiki/Trimble_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Furnas_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Texas_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Missouri",
        "https://en.wikipedia.org/wiki/Venango_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Ripley_County,_Indiana",
        "https://en.wikipedia.org/wiki/White_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lake_County,_Oregon",
        "https://en.wikipedia.org/wiki/Deer_Lodge_County,_Montana",
        "https://en.wikipedia.org/wiki/Cattaraugus_County,_New_York",
        "https://en.wikipedia.org/wiki/Massac_County,_Illinois",
        "https://en.wikipedia.org/wiki/Perry_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Iosco_County,_Michigan",
        "https://en.wikipedia.org/wiki/Decatur_County,_Indiana",
        "https://en.wikipedia.org/wiki/Greenup_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Alabama",
        "https://en.wikipedia.org/wiki/Clinton_County,_Ohio",
        "https://en.wikipedia.org/wiki/Maries_County,_Missouri",
        "https://en.wikipedia.org/wiki/Edwards_County,_Texas",
        "https://en.wikipedia.org/wiki/Marion_County,_Oregon",
        "https://en.wikipedia.org/wiki/Henderson_County,_Texas",
        "https://en.wikipedia.org/wiki/Marion_County,_Florida",
        "https://en.wikipedia.org/wiki/Meade_County,_Kansas",
        "https://en.wikipedia.org/wiki/Garfield_County,_Utah",
        "https://en.wikipedia.org/wiki/Stevens_County,_Washington",
        "https://en.wikipedia.org/wiki/Hockley_County,_Texas",
        "https://en.wikipedia.org/wiki/Randolph_County,_Illinois",
        "https://en.wikipedia.org/wiki/Coles_County,_Illinois",
        "https://en.wikipedia.org/wiki/Tuscarawas_County,_Ohio",
        "https://en.wikipedia.org/wiki/Pittsburg_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Buchanan_County,_Missouri",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Illinois",
        "https://en.wikipedia.org/wiki/Alpena_County,_Michigan",
        "https://en.wikipedia.org/wiki/Noble_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Rains_County,_Texas",
        "https://en.wikipedia.org/wiki/Pickett_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Ashland_County,_Ohio",
        "https://en.wikipedia.org/wiki/Pueblo_County,_Colorado",
        "https://en.wikipedia.org/wiki/Sherman_County,_Texas",
        "https://en.wikipedia.org/wiki/Marshall_County,_Indiana",
        "https://en.wikipedia.org/wiki/Richland_County,_Ohio",
        "https://en.wikipedia.org/wiki/Brule_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Henry_County,_Alabama",
        "https://en.wikipedia.org/wiki/Henry_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Van_Zandt_County,_Texas",
        "https://en.wikipedia.org/wiki/Ouachita_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Atchison_County,_Kansas",
        "https://en.wikipedia.org/wiki/Marion_County,_Missouri",
        "https://en.wikipedia.org/wiki/Donley_County,_Texas",
        "https://en.wikipedia.org/wiki/Lake_of_the_Woods_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Clarion_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Noble_County,_Indiana",
        "https://en.wikipedia.org/wiki/Spartanburg_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Marion_County,_Illinois",
        "https://en.wikipedia.org/wiki/Clinton_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Murray_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Douglas_County,_Oregon",
        "https://en.wikipedia.org/wiki/Watauga_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Bear_Lake_County,_Idaho",
        "https://en.wikipedia.org/wiki/Wirt_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Kit_Carson_County,_Colorado",
        "https://en.wikipedia.org/wiki/Jackson_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Brown_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Nye_County,_Nevada",
        "https://en.wikipedia.org/wiki/Raleigh_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Warren_County,_Illinois",
        "https://en.wikipedia.org/wiki/Gasconade_County,_Missouri",
        "https://en.wikipedia.org/wiki/Camas_County,_Idaho",
        "https://en.wikipedia.org/wiki/Grays_Harbor_County,_Washington",
        "https://en.wikipedia.org/wiki/Greene_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Piscataquis_County,_Maine",
        "https://en.wikipedia.org/wiki/Floyd_County,_Virginia",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Madison_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Lee_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Wakulla_County,_Florida",
        "https://en.wikipedia.org/wiki/White_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Josephine_County,_Oregon",
        "https://en.wikipedia.org/wiki/Carroll_County,_Ohio",
        "https://en.wikipedia.org/wiki/Chase_County,_Kansas",
        "https://en.wikipedia.org/wiki/Woodson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Galax,_Virginia",
        "https://en.wikipedia.org/wiki/Lyon_County,_Nevada",
        "https://en.wikipedia.org/wiki/Butte_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Assumption_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Crawford_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Gray_County,_Texas",
        "https://en.wikipedia.org/wiki/Chouteau_County,_Montana",
        "https://en.wikipedia.org/wiki/Stone_County,_Missouri",
        "https://en.wikipedia.org/wiki/Van_Buren_County,_Michigan",
        "https://en.wikipedia.org/wiki/West_Feliciana_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Box_Elder_County,_Utah",
        "https://en.wikipedia.org/wiki/Brazos_County,_Texas",
        "https://en.wikipedia.org/wiki/Greenbrier_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Union_County,_Illinois",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Montana",
        "https://en.wikipedia.org/wiki/Stanton_County,_Kansas",
        "https://en.wikipedia.org/wiki/Robertson_County,_Texas",
        "https://en.wikipedia.org/wiki/Grant_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Stewart_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Cass_County,_Indiana",
        "https://en.wikipedia.org/wiki/Catoosa_County,_Georgia",
        "https://en.wikipedia.org/wiki/Dade_County,_Georgia",
        "https://en.wikipedia.org/wiki/Erath_County,_Texas",
        "https://en.wikipedia.org/wiki/Stanislaus_County,_California",
        "https://en.wikipedia.org/wiki/McLennan_County,_Texas",
        "https://en.wikipedia.org/wiki/Floyd_County,_Texas",
        "https://en.wikipedia.org/wiki/Wetzel_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Bradley_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Indiana",
        "https://en.wikipedia.org/wiki/Rusk_County,_Texas",
        "https://en.wikipedia.org/wiki/Lynn_County,_Texas",
        "https://en.wikipedia.org/wiki/Beaufort_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Finney_County,_Kansas",
        "https://en.wikipedia.org/wiki/Juniata_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Boone_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Beltrami_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Lake_and_Peninsula_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Hopkins_County,_Texas",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Appanoose_County,_Iowa",
        "https://en.wikipedia.org/wiki/Howard_County,_Missouri",
        "https://en.wikipedia.org/wiki/Avery_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Saline_County,_Illinois",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Oregon",
        "https://en.wikipedia.org/wiki/Randolph_County,_Indiana",
        "https://en.wikipedia.org/wiki/Newberry_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Ontonagon_County,_Michigan",
        "https://en.wikipedia.org/wiki/Pittsylvania_County,_Virginia",
        "https://en.wikipedia.org/wiki/Colusa_County,_California",
        "https://en.wikipedia.org/wiki/Franklin_County,_New_York",
        "https://en.wikipedia.org/wiki/Columbiana_County,_Ohio",
        "https://en.wikipedia.org/wiki/Gaines_County,_Texas",
        "https://en.wikipedia.org/wiki/Colbert_County,_Alabama",
        "https://en.wikipedia.org/wiki/Aroostook_County,_Maine",
        "https://en.wikipedia.org/wiki/Wayne_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Adams_County,_Idaho",
        "https://en.wikipedia.org/wiki/Clinton_County,_Indiana",
        "https://en.wikipedia.org/wiki/Johnson_County,_Missouri",
        "https://en.wikipedia.org/wiki/Dickson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/DeSoto_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Lake_County,_California",
        "https://en.wikipedia.org/wiki/Sedgwick_County,_Colorado",
        "https://en.wikipedia.org/wiki/Essex_County,_Virginia",
        "https://en.wikipedia.org/wiki/Burleson_County,_Texas",
        "https://en.wikipedia.org/wiki/Madison_County,_Indiana",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Indiana",
        "https://en.wikipedia.org/wiki/Fayette_County,_Illinois",
        "https://en.wikipedia.org/wiki/Lake_County,_Montana",
        "https://en.wikipedia.org/wiki/Putnam_County,_Indiana",
        "https://en.wikipedia.org/wiki/Cowley_County,_Kansas",
        "https://en.wikipedia.org/wiki/Somerset_County,_Maine",
        "https://en.wikipedia.org/wiki/Linn_County,_Oregon",
        "https://en.wikipedia.org/wiki/Carlisle_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Loup_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Iron_County,_Michigan",
        "https://en.wikipedia.org/wiki/Dillingham_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Craig_County,_Virginia",
        "https://en.wikipedia.org/wiki/Crawford_County,_Michigan",
        "https://en.wikipedia.org/wiki/Calloway_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Klamath_County,_Oregon",
        "https://en.wikipedia.org/wiki/Monroe_County,_Ohio",
        "https://en.wikipedia.org/wiki/Scott_County,_Virginia",
        "https://en.wikipedia.org/wiki/Newton_County,_Georgia",
        "https://en.wikipedia.org/wiki/McIntosh_County,_Georgia",
        "https://en.wikipedia.org/wiki/Caldwell_County,_Missouri",
        "https://en.wikipedia.org/wiki/Crawford_County,_Ohio",
        "https://en.wikipedia.org/wiki/Carter_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Sherman_County,_Kansas",
        "https://en.wikipedia.org/wiki/Clay_County,_Indiana",
        "https://en.wikipedia.org/wiki/Washington_County,_Utah",
        "https://en.wikipedia.org/wiki/Lamar_County,_Texas",
        "https://en.wikipedia.org/wiki/Northwest_Arctic_Borough,_Alaska",
        "https://en.wikipedia.org/wiki/Preston_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Cotton_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Lee_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Logan_County,_Illinois",
        "https://en.wikipedia.org/wiki/Troup_County,_Georgia",
        "https://en.wikipedia.org/wiki/Red_River_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Oxford_County,_Maine",
        "https://en.wikipedia.org/wiki/Lynchburg,_Virginia",
        "https://en.wikipedia.org/wiki/Tallapoosa_County,_Alabama",
        "https://en.wikipedia.org/wiki/Harrison_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Webster_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Daviess_County,_Indiana",
        "https://en.wikipedia.org/wiki/Pine_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Hernando_County,_Florida",
        "https://en.wikipedia.org/wiki/Geary_County,_Kansas",
        "https://en.wikipedia.org/wiki/Mitchell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Franklin_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Marion_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Vernon_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Yoakum_County,_Texas",
        "https://en.wikipedia.org/wiki/Lafayette_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Colfax_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Barrow_County,_Georgia",
        "https://en.wikipedia.org/wiki/Hill_County,_Montana",
        "https://en.wikipedia.org/wiki/Crittenden_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Washington_County,_Indiana",
        "https://en.wikipedia.org/wiki/Van_Buren_County,_Iowa",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Ohio",
        "https://en.wikipedia.org/wiki/Tazewell_County,_Virginia",
        "https://en.wikipedia.org/wiki/Williams_County,_Ohio",
        "https://en.wikipedia.org/wiki/Lauderdale_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Pike_County,_Illinois",
        "https://en.wikipedia.org/wiki/Crenshaw_County,_Alabama",
        "https://en.wikipedia.org/wiki/Garrard_County,_Kentucky",
        "https://en.wikipedia.org/wiki/St._John_the_Baptist_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Baxter_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Taos_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/San_Bernardino_County,_California",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Kansas",
        "https://en.wikipedia.org/wiki/Bannock_County,_Idaho",
        "https://en.wikipedia.org/wiki/Owen_County,_Indiana",
        "https://en.wikipedia.org/wiki/Gilmer_County,_Georgia",
        "https://en.wikipedia.org/wiki/St._Mary_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Pleasants_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Stokes_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Ross_County,_Ohio",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Jasper_County,_Georgia",
        "https://en.wikipedia.org/wiki/Person_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Polk_County,_Florida",
        "https://en.wikipedia.org/wiki/Garvin_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Clearfield_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Tangipahoa_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Hamblen_County,_Tennessee",
        "https://en.wikipedia.org/wiki/San_Juan_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Curry_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Pendleton_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Milam_County,_Texas",
        "https://en.wikipedia.org/wiki/Chautauqua_County,_Kansas",
        "https://en.wikipedia.org/wiki/Brown_County,_Texas",
        "https://en.wikipedia.org/wiki/Carroll_County,_Georgia",
        "https://en.wikipedia.org/wiki/Fulton_County,_Indiana",
        "https://en.wikipedia.org/wiki/Vermilion_County,_Illinois",
        "https://en.wikipedia.org/wiki/Pawnee_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/New_Madrid_County,_Missouri",
        "https://en.wikipedia.org/wiki/Allegany_County,_Maryland",
        "https://en.wikipedia.org/wiki/Dyer_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Whitman_County,_Washington",
        "https://en.wikipedia.org/wiki/Brown_County,_Ohio",
        "https://en.wikipedia.org/wiki/Wabash_County,_Indiana",
        "https://en.wikipedia.org/wiki/Terry_County,_Texas",
        "https://en.wikipedia.org/wiki/Modoc_County,_California",
        "https://en.wikipedia.org/wiki/Vigo_County,_Indiana",
        "https://en.wikipedia.org/wiki/Gates_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Florida",
        "https://en.wikipedia.org/wiki/Pickens_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Hill_County,_Texas",
        "https://en.wikipedia.org/wiki/Iberville_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lewis_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Phelps_County,_Missouri",
        "https://en.wikipedia.org/wiki/Gallia_County,_Ohio",
        "https://en.wikipedia.org/wiki/Neosho_County,_Kansas",
        "https://en.wikipedia.org/wiki/Smith_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Dawes_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Jefferson_Davis_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lucas_County,_Iowa",
        "https://en.wikipedia.org/wiki/Tucker_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Shelby_County,_Texas",
        "https://en.wikipedia.org/wiki/Eastland_County,_Texas",
        "https://en.wikipedia.org/wiki/Jasper_County,_Missouri",
        "https://en.wikipedia.org/wiki/Ashland_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Wayne_County,_Indiana",
        "https://en.wikipedia.org/wiki/Elkhart_County,_Indiana",
        "https://en.wikipedia.org/wiki/Delaware_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Rockingham_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Cottle_County,_Texas",
        "https://en.wikipedia.org/wiki/Onslow_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Grenada_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Greenwood_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Knox_County,_Indiana",
        "https://en.wikipedia.org/wiki/Bates_County,_Missouri",
        "https://en.wikipedia.org/wiki/Brown_County,_Kansas",
        "https://en.wikipedia.org/wiki/Comanche_County,_Kansas",
        "https://en.wikipedia.org/wiki/Hocking_County,_Ohio",
        "https://en.wikipedia.org/wiki/Harrison_County,_Ohio",
        "https://en.wikipedia.org/wiki/Morgan_County,_Ohio",
        "https://en.wikipedia.org/wiki/Bartow_County,_Georgia",
        "https://en.wikipedia.org/wiki/Live_Oak_County,_Texas",
        "https://en.wikipedia.org/wiki/Linn_County,_Missouri",
        "https://en.wikipedia.org/wiki/Jackson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Livingston_County,_Missouri",
        "https://en.wikipedia.org/wiki/Rusk_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Lancaster_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Butte_County,_Idaho",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Missouri",
        "https://en.wikipedia.org/wiki/Angelina_County,_Texas",
        "https://en.wikipedia.org/wiki/Bibb_County,_Georgia",
        "https://en.wikipedia.org/wiki/Allegany_County,_New_York",
        "https://en.wikipedia.org/wiki/Crawford_County,_Kansas",
        "https://en.wikipedia.org/wiki/Wilson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Lowndes_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Knox_County,_Missouri",
        "https://en.wikipedia.org/wiki/Bon_Homme_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Pottawatomie_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Perry_County,_Indiana",
        "https://en.wikipedia.org/wiki/Halifax_County,_Virginia",
        "https://en.wikipedia.org/wiki/Bracken_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Rowan_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Pinal_County,_Arizona",
        "https://en.wikipedia.org/wiki/Lumpkin_County,_Georgia",
        "https://en.wikipedia.org/wiki/Obion_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Sequatchie_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Meade_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Edwards_County,_Illinois",
        "https://en.wikipedia.org/wiki/Schoolcraft_County,_Michigan",
        "https://en.wikipedia.org/wiki/Essex_County,_Vermont",
        "https://en.wikipedia.org/wiki/Fayette_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Union_County,_Indiana",
        "https://en.wikipedia.org/wiki/Crook_County,_Oregon",
        "https://en.wikipedia.org/wiki/Richmond_County,_Virginia",
        "https://en.wikipedia.org/wiki/Payne_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Walker_County,_Georgia",
        "https://en.wikipedia.org/wiki/Harney_County,_Oregon",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Missouri",
        "https://en.wikipedia.org/wiki/Esmeralda_County,_Nevada",
        "https://en.wikipedia.org/wiki/Martin_County,_Texas",
        "https://en.wikipedia.org/wiki/Delaware_County,_Indiana",
        "https://en.wikipedia.org/wiki/Taylor_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Ashe_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Smyth_County,_Virginia",
        "https://en.wikipedia.org/wiki/Umatilla_County,_Oregon",
        "https://en.wikipedia.org/wiki/Mohave_County,_Arizona",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Alabama",
        "https://en.wikipedia.org/wiki/Scott_County,_Missouri",
        "https://en.wikipedia.org/wiki/Washington_County,_Maine",
        "https://en.wikipedia.org/wiki/Natchitoches_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Mifflin_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Gila_County,_Arizona",
        "https://en.wikipedia.org/wiki/Liberty_County,_Georgia",
        "https://en.wikipedia.org/wiki/Muskingum_County,_Ohio",
        "https://en.wikipedia.org/wiki/Utah_County,_Utah",
        "https://en.wikipedia.org/wiki/Tuscola_County,_Michigan",
        "https://en.wikipedia.org/wiki/Cullman_County,_Alabama",
        "https://en.wikipedia.org/wiki/Clark_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Edgefield_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Graves_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Costilla_County,_Colorado",
        "https://en.wikipedia.org/wiki/Huntingdon_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Marshall_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Hooker_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Okanogan_County,_Washington",
        "https://en.wikipedia.org/wiki/Blount_County,_Alabama",
        "https://en.wikipedia.org/wiki/Saguache_County,_Colorado",
        "https://en.wikipedia.org/wiki/Phillips_County,_Colorado",
        "https://en.wikipedia.org/wiki/Union_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Sanilac_County,_Michigan",
        "https://en.wikipedia.org/wiki/Tyler_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Chilton_County,_Alabama",
        "https://en.wikipedia.org/wiki/Walker_County,_Alabama",
        "https://en.wikipedia.org/wiki/Briscoe_County,_Texas",
        "https://en.wikipedia.org/wiki/Morgan_County,_Colorado",
        "https://en.wikipedia.org/wiki/Barton_County,_Missouri",
        "https://en.wikipedia.org/wiki/McCulloch_County,_Texas",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Morrow_County,_Oregon",
        "https://en.wikipedia.org/wiki/Hawkins_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Elmore_County,_Idaho",
        "https://en.wikipedia.org/wiki/Prairie_County,_Montana",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Georgia",
        "https://en.wikipedia.org/wiki/Carroll_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Miller_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Lincoln_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Marion_County,_Ohio",
        "https://en.wikipedia.org/wiki/Newaygo_County,_Michigan",
        "https://en.wikipedia.org/wiki/Cleveland_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Mason_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Muskegon_County,_Michigan",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Catron_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Mingo_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Fayette_County,_Ohio",
        "https://en.wikipedia.org/wiki/Clay_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Grayson_County,_Virginia",
        "https://en.wikipedia.org/wiki/Chippewa_County,_Michigan",
        "https://en.wikipedia.org/wiki/Twin_Falls_County,_Idaho",
        "https://en.wikipedia.org/wiki/Lyman_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Mayes_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Dickens_County,_Texas",
        "https://en.wikipedia.org/wiki/Wexford_County,_Michigan",
        "https://en.wikipedia.org/wiki/St._Joseph_County,_Michigan",
        "https://en.wikipedia.org/wiki/Cannon_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Rio_Grande_County,_Colorado",
        "https://en.wikipedia.org/wiki/Crawford_County,_Georgia",
        "https://en.wikipedia.org/wiki/Brown_County,_Illinois",
        "https://en.wikipedia.org/wiki/Allen_County,_Kansas",
        "https://en.wikipedia.org/wiki/Pearl_River_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Mora_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Guernsey_County,_Ohio",
        "https://en.wikipedia.org/wiki/Stephens_County,_Texas",
        "https://en.wikipedia.org/wiki/Parke_County,_Indiana",
        "https://en.wikipedia.org/wiki/Gentry_County,_Missouri",
        "https://en.wikipedia.org/wiki/Jackson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Coshocton_County,_Ohio",
        "https://en.wikipedia.org/wiki/Richmond_County,_Georgia",
        "https://en.wikipedia.org/wiki/Bryan_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Randolph_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Putnam_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Greenlee_County,_Arizona",
        "https://en.wikipedia.org/wiki/Grant_County,_Indiana",
        "https://en.wikipedia.org/wiki/Stanly_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Crawford_County,_Indiana",
        "https://en.wikipedia.org/wiki/Floyd_County,_Georgia",
        "https://en.wikipedia.org/wiki/Oglethorpe_County,_Georgia",
        "https://en.wikipedia.org/wiki/Trousdale_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Shoshone_County,_Idaho",
        "https://en.wikipedia.org/wiki/Jackson_County,_Alabama",
        "https://en.wikipedia.org/wiki/Scott_County,_Indiana",
        "https://en.wikipedia.org/wiki/Miami_County,_Indiana",
        "https://en.wikipedia.org/wiki/Cloud_County,_Kansas",
        "https://en.wikipedia.org/wiki/Forest_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Jim_Wells_County,_Texas",
        "https://en.wikipedia.org/wiki/Nicholas_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Henderson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Pope_County,_Illinois",
        "https://en.wikipedia.org/wiki/Hinds_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Alexander_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Tehama_County,_California",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Tate_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Newton_County,_Texas",
        "https://en.wikipedia.org/wiki/Towns_County,_Georgia",
        "https://en.wikipedia.org/wiki/Saline_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Gibson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Washington_County,_Alabama",
        "https://en.wikipedia.org/wiki/Franklin_County,_Illinois",
        "https://en.wikipedia.org/wiki/Covington_County,_Alabama",
        "https://en.wikipedia.org/wiki/Mercer_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Hopewell,_Virginia",
        "https://en.wikipedia.org/wiki/Marshall_County,_Alabama",
        "https://en.wikipedia.org/wiki/Washington_County,_Idaho",
        "https://en.wikipedia.org/wiki/Hillsdale_County,_Michigan",
        "https://en.wikipedia.org/wiki/Wilbarger_County,_Texas",
        "https://en.wikipedia.org/wiki/Pocahontas_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Hart_County,_Georgia",
        "https://en.wikipedia.org/wiki/Gladwin_County,_Michigan",
        "https://en.wikipedia.org/wiki/Butts_County,_Georgia",
        "https://en.wikipedia.org/wiki/Scotland_County,_Missouri",
        "https://en.wikipedia.org/wiki/Nacogdoches_County,_Texas",
        "https://en.wikipedia.org/wiki/Coffee_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Sumter_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Fannin_County,_Texas",
        "https://en.wikipedia.org/wiki/Webster_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Marion_County,_Texas",
        "https://en.wikipedia.org/wiki/Smith_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Monroe_County,_Missouri",
        "https://en.wikipedia.org/wiki/Gogebic_County,_Michigan",
        "https://en.wikipedia.org/wiki/Wadena_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Navarro_County,_Texas",
        "https://en.wikipedia.org/wiki/Caldwell_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Choctaw_County,_Alabama",
        "https://en.wikipedia.org/wiki/Blackford_County,_Indiana",
        "https://en.wikipedia.org/wiki/Elk_County,_Kansas",
        "https://en.wikipedia.org/wiki/Jackson_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/St._Bernard_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Harnett_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Wharton_County,_Texas",
        "https://en.wikipedia.org/wiki/Henry_County,_Indiana",
        "https://en.wikipedia.org/wiki/Grimes_County,_Texas",
        "https://en.wikipedia.org/wiki/Missaukee_County,_Michigan",
        "https://en.wikipedia.org/wiki/Kern_County,_California",
        "https://en.wikipedia.org/wiki/Monroe_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Independence_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Gonzales_County,_Texas",
        "https://en.wikipedia.org/wiki/Meagher_County,_Montana",
        "https://en.wikipedia.org/wiki/Clark_County,_Missouri",
        "https://en.wikipedia.org/wiki/Polk_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Nome_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Kalkaska_County,_Michigan",
        "https://en.wikipedia.org/wiki/Yancey_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Fairfield_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Clearwater_County,_Idaho",
        "https://en.wikipedia.org/wiki/Jasper_County,_Texas",
        "https://en.wikipedia.org/wiki/Gem_County,_Idaho",
        "https://en.wikipedia.org/wiki/Childress_County,_Texas",
        "https://en.wikipedia.org/wiki/Pecos_County,_Texas",
        "https://en.wikipedia.org/wiki/Blaine_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Runnels_County,_Texas",
        "https://en.wikipedia.org/wiki/Banks_County,_Georgia",
        "https://en.wikipedia.org/wiki/Taney_County,_Missouri",
        "https://en.wikipedia.org/wiki/Surry_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/George_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Fresno_County,_California",
        "https://en.wikipedia.org/wiki/Ionia_County,_Michigan",
        "https://en.wikipedia.org/wiki/Etowah_County,_Alabama",
        "https://en.wikipedia.org/wiki/Foard_County,_Texas",
        "https://en.wikipedia.org/wiki/Oktibbeha_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Geneva_County,_Alabama",
        "https://en.wikipedia.org/wiki/Benewah_County,_Idaho",
        "https://en.wikipedia.org/wiki/Atascosa_County,_Texas",
        "https://en.wikipedia.org/wiki/Grant_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Alabama",
        "https://en.wikipedia.org/wiki/Duval_County,_Texas",
        "https://en.wikipedia.org/wiki/Gilchrist_County,_Florida",
        "https://en.wikipedia.org/wiki/Dakota_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Mercer_County,_Missouri",
        "https://en.wikipedia.org/wiki/Adams_County,_Indiana",
        "https://en.wikipedia.org/wiki/Covington,_Virginia",
        "https://en.wikipedia.org/wiki/Sterling_County,_Texas",
        "https://en.wikipedia.org/wiki/Bleckley_County,_Georgia",
        "https://en.wikipedia.org/wiki/Carbon_County,_Utah",
        "https://en.wikipedia.org/wiki/Unicoi_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Delta_County,_Texas",
        "https://en.wikipedia.org/wiki/Dawson_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Emery_County,_Utah",
        "https://en.wikipedia.org/wiki/Hardin_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Jennings_County,_Indiana",
        "https://en.wikipedia.org/wiki/Darlington_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Jones_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Cass_County,_Texas",
        "https://en.wikipedia.org/wiki/Cache_County,_Utah",
        "https://en.wikipedia.org/wiki/Highlands_County,_Florida",
        "https://en.wikipedia.org/wiki/Pike_County,_Ohio",
        "https://en.wikipedia.org/wiki/Cleveland_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Mecklenburg_County,_Virginia",
        "https://en.wikipedia.org/wiki/Macon_County,_Missouri",
        "https://en.wikipedia.org/wiki/Ferry_County,_Washington",
        "https://en.wikipedia.org/wiki/Morris_County,_Texas",
        "https://en.wikipedia.org/wiki/Chattahoochee_County,_Georgia",
        "https://en.wikipedia.org/wiki/McDonough_County,_Illinois",
        "https://en.wikipedia.org/wiki/Conway_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Arenac_County,_Michigan",
        "https://en.wikipedia.org/wiki/Dade_County,_Missouri",
        "https://en.wikipedia.org/wiki/Clark_County,_Idaho",
        "https://en.wikipedia.org/wiki/Switzerland_County,_Indiana",
        "https://en.wikipedia.org/wiki/Rio_Arriba_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Ashtabula_County,_Ohio",
        "https://en.wikipedia.org/wiki/Muhlenberg_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pierce_County,_Georgia",
        "https://en.wikipedia.org/wiki/Giles_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Ford_County,_Kansas",
        "https://en.wikipedia.org/wiki/McLean_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Thomas_County,_Georgia",
        "https://en.wikipedia.org/wiki/Concho_County,_Texas",
        "https://en.wikipedia.org/wiki/Millard_County,_Utah",
        "https://en.wikipedia.org/wiki/Catahoula_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Grant_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Johnston_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Howard_County,_Texas",
        "https://en.wikipedia.org/wiki/Webster_County,_Missouri",
        "https://en.wikipedia.org/wiki/Branch_County,_Michigan",
        "https://en.wikipedia.org/wiki/Madison_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lassen_County,_California",
        "https://en.wikipedia.org/wiki/Wilson_County,_Kansas",
        "https://en.wikipedia.org/wiki/Laurel_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Pope_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Illinois",
        "https://en.wikipedia.org/wiki/Love_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Acadia_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lewis_County,_Idaho",
        "https://en.wikipedia.org/wiki/Madison_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Logan_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Martinsville,_Virginia",
        "https://en.wikipedia.org/wiki/Karnes_County,_Texas",
        "https://en.wikipedia.org/wiki/Daviess_County,_Missouri",
        "https://en.wikipedia.org/wiki/Little_River_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Otero_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Boundary_County,_Idaho",
        "https://en.wikipedia.org/wiki/Webster_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Muskogee_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Illinois",
        "https://en.wikipedia.org/wiki/Potter_County,_Texas",
        "https://en.wikipedia.org/wiki/Mineral_County,_Montana",
        "https://en.wikipedia.org/wiki/Wayne_County,_Utah",
        "https://en.wikipedia.org/wiki/Baker_County,_Florida",
        "https://en.wikipedia.org/wiki/Henry_County,_Virginia",
        "https://en.wikipedia.org/wiki/Franklin_County,_Florida",
        "https://en.wikipedia.org/wiki/Washington_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Randolph_County,_Alabama",
        "https://en.wikipedia.org/wiki/Grant_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Hardeman_County,_Texas",
        "https://en.wikipedia.org/wiki/Desha_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Sullivan_County,_Indiana",
        "https://en.wikipedia.org/wiki/Craig_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Greene_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Livingston_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Haralson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lyon_County,_Kansas",
        "https://en.wikipedia.org/wiki/Mineral_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Spalding_County,_Georgia",
        "https://en.wikipedia.org/wiki/Houghton_County,_Michigan",
        "https://en.wikipedia.org/wiki/Graham_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Starke_County,_Indiana",
        "https://en.wikipedia.org/wiki/Christian_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Moore_County,_Texas",
        "https://en.wikipedia.org/wiki/Ashley_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Lenoir_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Okmulgee_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Dallam_County,_Texas",
        "https://en.wikipedia.org/wiki/Coal_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Barren_County,_Kentucky",
        "https://en.wikipedia.org/wiki/McMinn_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Liberty_County,_Texas",
        "https://en.wikipedia.org/wiki/Grant_County,_Washington",
        "https://en.wikipedia.org/wiki/Powell_County,_Montana",
        "https://en.wikipedia.org/wiki/Forrest_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Russell_County,_Virginia",
        "https://en.wikipedia.org/wiki/Vernon_County,_Missouri",
        "https://en.wikipedia.org/wiki/Yukon%E2%80%93Koyukuk_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Saluda_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Alger_County,_Michigan",
        "https://en.wikipedia.org/wiki/Benton_County,_Missouri",
        "https://en.wikipedia.org/wiki/Perry_County,_Illinois",
        "https://en.wikipedia.org/wiki/Pike_County,_Alabama",
        "https://en.wikipedia.org/wiki/Emporia,_Virginia",
        "https://en.wikipedia.org/wiki/Pettis_County,_Missouri",
        "https://en.wikipedia.org/wiki/Castro_County,_Texas",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Colorado",
        "https://en.wikipedia.org/wiki/Burke_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Audrain_County,_Missouri",
        "https://en.wikipedia.org/wiki/Russell_County,_Alabama",
        "https://en.wikipedia.org/wiki/Miller_County,_Georgia",
        "https://en.wikipedia.org/wiki/Caldwell_County,_Texas",
        "https://en.wikipedia.org/wiki/Crittenden_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Montmorency_County,_Michigan",
        "https://en.wikipedia.org/wiki/Greene_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Monroe_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Appling_County,_Georgia",
        "https://en.wikipedia.org/wiki/Ogemaw_County,_Michigan",
        "https://en.wikipedia.org/wiki/Hardin_County,_Ohio",
        "https://en.wikipedia.org/wiki/Swain_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Danville,_Virginia",
        "https://en.wikipedia.org/wiki/Valencia_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Tyler_County,_Texas",
        "https://en.wikipedia.org/wiki/LaRue_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Idaho",
        "https://en.wikipedia.org/wiki/Minidoka_County,_Idaho",
        "https://en.wikipedia.org/wiki/Randolph_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Franklin,_Virginia",
        "https://en.wikipedia.org/wiki/Marshall_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Kansas",
        "https://en.wikipedia.org/wiki/Marion_County,_Alabama",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Do%C3%B1a_Ana_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Laclede_County,_Missouri",
        "https://en.wikipedia.org/wiki/Rutherford_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Weakley_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Warren_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Grundy_County,_Missouri",
        "https://en.wikipedia.org/wiki/Jones_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Mahnomen_County,_Minnesota",
        "https://en.wikipedia.org/wiki/Polk_County,_Missouri",
        "https://en.wikipedia.org/wiki/Alleghany_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Franklin_County,_Washington",
        "https://en.wikipedia.org/wiki/Upshur_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Polk_County,_Texas",
        "https://en.wikipedia.org/wiki/Whitfield_County,_Georgia",
        "https://en.wikipedia.org/wiki/Wayne_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Chaves_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Barry_County,_Missouri",
        "https://en.wikipedia.org/wiki/Alamosa_County,_Colorado",
        "https://en.wikipedia.org/wiki/Chariton_County,_Missouri",
        "https://en.wikipedia.org/wiki/Edmonson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Sampson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Crawford_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Fremont_County,_Idaho",
        "https://en.wikipedia.org/wiki/Bollinger_County,_Missouri",
        "https://en.wikipedia.org/wiki/Harrison_County,_Missouri",
        "https://en.wikipedia.org/wiki/Union_County,_Kentucky",
        "https://en.wikipedia.org/wiki/St._Helena_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Moniteau_County,_Missouri",
        "https://en.wikipedia.org/wiki/Van_Buren_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Johnson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Simpson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Columbia_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Scioto_County,_Ohio",
        "https://en.wikipedia.org/wiki/Johnson_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Yakima_County,_Washington",
        "https://en.wikipedia.org/wiki/Peach_County,_Georgia",
        "https://en.wikipedia.org/wiki/Carroll_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Beaver_County,_Utah",
        "https://en.wikipedia.org/wiki/Union_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Treutlen_County,_Georgia",
        "https://en.wikipedia.org/wiki/Talladega_County,_Alabama",
        "https://en.wikipedia.org/wiki/Brooks_County,_Georgia",
        "https://en.wikipedia.org/wiki/Jackson_County,_Ohio",
        "https://en.wikipedia.org/wiki/Meigs_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Putnam_County,_Missouri",
        "https://en.wikipedia.org/wiki/Knox_County,_Texas",
        "https://en.wikipedia.org/wiki/St._Landry_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Bradley_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Miller_County,_Missouri",
        "https://en.wikipedia.org/wiki/Carroll_County,_Virginia",
        "https://en.wikipedia.org/wiki/Perry_County,_Ohio",
        "https://en.wikipedia.org/wiki/Johnson_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Coryell_County,_Texas",
        "https://en.wikipedia.org/wiki/LaGrange_County,_Indiana",
        "https://en.wikipedia.org/wiki/Titus_County,_Texas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Limestone_County,_Texas",
        "https://en.wikipedia.org/wiki/Pike_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Highland_County,_Ohio",
        "https://en.wikipedia.org/wiki/Bourbon_County,_Kansas",
        "https://en.wikipedia.org/wiki/Nottoway_County,_Virginia",
        "https://en.wikipedia.org/wiki/Mecosta_County,_Michigan",
        "https://en.wikipedia.org/wiki/Hampton_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Shelby_County,_Missouri",
        "https://en.wikipedia.org/wiki/Fulton_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Lewis_County,_Missouri",
        "https://en.wikipedia.org/wiki/Columbia_County,_Florida",
        "https://en.wikipedia.org/wiki/Parmer_County,_Texas",
        "https://en.wikipedia.org/wiki/Fleming_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Bedford_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Clarke_County,_Georgia",
        "https://en.wikipedia.org/wiki/Hickman_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Chambers_County,_Alabama",
        "https://en.wikipedia.org/wiki/Hot_Spring_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Sullivan_County,_Missouri",
        "https://en.wikipedia.org/wiki/Columbus_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Union_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Comanche_County,_Texas",
        "https://en.wikipedia.org/wiki/Adair_County,_Missouri",
        "https://en.wikipedia.org/wiki/Nowata_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Butler_County,_Missouri",
        "https://en.wikipedia.org/wiki/Yuba_County,_California",
        "https://en.wikipedia.org/wiki/Chowan_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Jay_County,_Indiana",
        "https://en.wikipedia.org/wiki/Caldwell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Jim_Hogg_County,_Texas",
        "https://en.wikipedia.org/wiki/Carter_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Jackson_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Sanders_County,_Montana",
        "https://en.wikipedia.org/wiki/Gordon_County,_Georgia",
        "https://en.wikipedia.org/wiki/Camp_County,_Texas",
        "https://en.wikipedia.org/wiki/Idaho_County,_Idaho",
        "https://en.wikipedia.org/wiki/Payette_County,_Idaho",
        "https://en.wikipedia.org/wiki/Fannin_County,_Georgia",
        "https://en.wikipedia.org/wiki/Bladen_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Laurens_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Alcorn_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Logan_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Blaine_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Franklin_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Polk_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Sevier_County,_Utah",
        "https://en.wikipedia.org/wiki/Grayson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Cleburne_County,_Alabama",
        "https://en.wikipedia.org/wiki/Wise_County,_Virginia",
        "https://en.wikipedia.org/wiki/Iron_County,_Missouri",
        "https://en.wikipedia.org/wiki/McIntosh_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Houston_County,_Texas",
        "https://en.wikipedia.org/wiki/Woodruff_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Allen_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Webster_County,_Georgia",
        "https://en.wikipedia.org/wiki/Otero_County,_Colorado",
        "https://en.wikipedia.org/wiki/Del_Norte_County,_California",
        "https://en.wikipedia.org/wiki/Isabella_County,_Michigan",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Missouri",
        "https://en.wikipedia.org/wiki/Warren_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Logan_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Schley_County,_Georgia",
        "https://en.wikipedia.org/wiki/Union_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Hardy_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Charles_Mix_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Wilkes_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Lamar_County,_Alabama",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Gallatin_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Grant_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Carter_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Seward_County,_Kansas",
        "https://en.wikipedia.org/wiki/Red_River_County,_Texas",
        "https://en.wikipedia.org/wiki/Osceola_County,_Florida",
        "https://en.wikipedia.org/wiki/Saline_County,_Missouri",
        "https://en.wikipedia.org/wiki/Ohio_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Hall_County,_Texas",
        "https://en.wikipedia.org/wiki/Nolan_County,_Texas",
        "https://en.wikipedia.org/wiki/Evans_County,_Georgia",
        "https://en.wikipedia.org/wiki/Winston_County,_Alabama",
        "https://en.wikipedia.org/wiki/Oceana_County,_Michigan",
        "https://en.wikipedia.org/wiki/Clarke_County,_Alabama",
        "https://en.wikipedia.org/wiki/Ouachita_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Wayne_County,_Missouri",
        "https://en.wikipedia.org/wiki/Montcalm_County,_Michigan",
        "https://en.wikipedia.org/wiki/Coleman_County,_Texas",
        "https://en.wikipedia.org/wiki/Heard_County,_Georgia",
        "https://en.wikipedia.org/wiki/Crosby_County,_Texas",
        "https://en.wikipedia.org/wiki/Bienville_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Wyandotte_County,_Kansas",
        "https://en.wikipedia.org/wiki/Fremont_County,_Colorado",
        "https://en.wikipedia.org/wiki/Rhea_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Prowers_County,_Colorado",
        "https://en.wikipedia.org/wiki/Petersburg,_Virginia",
        "https://en.wikipedia.org/wiki/Scott_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Tift_County,_Georgia",
        "https://en.wikipedia.org/wiki/McDowell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Wayne_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Oneida_County,_Idaho",
        "https://en.wikipedia.org/wiki/Kleberg_County,_Texas",
        "https://en.wikipedia.org/wiki/Habersham_County,_Georgia",
        "https://en.wikipedia.org/wiki/Mississippi_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Bamberg_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Lowndes_County,_Georgia",
        "https://en.wikipedia.org/wiki/Haskell_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Franklin_County,_Alabama",
        "https://en.wikipedia.org/wiki/Bingham_County,_Idaho",
        "https://en.wikipedia.org/wiki/Randolph_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Marion_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Montgomery_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Newton_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Barnwell_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Patrick_County,_Virginia",
        "https://en.wikipedia.org/wiki/Allen_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Noble_County,_Ohio",
        "https://en.wikipedia.org/wiki/Decatur_County,_Iowa",
        "https://en.wikipedia.org/wiki/Ware_County,_Georgia",
        "https://en.wikipedia.org/wiki/Yuma_County,_Arizona",
        "https://en.wikipedia.org/wiki/Gratiot_County,_Michigan",
        "https://en.wikipedia.org/wiki/Elbert_County,_Georgia",
        "https://en.wikipedia.org/wiki/Motley_County,_Texas",
        "https://en.wikipedia.org/wiki/Meriwether_County,_Georgia",
        "https://en.wikipedia.org/wiki/Bristol,_Virginia",
        "https://en.wikipedia.org/wiki/Chester_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Meigs_County,_Ohio",
        "https://en.wikipedia.org/wiki/Hale_County,_Alabama",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Texas",
        "https://en.wikipedia.org/wiki/Lamar_County,_Georgia",
        "https://en.wikipedia.org/wiki/Taylor_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Martin_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Van_Buren_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Washington_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Colleton_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Luce_County,_Michigan",
        "https://en.wikipedia.org/wiki/Johnson_County,_Illinois",
        "https://en.wikipedia.org/wiki/Charlotte_County,_Virginia",
        "https://en.wikipedia.org/wiki/Sabine_County,_Texas",
        "https://en.wikipedia.org/wiki/Hoke_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Fayette_County,_Indiana",
        "https://en.wikipedia.org/wiki/Madison_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Yalobusha_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Lamb_County,_Texas",
        "https://en.wikipedia.org/wiki/Trinity_County,_Texas",
        "https://en.wikipedia.org/wiki/Webster_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Wilkinson_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Toombs_County,_Georgia",
        "https://en.wikipedia.org/wiki/Haywood_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Howard_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Cross_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Nevada_County,_Arkansas",
        "https://en.wikipedia.org/wiki/San_Augustine_County,_Texas",
        "https://en.wikipedia.org/wiki/Clay_County,_Alabama",
        "https://en.wikipedia.org/wiki/Neshoba_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Fayette_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Bailey_County,_Texas",
        "https://en.wikipedia.org/wiki/Torrance_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Richland_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Crockett_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lafayette_County,_Florida",
        "https://en.wikipedia.org/wiki/Pike_County,_Missouri",
        "https://en.wikipedia.org/wiki/Screven_County,_Georgia",
        "https://en.wikipedia.org/wiki/Braxton_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Bullock_County,_Alabama",
        "https://en.wikipedia.org/wiki/Laurens_County,_Georgia",
        "https://en.wikipedia.org/wiki/Baldwin_County,_Georgia",
        "https://en.wikipedia.org/wiki/Dougherty_County,_Georgia",
        "https://en.wikipedia.org/wiki/Fulton_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Benton_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Cook_County,_Georgia",
        "https://en.wikipedia.org/wiki/Bulloch_County,_Georgia",
        "https://en.wikipedia.org/wiki/Claiborne_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Cherokee_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Harmon_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Stone_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Pontotoc_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Orange_County,_Indiana",
        "https://en.wikipedia.org/wiki/Bacon_County,_Georgia",
        "https://en.wikipedia.org/wiki/Stephens_County,_Georgia",
        "https://en.wikipedia.org/wiki/Worth_County,_Georgia",
        "https://en.wikipedia.org/wiki/Gulf_County,_Florida",
        "https://en.wikipedia.org/wiki/St._Francois_County,_Missouri",
        "https://en.wikipedia.org/wiki/Dent_County,_Missouri",
        "https://en.wikipedia.org/wiki/Pushmataha_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Houston_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Clay_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Bland_County,_Virginia",
        "https://en.wikipedia.org/wiki/Winston_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Bethel_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Anderson_County,_Texas",
        "https://en.wikipedia.org/wiki/Fayette_County,_Alabama",
        "https://en.wikipedia.org/wiki/Coosa_County,_Alabama",
        "https://en.wikipedia.org/wiki/Tippah_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Union_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Lincoln_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Benton_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Buena_Vista,_Virginia",
        "https://en.wikipedia.org/wiki/Reynolds_County,_Missouri",
        "https://en.wikipedia.org/wiki/Knott_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Greene_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Suwannee_County,_Florida",
        "https://en.wikipedia.org/wiki/Kings_County,_California",
        "https://en.wikipedia.org/wiki/McNairy_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Attala_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Crawford_County,_Missouri",
        "https://en.wikipedia.org/wiki/Hyde_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Hidalgo_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Jackson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Hickman_County,_Tennessee",
        "https://en.wikipedia.org/wiki/El_Paso_County,_Texas",
        "https://en.wikipedia.org/wiki/Wyoming_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Putnam_County,_Florida",
        "https://en.wikipedia.org/wiki/Pike_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Gooding_County,_Idaho",
        "https://en.wikipedia.org/wiki/Lowndes_County,_Alabama",
        "https://en.wikipedia.org/wiki/Overton_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Cherokee_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Tishomingo_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Polk_County,_Georgia",
        "https://en.wikipedia.org/wiki/Ottawa_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Carroll_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Seminole_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Copiah_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Simpson_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Levy_County,_Florida",
        "https://en.wikipedia.org/wiki/Clay_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Hughes_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Menard_County,_Texas",
        "https://en.wikipedia.org/wiki/Carter_County,_Missouri",
        "https://en.wikipedia.org/wiki/Cherokee_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Adams_County,_Ohio",
        "https://en.wikipedia.org/wiki/Franklin_County,_Georgia",
        "https://en.wikipedia.org/wiki/Perry_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Dickenson_County,_Virginia",
        "https://en.wikipedia.org/wiki/Irwin_County,_Georgia",
        "https://en.wikipedia.org/wiki/White_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Pershing_County,_Nevada",
        "https://en.wikipedia.org/wiki/Marion_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Crisp_County,_Georgia",
        "https://en.wikipedia.org/wiki/Pike_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Merced_County,_California",
        "https://en.wikipedia.org/wiki/The_Bronx",
        "https://en.wikipedia.org/wiki/Monroe_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Benson_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Schuyler_County,_Missouri",
        "https://en.wikipedia.org/wiki/Dallas_County,_Missouri",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Alabama",
        "https://en.wikipedia.org/wiki/Clare_County,_Michigan",
        "https://en.wikipedia.org/wiki/Le_Flore_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Prairie_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Butler_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Abbeville_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Sequoyah_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Marion_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Dodge_County,_Georgia",
        "https://en.wikipedia.org/wiki/Juab_County,_Utah",
        "https://en.wikipedia.org/wiki/Itawamba_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Socorro_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Breckinridge_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Vinton_County,_Ohio",
        "https://en.wikipedia.org/wiki/Osceola_County,_Michigan",
        "https://en.wikipedia.org/wiki/Chester_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Randolph_County,_Georgia",
        "https://en.wikipedia.org/wiki/Nodaway_County,_Missouri",
        "https://en.wikipedia.org/wiki/Jasper_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Panola_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Clarke_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Decatur_County,_Georgia",
        "https://en.wikipedia.org/wiki/Oscoda_County,_Michigan",
        "https://en.wikipedia.org/wiki/Calhoun_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Izard_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Tillman_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Evangeline_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/San_Saba_County,_Texas",
        "https://en.wikipedia.org/wiki/Avoyelles_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Hale_County,_Texas",
        "https://en.wikipedia.org/wiki/Dunklin_County,_Missouri",
        "https://en.wikipedia.org/wiki/Glascock_County,_Georgia",
        "https://en.wikipedia.org/wiki/Green_County,_Kentucky",
        "https://en.wikipedia.org/wiki/West_Carroll_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Marshall_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Upson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Caswell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Candler_County,_Georgia",
        "https://en.wikipedia.org/wiki/Greer_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Clark_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Twiggs_County,_Georgia",
        "https://en.wikipedia.org/wiki/Clayton_County,_Georgia",
        "https://en.wikipedia.org/wiki/Halifax_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Webster_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Quay_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Morgan_County,_Missouri",
        "https://en.wikipedia.org/wiki/Grainger_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Real_County,_Texas",
        "https://en.wikipedia.org/wiki/San_Miguel_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/McDuffie_County,_Georgia",
        "https://en.wikipedia.org/wiki/Northampton_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Vance_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Tulare_County,_California",
        "https://en.wikipedia.org/wiki/Letcher_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Newton_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Warren_County,_Georgia",
        "https://en.wikipedia.org/wiki/Swisher_County,_Texas",
        "https://en.wikipedia.org/wiki/Sumter_County,_Georgia",
        "https://en.wikipedia.org/wiki/Barbour_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Gilmer_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Texas_County,_Missouri",
        "https://en.wikipedia.org/wiki/Val_Verde_County,_Texas",
        "https://en.wikipedia.org/wiki/Hertford_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Caddo_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Madera_County,_California",
        "https://en.wikipedia.org/wiki/Todd_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Ritchie_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Atoka_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Iron_County,_Utah",
        "https://en.wikipedia.org/wiki/Clinch_County,_Georgia",
        "https://en.wikipedia.org/wiki/Sanpete_County,_Utah",
        "https://en.wikipedia.org/wiki/Cassia_County,_Idaho",
        "https://en.wikipedia.org/wiki/Okeechobee_County,_Florida",
        "https://en.wikipedia.org/wiki/Pulaski_County,_Georgia",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Canyon_County,_Idaho",
        "https://en.wikipedia.org/wiki/Franklin_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Sierra_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Lewis_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Bradford_County,_Florida",
        "https://en.wikipedia.org/wiki/Morgan_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Choctaw_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Washington_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Hampshire_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Floyd_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Wayne_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Washington_County,_Missouri",
        "https://en.wikipedia.org/wiki/Baraga_County,_Michigan",
        "https://en.wikipedia.org/wiki/Cumberland_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Orangeburg_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Power_County,_Idaho",
        "https://en.wikipedia.org/wiki/Jeff_Davis_County,_Georgia",
        "https://en.wikipedia.org/wiki/Dawson_County,_Texas",
        "https://en.wikipedia.org/wiki/Clarendon_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Santa_Cruz_County,_Arizona",
        "https://en.wikipedia.org/wiki/Arthur_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Robertson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Seminole_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lunenburg_County,_Virginia",
        "https://en.wikipedia.org/wiki/Franklin_County,_Idaho",
        "https://en.wikipedia.org/wiki/Gadsden_County,_Florida",
        "https://en.wikipedia.org/wiki/McCurtain_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Turner_County,_Georgia",
        "https://en.wikipedia.org/wiki/Randolph_County,_Missouri",
        "https://en.wikipedia.org/wiki/Early_County,_Georgia",
        "https://en.wikipedia.org/wiki/Jenkins_County,_Georgia",
        "https://en.wikipedia.org/wiki/Adams_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Deaf_Smith_County,_Texas",
        "https://en.wikipedia.org/wiki/Jackson_County,_Florida",
        "https://en.wikipedia.org/wiki/Dimmit_County,_Texas",
        "https://en.wikipedia.org/wiki/Washington_County,_Georgia",
        "https://en.wikipedia.org/wiki/Claiborne_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/McDonald_County,_Missouri",
        "https://en.wikipedia.org/wiki/Buchanan_County,_Virginia",
        "https://en.wikipedia.org/wiki/Uvalde_County,_Texas",
        "https://en.wikipedia.org/wiki/Marion_County,_Georgia",
        "https://en.wikipedia.org/wiki/Roosevelt_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Cocke_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Blaine_County,_Montana",
        "https://en.wikipedia.org/wiki/Bibb_County,_Alabama",
        "https://en.wikipedia.org/wiki/Union_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Summers_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Howell_County,_Missouri",
        "https://en.wikipedia.org/wiki/Butler_County,_Alabama",
        "https://en.wikipedia.org/wiki/Stone_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Washington_County,_Florida",
        "https://en.wikipedia.org/wiki/Hempstead_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Cochran_County,_Texas",
        "https://en.wikipedia.org/wiki/Adair_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Hickory_County,_Missouri",
        "https://en.wikipedia.org/wiki/Jasper_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Roane_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/St._Clair_County,_Missouri",
        "https://en.wikipedia.org/wiki/Wheatland_County,_Montana",
        "https://en.wikipedia.org/wiki/Doddridge_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Madison_County,_Missouri",
        "https://en.wikipedia.org/wiki/Conejos_County,_Colorado",
        "https://en.wikipedia.org/wiki/Hart_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Wayne_County,_Georgia",
        "https://en.wikipedia.org/wiki/Lanier_County,_Georgia",
        "https://en.wikipedia.org/wiki/Dallas_County,_Alabama",
        "https://en.wikipedia.org/wiki/Covington_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Richmond_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Wilkinson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Ozark_County,_Missouri",
        "https://en.wikipedia.org/wiki/Perry_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Lafayette_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Prince_Edward_County,_Virginia",
        "https://en.wikipedia.org/wiki/Crowley_County,_Colorado",
        "https://en.wikipedia.org/wiki/Perry_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Jerome_County,_Idaho",
        "https://en.wikipedia.org/wiki/Holmes_County,_Ohio",
        "https://en.wikipedia.org/wiki/Tensas_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Metcalfe_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Graham_County,_Arizona",
        "https://en.wikipedia.org/wiki/Buckingham_County,_Virginia",
        "https://en.wikipedia.org/wiki/Long_County,_Georgia",
        "https://en.wikipedia.org/wiki/Pickens_County,_Alabama",
        "https://en.wikipedia.org/wiki/Choctaw_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Chesterfield_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Duplin_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Scott_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Wilkes_County,_Georgia",
        "https://en.wikipedia.org/wiki/Russell_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Thurston_County,_Nebraska",
        "https://en.wikipedia.org/wiki/Charlton_County,_Georgia",
        "https://en.wikipedia.org/wiki/Bertie_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Rowan_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Harrisonburg,_Virginia",
        "https://en.wikipedia.org/wiki/Taylor_County,_Georgia",
        "https://en.wikipedia.org/wiki/Emanuel_County,_Georgia",
        "https://en.wikipedia.org/wiki/Drew_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Taylor_County,_Florida",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Coffee_County,_Georgia",
        "https://en.wikipedia.org/wiki/Colquitt_County,_Georgia",
        "https://en.wikipedia.org/wiki/Athens_County,_Ohio",
        "https://en.wikipedia.org/wiki/Baker_County,_Georgia",
        "https://en.wikipedia.org/wiki/Macon_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Talbot_County,_Georgia",
        "https://en.wikipedia.org/wiki/Yell_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Amite_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Edgecombe_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Piute_County,_Utah",
        "https://en.wikipedia.org/wiki/Adams_County,_Washington",
        "https://en.wikipedia.org/wiki/Monroe_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Brantley_County,_Georgia",
        "https://en.wikipedia.org/wiki/Poinsett_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Carroll_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Roosevelt_County,_Montana",
        "https://en.wikipedia.org/wiki/Pemiscot_County,_Missouri",
        "https://en.wikipedia.org/wiki/Clay_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Shannon_County,_Missouri",
        "https://en.wikipedia.org/wiki/Dixie_County,_Florida",
        "https://en.wikipedia.org/wiki/Walthall_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Bee_County,_Texas",
        "https://en.wikipedia.org/wiki/Holmes_County,_Florida",
        "https://en.wikipedia.org/wiki/Dallas_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Terrell_County,_Georgia",
        "https://en.wikipedia.org/wiki/Phillips_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Barbour_County,_Alabama",
        "https://en.wikipedia.org/wiki/Macon_County,_Alabama",
        "https://en.wikipedia.org/wiki/Campbell_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Johnson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Clinton_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Scott_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Winn_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Berrien_County,_Georgia",
        "https://en.wikipedia.org/wiki/Leake_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Imperial_County,_California",
        "https://en.wikipedia.org/wiki/Anson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Somerset_County,_Maryland",
        "https://en.wikipedia.org/wiki/Clay_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Searcy_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Sharp_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Kinney_County,_Texas",
        "https://en.wikipedia.org/wiki/Morehouse_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Chickasaw_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Zapata_County,_Texas",
        "https://en.wikipedia.org/wiki/Washington_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Lee_County,_Virginia",
        "https://en.wikipedia.org/wiki/Tyrrell_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Monroe_County,_Kentucky",
        "https://en.wikipedia.org/wiki/DeKalb_County,_Missouri",
        "https://en.wikipedia.org/wiki/Navajo_County,_Arizona",
        "https://en.wikipedia.org/wiki/Prentiss_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Sussex_County,_Virginia",
        "https://en.wikipedia.org/wiki/Escambia_County,_Alabama",
        "https://en.wikipedia.org/wiki/Chicot_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Marion_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Idaho",
        "https://en.wikipedia.org/wiki/Okfuskee_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Rockcastle_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Falls_County,_Texas",
        "https://en.wikipedia.org/wiki/Johnson_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Bolivar_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Georgia",
        "https://en.wikipedia.org/wiki/Fentress_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Murray_County,_Georgia",
        "https://en.wikipedia.org/wiki/Estill_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Concordia_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Leslie_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Ripley_County,_Missouri",
        "https://en.wikipedia.org/wiki/Douglas_County,_Missouri",
        "https://en.wikipedia.org/wiki/Wayne_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Greensville_County,_Virginia",
        "https://en.wikipedia.org/wiki/Bath_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Cedar_County,_Missouri",
        "https://en.wikipedia.org/wiki/Malheur_County,_Oregon",
        "https://en.wikipedia.org/wiki/Oregon_County,_Missouri",
        "https://en.wikipedia.org/wiki/Walker_County,_Texas",
        "https://en.wikipedia.org/wiki/Hamilton_County,_Florida",
        "https://en.wikipedia.org/wiki/Bennett_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Liberty_County,_Florida",
        "https://en.wikipedia.org/wiki/Harlan_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Morgan_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Culberson_County,_Texas",
        "https://en.wikipedia.org/wiki/Jefferson_Davis_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Lake_County,_Michigan",
        "https://en.wikipedia.org/wiki/Radford,_Virginia",
        "https://en.wikipedia.org/wiki/Garza_County,_Texas",
        "https://en.wikipedia.org/wiki/Presidio_County,_Texas",
        "https://en.wikipedia.org/wiki/Burke_County,_Georgia",
        "https://en.wikipedia.org/wiki/Hendry_County,_Florida",
        "https://en.wikipedia.org/wiki/Lewis_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Cibola_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Luna_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Brunswick_County,_Virginia",
        "https://en.wikipedia.org/wiki/Chattooga_County,_Georgia",
        "https://en.wikipedia.org/wiki/Sevier_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Glades_County,_Florida",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Whitley_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Atkinson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Owyhee_County,_Idaho",
        "https://en.wikipedia.org/wiki/Menifee_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Mitchell_County,_Texas",
        "https://en.wikipedia.org/wiki/Jackson_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Frio_County,_Texas",
        "https://en.wikipedia.org/wiki/Echols_County,_Georgia",
        "https://en.wikipedia.org/wiki/Mellette_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Lauderdale_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Monroe_County,_Alabama",
        "https://en.wikipedia.org/wiki/Bledsoe_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Sharkey_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Coahoma_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Grady_County,_Georgia",
        "https://en.wikipedia.org/wiki/Big_Horn_County,_Montana",
        "https://en.wikipedia.org/wiki/Mitchell_County,_Georgia",
        "https://en.wikipedia.org/wiki/Grundy_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Scotland_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Jackson_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Conecuh_County,_Alabama",
        "https://en.wikipedia.org/wiki/Glacier_County,_Montana",
        "https://en.wikipedia.org/wiki/Casey_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Dewey_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Mississippi_County,_Missouri",
        "https://en.wikipedia.org/wiki/Tunica_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Madison_County,_Florida",
        "https://en.wikipedia.org/wiki/Martin_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Montgomery_County,_Mississippi",
        "https://en.wikipedia.org/wiki/St._Francis_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Rolette_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/Sioux_County,_North_Dakota",
        "https://en.wikipedia.org/wiki/San_Juan_County,_Utah",
        "https://en.wikipedia.org/wiki/Reeves_County,_Texas",
        "https://en.wikipedia.org/wiki/Hardee_County,_Florida",
        "https://en.wikipedia.org/wiki/Robeson_County,_North_Carolina",
        "https://en.wikipedia.org/wiki/Tattnall_County,_Georgia",
        "https://en.wikipedia.org/wiki/Powell_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Kenedy_County,_Texas",
        "https://en.wikipedia.org/wiki/Madison_County,_Idaho",
        "https://en.wikipedia.org/wiki/Madison_County,_Texas",
        "https://en.wikipedia.org/wiki/Magoffin_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Adair_County,_Oklahoma",
        "https://en.wikipedia.org/wiki/Bell_County,_Kentucky",
        "https://en.wikipedia.org/wiki/DeSoto_County,_Florida",
        "https://en.wikipedia.org/wiki/Bent_County,_Colorado",
        "https://en.wikipedia.org/wiki/Lincoln_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Dillon_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Hardeman_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Greene_County,_Alabama",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Georgia",
        "https://en.wikipedia.org/wiki/Williamsburg_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Jones_County,_Texas",
        "https://en.wikipedia.org/wiki/Lexington,_Virginia",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Georgia",
        "https://en.wikipedia.org/wiki/Wright_County,_Missouri",
        "https://en.wikipedia.org/wiki/Lee_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Menominee_County,_Wisconsin",
        "https://en.wikipedia.org/wiki/Cameron_County,_Texas",
        "https://en.wikipedia.org/wiki/Breathitt_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Calhoun_County,_Florida",
        "https://en.wikipedia.org/wiki/Marlboro_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/Webb_County,_Texas",
        "https://en.wikipedia.org/wiki/Dooly_County,_Georgia",
        "https://en.wikipedia.org/wiki/Greene_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Taliaferro_County,_Georgia",
        "https://en.wikipedia.org/wiki/Knox_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Brooks_County,_Texas",
        "https://en.wikipedia.org/wiki/Hancock_County,_Tennessee",
        "https://en.wikipedia.org/wiki/Leflore_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Yazoo_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Corson_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Hidalgo_County,_Texas",
        "https://en.wikipedia.org/wiki/Ben_Hill_County,_Georgia",
        "https://en.wikipedia.org/wiki/Quitman_County,_Georgia",
        "https://en.wikipedia.org/wiki/Guadalupe_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Wolfe_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Sumter_County,_Alabama",
        "https://en.wikipedia.org/wiki/Lawrence_County,_Illinois",
        "https://en.wikipedia.org/wiki/Hudspeth_County,_Texas",
        "https://en.wikipedia.org/wiki/McDowell_County,_West_Virginia",
        "https://en.wikipedia.org/wiki/Elliott_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Lee_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Quitman_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Macon_County,_Georgia",
        "https://en.wikipedia.org/wiki/Kemper_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Issaquena_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Perry_County,_Alabama",
        "https://en.wikipedia.org/wiki/Maverick_County,_Texas",
        "https://en.wikipedia.org/wiki/Forest_County,_Pennsylvania",
        "https://en.wikipedia.org/wiki/Alexander_County,_Illinois",
        "https://en.wikipedia.org/wiki/Owsley_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Union_County,_Florida",
        "https://en.wikipedia.org/wiki/Madison_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Clay_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Wilcox_County,_Alabama",
        "https://en.wikipedia.org/wiki/Allendale_County,_South_Carolina",
        "https://en.wikipedia.org/wiki/La_Salle_County,_Texas",
        "https://en.wikipedia.org/wiki/Stewart_County,_Georgia",
        "https://en.wikipedia.org/wiki/Wilcox_County,_Georgia",
        "https://en.wikipedia.org/wiki/Clay_County,_Georgia",
        "https://en.wikipedia.org/wiki/Humphreys_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Zavala_County,_Texas",
        "https://en.wikipedia.org/wiki/Noxubee_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Tallahatchie_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Jefferson_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Apache_County,_Arizona",
        "https://en.wikipedia.org/wiki/McKinley_County,_New_Mexico",
        "https://en.wikipedia.org/wiki/Sunflower_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Lee_County,_Arkansas",
        "https://en.wikipedia.org/wiki/Telfair_County,_Georgia",
        "https://en.wikipedia.org/wiki/Hancock_County,_Georgia",
        "https://en.wikipedia.org/wiki/Ziebach_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Claiborne_County,_Mississippi",
        "https://en.wikipedia.org/wiki/Holmes_County,_Mississippi",
        "https://en.wikipedia.org/wiki/East_Carroll_Parish,_Louisiana",
        "https://en.wikipedia.org/wiki/Lake_County,_Tennessee",
        "https://en.wikipedia.org/wiki/McCreary_County,_Kentucky",
        "https://en.wikipedia.org/wiki/Starr_County,_Texas",
        "https://en.wikipedia.org/wiki/Buffalo_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Willacy_County,_Texas",
        "https://en.wikipedia.org/wiki/Kusilvak_Census_Area,_Alaska",
        "https://en.wikipedia.org/wiki/Todd_County,_South_Dakota",
        "https://en.wikipedia.org/wiki/Wheeler_County,_Georgia",
        "https://en.wikipedia.org/wiki/Oglala_Lakota_County,_South_Dakota"
      ]
    }
  ],
  "keywords": [
    "Rank",
    "County-area",
    "State",
    "Per capita income",
    "Median household income",
    "Median family income",
    "Population",
    "Number of households",
    "County-equivalent_link"
  ]
}