# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: d3ded15
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from knowledge_stack.models.job_type import JobType
from knowledge_stack.models.processing_stage import ProcessingStage
from knowledge_stack.models.resource_type import ResourceType
from typing import Optional, Set
from typing_extensions import Self

class RespJob(BaseModel):
    """
    Clean job response schema.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the job")
    tenant_id: UUID = Field(description="The ID of the tenant")
    resource_id: UUID = Field(description="The ID of the resource")
    resource_type: ResourceType = Field(description="The type of the resource")
    status: StrictStr = Field(description="The status of the job")
    progress: Optional[Union[Annotated[float, Field(le=100.0, strict=True, ge=0.0)], Annotated[int, Field(le=100, strict=True, ge=0)]]] = Field(default=0.0, description="Progress of the job (0.0 to 100.0)")
    completed_at: Optional[datetime] = Field(default=None, description="When the job was completed")
    processing_stage: ProcessingStage = Field(description="The processing stage for the job")
    job_type: JobType = Field(description="The type of the job")
    error: Optional[StrictStr] = Field(default=None, description="Error message if the job failed")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "tenant_id", "resource_id", "resource_type", "status", "progress", "completed_at", "processing_stage", "job_type", "error"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "tenant_id": obj.get("tenant_id"),
            "resource_id": obj.get("resource_id"),
            "resource_type": obj.get("resource_type"),
            "status": obj.get("status"),
            "progress": obj.get("progress") if obj.get("progress") is not None else 0.0,
            "completed_at": obj.get("completed_at"),
            "processing_stage": obj.get("processing_stage"),
            "job_type": obj.get("job_type"),
            "error": obj.get("error")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


