# Copyright 2018-2019 by Peter Cock, The James Hutton Institute.
# All rights reserved.
# This file is part of the THAPBI Phytophthora ITS1 Classifier Tool (PICT),
# and is released under the "MIT License Agreement". Please see the LICENSE
# file that should have been included as part of this package.

"""THAPBI *Phytophthora* ITS1 Classifier Tool (PICT).

*Phytophthora* (from Greek meaning plant-destroyer) species are economically
important plant pathogens, important in both agriculture and forestry. ITS1 is
short for Internal Transcribed Spacer one, which is a region of eukaryotes
genomes between the 18S and 5.8S rRNA genes. This is commonly used for
molecular barcoding, where sequencing this short region can identify species.

This Python package provides ITS1-based diagnostic/profiling tools for the
Tree Health and Plant Biosecurity Initiative (THAPBI) Phyto-Threats project,
funded by the UK's [BBSRC](https://www.bbsrc.ac.uk).

You would typically use THAPBI PICT via the command line tool it defines::

    $ thapbi_pict --help
    ...

"""

__version__ = "0.3.1"
