/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars;

import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.grammars.SchemaInformedGrammars;
import com.siemens.ct.exi.core.grammars.SchemaLessGrammars;
import com.siemens.ct.exi.grammars.XSDGrammarsBuilder;
import java.io.InputStream;
import org.apache.xerces.xni.parser.XMLEntityResolver;

public class GrammarFactory {
    protected XSDGrammarsBuilder grammarBuilder = XSDGrammarsBuilder.newInstance();

    protected GrammarFactory() {
    }

    public static GrammarFactory newInstance() {
        return new GrammarFactory();
    }

    public Grammars createGrammars(String xsdLocation) throws EXIException {
        return this.createGrammars(xsdLocation, null);
    }

    public Grammars createGrammars(String xsdLocation, XMLEntityResolver entityResolver) throws EXIException {
        if (xsdLocation == null || xsdLocation.equals("")) {
            throw new EXIException("SchemaLocation not specified correctly!");
        }
        this.grammarBuilder.loadGrammars(xsdLocation, entityResolver);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId(xsdLocation);
        return g;
    }

    public Grammars createGrammars(InputStream is) throws EXIException {
        return this.createGrammars(is, null);
    }

    public Grammars createGrammars(InputStream is, XMLEntityResolver entityResolver) throws EXIException {
        this.grammarBuilder.loadGrammars(is, entityResolver);
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setSchemaId("No-Schema-ID-Set");
        return g;
    }

    public Grammars createXSDTypesOnlyGrammars() throws EXIException {
        this.grammarBuilder.loadXSDTypesOnlyGrammars();
        SchemaInformedGrammars g = this.grammarBuilder.toGrammars();
        g.setBuiltInXMLSchemaTypesOnly(true);
        return g;
    }

    public Grammars createSchemaLessGrammars() {
        return new SchemaLessGrammars();
    }
}

