/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.api.dom;

import com.siemens.ct.exi.core.EXIBodyEncoder;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.EXIStreamEncoder;
import com.siemens.ct.exi.core.attributes.AttributeFactory;
import com.siemens.ct.exi.core.attributes.AttributeList;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.values.StringValue;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMWriter {
    protected EXIFactory factory;
    protected EXIStreamEncoder exiStream;
    protected EXIBodyEncoder exiBody;
    private AttributeList exiAttributes;
    protected boolean preserveWhitespaces;
    protected boolean preserveComments;
    protected boolean preservePIs;

    public DOMWriter(EXIFactory factory) throws EXIException {
        this.factory = factory;
        this.exiStream = factory.createEXIStreamEncoder();
        AttributeFactory attFactory = AttributeFactory.newInstance();
        this.exiAttributes = attFactory.createAttributeListInstance(factory);
        this.preserveComments = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePIs = factory.getFidelityOptions().isFidelityEnabled("PRESERVE_PIS");
    }

    public void setOutput(OutputStream os) throws EXIException, IOException {
        this.exiBody = this.exiStream.encodeHeader(os);
    }

    public void encode(Document doc) throws EXIException, IOException {
        if (this.exiBody == null) {
            throw new EXIException("Please specify output stream");
        }
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(doc.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encodeFragment(DocumentFragment docFragment) throws EXIException, IOException {
        if (this.exiBody == null) {
            throw new EXIException("Please specify output stream");
        }
        this.exiBody.encodeStartDocument();
        this.encodeChildNodes(docFragment.getChildNodes());
        this.exiBody.encodeEndDocument();
        this.exiBody.flush();
    }

    public void encode(Node n) throws EXIException, IOException {
        if (n.getNodeType() == 9) {
            this.encode((Document)n);
        } else if (n.getNodeType() == 11) {
            this.encodeFragment((DocumentFragment)n);
        } else {
            this.exiBody.encodeStartDocument();
            this.encodeNode(n);
            this.exiBody.encodeEndDocument();
            this.exiBody.flush();
        }
    }

    protected void encodeNode(Node root) throws EXIException, IOException {
        String prefix;
        assert (root.getNodeType() == 1);
        String namespaceURI = root.getNamespaceURI() == null ? "" : root.getNamespaceURI();
        String localName = root.getLocalName();
        if (localName == null) {
            localName = root.getNodeName();
        }
        if ((prefix = root.getPrefix()) == null) {
            prefix = "";
        }
        this.exiBody.encodeStartElement(namespaceURI, localName, prefix);
        NamedNodeMap attributes = root.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node at = attributes.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(at.getNamespaceURI())) {
                String pfx = at.getPrefix() == null ? "" : at.getLocalName();
                this.exiAttributes.addNamespaceDeclaration(at.getNodeValue(), pfx);
            } else {
                String atLocalName = at.getLocalName();
                if (atLocalName == null) {
                    atLocalName = at.getNodeName();
                }
                this.exiAttributes.addAttribute(at.getNamespaceURI(), atLocalName, at.getPrefix(), at.getNodeValue());
            }
            ++i;
        }
        this.exiBody.encodeAttributeList(this.exiAttributes);
        this.exiAttributes.clear();
        NodeList children = root.getChildNodes();
        this.encodeChildNodes(children);
        this.exiBody.encodeEndElement();
    }

    protected void encodeChildNodes(NodeList children) throws EXIException, IOException {
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            switch (n.getNodeType()) {
                case 1: {
                    this.encodeNode(n);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.exiBody.encodeCharacters(new StringValue(n.getNodeValue()));
                    break;
                }
                case 8: {
                    if (!this.preserveComments) break;
                    String c = n.getNodeValue();
                    this.exiBody.encodeComment(c.toCharArray(), 0, c.length());
                    break;
                }
                case 10: {
                    DocumentType dt = (DocumentType)n;
                    String publicID = dt.getPublicId() == null ? "" : dt.getPublicId();
                    String systemID = dt.getSystemId() == null ? "" : dt.getSystemId();
                    String text = dt.getInternalSubset() == null ? "" : dt.getInternalSubset();
                    this.exiBody.encodeDocType(dt.getName(), publicID, systemID, text);
                    break;
                }
                case 5: {
                    break;
                }
                case 4: {
                    this.exiBody.encodeCharacters(new StringValue(n.getNodeValue()));
                    break;
                }
                case 7: {
                    if (!this.preservePIs) break;
                    ProcessingInstruction pi = (ProcessingInstruction)n;
                    this.exiBody.encodeProcessingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                default: {
                    System.err.println("[WARNING] Unhandled DOM NodeType: " + n.getNodeType());
                }
            }
            ++i;
        }
    }
}

