/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.main.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.siemens.ct.exi.main.cmd.AbstractEXICodec;
import com.siemens.ct.exi.main.cmd.BuiltInSchema;
import com.siemens.ct.exi.main.cmd.EXICodecQuickTest;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public final class EXICodec
extends AbstractEXICodec {
    private static float version = 1.55f;
    private static String AppProtocolNS = "urn:iso:15118:2:2010:AppProtocol";
    private static String MsgDefNS = "urn:iso:15118:2:2013:MsgDef";
    private static String CommonMessagesNS = "urn:iso:std:iso:15118:-20:CommonMessages";
    private static String ACNS = "urn:iso:std:iso:15118:-20:AC";
    private static String DCNS = "urn:iso:std:iso:15118:-20:DC";
    private static String WPTNS = "urn:iso:std:iso:15118:-20:WPT";
    private static String ACDPNS = "urn:iso:std:iso:15118:-20:ACDP";
    private static String XMLDSigNS = "http://www.w3.org/2000/09/xmldsig#";
    private static String DINSpec_70121 = "urn:din:70121:2012:MsgDef";
    private static Map<String, BuiltInSchema> namespace_schema_mapping = new HashMap<String, BuiltInSchema>();

    public EXICodec() {
        namespace_schema_mapping.put(AppProtocolNS, BuiltInSchema.AppProtocol);
        namespace_schema_mapping.put(MsgDefNS, BuiltInSchema.ISO15118_2);
        namespace_schema_mapping.put(CommonMessagesNS, BuiltInSchema.ISO15118_20_V2G_CI_CommonMessages);
        namespace_schema_mapping.put(ACNS, BuiltInSchema.ISO15118_20_V2G_CI_AC);
        namespace_schema_mapping.put(DCNS, BuiltInSchema.ISO15118_20_V2G_CI_DC);
        namespace_schema_mapping.put(WPTNS, BuiltInSchema.ISO15118_20_V2G_CI_WPT);
        namespace_schema_mapping.put(ACDPNS, BuiltInSchema.ISO15118_20_V2G_CI_ACDP);
        namespace_schema_mapping.put(XMLDSigNS, BuiltInSchema.XSDCore);
        namespace_schema_mapping.put(DINSpec_70121, BuiltInSchema.DINSpec_70121);
    }

    public byte[] encode(String jsonDocument, String namespace) {
        try {
            this.resetLastEncodingError();
            BuiltInSchema schemaID = EXICodec.getSchema(namespace);
            return this.encode_json(jsonDocument, schemaID);
        }
        catch (JsonMappingException e) {
            this.setLastEncodingError("JSON Mapping Error " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            String className = e.getMessage().substring(e.getMessage().lastIndexOf(46) + 1);
            this.setLastEncodingError("Unknown Message Type: " + className);
        }
        catch (JsonProcessingException e) {
            this.setLastEncodingError("JSON Processing Error " + e.getMessage());
        }
        catch (Exception e) {
            this.setLastEncodingError("Unknown error: " + e.toString());
        }
        return null;
    }

    public String decode(byte[] exiStream, String namespace) {
        BuiltInSchema schemaID = EXICodec.getSchema(namespace);
        return this.decode_exi(exiStream, schemaID);
    }

    public String get_last_encoding_error() {
        return this.lastEncodingError;
    }

    public String get_last_decoding_error() {
        return this.lastDecodingError;
    }

    public boolean check_encode_decode_cycle(String jsonDocument, String namespace) {
        this.resetLastDecodingError();
        this.resetLastEncodingError();
        byte[] encoded_message = this.encode(jsonDocument, namespace);
        boolean result = false;
        if (encoded_message != null) {
            String decoded_message = this.decode(encoded_message, namespace);
            result = this.compareEncodedAndDecodedJSONFiles(jsonDocument, decoded_message);
        }
        return result;
    }

    public static byte[] toByteArray(String s) {
        return DatatypeConverter.parseHexBinary(s);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    @Override
    public float get_version() {
        return version;
    }

    private static BuiltInSchema getSchema(String namespace) {
        if (namespace_schema_mapping.containsKey(namespace)) {
            return namespace_schema_mapping.get(namespace);
        }
        return namespace_schema_mapping.get(namespace);
    }

    public static void main(String[] args) {
        EXICodecQuickTest.runFullEncodeDecodeTests();
        String json = "{\"V2G_Message\": {\"Header\": {\"SessionID\": \"C08CDF36985A7190\"}, \"Body\": {\"SessionSetupRes\": {\"ResponseCode\": \"OK_NewSessionEstablished\", \"EVSEID\": \"00\", \"DateTimeNow\": 1632218029}}}}";
        EXICodecQuickTest.runSingleJSONEncodeDecodeTest(json, DINSpec_70121);
    }
}

