/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXBErrorHandler
implements ErrorHandler {
    private ValidationEventHandler eventHandler;

    public JAXBErrorHandler(ValidationEventHandler validationEventHandler) {
        this.eventHandler = validationEventHandler;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.handleException(exception, 1);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.handleException(exception, 2);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.handleException(exception, 2);
    }

    private void handleException(SAXParseException exception, int severity) throws SAXException {
        ValidationEventImpl event;
        Throwable linkedException;
        ValidationEventLocatorImpl eventLocator = new ValidationEventLocatorImpl(exception);
        if (exception instanceof ValidatingMarshalRecord.MarshalSAXParseException) {
            eventLocator.setObject(((ValidatingMarshalRecord.MarshalSAXParseException)exception).getObject());
        }
        if ((linkedException = exception.getCause()) instanceof EclipseLinkException) {
            linkedException = exception.getCause();
        }
        if (!this.eventHandler.handleEvent(event = new ValidationEventImpl(severity, exception.getLocalizedMessage(), eventLocator, linkedException))) {
            if (linkedException instanceof EclipseLinkException) {
                throw (EclipseLinkException)linkedException;
            }
            throw exception;
        }
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.eventHandler;
    }
}

