import { _json, decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectLong as __expectLong, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectString as __expectString, limitedParseDouble as __limitedParseDouble, parseEpochTimestamp as __parseEpochTimestamp, take, withBaseException, } from "@aws-sdk/smithy-client";
import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { CodeDeployServiceException as __BaseException } from "../models/CodeDeployServiceException";
import { AlarmsLimitExceededException, ApplicationAlreadyExistsException, ApplicationDoesNotExistException, ApplicationLimitExceededException, ApplicationNameRequiredException, ArnNotSupportedException, BatchLimitExceededException, BucketNameFilterRequiredException, DeploymentAlreadyCompletedException, DeploymentConfigAlreadyExistsException, DeploymentConfigDoesNotExistException, DeploymentConfigInUseException, DeploymentConfigLimitExceededException, DeploymentConfigNameRequiredException, DeploymentDoesNotExistException, DeploymentGroupAlreadyExistsException, DeploymentGroupDoesNotExistException, DeploymentGroupLimitExceededException, DeploymentGroupNameRequiredException, DeploymentIdRequiredException, DeploymentIsNotInReadyStateException, DeploymentLimitExceededException, DeploymentNotStartedException, DeploymentTargetDoesNotExistException, DeploymentTargetIdRequiredException, DeploymentTargetListSizeExceededException, DescriptionTooLongException, ECSServiceMappingLimitExceededException, GitHubAccountTokenDoesNotExistException, GitHubAccountTokenNameRequiredException, IamArnRequiredException, IamSessionArnAlreadyRegisteredException, IamUserArnAlreadyRegisteredException, IamUserArnRequiredException, InstanceDoesNotExistException, InstanceIdRequiredException, InstanceLimitExceededException, InstanceNameAlreadyRegisteredException, InstanceNameRequiredException, InstanceNotRegisteredException, InvalidAlarmConfigException, InvalidApplicationNameException, InvalidArnException, InvalidAutoRollbackConfigException, InvalidAutoScalingGroupException, InvalidBlueGreenDeploymentConfigurationException, InvalidBucketNameFilterException, InvalidComputePlatformException, InvalidDeployedStateFilterException, InvalidDeploymentConfigNameException, InvalidDeploymentGroupNameException, InvalidDeploymentIdException, InvalidDeploymentInstanceTypeException, InvalidDeploymentStatusException, InvalidDeploymentStyleException, InvalidDeploymentTargetIdException, InvalidDeploymentWaitTypeException, InvalidEC2TagCombinationException, InvalidEC2TagException, InvalidECSServiceException, InvalidExternalIdException, InvalidFileExistsBehaviorException, InvalidGitHubAccountTokenException, InvalidGitHubAccountTokenNameException, InvalidIamSessionArnException, InvalidIamUserArnException, InvalidIgnoreApplicationStopFailuresValueException, InvalidInputException, InvalidInstanceNameException, InvalidInstanceStatusException, InvalidInstanceTypeException, InvalidKeyPrefixFilterException, InvalidLifecycleEventHookExecutionIdException, InvalidLifecycleEventHookExecutionStatusException, InvalidLoadBalancerInfoException, InvalidMinimumHealthyHostValueException, InvalidNextTokenException, InvalidOnPremisesTagCombinationException, InvalidOperationException, InvalidRegistrationStatusException, InvalidRevisionException, InvalidRoleException, InvalidSortByException, InvalidSortOrderException, InvalidTagException, InvalidTagFilterException, InvalidTagsToAddException, InvalidTargetFilterNameException, InvalidTargetGroupPairException, InvalidTargetInstancesException, InvalidTimeRangeException, InvalidTrafficRoutingConfigurationException, InvalidTriggerConfigException, InvalidUpdateOutdatedInstancesOnlyValueException, LifecycleEventAlreadyCompletedException, LifecycleHookLimitExceededException, MultipleIamArnsProvidedException, OperationNotSupportedException, ResourceArnRequiredException, ResourceValidationException, RevisionDoesNotExistException, RevisionRequiredException, RoleRequiredException, TagLimitExceededException, TagRequiredException, TagSetListLimitExceededException, ThrottlingException, TriggerTargetsLimitExceededException, UnsupportedActionForDeploymentTypeException, } from "../models/models_0";
export const se_AddTagsToOnPremisesInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("AddTagsToOnPremisesInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetApplicationRevisionsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetApplicationRevisions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetApplicationsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetApplications");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetDeploymentGroupsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetDeploymentGroups");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetDeploymentInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetDeploymentInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetDeploymentsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetDeployments");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetDeploymentTargetsCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetDeploymentTargets");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BatchGetOnPremisesInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("BatchGetOnPremisesInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ContinueDeploymentCommand = async (input, context) => {
    const headers = sharedHeaders("ContinueDeployment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateApplicationCommand = async (input, context) => {
    const headers = sharedHeaders("CreateApplication");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDeploymentCommand = async (input, context) => {
    const headers = sharedHeaders("CreateDeployment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDeploymentConfigCommand = async (input, context) => {
    const headers = sharedHeaders("CreateDeploymentConfig");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDeploymentGroupCommand = async (input, context) => {
    const headers = sharedHeaders("CreateDeploymentGroup");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteApplicationCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteApplication");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDeploymentConfigCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteDeploymentConfig");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDeploymentGroupCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteDeploymentGroup");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteGitHubAccountTokenCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteGitHubAccountToken");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteResourcesByExternalIdCommand = async (input, context) => {
    const headers = sharedHeaders("DeleteResourcesByExternalId");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterOnPremisesInstanceCommand = async (input, context) => {
    const headers = sharedHeaders("DeregisterOnPremisesInstance");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetApplicationCommand = async (input, context) => {
    const headers = sharedHeaders("GetApplication");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetApplicationRevisionCommand = async (input, context) => {
    const headers = sharedHeaders("GetApplicationRevision");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeploymentCommand = async (input, context) => {
    const headers = sharedHeaders("GetDeployment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeploymentConfigCommand = async (input, context) => {
    const headers = sharedHeaders("GetDeploymentConfig");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeploymentGroupCommand = async (input, context) => {
    const headers = sharedHeaders("GetDeploymentGroup");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeploymentInstanceCommand = async (input, context) => {
    const headers = sharedHeaders("GetDeploymentInstance");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetDeploymentTargetCommand = async (input, context) => {
    const headers = sharedHeaders("GetDeploymentTarget");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_GetOnPremisesInstanceCommand = async (input, context) => {
    const headers = sharedHeaders("GetOnPremisesInstance");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListApplicationRevisionsCommand = async (input, context) => {
    const headers = sharedHeaders("ListApplicationRevisions");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListApplicationsCommand = async (input, context) => {
    const headers = sharedHeaders("ListApplications");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListDeploymentConfigsCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeploymentConfigs");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListDeploymentGroupsCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeploymentGroups");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListDeploymentInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeploymentInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListDeploymentsCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeployments");
    let body;
    body = JSON.stringify(se_ListDeploymentsInput(input, context));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListDeploymentTargetsCommand = async (input, context) => {
    const headers = sharedHeaders("ListDeploymentTargets");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListGitHubAccountTokenNamesCommand = async (input, context) => {
    const headers = sharedHeaders("ListGitHubAccountTokenNames");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListOnPremisesInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("ListOnPremisesInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const headers = sharedHeaders("ListTagsForResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PutLifecycleEventHookExecutionStatusCommand = async (input, context) => {
    const headers = sharedHeaders("PutLifecycleEventHookExecutionStatus");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterApplicationRevisionCommand = async (input, context) => {
    const headers = sharedHeaders("RegisterApplicationRevision");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterOnPremisesInstanceCommand = async (input, context) => {
    const headers = sharedHeaders("RegisterOnPremisesInstance");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveTagsFromOnPremisesInstancesCommand = async (input, context) => {
    const headers = sharedHeaders("RemoveTagsFromOnPremisesInstances");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SkipWaitTimeForInstanceTerminationCommand = async (input, context) => {
    const headers = sharedHeaders("SkipWaitTimeForInstanceTermination");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopDeploymentCommand = async (input, context) => {
    const headers = sharedHeaders("StopDeployment");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_TagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("TagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UntagResourceCommand = async (input, context) => {
    const headers = sharedHeaders("UntagResource");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateApplicationCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateApplication");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_UpdateDeploymentGroupCommand = async (input, context) => {
    const headers = sharedHeaders("UpdateDeploymentGroup");
    let body;
    body = JSON.stringify(_json(input));
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_AddTagsToOnPremisesInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_AddTagsToOnPremisesInstancesCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_AddTagsToOnPremisesInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InstanceLimitExceededException":
        case "com.amazonaws.codedeploy#InstanceLimitExceededException":
            throw await de_InstanceLimitExceededExceptionRes(parsedOutput, context);
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InstanceNotRegisteredException":
        case "com.amazonaws.codedeploy#InstanceNotRegisteredException":
            throw await de_InstanceNotRegisteredExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        case "InvalidTagException":
        case "com.amazonaws.codedeploy#InvalidTagException":
            throw await de_InvalidTagExceptionRes(parsedOutput, context);
        case "TagLimitExceededException":
        case "com.amazonaws.codedeploy#TagLimitExceededException":
            throw await de_TagLimitExceededExceptionRes(parsedOutput, context);
        case "TagRequiredException":
        case "com.amazonaws.codedeploy#TagRequiredException":
            throw await de_TagRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetApplicationRevisionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetApplicationRevisionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetApplicationRevisionsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetApplicationRevisionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidRevisionException":
        case "com.amazonaws.codedeploy#InvalidRevisionException":
            throw await de_InvalidRevisionExceptionRes(parsedOutput, context);
        case "RevisionRequiredException":
        case "com.amazonaws.codedeploy#RevisionRequiredException":
            throw await de_RevisionRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetApplicationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetApplicationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetApplicationsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetApplicationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetDeploymentGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetDeploymentGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetDeploymentGroupsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetDeploymentGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetDeploymentInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetDeploymentInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetDeploymentInstancesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetDeploymentInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InstanceIdRequiredException":
        case "com.amazonaws.codedeploy#InstanceIdRequiredException":
            throw await de_InstanceIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetDeploymentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetDeploymentsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetDeploymentsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetDeploymentsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetDeploymentTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetDeploymentTargetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetDeploymentTargetsOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetDeploymentTargetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentNotStartedException":
        case "com.amazonaws.codedeploy#DeploymentNotStartedException":
            throw await de_DeploymentNotStartedExceptionRes(parsedOutput, context);
        case "DeploymentTargetDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentTargetDoesNotExistException":
            throw await de_DeploymentTargetDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentTargetIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentTargetIdRequiredException":
            throw await de_DeploymentTargetIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentTargetListSizeExceededException":
        case "com.amazonaws.codedeploy#DeploymentTargetListSizeExceededException":
            throw await de_DeploymentTargetListSizeExceededExceptionRes(parsedOutput, context);
        case "InstanceDoesNotExistException":
        case "com.amazonaws.codedeploy#InstanceDoesNotExistException":
            throw await de_InstanceDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidDeploymentTargetIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentTargetIdException":
            throw await de_InvalidDeploymentTargetIdExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_BatchGetOnPremisesInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_BatchGetOnPremisesInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_BatchGetOnPremisesInstancesOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_BatchGetOnPremisesInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BatchLimitExceededException":
        case "com.amazonaws.codedeploy#BatchLimitExceededException":
            throw await de_BatchLimitExceededExceptionRes(parsedOutput, context);
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ContinueDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ContinueDeploymentCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_ContinueDeploymentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentAlreadyCompletedException":
        case "com.amazonaws.codedeploy#DeploymentAlreadyCompletedException":
            throw await de_DeploymentAlreadyCompletedExceptionRes(parsedOutput, context);
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentIsNotInReadyStateException":
        case "com.amazonaws.codedeploy#DeploymentIsNotInReadyStateException":
            throw await de_DeploymentIsNotInReadyStateExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidDeploymentStatusException":
        case "com.amazonaws.codedeploy#InvalidDeploymentStatusException":
            throw await de_InvalidDeploymentStatusExceptionRes(parsedOutput, context);
        case "InvalidDeploymentWaitTypeException":
        case "com.amazonaws.codedeploy#InvalidDeploymentWaitTypeException":
            throw await de_InvalidDeploymentWaitTypeExceptionRes(parsedOutput, context);
        case "UnsupportedActionForDeploymentTypeException":
        case "com.amazonaws.codedeploy#UnsupportedActionForDeploymentTypeException":
            throw await de_UnsupportedActionForDeploymentTypeExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateApplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateApplicationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationAlreadyExistsException":
        case "com.amazonaws.codedeploy#ApplicationAlreadyExistsException":
            throw await de_ApplicationAlreadyExistsExceptionRes(parsedOutput, context);
        case "ApplicationLimitExceededException":
        case "com.amazonaws.codedeploy#ApplicationLimitExceededException":
            throw await de_ApplicationLimitExceededExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidTagsToAddException":
        case "com.amazonaws.codedeploy#InvalidTagsToAddException":
            throw await de_InvalidTagsToAddExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateDeploymentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateDeploymentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AlarmsLimitExceededException":
        case "com.amazonaws.codedeploy#AlarmsLimitExceededException":
            throw await de_AlarmsLimitExceededExceptionRes(parsedOutput, context);
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentLimitExceededException":
        case "com.amazonaws.codedeploy#DeploymentLimitExceededException":
            throw await de_DeploymentLimitExceededExceptionRes(parsedOutput, context);
        case "DescriptionTooLongException":
        case "com.amazonaws.codedeploy#DescriptionTooLongException":
            throw await de_DescriptionTooLongExceptionRes(parsedOutput, context);
        case "InvalidAlarmConfigException":
        case "com.amazonaws.codedeploy#InvalidAlarmConfigException":
            throw await de_InvalidAlarmConfigExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidAutoRollbackConfigException":
        case "com.amazonaws.codedeploy#InvalidAutoRollbackConfigException":
            throw await de_InvalidAutoRollbackConfigExceptionRes(parsedOutput, context);
        case "InvalidAutoScalingGroupException":
        case "com.amazonaws.codedeploy#InvalidAutoScalingGroupException":
            throw await de_InvalidAutoScalingGroupExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        case "InvalidFileExistsBehaviorException":
        case "com.amazonaws.codedeploy#InvalidFileExistsBehaviorException":
            throw await de_InvalidFileExistsBehaviorExceptionRes(parsedOutput, context);
        case "InvalidGitHubAccountTokenException":
        case "com.amazonaws.codedeploy#InvalidGitHubAccountTokenException":
            throw await de_InvalidGitHubAccountTokenExceptionRes(parsedOutput, context);
        case "InvalidIgnoreApplicationStopFailuresValueException":
        case "com.amazonaws.codedeploy#InvalidIgnoreApplicationStopFailuresValueException":
            throw await de_InvalidIgnoreApplicationStopFailuresValueExceptionRes(parsedOutput, context);
        case "InvalidLoadBalancerInfoException":
        case "com.amazonaws.codedeploy#InvalidLoadBalancerInfoException":
            throw await de_InvalidLoadBalancerInfoExceptionRes(parsedOutput, context);
        case "InvalidRevisionException":
        case "com.amazonaws.codedeploy#InvalidRevisionException":
            throw await de_InvalidRevisionExceptionRes(parsedOutput, context);
        case "InvalidRoleException":
        case "com.amazonaws.codedeploy#InvalidRoleException":
            throw await de_InvalidRoleExceptionRes(parsedOutput, context);
        case "InvalidTargetInstancesException":
        case "com.amazonaws.codedeploy#InvalidTargetInstancesException":
            throw await de_InvalidTargetInstancesExceptionRes(parsedOutput, context);
        case "InvalidTrafficRoutingConfigurationException":
        case "com.amazonaws.codedeploy#InvalidTrafficRoutingConfigurationException":
            throw await de_InvalidTrafficRoutingConfigurationExceptionRes(parsedOutput, context);
        case "InvalidUpdateOutdatedInstancesOnlyValueException":
        case "com.amazonaws.codedeploy#InvalidUpdateOutdatedInstancesOnlyValueException":
            throw await de_InvalidUpdateOutdatedInstancesOnlyValueExceptionRes(parsedOutput, context);
        case "RevisionDoesNotExistException":
        case "com.amazonaws.codedeploy#RevisionDoesNotExistException":
            throw await de_RevisionDoesNotExistExceptionRes(parsedOutput, context);
        case "RevisionRequiredException":
        case "com.amazonaws.codedeploy#RevisionRequiredException":
            throw await de_RevisionRequiredExceptionRes(parsedOutput, context);
        case "ThrottlingException":
        case "com.amazonaws.codedeploy#ThrottlingException":
            throw await de_ThrottlingExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateDeploymentConfigCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateDeploymentConfigCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateDeploymentConfigCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentConfigAlreadyExistsException":
        case "com.amazonaws.codedeploy#DeploymentConfigAlreadyExistsException":
            throw await de_DeploymentConfigAlreadyExistsExceptionRes(parsedOutput, context);
        case "DeploymentConfigLimitExceededException":
        case "com.amazonaws.codedeploy#DeploymentConfigLimitExceededException":
            throw await de_DeploymentConfigLimitExceededExceptionRes(parsedOutput, context);
        case "DeploymentConfigNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentConfigNameRequiredException":
            throw await de_DeploymentConfigNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        case "InvalidMinimumHealthyHostValueException":
        case "com.amazonaws.codedeploy#InvalidMinimumHealthyHostValueException":
            throw await de_InvalidMinimumHealthyHostValueExceptionRes(parsedOutput, context);
        case "InvalidTrafficRoutingConfigurationException":
        case "com.amazonaws.codedeploy#InvalidTrafficRoutingConfigurationException":
            throw await de_InvalidTrafficRoutingConfigurationExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_CreateDeploymentGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CreateDeploymentGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CreateDeploymentGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AlarmsLimitExceededException":
        case "com.amazonaws.codedeploy#AlarmsLimitExceededException":
            throw await de_AlarmsLimitExceededExceptionRes(parsedOutput, context);
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupAlreadyExistsException":
        case "com.amazonaws.codedeploy#DeploymentGroupAlreadyExistsException":
            throw await de_DeploymentGroupAlreadyExistsExceptionRes(parsedOutput, context);
        case "DeploymentGroupLimitExceededException":
        case "com.amazonaws.codedeploy#DeploymentGroupLimitExceededException":
            throw await de_DeploymentGroupLimitExceededExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "ECSServiceMappingLimitExceededException":
        case "com.amazonaws.codedeploy#ECSServiceMappingLimitExceededException":
            throw await de_ECSServiceMappingLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidAlarmConfigException":
        case "com.amazonaws.codedeploy#InvalidAlarmConfigException":
            throw await de_InvalidAlarmConfigExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidAutoRollbackConfigException":
        case "com.amazonaws.codedeploy#InvalidAutoRollbackConfigException":
            throw await de_InvalidAutoRollbackConfigExceptionRes(parsedOutput, context);
        case "InvalidAutoScalingGroupException":
        case "com.amazonaws.codedeploy#InvalidAutoScalingGroupException":
            throw await de_InvalidAutoScalingGroupExceptionRes(parsedOutput, context);
        case "InvalidBlueGreenDeploymentConfigurationException":
        case "com.amazonaws.codedeploy#InvalidBlueGreenDeploymentConfigurationException":
            throw await de_InvalidBlueGreenDeploymentConfigurationExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentStyleException":
        case "com.amazonaws.codedeploy#InvalidDeploymentStyleException":
            throw await de_InvalidDeploymentStyleExceptionRes(parsedOutput, context);
        case "InvalidEC2TagCombinationException":
        case "com.amazonaws.codedeploy#InvalidEC2TagCombinationException":
            throw await de_InvalidEC2TagCombinationExceptionRes(parsedOutput, context);
        case "InvalidEC2TagException":
        case "com.amazonaws.codedeploy#InvalidEC2TagException":
            throw await de_InvalidEC2TagExceptionRes(parsedOutput, context);
        case "InvalidECSServiceException":
        case "com.amazonaws.codedeploy#InvalidECSServiceException":
            throw await de_InvalidECSServiceExceptionRes(parsedOutput, context);
        case "InvalidInputException":
        case "com.amazonaws.codedeploy#InvalidInputException":
            throw await de_InvalidInputExceptionRes(parsedOutput, context);
        case "InvalidLoadBalancerInfoException":
        case "com.amazonaws.codedeploy#InvalidLoadBalancerInfoException":
            throw await de_InvalidLoadBalancerInfoExceptionRes(parsedOutput, context);
        case "InvalidOnPremisesTagCombinationException":
        case "com.amazonaws.codedeploy#InvalidOnPremisesTagCombinationException":
            throw await de_InvalidOnPremisesTagCombinationExceptionRes(parsedOutput, context);
        case "InvalidRoleException":
        case "com.amazonaws.codedeploy#InvalidRoleException":
            throw await de_InvalidRoleExceptionRes(parsedOutput, context);
        case "InvalidTagException":
        case "com.amazonaws.codedeploy#InvalidTagException":
            throw await de_InvalidTagExceptionRes(parsedOutput, context);
        case "InvalidTagsToAddException":
        case "com.amazonaws.codedeploy#InvalidTagsToAddException":
            throw await de_InvalidTagsToAddExceptionRes(parsedOutput, context);
        case "InvalidTargetGroupPairException":
        case "com.amazonaws.codedeploy#InvalidTargetGroupPairException":
            throw await de_InvalidTargetGroupPairExceptionRes(parsedOutput, context);
        case "InvalidTrafficRoutingConfigurationException":
        case "com.amazonaws.codedeploy#InvalidTrafficRoutingConfigurationException":
            throw await de_InvalidTrafficRoutingConfigurationExceptionRes(parsedOutput, context);
        case "InvalidTriggerConfigException":
        case "com.amazonaws.codedeploy#InvalidTriggerConfigException":
            throw await de_InvalidTriggerConfigExceptionRes(parsedOutput, context);
        case "LifecycleHookLimitExceededException":
        case "com.amazonaws.codedeploy#LifecycleHookLimitExceededException":
            throw await de_LifecycleHookLimitExceededExceptionRes(parsedOutput, context);
        case "RoleRequiredException":
        case "com.amazonaws.codedeploy#RoleRequiredException":
            throw await de_RoleRequiredExceptionRes(parsedOutput, context);
        case "TagSetListLimitExceededException":
        case "com.amazonaws.codedeploy#TagSetListLimitExceededException":
            throw await de_TagSetListLimitExceededExceptionRes(parsedOutput, context);
        case "ThrottlingException":
        case "com.amazonaws.codedeploy#ThrottlingException":
            throw await de_ThrottlingExceptionRes(parsedOutput, context);
        case "TriggerTargetsLimitExceededException":
        case "com.amazonaws.codedeploy#TriggerTargetsLimitExceededException":
            throw await de_TriggerTargetsLimitExceededExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteApplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteApplicationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_DeleteApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidRoleException":
        case "com.amazonaws.codedeploy#InvalidRoleException":
            throw await de_InvalidRoleExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteDeploymentConfigCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteDeploymentConfigCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_DeleteDeploymentConfigCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentConfigInUseException":
        case "com.amazonaws.codedeploy#DeploymentConfigInUseException":
            throw await de_DeploymentConfigInUseExceptionRes(parsedOutput, context);
        case "DeploymentConfigNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentConfigNameRequiredException":
            throw await de_DeploymentConfigNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        case "InvalidOperationException":
        case "com.amazonaws.codedeploy#InvalidOperationException":
            throw await de_InvalidOperationExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteDeploymentGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteDeploymentGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteDeploymentGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        case "InvalidRoleException":
        case "com.amazonaws.codedeploy#InvalidRoleException":
            throw await de_InvalidRoleExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteGitHubAccountTokenCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteGitHubAccountTokenCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteGitHubAccountTokenCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "GitHubAccountTokenDoesNotExistException":
        case "com.amazonaws.codedeploy#GitHubAccountTokenDoesNotExistException":
            throw await de_GitHubAccountTokenDoesNotExistExceptionRes(parsedOutput, context);
        case "GitHubAccountTokenNameRequiredException":
        case "com.amazonaws.codedeploy#GitHubAccountTokenNameRequiredException":
            throw await de_GitHubAccountTokenNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidGitHubAccountTokenNameException":
        case "com.amazonaws.codedeploy#InvalidGitHubAccountTokenNameException":
            throw await de_InvalidGitHubAccountTokenNameExceptionRes(parsedOutput, context);
        case "OperationNotSupportedException":
        case "com.amazonaws.codedeploy#OperationNotSupportedException":
            throw await de_OperationNotSupportedExceptionRes(parsedOutput, context);
        case "ResourceValidationException":
        case "com.amazonaws.codedeploy#ResourceValidationException":
            throw await de_ResourceValidationExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_DeleteResourcesByExternalIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeleteResourcesByExternalIdCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_DeleteResourcesByExternalIdCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    return throwDefaultError({
        output,
        parsedBody,
        errorCode,
    });
};
export const de_DeregisterOnPremisesInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_DeregisterOnPremisesInstanceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_DeregisterOnPremisesInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetApplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetApplicationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetApplicationOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetApplicationRevisionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetApplicationRevisionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetApplicationRevisionOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetApplicationRevisionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidRevisionException":
        case "com.amazonaws.codedeploy#InvalidRevisionException":
            throw await de_InvalidRevisionExceptionRes(parsedOutput, context);
        case "RevisionDoesNotExistException":
        case "com.amazonaws.codedeploy#RevisionDoesNotExistException":
            throw await de_RevisionDoesNotExistExceptionRes(parsedOutput, context);
        case "RevisionRequiredException":
        case "com.amazonaws.codedeploy#RevisionRequiredException":
            throw await de_RevisionRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetDeploymentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeploymentOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetDeploymentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetDeploymentConfigCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetDeploymentConfigCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeploymentConfigOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetDeploymentConfigCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentConfigNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentConfigNameRequiredException":
            throw await de_DeploymentConfigNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetDeploymentGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetDeploymentGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeploymentGroupOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetDeploymentGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetDeploymentInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetDeploymentInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeploymentInstanceOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetDeploymentInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InstanceDoesNotExistException":
        case "com.amazonaws.codedeploy#InstanceDoesNotExistException":
            throw await de_InstanceDoesNotExistExceptionRes(parsedOutput, context);
        case "InstanceIdRequiredException":
        case "com.amazonaws.codedeploy#InstanceIdRequiredException":
            throw await de_InstanceIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetDeploymentTargetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetDeploymentTargetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetDeploymentTargetOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetDeploymentTargetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentNotStartedException":
        case "com.amazonaws.codedeploy#DeploymentNotStartedException":
            throw await de_DeploymentNotStartedExceptionRes(parsedOutput, context);
        case "DeploymentTargetDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentTargetDoesNotExistException":
            throw await de_DeploymentTargetDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentTargetIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentTargetIdRequiredException":
            throw await de_DeploymentTargetIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidDeploymentTargetIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentTargetIdException":
            throw await de_InvalidDeploymentTargetIdExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_GetOnPremisesInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_GetOnPremisesInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GetOnPremisesInstanceOutput(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_GetOnPremisesInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InstanceNotRegisteredException":
        case "com.amazonaws.codedeploy#InstanceNotRegisteredException":
            throw await de_InstanceNotRegisteredExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListApplicationRevisionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListApplicationRevisionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListApplicationRevisionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "BucketNameFilterRequiredException":
        case "com.amazonaws.codedeploy#BucketNameFilterRequiredException":
            throw await de_BucketNameFilterRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidBucketNameFilterException":
        case "com.amazonaws.codedeploy#InvalidBucketNameFilterException":
            throw await de_InvalidBucketNameFilterExceptionRes(parsedOutput, context);
        case "InvalidDeployedStateFilterException":
        case "com.amazonaws.codedeploy#InvalidDeployedStateFilterException":
            throw await de_InvalidDeployedStateFilterExceptionRes(parsedOutput, context);
        case "InvalidKeyPrefixFilterException":
        case "com.amazonaws.codedeploy#InvalidKeyPrefixFilterException":
            throw await de_InvalidKeyPrefixFilterExceptionRes(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        case "InvalidSortByException":
        case "com.amazonaws.codedeploy#InvalidSortByException":
            throw await de_InvalidSortByExceptionRes(parsedOutput, context);
        case "InvalidSortOrderException":
        case "com.amazonaws.codedeploy#InvalidSortOrderException":
            throw await de_InvalidSortOrderExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListApplicationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListApplicationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListApplicationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListDeploymentConfigsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeploymentConfigsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListDeploymentConfigsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListDeploymentGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeploymentGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListDeploymentGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListDeploymentInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeploymentInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListDeploymentInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentNotStartedException":
        case "com.amazonaws.codedeploy#DeploymentNotStartedException":
            throw await de_DeploymentNotStartedExceptionRes(parsedOutput, context);
        case "InvalidComputePlatformException":
        case "com.amazonaws.codedeploy#InvalidComputePlatformException":
            throw await de_InvalidComputePlatformExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidDeploymentInstanceTypeException":
        case "com.amazonaws.codedeploy#InvalidDeploymentInstanceTypeException":
            throw await de_InvalidDeploymentInstanceTypeExceptionRes(parsedOutput, context);
        case "InvalidInstanceStatusException":
        case "com.amazonaws.codedeploy#InvalidInstanceStatusException":
            throw await de_InvalidInstanceStatusExceptionRes(parsedOutput, context);
        case "InvalidInstanceTypeException":
        case "com.amazonaws.codedeploy#InvalidInstanceTypeException":
            throw await de_InvalidInstanceTypeExceptionRes(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        case "InvalidTargetFilterNameException":
        case "com.amazonaws.codedeploy#InvalidTargetFilterNameException":
            throw await de_InvalidTargetFilterNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListDeploymentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeploymentsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListDeploymentsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentStatusException":
        case "com.amazonaws.codedeploy#InvalidDeploymentStatusException":
            throw await de_InvalidDeploymentStatusExceptionRes(parsedOutput, context);
        case "InvalidExternalIdException":
        case "com.amazonaws.codedeploy#InvalidExternalIdException":
            throw await de_InvalidExternalIdExceptionRes(parsedOutput, context);
        case "InvalidInputException":
        case "com.amazonaws.codedeploy#InvalidInputException":
            throw await de_InvalidInputExceptionRes(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        case "InvalidTimeRangeException":
        case "com.amazonaws.codedeploy#InvalidTimeRangeException":
            throw await de_InvalidTimeRangeExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListDeploymentTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListDeploymentTargetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListDeploymentTargetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentNotStartedException":
        case "com.amazonaws.codedeploy#DeploymentNotStartedException":
            throw await de_DeploymentNotStartedExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidDeploymentInstanceTypeException":
        case "com.amazonaws.codedeploy#InvalidDeploymentInstanceTypeException":
            throw await de_InvalidDeploymentInstanceTypeExceptionRes(parsedOutput, context);
        case "InvalidInstanceStatusException":
        case "com.amazonaws.codedeploy#InvalidInstanceStatusException":
            throw await de_InvalidInstanceStatusExceptionRes(parsedOutput, context);
        case "InvalidInstanceTypeException":
        case "com.amazonaws.codedeploy#InvalidInstanceTypeException":
            throw await de_InvalidInstanceTypeExceptionRes(parsedOutput, context);
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListGitHubAccountTokenNamesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListGitHubAccountTokenNamesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListGitHubAccountTokenNamesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        case "OperationNotSupportedException":
        case "com.amazonaws.codedeploy#OperationNotSupportedException":
            throw await de_OperationNotSupportedExceptionRes(parsedOutput, context);
        case "ResourceValidationException":
        case "com.amazonaws.codedeploy#ResourceValidationException":
            throw await de_ResourceValidationExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListOnPremisesInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListOnPremisesInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListOnPremisesInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InvalidNextTokenException":
        case "com.amazonaws.codedeploy#InvalidNextTokenException":
            throw await de_InvalidNextTokenExceptionRes(parsedOutput, context);
        case "InvalidRegistrationStatusException":
        case "com.amazonaws.codedeploy#InvalidRegistrationStatusException":
            throw await de_InvalidRegistrationStatusExceptionRes(parsedOutput, context);
        case "InvalidTagFilterException":
        case "com.amazonaws.codedeploy#InvalidTagFilterException":
            throw await de_InvalidTagFilterExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ArnNotSupportedException":
        case "com.amazonaws.codedeploy#ArnNotSupportedException":
            throw await de_ArnNotSupportedExceptionRes(parsedOutput, context);
        case "InvalidArnException":
        case "com.amazonaws.codedeploy#InvalidArnException":
            throw await de_InvalidArnExceptionRes(parsedOutput, context);
        case "ResourceArnRequiredException":
        case "com.amazonaws.codedeploy#ResourceArnRequiredException":
            throw await de_ResourceArnRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_PutLifecycleEventHookExecutionStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_PutLifecycleEventHookExecutionStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_PutLifecycleEventHookExecutionStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "InvalidLifecycleEventHookExecutionIdException":
        case "com.amazonaws.codedeploy#InvalidLifecycleEventHookExecutionIdException":
            throw await de_InvalidLifecycleEventHookExecutionIdExceptionRes(parsedOutput, context);
        case "InvalidLifecycleEventHookExecutionStatusException":
        case "com.amazonaws.codedeploy#InvalidLifecycleEventHookExecutionStatusException":
            throw await de_InvalidLifecycleEventHookExecutionStatusExceptionRes(parsedOutput, context);
        case "LifecycleEventAlreadyCompletedException":
        case "com.amazonaws.codedeploy#LifecycleEventAlreadyCompletedException":
            throw await de_LifecycleEventAlreadyCompletedExceptionRes(parsedOutput, context);
        case "UnsupportedActionForDeploymentTypeException":
        case "com.amazonaws.codedeploy#UnsupportedActionForDeploymentTypeException":
            throw await de_UnsupportedActionForDeploymentTypeExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_RegisterApplicationRevisionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RegisterApplicationRevisionCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_RegisterApplicationRevisionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DescriptionTooLongException":
        case "com.amazonaws.codedeploy#DescriptionTooLongException":
            throw await de_DescriptionTooLongExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidRevisionException":
        case "com.amazonaws.codedeploy#InvalidRevisionException":
            throw await de_InvalidRevisionExceptionRes(parsedOutput, context);
        case "RevisionRequiredException":
        case "com.amazonaws.codedeploy#RevisionRequiredException":
            throw await de_RevisionRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_RegisterOnPremisesInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RegisterOnPremisesInstanceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_RegisterOnPremisesInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "IamArnRequiredException":
        case "com.amazonaws.codedeploy#IamArnRequiredException":
            throw await de_IamArnRequiredExceptionRes(parsedOutput, context);
        case "IamSessionArnAlreadyRegisteredException":
        case "com.amazonaws.codedeploy#IamSessionArnAlreadyRegisteredException":
            throw await de_IamSessionArnAlreadyRegisteredExceptionRes(parsedOutput, context);
        case "IamUserArnAlreadyRegisteredException":
        case "com.amazonaws.codedeploy#IamUserArnAlreadyRegisteredException":
            throw await de_IamUserArnAlreadyRegisteredExceptionRes(parsedOutput, context);
        case "IamUserArnRequiredException":
        case "com.amazonaws.codedeploy#IamUserArnRequiredException":
            throw await de_IamUserArnRequiredExceptionRes(parsedOutput, context);
        case "InstanceNameAlreadyRegisteredException":
        case "com.amazonaws.codedeploy#InstanceNameAlreadyRegisteredException":
            throw await de_InstanceNameAlreadyRegisteredExceptionRes(parsedOutput, context);
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidIamSessionArnException":
        case "com.amazonaws.codedeploy#InvalidIamSessionArnException":
            throw await de_InvalidIamSessionArnExceptionRes(parsedOutput, context);
        case "InvalidIamUserArnException":
        case "com.amazonaws.codedeploy#InvalidIamUserArnException":
            throw await de_InvalidIamUserArnExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        case "MultipleIamArnsProvidedException":
        case "com.amazonaws.codedeploy#MultipleIamArnsProvidedException":
            throw await de_MultipleIamArnsProvidedExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_RemoveTagsFromOnPremisesInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_RemoveTagsFromOnPremisesInstancesCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_RemoveTagsFromOnPremisesInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "InstanceLimitExceededException":
        case "com.amazonaws.codedeploy#InstanceLimitExceededException":
            throw await de_InstanceLimitExceededExceptionRes(parsedOutput, context);
        case "InstanceNameRequiredException":
        case "com.amazonaws.codedeploy#InstanceNameRequiredException":
            throw await de_InstanceNameRequiredExceptionRes(parsedOutput, context);
        case "InstanceNotRegisteredException":
        case "com.amazonaws.codedeploy#InstanceNotRegisteredException":
            throw await de_InstanceNotRegisteredExceptionRes(parsedOutput, context);
        case "InvalidInstanceNameException":
        case "com.amazonaws.codedeploy#InvalidInstanceNameException":
            throw await de_InvalidInstanceNameExceptionRes(parsedOutput, context);
        case "InvalidTagException":
        case "com.amazonaws.codedeploy#InvalidTagException":
            throw await de_InvalidTagExceptionRes(parsedOutput, context);
        case "TagLimitExceededException":
        case "com.amazonaws.codedeploy#TagLimitExceededException":
            throw await de_TagLimitExceededExceptionRes(parsedOutput, context);
        case "TagRequiredException":
        case "com.amazonaws.codedeploy#TagRequiredException":
            throw await de_TagRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_SkipWaitTimeForInstanceTerminationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_SkipWaitTimeForInstanceTerminationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_SkipWaitTimeForInstanceTerminationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentAlreadyCompletedException":
        case "com.amazonaws.codedeploy#DeploymentAlreadyCompletedException":
            throw await de_DeploymentAlreadyCompletedExceptionRes(parsedOutput, context);
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "DeploymentNotStartedException":
        case "com.amazonaws.codedeploy#DeploymentNotStartedException":
            throw await de_DeploymentNotStartedExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "UnsupportedActionForDeploymentTypeException":
        case "com.amazonaws.codedeploy#UnsupportedActionForDeploymentTypeException":
            throw await de_UnsupportedActionForDeploymentTypeExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_StopDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_StopDeploymentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_StopDeploymentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DeploymentAlreadyCompletedException":
        case "com.amazonaws.codedeploy#DeploymentAlreadyCompletedException":
            throw await de_DeploymentAlreadyCompletedExceptionRes(parsedOutput, context);
        case "DeploymentDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentDoesNotExistException":
            throw await de_DeploymentDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentIdRequiredException":
        case "com.amazonaws.codedeploy#DeploymentIdRequiredException":
            throw await de_DeploymentIdRequiredExceptionRes(parsedOutput, context);
        case "InvalidDeploymentIdException":
        case "com.amazonaws.codedeploy#InvalidDeploymentIdException":
            throw await de_InvalidDeploymentIdExceptionRes(parsedOutput, context);
        case "UnsupportedActionForDeploymentTypeException":
        case "com.amazonaws.codedeploy#UnsupportedActionForDeploymentTypeException":
            throw await de_UnsupportedActionForDeploymentTypeExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ArnNotSupportedException":
        case "com.amazonaws.codedeploy#ArnNotSupportedException":
            throw await de_ArnNotSupportedExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidArnException":
        case "com.amazonaws.codedeploy#InvalidArnException":
            throw await de_InvalidArnExceptionRes(parsedOutput, context);
        case "InvalidTagsToAddException":
        case "com.amazonaws.codedeploy#InvalidTagsToAddException":
            throw await de_InvalidTagsToAddExceptionRes(parsedOutput, context);
        case "ResourceArnRequiredException":
        case "com.amazonaws.codedeploy#ResourceArnRequiredException":
            throw await de_ResourceArnRequiredExceptionRes(parsedOutput, context);
        case "TagRequiredException":
        case "com.amazonaws.codedeploy#TagRequiredException":
            throw await de_TagRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ArnNotSupportedException":
        case "com.amazonaws.codedeploy#ArnNotSupportedException":
            throw await de_ArnNotSupportedExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "InvalidArnException":
        case "com.amazonaws.codedeploy#InvalidArnException":
            throw await de_InvalidArnExceptionRes(parsedOutput, context);
        case "InvalidTagsToAddException":
        case "com.amazonaws.codedeploy#InvalidTagsToAddException":
            throw await de_InvalidTagsToAddExceptionRes(parsedOutput, context);
        case "ResourceArnRequiredException":
        case "com.amazonaws.codedeploy#ResourceArnRequiredException":
            throw await de_ResourceArnRequiredExceptionRes(parsedOutput, context);
        case "TagRequiredException":
        case "com.amazonaws.codedeploy#TagRequiredException":
            throw await de_TagRequiredExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateApplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateApplicationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
const de_UpdateApplicationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "ApplicationAlreadyExistsException":
        case "com.amazonaws.codedeploy#ApplicationAlreadyExistsException":
            throw await de_ApplicationAlreadyExistsExceptionRes(parsedOutput, context);
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
export const de_UpdateDeploymentGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_UpdateDeploymentGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = _json(data);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_UpdateDeploymentGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AlarmsLimitExceededException":
        case "com.amazonaws.codedeploy#AlarmsLimitExceededException":
            throw await de_AlarmsLimitExceededExceptionRes(parsedOutput, context);
        case "ApplicationDoesNotExistException":
        case "com.amazonaws.codedeploy#ApplicationDoesNotExistException":
            throw await de_ApplicationDoesNotExistExceptionRes(parsedOutput, context);
        case "ApplicationNameRequiredException":
        case "com.amazonaws.codedeploy#ApplicationNameRequiredException":
            throw await de_ApplicationNameRequiredExceptionRes(parsedOutput, context);
        case "DeploymentConfigDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentConfigDoesNotExistException":
            throw await de_DeploymentConfigDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupAlreadyExistsException":
        case "com.amazonaws.codedeploy#DeploymentGroupAlreadyExistsException":
            throw await de_DeploymentGroupAlreadyExistsExceptionRes(parsedOutput, context);
        case "DeploymentGroupDoesNotExistException":
        case "com.amazonaws.codedeploy#DeploymentGroupDoesNotExistException":
            throw await de_DeploymentGroupDoesNotExistExceptionRes(parsedOutput, context);
        case "DeploymentGroupNameRequiredException":
        case "com.amazonaws.codedeploy#DeploymentGroupNameRequiredException":
            throw await de_DeploymentGroupNameRequiredExceptionRes(parsedOutput, context);
        case "ECSServiceMappingLimitExceededException":
        case "com.amazonaws.codedeploy#ECSServiceMappingLimitExceededException":
            throw await de_ECSServiceMappingLimitExceededExceptionRes(parsedOutput, context);
        case "InvalidAlarmConfigException":
        case "com.amazonaws.codedeploy#InvalidAlarmConfigException":
            throw await de_InvalidAlarmConfigExceptionRes(parsedOutput, context);
        case "InvalidApplicationNameException":
        case "com.amazonaws.codedeploy#InvalidApplicationNameException":
            throw await de_InvalidApplicationNameExceptionRes(parsedOutput, context);
        case "InvalidAutoRollbackConfigException":
        case "com.amazonaws.codedeploy#InvalidAutoRollbackConfigException":
            throw await de_InvalidAutoRollbackConfigExceptionRes(parsedOutput, context);
        case "InvalidAutoScalingGroupException":
        case "com.amazonaws.codedeploy#InvalidAutoScalingGroupException":
            throw await de_InvalidAutoScalingGroupExceptionRes(parsedOutput, context);
        case "InvalidBlueGreenDeploymentConfigurationException":
        case "com.amazonaws.codedeploy#InvalidBlueGreenDeploymentConfigurationException":
            throw await de_InvalidBlueGreenDeploymentConfigurationExceptionRes(parsedOutput, context);
        case "InvalidDeploymentConfigNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentConfigNameException":
            throw await de_InvalidDeploymentConfigNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentGroupNameException":
        case "com.amazonaws.codedeploy#InvalidDeploymentGroupNameException":
            throw await de_InvalidDeploymentGroupNameExceptionRes(parsedOutput, context);
        case "InvalidDeploymentStyleException":
        case "com.amazonaws.codedeploy#InvalidDeploymentStyleException":
            throw await de_InvalidDeploymentStyleExceptionRes(parsedOutput, context);
        case "InvalidEC2TagCombinationException":
        case "com.amazonaws.codedeploy#InvalidEC2TagCombinationException":
            throw await de_InvalidEC2TagCombinationExceptionRes(parsedOutput, context);
        case "InvalidEC2TagException":
        case "com.amazonaws.codedeploy#InvalidEC2TagException":
            throw await de_InvalidEC2TagExceptionRes(parsedOutput, context);
        case "InvalidECSServiceException":
        case "com.amazonaws.codedeploy#InvalidECSServiceException":
            throw await de_InvalidECSServiceExceptionRes(parsedOutput, context);
        case "InvalidInputException":
        case "com.amazonaws.codedeploy#InvalidInputException":
            throw await de_InvalidInputExceptionRes(parsedOutput, context);
        case "InvalidLoadBalancerInfoException":
        case "com.amazonaws.codedeploy#InvalidLoadBalancerInfoException":
            throw await de_InvalidLoadBalancerInfoExceptionRes(parsedOutput, context);
        case "InvalidOnPremisesTagCombinationException":
        case "com.amazonaws.codedeploy#InvalidOnPremisesTagCombinationException":
            throw await de_InvalidOnPremisesTagCombinationExceptionRes(parsedOutput, context);
        case "InvalidRoleException":
        case "com.amazonaws.codedeploy#InvalidRoleException":
            throw await de_InvalidRoleExceptionRes(parsedOutput, context);
        case "InvalidTagException":
        case "com.amazonaws.codedeploy#InvalidTagException":
            throw await de_InvalidTagExceptionRes(parsedOutput, context);
        case "InvalidTargetGroupPairException":
        case "com.amazonaws.codedeploy#InvalidTargetGroupPairException":
            throw await de_InvalidTargetGroupPairExceptionRes(parsedOutput, context);
        case "InvalidTrafficRoutingConfigurationException":
        case "com.amazonaws.codedeploy#InvalidTrafficRoutingConfigurationException":
            throw await de_InvalidTrafficRoutingConfigurationExceptionRes(parsedOutput, context);
        case "InvalidTriggerConfigException":
        case "com.amazonaws.codedeploy#InvalidTriggerConfigException":
            throw await de_InvalidTriggerConfigExceptionRes(parsedOutput, context);
        case "LifecycleHookLimitExceededException":
        case "com.amazonaws.codedeploy#LifecycleHookLimitExceededException":
            throw await de_LifecycleHookLimitExceededExceptionRes(parsedOutput, context);
        case "TagSetListLimitExceededException":
        case "com.amazonaws.codedeploy#TagSetListLimitExceededException":
            throw await de_TagSetListLimitExceededExceptionRes(parsedOutput, context);
        case "ThrottlingException":
        case "com.amazonaws.codedeploy#ThrottlingException":
            throw await de_ThrottlingExceptionRes(parsedOutput, context);
        case "TriggerTargetsLimitExceededException":
        case "com.amazonaws.codedeploy#TriggerTargetsLimitExceededException":
            throw await de_TriggerTargetsLimitExceededExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody,
                errorCode,
            });
    }
};
const de_AlarmsLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new AlarmsLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApplicationAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApplicationAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApplicationDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApplicationDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApplicationLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApplicationLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ApplicationNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ApplicationNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ArnNotSupportedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ArnNotSupportedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BatchLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BatchLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BucketNameFilterRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new BucketNameFilterRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentAlreadyCompletedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentAlreadyCompletedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentConfigAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentConfigAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentConfigDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentConfigDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentConfigInUseExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentConfigInUseException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentConfigLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentConfigLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentConfigNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentConfigNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentGroupAlreadyExistsExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentGroupAlreadyExistsException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentGroupDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentGroupDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentGroupLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentGroupLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentGroupNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentGroupNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentIsNotInReadyStateExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentIsNotInReadyStateException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentNotStartedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentNotStartedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentTargetDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentTargetDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentTargetIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentTargetIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DeploymentTargetListSizeExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DeploymentTargetListSizeExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DescriptionTooLongExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new DescriptionTooLongException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ECSServiceMappingLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ECSServiceMappingLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_GitHubAccountTokenDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new GitHubAccountTokenDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_GitHubAccountTokenNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new GitHubAccountTokenNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamArnRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new IamArnRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamSessionArnAlreadyRegisteredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new IamSessionArnAlreadyRegisteredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamUserArnAlreadyRegisteredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new IamUserArnAlreadyRegisteredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamUserArnRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new IamUserArnRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceIdRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceIdRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceNameAlreadyRegisteredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceNameAlreadyRegisteredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceNameRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceNameRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceNotRegisteredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InstanceNotRegisteredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidAlarmConfigExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidAlarmConfigException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidApplicationNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidApplicationNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidAutoRollbackConfigExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidAutoRollbackConfigException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidAutoScalingGroupExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidAutoScalingGroupException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidBlueGreenDeploymentConfigurationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidBlueGreenDeploymentConfigurationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidBucketNameFilterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidBucketNameFilterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidComputePlatformExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidComputePlatformException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeployedStateFilterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeployedStateFilterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentConfigNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentConfigNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentGroupNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentGroupNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentInstanceTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentInstanceTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentStyleExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentStyleException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentTargetIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentTargetIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDeploymentWaitTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidDeploymentWaitTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidEC2TagCombinationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidEC2TagCombinationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidEC2TagExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidEC2TagException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidECSServiceExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidECSServiceException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidExternalIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidExternalIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidFileExistsBehaviorExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidFileExistsBehaviorException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidGitHubAccountTokenExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidGitHubAccountTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidGitHubAccountTokenNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidGitHubAccountTokenNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidIamSessionArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidIamSessionArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidIamUserArnExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidIamUserArnException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidIgnoreApplicationStopFailuresValueExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidIgnoreApplicationStopFailuresValueException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidInputExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidInputException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidInstanceNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidInstanceNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidInstanceStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidInstanceStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidInstanceTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidInstanceTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidKeyPrefixFilterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidKeyPrefixFilterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLifecycleEventHookExecutionIdExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLifecycleEventHookExecutionIdException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLifecycleEventHookExecutionStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLifecycleEventHookExecutionStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidLoadBalancerInfoExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidLoadBalancerInfoException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidMinimumHealthyHostValueExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidMinimumHealthyHostValueException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidNextTokenExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidNextTokenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOnPremisesTagCombinationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidOnPremisesTagCombinationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOperationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidOperationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRegistrationStatusExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRegistrationStatusException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRevisionExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRevisionException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRoleExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidRoleException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSortByExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidSortByException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSortOrderExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidSortOrderException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagFilterExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagFilterException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTagsToAddExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTagsToAddException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetFilterNameExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetFilterNameException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetGroupPairExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetGroupPairException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTargetInstancesExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTargetInstancesException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTimeRangeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTimeRangeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTrafficRoutingConfigurationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTrafficRoutingConfigurationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidTriggerConfigExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidTriggerConfigException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidUpdateOutdatedInstancesOnlyValueExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new InvalidUpdateOutdatedInstancesOnlyValueException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LifecycleEventAlreadyCompletedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LifecycleEventAlreadyCompletedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_LifecycleHookLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new LifecycleHookLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MultipleIamArnsProvidedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new MultipleIamArnsProvidedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OperationNotSupportedExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new OperationNotSupportedException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ResourceArnRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ResourceArnRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ResourceValidationExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ResourceValidationException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RevisionDoesNotExistExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RevisionDoesNotExistException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RevisionRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RevisionRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_RoleRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new RoleRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagRequiredExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagRequiredException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TagSetListLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TagSetListLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ThrottlingExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new ThrottlingException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TriggerTargetsLimitExceededExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new TriggerTargetsLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnsupportedActionForDeploymentTypeExceptionRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = _json(body);
    const exception = new UnsupportedActionForDeploymentTypeException({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_ListDeploymentsInput = (input, context) => {
    return take(input, {
        applicationName: [],
        createTimeRange: (_) => se_TimeRange(_, context),
        deploymentGroupName: [],
        externalId: [],
        includeOnlyStatuses: _json,
        nextToken: [],
    });
};
const se_TimeRange = (input, context) => {
    return take(input, {
        end: (_) => Math.round(_.getTime() / 1000),
        start: (_) => Math.round(_.getTime() / 1000),
    });
};
const de_ApplicationInfo = (output, context) => {
    return take(output, {
        applicationId: __expectString,
        applicationName: __expectString,
        computePlatform: __expectString,
        createTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        gitHubAccountName: __expectString,
        linkedToGitHub: __expectBoolean,
    });
};
const de_ApplicationsInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ApplicationInfo(entry, context);
    });
    return retVal;
};
const de_BatchGetApplicationRevisionsOutput = (output, context) => {
    return take(output, {
        applicationName: __expectString,
        errorMessage: __expectString,
        revisions: (_) => de_RevisionInfoList(_, context),
    });
};
const de_BatchGetApplicationsOutput = (output, context) => {
    return take(output, {
        applicationsInfo: (_) => de_ApplicationsInfoList(_, context),
    });
};
const de_BatchGetDeploymentGroupsOutput = (output, context) => {
    return take(output, {
        deploymentGroupsInfo: (_) => de_DeploymentGroupInfoList(_, context),
        errorMessage: __expectString,
    });
};
const de_BatchGetDeploymentInstancesOutput = (output, context) => {
    return take(output, {
        errorMessage: __expectString,
        instancesSummary: (_) => de_InstanceSummaryList(_, context),
    });
};
const de_BatchGetDeploymentsOutput = (output, context) => {
    return take(output, {
        deploymentsInfo: (_) => de_DeploymentsInfoList(_, context),
    });
};
const de_BatchGetDeploymentTargetsOutput = (output, context) => {
    return take(output, {
        deploymentTargets: (_) => de_DeploymentTargetList(_, context),
    });
};
const de_BatchGetOnPremisesInstancesOutput = (output, context) => {
    return take(output, {
        instanceInfos: (_) => de_InstanceInfoList(_, context),
    });
};
const de_CloudFormationTarget = (output, context) => {
    return take(output, {
        deploymentId: __expectString,
        lastUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEvents: (_) => de_LifecycleEventList(_, context),
        resourceType: __expectString,
        status: __expectString,
        targetId: __expectString,
        targetVersionWeight: __limitedParseDouble,
    });
};
const de_DeploymentConfigInfo = (output, context) => {
    return take(output, {
        computePlatform: __expectString,
        createTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        deploymentConfigId: __expectString,
        deploymentConfigName: __expectString,
        minimumHealthyHosts: _json,
        trafficRoutingConfig: _json,
    });
};
const de_DeploymentGroupInfo = (output, context) => {
    return take(output, {
        alarmConfiguration: _json,
        applicationName: __expectString,
        autoRollbackConfiguration: _json,
        autoScalingGroups: _json,
        blueGreenDeploymentConfiguration: _json,
        computePlatform: __expectString,
        deploymentConfigName: __expectString,
        deploymentGroupId: __expectString,
        deploymentGroupName: __expectString,
        deploymentStyle: _json,
        ec2TagFilters: _json,
        ec2TagSet: _json,
        ecsServices: _json,
        lastAttemptedDeployment: (_) => de_LastDeploymentInfo(_, context),
        lastSuccessfulDeployment: (_) => de_LastDeploymentInfo(_, context),
        loadBalancerInfo: _json,
        onPremisesInstanceTagFilters: _json,
        onPremisesTagSet: _json,
        outdatedInstancesStrategy: __expectString,
        serviceRoleArn: __expectString,
        targetRevision: _json,
        triggerConfigurations: _json,
    });
};
const de_DeploymentGroupInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DeploymentGroupInfo(entry, context);
    });
    return retVal;
};
const de_DeploymentInfo = (output, context) => {
    return take(output, {
        additionalDeploymentStatusInfo: __expectString,
        applicationName: __expectString,
        autoRollbackConfiguration: _json,
        blueGreenDeploymentConfiguration: _json,
        completeTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        computePlatform: __expectString,
        createTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        creator: __expectString,
        deploymentConfigName: __expectString,
        deploymentGroupName: __expectString,
        deploymentId: __expectString,
        deploymentOverview: _json,
        deploymentStatusMessages: _json,
        deploymentStyle: _json,
        description: __expectString,
        errorInformation: _json,
        externalId: __expectString,
        fileExistsBehavior: __expectString,
        ignoreApplicationStopFailures: __expectBoolean,
        instanceTerminationWaitTimeStarted: __expectBoolean,
        loadBalancerInfo: _json,
        overrideAlarmConfiguration: _json,
        previousRevision: _json,
        relatedDeployments: _json,
        revision: _json,
        rollbackInfo: _json,
        startTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        status: __expectString,
        targetInstances: _json,
        updateOutdatedInstancesOnly: __expectBoolean,
    });
};
const de_DeploymentsInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DeploymentInfo(entry, context);
    });
    return retVal;
};
const de_DeploymentTarget = (output, context) => {
    return take(output, {
        cloudFormationTarget: (_) => de_CloudFormationTarget(_, context),
        deploymentTargetType: __expectString,
        ecsTarget: (_) => de_ECSTarget(_, context),
        instanceTarget: (_) => de_InstanceTarget(_, context),
        lambdaTarget: (_) => de_LambdaTarget(_, context),
    });
};
const de_DeploymentTargetList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DeploymentTarget(entry, context);
    });
    return retVal;
};
const de_ECSTarget = (output, context) => {
    return take(output, {
        deploymentId: __expectString,
        lastUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEvents: (_) => de_LifecycleEventList(_, context),
        status: __expectString,
        targetArn: __expectString,
        targetId: __expectString,
        taskSetsInfo: (_) => de_ECSTaskSetList(_, context),
    });
};
const de_ECSTaskSet = (output, context) => {
    return take(output, {
        desiredCount: __expectLong,
        identifer: __expectString,
        pendingCount: __expectLong,
        runningCount: __expectLong,
        status: __expectString,
        targetGroup: _json,
        taskSetLabel: __expectString,
        trafficWeight: __limitedParseDouble,
    });
};
const de_ECSTaskSetList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ECSTaskSet(entry, context);
    });
    return retVal;
};
const de_GenericRevisionInfo = (output, context) => {
    return take(output, {
        deploymentGroups: _json,
        description: __expectString,
        firstUsedTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lastUsedTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        registerTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
    });
};
const de_GetApplicationOutput = (output, context) => {
    return take(output, {
        application: (_) => de_ApplicationInfo(_, context),
    });
};
const de_GetApplicationRevisionOutput = (output, context) => {
    return take(output, {
        applicationName: __expectString,
        revision: _json,
        revisionInfo: (_) => de_GenericRevisionInfo(_, context),
    });
};
const de_GetDeploymentConfigOutput = (output, context) => {
    return take(output, {
        deploymentConfigInfo: (_) => de_DeploymentConfigInfo(_, context),
    });
};
const de_GetDeploymentGroupOutput = (output, context) => {
    return take(output, {
        deploymentGroupInfo: (_) => de_DeploymentGroupInfo(_, context),
    });
};
const de_GetDeploymentInstanceOutput = (output, context) => {
    return take(output, {
        instanceSummary: (_) => de_InstanceSummary(_, context),
    });
};
const de_GetDeploymentOutput = (output, context) => {
    return take(output, {
        deploymentInfo: (_) => de_DeploymentInfo(_, context),
    });
};
const de_GetDeploymentTargetOutput = (output, context) => {
    return take(output, {
        deploymentTarget: (_) => de_DeploymentTarget(_, context),
    });
};
const de_GetOnPremisesInstanceOutput = (output, context) => {
    return take(output, {
        instanceInfo: (_) => de_InstanceInfo(_, context),
    });
};
const de_InstanceInfo = (output, context) => {
    return take(output, {
        deregisterTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        iamSessionArn: __expectString,
        iamUserArn: __expectString,
        instanceArn: __expectString,
        instanceName: __expectString,
        registerTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        tags: _json,
    });
};
const de_InstanceInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_InstanceInfo(entry, context);
    });
    return retVal;
};
const de_InstanceSummary = (output, context) => {
    return take(output, {
        deploymentId: __expectString,
        instanceId: __expectString,
        instanceType: __expectString,
        lastUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEvents: (_) => de_LifecycleEventList(_, context),
        status: __expectString,
    });
};
const de_InstanceSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_InstanceSummary(entry, context);
    });
    return retVal;
};
const de_InstanceTarget = (output, context) => {
    return take(output, {
        deploymentId: __expectString,
        instanceLabel: __expectString,
        lastUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEvents: (_) => de_LifecycleEventList(_, context),
        status: __expectString,
        targetArn: __expectString,
        targetId: __expectString,
    });
};
const de_LambdaFunctionInfo = (output, context) => {
    return take(output, {
        currentVersion: __expectString,
        functionAlias: __expectString,
        functionName: __expectString,
        targetVersion: __expectString,
        targetVersionWeight: __limitedParseDouble,
    });
};
const de_LambdaTarget = (output, context) => {
    return take(output, {
        deploymentId: __expectString,
        lambdaFunctionInfo: (_) => de_LambdaFunctionInfo(_, context),
        lastUpdatedAt: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEvents: (_) => de_LifecycleEventList(_, context),
        status: __expectString,
        targetArn: __expectString,
        targetId: __expectString,
    });
};
const de_LastDeploymentInfo = (output, context) => {
    return take(output, {
        createTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        deploymentId: __expectString,
        endTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        status: __expectString,
    });
};
const de_LifecycleEvent = (output, context) => {
    return take(output, {
        diagnostics: _json,
        endTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        lifecycleEventName: __expectString,
        startTime: (_) => __expectNonNull(__parseEpochTimestamp(__expectNumber(_))),
        status: __expectString,
    });
};
const de_LifecycleEventList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_LifecycleEvent(entry, context);
    });
    return retVal;
};
const de_RevisionInfo = (output, context) => {
    return take(output, {
        genericRevisionInfo: (_) => de_GenericRevisionInfo(_, context),
        revisionLocation: _json,
    });
};
const de_RevisionInfoList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RevisionInfo(entry, context);
    });
    return retVal;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
function sharedHeaders(operation) {
    return {
        "content-type": "application/x-amz-json-1.1",
        "x-amz-target": `CodeDeploy_20141006.${operation}`,
    };
}
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
