import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { CodeDeployClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CodeDeployClient";
import { ListApplicationRevisionsInput, ListApplicationRevisionsOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListApplicationRevisionsCommand}.
 */
export interface ListApplicationRevisionsCommandInput extends ListApplicationRevisionsInput {
}
/**
 * @public
 *
 * The output of {@link ListApplicationRevisionsCommand}.
 */
export interface ListApplicationRevisionsCommandOutput extends ListApplicationRevisionsOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Lists information about revisions for an application.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CodeDeployClient, ListApplicationRevisionsCommand } from "@aws-sdk/client-codedeploy"; // ES Modules import
 * // const { CodeDeployClient, ListApplicationRevisionsCommand } = require("@aws-sdk/client-codedeploy"); // CommonJS import
 * const client = new CodeDeployClient(config);
 * const input = { // ListApplicationRevisionsInput
 *   applicationName: "STRING_VALUE", // required
 *   sortBy: "registerTime" || "firstUsedTime" || "lastUsedTime",
 *   sortOrder: "ascending" || "descending",
 *   s3Bucket: "STRING_VALUE",
 *   s3KeyPrefix: "STRING_VALUE",
 *   deployed: "include" || "exclude" || "ignore",
 *   nextToken: "STRING_VALUE",
 * };
 * const command = new ListApplicationRevisionsCommand(input);
 * const response = await client.send(command);
 * // { // ListApplicationRevisionsOutput
 * //   revisions: [ // RevisionLocationList
 * //     { // RevisionLocation
 * //       revisionType: "S3" || "GitHub" || "String" || "AppSpecContent",
 * //       s3Location: { // S3Location
 * //         bucket: "STRING_VALUE",
 * //         key: "STRING_VALUE",
 * //         bundleType: "tar" || "tgz" || "zip" || "YAML" || "JSON",
 * //         version: "STRING_VALUE",
 * //         eTag: "STRING_VALUE",
 * //       },
 * //       gitHubLocation: { // GitHubLocation
 * //         repository: "STRING_VALUE",
 * //         commitId: "STRING_VALUE",
 * //       },
 * //       string: { // RawString
 * //         content: "STRING_VALUE",
 * //         sha256: "STRING_VALUE",
 * //       },
 * //       appSpecContent: { // AppSpecContent
 * //         content: "STRING_VALUE",
 * //         sha256: "STRING_VALUE",
 * //       },
 * //     },
 * //   ],
 * //   nextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListApplicationRevisionsCommandInput - {@link ListApplicationRevisionsCommandInput}
 * @returns {@link ListApplicationRevisionsCommandOutput}
 * @see {@link ListApplicationRevisionsCommandInput} for command's `input` shape.
 * @see {@link ListApplicationRevisionsCommandOutput} for command's `response` shape.
 * @see {@link CodeDeployClientResolvedConfig | config} for CodeDeployClient's `config` shape.
 *
 * @throws {@link ApplicationDoesNotExistException} (client fault)
 *  <p>The application does not exist with the IAM user or Amazon Web Services account.</p>
 *
 * @throws {@link ApplicationNameRequiredException} (client fault)
 *  <p>The minimum number of required application names was not specified.</p>
 *
 * @throws {@link BucketNameFilterRequiredException} (client fault)
 *  <p>A bucket name is required, but was not provided.</p>
 *
 * @throws {@link InvalidApplicationNameException} (client fault)
 *  <p>The application name was specified in an invalid format.</p>
 *
 * @throws {@link InvalidBucketNameFilterException} (client fault)
 *  <p>The bucket name either doesn't exist or was specified in an invalid format.</p>
 *
 * @throws {@link InvalidDeployedStateFilterException} (client fault)
 *  <p>The deployed state filter was specified in an invalid format.</p>
 *
 * @throws {@link InvalidKeyPrefixFilterException} (client fault)
 *  <p>The specified key prefix filter was specified in an invalid format.</p>
 *
 * @throws {@link InvalidNextTokenException} (client fault)
 *  <p>The next token was specified in an invalid format.</p>
 *
 * @throws {@link InvalidSortByException} (client fault)
 *  <p>The column name to sort by is either not present or was specified in an invalid
 *             format.</p>
 *
 * @throws {@link InvalidSortOrderException} (client fault)
 *  <p>The sort order was specified in an invalid format.</p>
 *
 * @throws {@link CodeDeployServiceException}
 * <p>Base exception class for all service exceptions from CodeDeploy service.</p>
 *
 */
export declare class ListApplicationRevisionsCommand extends $Command<ListApplicationRevisionsCommandInput, ListApplicationRevisionsCommandOutput, CodeDeployClientResolvedConfig> {
    readonly input: ListApplicationRevisionsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ListApplicationRevisionsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CodeDeployClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListApplicationRevisionsCommandInput, ListApplicationRevisionsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
