from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

VTK_EDGE_OVERLAP:int
VTK_NODE_OVERLAP:int
VTK_NO_OVERLAP:int
VTK_PARTIAL_OVERLAP:int

class vtkAbstractGridConnectivity(vtkmodules.vtkCommonCore.vtkObject):
    number_of_ghost_layers:'getset_descriptor'
    number_of_grids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def GetGhostedCellGhostArray(self, gridID:int) -> 'vtkUnsignedCharArray': ...
    def GetGhostedGridCellData(self, gridID:int) -> 'vtkCellData': ...
    def GetGhostedGridPointData(self, gridID:int) -> 'vtkPointData': ...
    def GetGhostedPointGhostArray(self, gridID:int) -> 'vtkUnsignedCharArray': ...
    def GetGhostedPoints(self, gridID:int) -> 'vtkPoints': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfGrids(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractGridConnectivity': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractGridConnectivity': ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfGrids(self, N:int) -> None: ...

class vtkAttributeSmoothingFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class SmoothingStrategyType(int): ...
    class InterpolationWeightsType(int): ...
    ADJACENT_TO_BOUNDARY:'SmoothingStrategyType'
    ALL_BUT_BOUNDARY:'SmoothingStrategyType'
    ALL_POINTS:'SmoothingStrategyType'
    AVERAGE:'InterpolationWeightsType'
    DISTANCE:'InterpolationWeightsType'
    DISTANCE2:'InterpolationWeightsType'
    SMOOTHING_MASK:'SmoothingStrategyType'
    number_of_iterations:'getset_descriptor'
    number_of_iterations_max_value:'getset_descriptor'
    number_of_iterations_min_value:'getset_descriptor'
    relaxation_factor:'getset_descriptor'
    smoothing_mask:'getset_descriptor'
    smoothing_strategy:'getset_descriptor'
    weights_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddExcludedArray(self, excludedArray:str) -> None: ...
    def ClearExcludedArrays(self) -> None: ...
    def GetExcludedArray(self, i:int) -> str: ...
    def GetNumberOfExcludedArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIterations(self) -> int: ...
    def GetNumberOfIterationsMaxValue(self) -> int: ...
    def GetNumberOfIterationsMinValue(self) -> int: ...
    def GetRelaxationFactor(self) -> float: ...
    def GetRelaxationFactorMaxValue(self) -> float: ...
    def GetRelaxationFactorMinValue(self) -> float: ...
    def GetSmoothingMask(self) -> 'vtkUnsignedCharArray': ...
    def GetSmoothingStrategy(self) -> int: ...
    def GetSmoothingStrategyMaxValue(self) -> int: ...
    def GetSmoothingStrategyMinValue(self) -> int: ...
    def GetWeightsType(self) -> int: ...
    def GetWeightsTypeMaxValue(self) -> int: ...
    def GetWeightsTypeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAttributeSmoothingFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAttributeSmoothingFilter': ...
    def SetNumberOfIterations(self, _arg:int) -> None: ...
    def SetRelaxationFactor(self, _arg:float) -> None: ...
    def SetSmoothingMask(self, _arg:'vtkUnsignedCharArray') -> None: ...
    def SetSmoothingStrategy(self, _arg:int) -> None: ...
    def SetSmoothingStrategyToAdjacentToBoundary(self) -> None: ...
    def SetSmoothingStrategyToAllButBoundary(self) -> None: ...
    def SetSmoothingStrategyToAllPoints(self) -> None: ...
    def SetSmoothingStrategyToSmoothingMask(self) -> None: ...
    def SetWeightsType(self, _arg:int) -> None: ...
    def SetWeightsTypeToAverage(self) -> None: ...
    def SetWeightsTypeToDistance(self) -> None: ...
    def SetWeightsTypeToDistance2(self) -> None: ...

class vtkCompositeDataGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataGeometryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataGeometryFilter': ...

class vtkDataSetSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    allow_interpolation:'getset_descriptor'
    delegation:'getset_descriptor'
    fast_mode:'getset_descriptor'
    match_boundaries_ignoring_cell_order:'getset_descriptor'
    nonlinear_subdivision_level:'getset_descriptor'
    original_cell_ids_name:'getset_descriptor'
    original_point_ids_name:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    pass_through_point_ids:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllowInterpolationOff(self) -> None: ...
    def AllowInterpolationOn(self) -> None: ...
    def DataSetExecute(self, input:'vtkDataSet', output:'vtkPolyData') -> int: ...
    def DelegationOff(self) -> None: ...
    def DelegationOn(self) -> None: ...
    def FastModeOff(self) -> None: ...
    def FastModeOn(self) -> None: ...
    def GetAllowInterpolation(self) -> int: ...
    def GetDelegation(self) -> int: ...
    def GetFastMode(self) -> bool: ...
    def GetMatchBoundariesIgnoringCellOrder(self) -> int: ...
    def GetNonlinearSubdivisionLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetSurfaceFilter': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetSurfaceFilter': ...
    def SetAllowInterpolation(self, _arg:int) -> None: ...
    def SetDelegation(self, _arg:int) -> None: ...
    def SetFastMode(self, _arg:bool) -> None: ...
    def SetMatchBoundariesIgnoringCellOrder(self, _arg:int) -> None: ...
    def SetNonlinearSubdivisionLevel(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', ext:MutableSequence[int], wholeExt:MutableSequence[int]) -> int: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', ext32:Sequence[int], wholeExt32:Sequence[int]) -> int: ...
    @overload
    def UniformGridExecute(self, input:'vtkDataSet', output:'vtkPolyData', ext:MutableSequence[int], wholeExt:MutableSequence[int], extractface:MutableSequence[bool]) -> int: ...
    @overload
    def UniformGridExecute(self, input:'vtkDataSet', output:'vtkPolyData', ext32:Sequence[int], wholeExt32:Sequence[int], extractface:MutableSequence[bool]) -> int: ...
    def UnstructuredGridExecute(self, input:'vtkDataSet', output:'vtkPolyData') -> int: ...

class vtkDataSetRegionSurfaceFilter(vtkDataSetSurfaceFilter):
    interface_i_ds_name:'getset_descriptor'
    material_i_ds_name:'getset_descriptor'
    material_pi_ds_name:'getset_descriptor'
    material_properties_name:'getset_descriptor'
    region_array_name:'getset_descriptor'
    single_sided:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInterfaceIDsName(self) -> str: ...
    def GetMaterialIDsName(self) -> str: ...
    def GetMaterialPIDsName(self) -> str: ...
    def GetMaterialPropertiesName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRegionArrayName(self) -> str: ...
    def GetSingleSided(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetRegionSurfaceFilter': ...
    def RecordOrigCellId(self, newIndex:int, origId:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetRegionSurfaceFilter': ...
    def SetInterfaceIDsName(self, _arg:str) -> None: ...
    def SetMaterialIDsName(self, _arg:str) -> None: ...
    def SetMaterialPIDsName(self, _arg:str) -> None: ...
    def SetMaterialPropertiesName(self, _arg:str) -> None: ...
    def SetRegionArrayName(self, _arg:str) -> None: ...
    def SetSingleSided(self, _arg:bool) -> None: ...
    def UnstructuredGridExecute(self, input:'vtkDataSet', output:'vtkPolyData') -> int: ...

class vtkExplicitStructuredGridSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    original_cell_ids_name:'getset_descriptor'
    original_point_ids_name:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    pass_through_point_ids:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridSurfaceFilter': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridSurfaceFilter': ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...

class vtkFastGeomQuadStruct(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkFastGeomQuadStruct') -> None: ...

class vtkGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    cell_clipping:'getset_descriptor'
    cell_maximum:'getset_descriptor'
    cell_minimum:'getset_descriptor'
    delegation:'getset_descriptor'
    excluded_faces:'getset_descriptor'
    excluded_faces_connection:'getset_descriptor'
    excluded_faces_data:'getset_descriptor'
    extent:'getset_descriptor'
    extent_clipping:'getset_descriptor'
    fast_mode:'getset_descriptor'
    match_boundaries_ignoring_cell_order:'getset_descriptor'
    merging:'getset_descriptor'
    nonlinear_subdivision_level:'getset_descriptor'
    original_cell_ids_name:'getset_descriptor'
    original_point_ids_name:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    pass_through_point_ids:'getset_descriptor'
    piece_invariant:'getset_descriptor'
    point_clipping:'getset_descriptor'
    point_maximum:'getset_descriptor'
    point_minimum:'getset_descriptor'
    remove_ghost_interfaces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellClippingOff(self) -> None: ...
    def CellClippingOn(self) -> None: ...
    @overload
    def DataSetExecute(self, input:'vtkDataSet', output:'vtkPolyData', exc:'vtkPolyData') -> int: ...
    @overload
    def DataSetExecute(self, input:'vtkDataSet', output:'vtkPolyData') -> int: ...
    def DelegationOff(self) -> None: ...
    def DelegationOn(self) -> None: ...
    def ExtentClippingOff(self) -> None: ...
    def ExtentClippingOn(self) -> None: ...
    def FastModeOff(self) -> None: ...
    def FastModeOn(self) -> None: ...
    def GetCellClipping(self) -> bool: ...
    def GetCellMaximum(self) -> int: ...
    def GetCellMaximumMaxValue(self) -> int: ...
    def GetCellMaximumMinValue(self) -> int: ...
    def GetCellMinimum(self) -> int: ...
    def GetCellMinimumMaxValue(self) -> int: ...
    def GetCellMinimumMinValue(self) -> int: ...
    def GetDelegation(self) -> int: ...
    def GetExcludedFaces(self) -> 'vtkPolyData': ...
    def GetExtent(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetExtentClipping(self) -> bool: ...
    def GetFastMode(self) -> bool: ...
    def GetMatchBoundariesIgnoringCellOrder(self) -> int: ...
    def GetMerging(self) -> bool: ...
    def GetNonlinearSubdivisionLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def GetPointClipping(self) -> bool: ...
    def GetPointMaximum(self) -> int: ...
    def GetPointMaximumMaxValue(self) -> int: ...
    def GetPointMaximumMinValue(self) -> int: ...
    def GetPointMinimum(self) -> int: ...
    def GetPointMinimumMaxValue(self) -> int: ...
    def GetPointMinimumMinValue(self) -> int: ...
    def GetRemoveGhostInterfaces(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergingOff(self) -> None: ...
    def MergingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkGeometryFilter': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    def PointClippingOff(self) -> None: ...
    def PointClippingOn(self) -> None: ...
    @overload
    def PolyDataExecute(self, input:'vtkDataSet', output:'vtkPolyData', exc:'vtkPolyData') -> int: ...
    @overload
    def PolyDataExecute(self, __a:'vtkDataSet', __b:'vtkPolyData') -> int: ...
    def RemoveGhostInterfacesOff(self) -> None: ...
    def RemoveGhostInterfacesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGeometryFilter': ...
    def SetCellClipping(self, _arg:bool) -> None: ...
    def SetCellMaximum(self, _arg:int) -> None: ...
    def SetCellMinimum(self, _arg:int) -> None: ...
    def SetDelegation(self, _arg:int) -> None: ...
    def SetExcludedFacesConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetExcludedFacesData(self, __a:'vtkPolyData') -> None: ...
    @overload
    def SetExtent(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[float]) -> None: ...
    def SetExtentClipping(self, _arg:bool) -> None: ...
    def SetFastMode(self, _arg:bool) -> None: ...
    def SetMatchBoundariesIgnoringCellOrder(self, _arg:int) -> None: ...
    def SetMerging(self, _arg:bool) -> None: ...
    def SetNonlinearSubdivisionLevel(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, precision:int) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPieceInvariant(self, _arg:int) -> None: ...
    def SetPointClipping(self, _arg:bool) -> None: ...
    def SetPointMaximum(self, _arg:int) -> None: ...
    def SetPointMinimum(self, _arg:int) -> None: ...
    def SetRemoveGhostInterfaces(self, _arg:bool) -> None: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', inInfo:'vtkInformation', exc:'vtkPolyData', extractFace:MutableSequence[bool]=...) -> int: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', wholeExtent:MutableSequence[int], exc:'vtkPolyData', extractFace:MutableSequence[bool]=...) -> int: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', inInfo:'vtkInformation', extractFace:MutableSequence[bool]=...) -> int: ...
    @overload
    def StructuredExecute(self, input:'vtkDataSet', output:'vtkPolyData', wholeExt:MutableSequence[int], extractFace:MutableSequence[bool]=...) -> int: ...
    def UnstructuredGridExecute(self, input:'vtkDataSet', output:'vtkPolyData') -> int: ...

class vtkGeometryFilterHelper(object):
    class CellType(int): ...
    LINES:'CellType'
    NON_LINEAR_CELLS:'CellType'
    NUM_CELL_TYPES:'CellType'
    OTHER_LINEAR_CELLS:'CellType'
    POLYS:'CellType'
    STRIPS:'CellType'
    VERTS:'CellType'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkGeometryFilterHelper') -> None: ...
    @overload
    @staticmethod
    def CopyFilterParams(gf:'vtkGeometryFilter', dssf:'vtkDataSetSurfaceFilter') -> None: ...
    @overload
    @staticmethod
    def CopyFilterParams(dssf:'vtkDataSetSurfaceFilter', gf:'vtkGeometryFilter') -> None: ...
    def HasOnlyLines(self) -> bool: ...
    def HasOnlyPolys(self) -> bool: ...
    def HasOnlyStrips(self) -> bool: ...
    def HasOnlyVerts(self) -> bool: ...

class vtkHierarchicalDataSetGeometryFilter(vtkCompositeDataGeometryFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalDataSetGeometryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalDataSetGeometryFilter': ...

class vtkImageDataGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    extent:'getset_descriptor'
    output_triangles:'getset_descriptor'
    threshold_cells:'getset_descriptor'
    threshold_value:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputTriangles(self) -> int: ...
    def GetThresholdCells(self) -> int: ...
    def GetThresholdValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataGeometryFilter': ...
    def OutputTrianglesOff(self) -> None: ...
    def OutputTrianglesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataGeometryFilter': ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    def SetOutputTriangles(self, _arg:int) -> None: ...
    def SetThresholdCells(self, _arg:int) -> None: ...
    def SetThresholdValue(self, _arg:float) -> None: ...
    def ThresholdCellsOff(self) -> None: ...
    def ThresholdCellsOn(self) -> None: ...
    def ThresholdValueOff(self) -> None: ...
    def ThresholdValueOn(self) -> None: ...

class vtkImageDataToUniformGrid(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    reverse:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReverse(self) -> int: ...
    def GetReverseMaxValue(self) -> int: ...
    def GetReverseMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataToUniformGrid': ...
    def ReverseOff(self) -> None: ...
    def ReverseOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataToUniformGrid': ...
    def SetReverse(self, _arg:int) -> None: ...

class vtkLinearToQuadraticCellsFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearToQuadraticCellsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearToQuadraticCellsFilter': ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkMarkBoundaryFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    boundary_cells_name:'getset_descriptor'
    boundary_faces_name:'getset_descriptor'
    boundary_points_name:'getset_descriptor'
    generate_boundary_faces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateBoundaryFacesOff(self) -> None: ...
    def GenerateBoundaryFacesOn(self) -> None: ...
    def GetBoundaryCellsName(self) -> str: ...
    def GetBoundaryFacesName(self) -> str: ...
    def GetBoundaryPointsName(self) -> str: ...
    def GetGenerateBoundaryFaces(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarkBoundaryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarkBoundaryFilter': ...
    def SetBoundaryCellsName(self, _arg:str) -> None: ...
    def SetBoundaryFacesName(self, _arg:str) -> None: ...
    def SetBoundaryPointsName(self, _arg:str) -> None: ...
    def SetGenerateBoundaryFaces(self, _arg:bool) -> None: ...

class vtkProjectSphereFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    center:'getset_descriptor'
    keep_pole_points:'getset_descriptor'
    translate_z:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetKeepPolePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslateZ(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeepPolePointsOff(self) -> None: ...
    def KeepPolePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkProjectSphereFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProjectSphereFilter': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetKeepPolePoints(self, _arg:bool) -> None: ...
    def SetTranslateZ(self, _arg:bool) -> None: ...
    def TranslateZOff(self) -> None: ...
    def TranslateZOn(self) -> None: ...

class vtkRecoverGeometryWireframe(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    cell_ids_attribute:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellIdsAttribute(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRecoverGeometryWireframe': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRecoverGeometryWireframe': ...
    def SetCellIdsAttribute(self, _arg:str) -> None: ...

class vtkRectilinearGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridGeometryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridGeometryFilter': ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...

class vtkRectilinearGridPartitioner(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    duplicate_nodes:'getset_descriptor'
    number_of_ghost_layers:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridPartitioner': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridPartitioner': ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkStructuredAMRGridConnectivity(vtkAbstractGridConnectivity):
    balanced_refinement:'getset_descriptor'
    cell_centered:'getset_descriptor'
    node_centered:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def GetBalancedRefinement(self) -> bool: ...
    def GetCellCentered(self) -> bool: ...
    def GetGhostedExtent(self, gridID:int, ext:MutableSequence[int]) -> None: ...
    def GetNeighbor(self, gridID:int, nei:int) -> 'vtkStructuredAMRNeighbor': ...
    def GetNodeCentered(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNeighbors(self, gridID:int) -> int: ...
    def Initialize(self, NumberOfLevels:int, N:int, RefinementRatio:int=-1) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredAMRGridConnectivity': ...
    @overload
    def RegisterGrid(self, gridIdx:int, level:int, refinementRatio:int, extents:MutableSequence[int], nodesGhostArray:'vtkUnsignedCharArray', cellGhostArray:'vtkUnsignedCharArray', pointData:'vtkPointData', cellData:'vtkCellData', gridNodes:'vtkPoints') -> None: ...
    @overload
    def RegisterGrid(self, gridIdx:int, level:int, extents:MutableSequence[int], nodesGhostArray:'vtkUnsignedCharArray', cellGhostArray:'vtkUnsignedCharArray', pointData:'vtkPointData', cellData:'vtkCellData', gridNodes:'vtkPoints') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredAMRGridConnectivity': ...
    def SetBalancedRefinement(self, _arg:bool) -> None: ...
    def SetCellCentered(self, _arg:bool) -> None: ...
    def SetNodeCentered(self, _arg:bool) -> None: ...

class vtkStructuredNeighbor(object):
    class NeighborOrientation(int): ...
    HI:'NeighborOrientation'
    LO:'NeighborOrientation'
    ONE_TO_ONE:'NeighborOrientation'
    SUBSET_BOTH:'NeighborOrientation'
    SUBSET_HI:'NeighborOrientation'
    SUBSET_LO:'NeighborOrientation'
    SUPERSET:'NeighborOrientation'
    UNDEFINED:'NeighborOrientation'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, NeiID:int, overlap:MutableSequence[int]) -> None: ...
    @overload
    def __init__(self, NeiID:int, overlap:MutableSequence[int], orient:MutableSequence[int]) -> None: ...
    @overload
    def __init__(self, N:'vtkStructuredNeighbor') -> None: ...
    def ComputeSendAndReceiveExtent(self, gridRealExtent:MutableSequence[int], gridGhostedExtent:MutableSequence[int], neiRealExtent:MutableSequence[int], WholeExtent:MutableSequence[int], N:int) -> None: ...

class vtkStructuredAMRNeighbor(vtkStructuredNeighbor):
    class NeighborRelationship(int): ...
    CHILD:'NeighborRelationship'
    COARSE_TO_FINE_SIBLING:'NeighborRelationship'
    FINE_TO_COARSE_SIBLING:'NeighborRelationship'
    PARENT:'NeighborRelationship'
    PARTIALLY_OVERLAPPING_CHILD:'NeighborRelationship'
    PARTIALLY_OVERLAPPING_PARENT:'NeighborRelationship'
    SAME_LEVEL_SIBLING:'NeighborRelationship'
    UNDEFINED:'NeighborRelationship'
    relation_ship_string:'getset_descriptor'
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, gridLevel:int, neiID:int, neighborLevel:int, gridOverlap:MutableSequence[int], neiOverlap:MutableSequence[int], orient:MutableSequence[int], relationShip:int) -> None: ...
    @overload
    def __init__(self, N:'vtkStructuredAMRNeighbor') -> None: ...
    def ComputeSendAndReceiveExtent(self, gridRealExtent:MutableSequence[int], gridGhostedExtent:MutableSequence[int], neiRealExtent:MutableSequence[int], WholeExtent:MutableSequence[int], N:int) -> None: ...
    def GetReceiveExtentOnGrid(self, ng:int, gridExtent:MutableSequence[int], ext:MutableSequence[int]) -> None: ...
    def GetRelationShipString(self) -> str: ...

class vtkStructuredGridConnectivity(vtkAbstractGridConnectivity):
    data_dimension:'getset_descriptor'
    number_of_grids:'getset_descriptor'
    whole_extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ComputeNeighbors(self) -> None: ...
    def CreateGhostLayers(self, N:int=1) -> None: ...
    def FillGhostArrays(self, gridID:int, nodesArray:'vtkUnsignedCharArray', cellsArray:'vtkUnsignedCharArray') -> None: ...
    def GetDataDimension(self) -> int: ...
    def GetGhostedGridExtent(self, gridID:int, ext:MutableSequence[int]) -> None: ...
    def GetGridExtent(self, gridID:int, extent:MutableSequence[int]) -> None: ...
    def GetGridNeighbor(self, gridID:int, nei:int) -> 'vtkStructuredNeighbor': ...
    def GetNeighbors(self, gridID:int, extents:MutableSequence[int]) -> 'vtkIdList': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfNeighbors(self, gridID:int) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridConnectivity': ...
    def RegisterGrid(self, gridID:int, extents:MutableSequence[int], nodesGhostArray:'vtkUnsignedCharArray', cellGhostArray:'vtkUnsignedCharArray', pointData:'vtkPointData', cellData:'vtkCellData', gridNodes:'vtkPoints') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridConnectivity': ...
    def SetGhostedGridExtent(self, gridID:int, ext:MutableSequence[int]) -> None: ...
    def SetNumberOfGrids(self, N:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkStructuredGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    extent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridGeometryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridGeometryFilter': ...
    @overload
    def SetExtent(self, iMin:int, iMax:int, jMin:int, jMax:int, kMin:int, kMax:int) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[int]) -> None: ...

class vtkStructuredGridPartitioner(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    duplicate_nodes:'getset_descriptor'
    number_of_ghost_layers:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridPartitioner': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridPartitioner': ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkStructuredPointsGeometryFilter(vtkImageDataGeometryFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredPointsGeometryFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredPointsGeometryFilter': ...

class vtkUnstructuredGridGeometryFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridBaseAlgorithm):
    cell_clipping:'getset_descriptor'
    cell_maximum:'getset_descriptor'
    cell_minimum:'getset_descriptor'
    duplicate_ghost_cell_clipping:'getset_descriptor'
    extent:'getset_descriptor'
    extent_clipping:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    match_boundaries_ignoring_cell_order:'getset_descriptor'
    merging:'getset_descriptor'
    original_cell_ids_name:'getset_descriptor'
    original_point_ids_name:'getset_descriptor'
    pass_through_cell_ids:'getset_descriptor'
    pass_through_point_ids:'getset_descriptor'
    point_clipping:'getset_descriptor'
    point_maximum:'getset_descriptor'
    point_minimum:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CellClippingOff(self) -> None: ...
    def CellClippingOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def DuplicateGhostCellClippingOff(self) -> None: ...
    def DuplicateGhostCellClippingOn(self) -> None: ...
    def ExtentClippingOff(self) -> None: ...
    def ExtentClippingOn(self) -> None: ...
    def GetCellClipping(self) -> int: ...
    def GetCellMaximum(self) -> int: ...
    def GetCellMaximumMaxValue(self) -> int: ...
    def GetCellMaximumMinValue(self) -> int: ...
    def GetCellMinimum(self) -> int: ...
    def GetCellMinimumMaxValue(self) -> int: ...
    def GetCellMinimumMinValue(self) -> int: ...
    def GetDuplicateGhostCellClipping(self) -> int: ...
    def GetExtent(self) -> Pointer: ...
    def GetExtentClipping(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMatchBoundariesIgnoringCellOrder(self) -> int: ...
    def GetMerging(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginalCellIdsName(self) -> str: ...
    def GetOriginalPointIdsName(self) -> str: ...
    def GetPassThroughCellIds(self) -> int: ...
    def GetPassThroughPointIds(self) -> int: ...
    def GetPointClipping(self) -> int: ...
    def GetPointMaximum(self) -> int: ...
    def GetPointMaximumMaxValue(self) -> int: ...
    def GetPointMaximumMinValue(self) -> int: ...
    def GetPointMinimum(self) -> int: ...
    def GetPointMinimumMaxValue(self) -> int: ...
    def GetPointMinimumMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergingOff(self) -> None: ...
    def MergingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkUnstructuredGridGeometryFilter': ...
    def PassThroughCellIdsOff(self) -> None: ...
    def PassThroughCellIdsOn(self) -> None: ...
    def PassThroughPointIdsOff(self) -> None: ...
    def PassThroughPointIdsOn(self) -> None: ...
    def PointClippingOff(self) -> None: ...
    def PointClippingOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridGeometryFilter': ...
    def SetCellClipping(self, _arg:int) -> None: ...
    def SetCellMaximum(self, _arg:int) -> None: ...
    def SetCellMinimum(self, _arg:int) -> None: ...
    def SetDuplicateGhostCellClipping(self, _arg:int) -> None: ...
    @overload
    def SetExtent(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    @overload
    def SetExtent(self, extent:MutableSequence[float]) -> None: ...
    def SetExtentClipping(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetMatchBoundariesIgnoringCellOrder(self, _arg:int) -> None: ...
    def SetMerging(self, _arg:int) -> None: ...
    def SetOriginalCellIdsName(self, _arg:str) -> None: ...
    def SetOriginalPointIdsName(self, _arg:str) -> None: ...
    def SetPassThroughCellIds(self, _arg:int) -> None: ...
    def SetPassThroughPointIds(self, _arg:int) -> None: ...
    def SetPointClipping(self, _arg:int) -> None: ...
    def SetPointMaximum(self, _arg:int) -> None: ...
    def SetPointMinimum(self, _arg:int) -> None: ...

