# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MpesaDetailsTransactionType(str, enum.Enum):
    """
    Type of transaction
    """

    CUSTOMER_PAY_BILL_ONLINE = "CustomerPayBillOnline"
    CUSTOMER_BUY_GOODS_ONLINE = "CustomerBuyGoodsOnline"
    SALARY_PAYMENT = "SalaryPayment"
    BUSINESS_PAYMENT = "BusinessPayment"
    PROMOTION_PAYMENT = "PromotionPayment"

    def visit(
        self,
        customer_pay_bill_online: typing.Callable[[], T_Result],
        customer_buy_goods_online: typing.Callable[[], T_Result],
        salary_payment: typing.Callable[[], T_Result],
        business_payment: typing.Callable[[], T_Result],
        promotion_payment: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is MpesaDetailsTransactionType.CUSTOMER_PAY_BILL_ONLINE:
            return customer_pay_bill_online()
        if self is MpesaDetailsTransactionType.CUSTOMER_BUY_GOODS_ONLINE:
            return customer_buy_goods_online()
        if self is MpesaDetailsTransactionType.SALARY_PAYMENT:
            return salary_payment()
        if self is MpesaDetailsTransactionType.BUSINESS_PAYMENT:
            return business_payment()
        if self is MpesaDetailsTransactionType.PROMOTION_PAYMENT:
            return promotion_payment()
