# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .address import Address
from .swift_payment_method import SwiftPaymentMethod
from .tag import Tag


class SwiftDetails(pydantic.BaseModel):
    """
    Model for SWIFT payment method
    """

    method: SwiftPaymentMethod
    swift_code: typing.Optional[str] = pydantic.Field(
        alias="swiftCode",
        description='SWIFT code of the financial institution <span style="white-space: nowrap">`non-empty`</span> ',
    )
    account_number: typing.Optional[str] = pydantic.Field(
        alias="accountNumber", description='Account number <span style="white-space: nowrap">`non-empty`</span> '
    )
    account_type: typing.Optional[str] = pydantic.Field(
        alias="accountType", description="Account type. E.g. Checking, Savings etc."
    )
    bank_name: typing.Optional[str] = pydantic.Field(
        alias="bankName", description='Name of the bank <span style="white-space: nowrap">`non-empty`</span> '
    )
    name: typing.Optional[str] = pydantic.Field(description="Name of the account holder")
    bank_address: typing.Optional[Address] = pydantic.Field(alias="bankAddress")
    special_instructions: typing.Optional[str] = pydantic.Field(
        alias="specialInstructions", description="Special instructions if any"
    )
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
