# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PaymentMethod(str, enum.Enum):
    ACH = "ACH"
    CARD = "CARD"
    IBAN = "IBAN"
    UPI = "UPI"
    GENERIC_BANK_ACCOUNT = "GENERIC_BANK_ACCOUNT"
    MPESA = "MPESA"
    SWIFT = "SWIFT"
    WALLET = "WALLET"
    CHECK = "CHECK"

    def visit(
        self,
        ach: typing.Callable[[], T_Result],
        card: typing.Callable[[], T_Result],
        iban: typing.Callable[[], T_Result],
        upi: typing.Callable[[], T_Result],
        generic_bank_account: typing.Callable[[], T_Result],
        mpesa: typing.Callable[[], T_Result],
        swift: typing.Callable[[], T_Result],
        wallet: typing.Callable[[], T_Result],
        check: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is PaymentMethod.ACH:
            return ach()
        if self is PaymentMethod.CARD:
            return card()
        if self is PaymentMethod.IBAN:
            return iban()
        if self is PaymentMethod.UPI:
            return upi()
        if self is PaymentMethod.GENERIC_BANK_ACCOUNT:
            return generic_bank_account()
        if self is PaymentMethod.MPESA:
            return mpesa()
        if self is PaymentMethod.SWIFT:
            return swift()
        if self is PaymentMethod.WALLET:
            return wallet()
        if self is PaymentMethod.CHECK:
            return check()
