# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic

from ..core.datetime_utils import serialize_datetime
from .amount import Amount
from .transaction_limits_payment_method_limits import TransactionLimitsPaymentMethodLimits


class TransactionLimits(pydantic.BaseModel):
    """
    Model for transaction limits for a given user
    """

    maximum_daily_transaction_limit: typing.Optional[Amount] = pydantic.Field(alias="maximumDailyTransactionLimit")
    maximum_weekly_transaction_limit: typing.Optional[Amount] = pydantic.Field(alias="maximumWeeklyTransactionLimit")
    maximum_monthly_transaction_limit: typing.Optional[Amount] = pydantic.Field(alias="maximumMonthlyTransactionLimit")
    maximum_quarterly_transaction_limit: typing.Optional[Amount] = pydantic.Field(
        alias="maximumQuarterlyTransactionLimit"
    )
    maximum_transaction_limit: typing.Optional[Amount] = pydantic.Field(alias="maximumTransactionLimit")
    maximum_yearly_transaction_limit: typing.Optional[Amount] = pydantic.Field(alias="maximumYearlyTransactionLimit")
    payment_method_limits: typing.Optional[TransactionLimitsPaymentMethodLimits] = pydantic.Field(
        alias="paymentMethodLimits"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
